/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.protocol.saml;

import java.security.Key;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.function.Supplier;
import javax.xml.crypto.MarshalException;
import javax.xml.crypto.XMLStructure;
import javax.xml.crypto.dsig.keyinfo.KeyInfo;
import javax.xml.crypto.dsig.keyinfo.KeyName;
import javax.xml.crypto.dsig.keyinfo.X509Data;
import javax.xml.datatype.Duration;
import javax.xml.datatype.XMLGregorianCalendar;
import org.jboss.logging.Logger;
import org.keycloak.common.util.Time;
import org.keycloak.crypto.KeyUse;
import org.keycloak.crypto.KeyWrapper;
import org.keycloak.crypto.PublicKeysWrapper;
import org.keycloak.dom.saml.v2.metadata.EntityDescriptorType;
import org.keycloak.dom.saml.v2.metadata.IDPSSODescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyDescriptorType;
import org.keycloak.dom.saml.v2.metadata.KeyTypes;
import org.keycloak.dom.saml.v2.metadata.SPSSODescriptorType;
import org.keycloak.keys.PublicKeyLoader;
import org.keycloak.saml.processing.core.saml.v2.util.SAMLMetadataUtil;
import org.keycloak.saml.processing.core.util.XMLSignatureUtil;
import org.w3c.dom.Element;

public abstract class SamlAbstractMetadataPublicKeyLoader
implements PublicKeyLoader {
    private static final Logger logger = Logger.getLogger(SamlAbstractMetadataPublicKeyLoader.class);
    private final boolean forIdP;

    public SamlAbstractMetadataPublicKeyLoader(boolean forIdP) {
        this.forIdP = forIdP;
    }

    protected abstract String getKeys() throws Exception;

    public PublicKeysWrapper loadKeys() throws Exception {
        String descriptor = this.getKeys();
        List keyDescriptor = null;
        EntityDescriptorType entityType = SAMLMetadataUtil.parseEntityDescriptorType((String)descriptor);
        Long expirationTime = this.getExpirationTime(() -> ((EntityDescriptorType)entityType).getValidUntil(), () -> ((EntityDescriptorType)entityType).getCacheDuration());
        if (this.forIdP) {
            IDPSSODescriptorType idpDescriptor = SAMLMetadataUtil.locateIDPSSODescriptorType((EntityDescriptorType)entityType);
            List list = keyDescriptor = idpDescriptor != null ? idpDescriptor.getKeyDescriptor() : null;
            if (idpDescriptor != null && expirationTime == null) {
                expirationTime = this.getExpirationTime(() -> ((IDPSSODescriptorType)idpDescriptor).getValidUntil(), () -> ((IDPSSODescriptorType)idpDescriptor).getCacheDuration());
            }
        } else {
            SPSSODescriptorType spDescriptor = SAMLMetadataUtil.locateSPSSODescriptorType((EntityDescriptorType)entityType);
            List list = keyDescriptor = spDescriptor != null ? spDescriptor.getKeyDescriptor() : null;
            if (spDescriptor != null && expirationTime == null) {
                expirationTime = this.getExpirationTime(() -> ((SPSSODescriptorType)spDescriptor).getValidUntil(), () -> ((SPSSODescriptorType)spDescriptor).getCacheDuration());
            }
        }
        ArrayList<KeyWrapper> keys = new ArrayList<KeyWrapper>();
        if (keyDescriptor != null) {
            for (KeyDescriptorType keyDescriptorType : keyDescriptor) {
                Element keyInfoElement = keyDescriptorType.getKeyInfo();
                if (keyInfoElement == null) continue;
                KeyUse use = null;
                if (KeyTypes.SIGNING.equals((Object)keyDescriptorType.getUse())) {
                    use = KeyUse.SIG;
                } else if (KeyTypes.ENCRYPTION.equals((Object)keyDescriptorType.getUse())) {
                    use = KeyUse.ENC;
                }
                try {
                    KeyInfo keyInfo = XMLSignatureUtil.createKeyInfo((Element)keyInfoElement);
                    X509Certificate cert = null;
                    String kid = null;
                    for (XMLStructure xs : keyInfo.getContent()) {
                        if (kid == null && xs instanceof KeyName) {
                            kid = ((KeyName)xs).getName();
                        } else if (cert == null && xs instanceof X509Data) {
                            for (Object content : ((X509Data)xs).getContent()) {
                                if (!(content instanceof X509Certificate)) continue;
                                cert = (X509Certificate)content;
                                break;
                            }
                        }
                        if (kid == null || cert == null) continue;
                        break;
                    }
                    if (cert == null) continue;
                    logger.debugf("Adding certificate %s to the list of public kets", (Object)cert.getSubjectX500Principal());
                    keys.add(this.createKeyWrapper(cert, kid, use));
                }
                catch (MarshalException e) {
                    logger.debugf((Throwable)e, "Error parsing KeyInfo from metadata endpoint information", new Object[0]);
                }
            }
        }
        return new PublicKeysWrapper(keys, expirationTime);
    }

    private Long getExpirationTime(Supplier<XMLGregorianCalendar> validUntil, Supplier<Duration> cacheDuration) {
        XMLGregorianCalendar validUntilValue;
        Long exp = null;
        Duration cacheDurationValue = cacheDuration.get();
        if (cacheDurationValue != null) {
            long now = Time.currentTimeMillis();
            exp = now + cacheDurationValue.getTimeInMillis(new Date(now));
        }
        if ((validUntilValue = validUntil.get()) != null) {
            exp = exp == null ? validUntilValue.toGregorianCalendar().getTime().getTime() : Math.min(exp, validUntilValue.toGregorianCalendar().getTime().getTime());
        }
        return exp;
    }

    private KeyWrapper createKeyWrapper(X509Certificate cert, String kid, KeyUse use) {
        KeyWrapper key = new KeyWrapper();
        key.setKid(kid != null ? kid : cert.getSubjectX500Principal().getName());
        key.setAlgorithm(cert.getPublicKey().getAlgorithm());
        key.setUse(use);
        key.setType(cert.getPublicKey().getAlgorithm());
        key.setPublicKey((Key)cert.getPublicKey());
        key.setCertificate(cert);
        return key;
    }
}

