/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.userprofile;

import java.util.List;
import org.keycloak.events.EventBuilder;
import org.keycloak.models.UserModel;
import org.keycloak.userprofile.AttributeChangeListener;
import org.keycloak.userprofile.UserProfile;

public class EventAuditingAttributeChangeListener
implements AttributeChangeListener {
    private EventBuilder event;
    private UserProfile profile;

    public EventAuditingAttributeChangeListener(UserProfile profile, EventBuilder event) {
        this.profile = profile;
        this.event = event;
    }

    public void onChange(String attributeName, UserModel userModel, List<String> oldValue) {
        if (attributeName.equals("firstName")) {
            this.event.detail("previous_first_name", oldValue).detail("updated_first_name", userModel.getFirstName());
        } else if (attributeName.equals("lastName")) {
            this.event.detail("previous_last_name", oldValue).detail("updated_last_name", userModel.getLastName());
        } else if (attributeName.equals("email")) {
            this.event.detail("previous_email", oldValue).detail("updated_email", userModel.getEmail());
        } else {
            this.event.detail("previous_" + attributeName, oldValue).detail("updated_" + attributeName, userModel.getAttributeStream(attributeName));
        }
    }
}

