/*
 * Decompiled with CFR 0.152.
 */
package io.undertow.server.handlers.resource;

import io.undertow.UndertowLogger;
import io.undertow.predicate.Predicate;
import io.undertow.predicate.Predicates;
import io.undertow.server.HandlerWrapper;
import io.undertow.server.HttpHandler;
import io.undertow.server.HttpServerExchange;
import io.undertow.server.handlers.ResponseCodeHandler;
import io.undertow.server.handlers.builder.HandlerBuilder;
import io.undertow.server.handlers.resource.DefaultResourceSupplier;
import io.undertow.server.handlers.resource.DirectoryUtils;
import io.undertow.server.handlers.resource.PathResourceManager;
import io.undertow.server.handlers.resource.RangeAwareResource;
import io.undertow.server.handlers.resource.Resource;
import io.undertow.server.handlers.resource.ResourceManager;
import io.undertow.server.handlers.resource.ResourceSupplier;
import io.undertow.util.ByteRange;
import io.undertow.util.CanonicalPathUtils;
import io.undertow.util.DateUtils;
import io.undertow.util.ETag;
import io.undertow.util.ETagUtils;
import io.undertow.util.MimeMappings;
import io.undertow.util.RedirectBuilder;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;

public class ResourceHandler
implements HttpHandler {
    private static final Set<String> KNOWN_METHODS = new HashSet<String>();
    private final List<String> welcomeFiles = new CopyOnWriteArrayList<String>(new String[]{"index.html", "index.htm", "default.html", "default.htm"});
    private volatile boolean directoryListingEnabled = false;
    private volatile boolean canonicalizePaths = true;
    private volatile MimeMappings mimeMappings = MimeMappings.DEFAULT;
    private volatile Predicate allowed = Predicates.truePredicate();
    private volatile ResourceSupplier resourceSupplier;
    private volatile ResourceManager resourceManager;
    private final HttpHandler next;

    public ResourceHandler(ResourceManager resourceSupplier) {
        this(resourceSupplier, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public ResourceHandler(ResourceManager resourceManager, HttpHandler next) {
        this.resourceSupplier = new DefaultResourceSupplier(resourceManager);
        this.resourceManager = resourceManager;
        this.next = next;
    }

    public ResourceHandler(ResourceSupplier resourceSupplier) {
        this(resourceSupplier, (HttpHandler)ResponseCodeHandler.HANDLE_404);
    }

    public ResourceHandler(ResourceSupplier resourceManager, HttpHandler next) {
        this.resourceSupplier = resourceManager;
        this.next = next;
    }

    @Deprecated
    public ResourceHandler() {
        this.next = ResponseCodeHandler.HANDLE_404;
    }

    @Override
    public void handleRequest(HttpServerExchange exchange) throws Exception {
        if (exchange.getRequestMethod().equals("GET") || exchange.getRequestMethod().equals("POST")) {
            this.serveResource(exchange, true);
        } else if (exchange.getRequestMethod().equals("HEAD")) {
            this.serveResource(exchange, false);
        } else {
            if (KNOWN_METHODS.contains(exchange.getRequestMethod())) {
                exchange.setStatusCode(405);
                exchange.addResponseHeader("Allow", String.join((CharSequence)", ", "GET", "HEAD", "POST"));
            } else {
                exchange.setStatusCode(501);
            }
            exchange.endExchange();
        }
    }

    private void serveResource(HttpServerExchange exchange, final boolean sendContent) throws Exception {
        if (DirectoryUtils.sendRequestedBlobs(exchange)) {
            return;
        }
        if (!this.allowed.resolve(exchange)) {
            exchange.setStatusCode(403);
            exchange.endExchange();
            return;
        }
        HttpHandler dispatchTask = new HttpHandler(){

            @Override
            public void handleRequest(HttpServerExchange exchange) throws Exception {
                Resource resource = null;
                try {
                    if (File.separatorChar == '/' || !exchange.getRelativePath().contains(File.separator)) {
                        resource = ResourceHandler.this.resourceSupplier.getResource(exchange, ResourceHandler.this.canonicalize(exchange.getRelativePath()));
                    }
                }
                catch (IOException e) {
                    ResourceHandler.this.clearCacheHeaders(exchange);
                    UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                    exchange.setStatusCode(500);
                    exchange.endExchange();
                    return;
                }
                if (resource == null) {
                    ResourceHandler.this.clearCacheHeaders(exchange);
                    ResourceHandler.this.next.handleRequest(exchange);
                    return;
                }
                if (resource.isDirectory()) {
                    Resource indexResource;
                    try {
                        indexResource = ResourceHandler.this.getIndexFiles(exchange, ResourceHandler.this.resourceSupplier, resource.getPath(), ResourceHandler.this.welcomeFiles);
                    }
                    catch (IOException e) {
                        UndertowLogger.REQUEST_IO_LOGGER.ioException(e);
                        exchange.setStatusCode(500);
                        exchange.endExchange();
                        return;
                    }
                    if (indexResource == null) {
                        if (ResourceHandler.this.directoryListingEnabled) {
                            DirectoryUtils.renderDirectoryListing(exchange, resource);
                            return;
                        }
                        exchange.setStatusCode(403);
                        exchange.endExchange();
                        return;
                    }
                    if (!exchange.getRequestPath().endsWith("/")) {
                        exchange.setStatusCode(302);
                        exchange.setResponseHeader("Location", RedirectBuilder.redirect(exchange, exchange.getRelativePath() + "/", true));
                        exchange.endExchange();
                        return;
                    }
                    resource = indexResource;
                } else if (exchange.getRelativePath().endsWith("/")) {
                    exchange.setStatusCode(404);
                    exchange.endExchange();
                    return;
                }
                ETag etag = resource.getETag();
                Date lastModified = resource.getLastModified();
                if (!ETagUtils.handleIfMatch(exchange, etag, false) || !DateUtils.handleIfUnmodifiedSince(exchange, lastModified)) {
                    exchange.setStatusCode(412);
                    exchange.endExchange();
                    return;
                }
                if (!ETagUtils.handleIfNoneMatch(exchange, etag, true) || !DateUtils.handleIfModifiedSince(exchange, lastModified)) {
                    exchange.setStatusCode(304);
                    exchange.endExchange();
                    return;
                }
                Long contentLength = resource.getContentLength();
                if (contentLength != null && !exchange.containsResponseHeader("Transfer-Encoding")) {
                    exchange.setResponseContentLength(contentLength);
                }
                ByteRange.RangeResponseResult rangeResponse = null;
                long start = -1L;
                long end = -1L;
                if (resource instanceof RangeAwareResource && ((RangeAwareResource)resource).isRangeSupported() && contentLength != null) {
                    exchange.setResponseHeader("Accept-Ranges", "bytes");
                    ByteRange range = ByteRange.parse(exchange.getRequestHeader("Range"));
                    if (range != null && range.getRanges() == 1 && resource.getContentLength() != null && (rangeResponse = range.getResponseResult(resource.getContentLength(), exchange.getRequestHeader("If-Range"), resource.getLastModified(), resource.getETag() == null ? null : resource.getETag().getTag())) != null) {
                        start = rangeResponse.getStart();
                        end = rangeResponse.getEnd();
                        exchange.setStatusCode(rangeResponse.getStatusCode());
                        exchange.setResponseHeader("Content-Range", rangeResponse.getContentRange());
                        long length = rangeResponse.getContentLength();
                        exchange.setResponseContentLength(length);
                        if (rangeResponse.getStatusCode() == 416) {
                            return;
                        }
                    }
                }
                if (!exchange.containsResponseHeader("Content-Type")) {
                    String contentType = resource.getContentType(ResourceHandler.this.mimeMappings);
                    if (contentType != null) {
                        exchange.setResponseHeader("Content-Type", contentType);
                    } else {
                        exchange.setResponseHeader("Content-Type", "application/octet-stream");
                    }
                }
                if (lastModified != null) {
                    exchange.setResponseHeader("Last-Modified", resource.getLastModifiedString());
                }
                if (etag != null) {
                    exchange.setResponseHeader("ETag", etag.toString());
                }
                if (!sendContent) {
                    exchange.endExchange();
                } else if (rangeResponse != null) {
                    ((RangeAwareResource)resource).serveRangeAsync(exchange.getOutputChannel(), exchange, start, end);
                } else {
                    resource.serveAsync(exchange.getOutputChannel(), exchange);
                }
            }
        };
        if (exchange.isInIoThread()) {
            exchange.dispatch(dispatchTask);
        } else {
            dispatchTask.handleRequest(exchange);
        }
    }

    private void clearCacheHeaders(HttpServerExchange exchange) {
        exchange.removeResponseHeader("Cache-Control");
        exchange.removeResponseHeader("Expires");
    }

    private Resource getIndexFiles(HttpServerExchange exchange, ResourceSupplier resourceManager, String base, List<String> possible) throws IOException {
        Object realBase = base.endsWith("/") ? base : base + "/";
        for (String possibility : possible) {
            Resource index = resourceManager.getResource(exchange, this.canonicalize((String)realBase + possibility));
            if (index == null) continue;
            return index;
        }
        return null;
    }

    private String canonicalize(String s) {
        if (this.canonicalizePaths) {
            return CanonicalPathUtils.canonicalize(s);
        }
        return s;
    }

    public boolean isDirectoryListingEnabled() {
        return this.directoryListingEnabled;
    }

    public ResourceHandler setDirectoryListingEnabled(boolean directoryListingEnabled) {
        this.directoryListingEnabled = directoryListingEnabled;
        return this;
    }

    public ResourceHandler addWelcomeFiles(String ... files) {
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public ResourceHandler setWelcomeFiles(String ... files) {
        this.welcomeFiles.clear();
        this.welcomeFiles.addAll(Arrays.asList(files));
        return this;
    }

    public MimeMappings getMimeMappings() {
        return this.mimeMappings;
    }

    public ResourceHandler setMimeMappings(MimeMappings mimeMappings) {
        this.mimeMappings = mimeMappings;
        return this;
    }

    public Predicate getAllowed() {
        return this.allowed;
    }

    public ResourceHandler setAllowed(Predicate allowed) {
        this.allowed = allowed;
        return this;
    }

    public ResourceSupplier getResourceSupplier() {
        return this.resourceSupplier;
    }

    public ResourceHandler setResourceSupplier(ResourceSupplier resourceSupplier) {
        this.resourceSupplier = resourceSupplier;
        this.resourceManager = null;
        return this;
    }

    public ResourceManager getResourceManager() {
        return this.resourceManager;
    }

    public ResourceHandler setResourceManager(ResourceManager resourceManager) {
        this.resourceManager = resourceManager;
        this.resourceSupplier = new DefaultResourceSupplier(resourceManager);
        return this;
    }

    public boolean isCanonicalizePaths() {
        return this.canonicalizePaths;
    }

    public void setCanonicalizePaths(boolean canonicalizePaths) {
        this.canonicalizePaths = canonicalizePaths;
    }

    static {
        KNOWN_METHODS.add("OPTIONS");
        KNOWN_METHODS.add("GET");
        KNOWN_METHODS.add("HEAD");
        KNOWN_METHODS.add("POST");
        KNOWN_METHODS.add("PUT");
        KNOWN_METHODS.add("DELETE");
        KNOWN_METHODS.add("TRACE");
        KNOWN_METHODS.add("CONNECT");
    }

    private static class Wrapper
    implements HandlerWrapper {
        private final String location;
        private final boolean allowDirectoryListing;

        private Wrapper(String location, boolean allowDirectoryListing) {
            this.location = location;
            this.allowDirectoryListing = allowDirectoryListing;
        }

        @Override
        public HttpHandler wrap(HttpHandler handler) {
            PathResourceManager rm = new PathResourceManager(Paths.get(this.location, new String[0]), 1024L);
            ResourceHandler resourceHandler = new ResourceHandler(rm);
            resourceHandler.setDirectoryListingEnabled(this.allowDirectoryListing);
            return resourceHandler;
        }
    }

    public static class Builder
    implements HandlerBuilder {
        @Override
        public String name() {
            return "resource";
        }

        @Override
        public Map<String, Class<?>> parameters() {
            HashMap params = new HashMap();
            params.put("location", String.class);
            params.put("allow-listing", Boolean.TYPE);
            return params;
        }

        @Override
        public Set<String> requiredParameters() {
            return Collections.singleton("location");
        }

        @Override
        public String defaultParameter() {
            return "location";
        }

        @Override
        public HandlerWrapper build(Map<String, Object> config) {
            return new Wrapper((String)config.get("location"), (Boolean)config.get("allow-listing"));
        }
    }
}

