/*
 * Decompiled with CFR 0.152.
 */
package org.hibernate.community.dialect.lock.internal;

import jakarta.persistence.Timeout;
import java.sql.Connection;
import org.hibernate.HibernateException;
import org.hibernate.Timeouts;
import org.hibernate.dialect.RowLockStrategy;
import org.hibernate.dialect.lock.internal.Helper;
import org.hibernate.dialect.lock.spi.ConnectionLockTimeoutStrategy;
import org.hibernate.dialect.lock.spi.LockTimeoutType;
import org.hibernate.dialect.lock.spi.LockingSupport;
import org.hibernate.dialect.lock.spi.OuterJoinLockingType;
import org.hibernate.engine.spi.SessionFactoryImplementor;

public class GaussDBLockingSupport
implements LockingSupport,
LockingSupport.Metadata,
ConnectionLockTimeoutStrategy {
    public static final LockingSupport LOCKING_SUPPORT = new GaussDBLockingSupport();
    private final boolean supportsNoWait;
    private final boolean supportsSkipLocked;

    public GaussDBLockingSupport() {
        this(true, true);
    }

    public GaussDBLockingSupport(boolean supportsNoWait, boolean supportsSkipLocked) {
        this.supportsNoWait = supportsNoWait;
        this.supportsSkipLocked = supportsSkipLocked;
    }

    public LockingSupport.Metadata getMetadata() {
        return this;
    }

    public RowLockStrategy getWriteRowLockStrategy() {
        return RowLockStrategy.TABLE;
    }

    public OuterJoinLockingType getOuterJoinLockingType() {
        return OuterJoinLockingType.UNSUPPORTED;
    }

    public ConnectionLockTimeoutStrategy getConnectionLockTimeoutStrategy() {
        return this;
    }

    public ConnectionLockTimeoutStrategy.Level getSupportedLevel() {
        return ConnectionLockTimeoutStrategy.Level.SUPPORTED;
    }

    public LockTimeoutType getLockTimeoutType(Timeout timeout) {
        return switch (timeout.milliseconds()) {
            case 0 -> {
                if (this.supportsNoWait) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -2 -> {
                if (this.supportsSkipLocked) {
                    yield LockTimeoutType.QUERY;
                }
                yield LockTimeoutType.NONE;
            }
            case -1 -> LockTimeoutType.NONE;
            default -> LockTimeoutType.CONNECTION;
        };
    }

    public Timeout getLockTimeout(Connection connection, SessionFactoryImplementor factory) {
        return Helper.getLockTimeout((String)"select current_setting('lockwait_timeout')", resultSet -> {
            String value = resultSet.getString(1);
            if ("0".equals(value)) {
                return Timeouts.WAIT_FOREVER;
            }
            if (value.endsWith("min")) {
                int minute = GaussDBLockingSupport.getTimeout(value, 3);
                return Timeout.milliseconds((int)(minute * 60 * 1000));
            }
            if (value.endsWith("s")) {
                int seconds = GaussDBLockingSupport.getTimeout(value, 1);
                return Timeout.seconds((int)seconds);
            }
            int milliseconds = GaussDBLockingSupport.getTimeout(value, 2);
            return Timeout.milliseconds((int)milliseconds);
        }, (Connection)connection, (SessionFactoryImplementor)factory);
    }

    private static int getTimeout(String value, int unitLength) {
        int number;
        try {
            number = Integer.parseInt(value.substring(0, value.length() - unitLength));
        }
        catch (NumberFormatException e) {
            throw new RuntimeException(e);
        }
        return number;
    }

    public void setLockTimeout(Timeout timeout, Connection connection, SessionFactoryImplementor factory) {
        Helper.setLockTimeout((Timeout)timeout, t -> {
            int milliseconds = timeout.milliseconds();
            if (milliseconds == -2) {
                throw new HibernateException("Connection lock-timeout does not accept skip-locked");
            }
            if (milliseconds == 0) {
                throw new HibernateException("Connection lock-timeout does not accept no-wait");
            }
            return milliseconds == -1 ? 0 : milliseconds;
        }, (String)"set local lockwait_timeout = %s", (Connection)connection, (SessionFactoryImplementor)factory);
    }
}

