/*
 * Decompiled with CFR 0.152.
 */
package org.keycloak.saml.processing.core.parsers.saml.xmldsig;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.StartElement;
import org.keycloak.dom.xmlsec.w3.xmldsig.RSAKeyValueType;
import org.keycloak.saml.common.constants.GeneralConstants;
import org.keycloak.saml.common.exceptions.ParsingException;
import org.keycloak.saml.common.util.StaxParserUtil;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.AbstractStaxXmlDSigParser;
import org.keycloak.saml.processing.core.parsers.saml.xmldsig.XmlDSigQNames;

public class RsaKeyValueParser
extends AbstractStaxXmlDSigParser<RSAKeyValueType> {
    public static final RsaKeyValueParser INSTANCE = new RsaKeyValueParser();

    private RsaKeyValueParser() {
        super(XmlDSigQNames.RSA_KEY_VALUE);
    }

    public static RsaKeyValueParser getInstance() {
        return INSTANCE;
    }

    @Override
    protected RSAKeyValueType instantiateElement(XMLEventReader xmlEventReader, StartElement element) throws ParsingException {
        return new RSAKeyValueType();
    }

    @Override
    protected void processSubElement(XMLEventReader xmlEventReader, RSAKeyValueType target, XmlDSigQNames element, StartElement elementDetail) throws ParsingException {
        switch (element) {
            case MODULUS: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setModulus(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            case EXPONENT: {
                StaxParserUtil.advance(xmlEventReader);
                String text = StaxParserUtil.getElementText(xmlEventReader);
                target.setExponent(text.getBytes(GeneralConstants.SAML_CHARSET));
                break;
            }
            default: {
                throw LOGGER.parserUnknownTag(StaxParserUtil.getElementName(elementDetail), elementDetail.getLocation());
            }
        }
    }
}

