/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev.testing;

import io.quarkus.bootstrap.BootstrapAppModelFactory;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.app.QuarkusBootstrap;
import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.bootstrap.model.ApplicationModel;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.ModuleTestRunner;
import io.quarkus.deployment.dev.testing.TestClassResult;
import io.quarkus.deployment.dev.testing.TestConfig;
import io.quarkus.deployment.dev.testing.TestController;
import io.quarkus.deployment.dev.testing.TestListener;
import io.quarkus.deployment.dev.testing.TestResult;
import io.quarkus.deployment.dev.testing.TestRunListener;
import io.quarkus.deployment.dev.testing.TestRunResults;
import io.quarkus.deployment.dev.testing.TestState;
import io.quarkus.deployment.dev.testing.TestType;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.testing.TestWatchedFiles;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.jboss.logging.Logger;
import org.junit.platform.launcher.TestIdentifier;

public class TestSupport
implements TestController {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.test");
    private static final AtomicLong COUNTER = new AtomicLong();
    final CuratedApplication curatedApplication;
    final List<CompilationProvider> compilationProviders;
    final DevModeContext context;
    final List<ModuleTestRunner> moduleRunners = new ArrayList<ModuleTestRunner>();
    final List<TestListener> testListeners = new CopyOnWriteArrayList<TestListener>();
    final DevModeType devModeType;
    volatile QuarkusCompiler compiler;
    volatile boolean started;
    volatile TestRunResults testRunResults;
    volatile List<String> includeTags = Collections.emptyList();
    volatile List<String> excludeTags = Collections.emptyList();
    volatile Pattern include = null;
    volatile Pattern exclude = null;
    volatile String specificSelection = null;
    volatile List<String> includeEngines = Collections.emptyList();
    volatile List<String> excludeEngines = Collections.emptyList();
    volatile boolean displayTestOutput;
    volatile Boolean explicitDisplayTestOutput;
    volatile boolean brokenOnlyMode;
    volatile TestType testType = TestType.ALL;
    private boolean testsRunning = false;
    private boolean testsQueued = false;
    private ClassScanResult queuedChanges = null;
    private Throwable compileProblem;
    private volatile boolean firstRun = true;
    List<String> appPropertiesIncludeTags;
    List<String> appPropertiesExcludeTags;
    String appPropertiesIncludePattern;
    String appPropertiesExcludePattern;
    List<String> appPropertiesIncludeEngines;
    List<String> appPropertiesExcludeEngines;
    TestType appPropertiesTestType;
    private TestConfig config;
    private volatile boolean closed;

    public TestSupport(CuratedApplication curatedApplication, List<CompilationProvider> compilationProviders, DevModeContext context, DevModeType devModeType) {
        this.curatedApplication = curatedApplication;
        this.compilationProviders = compilationProviders;
        this.context = context;
        this.devModeType = devModeType;
    }

    public static Optional<TestSupport> instance() {
        if (RuntimeUpdatesProcessor.INSTANCE == null) {
            return Optional.empty();
        }
        return Optional.ofNullable(RuntimeUpdatesProcessor.INSTANCE.getTestSupport());
    }

    public synchronized boolean isRunning() {
        return this.testsRunning;
    }

    public List<TestListener> getTestListeners() {
        return this.testListeners;
    }

    public RunStatus getStatus() {
        long last = -1L;
        long runningTestRunId = this.getRunningTestRunId();
        TestRunResults tr = this.testRunResults;
        if (tr != null) {
            last = tr.getId();
        }
        return new RunStatus(last, runningTestRunId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        if (!this.started) {
            TestSupport testSupport = this;
            synchronized (testSupport) {
                if (!this.started) {
                    try {
                        this.started = true;
                        this.init();
                        for (TestListener i : this.testListeners) {
                            i.testsEnabled();
                        }
                        if (this.firstRun) {
                            this.runTests();
                        }
                        this.firstRun = false;
                    }
                    catch (Exception e) {
                        log.error((Object)"Failed to create compiler, runtime compilation will be unavailable", (Throwable)e);
                    }
                }
            }
        }
    }

    private static Pattern getCompiledPatternOrNull(Optional<String> patternStr) {
        return patternStr.isPresent() ? Pattern.compile(patternStr.get()) : null;
    }

    public void init() {
        if (this.moduleRunners.isEmpty()) {
            TestWatchedFiles.setWatchedFilesListener((paths, predicates) -> RuntimeUpdatesProcessor.INSTANCE.setWatchedFilePaths((Map<String, Boolean>)paths, (List<Map.Entry<Predicate<String>, Boolean>>)predicates, true));
            Pattern includeModulePattern = TestSupport.getCompiledPatternOrNull(this.config.includeModulePattern());
            Pattern excludeModulePattern = TestSupport.getCompiledPatternOrNull(this.config.excludeModulePattern());
            for (DevModeContext.ModuleInfo module : this.context.getAllModules()) {
                boolean mainModule;
                boolean bl = mainModule = module == this.context.getApplicationRoot();
                if (this.config.onlyTestApplicationModule() && !mainModule || (includeModulePattern != null ? !includeModulePattern.matcher(module.getArtifactKey().getGroupId() + ":" + module.getArtifactKey().getArtifactId()).matches() : excludeModulePattern != null && excludeModulePattern.matcher(module.getArtifactKey().getGroupId() + ":" + module.getArtifactKey().getArtifactId()).matches())) continue;
                try {
                    QuarkusClassLoader ctParentFirstCl;
                    Path projectDir = Path.of(module.getProjectDirectory(), new String[0]);
                    QuarkusBootstrap.Builder bootstrapConfig = this.curatedApplication.getQuarkusBootstrap().clonedBuilder().setMode(QuarkusBootstrap.Mode.TEST).setAssertionsEnabled(true).setDisableClasspathCache(false).setIsolateDeployment(true).setExistingModel(null).setBaseClassLoader(this.getClass().getClassLoader().getParent()).setTest(true).setAuxiliaryApplication(true).setHostApplicationIsTestOnly(this.devModeType == DevModeType.TEST_ONLY).setProjectRoot(projectDir).setApplicationRoot((PathCollection)this.getRootPaths(module, mainModule)).clearLocalArtifacts();
                    QuarkusBootstrap.Mode currentMode = this.curatedApplication.getQuarkusBootstrap().getMode();
                    if (QuarkusBootstrap.Mode.CONTINUOUS_TEST != currentMode && QuarkusBootstrap.Mode.TEST != currentMode) {
                        BootstrapAppModelFactory appModelFactory = this.curatedApplication.getQuarkusBootstrap().newAppModelFactory();
                        appModelFactory.setBootstrapAppModelResolver(null);
                        appModelFactory.setTest(true);
                        appModelFactory.setLocalArtifacts(Set.of());
                        if (!mainModule) {
                            appModelFactory.setAppArtifact(null);
                            appModelFactory.setProjectRoot(projectDir);
                        }
                        ApplicationModel testModel = appModelFactory.resolveAppModel().getApplicationModel();
                        bootstrapConfig.setExistingModel(testModel);
                        QuarkusClassLoader.Builder clBuilder = null;
                        Set currentParentFirst = this.curatedApplication.getApplicationModel().getParentFirst();
                        for (ResolvedDependency d : testModel.getDependencies()) {
                            if (!d.isClassLoaderParentFirst() || currentParentFirst.contains(d.getKey())) continue;
                            if (clBuilder == null) {
                                clBuilder = QuarkusClassLoader.builder((String)("Continuous Testing Parent-First" + this.curatedApplication.getClassLoaderNameSuffix()), (ClassLoader)this.getClass().getClassLoader().getParent(), (boolean)false);
                            }
                            clBuilder.addNormalPriorityElement(ClassPathElement.fromDependency((ResolvedDependency)d));
                        }
                        QuarkusClassLoader quarkusClassLoader = ctParentFirstCl = clBuilder == null ? null : clBuilder.build();
                        if (ctParentFirstCl != null) {
                            bootstrapConfig.setBaseClassLoader((ClassLoader)ctParentFirstCl);
                        }
                    } else {
                        ctParentFirstCl = null;
                        if (mainModule) {
                            bootstrapConfig.setExistingModel(this.curatedApplication.getApplicationModel());
                        }
                    }
                    for (ResolvedDependency i : this.curatedApplication.getApplicationModel().getDependencies()) {
                        if (!i.isClassLoaderParentFirst()) continue;
                        bootstrapConfig.addParentFirstArtifact(i.getKey());
                    }
                    final CuratedApplication testCuratedApplication = bootstrapConfig.build().bootstrap();
                    if (mainModule) {
                        this.compiler = new QuarkusCompiler(testCuratedApplication, this.compilationProviders, this.context);
                    }
                    ModuleTestRunner testRunner = new ModuleTestRunner(this, testCuratedApplication, module);
                    QuarkusClassLoader cl = (QuarkusClassLoader)this.getClass().getClassLoader();
                    cl.addCloseTask(new Runnable(){

                        @Override
                        public void run() {
                            try {
                                TestSupport.this.close();
                            }
                            finally {
                                testCuratedApplication.close();
                                if (ctParentFirstCl != null) {
                                    ctParentFirstCl.close();
                                }
                            }
                        }
                    });
                    this.moduleRunners.add(testRunner);
                }
                catch (Exception e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private PathList getRootPaths(DevModeContext.ModuleInfo module, boolean mainModule) {
        final PathList.Builder pathBuilder = PathList.builder();
        Consumer<Path> paths = new Consumer<Path>(){

            @Override
            public void accept(Path t) {
                if (!pathBuilder.contains(t)) {
                    if (!Files.exists(t, new LinkOption[0])) {
                        try {
                            Files.createDirectories(t, new FileAttribute[0]);
                        }
                        catch (IOException e) {
                            throw new UncheckedIOException(e);
                        }
                    }
                    pathBuilder.add(t);
                }
            }
        };
        module.getTest().ifPresent(test -> {
            paths.accept(Path.of(test.getClassesPath(), new String[0]));
            if (test.getResourcesOutputPath() != null) {
                paths.accept(Path.of(test.getResourcesOutputPath(), new String[0]));
            }
        });
        if (mainModule) {
            this.curatedApplication.getQuarkusBootstrap().getApplicationRoot().forEach(paths::accept);
        } else {
            paths.accept(Path.of(module.getMain().getClassesPath(), new String[0]));
        }
        return pathBuilder.build();
    }

    public synchronized void close() {
        this.closed = true;
        this.stop();
    }

    public synchronized void stop() {
        if (this.started) {
            this.started = false;
            for (TestListener i : this.testListeners) {
                i.testsDisabled();
            }
        }
        for (ModuleTestRunner runner : this.moduleRunners) {
            runner.abort();
        }
        TestWatchedFiles.setWatchedFilesListener((BiConsumer)null);
    }

    public void runTests() {
        this.runTests(null);
    }

    @Override
    public void runFailedTests() {
        this.runTests(null, true, false);
    }

    public void runTests(ClassScanResult classScanResult) {
        this.runTests(classScanResult, false, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(final ClassScanResult classScanResult, final boolean reRunFailures, boolean runningQueued) {
        if (this.compileProblem != null) {
            return;
        }
        if (!this.started) {
            return;
        }
        if (reRunFailures && this.testRunResults == null) {
            return;
        }
        if (reRunFailures && this.testRunResults.getCurrentFailing().isEmpty()) {
            log.error((Object)"Not re-running failed tests, as all tests passed");
            return;
        }
        TestSupport testSupport = this;
        synchronized (testSupport) {
            if (this.testsRunning && !runningQueued) {
                if (reRunFailures) {
                    log.error((Object)"Not re-running failed tests, as tests are already in progress.");
                    return;
                }
                if (this.testsQueued) {
                    if (this.queuedChanges != null) {
                        this.queuedChanges = ClassScanResult.merge(this.queuedChanges, classScanResult);
                    }
                } else {
                    this.testsQueued = true;
                    this.queuedChanges = classScanResult;
                }
                return;
            }
            this.testsRunning = true;
        }
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    try {
                        TestSupport.this.runInternal(classScanResult, reRunFailures);
                    }
                    finally {
                        boolean run = false;
                        ClassScanResult current = null;
                        TestSupport testSupport = TestSupport.this;
                        synchronized (testSupport) {
                            if (TestSupport.this.started) {
                                if (TestSupport.this.testsQueued) {
                                    TestSupport.this.testsQueued = false;
                                    run = true;
                                } else {
                                    TestSupport.this.testsRunning = false;
                                }
                                current = TestSupport.this.queuedChanges;
                                TestSupport.this.queuedChanges = null;
                            }
                        }
                        if (run) {
                            TestSupport.this.runTests(current, false, true);
                        }
                    }
                }
                catch (Throwable t) {
                    log.error((Object)"Internal error running tests", t);
                }
            }
        }, "Test runner thread");
        t.setDaemon(true);
        t.start();
    }

    void runInternal(ClassScanResult classScanResult, boolean reRunFailures) {
        TestRunResults testRunResults;
        long runId = COUNTER.incrementAndGet();
        this.handleApplicationPropertiesChange();
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        final ArrayList testRunListeners = new ArrayList();
        for (TestListener i : this.testListeners) {
            i.testRunStarted(testRunListeners::add);
        }
        long start = System.currentTimeMillis();
        final AtomicLong testCount = new AtomicLong();
        final ArrayList allResults = new ArrayList();
        for (ModuleTestRunner moduleTestRunner : this.moduleRunners) {
            runnables.add(moduleTestRunner.prepare(classScanResult, reRunFailures, runId, new TestRunListener(){

                @Override
                public void runStarted(long toRun) {
                    testCount.addAndGet(toRun);
                }

                @Override
                public void testComplete(TestResult result) {
                    for (TestRunListener i : testRunListeners) {
                        i.testComplete(result);
                    }
                }

                @Override
                public void runComplete(TestRunResults results) {
                    allResults.add(results);
                }

                @Override
                public void runAborted() {
                    for (TestRunListener i : testRunListeners) {
                        i.runAborted();
                    }
                }

                @Override
                public void testStarted(TestIdentifier testIdentifier, String className) {
                    for (TestRunListener i : testRunListeners) {
                        i.testStarted(testIdentifier, className);
                    }
                }
            }));
        }
        for (TestRunListener testRunListener : testRunListeners) {
            testRunListener.runStarted(testCount.get());
        }
        for (Runnable runnable : runnables) {
            try {
                runnable.run();
            }
            catch (Exception e) {
                log.error((Object)"Failed to run test module", (Throwable)e);
            }
        }
        HashMap<String, TestClassResult> aggregate = new HashMap<String, TestClassResult>();
        for (TestRunResults i : allResults) {
            aggregate.putAll(i.getResults());
        }
        this.testRunResults = testRunResults = new TestRunResults(runId, classScanResult, classScanResult == null, start, System.currentTimeMillis(), aggregate);
        if (!this.closed) {
            for (TestRunListener i : testRunListeners) {
                i.runComplete(testRunResults);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addListener(TestListener listener) {
        boolean run = false;
        TestSupport testSupport = this;
        synchronized (testSupport) {
            this.testListeners.add(listener);
            if (this.started) {
                run = true;
            }
        }
        listener.listenerRegistered(this);
        if (run) {
            listener.testsEnabled();
        }
    }

    private void handleApplicationPropertiesChange() {
        SmallRyeConfig updatedConfig = TestSupport.getMinimalConfig();
        List includeTags = this.getTrimmedListFromConfig(updatedConfig, "quarkus.test.include-tags").orElse(null);
        List excludeTags = this.getTrimmedListFromConfig(updatedConfig, "quarkus.test.exclude-tags").orElse(null);
        String includePattern = updatedConfig.getOptionalValue("quarkus.test.include-pattern", String.class).orElse(null);
        String excludePattern = updatedConfig.getOptionalValue("quarkus.test.exclude-pattern", String.class).orElse(null);
        List includeEngines = this.getTrimmedListFromConfig(updatedConfig, "quarkus.test.include-engines").orElse(null);
        List excludeEngines = this.getTrimmedListFromConfig(updatedConfig, "quarkus.test.exclude-engines").orElse(null);
        TestType testType = updatedConfig.getOptionalValue("quarkus.test.type", TestType.class).orElse(TestType.ALL);
        if (!this.firstRun) {
            if (!Objects.equals(includeTags, this.appPropertiesIncludeTags)) {
                this.includeTags = Objects.requireNonNullElse(includeTags, Collections.emptyList());
            }
            if (!Objects.equals(excludeTags, this.appPropertiesExcludeTags)) {
                this.excludeTags = Objects.requireNonNullElse(excludeTags, Collections.emptyList());
            }
            if (!Objects.equals(includePattern, this.appPropertiesIncludePattern)) {
                this.include = includePattern == null ? null : Pattern.compile(includePattern);
            }
            if (!Objects.equals(excludePattern, this.appPropertiesExcludePattern)) {
                this.exclude = excludePattern == null ? null : Pattern.compile(excludePattern);
            }
            if (!Objects.equals(includeEngines, this.appPropertiesIncludeEngines)) {
                this.includeEngines = Objects.requireNonNullElse(includeEngines, Collections.emptyList());
            }
            if (!Objects.equals(excludeEngines, this.appPropertiesExcludeEngines)) {
                this.excludeEngines = Objects.requireNonNullElse(excludeEngines, Collections.emptyList());
            }
            if (!Objects.equals((Object)testType, (Object)this.appPropertiesTestType)) {
                this.testType = testType;
            }
        }
        this.appPropertiesIncludeTags = includeTags;
        this.appPropertiesExcludeTags = excludeTags;
        this.appPropertiesIncludePattern = includePattern;
        this.appPropertiesExcludePattern = excludePattern;
        this.appPropertiesIncludeEngines = includeEngines;
        this.appPropertiesExcludeEngines = excludeEngines;
        this.appPropertiesTestType = testType;
    }

    private static SmallRyeConfig getMinimalConfig() {
        return new SmallRyeConfigBuilder().addDefaultSources().build();
    }

    private Optional<List<String>> getTrimmedListFromConfig(SmallRyeConfig updatedConfig, String property) {
        return updatedConfig.getOptionalValue(property, String.class).map(t -> Arrays.stream(t.split(",")).map(String::trim).collect(Collectors.toList()));
    }

    public boolean isStarted() {
        return this.started;
    }

    public QuarkusCompiler getCompiler() {
        return this.compiler;
    }

    public TestRunResults getTestRunResults() {
        return this.testRunResults;
    }

    public TestRunResults getResults() {
        return this.testRunResults;
    }

    public synchronized long getRunningTestRunId() {
        if (this.testsRunning) {
            return COUNTER.get();
        }
        return -1L;
    }

    public void setTags(List<String> includeTags, List<String> excludeTags) {
        this.includeTags = includeTags;
        this.excludeTags = excludeTags;
    }

    public void setPatterns(String include, String exclude) {
        this.include = include == null ? null : Pattern.compile(include);
        this.exclude = exclude == null ? null : Pattern.compile(exclude);
    }

    public void setSpecificSelection(String specificSelection) {
        this.specificSelection = specificSelection;
    }

    public void setEngines(List<String> includeEngines, List<String> excludeEngines) {
        this.includeEngines = includeEngines;
        this.excludeEngines = excludeEngines;
    }

    public TestSupport setConfiguredDisplayTestOutput(boolean displayTestOutput) {
        if (this.explicitDisplayTestOutput != null) {
            this.displayTestOutput = displayTestOutput;
        }
        this.displayTestOutput = displayTestOutput;
        return this;
    }

    public TestSupport setTestType(TestType testType) {
        this.testType = testType;
        return this;
    }

    @Override
    public TestState currentState() {
        return TestState.merge(this.moduleRunners.stream().map(ModuleTestRunner::getTestState).collect(Collectors.toList()));
    }

    @Override
    public void runAllTests() {
        this.runTests();
    }

    @Override
    public void setDisplayTestOutput(boolean displayTestOutput) {
        this.explicitDisplayTestOutput = displayTestOutput;
        this.displayTestOutput = displayTestOutput;
    }

    @Override
    public boolean toggleBrokenOnlyMode() {
        boolean bl = this.brokenOnlyMode = !this.brokenOnlyMode;
        if (this.brokenOnlyMode) {
            log.info((Object)"Broken only mode enabled");
        } else {
            log.info((Object)"Broken only mode disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setBrokenOnly(this.brokenOnlyMode);
        }
        return this.brokenOnlyMode;
    }

    @Override
    public boolean toggleTestOutput() {
        this.setDisplayTestOutput(!this.displayTestOutput);
        if (this.displayTestOutput) {
            log.info((Object)"Test output enabled");
        } else {
            log.info((Object)"Test output disabled");
        }
        for (TestListener i : this.testListeners) {
            i.setTestOutput(this.displayTestOutput);
        }
        return this.displayTestOutput;
    }

    @Override
    public boolean toggleInstrumentation() {
        boolean ibr = RuntimeUpdatesProcessor.INSTANCE.toggleInstrumentation();
        for (TestListener i : this.testListeners) {
            i.setInstrumentationBasedReload(ibr);
        }
        return ibr;
    }

    @Override
    public boolean toggleLiveReloadEnabled() {
        boolean lr = RuntimeUpdatesProcessor.INSTANCE.toggleLiveReloadEnabled();
        for (TestListener i : this.testListeners) {
            i.setLiveReloadEnabled(lr);
        }
        return lr;
    }

    @Override
    public void printFullResults() {
        if (this.currentState().getFailingClasses().isEmpty()) {
            log.info((Object)"All tests passed, no output to display");
        }
        for (TestClassResult i : this.currentState().getFailingClasses()) {
            for (TestResult failed : i.getFailing()) {
                log.error((Object)("Test " + failed.getDisplayName() + " failed " + String.valueOf(failed.getTestExecutionResult().getStatus()) + "\n"), (Throwable)failed.getTestExecutionResult().getThrowable().get());
            }
        }
    }

    @Override
    public boolean isBrokenOnlyMode() {
        return this.brokenOnlyMode;
    }

    @Override
    public boolean isDisplayTestOutput() {
        return this.displayTestOutput;
    }

    @Override
    public boolean isInstrumentationEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.instrumentationEnabled();
    }

    @Override
    public boolean isLiveReloadEnabled() {
        return RuntimeUpdatesProcessor.INSTANCE.isLiveReloadEnabled();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testCompileFailed(Throwable e) {
        TestSupport testSupport = this;
        synchronized (testSupport) {
            this.compileProblem = e;
        }
        for (TestListener i : this.testListeners) {
            i.testCompileFailed(e.getMessage());
        }
    }

    public synchronized void testCompileSucceeded() {
        this.compileProblem = null;
        for (TestListener i : this.testListeners) {
            i.testCompileSucceeded();
        }
    }

    public void setConfig(TestConfig config) {
        this.config = config;
    }

    public TestConfig getConfig() {
        return this.config;
    }

    public static class RunStatus {
        final long lastRun;
        final long running;

        public RunStatus(long lastRun, long running) {
            this.lastRun = lastRun;
            this.running = running;
        }

        public long getLastRun() {
            return this.lastRun;
        }

        public long getRunning() {
            return this.running;
        }
    }
}

