/* [config]
 * expect_result: fail
 * glsl_version: 1.30
 * [end config]
 *
 * Declare a noperspective interpolation ivec2 array.
 *
 * The OpenGL Shading Language 1.30 spec states:
 *
 *    "4.3.6 Outputs
 *    ...
 *        If a vertex output is a signed or unsigned integer or
 *        integer vector, then it must be qualified with the
 *        interpolation qualifier flat.
 *    ...
 *        The type and presence of the interpolation qualifiers and
 *        storage qualifiers and invariant qualifiers of variables
 *        with the same name declared in linked vertex and fragments
 *        shaders must match, otherwise the link command will fail."
 *
 * From this, it can be followed that if a fragment input is a signed
 * or unsigned integer or derived type, it must be qualified with the
 * interpolation qualifier flat.
 */

#version 130

noperspective in ivec2 u[4];
out vec4 color;

void main()
{
	color = vec4(u[3].xyxy);
}
