/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.asn1.translator;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.model.Asn1Container;
import de.rub.nds.asn1.parser.IntermediateAsn1Field;
import de.rub.nds.asn1.translator.Context;
import de.rub.nds.asn1.translator.ContextComponent;
import de.rub.nds.asn1.translator.ContextComponentOption;
import de.rub.nds.asn1.translator.ContextRegister;
import de.rub.nds.asn1.translator.fieldtranslators.Asn1AnonymousFieldFT;
import de.rub.nds.asn1.translator.fieldtranslators.FieldTranslator;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class Asn1Translator {
    private static final Logger LOGGER = LogManager.getLogger();
    private final List<IntermediateAsn1Field> intermediateAsn1Fields;
    private final Context context;
    private final boolean isStrictMode;

    public Asn1Translator(String contextName, List<IntermediateAsn1Field> intermediateAsn1Fields, boolean strictMode) {
        this.intermediateAsn1Fields = intermediateAsn1Fields;
        this.context = ContextRegister.getInstance().createContext(contextName);
        this.isStrictMode = strictMode;
    }

    public List<Asn1Encodable> translate() {
        List<Asn1Encodable> asn1Encodables = this.isStrictMode ? this.translateStrict() : this.translateBestEffort();
        return asn1Encodables;
    }

    private List<Asn1Encodable> translateStrict() {
        LinkedList<Asn1Encodable> asn1Encodables = new LinkedList<Asn1Encodable>();
        for (IntermediateAsn1Field intermediateAsn1Field : this.intermediateAsn1Fields) {
            boolean isHandled = false;
            while (this.context.hasCurrent() && !isHandled) {
                ContextComponent contextComponent = this.context.getCurrent();
                if (contextComponent.hasMatch(intermediateAsn1Field)) {
                    asn1Encodables.add(this.translateSingleIntermediateField(contextComponent, intermediateAsn1Field));
                    isHandled = true;
                    if (contextComponent.isRepetitive) continue;
                    this.context.consume();
                    continue;
                }
                if (contextComponent.isRepetitive || contextComponent.isOptional) {
                    this.context.consume();
                    continue;
                }
                throw new RuntimeException("Context " + this.context.getClass() + " cannot handle " + asn1Encodables.getClass().toString() + "!");
            }
            if (isHandled) continue;
            throw new RuntimeException("Context " + this.context.getClass() + " cannot handle " + asn1Encodables.getClass().toString() + "!");
        }
        if (!this.context.canBeFinished()) {
            throw new RuntimeException("Context " + this.context.getClass() + " expects more components!");
        }
        return asn1Encodables;
    }

    private List<Asn1Encodable> translateBestEffort() {
        LinkedList<Asn1Encodable> asn1Encodables = new LinkedList<Asn1Encodable>();
        for (IntermediateAsn1Field intermediateAsn1Field : this.intermediateAsn1Fields) {
            boolean contextComponentsOptionalUntilMatch = false;
            boolean isHandled = false;
            while (this.context.hasCurrent()) {
                ContextComponent contextComponent = this.context.getCurrent();
                if (contextComponent.hasMatch(intermediateAsn1Field)) {
                    asn1Encodables.add(this.translateSingleIntermediateField(contextComponent, intermediateAsn1Field));
                    isHandled = true;
                    if (!contextComponent.isRepetitive) {
                        this.context.consume();
                    }
                } else if (contextComponentsOptionalUntilMatch) {
                    this.context.consume();
                } else if (contextComponent.isRepetitive || contextComponent.isOptional) {
                    contextComponentsOptionalUntilMatch = this.contextComponentsOptionalUntilMatch(intermediateAsn1Field);
                }
                if (contextComponentsOptionalUntilMatch && !isHandled) continue;
            }
            if (isHandled) continue;
            asn1Encodables.add(this.translateSingleIntermediateField(intermediateAsn1Field));
        }
        if (!this.context.canBeFinished()) {
            LOGGER.warn("Context " + this.context.getClass() + " expects more components!");
        }
        return asn1Encodables;
    }

    private boolean contextComponentsOptionalUntilMatch(IntermediateAsn1Field intermediateAsn1Field) {
        boolean result = false;
        int i = 1;
        while (!result && this.context.has(i)) {
            if (this.context.peek(i).hasMatch(intermediateAsn1Field)) {
                result = true;
            }
            ++i;
        }
        return result;
    }

    private Asn1Encodable translateSingleIntermediateField(IntermediateAsn1Field intermediateAsn1Field) {
        Asn1AnonymousFieldFT anonymousFieldFT = new Asn1AnonymousFieldFT(intermediateAsn1Field);
        return anonymousFieldFT.translate("", "");
    }

    private Asn1Encodable translateSingleIntermediateField(ContextComponent contextComponent, IntermediateAsn1Field intermediateAsn1Field) {
        ContextComponentOption<?> contextComponentOption = contextComponent.getMatch(intermediateAsn1Field);
        FieldTranslator fieldTranslator = this.invokeFieldTranslator(contextComponentOption.fieldTranslatorClass, intermediateAsn1Field);
        Object result = fieldTranslator.translate(contextComponent.identifier, contextComponent.type);
        if (result instanceof Asn1Container) {
            Asn1Container container = (Asn1Container)result;
            Asn1Translator childTranslator = new Asn1Translator(contextComponentOption.subContextName, intermediateAsn1Field.getChildren(), this.isStrictMode);
            container.setChildren(childTranslator.translate());
        }
        return result;
    }

    private <T extends Asn1Encodable> FieldTranslator<T> invokeFieldTranslator(Class<? extends FieldTranslator<T>> fieldTranslatorClass, IntermediateAsn1Field intermediateAsn1Field) {
        try {
            Constructor<FieldTranslator<T>> constructor = fieldTranslatorClass.getDeclaredConstructor(IntermediateAsn1Field.class);
            return constructor.newInstance(intermediateAsn1Field);
        }
        catch (NoSuchMethodException e) {
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            throw new RuntimeException(e);
        }
    }
}

