/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.crypto.keys;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomPrivateKey;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.math.BigInteger;
import java.util.Objects;
import javax.crypto.interfaces.DHPrivateKey;
import javax.crypto.spec.DHParameterSpec;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@XmlAccessorType(value=XmlAccessType.FIELD)
public class CustomDHPrivateKey
extends CustomPrivateKey
implements DHPrivateKey {
    private static final Logger LOGGER = LogManager.getLogger();
    private final BigInteger privateKey;
    private final BigInteger modulus;
    private final BigInteger generator;

    private CustomDHPrivateKey() {
        this.privateKey = null;
        this.modulus = null;
        this.generator = null;
    }

    public CustomDHPrivateKey(BigInteger privateKey, BigInteger modulus, BigInteger generator) {
        this.privateKey = privateKey;
        this.modulus = modulus;
        this.generator = generator;
    }

    @Override
    public BigInteger getX() {
        return this.privateKey;
    }

    @Override
    public DHParameterSpec getParams() {
        return new DHParameterSpec(this.modulus, this.generator);
    }

    @Override
    public String getAlgorithm() {
        return "DH";
    }

    @Override
    public String getFormat() {
        return "None";
    }

    @Override
    public byte[] getEncoded() {
        throw new UnsupportedOperationException("CustomKey cannot be encoded");
    }

    @Override
    public void adjustInContext(TlsContext context, ConnectionEndType ownerOfKey) {
        LOGGER.debug("Adjusting DH private key in context");
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                context.setClientDhPrivateKey(this.privateKey);
                break;
            }
            case SERVER: {
                context.setServerDhPrivateKey(this.privateKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    @Override
    public void adjustInConfig(Config config, ConnectionEndType ownerOfKey) {
        if (null == ownerOfKey) {
            throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
        }
        switch (ownerOfKey) {
            case CLIENT: {
                config.setDefaultClientDhPrivateKey(this.privateKey);
                break;
            }
            case SERVER: {
                config.setDefaultServerDhPrivateKey(this.privateKey);
                break;
            }
            default: {
                throw new IllegalArgumentException("Owner of Key " + ownerOfKey + " is not supported");
            }
        }
    }

    public int hashCode() {
        int hash = 3;
        hash = 23 * hash + Objects.hashCode(this.privateKey);
        hash = 23 * hash + Objects.hashCode(this.modulus);
        hash = 23 * hash + Objects.hashCode(this.generator);
        return hash;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        CustomDHPrivateKey other = (CustomDHPrivateKey)obj;
        if (!Objects.equals(this.privateKey, other.privateKey)) {
            return false;
        }
        if (!Objects.equals(this.modulus, other.modulus)) {
            return false;
        }
        return Objects.equals(this.generator, other.generator);
    }
}

