/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.preparator;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.protocol.message.PskEcDhClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.preparator.ECDHClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.workflow.chooser.Chooser;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class PskEcDhClientKeyExchangePreparator
extends ECDHClientKeyExchangePreparator<PskEcDhClientKeyExchangeMessage> {
    private static final Logger LOGGER = LogManager.getLogger();
    private ByteArrayOutputStream outputStream;
    private final PskEcDhClientKeyExchangeMessage msg;

    public PskEcDhClientKeyExchangePreparator(Chooser chooser, PskEcDhClientKeyExchangeMessage message) {
        super(chooser, message);
        this.msg = message;
    }

    @Override
    public void prepareHandshakeMessageContents() {
        this.msg.setIdentity(this.chooser.getPSKIdentity());
        this.msg.setIdentityLength(((byte[])this.msg.getIdentity().getValue()).length);
        super.prepareHandshakeMessageContents();
    }

    @Override
    protected byte[] computePremasterSecret(EllipticCurve curve, Point publicKey, BigInteger privateKey) {
        byte[] premasterSecret = super.computePremasterSecret(curve, publicKey, privateKey);
        this.outputStream = new ByteArrayOutputStream();
        try {
            this.outputStream.write(ArrayConverter.intToBytes((int)premasterSecret.length, (int)2));
            LOGGER.debug("PremasterSecret: dhValue Length: " + premasterSecret.length);
            this.outputStream.write(premasterSecret);
            LOGGER.debug("PremasterSecret: dhValue" + Arrays.toString(premasterSecret));
            this.outputStream.write(ArrayConverter.intToBytes((int)this.chooser.getConfig().getDefaultPSKKey().length, (int)2));
            this.outputStream.write(this.chooser.getConfig().getDefaultPSKKey());
        }
        catch (IOException ex) {
            LOGGER.warn("Encountered exception while writing to ByteArrayOutputStream.");
            LOGGER.debug((Object)ex);
        }
        byte[] tempPremasterSecret = this.outputStream.toByteArray();
        LOGGER.debug("PSK PremasterSecret: " + Arrays.toString(tempPremasterSecret));
        return tempPremasterSecret;
    }
}

