/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.workflow.action;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.exceptions.WorkflowExecutionException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.EsniKeyRecord;
import de.rub.nds.tlsattacker.core.protocol.message.extension.ExtensionMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.extension.EsniKeyRecordParser;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import java.util.Base64;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.xbill.DNS.Lookup;
import org.xbill.DNS.Record;
import org.xbill.DNS.TXTRecord;
import org.xbill.DNS.TextParseException;

public class EsniKeyDnsRequestAction
extends TlsAction {
    private static final Logger LOGGER = LogManager.getLogger();
    private List<ExtensionMessage> extensions;

    @Override
    public void execute(State state) throws WorkflowExecutionException {
        byte[] esniKeyRecordBytes;
        TlsContext tlsContext = state.getTlsContext();
        Config tlsConfig = state.getConfig();
        if (this.isExecuted()) {
            throw new WorkflowExecutionException("Action already executed!");
        }
        String hostname = "_esni." + tlsConfig.getDefaultClientConnection().getHostname();
        LOGGER.debug("Sending DNS request to get ESNI Resource Record for: " + hostname);
        LinkedList<String> esniKeyRecords = new LinkedList<String>();
        try {
            Lookup lookup = new Lookup(hostname, 16);
            lookup.run();
            if (lookup.getResult() == 0) {
                for (Record record : lookup.getAnswers()) {
                    for (String recordString : ((TXTRecord)record).getStrings()) {
                        esniKeyRecords.add(recordString);
                    }
                }
            }
        }
        catch (TextParseException e) {
            LOGGER.warn("No ESNI DNS Resource Record available for " + hostname);
            this.setExecuted(true);
            return;
        }
        if (esniKeyRecords.isEmpty()) {
            LOGGER.warn("No ESNI DNS Resource Record available for " + hostname);
            this.setExecuted(true);
            return;
        }
        String esniKeyRecordStr = (String)esniKeyRecords.get(0);
        try {
            esniKeyRecordBytes = Base64.getMimeDecoder().decode(esniKeyRecordStr);
        }
        catch (IllegalArgumentException e) {
            LOGGER.warn("Failed to base64 decode Resource Record for" + hostname + ". Resource Record: " + esniKeyRecordStr);
            this.setExecuted(true);
            return;
        }
        LOGGER.debug("esniKeyRecordStr :" + esniKeyRecordStr);
        LOGGER.debug("esniKeyRecordBytes: " + ArrayConverter.bytesToHexString((byte[])esniKeyRecordBytes));
        EsniKeyRecordParser esniKeyParser = new EsniKeyRecordParser(0, esniKeyRecordBytes, tlsContext.getConfig());
        EsniKeyRecord esniKeyRecord = esniKeyParser.parse();
        tlsContext.setEsniRecordBytes(esniKeyRecordBytes);
        tlsContext.setEsniRecordVersion(esniKeyRecord.getVersion());
        tlsContext.setEsniRecordChecksum(esniKeyRecord.getChecksum());
        tlsContext.setEsniServerKeyShareEntries(esniKeyRecord.getKeys());
        tlsContext.setEsniServerCiphersuites(esniKeyRecord.getCipherSuites());
        tlsContext.setEsniPaddedLength(esniKeyRecord.getPaddedLength());
        tlsContext.setEsniKeysNotBefore(esniKeyRecord.getNotBefore());
        tlsContext.setEsniKeysNotAfter(esniKeyRecord.getNotAfter());
        this.extensions = esniKeyRecord.getExtensions();
        this.setExecuted(true);
    }

    @Override
    public void reset() {
        this.setExecuted(false);
    }

    @Override
    public boolean executedAsPlanned() {
        return this.isExecuted();
    }
}

