/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.attacks.pkcs1.oracles;

import de.rub.nds.tlsattacker.attacks.pkcs1.OracleException;
import java.security.PublicKey;
import java.security.interfaces.RSAPublicKey;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class Pkcs1Oracle {
    private static final Logger LOGGER = LogManager.getLogger();
    protected long numberOfQueries;
    protected int blockSize;
    protected RSAPublicKey publicKey;
    protected boolean isPlaintextOracle = false;
    protected OracleType oracleType = null;

    public int getBlockSize() {
        return this.blockSize;
    }

    public long getNumberOfQueries() {
        return this.numberOfQueries;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public abstract boolean checkPKCSConformity(byte[] var1) throws OracleException;

    public boolean isPlaintextOracle() {
        return this.isPlaintextOracle;
    }

    public OracleType getOracleType() {
        return this.oracleType;
    }

    public void resetNumberOfQueries() {
        this.numberOfQueries = 0L;
    }

    public static enum OracleType {
        TTT,
        TFT,
        FTT,
        FFT,
        FFF,
        JSSE,
        XMLENC,
        BigIP,
        MANGER_0x00,
        DROWN_EXTRA_CLEAR;

    }
}

