/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.descriptor;

import java.lang.reflect.AnnotatedElement;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.junit.jupiter.api.Order;
import org.junit.jupiter.api.extension.ExtendWith;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.api.extension.RegisterExtension;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.MutableExtensionRegistry;
import org.junit.platform.commons.util.AnnotationUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ReflectionUtils;

final class ExtensionUtils {
    private static final Comparator<Field> orderComparator = (field1, field2) -> Integer.compare(ExtensionUtils.getOrder(field1), ExtensionUtils.getOrder(field2));

    private ExtensionUtils() {
    }

    static MutableExtensionRegistry populateNewExtensionRegistryFromExtendWithAnnotation(MutableExtensionRegistry parentRegistry, AnnotatedElement annotatedElement) {
        Preconditions.notNull((Object)parentRegistry, (String)"Parent ExtensionRegistry must not be null");
        Preconditions.notNull((Object)annotatedElement, (String)"AnnotatedElement must not be null");
        List<Class<? extends Extension>> extensionTypes = AnnotationUtils.findRepeatableAnnotations((AnnotatedElement)annotatedElement, ExtendWith.class).stream().map(ExtendWith::value).flatMap(Arrays::stream).collect(Collectors.toList());
        return MutableExtensionRegistry.createRegistryFrom(parentRegistry, extensionTypes);
    }

    static void registerExtensionsFromFields(ExtensionRegistrar registrar, Class<?> clazz, Object instance) {
        Preconditions.notNull((Object)registrar, (String)"ExtensionRegistrar must not be null");
        Preconditions.notNull(clazz, (String)"Class must not be null");
        Predicate<Field> predicate = instance == null ? ReflectionUtils::isStatic : ReflectionUtils::isNotStatic;
        ArrayList<Field> fields = new ArrayList<Field>(AnnotationUtils.findAnnotatedFields(clazz, RegisterExtension.class, predicate));
        fields.sort(orderComparator);
        fields.forEach(field -> {
            Preconditions.condition((boolean)ReflectionUtils.isNotPrivate((Member)field), () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field must not be private.", field));
            ReflectionUtils.tryToReadFieldValue((Field)field, (Object)instance).ifSuccess(value -> {
                Preconditions.condition((boolean)(value instanceof Extension), () -> String.format("Failed to register extension via @RegisterExtension field [%s]: field value's type [%s] must implement an [%s] API.", field, value != null ? value.getClass().getName() : null, Extension.class.getName()));
                registrar.registerExtension((Extension)value, field);
            });
        });
    }

    private static int getOrder(Field field) {
        return AnnotationUtils.findAnnotation((AnnotatedElement)field, Order.class).map(Order::value).orElse(Integer.MAX_VALUE);
    }
}

