/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.x509attacker.linker;

import de.rub.nds.asn1.Asn1Encodable;
import de.rub.nds.asn1.util.AttributeParser;
import de.rub.nds.x509attacker.linker.LinkerException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.Map;

public class Linker {
    private final Map<String, Asn1Encodable> identifierMap;
    private Map<Asn1Encodable, Asn1Encodable> links = new HashMap<Asn1Encodable, Asn1Encodable>();

    public Linker(Map<String, Asn1Encodable> identifierMap) {
        this.identifierMap = identifierMap;
        this.runLinking();
    }

    public void runLinking() {
        LinkedList<Asn1Encodable> asn1Encodables = new LinkedList<Asn1Encodable>(this.identifierMap.values());
        for (Asn1Encodable asn1Encodable : asn1Encodables) {
            if (!asn1Encodable.hasAttribute("fromIdentifier")) continue;
            String fromIdentifier = AttributeParser.parseStringAttribute((Asn1Encodable)asn1Encodable, (String)"fromIdentifier");
            this.resolveAndBuildLink(asn1Encodable, fromIdentifier);
        }
    }

    private void resolveAndBuildLink(Asn1Encodable asn1Encodable, String fromIdentifier) {
        if (!fromIdentifier.isEmpty()) {
            if (this.identifierMap.containsKey(fromIdentifier)) {
                Asn1Encodable referencedAsn1Encodable = this.identifierMap.get(fromIdentifier);
                this.buildLink(asn1Encodable, referencedAsn1Encodable);
            } else {
                throw new LinkerException("Cannot build link from " + asn1Encodable + " for fromIdentifier " + fromIdentifier + "!");
            }
        }
    }

    private void buildLink(Asn1Encodable asn1Encodable, Asn1Encodable referencedAsn1Encodable) {
        this.links.put(asn1Encodable, referencedAsn1Encodable);
    }

    public boolean hasLink(Asn1Encodable asn1Encodable) {
        return this.links.containsKey(asn1Encodable);
    }

    public Asn1Encodable getLinkedAsn1Encodable(Asn1Encodable asn1Encodable) {
        return this.links.get(asn1Encodable);
    }
}

