/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.modules.keyring.gnome.libsecret;

import com.sun.jna.Native;
import com.sun.jna.Pointer;
import com.sun.jna.Structure;
import com.sun.jna.ptr.PointerByReference;
import java.io.ByteArrayOutputStream;
import java.nio.ByteBuffer;
import java.nio.CharBuffer;
import java.nio.charset.Charset;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.netbeans.modules.keyring.gnome.libsecret.Glib;
import org.netbeans.modules.keyring.gnome.libsecret.LibSecret;
import org.netbeans.modules.keyring.impl.KeyringSupport;
import org.netbeans.spi.keyring.KeyringProvider;

public class GnomeLibSecretProvider
implements KeyringProvider {
    private static final Logger LOG = Logger.getLogger(GnomeLibSecretProvider.class.getName());
    private static final String KEY = "key";
    private static final Charset CHARSET = Charset.forName(Native.getDefaultStringEncoding());
    private final String appName = KeyringSupport.getAppName();
    private LibSecret.SecretSchema secretSchema = null;

    private LibSecret.SecretSchema getSchema() {
        if (this.secretSchema != null) {
            return this.secretSchema;
        }
        this.secretSchema = new LibSecret.SecretSchema();
        this.secretSchema.name = this.appName;
        this.secretSchema.flags = 0;
        this.secretSchema.attributes[0] = new LibSecret.SecretSchemaAttribute();
        this.secretSchema.attributes[0].name = KEY;
        this.secretSchema.attributes[0].type = 0;
        return this.secretSchema;
    }

    public boolean enabled() {
        if (Boolean.getBoolean("netbeans.keyring.no.native")) {
            LOG.fine("native keyring integration disabled");
            return false;
        }
        try {
            this.read("NoNeXiStEnT");
            return true;
        }
        catch (RuntimeException runtimeException) {
            LOG.log(Level.WARNING, null, runtimeException);
            return false;
        }
        catch (UnsatisfiedLinkError unsatisfiedLinkError) {
            LOG.log(Level.FINE, null, unsatisfiedLinkError);
            return false;
        }
    }

    public char[] read(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        LibSecret.SecretSchema secretSchema = this.getSchema();
        Pointer pointer = LibSecret.INSTANCE.secret_password_lookup_sync(secretSchema, null, pointerByReference, KEY, string);
        if (pointerByReference.getValue() != null) {
            this.processError(pointerByReference);
            return null;
        }
        if (pointer == null) {
            return null;
        }
        return this.decode(this.readZeroTerminatedBytes(pointer));
    }

    public void save(String string, char[] cArray, String string2) {
        PointerByReference pointerByReference = new PointerByReference();
        LibSecret.SecretSchema secretSchema = this.getSchema();
        String string3 = this.appName + " - " + (string2 != null ? string2 : string);
        LibSecret.INSTANCE.secret_password_store_sync(secretSchema, "default", string3, this.encode(cArray), null, pointerByReference, KEY, string);
        if (pointerByReference.getValue() != null) {
            this.processError(pointerByReference);
        }
    }

    public void delete(String string) {
        PointerByReference pointerByReference = new PointerByReference();
        LibSecret.SecretSchema secretSchema = this.getSchema();
        LibSecret.INSTANCE.secret_password_clear_sync(secretSchema, null, pointerByReference, KEY, string);
        if (pointerByReference.getValue() != null) {
            this.processError(pointerByReference);
        }
    }

    private void processError(PointerByReference pointerByReference) throws IllegalArgumentException {
        try {
            Glib.GError gError = (Glib.GError)Structure.newInstance(Glib.GError.class, (Pointer)pointerByReference.getValue());
            gError.read();
            throw new RuntimeException(String.format("%d/%d: %s", gError.domain, gError.code, gError.message));
        }
        catch (Throwable throwable) {
            Glib.INSTANCE.g_error_free(pointerByReference.getValue());
            throw throwable;
        }
    }

    private byte[] encode(char[] cArray) {
        ByteBuffer byteBuffer = CHARSET.encode(CharBuffer.wrap(cArray));
        byte[] byArray = new byte[byteBuffer.limit() + 1];
        byteBuffer.get(byArray, 0, byteBuffer.limit());
        return byArray;
    }

    private char[] decode(byte[] byArray) {
        CharBuffer charBuffer = CHARSET.decode(ByteBuffer.wrap(byArray));
        char[] cArray = new char[charBuffer.limit()];
        charBuffer.get(cArray, 0, charBuffer.limit());
        return cArray;
    }

    private byte[] readZeroTerminatedBytes(Pointer pointer) {
        byte by;
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        for (int i = 0; i < 100000 && (by = pointer.getByte((long)i)) != 0; ++i) {
            byteArrayOutputStream.write(by);
        }
        return byteArrayOutputStream.toByteArray();
    }
}

