"""Generated message classes for sqladmin version v1beta4.

API for Cloud SQL database instance management
"""
# NOTE: This file is autogenerated and should not be edited by hand.

from __future__ import absolute_import

from apitools.base.protorpclite import messages as _messages
from apitools.base.py import encoding
from apitools.base.py import extra_types


package = 'sqladmin'


class AclEntry(_messages.Message):
  r"""An entry for an Access Control list.

  Fields:
    expirationTime: The time when this access control entry expires in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    kind: This is always `sql#aclEntry`.
    name: Optional. A label to identify this entry.
    value: The allowlisted value for the access control list.
  """

  expirationTime = _messages.StringField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)
  value = _messages.StringField(4)


class AcquireSsrsLeaseContext(_messages.Message):
  r"""Acquire SSRS lease context.

  Fields:
    duration: Lease duration needed for the SSRS setup.
    reportDatabase: The report database to be used for the SSRS setup.
    serviceLogin: The username to be used as the service login to connect to
      the report database for SSRS setup.
    setupLogin: The username to be used as the setup login to connect to the
      database server for SSRS setup.
  """

  duration = _messages.StringField(1)
  reportDatabase = _messages.StringField(2)
  serviceLogin = _messages.StringField(3)
  setupLogin = _messages.StringField(4)


class AdvancedMachineFeatures(_messages.Message):
  r"""Specifies options for controlling advanced machine features.

  Fields:
    threadsPerCore: The number of threads per physical core.
  """

  threadsPerCore = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class ApiWarning(_messages.Message):
  r"""An Admin API warning message.

  Enums:
    CodeValueValuesEnum: Code to uniquely identify the warning type.

  Fields:
    code: Code to uniquely identify the warning type.
    message: The warning message.
    region: The region name for REGION_UNREACHABLE warning.
  """

  class CodeValueValuesEnum(_messages.Enum):
    r"""Code to uniquely identify the warning type.

    Values:
      SQL_API_WARNING_CODE_UNSPECIFIED: An unknown or unset warning type from
        Cloud SQL API.
      REGION_UNREACHABLE: Warning when one or more regions are not reachable.
        The returned result set may be incomplete.
      MAX_RESULTS_EXCEEDS_LIMIT: Warning when user provided maxResults
        parameter exceeds the limit. The returned result set may be
        incomplete.
      COMPROMISED_CREDENTIALS: Warning when user tries to create/update a user
        with credentials that have previously been compromised by a public
        data breach.
      INTERNAL_STATE_FAILURE: Warning when the operation succeeds but some
        non-critical workflow state failed.
    """
    SQL_API_WARNING_CODE_UNSPECIFIED = 0
    REGION_UNREACHABLE = 1
    MAX_RESULTS_EXCEEDS_LIMIT = 2
    COMPROMISED_CREDENTIALS = 3
    INTERNAL_STATE_FAILURE = 4

  code = _messages.EnumField('CodeValueValuesEnum', 1)
  message = _messages.StringField(2)
  region = _messages.StringField(3)


class AvailableDatabaseVersion(_messages.Message):
  r"""An available database version. It can be a major or a minor version.

  Fields:
    displayName: The database version's display name.
    majorVersion: The version's major version name.
    name: The database version name. For MySQL 8.0, this string provides the
      database major and minor version.
  """

  displayName = _messages.StringField(1)
  majorVersion = _messages.StringField(2)
  name = _messages.StringField(3)


class Backup(_messages.Message):
  r"""A backup resource.

  Enums:
    BackupKindValueValuesEnum: Output only. Specifies the kind of backup,
      PHYSICAL or DEFAULT_SNAPSHOT.
    DatabaseVersionValueValuesEnum: Output only. The database version of the
      instance of at the time this backup was made.
    StateValueValuesEnum: Output only. The state of this backup.
    TypeValueValuesEnum: Output only. The type of this backup. The type can be
      "AUTOMATED", "ON_DEMAND", or "FINAL".

  Fields:
    backupInterval: Output only. This output contains the following values:
      start_time: All database writes up to this time are available. end_time:
      Any database writes after this time aren't available.
    backupKind: Output only. Specifies the kind of backup, PHYSICAL or
      DEFAULT_SNAPSHOT.
    backupRun: Output only. The mapping to backup run resource used for IAM
      validations.
    databaseVersion: Output only. The database version of the instance of at
      the time this backup was made.
    description: The description of this backup.
    error: Output only. Information about why the backup operation fails (for
      example, when the backup state fails).
    expiryTime: Backup expiration time. A UTC timestamp of when this resource
      expired.
    instance: The name of the database instance.
    instanceDeletionTime: Optional. Output only. Timestamp in UTC of when the
      instance associated with this backup is deleted.
    instanceSettings: Optional. Output only. Instance setting of the source
      instance that's associated with this backup.
    kind: Output only. This is always `sql#backup`.
    kmsKey: Output only. This output contains the encryption configuration for
      a backup and the resource name of the KMS key for disk encryption.
    kmsKeyVersion: Output only. This output contains the encryption status for
      a backup and the version of the KMS key that's used to encrypt the Cloud
      SQL instance.
    location: The storage location of the backups. The location can be multi-
      regional.
    maxChargeableBytes: Output only. The maximum chargeable bytes for the
      backup.
    name: Output only. The resource name of the backup. Format:
      projects/{project}/backups/{backup}.
    satisfiesPzi: Output only. This status indicates whether the backup
      satisfies PZI. The status is reserved for future use.
    satisfiesPzs: Output only. This status indicates whether the backup
      satisfies PZS. The status is reserved for future use.
    selfLink: Output only. The URI of this resource.
    state: Output only. The state of this backup.
    timeZone: Output only. This output contains a backup time zone. If a Cloud
      SQL for SQL Server instance has a different time zone from the backup's
      time zone, then the restore to the instance doesn't happen.
    ttlDays: Input only. The time-to-live (TTL) interval for this resource (in
      days). For example: ttlDays:7, means 7 days from the current time. The
      expiration time can't exceed 365 days from the time that the backup is
      created.
    type: Output only. The type of this backup. The type can be "AUTOMATED",
      "ON_DEMAND", or "FINAL".
  """

  class BackupKindValueValuesEnum(_messages.Enum):
    r"""Output only. Specifies the kind of backup, PHYSICAL or
    DEFAULT_SNAPSHOT.

    Values:
      SQL_BACKUP_KIND_UNSPECIFIED: This is an unknown BackupKind.
      SNAPSHOT: Snapshot-based backups.
      PHYSICAL: Physical backups.
    """
    SQL_BACKUP_KIND_UNSPECIFIED = 0
    SNAPSHOT = 1
    PHYSICAL = 2

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""Output only. The database version of the instance of at the time this
    backup was made.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The state of this backup.

    Values:
      SQL_BACKUP_STATE_UNSPECIFIED: The state of the backup is unknown.
      ENQUEUED: The backup that's added to a queue.
      RUNNING: The backup is in progress.
      FAILED: The backup failed.
      SUCCESSFUL: The backup is successful.
      DELETING: The backup is being deleted.
      DELETION_FAILED: Deletion of the backup failed.
    """
    SQL_BACKUP_STATE_UNSPECIFIED = 0
    ENQUEUED = 1
    RUNNING = 2
    FAILED = 3
    SUCCESSFUL = 4
    DELETING = 5
    DELETION_FAILED = 6

  class TypeValueValuesEnum(_messages.Enum):
    r"""Output only. The type of this backup. The type can be "AUTOMATED",
    "ON_DEMAND", or "FINAL".

    Values:
      SQL_BACKUP_TYPE_UNSPECIFIED: This is an unknown backup type.
      AUTOMATED: The backup schedule triggers a backup automatically.
      ON_DEMAND: The user triggers a backup manually.
      FINAL: The backup that's created when the instance is deleted.
    """
    SQL_BACKUP_TYPE_UNSPECIFIED = 0
    AUTOMATED = 1
    ON_DEMAND = 2
    FINAL = 3

  backupInterval = _messages.MessageField('Interval', 1)
  backupKind = _messages.EnumField('BackupKindValueValuesEnum', 2)
  backupRun = _messages.StringField(3)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 4)
  description = _messages.StringField(5)
  error = _messages.MessageField('OperationError', 6)
  expiryTime = _messages.StringField(7)
  instance = _messages.StringField(8)
  instanceDeletionTime = _messages.StringField(9)
  instanceSettings = _messages.MessageField('DatabaseInstance', 10)
  kind = _messages.StringField(11)
  kmsKey = _messages.StringField(12)
  kmsKeyVersion = _messages.StringField(13)
  location = _messages.StringField(14)
  maxChargeableBytes = _messages.IntegerField(15)
  name = _messages.StringField(16)
  satisfiesPzi = _messages.BooleanField(17)
  satisfiesPzs = _messages.BooleanField(18)
  selfLink = _messages.StringField(19)
  state = _messages.EnumField('StateValueValuesEnum', 20)
  timeZone = _messages.StringField(21)
  ttlDays = _messages.IntegerField(22)
  type = _messages.EnumField('TypeValueValuesEnum', 23)


class BackupConfiguration(_messages.Message):
  r"""Database instance backup configuration.

  Enums:
    BackupTierValueValuesEnum: Output only. Backup tier that manages the
      backups for the instance.
    TransactionalLogStorageStateValueValuesEnum: Output only. This value
      contains the storage location of transactional logs for the database for
      point-in-time recovery.

  Fields:
    backupRetentionSettings: Backup retention settings.
    backupTier: Output only. Backup tier that manages the backups for the
      instance.
    binaryLogEnabled: (MySQL only) Whether binary log is enabled. If backup
      configuration is disabled, binarylog must be disabled as well.
    enabled: Whether this configuration is enabled.
    kind: This is always `sql#backupConfiguration`.
    location: Location of the backup
    managementConfig: Output only. Configurations for Backup and DR Service
      managed instances.
    pointInTimeRecoveryEnabled: Whether point in time recovery is enabled.
    replicationLogArchivingEnabled: Reserved for future use.
    startTime: Start time for the daily backup configuration in UTC timezone
      in the 24 hour format - `HH:MM`.
    transactionLogRetentionDays: The number of days of transaction logs we
      retain for point in time restore, from 1-7.
    transactionalLogStorageState: Output only. This value contains the storage
      location of transactional logs for the database for point-in-time
      recovery.
  """

  class BackupTierValueValuesEnum(_messages.Enum):
    r"""Output only. Backup tier that manages the backups for the instance.

    Values:
      BACKUP_TIER_UNSPECIFIED: Unspecified.
      STANDARD: Instance is managed by Cloud SQL.
      ADVANCED: Deprecated: ADVANCED is deprecated. Please use ENHANCED
        instead.
      ENHANCED: Instance is managed by Google Cloud Backup and DR Service.
    """
    BACKUP_TIER_UNSPECIFIED = 0
    STANDARD = 1
    ADVANCED = 2
    ENHANCED = 3

  class TransactionalLogStorageStateValueValuesEnum(_messages.Enum):
    r"""Output only. This value contains the storage location of transactional
    logs for the database for point-in-time recovery.

    Values:
      TRANSACTIONAL_LOG_STORAGE_STATE_UNSPECIFIED: Unspecified.
      DISK: The transaction logs used for PITR for the instance are stored on
        a data disk.
      SWITCHING_TO_CLOUD_STORAGE: The transaction logs used for PITR for the
        instance are switching from being stored on a data disk to being
        stored in Cloud Storage. Only applicable to MySQL.
      SWITCHED_TO_CLOUD_STORAGE: The transaction logs used for PITR for the
        instance are now stored in Cloud Storage. Previously, they were stored
        on a data disk. Only applicable to MySQL.
      CLOUD_STORAGE: The transaction logs used for PITR for the instance are
        stored in Cloud Storage. Only applicable to MySQL and PostgreSQL.
    """
    TRANSACTIONAL_LOG_STORAGE_STATE_UNSPECIFIED = 0
    DISK = 1
    SWITCHING_TO_CLOUD_STORAGE = 2
    SWITCHED_TO_CLOUD_STORAGE = 3
    CLOUD_STORAGE = 4

  backupRetentionSettings = _messages.MessageField('BackupRetentionSettings', 1)
  backupTier = _messages.EnumField('BackupTierValueValuesEnum', 2)
  binaryLogEnabled = _messages.BooleanField(3)
  enabled = _messages.BooleanField(4)
  kind = _messages.StringField(5)
  location = _messages.StringField(6)
  managementConfig = _messages.MessageField('ManagementConfig', 7)
  pointInTimeRecoveryEnabled = _messages.BooleanField(8)
  replicationLogArchivingEnabled = _messages.BooleanField(9)
  startTime = _messages.StringField(10)
  transactionLogRetentionDays = _messages.IntegerField(11, variant=_messages.Variant.INT32)
  transactionalLogStorageState = _messages.EnumField('TransactionalLogStorageStateValueValuesEnum', 12)


class BackupContext(_messages.Message):
  r"""Backup context.

  Fields:
    backupId: The identifier of the backup.
    kind: This is always `sql#backupContext`.
    name: The name of the backup. Format: projects/{project}/backups/{backup}
  """

  backupId = _messages.IntegerField(1)
  kind = _messages.StringField(2)
  name = _messages.StringField(3)


class BackupReencryptionConfig(_messages.Message):
  r"""Backup Reencryption Config

  Enums:
    BackupTypeValueValuesEnum: Type of backups users want to re-encrypt.

  Fields:
    backupLimit: Backup re-encryption limit
    backupType: Type of backups users want to re-encrypt.
  """

  class BackupTypeValueValuesEnum(_messages.Enum):
    r"""Type of backups users want to re-encrypt.

    Values:
      BACKUP_TYPE_UNSPECIFIED: Unknown backup type, will be defaulted to
        AUTOMATIC backup type
      AUTOMATED: Reencrypt automatic backups
      ON_DEMAND: Reencrypt on-demand backups
    """
    BACKUP_TYPE_UNSPECIFIED = 0
    AUTOMATED = 1
    ON_DEMAND = 2

  backupLimit = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  backupType = _messages.EnumField('BackupTypeValueValuesEnum', 2)


class BackupRetentionSettings(_messages.Message):
  r"""We currently only support backup retention by specifying the number of
  backups we will retain.

  Enums:
    RetentionUnitValueValuesEnum: The unit that 'retained_backups' represents.

  Fields:
    retainedBackups: Depending on the value of retention_unit, this is used to
      determine if a backup needs to be deleted. If retention_unit is 'COUNT',
      we will retain this many backups.
    retentionUnit: The unit that 'retained_backups' represents.
  """

  class RetentionUnitValueValuesEnum(_messages.Enum):
    r"""The unit that 'retained_backups' represents.

    Values:
      RETENTION_UNIT_UNSPECIFIED: Backup retention unit is unspecified, will
        be treated as COUNT.
      COUNT: Retention will be by count, eg. "retain the most recent 7
        backups".
    """
    RETENTION_UNIT_UNSPECIFIED = 0
    COUNT = 1

  retainedBackups = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  retentionUnit = _messages.EnumField('RetentionUnitValueValuesEnum', 2)


class BackupRun(_messages.Message):
  r"""A BackupRun resource.

  Enums:
    BackupKindValueValuesEnum: Specifies the kind of backup, PHYSICAL or
      DEFAULT_SNAPSHOT.
    DatabaseVersionValueValuesEnum: Output only. The instance database version
      at the time this backup was made.
    StatusValueValuesEnum: The status of this run.
    TypeValueValuesEnum: The type of this run; can be either "AUTOMATED" or
      "ON_DEMAND" or "FINAL". This field defaults to "ON_DEMAND" and is
      ignored, when specified for insert requests.

  Fields:
    backupDatabaseInstalledVersion: Output only. Currently installed database
      version on the instance, including minor versions, such as
      `MYSQL_8_0_18`.
    backupKind: Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.
    databaseVersion: Output only. The instance database version at the time
      this backup was made.
    description: The description of this run, only applicable to on-demand
      backups.
    diskEncryptionConfiguration: Encryption configuration specific to a
      backup.
    diskEncryptionStatus: Encryption status specific to a backup.
    endTime: The time the backup operation completed in UTC timezone in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    enqueuedTime: The time the run was enqueued in UTC timezone in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    error: Information about why the backup operation failed. This is only
      present if the run has the FAILED status.
    id: The identifier for this backup run. Unique only for a specific Cloud
      SQL instance.
    instance: Name of the database instance.
    kind: This is always `sql#backupRun`.
    location: Location of the backups.
    maxChargeableBytes: Output only. The maximum chargeable bytes for the
      backup.
    selfLink: The URI of this resource.
    startTime: The time the backup operation actually started in UTC timezone
      in [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    status: The status of this run.
    timeZone: Backup time zone to prevent restores to an instance with a
      different time zone. Now relevant only for SQL Server.
    type: The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or
      "FINAL". This field defaults to "ON_DEMAND" and is ignored, when
      specified for insert requests.
    windowStartTime: The start time of the backup window during which this the
      backup was attempted in [RFC 3339](https://tools.ietf.org/html/rfc3339)
      format, for example `2012-11-15T16:19:00.094Z`.
  """

  class BackupKindValueValuesEnum(_messages.Enum):
    r"""Specifies the kind of backup, PHYSICAL or DEFAULT_SNAPSHOT.

    Values:
      SQL_BACKUP_KIND_UNSPECIFIED: This is an unknown BackupKind.
      SNAPSHOT: Snapshot-based backups.
      PHYSICAL: Physical backups.
    """
    SQL_BACKUP_KIND_UNSPECIFIED = 0
    SNAPSHOT = 1
    PHYSICAL = 2

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""Output only. The instance database version at the time this backup was
    made.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of this run.

    Values:
      SQL_BACKUP_RUN_STATUS_UNSPECIFIED: The status of the run is unknown.
      ENQUEUED: The backup operation was enqueued.
      OVERDUE: The backup is overdue across a given backup window. Indicates a
        problem. Example: Long-running operation in progress during the whole
        window.
      RUNNING: The backup is in progress.
      FAILED: The backup failed.
      SUCCESSFUL: The backup was successful.
      SKIPPED: The backup was skipped (without problems) for a given backup
        window. Example: Instance was idle.
      DELETION_PENDING: The backup is about to be deleted.
      DELETION_FAILED: The backup deletion failed.
      DELETED: The backup has been deleted.
    """
    SQL_BACKUP_RUN_STATUS_UNSPECIFIED = 0
    ENQUEUED = 1
    OVERDUE = 2
    RUNNING = 3
    FAILED = 4
    SUCCESSFUL = 5
    SKIPPED = 6
    DELETION_PENDING = 7
    DELETION_FAILED = 8
    DELETED = 9

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this run; can be either "AUTOMATED" or "ON_DEMAND" or
    "FINAL". This field defaults to "ON_DEMAND" and is ignored, when specified
    for insert requests.

    Values:
      SQL_BACKUP_RUN_TYPE_UNSPECIFIED: This is an unknown BackupRun type.
      AUTOMATED: The backup schedule automatically triggers a backup.
      ON_DEMAND: The user manually triggers a backup.
      FINAL: The backup created when instance is deleted.
    """
    SQL_BACKUP_RUN_TYPE_UNSPECIFIED = 0
    AUTOMATED = 1
    ON_DEMAND = 2
    FINAL = 3

  backupDatabaseInstalledVersion = _messages.StringField(1)
  backupKind = _messages.EnumField('BackupKindValueValuesEnum', 2)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 3)
  description = _messages.StringField(4)
  diskEncryptionConfiguration = _messages.MessageField('DiskEncryptionConfiguration', 5)
  diskEncryptionStatus = _messages.MessageField('DiskEncryptionStatus', 6)
  endTime = _messages.StringField(7)
  enqueuedTime = _messages.StringField(8)
  error = _messages.MessageField('OperationError', 9)
  id = _messages.IntegerField(10)
  instance = _messages.StringField(11)
  kind = _messages.StringField(12)
  location = _messages.StringField(13)
  maxChargeableBytes = _messages.IntegerField(14)
  selfLink = _messages.StringField(15)
  startTime = _messages.StringField(16)
  status = _messages.EnumField('StatusValueValuesEnum', 17)
  timeZone = _messages.StringField(18)
  type = _messages.EnumField('TypeValueValuesEnum', 19)
  windowStartTime = _messages.StringField(20)


class BackupRunsListResponse(_messages.Message):
  r"""Backup run list results.

  Fields:
    items: A list of backup runs in reverse chronological order of the
      enqueued time.
    kind: This is always `sql#backupRunsList`.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
  """

  items = _messages.MessageField('BackupRun', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)


class BinLogCoordinates(_messages.Message):
  r"""Binary log coordinates.

  Fields:
    binLogFileName: Name of the binary log file for a Cloud SQL instance.
    binLogPosition: Position (offset) within the binary log file.
    kind: This is always `sql#binLogCoordinates`.
  """

  binLogFileName = _messages.StringField(1)
  binLogPosition = _messages.IntegerField(2)
  kind = _messages.StringField(3)


class CloneContext(_messages.Message):
  r"""Database instance clone context.

  Fields:
    allocatedIpRange: The name of the allocated ip range for the private ip
      Cloud SQL instance. For example: "google-managed-services-default". If
      set, the cloned instance ip will be created in the allocated range. The
      range name must comply with [RFC
      1035](https://tools.ietf.org/html/rfc1035). Specifically, the name must
      be 1-63 characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
    binLogCoordinates: Binary log coordinates, if specified, identify the
      position up to which the source instance is cloned. If not specified,
      the source instance is cloned up to the most recent binary log
      coordinates.
    databaseNames: (SQL Server only) Clone only the specified databases from
      the source instance. Clone all databases if empty.
    destinationInstanceName: Name of the Cloud SQL instance to be created as a
      clone.
    destinationNetwork: Optional. The fully qualified URI of the VPC network
      to which the cloned instance will be connected via Private Services
      Access for private IP. for example:`projects/my-network-
      project/global/networks/my-network`. This field is required only for
      cross-project cloning.
    destinationProject: Optional. The project ID of the destination project
      where the cloned instance will be created. To perform a cross-project
      clone, this field is required. If not specified, the clone is created in
      the same project as the source instance.
    kind: This is always `sql#cloneContext`.
    pitrTimestampMs: Reserved for future use.
    pointInTime: Timestamp, if specified, identifies the time to which the
      source instance is cloned.
    preferredSecondaryZone: Optional. Copy clone and point-in-time recovery
      clone of a regional instance in the specified zones. If not specified,
      clone to the same secondary zone as the source instance. This value
      cannot be the same as the preferred_zone field.
    preferredZone: Optional. Copy clone and point-in-time recovery clone of an
      instance to the specified zone. If no zone is specified, clone to the
      same primary zone as the source instance.
    sourceInstanceDeletionTime: The timestamp used to identify the time when
      the source instance is deleted. If this instance is deleted, then you
      must set the timestamp.
  """

  allocatedIpRange = _messages.StringField(1)
  binLogCoordinates = _messages.MessageField('BinLogCoordinates', 2)
  databaseNames = _messages.StringField(3, repeated=True)
  destinationInstanceName = _messages.StringField(4)
  destinationNetwork = _messages.StringField(5)
  destinationProject = _messages.StringField(6)
  kind = _messages.StringField(7)
  pitrTimestampMs = _messages.IntegerField(8)
  pointInTime = _messages.StringField(9)
  preferredSecondaryZone = _messages.StringField(10)
  preferredZone = _messages.StringField(11)
  sourceInstanceDeletionTime = _messages.StringField(12)


class Column(_messages.Message):
  r"""Contains the name and datatype of a column.

  Fields:
    name: Name of the column.
    type: Datatype of the column.
  """

  name = _messages.StringField(1)
  type = _messages.StringField(2)


class ConnectPoolNodeConfig(_messages.Message):
  r"""Details of a single read pool node of a read pool.

  Fields:
    dnsName: Output only. The DNS name of the read pool node.
    dnsNames: Output only. The list of DNS names used by this read pool node.
    ipAddresses: Output only. Mappings containing IP addresses that can be
      used to connect to the read pool node.
    name: Output only. The name of the read pool node. Doesn't include the
      project ID.
  """

  dnsName = _messages.StringField(1)
  dnsNames = _messages.MessageField('DnsNameMapping', 2, repeated=True)
  ipAddresses = _messages.MessageField('IpMapping', 3, repeated=True)
  name = _messages.StringField(4)


class ConnectSettings(_messages.Message):
  r"""Connect settings retrieval response.

  Enums:
    BackendTypeValueValuesEnum: `SECOND_GEN`: Cloud SQL database instance.
      `EXTERNAL`: A database server that is not managed by Google. This
      property is read-only; use the `tier` property in the `settings` object
      to determine the database type.
    DatabaseVersionValueValuesEnum: The database engine type and version. The
      `databaseVersion` field cannot be changed after instance creation. MySQL
      instances: `MYSQL_8_0`, `MYSQL_5_7` (default), or `MYSQL_5_6`.
      PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11` or
      `POSTGRES_12` (default), `POSTGRES_13`, or `POSTGRES_14`. SQL Server
      instances: `SQLSERVER_2017_STANDARD` (default),
      `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`,
      `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
      `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
      `SQLSERVER_2019_WEB`.
    MdxProtocolSupportValueListEntryValuesEnum:
    ServerCaModeValueValuesEnum: Specify what type of CA is used for the
      server certificate.

  Fields:
    backendType: `SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A
      database server that is not managed by Google. This property is read-
      only; use the `tier` property in the `settings` object to determine the
      database type.
    customSubjectAlternativeNames: Custom subject alternative names for the
      server certificate.
    databaseVersion: The database engine type and version. The
      `databaseVersion` field cannot be changed after instance creation. MySQL
      instances: `MYSQL_8_0`, `MYSQL_5_7` (default), or `MYSQL_5_6`.
      PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11` or
      `POSTGRES_12` (default), `POSTGRES_13`, or `POSTGRES_14`. SQL Server
      instances: `SQLSERVER_2017_STANDARD` (default),
      `SQLSERVER_2017_ENTERPRISE`, `SQLSERVER_2017_EXPRESS`,
      `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
      `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
      `SQLSERVER_2019_WEB`.
    dnsName: The dns name of the instance.
    dnsNames: Output only. The list of DNS names used by this instance.
    ipAddresses: The assigned IP addresses for the instance.
    kind: This is always `sql#connectSettings`.
    mdxProtocolSupport: Optional. Output only. mdx_protocol_support controls
      how the client uses metadata exchange when connecting to the instance.
      The values in the list representing parts of the MDX protocol that are
      supported by this instance. When the list is empty, the instance does
      not support MDX, so the client must not send an MDX request. The default
      is empty.
    nodeCount: The number of read pool nodes in a read pool.
    nodes: Output only. Entries containing information about each read pool
      node of the read pool.
    pscEnabled: Whether PSC connectivity is enabled for this instance.
    region: The cloud region for the instance. e.g. `us-central1`, `europe-
      west1`. The region cannot be changed after instance creation.
    serverCaCert: SSL configuration.
    serverCaMode: Specify what type of CA is used for the server certificate.
  """

  class BackendTypeValueValuesEnum(_messages.Enum):
    r"""`SECOND_GEN`: Cloud SQL database instance. `EXTERNAL`: A database
    server that is not managed by Google. This property is read-only; use the
    `tier` property in the `settings` object to determine the database type.

    Values:
      SQL_BACKEND_TYPE_UNSPECIFIED: This is an unknown backend type for
        instance.
      FIRST_GEN: V1 speckle instance.
      SECOND_GEN: V2 speckle instance.
      EXTERNAL: On premises instance.
    """
    SQL_BACKEND_TYPE_UNSPECIFIED = 0
    FIRST_GEN = 1
    SECOND_GEN = 2
    EXTERNAL = 3

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""The database engine type and version. The `databaseVersion` field
    cannot be changed after instance creation. MySQL instances: `MYSQL_8_0`,
    `MYSQL_5_7` (default), or `MYSQL_5_6`. PostgreSQL instances:
    `POSTGRES_9_6`, `POSTGRES_10`, `POSTGRES_11` or `POSTGRES_12` (default),
    `POSTGRES_13`, or `POSTGRES_14`. SQL Server instances:
    `SQLSERVER_2017_STANDARD` (default), `SQLSERVER_2017_ENTERPRISE`,
    `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`, `SQLSERVER_2019_STANDARD`,
    `SQLSERVER_2019_ENTERPRISE`, `SQLSERVER_2019_EXPRESS`, or
    `SQLSERVER_2019_WEB`.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class MdxProtocolSupportValueListEntryValuesEnum(_messages.Enum):
    r"""MdxProtocolSupportValueListEntryValuesEnum enum type.

    Values:
      MDX_PROTOCOL_SUPPORT_UNSPECIFIED: Not specified.
      CLIENT_PROTOCOL_TYPE: Client should send the client protocol type in the
        MDX request.
    """
    MDX_PROTOCOL_SUPPORT_UNSPECIFIED = 0
    CLIENT_PROTOCOL_TYPE = 1

  class ServerCaModeValueValuesEnum(_messages.Enum):
    r"""Specify what type of CA is used for the server certificate.

    Values:
      CA_MODE_UNSPECIFIED: CA mode is unspecified. It is effectively the same
        as `GOOGLE_MANAGED_INTERNAL_CA`.
      GOOGLE_MANAGED_INTERNAL_CA: Google-managed self-signed internal CA.
      GOOGLE_MANAGED_CAS_CA: Google-managed regional CA part of root CA
        hierarchy hosted on Google Cloud's Certificate Authority Service
        (CAS).
      CUSTOMER_MANAGED_CAS_CA: Customer-managed CA hosted on Google Cloud's
        Certificate Authority Service (CAS).
    """
    CA_MODE_UNSPECIFIED = 0
    GOOGLE_MANAGED_INTERNAL_CA = 1
    GOOGLE_MANAGED_CAS_CA = 2
    CUSTOMER_MANAGED_CAS_CA = 3

  backendType = _messages.EnumField('BackendTypeValueValuesEnum', 1)
  customSubjectAlternativeNames = _messages.StringField(2, repeated=True)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 3)
  dnsName = _messages.StringField(4)
  dnsNames = _messages.MessageField('DnsNameMapping', 5, repeated=True)
  ipAddresses = _messages.MessageField('IpMapping', 6, repeated=True)
  kind = _messages.StringField(7)
  mdxProtocolSupport = _messages.EnumField('MdxProtocolSupportValueListEntryValuesEnum', 8, repeated=True)
  nodeCount = _messages.IntegerField(9, variant=_messages.Variant.INT32)
  nodes = _messages.MessageField('ConnectPoolNodeConfig', 10, repeated=True)
  pscEnabled = _messages.BooleanField(11)
  region = _messages.StringField(12)
  serverCaCert = _messages.MessageField('SslCert', 13)
  serverCaMode = _messages.EnumField('ServerCaModeValueValuesEnum', 14)


class ConnectionPoolConfig(_messages.Message):
  r"""The managed connection pooling configuration.

  Fields:
    connectionPoolingEnabled: Whether managed connection pooling is enabled.
    flags: Optional. List of connection pool configuration flags.
    poolerCount: Output only. Number of connection poolers.
  """

  connectionPoolingEnabled = _messages.BooleanField(1)
  flags = _messages.MessageField('ConnectionPoolFlags', 2, repeated=True)
  poolerCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)


class ConnectionPoolFlags(_messages.Message):
  r"""Connection pool flags for Cloud SQL instances managed connection pool
  configuration.

  Fields:
    name: Required. The name of the flag.
    value: Required. The value of the flag. Boolean flags are set to `on` for
      true and `off` for false. This field must be omitted if the flag doesn't
      take a value.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DataCacheConfig(_messages.Message):
  r"""Data cache configurations.

  Fields:
    dataCacheEnabled: Whether data cache is enabled for the instance.
  """

  dataCacheEnabled = _messages.BooleanField(1)


class Database(_messages.Message):
  r"""Represents a SQL database on the Cloud SQL instance.

  Fields:
    charset: The Cloud SQL charset value.
    collation: The Cloud SQL collation value.
    etag: This field is deprecated and will be removed from a future version
      of the API.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID.
    kind: This is always `sql#database`.
    name: The name of the database in the Cloud SQL instance. This does not
      include the project ID or instance name.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable.
    selfLink: The URI of this resource.
    sqlserverDatabaseDetails: A SqlServerDatabaseDetails attribute.
  """

  charset = _messages.StringField(1)
  collation = _messages.StringField(2)
  etag = _messages.StringField(3)
  instance = _messages.StringField(4)
  kind = _messages.StringField(5)
  name = _messages.StringField(6)
  project = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  sqlserverDatabaseDetails = _messages.MessageField('SqlServerDatabaseDetails', 9)


class DatabaseFlags(_messages.Message):
  r"""Database flags for Cloud SQL instances.

  Fields:
    name: The name of the flag. These flags are passed at instance startup, so
      include both server options and system variables. Flags are specified
      with underscores, not hyphens. For more information, see [Configuring
      Database Flags](https://cloud.google.com/sql/docs/mysql/flags) in the
      Cloud SQL documentation.
    value: The value of the flag. Boolean flags are set to `on` for true and
      `off` for false. This field must be omitted if the flag doesn't take a
      value.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class DatabaseInstance(_messages.Message):
  r"""A Cloud SQL instance resource.

  Enums:
    BackendTypeValueValuesEnum: The backend type. `SECOND_GEN`: Cloud SQL
      database instance. `EXTERNAL`: A database server that is not managed by
      Google. This property is read-only; use the `tier` property in the
      `settings` object to determine the database type.
    DatabaseVersionValueValuesEnum: The database engine type and version. The
      `databaseVersion` field cannot be changed after instance creation.
    InstalledVersionValueValuesEnum: Stores the current database version
      including minor version such as `MYSQL_8_0_18`.
    InstanceTypeValueValuesEnum: The instance type.
    SqlNetworkArchitectureValueValuesEnum: The SQL network architecture for
      the instance.
    StateValueValuesEnum: The current serving state of the Cloud SQL instance.
    SuspensionReasonValueListEntryValuesEnum:

  Messages:
    FailoverReplicaValue: The name and status of the failover replica.
    TagsValue: Optional. Input only. Immutable. Tag keys and tag values that
      are bound to this instance. You must represent each item in the map as:
      `"" : ""`. For example, a single resource can have the following tags:
      ``` "123/environment": "production", "123/costCenter": "marketing", ```
      For more information on tag creation and management, see
      https://cloud.google.com/resource-manager/docs/tags/tags-overview.

  Fields:
    availableMaintenanceVersions: Output only. List all maintenance versions
      applicable on the instance
    backendType: The backend type. `SECOND_GEN`: Cloud SQL database instance.
      `EXTERNAL`: A database server that is not managed by Google. This
      property is read-only; use the `tier` property in the `settings` object
      to determine the database type.
    connectionName: Connection name of the Cloud SQL instance used in
      connection strings.
    createTime: Output only. The time when the instance was created in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    currentDiskSize: The current disk usage of the instance in bytes. This
      property has been deprecated. Use the
      "cloudsql.googleapis.com/database/disk/bytes_used" metric in Cloud
      Monitoring API instead. Please see [this
      announcement](https://groups.google.com/d/msg/google-cloud-sql-
      announce/I_7-F9EBhT0/BtvFtdFeAgAJ) for details.
    databaseInstalledVersion: Output only. Stores the current database version
      running on the instance including minor version such as `MYSQL_8_0_18`.
    databaseVersion: The database engine type and version. The
      `databaseVersion` field cannot be changed after instance creation.
    diskEncryptionConfiguration: Disk encryption configuration specific to an
      instance.
    diskEncryptionStatus: Disk encryption status specific to an instance.
    dnsName: Output only. The dns name of the instance.
    dnsNames: Output only. The list of DNS names used by this instance.
    etag: This field is deprecated and will be removed from a future version
      of the API. Use the `settings.settingsVersion` field instead.
    failoverReplica: The name and status of the failover replica.
    gceZone: The Compute Engine zone that the instance is currently serving
      from. This value could be different from the zone that was specified
      when the instance was created if the instance has failed over to its
      secondary zone. WARNING: Changing this might restart the instance.
    geminiConfig: Gemini instance configuration.
    includeReplicasForMajorVersionUpgrade: Input only. Determines whether an
      in-place major version upgrade of replicas happens when an in-place
      major version upgrade of a primary instance is initiated.
    installedVersion: Stores the current database version including minor
      version such as `MYSQL_8_0_18`.
    instanceType: The instance type.
    ipAddresses: The assigned IP addresses for the instance.
    ipv6Address: The IPv6 address assigned to the instance. (Deprecated) This
      property was applicable only to First Generation instances.
    kind: This is always `sql#instance`.
    maintenanceVersion: The current software version on the instance.
    majorVersionUpgradeIncludesReplicas: Input only. Deprecated field. Use the
      field include_replicas_for_major_version_upgrade instead.
    masterInstanceName: The name of the instance which will act as primary in
      the replication setup.
    maxDiskSize: The maximum disk size of the instance in bytes.
    name: Name of the Cloud SQL instance. This does not include the project
      ID.
    nodeCount: The number of read pool nodes in a read pool.
    nodes: Output only. Entries containing information about each read pool
      node of the read pool.
    onPremisesConfiguration: Configuration specific to on-premises instances.
    outOfDiskReport: This field represents the report generated by the
      proactive database wellness job for OutOfDisk issues. * Writers: * the
      proactive database wellness job for OOD. * Readers: * the proactive
      database wellness job
    primaryDnsName: Output only. DEPRECATED: please use write_endpoint
      instead.
    project: The project ID of the project containing the Cloud SQL instance.
      The Google apps domain is prefixed if applicable.
    pscServiceAttachmentLink: Output only. The link to service attachment of
      PSC instance.
    region: The geographical region of the Cloud SQL instance. It can be one
      of the
      [regions](https://cloud.google.com/sql/docs/mysql/locations#location-r)
      where Cloud SQL operates: For example, `asia-east1`, `europe-west1`, and
      `us-central1`. The default value is `us-central1`.
    replicaConfiguration: Configuration specific to failover replicas and read
      replicas.
    replicaNames: The replicas of the instance.
    replicationCluster: A primary instance and disaster recovery (DR) replica
      pair. A DR replica is a cross-region replica that you designate for
      failover in the event that the primary instance experiences regional
      failure. Applicable to MySQL and PostgreSQL.
    rootPassword: Initial root password. Use only on creation. You must set
      root passwords before you can connect to PostgreSQL instances.
    satisfiesPzi: Output only. This status indicates whether the instance
      satisfies PZI. The status is reserved for future use.
    satisfiesPzs: This status indicates whether the instance satisfies PZS.
      The status is reserved for future use.
    scheduledMaintenance: The start time of any upcoming scheduled maintenance
      for this instance.
    secondaryGceZone: The Compute Engine zone that the failover instance is
      currently serving from for a regional instance. This value could be
      different from the zone that was specified when the instance was created
      if the instance has failed over to its secondary/failover zone.
    selfLink: The URI of this resource.
    serverCaCert: SSL configuration.
    serviceAccountEmailAddress: The service account email address assigned to
      the instance. \This property is read-only.
    settings: The user settings.
    sourceInstanceNames: Optional. A list of names of source instances, each
      of which contains connection information, and is used to perform sync
      and replication setup.
    sqlNetworkArchitecture: The SQL network architecture for the instance.
    state: The current serving state of the Cloud SQL instance.
    suspensionReason: If the instance state is SUSPENDED, the reason for the
      suspension.
    switchTransactionLogsToCloudStorageEnabled: Input only. Whether Cloud SQL
      is enabled to switch storing point-in-time recovery log files from a
      data disk to Cloud Storage.
    tags: Optional. Input only. Immutable. Tag keys and tag values that are
      bound to this instance. You must represent each item in the map as: `""
      : ""`. For example, a single resource can have the following tags: ```
      "123/environment": "production", "123/costCenter": "marketing", ``` For
      more information on tag creation and management, see
      https://cloud.google.com/resource-manager/docs/tags/tags-overview.
    upgradableDatabaseVersions: Output only. All database versions that are
      available for upgrade.
    writeEndpoint: Output only. The dns name of the primary instance in a
      replication group.
  """

  class BackendTypeValueValuesEnum(_messages.Enum):
    r"""The backend type. `SECOND_GEN`: Cloud SQL database instance.
    `EXTERNAL`: A database server that is not managed by Google. This property
    is read-only; use the `tier` property in the `settings` object to
    determine the database type.

    Values:
      SQL_BACKEND_TYPE_UNSPECIFIED: This is an unknown backend type for
        instance.
      FIRST_GEN: V1 speckle instance.
      SECOND_GEN: V2 speckle instance.
      EXTERNAL: On premises instance.
    """
    SQL_BACKEND_TYPE_UNSPECIFIED = 0
    FIRST_GEN = 1
    SECOND_GEN = 2
    EXTERNAL = 3

  class DatabaseVersionValueValuesEnum(_messages.Enum):
    r"""The database engine type and version. The `databaseVersion` field
    cannot be changed after instance creation.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class InstalledVersionValueValuesEnum(_messages.Enum):
    r"""Stores the current database version including minor version such as
    `MYSQL_8_0_18`.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class InstanceTypeValueValuesEnum(_messages.Enum):
    r"""The instance type.

    Values:
      SQL_INSTANCE_TYPE_UNSPECIFIED: This is an unknown Cloud SQL instance
        type.
      CLOUD_SQL_INSTANCE: A regular Cloud SQL instance that is not replicating
        from a primary instance.
      ON_PREMISES_INSTANCE: An instance running on the customer's premises
        that is not managed by Cloud SQL.
      READ_REPLICA_INSTANCE: A Cloud SQL instance acting as a read-replica.
      READ_POOL_INSTANCE: A Cloud SQL read pool.
      CLOUD_SQL_HA_CLUSTER: A Cloud SQL HA cluster.
    """
    SQL_INSTANCE_TYPE_UNSPECIFIED = 0
    CLOUD_SQL_INSTANCE = 1
    ON_PREMISES_INSTANCE = 2
    READ_REPLICA_INSTANCE = 3
    READ_POOL_INSTANCE = 4
    CLOUD_SQL_HA_CLUSTER = 5

  class SqlNetworkArchitectureValueValuesEnum(_messages.Enum):
    r"""The SQL network architecture for the instance.

    Values:
      SQL_NETWORK_ARCHITECTURE_UNSPECIFIED: <no description>
      NEW_NETWORK_ARCHITECTURE: The instance uses the new network
        architecture.
      OLD_NETWORK_ARCHITECTURE: The instance uses the old network
        architecture.
    """
    SQL_NETWORK_ARCHITECTURE_UNSPECIFIED = 0
    NEW_NETWORK_ARCHITECTURE = 1
    OLD_NETWORK_ARCHITECTURE = 2

  class StateValueValuesEnum(_messages.Enum):
    r"""The current serving state of the Cloud SQL instance.

    Values:
      SQL_INSTANCE_STATE_UNSPECIFIED: The state of the instance is unknown.
      RUNNABLE: The instance is running, or has been stopped by owner.
      SUSPENDED: The instance is not available, for example due to problems
        with billing.
      PENDING_DELETE: The instance is being deleted.
      PENDING_CREATE: The instance is being created.
      MAINTENANCE: The instance is down for maintenance.
      FAILED: The creation of the instance failed or a fatal error occurred
        during maintenance.
      ONLINE_MAINTENANCE: Deprecated
      REPAIRING: (Applicable to read pool nodes only.) The read pool node
        needs to be repaired. The database might be unavailable.
    """
    SQL_INSTANCE_STATE_UNSPECIFIED = 0
    RUNNABLE = 1
    SUSPENDED = 2
    PENDING_DELETE = 3
    PENDING_CREATE = 4
    MAINTENANCE = 5
    FAILED = 6
    ONLINE_MAINTENANCE = 7
    REPAIRING = 8

  class SuspensionReasonValueListEntryValuesEnum(_messages.Enum):
    r"""SuspensionReasonValueListEntryValuesEnum enum type.

    Values:
      SQL_SUSPENSION_REASON_UNSPECIFIED: This is an unknown suspension reason.
      BILLING_ISSUE: The instance is suspended due to billing issues (for
        example:, account issue)
      LEGAL_ISSUE: The instance is suspended due to illegal content (for
        example:, child pornography, copyrighted material, etc.).
      OPERATIONAL_ISSUE: The instance is causing operational issues (for
        example:, causing the database to crash).
      KMS_KEY_ISSUE: The KMS key used by the instance is either revoked or
        denied access to
      CLOUD_SQL_FREE_TRIAL_EXPIRED: The Cloud SQL free trial for the instance
        has expired.
    """
    SQL_SUSPENSION_REASON_UNSPECIFIED = 0
    BILLING_ISSUE = 1
    LEGAL_ISSUE = 2
    OPERATIONAL_ISSUE = 3
    KMS_KEY_ISSUE = 4
    CLOUD_SQL_FREE_TRIAL_EXPIRED = 5

  class FailoverReplicaValue(_messages.Message):
    r"""The name and status of the failover replica.

    Fields:
      available: The availability status of the failover replica. A false
        status indicates that the failover replica is out of sync. The primary
        instance can only failover to the failover replica when the status is
        true.
      name: The name of the failover replica. If specified at instance
        creation, a failover replica is created for the instance. The name
        doesn't include the project ID.
    """

    available = _messages.BooleanField(1)
    name = _messages.StringField(2)

  @encoding.MapUnrecognizedFields('additionalProperties')
  class TagsValue(_messages.Message):
    r"""Optional. Input only. Immutable. Tag keys and tag values that are
    bound to this instance. You must represent each item in the map as: `"" :
    ""`. For example, a single resource can have the following tags: ```
    "123/environment": "production", "123/costCenter": "marketing", ``` For
    more information on tag creation and management, see
    https://cloud.google.com/resource-manager/docs/tags/tags-overview.

    Messages:
      AdditionalProperty: An additional property for a TagsValue object.

    Fields:
      additionalProperties: Additional properties of type TagsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a TagsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  availableMaintenanceVersions = _messages.StringField(1, repeated=True)
  backendType = _messages.EnumField('BackendTypeValueValuesEnum', 2)
  connectionName = _messages.StringField(3)
  createTime = _messages.StringField(4)
  currentDiskSize = _messages.IntegerField(5)
  databaseInstalledVersion = _messages.StringField(6)
  databaseVersion = _messages.EnumField('DatabaseVersionValueValuesEnum', 7)
  diskEncryptionConfiguration = _messages.MessageField('DiskEncryptionConfiguration', 8)
  diskEncryptionStatus = _messages.MessageField('DiskEncryptionStatus', 9)
  dnsName = _messages.StringField(10)
  dnsNames = _messages.MessageField('DnsNameMapping', 11, repeated=True)
  etag = _messages.StringField(12)
  failoverReplica = _messages.MessageField('FailoverReplicaValue', 13)
  gceZone = _messages.StringField(14)
  geminiConfig = _messages.MessageField('GeminiInstanceConfig', 15)
  includeReplicasForMajorVersionUpgrade = _messages.BooleanField(16)
  installedVersion = _messages.EnumField('InstalledVersionValueValuesEnum', 17)
  instanceType = _messages.EnumField('InstanceTypeValueValuesEnum', 18)
  ipAddresses = _messages.MessageField('IpMapping', 19, repeated=True)
  ipv6Address = _messages.StringField(20)
  kind = _messages.StringField(21)
  maintenanceVersion = _messages.StringField(22)
  majorVersionUpgradeIncludesReplicas = _messages.BooleanField(23)
  masterInstanceName = _messages.StringField(24)
  maxDiskSize = _messages.IntegerField(25)
  name = _messages.StringField(26)
  nodeCount = _messages.IntegerField(27, variant=_messages.Variant.INT32)
  nodes = _messages.MessageField('PoolNodeConfig', 28, repeated=True)
  onPremisesConfiguration = _messages.MessageField('OnPremisesConfiguration', 29)
  outOfDiskReport = _messages.MessageField('SqlOutOfDiskReport', 30)
  primaryDnsName = _messages.StringField(31)
  project = _messages.StringField(32)
  pscServiceAttachmentLink = _messages.StringField(33)
  region = _messages.StringField(34)
  replicaConfiguration = _messages.MessageField('ReplicaConfiguration', 35)
  replicaNames = _messages.StringField(36, repeated=True)
  replicationCluster = _messages.MessageField('ReplicationCluster', 37)
  rootPassword = _messages.StringField(38)
  satisfiesPzi = _messages.BooleanField(39)
  satisfiesPzs = _messages.BooleanField(40)
  scheduledMaintenance = _messages.MessageField('SqlScheduledMaintenance', 41)
  secondaryGceZone = _messages.StringField(42)
  selfLink = _messages.StringField(43)
  serverCaCert = _messages.MessageField('SslCert', 44)
  serviceAccountEmailAddress = _messages.StringField(45)
  settings = _messages.MessageField('Settings', 46)
  sourceInstanceNames = _messages.StringField(47, repeated=True)
  sqlNetworkArchitecture = _messages.EnumField('SqlNetworkArchitectureValueValuesEnum', 48)
  state = _messages.EnumField('StateValueValuesEnum', 49)
  suspensionReason = _messages.EnumField('SuspensionReasonValueListEntryValuesEnum', 50, repeated=True)
  switchTransactionLogsToCloudStorageEnabled = _messages.BooleanField(51)
  tags = _messages.MessageField('TagsValue', 52)
  upgradableDatabaseVersions = _messages.MessageField('AvailableDatabaseVersion', 53, repeated=True)
  writeEndpoint = _messages.StringField(54)


class DatabasesListResponse(_messages.Message):
  r"""Database list response.

  Fields:
    items: List of database resources in the instance.
    kind: This is always `sql#databasesList`.
  """

  items = _messages.MessageField('Database', 1, repeated=True)
  kind = _messages.StringField(2)


class DbAlignedAtomicWritesConfig(_messages.Message):
  r"""Database engine aligned atomic writes configuration.

  Fields:
    dbAlignedAtomicWrites: Optional. When this parameter is set to true,
      CloudSQL will enable large block atomic writes with respect to the
      respective database engine.
  """

  dbAlignedAtomicWrites = _messages.BooleanField(1)


class DemoteContext(_messages.Message):
  r"""This context is used to demote an existing standalone instance to be a
  Cloud SQL read replica for an external database server.

  Fields:
    kind: This is always `sql#demoteContext`.
    sourceRepresentativeInstanceName: Required. The name of the instance which
      acts as an on-premises primary instance in the replication setup.
  """

  kind = _messages.StringField(1)
  sourceRepresentativeInstanceName = _messages.StringField(2)


class DemoteMasterConfiguration(_messages.Message):
  r"""Read-replica configuration for connecting to the on-premises primary
  instance.

  Fields:
    kind: This is always `sql#demoteMasterConfiguration`.
    mysqlReplicaConfiguration: MySQL specific configuration when replicating
      from a MySQL on-premises primary instance. Replication configuration
      information such as the username, password, certificates, and keys are
      not stored in the instance metadata. The configuration information is
      used only to set up the replication connection and is stored by MySQL in
      a file named `master.info` in the data directory.
  """

  kind = _messages.StringField(1)
  mysqlReplicaConfiguration = _messages.MessageField('DemoteMasterMySqlReplicaConfiguration', 2)


class DemoteMasterContext(_messages.Message):
  r"""Database instance demote primary instance context.

  Fields:
    kind: This is always `sql#demoteMasterContext`.
    masterInstanceName: The name of the instance which will act as on-premises
      primary instance in the replication setup.
    replicaConfiguration: Configuration specific to read-replicas replicating
      from the on-premises primary instance.
    skipReplicationSetup: Flag to skip replication setup on the instance.
    verifyGtidConsistency: Verify the GTID consistency for demote operation.
      Default value: `True`. Setting this flag to `false` enables you to
      bypass the GTID consistency check between on-premises primary instance
      and Cloud SQL instance during the demotion operation but also exposes
      you to the risk of future replication failures. Change the value only if
      you know the reason for the GTID divergence and are confident that doing
      so will not cause any replication issues.
  """

  kind = _messages.StringField(1)
  masterInstanceName = _messages.StringField(2)
  replicaConfiguration = _messages.MessageField('DemoteMasterConfiguration', 3)
  skipReplicationSetup = _messages.BooleanField(4)
  verifyGtidConsistency = _messages.BooleanField(5)


class DemoteMasterMySqlReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration specific to MySQL databases.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the replica's x509 certificate.
    clientKey: PEM representation of the replica's private key. The
      corresponding public key is encoded in the client's certificate. The
      format of the replica's private key can be either PKCS #1 or PKCS #8.
    kind: This is always `sql#demoteMasterMysqlReplicaConfiguration`.
    password: The password for the replication connection.
    username: The username for the replication connection.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  kind = _messages.StringField(4)
  password = _messages.StringField(5)
  username = _messages.StringField(6)


class DenyMaintenancePeriod(_messages.Message):
  r"""Deny Maintenance Periods. This specifies a date range during when all
  CSA rollout will be denied.

  Fields:
    endDate: "deny maintenance period" end date. If the year of the end date
      is empty, the year of the start date also must be empty. In this case,
      it means the deny maintenance period recurs every year. The date is in
      format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
    startDate: "deny maintenance period" start date. If the year of the start
      date is empty, the year of the end date also must be empty. In this
      case, it means the deny maintenance period recurs every year. The date
      is in format yyyy-mm-dd i.e., 2020-11-01, or mm-dd, i.e., 11-01
    time: Time in UTC when the "deny maintenance period" starts on start_date
      and ends on end_date. The time is in format: HH:mm:SS, i.e., 00:00:00
  """

  endDate = _messages.StringField(1)
  startDate = _messages.StringField(2)
  time = _messages.StringField(3)


class DiskEncryptionConfiguration(_messages.Message):
  r"""Disk encryption configuration for an instance.

  Fields:
    kind: This is always `sql#diskEncryptionConfiguration`.
    kmsKeyName: Resource name of KMS key for disk encryption
  """

  kind = _messages.StringField(1)
  kmsKeyName = _messages.StringField(2)


class DiskEncryptionStatus(_messages.Message):
  r"""Disk encryption status for an instance.

  Fields:
    kind: This is always `sql#diskEncryptionStatus`.
    kmsKeyVersionName: KMS key version used to encrypt the Cloud SQL instance
      resource
  """

  kind = _messages.StringField(1)
  kmsKeyVersionName = _messages.StringField(2)


class DnsNameMapping(_messages.Message):
  r"""DNS metadata.

  Enums:
    ConnectionTypeValueValuesEnum: Output only. The connection type of the DNS
      name.
    DnsScopeValueValuesEnum: Output only. The scope that the DNS name applies
      to.

  Fields:
    connectionType: Output only. The connection type of the DNS name.
    dnsScope: Output only. The scope that the DNS name applies to.
    name: The DNS name.
  """

  class ConnectionTypeValueValuesEnum(_messages.Enum):
    r"""Output only. The connection type of the DNS name.

    Values:
      CONNECTION_TYPE_UNSPECIFIED: Unknown connection type.
      PUBLIC: Public IP.
      PRIVATE_SERVICES_ACCESS: Private services access (private IP).
      PRIVATE_SERVICE_CONNECT: Private Service Connect.
    """
    CONNECTION_TYPE_UNSPECIFIED = 0
    PUBLIC = 1
    PRIVATE_SERVICES_ACCESS = 2
    PRIVATE_SERVICE_CONNECT = 3

  class DnsScopeValueValuesEnum(_messages.Enum):
    r"""Output only. The scope that the DNS name applies to.

    Values:
      DNS_SCOPE_UNSPECIFIED: Unknown DNS scope.
      INSTANCE: Indicates a instance-level DNS name.
    """
    DNS_SCOPE_UNSPECIFIED = 0
    INSTANCE = 1

  connectionType = _messages.EnumField('ConnectionTypeValueValuesEnum', 1)
  dnsScope = _messages.EnumField('DnsScopeValueValuesEnum', 2)
  name = _messages.StringField(3)


class Empty(_messages.Message):
  r"""A generic empty message that you can re-use to avoid defining duplicated
  empty messages in your APIs. A typical example is to use it as the request
  or the response type of an API method. For instance: service Foo { rpc
  Bar(google.protobuf.Empty) returns (google.protobuf.Empty); }
  """



class ExecuteSqlPayload(_messages.Message):
  r"""The request payload used to execute SQL statements.

  Enums:
    OutputFormatValueValuesEnum: Optional. Deprecated field. The requested
      format of the SQL response.
    PartialResultModeValueValuesEnum: Optional. Controls how the API should
      respond when the SQL execution result is incomplete due to the size
      limit or another error. The default mode is to throw an error.

  Fields:
    accessToken: Optional. Deprecated field. The access token required for IAM
      user authentication.
    autoIamAuthn: Optional. When set to true, the API caller identity
      associated with the request is used for database authentication. The API
      caller must be an IAM user in the database.
    database: Optional. Name of the database on which the statement will be
      executed.
    outputFormat: Optional. Deprecated field. The requested format of the SQL
      response.
    partialResultMode: Optional. Controls how the API should respond when the
      SQL execution result is incomplete due to the size limit or another
      error. The default mode is to throw an error.
    password: Optional. The database user's password.
    rowLimit: Optional. The maximum number of rows returned per SQL statement.
    secretPath: Optional. The resource ID of a secret in secret manager which
      contains the database user's password. Expected format -
      projects/{project}/secrets/{secret}/versions/{version}.
    sqlStatement: Required. SQL statements to run on the database. It can be a
      single statement or a sequence of statements separated by semicolons.
    user: Optional. The name of an existing database user to connect to the
      database. When `auto_iam_authn` is set to true, this field is ignored
      and the API caller's IAM user is used.
  """

  class OutputFormatValueValuesEnum(_messages.Enum):
    r"""Optional. Deprecated field. The requested format of the SQL response.

    Values:
      OUTPUT_FORMAT_UNSPECIFIED: Output format is not specified. This is the
        default value.
      JSON: Output format would be in JSON format.
    """
    OUTPUT_FORMAT_UNSPECIFIED = 0
    JSON = 1

  class PartialResultModeValueValuesEnum(_messages.Enum):
    r"""Optional. Controls how the API should respond when the SQL execution
    result is incomplete due to the size limit or another error. The default
    mode is to throw an error.

    Values:
      PARTIAL_RESULT_MODE_UNSPECIFIED: Unspecified mode, effectively the same
        as `FAIL_PARTIAL_RESULT`.
      FAIL_PARTIAL_RESULT: Throw an error if the result exceeds 10 MB or if a
        partial result can be retrieved. Don't return the result.
      ALLOW_PARTIAL_RESULT: Return a truncated result and set `partial_result`
        to true if the result exceeds 10 MB or if only a partial result can be
        retrieved due to error. Don't throw an error.
    """
    PARTIAL_RESULT_MODE_UNSPECIFIED = 0
    FAIL_PARTIAL_RESULT = 1
    ALLOW_PARTIAL_RESULT = 2

  accessToken = _messages.StringField(1)
  autoIamAuthn = _messages.BooleanField(2)
  database = _messages.StringField(3)
  outputFormat = _messages.EnumField('OutputFormatValueValuesEnum', 4)
  partialResultMode = _messages.EnumField('PartialResultModeValueValuesEnum', 5)
  password = _messages.StringField(6)
  rowLimit = _messages.IntegerField(7)
  secretPath = _messages.StringField(8)
  sqlStatement = _messages.StringField(9)
  user = _messages.StringField(10)


class ExportContext(_messages.Message):
  r"""Database instance export context.

  Enums:
    FileTypeValueValuesEnum: The file type for the specified uri.

  Messages:
    BakExportOptionsValue: Options for exporting BAK files (SQL Server-only)
    CsvExportOptionsValue: Options for exporting data as CSV. `MySQL` and
      `PostgreSQL` instances only.
    ServerlessExportOptionsValue: Optional. Options for serverless exports.
      Only applicable when 'offload' is set.
    SqlExportOptionsValue: Options for exporting data as SQL statements.
    TdeExportOptionsValue: Optional. Export parameters specific to SQL Server
      TDE certificates

  Fields:
    bakExportOptions: Options for exporting BAK files (SQL Server-only)
    csvExportOptions: Options for exporting data as CSV. `MySQL` and
      `PostgreSQL` instances only.
    databases: Databases to be exported. `MySQL instances:` If `fileType` is
      `SQL` and no database is specified, all databases are exported, except
      for the `mysql` system database. If `fileType` is `CSV`, you can specify
      one database, either by using this property or by using the
      `csvExportOptions.selectQuery` property, which takes precedence over
      this property. `PostgreSQL instances:` If you don't specify a database
      by name, all user databases in the instance are exported. This excludes
      system databases and Cloud SQL databases used to manage internal
      operations. Exporting all user databases is only available for
      directory-formatted parallel export. If `fileType` is `CSV`, this
      database must match the one specified in the
      `csvExportOptions.selectQuery` property. `SQL Server instances:` You
      must specify one database to be exported, and the `fileType` must be
      `BAK`.
    fileType: The file type for the specified uri.
    kind: This is always `sql#exportContext`.
    offload: Whether to perform a serverless export.
    serverlessExportOptions: Optional. Options for serverless exports. Only
      applicable when 'offload' is set.
    sqlExportOptions: Options for exporting data as SQL statements.
    tdeExportOptions: Optional. Export parameters specific to SQL Server TDE
      certificates
    uri: The path to the file in Google Cloud Storage where the export will be
      stored. The URI is in the form `gs://bucketName/fileName`. If the file
      already exists, the request succeeds, but the operation fails. If
      `fileType` is `SQL` and the filename ends with .gz, the contents are
      compressed.
  """

  class FileTypeValueValuesEnum(_messages.Enum):
    r"""The file type for the specified uri.

    Values:
      SQL_FILE_TYPE_UNSPECIFIED: Unknown file type.
      SQL: File containing SQL statements.
      CSV: File in CSV format.
      BAK: <no description>
      TDE: TDE certificate.
    """
    SQL_FILE_TYPE_UNSPECIFIED = 0
    SQL = 1
    CSV = 2
    BAK = 3
    TDE = 4

  class BakExportOptionsValue(_messages.Message):
    r"""Options for exporting BAK files (SQL Server-only)

    Enums:
      BakTypeValueValuesEnum: Type of this bak file will be export, FULL or
        DIFF, SQL Server only

    Fields:
      bakType: Type of this bak file will be export, FULL or DIFF, SQL Server
        only
      copyOnly: Deprecated: copy_only is deprecated. Use differential_base
        instead
      differentialBase: Whether or not the backup can be used as a
        differential base copy_only backup can not be served as differential
        base
      exportLogEndTime: Optional. The end timestamp when transaction log will
        be included in the export operation. [RFC
        3339](https://tools.ietf.org/html/rfc3339) format (for example,
        `2023-10-01T16:19:00.094`) in UTC. When omitted, all available logs
        until current time will be included. Only applied to Cloud SQL for SQL
        Server.
      exportLogStartTime: Optional. The begin timestamp when transaction log
        will be included in the export operation. [RFC
        3339](https://tools.ietf.org/html/rfc3339) format (for example,
        `2023-10-01T16:19:00.094`) in UTC. When omitted, all available logs
        from the beginning of retention period will be included. Only applied
        to Cloud SQL for SQL Server.
      stripeCount: Option for specifying how many stripes to use for the
        export. If blank, and the value of the striped field is true, the
        number of stripes is automatically chosen.
      striped: Whether or not the export should be striped.
    """

    class BakTypeValueValuesEnum(_messages.Enum):
      r"""Type of this bak file will be export, FULL or DIFF, SQL Server only

      Values:
        BAK_TYPE_UNSPECIFIED: Default type.
        FULL: Full backup.
        DIFF: Differential backup.
        TLOG: SQL Server Transaction Log
      """
      BAK_TYPE_UNSPECIFIED = 0
      FULL = 1
      DIFF = 2
      TLOG = 3

    bakType = _messages.EnumField('BakTypeValueValuesEnum', 1)
    copyOnly = _messages.BooleanField(2)
    differentialBase = _messages.BooleanField(3)
    exportLogEndTime = _messages.StringField(4)
    exportLogStartTime = _messages.StringField(5)
    stripeCount = _messages.IntegerField(6, variant=_messages.Variant.INT32)
    striped = _messages.BooleanField(7)

  class CsvExportOptionsValue(_messages.Message):
    r"""Options for exporting data as CSV. `MySQL` and `PostgreSQL` instances
    only.

    Fields:
      escapeCharacter: Specifies the character that should appear before a
        data character that needs to be escaped.
      fieldsTerminatedBy: Specifies the character that separates columns
        within each row (line) of the file.
      linesTerminatedBy: This is used to separate lines. If a line does not
        contain all fields, the rest of the columns are set to their default
        values.
      quoteCharacter: Specifies the quoting character to be used when a data
        value is quoted.
      selectQuery: The select query used to extract the data.
    """

    escapeCharacter = _messages.StringField(1)
    fieldsTerminatedBy = _messages.StringField(2)
    linesTerminatedBy = _messages.StringField(3)
    quoteCharacter = _messages.StringField(4)
    selectQuery = _messages.StringField(5)

  class ServerlessExportOptionsValue(_messages.Message):
    r"""Optional. Options for serverless exports. Only applicable when
    'offload' is set.

    Fields:
      dataDiskSizeGb: Optional. The disk size to create the offload instance
        with.
      databaseFlags: Optional. Database flags to set specifically on the
        offload instance.
      tier: Optional. The tier to create the offload instance with.
    """

    dataDiskSizeGb = _messages.IntegerField(1)
    databaseFlags = _messages.MessageField('DatabaseFlags', 2, repeated=True)
    tier = _messages.StringField(3)

  class SqlExportOptionsValue(_messages.Message):
    r"""Options for exporting data as SQL statements.

    Messages:
      MysqlExportOptionsValue: Options for exporting from MySQL.
      PostgresExportOptionsValue: Options for exporting from a Cloud SQL for
        PostgreSQL instance.

    Fields:
      mysqlExportOptions: Options for exporting from MySQL.
      parallel: Optional. Whether or not the export should be parallel.
      postgresExportOptions: Options for exporting from a Cloud SQL for
        PostgreSQL instance.
      schemaOnly: Export only schemas.
      tables: Tables to export, or that were exported, from the specified
        database. If you specify tables, specify one and only one database.
        For PostgreSQL instances, you can specify only one table.
      threads: Optional. The number of threads to use for parallel export.
    """

    class MysqlExportOptionsValue(_messages.Message):
      r"""Options for exporting from MySQL.

      Fields:
        masterData: Option to include SQL statement required to set up
          replication. If set to `1`, the dump file includes a CHANGE MASTER
          TO statement with the binary log coordinates, and --set-gtid-purged
          is set to ON. If set to `2`, the CHANGE MASTER TO statement is
          written as a SQL comment and has no effect. If set to any value
          other than `1`, --set-gtid-purged is set to OFF.
      """

      masterData = _messages.IntegerField(1, variant=_messages.Variant.INT32)

    class PostgresExportOptionsValue(_messages.Message):
      r"""Options for exporting from a Cloud SQL for PostgreSQL instance.

      Fields:
        clean: Optional. Use this option to include DROP <object> SQL
          statements. Use these statements to delete database objects before
          running the import operation.
        ifExists: Optional. Option to include an IF EXISTS SQL statement with
          each DROP statement produced by clean.
      """

      clean = _messages.BooleanField(1)
      ifExists = _messages.BooleanField(2)

    mysqlExportOptions = _messages.MessageField('MysqlExportOptionsValue', 1)
    parallel = _messages.BooleanField(2)
    postgresExportOptions = _messages.MessageField('PostgresExportOptionsValue', 3)
    schemaOnly = _messages.BooleanField(4)
    tables = _messages.StringField(5, repeated=True)
    threads = _messages.IntegerField(6, variant=_messages.Variant.INT32)

  class TdeExportOptionsValue(_messages.Message):
    r"""Optional. Export parameters specific to SQL Server TDE certificates

    Fields:
      certificatePath: Required. Path to the TDE certificate public key in the
        form gs://bucketName/fileName. The instance must have write access to
        the location. Applicable only for SQL Server instances.
      name: Required. Certificate name. Applicable only for SQL Server
        instances.
      privateKeyPassword: Required. Password that encrypts the private key.
      privateKeyPath: Required. Path to the TDE certificate private key in the
        form gs://bucketName/fileName. The instance must have write access to
        the location. Applicable only for SQL Server instances.
    """

    certificatePath = _messages.StringField(1)
    name = _messages.StringField(2)
    privateKeyPassword = _messages.StringField(3)
    privateKeyPath = _messages.StringField(4)

  bakExportOptions = _messages.MessageField('BakExportOptionsValue', 1)
  csvExportOptions = _messages.MessageField('CsvExportOptionsValue', 2)
  databases = _messages.StringField(3, repeated=True)
  fileType = _messages.EnumField('FileTypeValueValuesEnum', 4)
  kind = _messages.StringField(5)
  offload = _messages.BooleanField(6)
  serverlessExportOptions = _messages.MessageField('ServerlessExportOptionsValue', 7)
  sqlExportOptions = _messages.MessageField('SqlExportOptionsValue', 8)
  tdeExportOptions = _messages.MessageField('TdeExportOptionsValue', 9)
  uri = _messages.StringField(10)


class ExternalSyncSelectedObject(_messages.Message):
  r"""The selected object that Cloud SQL migrates.

  Fields:
    database: The name of the database that Cloud SQL migrates.
  """

  database = _messages.StringField(1)


class FailoverContext(_messages.Message):
  r"""Database instance failover context.

  Fields:
    kind: This is always `sql#failoverContext`.
    settingsVersion: The current settings version of this instance. Request
      will be rejected if this version doesn't match the current settings
      version.
  """

  kind = _messages.StringField(1)
  settingsVersion = _messages.IntegerField(2)


class FinalBackupConfig(_messages.Message):
  r"""Config used to determine the final backup settings for the instance.

  Fields:
    enabled: Whether the final backup is enabled for the instance.
    retentionDays: The number of days to retain the final backup after the
      instance deletion. The final backup will be purged at
      (time_of_instance_deletion + retention_days).
  """

  enabled = _messages.BooleanField(1)
  retentionDays = _messages.IntegerField(2, variant=_messages.Variant.INT32)


class Flag(_messages.Message):
  r"""A flag resource.

  Enums:
    AppliesToValueListEntryValuesEnum:
    FlagScopeValueValuesEnum: Scope of flag.
    TypeValueValuesEnum: The type of the flag. Flags are typed to being
      `BOOLEAN`, `STRING`, `INTEGER` or `NONE`. `NONE` is used for flags which
      do not take a value, such as `skip_grant_tables`.

  Fields:
    allowedIntValues: Use this field if only certain integers are accepted.
      Can be combined with min_value and max_value to add additional values.
    allowedStringValues: For `STRING` flags, a list of strings that the value
      can be set to.
    appliesTo: The database version this flag applies to. Can be MySQL
      instances: `MYSQL_8_0`, `MYSQL_8_0_18`, `MYSQL_8_0_26`, `MYSQL_5_7`, or
      `MYSQL_5_6`. PostgreSQL instances: `POSTGRES_9_6`, `POSTGRES_10`,
      `POSTGRES_11` or `POSTGRES_12`. SQL Server instances:
      `SQLSERVER_2017_STANDARD`, `SQLSERVER_2017_ENTERPRISE`,
      `SQLSERVER_2017_EXPRESS`, `SQLSERVER_2017_WEB`,
      `SQLSERVER_2019_STANDARD`, `SQLSERVER_2019_ENTERPRISE`,
      `SQLSERVER_2019_EXPRESS`, or `SQLSERVER_2019_WEB`. See [the complete
      list](/sql/docs/mysql/admin-api/rest/v1/SqlDatabaseVersion).
    flagScope: Scope of flag.
    inBeta: Whether or not the flag is considered in beta.
    kind: This is always `sql#flag`.
    maxValue: For `INTEGER` flags, the maximum allowed value.
    minValue: For `INTEGER` flags, the minimum allowed value.
    name: This is the name of the flag. Flag names always use underscores, not
      hyphens, for example: `max_allowed_packet`
    recommendedIntValue: Recommended flag value in integer format for UI
      display.
    recommendedStringValue: Recommended flag value in string format for UI
      display.
    requiresRestart: Indicates whether changing this flag will trigger a
      database restart. Only applicable to Second Generation instances.
    type: The type of the flag. Flags are typed to being `BOOLEAN`, `STRING`,
      `INTEGER` or `NONE`. `NONE` is used for flags which do not take a value,
      such as `skip_grant_tables`.
  """

  class AppliesToValueListEntryValuesEnum(_messages.Enum):
    r"""AppliesToValueListEntryValuesEnum enum type.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  class FlagScopeValueValuesEnum(_messages.Enum):
    r"""Scope of flag.

    Values:
      SQL_FLAG_SCOPE_UNSPECIFIED: Assume database flags if unspecified
      SQL_FLAG_SCOPE_DATABASE: database flags
      SQL_FLAG_SCOPE_CONNECTION_POOL: connection pool configuration flags
    """
    SQL_FLAG_SCOPE_UNSPECIFIED = 0
    SQL_FLAG_SCOPE_DATABASE = 1
    SQL_FLAG_SCOPE_CONNECTION_POOL = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of the flag. Flags are typed to being `BOOLEAN`, `STRING`,
    `INTEGER` or `NONE`. `NONE` is used for flags which do not take a value,
    such as `skip_grant_tables`.

    Values:
      SQL_FLAG_TYPE_UNSPECIFIED: This is an unknown flag type.
      BOOLEAN: Boolean type flag.
      STRING: String type flag.
      INTEGER: Integer type flag.
      NONE: Flag type used for a server startup option.
      MYSQL_TIMEZONE_OFFSET: Type introduced specially for MySQL TimeZone
        offset. Accept a string value with the format [-12:59, 13:00].
      FLOAT: Float type flag.
      REPEATED_STRING: Comma-separated list of the strings in a SqlFlagType
        enum.
    """
    SQL_FLAG_TYPE_UNSPECIFIED = 0
    BOOLEAN = 1
    STRING = 2
    INTEGER = 3
    NONE = 4
    MYSQL_TIMEZONE_OFFSET = 5
    FLOAT = 6
    REPEATED_STRING = 7

  allowedIntValues = _messages.IntegerField(1, repeated=True)
  allowedStringValues = _messages.StringField(2, repeated=True)
  appliesTo = _messages.EnumField('AppliesToValueListEntryValuesEnum', 3, repeated=True)
  flagScope = _messages.EnumField('FlagScopeValueValuesEnum', 4)
  inBeta = _messages.BooleanField(5)
  kind = _messages.StringField(6)
  maxValue = _messages.IntegerField(7)
  minValue = _messages.IntegerField(8)
  name = _messages.StringField(9)
  recommendedIntValue = _messages.IntegerField(10)
  recommendedStringValue = _messages.StringField(11)
  requiresRestart = _messages.BooleanField(12)
  type = _messages.EnumField('TypeValueValuesEnum', 13)


class FlagsListResponse(_messages.Message):
  r"""Flags list response.

  Fields:
    items: List of flags.
    kind: This is always `sql#flagsList`.
  """

  items = _messages.MessageField('Flag', 1, repeated=True)
  kind = _messages.StringField(2)


class GeminiInstanceConfig(_messages.Message):
  r"""Gemini instance configuration.

  Fields:
    activeQueryEnabled: Output only. Whether the active query is enabled.
    entitled: Output only. Whether Gemini is enabled.
    flagRecommenderEnabled: Output only. Whether the flag recommender is
      enabled.
    googleVacuumMgmtEnabled: Output only. Whether the vacuum management is
      enabled.
    indexAdvisorEnabled: Output only. Whether the index advisor is enabled.
    oomSessionCancelEnabled: Output only. Whether canceling the out-of-memory
      (OOM) session is enabled.
  """

  activeQueryEnabled = _messages.BooleanField(1)
  entitled = _messages.BooleanField(2)
  flagRecommenderEnabled = _messages.BooleanField(3)
  googleVacuumMgmtEnabled = _messages.BooleanField(4)
  indexAdvisorEnabled = _messages.BooleanField(5)
  oomSessionCancelEnabled = _messages.BooleanField(6)


class GenerateEphemeralCertRequest(_messages.Message):
  r"""Ephemeral certificate creation request.

  Fields:
    access_token: Optional. Access token to include in the signed certificate.
    public_key: PEM encoded public key to include in the signed certificate.
    readTime: Optional. Optional snapshot read timestamp to trade freshness
      for performance.
    validDuration: Optional. If set, it will contain the cert valid duration.
  """

  access_token = _messages.StringField(1)
  public_key = _messages.StringField(2)
  readTime = _messages.StringField(3)
  validDuration = _messages.StringField(4)


class GenerateEphemeralCertResponse(_messages.Message):
  r"""Ephemeral certificate creation request.

  Fields:
    ephemeralCert: Generated cert
  """

  ephemeralCert = _messages.MessageField('SslCert', 1)


class ImportContext(_messages.Message):
  r"""Database instance import context.

  Enums:
    FileTypeValueValuesEnum: The file type for the specified uri. * `SQL`: The
      file contains SQL statements. * `CSV`: The file contains CSV data. *
      `BAK`: The file contains backup data for a SQL Server instance.

  Messages:
    BakImportOptionsValue: Import parameters specific to SQL Server .BAK files
    CsvImportOptionsValue: Options for importing data as CSV.
    SqlImportOptionsValue: Optional. Options for importing data from SQL
      statements.
    TdeImportOptionsValue: Optional. Import parameters specific to SQL Server
      .TDE files Import parameters specific to SQL Server TDE certificates

  Fields:
    bakImportOptions: Import parameters specific to SQL Server .BAK files
    csvImportOptions: Options for importing data as CSV.
    database: The target database for the import. If `fileType` is `SQL`, this
      field is required only if the import file does not specify a database,
      and is overridden by any database specification in the import file. For
      entire instance parallel import operations, the database is overridden
      by the database name stored in subdirectory name. If `fileType` is
      `CSV`, one database must be specified.
    fileType: The file type for the specified uri. * `SQL`: The file contains
      SQL statements. * `CSV`: The file contains CSV data. * `BAK`: The file
      contains backup data for a SQL Server instance.
    importUser: The PostgreSQL user for this import operation. PostgreSQL
      instances only.
    kind: This is always `sql#importContext`.
    sqlImportOptions: Optional. Options for importing data from SQL
      statements.
    tdeImportOptions: Optional. Import parameters specific to SQL Server .TDE
      files Import parameters specific to SQL Server TDE certificates
    uri: Path to the import file in Cloud Storage, in the form
      `gs://bucketName/fileName`. Compressed gzip files (.gz) are supported
      when `fileType` is `SQL`. The instance must have write permissions to
      the bucket and read access to the file.
  """

  class FileTypeValueValuesEnum(_messages.Enum):
    r"""The file type for the specified uri. * `SQL`: The file contains SQL
    statements. * `CSV`: The file contains CSV data. * `BAK`: The file
    contains backup data for a SQL Server instance.

    Values:
      SQL_FILE_TYPE_UNSPECIFIED: Unknown file type.
      SQL: File containing SQL statements.
      CSV: File in CSV format.
      BAK: <no description>
      TDE: TDE certificate.
    """
    SQL_FILE_TYPE_UNSPECIFIED = 0
    SQL = 1
    CSV = 2
    BAK = 3
    TDE = 4

  class BakImportOptionsValue(_messages.Message):
    r"""Import parameters specific to SQL Server .BAK files

    Enums:
      BakTypeValueValuesEnum: Type of the bak content, FULL or DIFF.

    Messages:
      EncryptionOptionsValue: A EncryptionOptionsValue object.

    Fields:
      bakType: Type of the bak content, FULL or DIFF.
      encryptionOptions: A EncryptionOptionsValue attribute.
      noRecovery: Whether or not the backup importing will restore database
        with NORECOVERY option. Applies only to Cloud SQL for SQL Server.
      recoveryOnly: Whether or not the backup importing request will just
        bring database online without downloading Bak content only one of
        "no_recovery" and "recovery_only" can be true otherwise error will
        return. Applies only to Cloud SQL for SQL Server.
      stopAt: Optional. The timestamp when the import should stop. This
        timestamp is in the [RFC 3339](https://tools.ietf.org/html/rfc3339)
        format (for example, `2023-10-01T16:19:00.094`). This field is
        equivalent to the STOPAT keyword and applies to Cloud SQL for SQL
        Server only.
      stopAtMark: Optional. The marked transaction where the import should
        stop. This field is equivalent to the STOPATMARK keyword and applies
        to Cloud SQL for SQL Server only.
      striped: Whether or not the backup set being restored is striped.
        Applies only to Cloud SQL for SQL Server.
    """

    class BakTypeValueValuesEnum(_messages.Enum):
      r"""Type of the bak content, FULL or DIFF.

      Values:
        BAK_TYPE_UNSPECIFIED: Default type.
        FULL: Full backup.
        DIFF: Differential backup.
        TLOG: SQL Server Transaction Log
      """
      BAK_TYPE_UNSPECIFIED = 0
      FULL = 1
      DIFF = 2
      TLOG = 3

    class EncryptionOptionsValue(_messages.Message):
      r"""A EncryptionOptionsValue object.

      Fields:
        certPath: Path to the Certificate (.cer) in Cloud Storage, in the form
          `gs://bucketName/fileName`. The instance must have write permissions
          to the bucket and read access to the file.
        keepEncrypted: Optional. Whether the imported file remains encrypted.
        pvkPassword: Password that encrypts the private key
        pvkPath: Path to the Certificate Private Key (.pvk) in Cloud Storage,
          in the form `gs://bucketName/fileName`. The instance must have write
          permissions to the bucket and read access to the file.
      """

      certPath = _messages.StringField(1)
      keepEncrypted = _messages.BooleanField(2)
      pvkPassword = _messages.StringField(3)
      pvkPath = _messages.StringField(4)

    bakType = _messages.EnumField('BakTypeValueValuesEnum', 1)
    encryptionOptions = _messages.MessageField('EncryptionOptionsValue', 2)
    noRecovery = _messages.BooleanField(3)
    recoveryOnly = _messages.BooleanField(4)
    stopAt = _messages.StringField(5)
    stopAtMark = _messages.StringField(6)
    striped = _messages.BooleanField(7)

  class CsvImportOptionsValue(_messages.Message):
    r"""Options for importing data as CSV.

    Fields:
      columns: The columns to which CSV data is imported. If not specified,
        all columns of the database table are loaded with CSV data.
      escapeCharacter: Specifies the character that should appear before a
        data character that needs to be escaped.
      fieldsTerminatedBy: Specifies the character that separates columns
        within each row (line) of the file.
      linesTerminatedBy: This is used to separate lines. If a line does not
        contain all fields, the rest of the columns are set to their default
        values.
      quoteCharacter: Specifies the quoting character to be used when a data
        value is quoted.
      table: The table to which CSV data is imported.
    """

    columns = _messages.StringField(1, repeated=True)
    escapeCharacter = _messages.StringField(2)
    fieldsTerminatedBy = _messages.StringField(3)
    linesTerminatedBy = _messages.StringField(4)
    quoteCharacter = _messages.StringField(5)
    table = _messages.StringField(6)

  class SqlImportOptionsValue(_messages.Message):
    r"""Optional. Options for importing data from SQL statements.

    Messages:
      PostgresImportOptionsValue: Optional. Options for importing from a Cloud
        SQL for PostgreSQL instance.

    Fields:
      parallel: Optional. Whether or not the import should be parallel.
      postgresImportOptions: Optional. Options for importing from a Cloud SQL
        for PostgreSQL instance.
      threads: Optional. The number of threads to use for parallel import.
    """

    class PostgresImportOptionsValue(_messages.Message):
      r"""Optional. Options for importing from a Cloud SQL for PostgreSQL
      instance.

      Fields:
        clean: Optional. The --clean flag for the pg_restore utility. This
          flag applies only if you enabled Cloud SQL to import files in
          parallel.
        ifExists: Optional. The --if-exists flag for the pg_restore utility.
          This flag applies only if you enabled Cloud SQL to import files in
          parallel.
      """

      clean = _messages.BooleanField(1)
      ifExists = _messages.BooleanField(2)

    parallel = _messages.BooleanField(1)
    postgresImportOptions = _messages.MessageField('PostgresImportOptionsValue', 2)
    threads = _messages.IntegerField(3, variant=_messages.Variant.INT32)

  class TdeImportOptionsValue(_messages.Message):
    r"""Optional. Import parameters specific to SQL Server .TDE files Import
    parameters specific to SQL Server TDE certificates

    Fields:
      certificatePath: Required. Path to the TDE certificate public key in the
        form gs://bucketName/fileName. The instance must have read access to
        the file. Applicable only for SQL Server instances.
      name: Required. Certificate name. Applicable only for SQL Server
        instances.
      privateKeyPassword: Required. Password that encrypts the private key.
      privateKeyPath: Required. Path to the TDE certificate private key in the
        form gs://bucketName/fileName. The instance must have read access to
        the file. Applicable only for SQL Server instances.
    """

    certificatePath = _messages.StringField(1)
    name = _messages.StringField(2)
    privateKeyPassword = _messages.StringField(3)
    privateKeyPath = _messages.StringField(4)

  bakImportOptions = _messages.MessageField('BakImportOptionsValue', 1)
  csvImportOptions = _messages.MessageField('CsvImportOptionsValue', 2)
  database = _messages.StringField(3)
  fileType = _messages.EnumField('FileTypeValueValuesEnum', 4)
  importUser = _messages.StringField(5)
  kind = _messages.StringField(6)
  sqlImportOptions = _messages.MessageField('SqlImportOptionsValue', 7)
  tdeImportOptions = _messages.MessageField('TdeImportOptionsValue', 8)
  uri = _messages.StringField(9)


class InsightsConfig(_messages.Message):
  r"""Insights configuration. This specifies when Cloud SQL Insights feature
  is enabled and optional configuration.

  Fields:
    queryInsightsEnabled: Whether Query Insights feature is enabled.
    queryPlansPerMinute: Number of query execution plans captured by Insights
      per minute for all queries combined. Default is 5.
    queryStringLength: Maximum query length stored in bytes. Default value:
      1024 bytes. Range: 256-4500 bytes. Query lengths greater than this field
      value will be truncated to this value. When unset, query length will be
      the default value. Changing query length will restart the database.
    recordApplicationTags: Whether Query Insights will record application tags
      from query when enabled.
    recordClientAddress: Whether Query Insights will record client address
      when enabled.
  """

  queryInsightsEnabled = _messages.BooleanField(1)
  queryPlansPerMinute = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  queryStringLength = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  recordApplicationTags = _messages.BooleanField(4)
  recordClientAddress = _messages.BooleanField(5)


class InstanceReference(_messages.Message):
  r"""Reference to another Cloud SQL instance.

  Fields:
    name: The name of the Cloud SQL instance being referenced. This does not
      include the project ID.
    project: The project ID of the Cloud SQL instance being referenced. The
      default is the same project ID as the instance references it.
    region: The region of the Cloud SQL instance being referenced.
  """

  name = _messages.StringField(1)
  project = _messages.StringField(2)
  region = _messages.StringField(3)


class InstancesAcquireSsrsLeaseRequest(_messages.Message):
  r"""Request to acquire an SSRS lease for an instance.

  Fields:
    acquireSsrsLeaseContext: Contains details about the acquire SSRS lease
      operation.
  """

  acquireSsrsLeaseContext = _messages.MessageField('AcquireSsrsLeaseContext', 1)


class InstancesCloneRequest(_messages.Message):
  r"""Database instance clone request.

  Fields:
    cloneContext: Contains details about the clone operation.
  """

  cloneContext = _messages.MessageField('CloneContext', 1)


class InstancesDemoteMasterRequest(_messages.Message):
  r"""Database demote primary instance request.

  Fields:
    demoteMasterContext: Contains details about the demoteMaster operation.
  """

  demoteMasterContext = _messages.MessageField('DemoteMasterContext', 1)


class InstancesDemoteRequest(_messages.Message):
  r"""This request is used to demote an existing standalone instance to be a
  Cloud SQL read replica for an external database server.

  Fields:
    demoteContext: Required. This context is used to demote an existing
      standalone instance to be a Cloud SQL read replica for an external
      database server.
  """

  demoteContext = _messages.MessageField('DemoteContext', 1)


class InstancesExportRequest(_messages.Message):
  r"""Database instance export request.

  Fields:
    exportContext: Contains details about the export operation.
  """

  exportContext = _messages.MessageField('ExportContext', 1)


class InstancesFailoverRequest(_messages.Message):
  r"""Instance failover request.

  Fields:
    failoverContext: Failover Context.
  """

  failoverContext = _messages.MessageField('FailoverContext', 1)


class InstancesImportRequest(_messages.Message):
  r"""Database instance import request.

  Fields:
    importContext: Contains details about the import operation.
  """

  importContext = _messages.MessageField('ImportContext', 1)


class InstancesListEntraIdCertificatesResponse(_messages.Message):
  r"""Instances ListEntraIdCertificates response.

  Fields:
    activeVersion: The `sha1_fingerprint` of the active certificate from
      `certs`.
    certs: List of Entra ID certificates for the instance.
    kind: This is always `sql#instancesListEntraIdCertificates`.
  """

  activeVersion = _messages.StringField(1)
  certs = _messages.MessageField('SslCert', 2, repeated=True)
  kind = _messages.StringField(3)


class InstancesListResponse(_messages.Message):
  r"""Database instances list response.

  Fields:
    items: List of database instance resources.
    kind: This is always `sql#instancesList`.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
    warnings: List of warnings that occurred while handling the request.
  """

  items = _messages.MessageField('DatabaseInstance', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)
  warnings = _messages.MessageField('ApiWarning', 4, repeated=True)


class InstancesListServerCasResponse(_messages.Message):
  r"""Instances ListServerCas response.

  Fields:
    activeVersion: A string attribute.
    certs: List of server CA certificates for the instance.
    kind: This is always `sql#instancesListServerCas`.
  """

  activeVersion = _messages.StringField(1)
  certs = _messages.MessageField('SslCert', 2, repeated=True)
  kind = _messages.StringField(3)


class InstancesListServerCertificatesResponse(_messages.Message):
  r"""Instances ListServerCertificatess response.

  Fields:
    activeVersion: The `sha1_fingerprint` of the active certificate from
      `server_certs`.
    caCerts: List of server CA certificates for the instance.
    kind: This is always `sql#instancesListServerCertificates`.
    serverCerts: List of server certificates for the instance, signed by the
      corresponding CA from the `ca_certs` list.
  """

  activeVersion = _messages.StringField(1)
  caCerts = _messages.MessageField('SslCert', 2, repeated=True)
  kind = _messages.StringField(3)
  serverCerts = _messages.MessageField('SslCert', 4, repeated=True)


class InstancesPreCheckMajorVersionUpgradeRequest(_messages.Message):
  r"""Request for Pre-checks for MVU

  Fields:
    preCheckMajorVersionUpgradeContext: Required. Contains details about the
      pre-check major version upgrade operation.
  """

  preCheckMajorVersionUpgradeContext = _messages.MessageField('PreCheckMajorVersionUpgradeContext', 1)


class InstancesReencryptRequest(_messages.Message):
  r"""Database Instance reencrypt request.

  Fields:
    backupReencryptionConfig: Configuration specific to backup re-encryption
  """

  backupReencryptionConfig = _messages.MessageField('BackupReencryptionConfig', 1)


class InstancesRestoreBackupRequest(_messages.Message):
  r"""Database instance restore backup request.

  Fields:
    backup: The name of the backup that's used to restore a Cloud SQL
      instance: Format: projects/{project-id}/backups/{backup-uid}. Only one
      of restore_backup_context, backup, backupdr_backup can be passed to the
      input.
    backupdrBackup: The name of the backup that's used to restore a Cloud SQL
      instance: Format: "projects/{project-id}/locations/{location}/backupVaul
      ts/{backupvault}/dataSources/{datasource}/backups/{backup-uid}". Only
      one of restore_backup_context, backup, backupdr_backup can be passed to
      the input.
    restoreBackupContext: Parameters required to perform the restore backup
      operation.
    restoreInstanceClearOverridesFieldNames: Optional. This field has the same
      purpose as restore_instance_settings, changes any instance settings
      stored in the backup you are restoring from. With the difference that
      these fields are cleared in the settings.
    restoreInstanceSettings: Optional. By using this parameter, Cloud SQL
      overrides any instance settings stored in the backup you are restoring
      from. You can't change the instance's major database version and you can
      only increase the disk size. You can use this field to restore new
      instances only. This field is not applicable for restore to existing
      instances.
  """

  backup = _messages.StringField(1)
  backupdrBackup = _messages.StringField(2)
  restoreBackupContext = _messages.MessageField('RestoreBackupContext', 3)
  restoreInstanceClearOverridesFieldNames = _messages.StringField(4, repeated=True)
  restoreInstanceSettings = _messages.MessageField('DatabaseInstance', 5)


class InstancesRotateEntraIdCertificateRequest(_messages.Message):
  r"""Rotate Entra ID Certificate request.

  Fields:
    rotateEntraIdCertificateContext: Optional. Contains details about the
      rotate Entra ID certificate operation.
  """

  rotateEntraIdCertificateContext = _messages.MessageField('RotateEntraIdCertificateContext', 1)


class InstancesRotateServerCaRequest(_messages.Message):
  r"""Rotate Server CA request.

  Fields:
    rotateServerCaContext: Contains details about the rotate server CA
      operation.
  """

  rotateServerCaContext = _messages.MessageField('RotateServerCaContext', 1)


class InstancesRotateServerCertificateRequest(_messages.Message):
  r"""Rotate Server Certificate request.

  Fields:
    rotateServerCertificateContext: Optional. Contains details about the
      rotate server CA operation.
  """

  rotateServerCertificateContext = _messages.MessageField('RotateServerCertificateContext', 1)


class InstancesTruncateLogRequest(_messages.Message):
  r"""Instance truncate log request.

  Fields:
    truncateLogContext: Contains details about the truncate log operation.
  """

  truncateLogContext = _messages.MessageField('TruncateLogContext', 1)


class Interval(_messages.Message):
  r"""Represents a time interval, encoded as a Timestamp start (inclusive) and
  a Timestamp end (exclusive). The start must be less than or equal to the
  end. When the start equals the end, the interval is empty (matches no time).
  When both start and end are unspecified, the interval matches any time.

  Fields:
    endTime: Optional. Exclusive end of the interval. If specified, a
      Timestamp matching this interval will have to be before the end.
    startTime: Optional. Inclusive start of the interval. If specified, a
      Timestamp matching this interval will have to be the same or after the
      start.
  """

  endTime = _messages.StringField(1)
  startTime = _messages.StringField(2)


class IpConfiguration(_messages.Message):
  r"""IP Management configuration.

  Enums:
    ServerCaModeValueValuesEnum: Specify what type of CA is used for the
      server certificate.
    ServerCertificateRotationModeValueValuesEnum: Optional. Controls the
      automatic server certificate rotation feature. This feature is disabled
      by default. When enabled, the server certificate will be automatically
      rotated during Cloud SQL scheduled maintenance or self-service
      maintenance updates up to six months before it expires. This setting can
      only be set if server_ca_mode is either GOOGLE_MANAGED_CAS_CA or
      CUSTOMER_MANAGED_CAS_CA.
    SslModeValueValuesEnum: Specify how SSL/TLS is enforced in database
      connections. If you must use the `require_ssl` flag for backward
      compatibility, then only the following value pairs are valid: For
      PostgreSQL and MySQL: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and
      `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`
      * `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true`
      For SQL Server: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and
      `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=true`
      The value of `ssl_mode` has priority over the value of `require_ssl`.
      For example, for the pair `ssl_mode=ENCRYPTED_ONLY` and
      `require_ssl=false`, `ssl_mode=ENCRYPTED_ONLY` means accept only SSL
      connections, while `require_ssl=false` means accept both non-SSL and SSL
      connections. In this case, MySQL and PostgreSQL databases respect
      `ssl_mode` and accepts only SSL connections.

  Fields:
    allocatedIpRange: The name of the allocated ip range for the private ip
      Cloud SQL instance. For example: "google-managed-services-default". If
      set, the instance ip will be created in the allocated range. The range
      name must comply with [RFC 1035](https://tools.ietf.org/html/rfc1035).
      Specifically, the name must be 1-63 characters long and match the
      regular expression `[a-z]([-a-z0-9]*[a-z0-9])?.`
    authorizedNetworks: The list of external networks that are allowed to
      connect to the instance using the IP. In 'CIDR' notation, also known as
      'slash' notation (for example: `157.197.200.0/24`).
    customSubjectAlternativeNames: Optional. Custom Subject Alternative
      Name(SAN)s for a Cloud SQL instance.
    enablePrivatePathForGoogleCloudServices: Controls connectivity to private
      IP instances from Google services, such as BigQuery.
    ipv4Enabled: Whether the instance is assigned a public IP address or not.
    privateNetwork: The resource link for the VPC network from which the Cloud
      SQL instance is accessible for private IP. For example,
      `/projects/myProject/global/networks/default`. This setting can be
      updated, but it cannot be removed after it is set.
    pscConfig: PSC settings for this instance.
    requireSsl: Use `ssl_mode` instead. Whether SSL/TLS connections over IP
      are enforced. If set to false, then allow both non-SSL/non-TLS and
      SSL/TLS connections. For SSL/TLS connections, the client certificate
      won't be verified. If set to true, then only allow connections encrypted
      with SSL/TLS and with valid client certificates. If you want to enforce
      SSL/TLS without enforcing the requirement for valid client certificates,
      then use the `ssl_mode` flag instead of the legacy `require_ssl` flag.
    reservedIpRange: This field is deprecated and will be removed from a
      future version of the API.
    serverCaMode: Specify what type of CA is used for the server certificate.
    serverCaPool: Optional. The resource name of the server CA pool for an
      instance with `CUSTOMER_MANAGED_CAS_CA` as the `server_ca_mode`. Format:
      projects/{PROJECT}/locations/{REGION}/caPools/{CA_POOL_ID}
    serverCertificateRotationMode: Optional. Controls the automatic server
      certificate rotation feature. This feature is disabled by default. When
      enabled, the server certificate will be automatically rotated during
      Cloud SQL scheduled maintenance or self-service maintenance updates up
      to six months before it expires. This setting can only be set if
      server_ca_mode is either GOOGLE_MANAGED_CAS_CA or
      CUSTOMER_MANAGED_CAS_CA.
    sslMode: Specify how SSL/TLS is enforced in database connections. If you
      must use the `require_ssl` flag for backward compatibility, then only
      the following value pairs are valid: For PostgreSQL and MySQL: *
      `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
      `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
      `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true`
      For SQL Server: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and
      `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=true`
      The value of `ssl_mode` has priority over the value of `require_ssl`.
      For example, for the pair `ssl_mode=ENCRYPTED_ONLY` and
      `require_ssl=false`, `ssl_mode=ENCRYPTED_ONLY` means accept only SSL
      connections, while `require_ssl=false` means accept both non-SSL and SSL
      connections. In this case, MySQL and PostgreSQL databases respect
      `ssl_mode` and accepts only SSL connections.
  """

  class ServerCaModeValueValuesEnum(_messages.Enum):
    r"""Specify what type of CA is used for the server certificate.

    Values:
      CA_MODE_UNSPECIFIED: CA mode is unspecified. It is effectively the same
        as `GOOGLE_MANAGED_INTERNAL_CA`.
      GOOGLE_MANAGED_INTERNAL_CA: Google-managed self-signed internal CA.
      GOOGLE_MANAGED_CAS_CA: Google-managed regional CA part of root CA
        hierarchy hosted on Google Cloud's Certificate Authority Service
        (CAS).
      CUSTOMER_MANAGED_CAS_CA: Customer-managed CA hosted on Google Cloud's
        Certificate Authority Service (CAS).
    """
    CA_MODE_UNSPECIFIED = 0
    GOOGLE_MANAGED_INTERNAL_CA = 1
    GOOGLE_MANAGED_CAS_CA = 2
    CUSTOMER_MANAGED_CAS_CA = 3

  class ServerCertificateRotationModeValueValuesEnum(_messages.Enum):
    r"""Optional. Controls the automatic server certificate rotation feature.
    This feature is disabled by default. When enabled, the server certificate
    will be automatically rotated during Cloud SQL scheduled maintenance or
    self-service maintenance updates up to six months before it expires. This
    setting can only be set if server_ca_mode is either GOOGLE_MANAGED_CAS_CA
    or CUSTOMER_MANAGED_CAS_CA.

    Values:
      SERVER_CERTIFICATE_ROTATION_MODE_UNSPECIFIED: Unspecified: no automatic
        server certificate rotation.
      NO_AUTOMATIC_ROTATION: No automatic server certificate rotation. The
        user must [manage server certificate rotation](/sql/docs/mysql/manage-
        ssl-instance#rotate-server-certificate-cas) on their side.
      AUTOMATIC_ROTATION_DURING_MAINTENANCE: Automatic server certificate
        rotation during Cloud SQL scheduled maintenance or self-service
        maintenance updates. Requires `server_ca_mode` to be
        `GOOGLE_MANAGED_CAS_CA` or `CUSTOMER_MANAGED_CAS_CA`.
    """
    SERVER_CERTIFICATE_ROTATION_MODE_UNSPECIFIED = 0
    NO_AUTOMATIC_ROTATION = 1
    AUTOMATIC_ROTATION_DURING_MAINTENANCE = 2

  class SslModeValueValuesEnum(_messages.Enum):
    r"""Specify how SSL/TLS is enforced in database connections. If you must
    use the `require_ssl` flag for backward compatibility, then only the
    following value pairs are valid: For PostgreSQL and MySQL: *
    `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and `require_ssl=false` *
    `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false` *
    `ssl_mode=TRUSTED_CLIENT_CERTIFICATE_REQUIRED` and `require_ssl=true` For
    SQL Server: * `ssl_mode=ALLOW_UNENCRYPTED_AND_ENCRYPTED` and
    `require_ssl=false` * `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=true` The
    value of `ssl_mode` has priority over the value of `require_ssl`. For
    example, for the pair `ssl_mode=ENCRYPTED_ONLY` and `require_ssl=false`,
    `ssl_mode=ENCRYPTED_ONLY` means accept only SSL connections, while
    `require_ssl=false` means accept both non-SSL and SSL connections. In this
    case, MySQL and PostgreSQL databases respect `ssl_mode` and accepts only
    SSL connections.

    Values:
      SSL_MODE_UNSPECIFIED: The SSL mode is unknown.
      ALLOW_UNENCRYPTED_AND_ENCRYPTED: Allow non-SSL/non-TLS and SSL/TLS
        connections. For SSL connections to MySQL and PostgreSQL, the client
        certificate isn't verified. When this value is used, the legacy
        `require_ssl` flag must be false or cleared to avoid a conflict
        between the values of the two flags.
      ENCRYPTED_ONLY: Only allow connections encrypted with SSL/TLS. For SSL
        connections to MySQL and PostgreSQL, the client certificate isn't
        verified. When this value is used, the legacy `require_ssl` flag must
        be false or cleared to avoid a conflict between the values of the two
        flags.
      TRUSTED_CLIENT_CERTIFICATE_REQUIRED: Only allow connections encrypted
        with SSL/TLS and with valid client certificates. When this value is
        used, the legacy `require_ssl` flag must be true or cleared to avoid
        the conflict between values of two flags. PostgreSQL clients or users
        that connect using IAM database authentication must use either the
        [Cloud SQL Auth
        Proxy](https://cloud.google.com/sql/docs/postgres/connect-auth-proxy)
        or [Cloud SQL
        Connectors](https://cloud.google.com/sql/docs/postgres/connect-
        connectors) to enforce client identity verification. Only applicable
        to MySQL and PostgreSQL. Not applicable to SQL Server.
    """
    SSL_MODE_UNSPECIFIED = 0
    ALLOW_UNENCRYPTED_AND_ENCRYPTED = 1
    ENCRYPTED_ONLY = 2
    TRUSTED_CLIENT_CERTIFICATE_REQUIRED = 3

  allocatedIpRange = _messages.StringField(1)
  authorizedNetworks = _messages.MessageField('AclEntry', 2, repeated=True)
  customSubjectAlternativeNames = _messages.StringField(3, repeated=True)
  enablePrivatePathForGoogleCloudServices = _messages.BooleanField(4)
  ipv4Enabled = _messages.BooleanField(5)
  privateNetwork = _messages.StringField(6)
  pscConfig = _messages.MessageField('PscConfig', 7)
  requireSsl = _messages.BooleanField(8)
  reservedIpRange = _messages.StringField(9)
  serverCaMode = _messages.EnumField('ServerCaModeValueValuesEnum', 10)
  serverCaPool = _messages.StringField(11)
  serverCertificateRotationMode = _messages.EnumField('ServerCertificateRotationModeValueValuesEnum', 12)
  sslMode = _messages.EnumField('SslModeValueValuesEnum', 13)


class IpMapping(_messages.Message):
  r"""Database instance IP mapping

  Enums:
    TypeValueValuesEnum: The type of this IP address. A `PRIMARY` address is a
      public address that can accept incoming connections. A `PRIVATE` address
      is a private address that can accept incoming connections. An `OUTGOING`
      address is the source address of connections originating from the
      instance, if supported.

  Fields:
    ipAddress: The IP address assigned.
    timeToRetire: The due time for this IP to be retired in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`. This field is only available when the IP is
      scheduled to be retired.
    type: The type of this IP address. A `PRIMARY` address is a public address
      that can accept incoming connections. A `PRIVATE` address is a private
      address that can accept incoming connections. An `OUTGOING` address is
      the source address of connections originating from the instance, if
      supported.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""The type of this IP address. A `PRIMARY` address is a public address
    that can accept incoming connections. A `PRIVATE` address is a private
    address that can accept incoming connections. An `OUTGOING` address is the
    source address of connections originating from the instance, if supported.

    Values:
      SQL_IP_ADDRESS_TYPE_UNSPECIFIED: This is an unknown IP address type.
      PRIMARY: IP address the customer is supposed to connect to. Usually this
        is the load balancer's IP address
      OUTGOING: Source IP address of the connection a read replica establishes
        to its external primary instance. This IP address can be allowlisted
        by the customer in case it has a firewall that filters incoming
        connection to its on premises primary instance.
      PRIVATE: Private IP used when using private IPs and network peering.
      MIGRATED_1ST_GEN: V1 IP of a migrated instance. We want the user to
        decommission this IP as soon as the migration is complete. Note: V1
        instances with V1 ip addresses will be counted as PRIMARY.
    """
    SQL_IP_ADDRESS_TYPE_UNSPECIFIED = 0
    PRIMARY = 1
    OUTGOING = 2
    PRIVATE = 3
    MIGRATED_1ST_GEN = 4

  ipAddress = _messages.StringField(1)
  timeToRetire = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class ListBackupsResponse(_messages.Message):
  r"""The response payload containing a list of the backups.

  Fields:
    backups: A list of backups.
    nextPageToken: A token, which can be sent as `page_token` to retrieve the
      next page. If this field is omitted, then there aren't subsequent pages.
    warnings: If a region isn't unavailable or if an unknown error occurs,
      then a warning message is returned.
  """

  backups = _messages.MessageField('Backup', 1, repeated=True)
  nextPageToken = _messages.StringField(2)
  warnings = _messages.MessageField('ApiWarning', 3, repeated=True)


class LocationPreference(_messages.Message):
  r"""Preferred location. This specifies where a Cloud SQL instance is
  located. Note that if the preferred location is not available, the instance
  will be located as close as possible within the region. Only one location
  may be specified.

  Fields:
    followGaeApplication: The App Engine application to follow, it must be in
      the same region as the Cloud SQL instance. WARNING: Changing this might
      restart the instance.
    kind: This is always `sql#locationPreference`.
    secondaryZone: The preferred Compute Engine zone for the
      secondary/failover (for example: us-central1-a, us-central1-b, etc.). To
      disable this field, set it to 'no_secondary_zone'.
    zone: The preferred Compute Engine zone (for example: us-central1-a, us-
      central1-b, etc.). WARNING: Changing this might restart the instance.
  """

  followGaeApplication = _messages.StringField(1)
  kind = _messages.StringField(2)
  secondaryZone = _messages.StringField(3)
  zone = _messages.StringField(4)


class MaintenanceWindow(_messages.Message):
  r"""Maintenance window. This specifies when a Cloud SQL instance is
  restarted for system maintenance purposes.

  Enums:
    UpdateTrackValueValuesEnum: Maintenance timing settings: `canary`,
      `stable`, or `week5`. For more information, see [About maintenance on
      Cloud SQL
      instances](https://cloud.google.com/sql/docs/mysql/maintenance).

  Fields:
    day: Day of week - `MONDAY`, `TUESDAY`, `WEDNESDAY`, `THURSDAY`, `FRIDAY`,
      `SATURDAY`, or `SUNDAY`. Specify in the UTC time zone. Returned in
      output as an integer, 1 to 7, where `1` equals Monday.
    hour: Hour of day - 0 to 23. Specify in the UTC time zone.
    kind: This is always `sql#maintenanceWindow`.
    updateTrack: Maintenance timing settings: `canary`, `stable`, or `week5`.
      For more information, see [About maintenance on Cloud SQL
      instances](https://cloud.google.com/sql/docs/mysql/maintenance).
  """

  class UpdateTrackValueValuesEnum(_messages.Enum):
    r"""Maintenance timing settings: `canary`, `stable`, or `week5`. For more
    information, see [About maintenance on Cloud SQL
    instances](https://cloud.google.com/sql/docs/mysql/maintenance).

    Values:
      SQL_UPDATE_TRACK_UNSPECIFIED: This is an unknown maintenance timing
        preference.
      canary: For an instance with a scheduled maintenance window, this
        maintenance timing indicates that the maintenance update is scheduled
        7 to 14 days after the notification is sent out. Also referred to as
        `Week 1` (Console) and `preview` (gcloud CLI).
      stable: For an instance with a scheduled maintenance window, this
        maintenance timing indicates that the maintenance update is scheduled
        15 to 21 days after the notification is sent out. Also referred to as
        `Week 2` (Console) and `production` (gcloud CLI).
      week5: For instance with a scheduled maintenance window, this
        maintenance timing indicates that the maintenance update is scheduled
        35 to 42 days after the notification is sent out.
    """
    SQL_UPDATE_TRACK_UNSPECIFIED = 0
    canary = 1
    stable = 2
    week5 = 3

  day = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  hour = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  kind = _messages.StringField(3)
  updateTrack = _messages.EnumField('UpdateTrackValueValuesEnum', 4)


class ManagementConfig(_messages.Message):
  r"""Configurations for Backup and DR Service managed instances.

  Fields:
    backupdrTransactionLogRetentionDays: The number of days of transaction
      logs we retain for backups of instances managed by Backup and DR
      Service.
  """

  backupdrTransactionLogRetentionDays = _messages.IntegerField(1, variant=_messages.Variant.INT32)


class Message(_messages.Message):
  r"""Represents a notice or warning message from the database.

  Fields:
    message: The full message string. For PostgreSQL, this is a formatted
      string that may include severity, code, and the notice/warning message.
      For MySQL, this contains the warning message.
    severity: The severity of the message (e.g., "NOTICE" for PostgreSQL,
      "WARNING" for MySQL).
  """

  message = _messages.StringField(1)
  severity = _messages.StringField(2)


class Metadata(_messages.Message):
  r"""The additional metadata information regarding the execution of the SQL
  statements.

  Fields:
    sqlStatementExecutionTime: The time taken to execute the SQL statements.
  """

  sqlStatementExecutionTime = _messages.StringField(1)


class MySqlReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration specific to MySQL databases.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the replica's x509 certificate.
    clientKey: PEM representation of the replica's private key. The
      corresponding public key is encoded in the client's certificate.
    connectRetryInterval: Seconds to wait between connect retries. MySQL's
      default is 60 seconds.
    dumpFilePath: Path to a SQL dump file in Google Cloud Storage from which
      the replica instance is to be created. The URI is in the form
      gs://bucketName/fileName. Compressed gzip files (.gz) are also
      supported. Dumps have the binlog co-ordinates from which replication
      begins. This can be accomplished by setting --master-data to 1 when
      using mysqldump.
    kind: This is always `sql#mysqlReplicaConfiguration`.
    masterHeartbeatPeriod: Interval in milliseconds between replication
      heartbeats.
    password: The password for the replication connection.
    sslCipher: A list of permissible ciphers to use for SSL encryption.
    username: The username for the replication connection.
    verifyServerCertificate: Whether or not to check the primary instance's
      Common Name value in the certificate that it sends during the SSL
      handshake.
  """

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  connectRetryInterval = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  dumpFilePath = _messages.StringField(5)
  kind = _messages.StringField(6)
  masterHeartbeatPeriod = _messages.IntegerField(7)
  password = _messages.StringField(8)
  sslCipher = _messages.StringField(9)
  username = _messages.StringField(10)
  verifyServerCertificate = _messages.BooleanField(11)


class MySqlSyncConfig(_messages.Message):
  r"""MySQL-specific external server sync settings.

  Fields:
    initialSyncFlags: Flags to use for the initial dump.
  """

  initialSyncFlags = _messages.MessageField('SyncFlags', 1, repeated=True)


class OnPremisesConfiguration(_messages.Message):
  r"""On-premises instance configuration.

  Enums:
    SslOptionValueValuesEnum: Optional. SslOption for replica connection to
      the on-premises source.

  Fields:
    caCertificate: PEM representation of the trusted CA's x509 certificate.
    clientCertificate: PEM representation of the replica's x509 certificate.
    clientKey: PEM representation of the replica's private key. The
      corresponding public key is encoded in the client's certificate.
    dumpFilePath: The dump file to create the Cloud SQL replica.
    hostPort: The host and port of the on-premises instance in host:port
      format
    kind: This is always `sql#onPremisesConfiguration`.
    password: The password for connecting to on-premises instance.
    selectedObjects: Optional. A list of objects that the user selects for
      replication from an external source instance.
    sourceInstance: The reference to Cloud SQL instance if the source is Cloud
      SQL.
    sslOption: Optional. SslOption for replica connection to the on-premises
      source.
    username: The username for connecting to on-premises instance.
  """

  class SslOptionValueValuesEnum(_messages.Enum):
    r"""Optional. SslOption for replica connection to the on-premises source.

    Values:
      SSL_OPTION_UNSPECIFIED: Unknown SSL option i.e. SSL option not specified
        by user.
      DISABLE: SSL is disabled for replica connection to the on-premises
        source.
      REQUIRE: SSL is required for replica connection to the on-premises
        source.
      VERIFY_CA: Verify CA is required for replica connection to the on-
        premises source.
    """
    SSL_OPTION_UNSPECIFIED = 0
    DISABLE = 1
    REQUIRE = 2
    VERIFY_CA = 3

  caCertificate = _messages.StringField(1)
  clientCertificate = _messages.StringField(2)
  clientKey = _messages.StringField(3)
  dumpFilePath = _messages.StringField(4)
  hostPort = _messages.StringField(5)
  kind = _messages.StringField(6)
  password = _messages.StringField(7)
  selectedObjects = _messages.MessageField('SelectedObjects', 8, repeated=True)
  sourceInstance = _messages.MessageField('InstanceReference', 9)
  sslOption = _messages.EnumField('SslOptionValueValuesEnum', 10)
  username = _messages.StringField(11)


class Operation(_messages.Message):
  r"""An Operation resource. For successful operations that return an
  Operation resource, only the fields relevant to the operation are populated
  in the resource.

  Enums:
    MaintenanceTypeValueValuesEnum: Optional. The type of maintenance to be
      performed on the instance.
    OperationTypeValueValuesEnum: The type of the operation. Valid values are:
      * `CREATE` * `DELETE` * `UPDATE` * `RESTART` * `IMPORT` * `EXPORT` *
      `BACKUP_VOLUME` * `RESTORE_VOLUME` * `CREATE_USER` * `DELETE_USER` *
      `CREATE_DATABASE` * `DELETE_DATABASE`
    StatusValueValuesEnum: The status of an operation.

  Fields:
    acquireSsrsLeaseContext: The context for acquire SSRS lease operation, if
      applicable.
    apiWarning: An Admin API warning message.
    backupContext: The context for backup operation, if applicable.
    endTime: The time this operation finished in UTC timezone in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    error: If errors occurred during processing of this operation, this field
      will be populated.
    exportContext: The context for export operation, if applicable.
    importContext: The context for import operation, if applicable.
    insertTime: The time this operation was enqueued in UTC timezone in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    kind: This is always `sql#operation`.
    maintenanceType: Optional. The type of maintenance to be performed on the
      instance.
    name: An identifier that uniquely identifies the operation. You can use
      this identifier to retrieve the Operations resource that has information
      about the operation.
    operationType: The type of the operation. Valid values are: * `CREATE` *
      `DELETE` * `UPDATE` * `RESTART` * `IMPORT` * `EXPORT` * `BACKUP_VOLUME`
      * `RESTORE_VOLUME` * `CREATE_USER` * `DELETE_USER` * `CREATE_DATABASE` *
      `DELETE_DATABASE`
    preCheckMajorVersionUpgradeContext: The context for pre-check major
      version upgrade operation, if applicable. This field is only populated
      when the operation_type is PRE_CHECK_MAJOR_VERSION_UPGRADE. The
      PreCheckMajorVersionUpgradeContext message itself contains the details
      for that pre-check, such as the target database version for the upgrade
      and the results of the check (including any warnings or errors found).
    selfLink: The URI of this resource.
    startTime: The time this operation actually started in UTC timezone in
      [RFC 3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    status: The status of an operation.
    subOperationType: Optional. The sub operation based on the operation type.
    targetId: Name of the resource on which this operation runs.
    targetLink: A string attribute.
    targetProject: The project ID of the target instance related to this
      operation.
    user: The email address of the user who initiated this operation.
  """

  class MaintenanceTypeValueValuesEnum(_messages.Enum):
    r"""Optional. The type of maintenance to be performed on the instance.

    Values:
      SQL_MAINTENANCE_TYPE_UNSPECIFIED: Maintenance type is unspecified.
      INSTANCE_MAINTENANCE: Indicates that a standalone instance is undergoing
        maintenance. The instance can be either a primary instance or a
        replica.
      REPLICA_INCLUDED_MAINTENANCE: Indicates that the primary instance and
        all of its replicas, including cascading replicas, are undergoing
        maintenance. Maintenance is performed on groups of replicas first,
        followed by the primary instance.
      INSTANCE_SELF_SERVICE_MAINTENANCE: Indicates that the standalone
        instance is undergoing maintenance, initiated by self-service. The
        instance can be either a primary instance or a replica.
      REPLICA_INCLUDED_SELF_SERVICE_MAINTENANCE: Indicates that the primary
        instance and all of its replicas are undergoing maintenance, initiated
        by self-service. Maintenance is performed on groups of replicas first,
        followed by the primary instance.
    """
    SQL_MAINTENANCE_TYPE_UNSPECIFIED = 0
    INSTANCE_MAINTENANCE = 1
    REPLICA_INCLUDED_MAINTENANCE = 2
    INSTANCE_SELF_SERVICE_MAINTENANCE = 3
    REPLICA_INCLUDED_SELF_SERVICE_MAINTENANCE = 4

  class OperationTypeValueValuesEnum(_messages.Enum):
    r"""The type of the operation. Valid values are: * `CREATE` * `DELETE` *
    `UPDATE` * `RESTART` * `IMPORT` * `EXPORT` * `BACKUP_VOLUME` *
    `RESTORE_VOLUME` * `CREATE_USER` * `DELETE_USER` * `CREATE_DATABASE` *
    `DELETE_DATABASE`

    Values:
      SQL_OPERATION_TYPE_UNSPECIFIED: Unknown operation type.
      IMPORT: Imports data into a Cloud SQL instance.
      EXPORT: Exports data from a Cloud SQL instance to a Cloud Storage
        bucket.
      CREATE: Creates a new Cloud SQL instance.
      UPDATE: Updates the settings of a Cloud SQL instance.
      DELETE: Deletes a Cloud SQL instance.
      RESTART: Restarts the Cloud SQL instance.
      BACKUP: <no description>
      SNAPSHOT: <no description>
      BACKUP_VOLUME: Performs instance backup.
      DELETE_VOLUME: Deletes an instance backup.
      RESTORE_VOLUME: Restores an instance backup.
      INJECT_USER: Injects a privileged user in mysql for MOB instances.
      CLONE: Clones a Cloud SQL instance.
      STOP_REPLICA: Stops replication on a Cloud SQL read replica instance.
      START_REPLICA: Starts replication on a Cloud SQL read replica instance.
      PROMOTE_REPLICA: Promotes a Cloud SQL replica instance.
      CREATE_REPLICA: Creates a Cloud SQL replica instance.
      CREATE_USER: Creates a new user in a Cloud SQL instance.
      DELETE_USER: Deletes a user from a Cloud SQL instance.
      UPDATE_USER: Updates an existing user in a Cloud SQL instance. If a user
        with the specified username doesn't exist, a new user is created.
      CREATE_DATABASE: Creates a database in the Cloud SQL instance.
      DELETE_DATABASE: Deletes a database in the Cloud SQL instance.
      UPDATE_DATABASE: Updates a database in the Cloud SQL instance.
      FAILOVER: Performs failover of an HA-enabled Cloud SQL failover replica.
      DELETE_BACKUP: Deletes the backup taken by a backup run.
      RECREATE_REPLICA: <no description>
      TRUNCATE_LOG: Truncates a general or slow log table in MySQL.
      DEMOTE_MASTER: Demotes the stand-alone instance to be a Cloud SQL read
        replica for an external database server.
      MAINTENANCE: Indicates that the instance is currently in maintenance.
        Maintenance typically causes the instance to be unavailable for 1-3
        minutes.
      ENABLE_PRIVATE_IP: This field is deprecated, and will be removed in
        future version of API.
      DEFER_MAINTENANCE: <no description>
      CREATE_CLONE: Creates clone instance.
      RESCHEDULE_MAINTENANCE: Reschedule maintenance to another time.
      START_EXTERNAL_SYNC: Starts external sync of a Cloud SQL EM replica to
        an external primary instance.
      LOG_CLEANUP: Recovers logs from an instance's old data disk.
      AUTO_RESTART: Performs auto-restart of an HA-enabled Cloud SQL database
        for auto recovery.
      REENCRYPT: Re-encrypts CMEK instances with latest key version.
      SWITCHOVER: Switches the roles of the primary and replica pair. The
        target instance should be the replica.
      UPDATE_BACKUP: Update a backup.
      ACQUIRE_SSRS_LEASE: Acquire a lease for the setup of SQL Server
        Reporting Services (SSRS).
      RELEASE_SSRS_LEASE: Release a lease for the setup of SQL Server
        Reporting Services (SSRS).
      RECONFIGURE_OLD_PRIMARY: Reconfigures old primary after a promote
        replica operation. Effect of a promote operation to the old primary is
        executed in this operation, asynchronously from the promote replica
        operation executed to the replica.
      CLUSTER_MAINTENANCE: Indicates that the instance, its read replicas, and
        its cascading replicas are in maintenance. Maintenance typically gets
        initiated on groups of replicas first, followed by the primary
        instance. For each instance, maintenance typically causes the instance
        to be unavailable for 1-3 minutes.
      SELF_SERVICE_MAINTENANCE: Indicates that the instance (and any of its
        replicas) are currently in maintenance. This is initiated as a self-
        service request by using SSM. Maintenance typically causes the
        instance to be unavailable for 1-3 minutes.
      SWITCHOVER_TO_REPLICA: Switches a primary instance to a replica. This
        operation runs as part of a switchover operation to the original
        primary instance.
      MAJOR_VERSION_UPGRADE: Updates the major version of a Cloud SQL
        instance.
      ADVANCED_BACKUP: Deprecated: ADVANCED_BACKUP is deprecated. Use
        ENHANCED_BACKUP instead.
      MANAGE_BACKUP: Changes the BackupTier of a Cloud SQL instance.
      ENHANCED_BACKUP: Creates a backup for an Enhanced BackupTier Cloud SQL
        instance.
      REPAIR_READ_POOL: Repairs entire read pool or specified read pool nodes
        in the read pool.
      CREATE_READ_POOL: Creates a Cloud SQL read pool instance.
      PRE_CHECK_MAJOR_VERSION_UPGRADE: Pre-checks for major version upgrade.
    """
    SQL_OPERATION_TYPE_UNSPECIFIED = 0
    IMPORT = 1
    EXPORT = 2
    CREATE = 3
    UPDATE = 4
    DELETE = 5
    RESTART = 6
    BACKUP = 7
    SNAPSHOT = 8
    BACKUP_VOLUME = 9
    DELETE_VOLUME = 10
    RESTORE_VOLUME = 11
    INJECT_USER = 12
    CLONE = 13
    STOP_REPLICA = 14
    START_REPLICA = 15
    PROMOTE_REPLICA = 16
    CREATE_REPLICA = 17
    CREATE_USER = 18
    DELETE_USER = 19
    UPDATE_USER = 20
    CREATE_DATABASE = 21
    DELETE_DATABASE = 22
    UPDATE_DATABASE = 23
    FAILOVER = 24
    DELETE_BACKUP = 25
    RECREATE_REPLICA = 26
    TRUNCATE_LOG = 27
    DEMOTE_MASTER = 28
    MAINTENANCE = 29
    ENABLE_PRIVATE_IP = 30
    DEFER_MAINTENANCE = 31
    CREATE_CLONE = 32
    RESCHEDULE_MAINTENANCE = 33
    START_EXTERNAL_SYNC = 34
    LOG_CLEANUP = 35
    AUTO_RESTART = 36
    REENCRYPT = 37
    SWITCHOVER = 38
    UPDATE_BACKUP = 39
    ACQUIRE_SSRS_LEASE = 40
    RELEASE_SSRS_LEASE = 41
    RECONFIGURE_OLD_PRIMARY = 42
    CLUSTER_MAINTENANCE = 43
    SELF_SERVICE_MAINTENANCE = 44
    SWITCHOVER_TO_REPLICA = 45
    MAJOR_VERSION_UPGRADE = 46
    ADVANCED_BACKUP = 47
    MANAGE_BACKUP = 48
    ENHANCED_BACKUP = 49
    REPAIR_READ_POOL = 50
    CREATE_READ_POOL = 51
    PRE_CHECK_MAJOR_VERSION_UPGRADE = 52

  class StatusValueValuesEnum(_messages.Enum):
    r"""The status of an operation.

    Values:
      SQL_OPERATION_STATUS_UNSPECIFIED: The state of the operation is unknown.
      PENDING: The operation has been queued, but has not started yet.
      RUNNING: The operation is running.
      DONE: The operation completed.
    """
    SQL_OPERATION_STATUS_UNSPECIFIED = 0
    PENDING = 1
    RUNNING = 2
    DONE = 3

  acquireSsrsLeaseContext = _messages.MessageField('AcquireSsrsLeaseContext', 1)
  apiWarning = _messages.MessageField('ApiWarning', 2)
  backupContext = _messages.MessageField('BackupContext', 3)
  endTime = _messages.StringField(4)
  error = _messages.MessageField('OperationErrors', 5)
  exportContext = _messages.MessageField('ExportContext', 6)
  importContext = _messages.MessageField('ImportContext', 7)
  insertTime = _messages.StringField(8)
  kind = _messages.StringField(9)
  maintenanceType = _messages.EnumField('MaintenanceTypeValueValuesEnum', 10)
  name = _messages.StringField(11)
  operationType = _messages.EnumField('OperationTypeValueValuesEnum', 12)
  preCheckMajorVersionUpgradeContext = _messages.MessageField('PreCheckMajorVersionUpgradeContext', 13)
  selfLink = _messages.StringField(14)
  startTime = _messages.StringField(15)
  status = _messages.EnumField('StatusValueValuesEnum', 16)
  subOperationType = _messages.MessageField('SqlSubOperationType', 17)
  targetId = _messages.StringField(18)
  targetLink = _messages.StringField(19)
  targetProject = _messages.StringField(20)
  user = _messages.StringField(21)


class OperationError(_messages.Message):
  r"""Database instance operation error.

  Fields:
    code: Identifies the specific error that occurred.
    kind: This is always `sql#operationError`.
    message: Additional information about the error encountered.
  """

  code = _messages.StringField(1)
  kind = _messages.StringField(2)
  message = _messages.StringField(3)


class OperationErrors(_messages.Message):
  r"""Database instance operation errors list wrapper.

  Fields:
    errors: The list of errors encountered while processing this operation.
    kind: This is always `sql#operationErrors`.
  """

  errors = _messages.MessageField('OperationError', 1, repeated=True)
  kind = _messages.StringField(2)


class OperationMetadata(_messages.Message):
  r"""Represents the metadata of the long-running operation.

  Fields:
    apiVersion: Output only. API version used to start the operation.
    cancelRequested: Output only. Identifies whether the user has requested
      cancellation of the operation. Operations that have been cancelled
      successfully have google.longrunning.Operation.error value with a
      google.rpc.Status.code of `1`, corresponding to `Code.CANCELLED`.
    createTime: Output only. The time the operation was created.
    endTime: Output only. The time the operation finished running.
    statusDetail: Output only. Human-readable status of the operation, if any.
    target: Output only. Server-defined resource path for the target of the
      operation.
    verb: Output only. Name of the verb executed by the operation.
  """

  apiVersion = _messages.StringField(1)
  cancelRequested = _messages.BooleanField(2)
  createTime = _messages.StringField(3)
  endTime = _messages.StringField(4)
  statusDetail = _messages.StringField(5)
  target = _messages.StringField(6)
  verb = _messages.StringField(7)


class OperationsListResponse(_messages.Message):
  r"""Operations list response.

  Fields:
    items: List of operation resources.
    kind: This is always `sql#operationsList`.
    nextPageToken: The continuation token, used to page through large result
      sets. Provide this value in a subsequent request to return the next page
      of results.
    warnings: List of warnings that occurred while handling the request.
  """

  items = _messages.MessageField('Operation', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)
  warnings = _messages.MessageField('ApiWarning', 4, repeated=True)


class PasswordStatus(_messages.Message):
  r"""Read-only password status.

  Fields:
    locked: If true, user does not have login privileges.
    passwordExpirationTime: The expiration time of the current password.
  """

  locked = _messages.BooleanField(1)
  passwordExpirationTime = _messages.StringField(2)


class PasswordValidationPolicy(_messages.Message):
  r"""Database instance local user password validation policy. This message
  defines the password policy for local database users. When enabled, it
  enforces constraints on password complexity, length, and reuse. Keep this
  policy enabled to help prevent unauthorized access.

  Enums:
    ComplexityValueValuesEnum: The complexity of the password.

  Fields:
    complexity: The complexity of the password.
    disallowCompromisedCredentials: This field is deprecated and will be
      removed in a future version of the API.
    disallowUsernameSubstring: Disallow username as a part of the password.
    enablePasswordPolicy: Whether to enable the password policy or not. When
      enabled, passwords must meet complexity requirements. Keep this policy
      enabled to help prevent unauthorized access. Disabling this policy
      allows weak passwords.
    minLength: Minimum number of characters allowed.
    passwordChangeInterval: Minimum interval after which the password can be
      changed. This flag is only supported for PostgreSQL.
    reuseInterval: Number of previous passwords that cannot be reused.
  """

  class ComplexityValueValuesEnum(_messages.Enum):
    r"""The complexity of the password.

    Values:
      COMPLEXITY_UNSPECIFIED: Complexity check is not specified.
      COMPLEXITY_DEFAULT: A combination of lowercase, uppercase, numeric, and
        non-alphanumeric characters.
    """
    COMPLEXITY_UNSPECIFIED = 0
    COMPLEXITY_DEFAULT = 1

  complexity = _messages.EnumField('ComplexityValueValuesEnum', 1)
  disallowCompromisedCredentials = _messages.BooleanField(2)
  disallowUsernameSubstring = _messages.BooleanField(3)
  enablePasswordPolicy = _messages.BooleanField(4)
  minLength = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  passwordChangeInterval = _messages.StringField(6)
  reuseInterval = _messages.IntegerField(7, variant=_messages.Variant.INT32)


class PerformDiskShrinkContext(_messages.Message):
  r"""Perform disk shrink context.

  Fields:
    targetSizeGb: The target disk shrink size in GigaBytes.
  """

  targetSizeGb = _messages.IntegerField(1)


class PerformanceCaptureConfig(_messages.Message):
  r"""Performance Capture configuration.

  Fields:
    enabled: Optional. Enable or disable the Performance Capture.
    probeThreshold: Optional. The minimum number of consecutive readings above
      threshold that triggers instance state capture.
    probingIntervalSeconds: Optional. The time interval in seconds between any
      two probes.
    runningThreadsThreshold: Optional. The minimum number of server threads
      running to trigger the capture on primary.
    secondsBehindSourceThreshold: Optional. The minimum number of seconds
      replica must be lagging behind primary to trigger capture on replica.
    transactionDurationThreshold: Optional. The amount of time in seconds that
      a transaction needs to have been open before the watcher starts
      recording it.
  """

  enabled = _messages.BooleanField(1)
  probeThreshold = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  probingIntervalSeconds = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  runningThreadsThreshold = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  secondsBehindSourceThreshold = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  transactionDurationThreshold = _messages.IntegerField(6, variant=_messages.Variant.INT32)


class PointInTimeRestoreContext(_messages.Message):
  r"""Context to perform a point-in-time restore of an instance managed by
  Backup and Disaster Recovery (DR) Service.

  Fields:
    allocatedIpRange: Optional. The name of the allocated IP range for the
      internal IP Cloud SQL instance. For example: "google-managed-services-
      default". If you set this, then Cloud SQL creates the IP address for the
      cloned instance in the allocated range. This range must comply with [RFC
      1035](https://tools.ietf.org/html/rfc1035) standards. Specifically, the
      name must be 1-63 characters long and match the regular expression
      [a-z]([-a-z0-9]*[a-z0-9])?. Reserved for future use.
    databaseNames: Optional. (SQL Server only) Clone only the specified
      databases from the source instance. If you don't specify any databases,
      then Cloud SQL clones all databases for the instance.
    datasource: The Backup and Disaster Recovery (DR) Service Datasource URI.
      Format: projects/{project}/locations/{region}/backupVaults/{backupvault}
      /dataSources/{datasource}.
    pointInTime: Required. The date and time to which you want to restore the
      instance.
    preferredSecondaryZone: Optional. Point-in-time recovery of a regional
      instance in the specified zones. If not specified, clone to the same
      secondary zone as the source instance. This value cannot be the same as
      the preferred_zone field.
    preferredZone: Optional. Point-in-time recovery of an instance to the
      specified zone. If no zone is specified, then clone to the same primary
      zone as the source instance.
    privateNetwork: Optional. The resource link for the VPC network from which
      the Cloud SQL instance is accessible for private IP. For example,
      `/projects/myProject/global/networks/default`.
    sourceInstanceDeletionTime: The timestamp used to identify the time when
      the source instance is deleted. If this instance is deleted, then you
      must set the timestamp.
    targetInstance: Target instance name.
    targetInstanceClearSettingsFieldNames: Optional. Specifies the instance
      settings that will be cleared from the source instance. This field is
      only applicable for cross project PITRs.
    targetInstanceSettings: Optional. Specifies the instance settings that
      will be overridden from the source instance. This field is only
      applicable for cross project PITRs.
  """

  allocatedIpRange = _messages.StringField(1)
  databaseNames = _messages.StringField(2, repeated=True)
  datasource = _messages.StringField(3)
  pointInTime = _messages.StringField(4)
  preferredSecondaryZone = _messages.StringField(5)
  preferredZone = _messages.StringField(6)
  privateNetwork = _messages.StringField(7)
  sourceInstanceDeletionTime = _messages.StringField(8)
  targetInstance = _messages.StringField(9)
  targetInstanceClearSettingsFieldNames = _messages.StringField(10, repeated=True)
  targetInstanceSettings = _messages.MessageField('DatabaseInstance', 11)


class PoolNodeConfig(_messages.Message):
  r"""Details of a single read pool node of a read pool.

  Enums:
    StateValueValuesEnum: Output only. The current state of the read pool
      node.

  Fields:
    dnsName: Output only. The DNS name of the read pool node.
    dnsNames: Output only. The list of DNS names used by this read pool node.
    gceZone: Output only. The zone of the read pool node.
    ipAddresses: Output only. Mappings containing IP addresses that can be
      used to connect to the read pool node.
    name: Output only. The name of the read pool node, to be used for
      retrieving metrics and logs.
    pscAutoConnections: Output only. The list of settings for requested
      automatically-setup Private Service Connect (PSC) consumer endpoints
      that can be used to connect to this read pool node.
    pscServiceAttachmentLink: Output only. The Private Service Connect (PSC)
      service attachment of the read pool node.
    state: Output only. The current state of the read pool node.
  """

  class StateValueValuesEnum(_messages.Enum):
    r"""Output only. The current state of the read pool node.

    Values:
      SQL_INSTANCE_STATE_UNSPECIFIED: The state of the instance is unknown.
      RUNNABLE: The instance is running, or has been stopped by owner.
      SUSPENDED: The instance is not available, for example due to problems
        with billing.
      PENDING_DELETE: The instance is being deleted.
      PENDING_CREATE: The instance is being created.
      MAINTENANCE: The instance is down for maintenance.
      FAILED: The creation of the instance failed or a fatal error occurred
        during maintenance.
      ONLINE_MAINTENANCE: Deprecated
      REPAIRING: (Applicable to read pool nodes only.) The read pool node
        needs to be repaired. The database might be unavailable.
    """
    SQL_INSTANCE_STATE_UNSPECIFIED = 0
    RUNNABLE = 1
    SUSPENDED = 2
    PENDING_DELETE = 3
    PENDING_CREATE = 4
    MAINTENANCE = 5
    FAILED = 6
    ONLINE_MAINTENANCE = 7
    REPAIRING = 8

  dnsName = _messages.StringField(1)
  dnsNames = _messages.MessageField('DnsNameMapping', 2, repeated=True)
  gceZone = _messages.StringField(3)
  ipAddresses = _messages.MessageField('IpMapping', 4, repeated=True)
  name = _messages.StringField(5)
  pscAutoConnections = _messages.MessageField('PscAutoConnectionConfig', 6, repeated=True)
  pscServiceAttachmentLink = _messages.StringField(7)
  state = _messages.EnumField('StateValueValuesEnum', 8)


class PreCheckMajorVersionUpgradeContext(_messages.Message):
  r"""Pre-check major version upgrade context.

  Enums:
    TargetDatabaseVersionValueValuesEnum: Required. The target database
      version to upgrade to.

  Fields:
    kind: Optional. This is always `sql#preCheckMajorVersionUpgradeContext`.
    preCheckResponse: Output only. The responses from the precheck operation.
    targetDatabaseVersion: Required. The target database version to upgrade
      to.
  """

  class TargetDatabaseVersionValueValuesEnum(_messages.Enum):
    r"""Required. The target database version to upgrade to.

    Values:
      SQL_DATABASE_VERSION_UNSPECIFIED: This is an unknown database version.
      MYSQL_5_1: The database version is MySQL 5.1.
      MYSQL_5_5: The database version is MySQL 5.5.
      MYSQL_5_6: The database version is MySQL 5.6.
      MYSQL_5_7: The database version is MySQL 5.7.
      MYSQL_8_0: The database version is MySQL 8.
      MYSQL_8_0_18: The database major version is MySQL 8.0 and the minor
        version is 18.
      MYSQL_8_0_26: The database major version is MySQL 8.0 and the minor
        version is 26.
      MYSQL_8_0_27: The database major version is MySQL 8.0 and the minor
        version is 27.
      MYSQL_8_0_28: The database major version is MySQL 8.0 and the minor
        version is 28.
      MYSQL_8_0_29: The database major version is MySQL 8.0 and the minor
        version is 29.
      MYSQL_8_0_30: The database major version is MySQL 8.0 and the minor
        version is 30.
      MYSQL_8_0_31: The database major version is MySQL 8.0 and the minor
        version is 31.
      MYSQL_8_0_32: The database major version is MySQL 8.0 and the minor
        version is 32.
      MYSQL_8_0_33: The database major version is MySQL 8.0 and the minor
        version is 33.
      MYSQL_8_0_34: The database major version is MySQL 8.0 and the minor
        version is 34.
      MYSQL_8_0_35: The database major version is MySQL 8.0 and the minor
        version is 35.
      MYSQL_8_0_36: The database major version is MySQL 8.0 and the minor
        version is 36.
      MYSQL_8_0_37: The database major version is MySQL 8.0 and the minor
        version is 37.
      MYSQL_8_0_39: The database major version is MySQL 8.0 and the minor
        version is 39.
      MYSQL_8_0_40: The database major version is MySQL 8.0 and the minor
        version is 40.
      MYSQL_8_0_41: The database major version is MySQL 8.0 and the minor
        version is 41.
      MYSQL_8_0_42: The database major version is MySQL 8.0 and the minor
        version is 42.
      MYSQL_8_0_43: The database major version is MySQL 8.0 and the minor
        version is 43.
      MYSQL_8_0_44: The database major version is MySQL 8.0 and the minor
        version is 44.
      MYSQL_8_0_45: The database major version is MySQL 8.0 and the minor
        version is 45.
      MYSQL_8_0_46: The database major version is MySQL 8.0 and the minor
        version is 46.
      MYSQL_8_4: The database version is MySQL 8.4.
      MYSQL_9_7: The database version is MySQL 9.7.
      MYSQL_9_7_0: The database version is MySQL 9.7.0.
      MYSQL_9_7_1: The database version is MySQL 9.7.1.
      MYSQL_9_7_2: The database version is MySQL 9.7.2.
      MYSQL_9_7_3: The database version is MySQL 9.7.3.
      MYSQL_9_7_4: The database version is MySQL 9.7.4.
      MYSQL_9_7_5: The database version is MySQL 9.7.5.
      SQLSERVER_2017_STANDARD: The database version is SQL Server 2017
        Standard.
      SQLSERVER_2017_ENTERPRISE: The database version is SQL Server 2017
        Enterprise.
      SQLSERVER_2017_EXPRESS: The database version is SQL Server 2017 Express.
      SQLSERVER_2017_WEB: The database version is SQL Server 2017 Web.
      POSTGRES_9_6: The database version is PostgreSQL 9.6.
      POSTGRES_10: The database version is PostgreSQL 10.
      POSTGRES_11: The database version is PostgreSQL 11.
      POSTGRES_12: The database version is PostgreSQL 12.
      POSTGRES_13: The database version is PostgreSQL 13.
      POSTGRES_14: The database version is PostgreSQL 14.
      POSTGRES_15: The database version is PostgreSQL 15.
      POSTGRES_16: The database version is PostgreSQL 16.
      POSTGRES_17: The database version is PostgreSQL 17.
      POSTGRES_18: The database version is PostgreSQL 18.
      SQLSERVER_2019_STANDARD: The database version is SQL Server 2019
        Standard.
      SQLSERVER_2019_ENTERPRISE: The database version is SQL Server 2019
        Enterprise.
      SQLSERVER_2019_EXPRESS: The database version is SQL Server 2019 Express.
      SQLSERVER_2019_WEB: The database version is SQL Server 2019 Web.
      SQLSERVER_2022_STANDARD: The database version is SQL Server 2022
        Standard.
      SQLSERVER_2022_ENTERPRISE: The database version is SQL Server 2022
        Enterprise.
      SQLSERVER_2022_EXPRESS: The database version is SQL Server 2022 Express.
      SQLSERVER_2022_WEB: The database version is SQL Server 2022 Web.
    """
    SQL_DATABASE_VERSION_UNSPECIFIED = 0
    MYSQL_5_1 = 1
    MYSQL_5_5 = 2
    MYSQL_5_6 = 3
    MYSQL_5_7 = 4
    MYSQL_8_0 = 5
    MYSQL_8_0_18 = 6
    MYSQL_8_0_26 = 7
    MYSQL_8_0_27 = 8
    MYSQL_8_0_28 = 9
    MYSQL_8_0_29 = 10
    MYSQL_8_0_30 = 11
    MYSQL_8_0_31 = 12
    MYSQL_8_0_32 = 13
    MYSQL_8_0_33 = 14
    MYSQL_8_0_34 = 15
    MYSQL_8_0_35 = 16
    MYSQL_8_0_36 = 17
    MYSQL_8_0_37 = 18
    MYSQL_8_0_39 = 19
    MYSQL_8_0_40 = 20
    MYSQL_8_0_41 = 21
    MYSQL_8_0_42 = 22
    MYSQL_8_0_43 = 23
    MYSQL_8_0_44 = 24
    MYSQL_8_0_45 = 25
    MYSQL_8_0_46 = 26
    MYSQL_8_4 = 27
    MYSQL_9_7 = 28
    MYSQL_9_7_0 = 29
    MYSQL_9_7_1 = 30
    MYSQL_9_7_2 = 31
    MYSQL_9_7_3 = 32
    MYSQL_9_7_4 = 33
    MYSQL_9_7_5 = 34
    SQLSERVER_2017_STANDARD = 35
    SQLSERVER_2017_ENTERPRISE = 36
    SQLSERVER_2017_EXPRESS = 37
    SQLSERVER_2017_WEB = 38
    POSTGRES_9_6 = 39
    POSTGRES_10 = 40
    POSTGRES_11 = 41
    POSTGRES_12 = 42
    POSTGRES_13 = 43
    POSTGRES_14 = 44
    POSTGRES_15 = 45
    POSTGRES_16 = 46
    POSTGRES_17 = 47
    POSTGRES_18 = 48
    SQLSERVER_2019_STANDARD = 49
    SQLSERVER_2019_ENTERPRISE = 50
    SQLSERVER_2019_EXPRESS = 51
    SQLSERVER_2019_WEB = 52
    SQLSERVER_2022_STANDARD = 53
    SQLSERVER_2022_ENTERPRISE = 54
    SQLSERVER_2022_EXPRESS = 55
    SQLSERVER_2022_WEB = 56

  kind = _messages.StringField(1)
  preCheckResponse = _messages.MessageField('PreCheckResponse', 2, repeated=True)
  targetDatabaseVersion = _messages.EnumField('TargetDatabaseVersionValueValuesEnum', 3)


class PreCheckResponse(_messages.Message):
  r"""Structured PreCheckResponse containing message, type, and required
  actions.

  Enums:
    MessageTypeValueValuesEnum: The type of message whether it is an info,
      warning, or error.

  Fields:
    actionsRequired: The actions that the user needs to take. Use repeated for
      multiple actions.
    message: The message to be displayed to the user.
    messageType: The type of message whether it is an info, warning, or error.
  """

  class MessageTypeValueValuesEnum(_messages.Enum):
    r"""The type of message whether it is an info, warning, or error.

    Values:
      MESSAGE_TYPE_UNSPECIFIED: Default unspecified value to prevent
        unintended behavior changes.
      INFO: General informational messages that don't require action.
      WARNING: Warnings that might impact the upgrade but don't block it.
      ERROR: Errors that a user must resolve before proceeding with the
        upgrade.
    """
    MESSAGE_TYPE_UNSPECIFIED = 0
    INFO = 1
    WARNING = 2
    ERROR = 3

  actionsRequired = _messages.StringField(1, repeated=True)
  message = _messages.StringField(2)
  messageType = _messages.EnumField('MessageTypeValueValuesEnum', 3)


class PscAutoConnectionConfig(_messages.Message):
  r"""Settings for an automatically-setup Private Service Connect consumer
  endpoint that is used to connect to a Cloud SQL instance.

  Fields:
    consumerNetwork: Optional. The consumer network of this consumer endpoint.
      This must be a resource path that includes both the host project and the
      network name. For example, `projects/project1/global/networks/network1`.
      The consumer host project of this network might be different from the
      consumer service project.
    consumerNetworkStatus: The connection policy status of the consumer
      network.
    consumerProject: Optional. This is the project ID of consumer service
      project of this consumer endpoint. Optional. This is only applicable if
      consumer_network is a shared vpc network.
    ipAddress: The IP address of the consumer endpoint.
    status: The connection status of the consumer endpoint.
  """

  consumerNetwork = _messages.StringField(1)
  consumerNetworkStatus = _messages.StringField(2)
  consumerProject = _messages.StringField(3)
  ipAddress = _messages.StringField(4)
  status = _messages.StringField(5)


class PscConfig(_messages.Message):
  r"""PSC settings for a Cloud SQL instance.

  Fields:
    allowedConsumerProjects: Optional. The list of consumer projects that are
      allow-listed for PSC connections to this instance. This instance can be
      connected to with PSC from any network in these projects. Each consumer
      project in this list may be represented by a project number (numeric) or
      by a project id (alphanumeric).
    networkAttachmentUri: Optional. The network attachment of the consumer
      network that the Private Service Connect enabled Cloud SQL instance is
      authorized to connect via PSC interface. format:
      projects/PROJECT/regions/REGION/networkAttachments/ID
    pscAutoConnections: Optional. The list of settings for requested Private
      Service Connect consumer endpoints that can be used to connect to this
      Cloud SQL instance.
    pscEnabled: Whether PSC connectivity is enabled for this instance.
  """

  allowedConsumerProjects = _messages.StringField(1, repeated=True)
  networkAttachmentUri = _messages.StringField(2)
  pscAutoConnections = _messages.MessageField('PscAutoConnectionConfig', 3, repeated=True)
  pscEnabled = _messages.BooleanField(4)


class QueryResult(_messages.Message):
  r"""QueryResult contains the result of executing a single SQL statement.

  Fields:
    columns: List of columns included in the result. This also includes the
      data type of the column.
    message: Message related to the SQL execution result.
    partialResult: Set to true if the SQL execution's result is truncated due
      to size limits or an error retrieving results.
    rows: Rows returned by the SQL statement.
    status: If results were truncated due to an error, details of that error.
  """

  columns = _messages.MessageField('Column', 1, repeated=True)
  message = _messages.StringField(2)
  partialResult = _messages.BooleanField(3)
  rows = _messages.MessageField('Row', 4, repeated=True)
  status = _messages.MessageField('Status', 5)


class ReadPoolAutoScaleConfig(_messages.Message):
  r"""The read pool auto-scale configuration.

  Fields:
    disableScaleIn: Indicates whether read pool auto scaling supports scale in
      operations (removing nodes).
    enabled: Indicates whether read pool auto scaling is enabled.
    maxNodeCount: Maximum number of read pool nodes to be maintained.
    minNodeCount: Minimum number of read pool nodes to be maintained.
    scaleInCooldownSeconds: The cooldown period for scale in operations.
    scaleOutCooldownSeconds: The cooldown period for scale out operations.
    targetMetrics: Optional. Target metrics for read pool auto scaling.
  """

  disableScaleIn = _messages.BooleanField(1)
  enabled = _messages.BooleanField(2)
  maxNodeCount = _messages.IntegerField(3, variant=_messages.Variant.INT32)
  minNodeCount = _messages.IntegerField(4, variant=_messages.Variant.INT32)
  scaleInCooldownSeconds = _messages.IntegerField(5, variant=_messages.Variant.INT32)
  scaleOutCooldownSeconds = _messages.IntegerField(6, variant=_messages.Variant.INT32)
  targetMetrics = _messages.MessageField('TargetMetric', 7, repeated=True)


class ReplicaConfiguration(_messages.Message):
  r"""Read-replica configuration for connecting to the primary instance.

  Fields:
    cascadableReplica: Optional. Specifies if a SQL Server replica is a
      cascadable replica. A cascadable replica is a SQL Server cross region
      replica that supports replica(s) under it.
    failoverTarget: Specifies if the replica is the failover target. If the
      field is set to `true` the replica will be designated as a failover
      replica. In case the primary instance fails, the replica instance will
      be promoted as the new primary instance. Only one replica can be
      specified as failover target, and the replica has to be in different
      zone with the primary instance.
    kind: This is always `sql#replicaConfiguration`.
    mysqlReplicaConfiguration: MySQL specific configuration when replicating
      from a MySQL on-premises primary instance. Replication configuration
      information such as the username, password, certificates, and keys are
      not stored in the instance metadata. The configuration information is
      used only to set up the replication connection and is stored by MySQL in
      a file named `master.info` in the data directory.
  """

  cascadableReplica = _messages.BooleanField(1)
  failoverTarget = _messages.BooleanField(2)
  kind = _messages.StringField(3)
  mysqlReplicaConfiguration = _messages.MessageField('MySqlReplicaConfiguration', 4)


class ReplicationCluster(_messages.Message):
  r"""A primary instance and disaster recovery (DR) replica pair. A DR replica
  is a cross-region replica that you designate for failover in the event that
  the primary instance has regional failure. Applicable to MySQL and
  PostgreSQL.

  Fields:
    drReplica: Output only. Read-only field that indicates whether the replica
      is a DR replica. This field is not set if the instance is a primary
      instance.
    failoverDrReplicaName: Optional. If the instance is a primary instance,
      then this field identifies the disaster recovery (DR) replica. A DR
      replica is an optional configuration for Enterprise Plus edition
      instances. If the instance is a read replica, then the field is not set.
      Set this field to a replica name to designate a DR replica for a primary
      instance. Remove the replica name to remove the DR replica designation.
    psaWriteEndpoint: Output only. If set, this field indicates this instance
      has a private service access (PSA) DNS endpoint that is pointing to the
      primary instance of the cluster. If this instance is the primary, then
      the DNS endpoint points to this instance. After a switchover or replica
      failover operation, this DNS endpoint points to the promoted instance.
      This is a read-only field, returned to the user as information. This
      field can exist even if a standalone instance doesn't have a DR replica
      yet or the DR replica is deleted.
  """

  drReplica = _messages.BooleanField(1)
  failoverDrReplicaName = _messages.StringField(2)
  psaWriteEndpoint = _messages.StringField(3)


class Reschedule(_messages.Message):
  r"""A Reschedule object.

  Enums:
    RescheduleTypeValueValuesEnum: Required. The type of the reschedule.

  Fields:
    rescheduleType: Required. The type of the reschedule.
    scheduleTime: Optional. Timestamp when the maintenance shall be
      rescheduled to if reschedule_type=SPECIFIC_TIME, in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
  """

  class RescheduleTypeValueValuesEnum(_messages.Enum):
    r"""Required. The type of the reschedule.

    Values:
      RESCHEDULE_TYPE_UNSPECIFIED: <no description>
      IMMEDIATE: Reschedules maintenance to happen now (within 5 minutes).
      NEXT_AVAILABLE_WINDOW: Reschedules maintenance to occur within one week
        from the originally scheduled day and time.
      SPECIFIC_TIME: Reschedules maintenance to a specific time and day.
    """
    RESCHEDULE_TYPE_UNSPECIFIED = 0
    IMMEDIATE = 1
    NEXT_AVAILABLE_WINDOW = 2
    SPECIFIC_TIME = 3

  rescheduleType = _messages.EnumField('RescheduleTypeValueValuesEnum', 1)
  scheduleTime = _messages.StringField(2)


class RestoreBackupContext(_messages.Message):
  r"""Database instance restore from backup context. Backup context contains
  source instance id and project id.

  Fields:
    backupRunId: The ID of the backup run to restore from.
    instanceId: The ID of the instance that the backup was taken from.
    kind: This is always `sql#restoreBackupContext`.
    project: The full project ID of the source instance.
  """

  backupRunId = _messages.IntegerField(1)
  instanceId = _messages.StringField(2)
  kind = _messages.StringField(3)
  project = _messages.StringField(4)


class RotateEntraIdCertificateContext(_messages.Message):
  r"""Instance rotate Entra ID certificate context.

  Fields:
    kind: Optional. This is always `sql#rotateEntraIdCertificateContext`.
    nextVersion: Optional. The fingerprint of the next version to be rotated
      to. If left unspecified, will be rotated to the most recently added
      Entra ID certificate version.
  """

  kind = _messages.StringField(1)
  nextVersion = _messages.StringField(2)


class RotateServerCaContext(_messages.Message):
  r"""Instance rotate server CA context.

  Fields:
    kind: This is always `sql#rotateServerCaContext`.
    nextVersion: The fingerprint of the next version to be rotated to. If left
      unspecified, will be rotated to the most recently added server CA
      version.
  """

  kind = _messages.StringField(1)
  nextVersion = _messages.StringField(2)


class RotateServerCertificateContext(_messages.Message):
  r"""Instance rotate server certificate context.

  Fields:
    kind: Optional. This is always `sql#rotateServerCertificateContext`.
    nextVersion: Optional. The fingerprint of the next version to be rotated
      to. If left unspecified, will be rotated to the most recently added
      server certificate version.
  """

  kind = _messages.StringField(1)
  nextVersion = _messages.StringField(2)


class Row(_messages.Message):
  r"""Contains the values for a row.

  Fields:
    values: The values for the row.
  """

  values = _messages.MessageField('Value', 1, repeated=True)


class SelectedObjects(_messages.Message):
  r"""A list of objects that the user selects for replication from an external
  source instance.

  Fields:
    database: Required. The name of the database to migrate.
  """

  database = _messages.StringField(1)


class Settings(_messages.Message):
  r"""Database instance settings.

  Enums:
    ActivationPolicyValueValuesEnum: The activation policy specifies when the
      instance is activated; it is applicable only when the instance state is
      RUNNABLE. Valid values: * `ALWAYS`: The instance is on, and remains so
      even in the absence of connection requests. * `NEVER`: The instance is
      off; it is not activated, even if a connection request arrives.
    AvailabilityTypeValueValuesEnum: Availability type. Potential values: *
      `ZONAL`: The instance serves data from only one zone. Outages in that
      zone affect data accessibility. * `REGIONAL`: The instance can serve
      data from more than one zone in a region (it is highly available)./ For
      more information, see [Overview of the High Availability
      Configuration](https://cloud.google.com/sql/docs/mysql/high-
      availability).
    ConnectorEnforcementValueValuesEnum: Specifies if connections must use
      Cloud SQL connectors. Option values include the following:
      `NOT_REQUIRED` (Cloud SQL instances can be connected without Cloud SQL
      Connectors) and `REQUIRED` (Only allow connections that use Cloud SQL
      Connectors) Note that using REQUIRED disables all existing authorized
      networks. If this field is not specified when creating a new instance,
      NOT_REQUIRED is used. If this field is not specified when patching or
      updating an existing instance, it is left unchanged in the instance.
    DataApiAccessValueValuesEnum: This parameter controls whether to allow
      using ExecuteSql API to connect to the instance. Not allowed by default.
    DataDiskTypeValueValuesEnum: The type of data disk: `PD_SSD` (default) or
      `PD_HDD`. Not used for First Generation instances.
    EditionValueValuesEnum: Optional. The edition of the instance.
    PricingPlanValueValuesEnum: The pricing plan for this instance. This can
      be either `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second
      Generation instances.
    ReplicationTypeValueValuesEnum: The type of replication this instance
      uses. This can be either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated)
      This property was only applicable to First Generation instances.

  Messages:
    UserLabelsValue: User-provided labels, represented as a dictionary where
      each label is a single key value pair.

  Fields:
    acceleratedReplicaMode: Optional. Configuration to depict if the replica
      is accelerated.
    activationPolicy: The activation policy specifies when the instance is
      activated; it is applicable only when the instance state is RUNNABLE.
      Valid values: * `ALWAYS`: The instance is on, and remains so even in the
      absence of connection requests. * `NEVER`: The instance is off; it is
      not activated, even if a connection request arrives.
    activeDirectoryConfig: Active Directory configuration, relevant only for
      Cloud SQL for SQL Server.
    advancedMachineFeatures: Specifies advanced machine configuration for the
      instances relevant only for SQL Server.
    authorizedGaeApplications: The App Engine app IDs that can access this
      instance. (Deprecated) Applied to First Generation instances only.
    autoUpgradeEnabled: Optional. Cloud SQL for MySQL auto-upgrade
      configuration. When this parameter is set to true, auto-upgrade is
      enabled for MySQL 8.0 minor versions. The MySQL version must be 8.0.35
      or higher.
    availabilityType: Availability type. Potential values: * `ZONAL`: The
      instance serves data from only one zone. Outages in that zone affect
      data accessibility. * `REGIONAL`: The instance can serve data from more
      than one zone in a region (it is highly available)./ For more
      information, see [Overview of the High Availability
      Configuration](https://cloud.google.com/sql/docs/mysql/high-
      availability).
    backupConfiguration: The daily backup configuration for the instance.
    collation: The name of server Instance collation.
    connectionPoolConfig: Optional. The managed connection pooling
      configuration for the instance.
    connectorEnforcement: Specifies if connections must use Cloud SQL
      connectors. Option values include the following: `NOT_REQUIRED` (Cloud
      SQL instances can be connected without Cloud SQL Connectors) and
      `REQUIRED` (Only allow connections that use Cloud SQL Connectors) Note
      that using REQUIRED disables all existing authorized networks. If this
      field is not specified when creating a new instance, NOT_REQUIRED is
      used. If this field is not specified when patching or updating an
      existing instance, it is left unchanged in the instance.
    crashSafeReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether database flags for crash-safe replication
      are enabled. This property was only applicable to First Generation
      instances.
    dataApiAccess: This parameter controls whether to allow using ExecuteSql
      API to connect to the instance. Not allowed by default.
    dataCacheConfig: Configuration for data cache.
    dataDiskProvisionedIops: Optional. Provisioned number of I/O operations
      per second for the data disk. This field is only used for hyperdisk-
      balanced disk types.
    dataDiskProvisionedThroughput: Optional. Provisioned throughput measured
      in MiB per second for the data disk. This field is only used for
      hyperdisk-balanced disk types.
    dataDiskSizeGb: The size of data disk, in GB. The data disk size minimum
      is 10GB.
    dataDiskType: The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not
      used for First Generation instances.
    databaseFlags: The database flags passed to the instance at startup.
    databaseReplicationEnabled: Configuration specific to read replica
      instances. Indicates whether replication is enabled or not. WARNING:
      Changing this restarts the instance.
    dbAlignedAtomicWritesConfig: Optional. Database engine aligned atomic
      writes configuration.
    deletionProtectionEnabled: Configuration to protect against accidental
      instance deletion.
    denyMaintenancePeriods: Deny maintenance periods
    edition: Optional. The edition of the instance.
    enableDataplexIntegration: Optional. By default, Cloud SQL instances have
      schema extraction disabled for Dataplex. When this parameter is set to
      true, schema extraction for Dataplex on Cloud SQL instances is
      activated.
    enableGoogleMlIntegration: Optional. When this parameter is set to true,
      Cloud SQL instances can connect to Vertex AI to pass requests for real-
      time predictions and insights to the AI. The default value is false.
      This applies only to Cloud SQL for MySQL and Cloud SQL for PostgreSQL
      instances.
    entraidConfig: Optional. The Microsoft Entra ID configuration for the SQL
      Server instance.
    finalBackupConfig: Optional. The final backup configuration for the
      instance.
    insightsConfig: Insights configuration, for now relevant only for
      Postgres.
    instanceVersion: The current software version the instance is running on.
    ipConfiguration: The settings for IP Management. This allows to enable or
      disable the instance IP and manage which external networks can connect
      to the instance. The IPv4 address cannot be disabled for Second
      Generation instances.
    kind: This is always `sql#settings`.
    locationPreference: The location preference settings. This allows the
      instance to be located as near as possible to either an App Engine app
      or Compute Engine zone for better performance. App Engine co-location
      was only applicable to First Generation instances.
    maintenanceVersion: The current software version on the instance.
    maintenanceWindow: The maintenance window for this instance. This
      specifies when the instance can be restarted for maintenance purposes.
    passwordValidationPolicy: The local user password validation policy of the
      instance.
    performanceCaptureConfig: Optional. Configuration for Performance Capture,
      provides diagnostic metrics during high load situations.
    pricingPlan: The pricing plan for this instance. This can be either
      `PER_USE` or `PACKAGE`. Only `PER_USE` is supported for Second
      Generation instances.
    readPoolAutoScaleConfig: Optional. The read pool auto-scale configuration
      for the instance.
    recreateReplicasOnPrimaryCrash: Specifies if replicas should automatically
      be recreated on a MySQL primary instance crashes when it is operating in
      low durability mode.
    replicationLagMaxSeconds: Optional. Configuration value for recreation of
      replica after certain replication lag.
    replicationType: The type of replication this instance uses. This can be
      either `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was
      only applicable to First Generation instances.
    retainBackupsOnDelete: Optional. When this parameter is set to true, Cloud
      SQL retains backups of the instance even after the instance is deleted.
      The ON_DEMAND backup will be retained until customer deletes the backup
      or the project. The AUTOMATED backup will be retained based on the
      backups retention setting.
    settingsVersion: The version of instance settings. This is a required
      field for update method to make sure concurrent updates are handled
      properly. During update, use the most recent settingsVersion value for
      this instance and do not try to update this value.
    sqlServerAuditConfig: SQL Server specific audit configuration.
    storageAutoResize: Configuration to increase storage size automatically.
      The default value is true.
    storageAutoResizeLimit: The maximum size to which storage capacity can be
      automatically increased. The default value is 0, which specifies that
      there is no limit.
    tier: The tier (or machine type) for this instance, for example `db-
      custom-1-3840`. WARNING: Changing this restarts the instance.
    timeZone: Server timezone, relevant only for Cloud SQL for SQL Server.
    uncMappings: Optional. The UNC mapping for the instance, used for
      transactional replication. SQL Server only.
    userLabels: User-provided labels, represented as a dictionary where each
      label is a single key value pair.
  """

  class ActivationPolicyValueValuesEnum(_messages.Enum):
    r"""The activation policy specifies when the instance is activated; it is
    applicable only when the instance state is RUNNABLE. Valid values: *
    `ALWAYS`: The instance is on, and remains so even in the absence of
    connection requests. * `NEVER`: The instance is off; it is not activated,
    even if a connection request arrives.

    Values:
      SQL_ACTIVATION_POLICY_UNSPECIFIED: Unknown activation plan.
      ALWAYS: The instance is always up and running.
      NEVER: The instance never starts.
      ON_DEMAND: The instance starts upon receiving requests.
    """
    SQL_ACTIVATION_POLICY_UNSPECIFIED = 0
    ALWAYS = 1
    NEVER = 2
    ON_DEMAND = 3

  class AvailabilityTypeValueValuesEnum(_messages.Enum):
    r"""Availability type. Potential values: * `ZONAL`: The instance serves
    data from only one zone. Outages in that zone affect data accessibility. *
    `REGIONAL`: The instance can serve data from more than one zone in a
    region (it is highly available)./ For more information, see [Overview of
    the High Availability
    Configuration](https://cloud.google.com/sql/docs/mysql/high-availability).

    Values:
      SQL_AVAILABILITY_TYPE_UNSPECIFIED: This is an unknown Availability type.
      ZONAL: Zonal available instance.
      REGIONAL: Regional available instance.
    """
    SQL_AVAILABILITY_TYPE_UNSPECIFIED = 0
    ZONAL = 1
    REGIONAL = 2

  class ConnectorEnforcementValueValuesEnum(_messages.Enum):
    r"""Specifies if connections must use Cloud SQL connectors. Option values
    include the following: `NOT_REQUIRED` (Cloud SQL instances can be
    connected without Cloud SQL Connectors) and `REQUIRED` (Only allow
    connections that use Cloud SQL Connectors) Note that using REQUIRED
    disables all existing authorized networks. If this field is not specified
    when creating a new instance, NOT_REQUIRED is used. If this field is not
    specified when patching or updating an existing instance, it is left
    unchanged in the instance.

    Values:
      CONNECTOR_ENFORCEMENT_UNSPECIFIED: The requirement for Cloud SQL
        connectors is unknown.
      NOT_REQUIRED: Do not require Cloud SQL connectors.
      REQUIRED: Require all connections to use Cloud SQL connectors, including
        the Cloud SQL Auth Proxy and Cloud SQL Java, Python, and Go
        connectors. Note: This disables all existing authorized networks.
    """
    CONNECTOR_ENFORCEMENT_UNSPECIFIED = 0
    NOT_REQUIRED = 1
    REQUIRED = 2

  class DataApiAccessValueValuesEnum(_messages.Enum):
    r"""This parameter controls whether to allow using ExecuteSql API to
    connect to the instance. Not allowed by default.

    Values:
      DATA_API_ACCESS_UNSPECIFIED: Unspecified, effectively the same as
        `DISALLOW_DATA_API`.
      DISALLOW_DATA_API: Disallow using ExecuteSql API to connect to the
        instance.
      ALLOW_DATA_API: Allow using ExecuteSql API to connect to the instance.
        For private IP instances, this allows authorized users to access the
        instance from the public internet using ExecuteSql API.
    """
    DATA_API_ACCESS_UNSPECIFIED = 0
    DISALLOW_DATA_API = 1
    ALLOW_DATA_API = 2

  class DataDiskTypeValueValuesEnum(_messages.Enum):
    r"""The type of data disk: `PD_SSD` (default) or `PD_HDD`. Not used for
    First Generation instances.

    Values:
      SQL_DATA_DISK_TYPE_UNSPECIFIED: This is an unknown data disk type.
      PD_SSD: An SSD data disk.
      PD_HDD: An HDD data disk.
      OBSOLETE_LOCAL_SSD: This field is deprecated and will be removed from a
        future version of the API.
      HYPERDISK_BALANCED: A Hyperdisk Balanced data disk.
    """
    SQL_DATA_DISK_TYPE_UNSPECIFIED = 0
    PD_SSD = 1
    PD_HDD = 2
    OBSOLETE_LOCAL_SSD = 3
    HYPERDISK_BALANCED = 4

  class EditionValueValuesEnum(_messages.Enum):
    r"""Optional. The edition of the instance.

    Values:
      EDITION_UNSPECIFIED: The instance did not specify the edition.
      ENTERPRISE: The instance is an enterprise edition.
      ENTERPRISE_PLUS: The instance is an Enterprise Plus edition.
    """
    EDITION_UNSPECIFIED = 0
    ENTERPRISE = 1
    ENTERPRISE_PLUS = 2

  class PricingPlanValueValuesEnum(_messages.Enum):
    r"""The pricing plan for this instance. This can be either `PER_USE` or
    `PACKAGE`. Only `PER_USE` is supported for Second Generation instances.

    Values:
      SQL_PRICING_PLAN_UNSPECIFIED: This is an unknown pricing plan for this
        instance.
      PACKAGE: The instance is billed at a monthly flat rate.
      PER_USE: The instance is billed per usage.
    """
    SQL_PRICING_PLAN_UNSPECIFIED = 0
    PACKAGE = 1
    PER_USE = 2

  class ReplicationTypeValueValuesEnum(_messages.Enum):
    r"""The type of replication this instance uses. This can be either
    `ASYNCHRONOUS` or `SYNCHRONOUS`. (Deprecated) This property was only
    applicable to First Generation instances.

    Values:
      SQL_REPLICATION_TYPE_UNSPECIFIED: This is an unknown replication type
        for a Cloud SQL instance.
      SYNCHRONOUS: The synchronous replication mode for First Generation
        instances. It is the default value.
      ASYNCHRONOUS: The asynchronous replication mode for First Generation
        instances. It provides a slight performance gain, but if an outage
        occurs while this option is set to asynchronous, you can lose up to a
        few seconds of updates to your data.
    """
    SQL_REPLICATION_TYPE_UNSPECIFIED = 0
    SYNCHRONOUS = 1
    ASYNCHRONOUS = 2

  @encoding.MapUnrecognizedFields('additionalProperties')
  class UserLabelsValue(_messages.Message):
    r"""User-provided labels, represented as a dictionary where each label is
    a single key value pair.

    Messages:
      AdditionalProperty: An additional property for a UserLabelsValue object.

    Fields:
      additionalProperties: Additional properties of type UserLabelsValue
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a UserLabelsValue object.

      Fields:
        key: Name of the additional property.
        value: A string attribute.
      """

      key = _messages.StringField(1)
      value = _messages.StringField(2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  acceleratedReplicaMode = _messages.BooleanField(1)
  activationPolicy = _messages.EnumField('ActivationPolicyValueValuesEnum', 2)
  activeDirectoryConfig = _messages.MessageField('SqlActiveDirectoryConfig', 3)
  advancedMachineFeatures = _messages.MessageField('AdvancedMachineFeatures', 4)
  authorizedGaeApplications = _messages.StringField(5, repeated=True)
  autoUpgradeEnabled = _messages.BooleanField(6)
  availabilityType = _messages.EnumField('AvailabilityTypeValueValuesEnum', 7)
  backupConfiguration = _messages.MessageField('BackupConfiguration', 8)
  collation = _messages.StringField(9)
  connectionPoolConfig = _messages.MessageField('ConnectionPoolConfig', 10)
  connectorEnforcement = _messages.EnumField('ConnectorEnforcementValueValuesEnum', 11)
  crashSafeReplicationEnabled = _messages.BooleanField(12)
  dataApiAccess = _messages.EnumField('DataApiAccessValueValuesEnum', 13)
  dataCacheConfig = _messages.MessageField('DataCacheConfig', 14)
  dataDiskProvisionedIops = _messages.IntegerField(15)
  dataDiskProvisionedThroughput = _messages.IntegerField(16)
  dataDiskSizeGb = _messages.IntegerField(17)
  dataDiskType = _messages.EnumField('DataDiskTypeValueValuesEnum', 18)
  databaseFlags = _messages.MessageField('DatabaseFlags', 19, repeated=True)
  databaseReplicationEnabled = _messages.BooleanField(20)
  dbAlignedAtomicWritesConfig = _messages.MessageField('DbAlignedAtomicWritesConfig', 21)
  deletionProtectionEnabled = _messages.BooleanField(22)
  denyMaintenancePeriods = _messages.MessageField('DenyMaintenancePeriod', 23, repeated=True)
  edition = _messages.EnumField('EditionValueValuesEnum', 24)
  enableDataplexIntegration = _messages.BooleanField(25)
  enableGoogleMlIntegration = _messages.BooleanField(26)
  entraidConfig = _messages.MessageField('SqlServerEntraIdConfig', 27)
  finalBackupConfig = _messages.MessageField('FinalBackupConfig', 28)
  insightsConfig = _messages.MessageField('InsightsConfig', 29)
  instanceVersion = _messages.StringField(30)
  ipConfiguration = _messages.MessageField('IpConfiguration', 31)
  kind = _messages.StringField(32)
  locationPreference = _messages.MessageField('LocationPreference', 33)
  maintenanceVersion = _messages.StringField(34)
  maintenanceWindow = _messages.MessageField('MaintenanceWindow', 35)
  passwordValidationPolicy = _messages.MessageField('PasswordValidationPolicy', 36)
  performanceCaptureConfig = _messages.MessageField('PerformanceCaptureConfig', 37)
  pricingPlan = _messages.EnumField('PricingPlanValueValuesEnum', 38)
  readPoolAutoScaleConfig = _messages.MessageField('ReadPoolAutoScaleConfig', 39)
  recreateReplicasOnPrimaryCrash = _messages.BooleanField(40)
  replicationLagMaxSeconds = _messages.IntegerField(41, variant=_messages.Variant.INT32)
  replicationType = _messages.EnumField('ReplicationTypeValueValuesEnum', 42)
  retainBackupsOnDelete = _messages.BooleanField(43)
  settingsVersion = _messages.IntegerField(44)
  sqlServerAuditConfig = _messages.MessageField('SqlServerAuditConfig', 45)
  storageAutoResize = _messages.BooleanField(46)
  storageAutoResizeLimit = _messages.IntegerField(47)
  tier = _messages.StringField(48)
  timeZone = _messages.StringField(49)
  uncMappings = _messages.MessageField('UncMapping', 50, repeated=True)
  userLabels = _messages.MessageField('UserLabelsValue', 51)


class SqlActiveDirectoryConfig(_messages.Message):
  r"""Active Directory configuration, relevant only for Cloud SQL for SQL
  Server.

  Enums:
    ModeValueValuesEnum: Optional. The mode of the Active Directory
      configuration.

  Fields:
    adminCredentialSecretName: Optional. The secret manager key storing the
      administrator credential. (e.g., projects/{project}/secrets/{secret}).
    dnsServers: Optional. Domain controller IPv4 addresses used to bootstrap
      Active Directory.
    domain: The name of the domain (e.g., mydomain.com).
    kind: This is always sql#activeDirectoryConfig.
    mode: Optional. The mode of the Active Directory configuration.
    organizationalUnit: Optional. The organizational unit distinguished name.
      This is the full hierarchical path to the organizational unit.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. The mode of the Active Directory configuration.

    Values:
      ACTIVE_DIRECTORY_MODE_UNSPECIFIED: Unspecified mode.
      MANAGED_ACTIVE_DIRECTORY: Managed Active Directory mode. This is the
        fallback option to maintain backward compatibility.
      SELF_MANAGED_ACTIVE_DIRECTORY: Deprecated: Use
        CUSTOMER_MANAGED_ACTIVE_DIRECTORY instead.
      CUSTOMER_MANAGED_ACTIVE_DIRECTORY: Customer-managed Active Directory
        mode.
    """
    ACTIVE_DIRECTORY_MODE_UNSPECIFIED = 0
    MANAGED_ACTIVE_DIRECTORY = 1
    SELF_MANAGED_ACTIVE_DIRECTORY = 2
    CUSTOMER_MANAGED_ACTIVE_DIRECTORY = 3

  adminCredentialSecretName = _messages.StringField(1)
  dnsServers = _messages.StringField(2, repeated=True)
  domain = _messages.StringField(3)
  kind = _messages.StringField(4)
  mode = _messages.EnumField('ModeValueValuesEnum', 5)
  organizationalUnit = _messages.StringField(6)


class SqlBackupRunsDeleteRequest(_messages.Message):
  r"""A SqlBackupRunsDeleteRequest object.

  Fields:
    id: The ID of the backup run to delete. To find a backup run ID, use the
      [list](https://cloud.google.com/sql/docs/mysql/admin-
      api/rest/v1beta4/backupRuns/list) method.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsGetRequest(_messages.Message):
  r"""A SqlBackupRunsGetRequest object.

  Fields:
    id: The ID of this backup run.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  id = _messages.IntegerField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsInsertRequest(_messages.Message):
  r"""A SqlBackupRunsInsertRequest object.

  Fields:
    backupRun: A BackupRun resource to be passed as the request body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  backupRun = _messages.MessageField('BackupRun', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlBackupRunsListRequest(_messages.Message):
  r"""A SqlBackupRunsListRequest object.

  Fields:
    instance: Cloud SQL instance ID, or "-" for all instances. This does not
      include the project ID.
    maxResults: Maximum number of backup runs per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlBackupsCreateBackupRequest(_messages.Message):
  r"""A SqlBackupsCreateBackupRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    parent: Required. The parent resource where this backup is created.
      Format: projects/{project}
  """

  backup = _messages.MessageField('Backup', 1)
  parent = _messages.StringField(2, required=True)


class SqlBackupsDeleteBackupRequest(_messages.Message):
  r"""A SqlBackupsDeleteBackupRequest object.

  Fields:
    name: Required. The name of the backup to delete. Format:
      projects/{project}/backups/{backup}
  """

  name = _messages.StringField(1, required=True)


class SqlBackupsGetBackupRequest(_messages.Message):
  r"""A SqlBackupsGetBackupRequest object.

  Fields:
    name: Required. The name of the backup to retrieve. Format:
      projects/{project}/backups/{backup}
  """

  name = _messages.StringField(1, required=True)


class SqlBackupsListBackupsRequest(_messages.Message):
  r"""A SqlBackupsListBackupsRequest object.

  Fields:
    filter: Multiple filter queries are separated by spaces. For example,
      'instance:abc AND type:FINAL, 'location:us',
      'backupInterval.startTime>=1950-01-01T01:01:25.771Z'. You can filter by
      type, instance, backupInterval.startTime (creation time), or location.
    pageSize: The maximum number of backups to return per response. The
      service might return fewer backups than this value. If a value for this
      parameter isn't specified, then, at most, 500 backups are returned. The
      maximum value is 2,000. Any values that you set, which are greater than
      2,000, are changed to 2,000.
    pageToken: A page token, received from a previous `ListBackups` call.
      Provide this to retrieve the subsequent page. When paginating, all other
      parameters provided to `ListBackups` must match the call that provided
      the page token.
    parent: Required. The parent that owns this collection of backups. Format:
      projects/{project}
  """

  filter = _messages.StringField(1)
  pageSize = _messages.IntegerField(2, variant=_messages.Variant.INT32)
  pageToken = _messages.StringField(3)
  parent = _messages.StringField(4, required=True)


class SqlBackupsUpdateBackupRequest(_messages.Message):
  r"""A SqlBackupsUpdateBackupRequest object.

  Fields:
    backup: A Backup resource to be passed as the request body.
    name: Output only. The resource name of the backup. Format:
      projects/{project}/backups/{backup}.
    updateMask: The list of fields that you can update. You can update only
      the description and retention period of the final backup.
  """

  backup = _messages.MessageField('Backup', 1)
  name = _messages.StringField(2, required=True)
  updateMask = _messages.StringField(3)


class SqlConnectGenerateEphemeralRequest(_messages.Message):
  r"""A SqlConnectGenerateEphemeralRequest object.

  Fields:
    generateEphemeralCertRequest: A GenerateEphemeralCertRequest resource to
      be passed as the request body.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  generateEphemeralCertRequest = _messages.MessageField('GenerateEphemeralCertRequest', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlConnectGetRequest(_messages.Message):
  r"""A SqlConnectGetRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    readTime: Optional. Optional snapshot read timestamp to trade freshness
      for performance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  readTime = _messages.StringField(3)


class SqlDatabasesDeleteRequest(_messages.Message):
  r"""A SqlDatabasesDeleteRequest object.

  Fields:
    database: Name of the database to be deleted in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesGetRequest(_messages.Message):
  r"""A SqlDatabasesGetRequest object.

  Fields:
    database: Name of the database in the instance.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlDatabasesListRequest(_messages.Message):
  r"""A SqlDatabasesListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlDatabasesPatchRequest(_messages.Message):
  r"""A SqlDatabasesPatchRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlDatabasesUpdateRequest(_messages.Message):
  r"""A SqlDatabasesUpdateRequest object.

  Fields:
    database: Name of the database to be updated in the instance.
    databaseResource: A Database resource to be passed as the request body.
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  database = _messages.StringField(1, required=True)
  databaseResource = _messages.MessageField('Database', 2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlExternalSyncSettingError(_messages.Message):
  r"""External primary instance migration setting error/warning.

  Enums:
    TypeValueValuesEnum: Identifies the specific error that occurred.

  Fields:
    detail: Additional information about the error encountered.
    kind: Can be `sql#externalSyncSettingError` or
      `sql#externalSyncSettingWarning`.
    type: Identifies the specific error that occurred.
  """

  class TypeValueValuesEnum(_messages.Enum):
    r"""Identifies the specific error that occurred.

    Values:
      SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED: <no description>
      CONNECTION_FAILURE: <no description>
      BINLOG_NOT_ENABLED: <no description>
      INCOMPATIBLE_DATABASE_VERSION: <no description>
      REPLICA_ALREADY_SETUP: <no description>
      INSUFFICIENT_PRIVILEGE: The replication user is missing privileges that
        are required.
      UNSUPPORTED_MIGRATION_TYPE: Unsupported migration type.
      NO_PGLOGICAL_INSTALLED: No pglogical extension installed on databases,
        applicable for postgres.
      PGLOGICAL_NODE_ALREADY_EXISTS: pglogical node already exists on
        databases, applicable for postgres.
      INVALID_WAL_LEVEL: The value of parameter wal_level is not set to
        logical.
      INVALID_SHARED_PRELOAD_LIBRARY: The value of parameter
        shared_preload_libraries does not include pglogical.
      INSUFFICIENT_MAX_REPLICATION_SLOTS: The value of parameter
        max_replication_slots is not sufficient.
      INSUFFICIENT_MAX_WAL_SENDERS: The value of parameter max_wal_senders is
        not sufficient.
      INSUFFICIENT_MAX_WORKER_PROCESSES: The value of parameter
        max_worker_processes is not sufficient.
      UNSUPPORTED_EXTENSIONS: Extensions installed are either not supported or
        having unsupported versions
      INVALID_RDS_LOGICAL_REPLICATION: The value of parameter
        rds.logical_replication is not set to 1.
      INVALID_LOGGING_SETUP: The primary instance logging setup doesn't allow
        EM sync.
      INVALID_DB_PARAM: The primary instance database parameter setup doesn't
        allow EM sync.
      UNSUPPORTED_GTID_MODE: The gtid_mode is not supported, applicable for
        MySQL.
      SQLSERVER_AGENT_NOT_RUNNING: SQL Server Agent is not running.
      UNSUPPORTED_TABLE_DEFINITION: The table definition is not support due to
        missing primary key or replica identity, applicable for postgres. Note
        that this is a warning and won't block the migration.
      UNSUPPORTED_DEFINER: The customer has a definer that will break EM
        setup.
      SQLSERVER_SERVERNAME_MISMATCH: SQL Server @@SERVERNAME does not match
        actual host name.
      PRIMARY_ALREADY_SETUP: The primary instance has been setup and will fail
        the setup.
      UNSUPPORTED_BINLOG_FORMAT: The primary instance has unsupported binary
        log format.
      BINLOG_RETENTION_SETTING: The primary instance's binary log retention
        setting.
      UNSUPPORTED_STORAGE_ENGINE: The primary instance has tables with
        unsupported storage engine.
      LIMITED_SUPPORT_TABLES: Source has tables with limited support eg:
        PostgreSQL tables without primary keys.
      EXISTING_DATA_IN_REPLICA: The replica instance contains existing data.
      MISSING_OPTIONAL_PRIVILEGES: The replication user is missing privileges
        that are optional.
      RISKY_BACKUP_ADMIN_PRIVILEGE: Additional BACKUP_ADMIN privilege is
        granted to the replication user which may lock source MySQL 8 instance
        for DDLs during initial sync.
      INSUFFICIENT_GCS_PERMISSIONS: The Cloud Storage bucket is missing
        necessary permissions.
      INVALID_FILE_INFO: The Cloud Storage bucket has an error in the file or
        contains invalid file information.
      UNSUPPORTED_DATABASE_SETTINGS: The source instance has unsupported
        database settings for migration.
      MYSQL_PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE: The replication user is
        missing parallel import specific privileges. (e.g. LOCK TABLES) for
        MySQL.
      LOCAL_INFILE_OFF: The global variable local_infile is off on external
        server replica.
      TURN_ON_PITR_AFTER_PROMOTE: This code instructs customers to turn on
        point-in-time recovery manually for the instance after promoting the
        Cloud SQL for PostgreSQL instance.
      INCOMPATIBLE_DATABASE_MINOR_VERSION: The minor version of replica
        database is incompatible with the source.
      SOURCE_MAX_SUBSCRIPTIONS: This warning message indicates that Cloud SQL
        uses the maximum number of subscriptions to migrate data from the
        source to the destination.
      UNABLE_TO_VERIFY_DEFINERS: Unable to verify definers on the source for
        MySQL.
      SUBSCRIPTION_CALCULATION_STATUS: If a time out occurs while the
        subscription counts are calculated, then this value is set to 1.
        Otherwise, this value is set to 2.
      PG_SUBSCRIPTION_COUNT: Count of subscriptions needed to sync source data
        for PostgreSQL database.
      PG_SYNC_PARALLEL_LEVEL: Final parallel level that is used to do
        migration.
      INSUFFICIENT_DISK_SIZE: The disk size of the replica instance is smaller
        than the data size of the source instance.
      INSUFFICIENT_MACHINE_TIER: The data size of the source instance is
        greater than 1 TB, the number of cores of the replica instance is less
        than 8, and the memory of the replica is less than 32 GB.
      UNSUPPORTED_EXTENSIONS_NOT_MIGRATED: The warning message indicates the
        unsupported extensions will not be migrated to the destination.
      EXTENSIONS_NOT_MIGRATED: The warning message indicates the pg_cron
        extension and settings will not be migrated to the destination.
      PG_CRON_FLAG_ENABLED_IN_REPLICA: The error message indicates that
        pg_cron flags are enabled on the destination which is not supported
        during the migration.
      EXTENSIONS_NOT_ENABLED_IN_REPLICA: This error message indicates that the
        specified extensions are not enabled on destination instance. For
        example, before you can migrate data to the destination instance, you
        must enable the PGAudit extension on the instance.
      UNSUPPORTED_COLUMNS: The source database has generated columns that
        can't be migrated. Please change them to regular columns before
        migration.
      USERS_NOT_CREATED_IN_REPLICA: The source database has users that aren't
        created in the replica. First, create all users, which are in the
        pg_user_mappings table of the source database, in the destination
        instance. Then, perform the migration.
      UNSUPPORTED_SYSTEM_OBJECTS: The selected objects include system objects
        that aren't supported for migration.
      UNSUPPORTED_TABLES_WITH_REPLICA_IDENTITY: The source database has tables
        with the FULL or NOTHING replica identity. Before starting your
        migration, either remove the identity or change it to DEFAULT. Note
        that this is an error and will block the migration.
      SELECTED_OBJECTS_NOT_EXIST_ON_SOURCE: The selected objects don't exist
        on the source instance.
      PSC_ONLY_INSTANCE_WITH_NO_NETWORK_ATTACHMENT_URI: PSC only destination
        instance does not have a network attachment URI.
      SELECTED_OBJECTS_REFERENCE_UNSELECTED_OBJECTS: Selected objects
        reference unselected objects. Based on their object type (foreign key
        constraint or view), selected objects will fail during migration.
      PROMPT_DELETE_EXISTING: The migration will delete existing data in the
        replica; set replica_overwrite_enabled in the request to acknowledge
        this. This is an error. MySQL only.
      WILL_DELETE_EXISTING: The migration will delete existing data in the
        replica; replica_overwrite_enabled was set in the request
        acknowledging this. This is a warning rather than an error. MySQL
        only.
      PG_DDL_REPLICATION_INSUFFICIENT_PRIVILEGE: The replication user is
        missing specific privileges to setup DDL replication. (e.g. CREATE
        EVENT TRIGGER, CREATE SCHEMA) for PostgreSQL.
    """
    SQL_EXTERNAL_SYNC_SETTING_ERROR_TYPE_UNSPECIFIED = 0
    CONNECTION_FAILURE = 1
    BINLOG_NOT_ENABLED = 2
    INCOMPATIBLE_DATABASE_VERSION = 3
    REPLICA_ALREADY_SETUP = 4
    INSUFFICIENT_PRIVILEGE = 5
    UNSUPPORTED_MIGRATION_TYPE = 6
    NO_PGLOGICAL_INSTALLED = 7
    PGLOGICAL_NODE_ALREADY_EXISTS = 8
    INVALID_WAL_LEVEL = 9
    INVALID_SHARED_PRELOAD_LIBRARY = 10
    INSUFFICIENT_MAX_REPLICATION_SLOTS = 11
    INSUFFICIENT_MAX_WAL_SENDERS = 12
    INSUFFICIENT_MAX_WORKER_PROCESSES = 13
    UNSUPPORTED_EXTENSIONS = 14
    INVALID_RDS_LOGICAL_REPLICATION = 15
    INVALID_LOGGING_SETUP = 16
    INVALID_DB_PARAM = 17
    UNSUPPORTED_GTID_MODE = 18
    SQLSERVER_AGENT_NOT_RUNNING = 19
    UNSUPPORTED_TABLE_DEFINITION = 20
    UNSUPPORTED_DEFINER = 21
    SQLSERVER_SERVERNAME_MISMATCH = 22
    PRIMARY_ALREADY_SETUP = 23
    UNSUPPORTED_BINLOG_FORMAT = 24
    BINLOG_RETENTION_SETTING = 25
    UNSUPPORTED_STORAGE_ENGINE = 26
    LIMITED_SUPPORT_TABLES = 27
    EXISTING_DATA_IN_REPLICA = 28
    MISSING_OPTIONAL_PRIVILEGES = 29
    RISKY_BACKUP_ADMIN_PRIVILEGE = 30
    INSUFFICIENT_GCS_PERMISSIONS = 31
    INVALID_FILE_INFO = 32
    UNSUPPORTED_DATABASE_SETTINGS = 33
    MYSQL_PARALLEL_IMPORT_INSUFFICIENT_PRIVILEGE = 34
    LOCAL_INFILE_OFF = 35
    TURN_ON_PITR_AFTER_PROMOTE = 36
    INCOMPATIBLE_DATABASE_MINOR_VERSION = 37
    SOURCE_MAX_SUBSCRIPTIONS = 38
    UNABLE_TO_VERIFY_DEFINERS = 39
    SUBSCRIPTION_CALCULATION_STATUS = 40
    PG_SUBSCRIPTION_COUNT = 41
    PG_SYNC_PARALLEL_LEVEL = 42
    INSUFFICIENT_DISK_SIZE = 43
    INSUFFICIENT_MACHINE_TIER = 44
    UNSUPPORTED_EXTENSIONS_NOT_MIGRATED = 45
    EXTENSIONS_NOT_MIGRATED = 46
    PG_CRON_FLAG_ENABLED_IN_REPLICA = 47
    EXTENSIONS_NOT_ENABLED_IN_REPLICA = 48
    UNSUPPORTED_COLUMNS = 49
    USERS_NOT_CREATED_IN_REPLICA = 50
    UNSUPPORTED_SYSTEM_OBJECTS = 51
    UNSUPPORTED_TABLES_WITH_REPLICA_IDENTITY = 52
    SELECTED_OBJECTS_NOT_EXIST_ON_SOURCE = 53
    PSC_ONLY_INSTANCE_WITH_NO_NETWORK_ATTACHMENT_URI = 54
    SELECTED_OBJECTS_REFERENCE_UNSELECTED_OBJECTS = 55
    PROMPT_DELETE_EXISTING = 56
    WILL_DELETE_EXISTING = 57
    PG_DDL_REPLICATION_INSUFFICIENT_PRIVILEGE = 58

  detail = _messages.StringField(1)
  kind = _messages.StringField(2)
  type = _messages.EnumField('TypeValueValuesEnum', 3)


class SqlFlagsListRequest(_messages.Message):
  r"""A SqlFlagsListRequest object.

  Enums:
    FlagScopeValueValuesEnum: Optional. Specify the scope of flags to be
      returned by SqlFlagsListService. Return list of database flags if
      unspecified.

  Fields:
    databaseVersion: Database type and version you want to retrieve flags for.
      By default, this method returns flags for all database types and
      versions.
    flagScope: Optional. Specify the scope of flags to be returned by
      SqlFlagsListService. Return list of database flags if unspecified.
  """

  class FlagScopeValueValuesEnum(_messages.Enum):
    r"""Optional. Specify the scope of flags to be returned by
    SqlFlagsListService. Return list of database flags if unspecified.

    Values:
      SQL_FLAG_SCOPE_UNSPECIFIED: Assume database flags if unspecified
      SQL_FLAG_SCOPE_DATABASE: database flags
      SQL_FLAG_SCOPE_CONNECTION_POOL: connection pool configuration flags
    """
    SQL_FLAG_SCOPE_UNSPECIFIED = 0
    SQL_FLAG_SCOPE_DATABASE = 1
    SQL_FLAG_SCOPE_CONNECTION_POOL = 2

  databaseVersion = _messages.StringField(1)
  flagScope = _messages.EnumField('FlagScopeValueValuesEnum', 2)


class SqlInstancesAcquireSsrsLeaseRequest(_messages.Message):
  r"""A SqlInstancesAcquireSsrsLeaseRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This doesn't include the
      project ID. It's composed of lowercase letters, numbers, and hyphens,
      and it must start with a letter. The total length must be 98 characters
      or less (Example: instance-id).
    instancesAcquireSsrsLeaseRequest: A InstancesAcquireSsrsLeaseRequest
      resource to be passed as the request body.
    project: Required. ID of the project that contains the instance (Example:
      project-id).
  """

  instance = _messages.StringField(1, required=True)
  instancesAcquireSsrsLeaseRequest = _messages.MessageField('InstancesAcquireSsrsLeaseRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesAcquireSsrsLeaseResponse(_messages.Message):
  r"""Acquire SSRS lease response.

  Fields:
    operationId: The unique identifier for this operation.
  """

  operationId = _messages.StringField(1)


class SqlInstancesAddEntraIdCertificateRequest(_messages.Message):
  r"""A SqlInstancesAddEntraIdCertificateRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesAddReplicationSourceRequest(_messages.Message):
  r"""Instance add replication source request.

  Fields:
    replicationSource: Required. The name of the source metadata instance to
      add for replication.
  """

  replicationSource = _messages.StringField(1)


class SqlInstancesAddServerCaRequest(_messages.Message):
  r"""A SqlInstancesAddServerCaRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesAddServerCertificateRequest(_messages.Message):
  r"""A SqlInstancesAddServerCertificateRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesCloneRequest(_messages.Message):
  r"""A SqlInstancesCloneRequest object.

  Fields:
    instance: The ID of the Cloud SQL instance to be cloned (source). This
      does not include the project ID.
    instancesCloneRequest: A InstancesCloneRequest resource to be passed as
      the request body.
    project: Project ID of the source as well as the clone Cloud SQL instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesCloneRequest = _messages.MessageField('InstancesCloneRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesDeleteRequest(_messages.Message):
  r"""A SqlInstancesDeleteRequest object.

  Fields:
    enableFinalBackup: Flag to opt-in for final backup. By default, it is
      turned off.
    finalBackupDescription: Optional. The description of the final backup.
    finalBackupExpiryTime: Optional. Final Backup expiration time. Timestamp
      in UTC of when this resource is considered expired.
    finalBackupTtlDays: Optional. Retention period of the final backup.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      deleted.
    retainBackups: Flag to opt-in for keep all visible backups after deleting
      the instance. Currently, this only applies to the backups, the PITR
      Cloud Storage bucket is not retained yet. By default, it is turned off.
    retainBackupsExpiryTime: Expiration timestamp in UTC.
    retainBackupsTtlDays: Retention period in days.
    skipFinalBackup: Deprecated field, please use enable_final_backup.
  """

  enableFinalBackup = _messages.BooleanField(1)
  finalBackupDescription = _messages.StringField(2)
  finalBackupExpiryTime = _messages.StringField(3)
  finalBackupTtlDays = _messages.IntegerField(4)
  instance = _messages.StringField(5, required=True)
  project = _messages.StringField(6, required=True)
  retainBackups = _messages.BooleanField(7)
  retainBackupsExpiryTime = _messages.StringField(8)
  retainBackupsTtlDays = _messages.IntegerField(9)
  skipFinalBackup = _messages.BooleanField(10)


class SqlInstancesDemoteMasterRequest(_messages.Message):
  r"""A SqlInstancesDemoteMasterRequest object.

  Fields:
    instance: Cloud SQL instance name.
    instancesDemoteMasterRequest: A InstancesDemoteMasterRequest resource to
      be passed as the request body.
    project: ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesDemoteMasterRequest = _messages.MessageField('InstancesDemoteMasterRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesDemoteRequest(_messages.Message):
  r"""A SqlInstancesDemoteRequest object.

  Fields:
    instance: Required. The name of the Cloud SQL instance.
    instancesDemoteRequest: A InstancesDemoteRequest resource to be passed as
      the request body.
    project: Required. The project ID of the project that contains the
      instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesDemoteRequest = _messages.MessageField('InstancesDemoteRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesExecuteSqlRequest(_messages.Message):
  r"""A SqlInstancesExecuteSqlRequest object.

  Fields:
    executeSqlPayload: A ExecuteSqlPayload resource to be passed as the
      request body.
    instance: Required. Database instance ID. This does not include the
      project ID.
    project: Required. Project ID of the project that contains the instance.
  """

  executeSqlPayload = _messages.MessageField('ExecuteSqlPayload', 1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesExecuteSqlResponse(_messages.Message):
  r"""Execute SQL statements response.

  Fields:
    columns: Deprecated field. Use results.columns instead.
    formattedRows: Deprecated field. If output format was set to JSON, then
      this field will contain the response in JSON format.
    message: Deprecated field. Use results.message instead.
    messages: A list of notices and warnings generated during query execution.
      For PostgreSQL, this includes all notices and warnings. For MySQL, this
      includes warnings generated by the last executed statement. To retrieve
      all warnings for a multi-statement query, `SHOW WARNINGS` must be
      executed after each statement.
    metadata: The additional metadata information regarding the execution of
      the SQL statements.
    partialResult: Deprecated field. Use results.partial_result instead.
    results: The list of results after executing all the SQL statements.
    rows: Deprecated field. Use results.rows instead.
    status: Contains the error from the database if the SQL execution failed.
  """

  columns = _messages.MessageField('Column', 1, repeated=True)
  formattedRows = _messages.StringField(2)
  message = _messages.StringField(3)
  messages = _messages.MessageField('Message', 4, repeated=True)
  metadata = _messages.MessageField('Metadata', 5)
  partialResult = _messages.BooleanField(6)
  results = _messages.MessageField('QueryResult', 7, repeated=True)
  rows = _messages.MessageField('Row', 8, repeated=True)
  status = _messages.MessageField('Status', 9)


class SqlInstancesExportRequest(_messages.Message):
  r"""A SqlInstancesExportRequest object.

  Fields:
    instance: The Cloud SQL instance ID. This doesn't include the project ID.
    instancesExportRequest: A InstancesExportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance to be
      exported.
  """

  instance = _messages.StringField(1, required=True)
  instancesExportRequest = _messages.MessageField('InstancesExportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesFailoverRequest(_messages.Message):
  r"""A SqlInstancesFailoverRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesFailoverRequest: A InstancesFailoverRequest resource to be passed
      as the request body.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  instancesFailoverRequest = _messages.MessageField('InstancesFailoverRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesGetDiskShrinkConfigResponse(_messages.Message):
  r"""Instance get disk shrink config response.

  Fields:
    kind: This is always `sql#getDiskShrinkConfig`.
    message: Additional message to customers.
    minimalTargetSizeGb: The minimum size to which a disk can be shrunk in
      GigaBytes.
  """

  kind = _messages.StringField(1)
  message = _messages.StringField(2)
  minimalTargetSizeGb = _messages.IntegerField(3)


class SqlInstancesGetLatestRecoveryTimeResponse(_messages.Message):
  r"""Instance get latest recovery time response.

  Fields:
    earliestRecoveryTime: Timestamp, identifies the earliest recovery time of
      the source instance.
    kind: This is always `sql#getLatestRecoveryTime`.
    latestRecoveryTime: Timestamp, identifies the latest recovery time of the
      source instance.
  """

  earliestRecoveryTime = _messages.StringField(1)
  kind = _messages.StringField(2)
  latestRecoveryTime = _messages.StringField(3)


class SqlInstancesGetRequest(_messages.Message):
  r"""A SqlInstancesGetRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesImportRequest(_messages.Message):
  r"""A SqlInstancesImportRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesImportRequest: A InstancesImportRequest resource to be passed as
      the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesImportRequest = _messages.MessageField('InstancesImportRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesInsertRequest(_messages.Message):
  r"""A SqlInstancesInsertRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    project: Project ID of the project to which the newly created Cloud SQL
      instances should belong.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  project = _messages.StringField(2, required=True)


class SqlInstancesListEntraIdCertificatesRequest(_messages.Message):
  r"""A SqlInstancesListEntraIdCertificatesRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesListRequest(_messages.Message):
  r"""A SqlInstancesListRequest object.

  Fields:
    filter: A filter expression that filters resources listed in the response.
      The expression is in the form of field:value. For example,
      'instanceType:CLOUD_SQL_INSTANCE'. Fields can be nested as needed as per
      their JSON representation, such as
      'settings.userLabels.auto_start:true'. Multiple filter queries are
      space-separated. For example. 'state:RUNNABLE
      instanceType:CLOUD_SQL_INSTANCE'. By default, each expression is an AND
      expression. However, you can include AND and OR expressions explicitly.
    maxResults: The maximum number of instances to return. The service may
      return fewer than this value. If unspecified, at most 500 instances are
      returned. The maximum value is 1000; values above 1000 are coerced to
      1000.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project for which to list Cloud SQL instances.
  """

  filter = _messages.StringField(1)
  maxResults = _messages.IntegerField(2, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlInstancesListServerCasRequest(_messages.Message):
  r"""A SqlInstancesListServerCasRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesListServerCertificatesRequest(_messages.Message):
  r"""A SqlInstancesListServerCertificatesRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesPatchRequest(_messages.Message):
  r"""A SqlInstancesPatchRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    enforcePsaWriteEndpoint: Optional. Deprecated field. Set PSA network to
      the same value as existing network to force DNS write endpoint
      configuration.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  enforcePsaWriteEndpoint = _messages.BooleanField(2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlInstancesPointInTimeRestoreRequest(_messages.Message):
  r"""A SqlInstancesPointInTimeRestoreRequest object.

  Fields:
    parent: Required. The parent resource where you created this instance.
      Format: projects/{project}
    pointInTimeRestoreContext: A PointInTimeRestoreContext resource to be
      passed as the request body.
  """

  parent = _messages.StringField(1, required=True)
  pointInTimeRestoreContext = _messages.MessageField('PointInTimeRestoreContext', 2)


class SqlInstancesPreCheckMajorVersionUpgradeRequest(_messages.Message):
  r"""A SqlInstancesPreCheckMajorVersionUpgradeRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    instancesPreCheckMajorVersionUpgradeRequest: A
      InstancesPreCheckMajorVersionUpgradeRequest resource to be passed as the
      request body.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesPreCheckMajorVersionUpgradeRequest = _messages.MessageField('InstancesPreCheckMajorVersionUpgradeRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesPromoteReplicaRequest(_messages.Message):
  r"""A SqlInstancesPromoteReplicaRequest object.

  Fields:
    failover: Set to true to invoke a replica failover to the DR replica. As
      part of replica failover, the promote operation attempts to add the
      original primary instance as a replica of the promoted DR replica when
      the original primary instance comes back online. If set to false or not
      specified, then the original primary instance becomes an independent
      Cloud SQL primary instance.
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  failover = _messages.BooleanField(1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesReencryptRequest(_messages.Message):
  r"""A SqlInstancesReencryptRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesReencryptRequest: A InstancesReencryptRequest resource to be
      passed as the request body.
    project: ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesReencryptRequest = _messages.MessageField('InstancesReencryptRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesReleaseSsrsLeaseRequest(_messages.Message):
  r"""A SqlInstancesReleaseSsrsLeaseRequest object.

  Fields:
    instance: Required. The Cloud SQL instance ID. This doesn't include the
      project ID. It's composed of lowercase letters, numbers, and hyphens,
      and it must start with a letter. The total length must be 98 characters
      or less (Example: instance-id).
    project: Required. The ID of the project that contains the instance
      (Example: project-id).
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesReleaseSsrsLeaseResponse(_messages.Message):
  r"""The response for the release of the SSRS lease.

  Fields:
    operationId: The operation ID.
  """

  operationId = _messages.StringField(1)


class SqlInstancesRemoveReplicationSourceRequest(_messages.Message):
  r"""Instance remove replication source request.

  Fields:
    replicationSource: Required. The name of the source metadata instance to
      remove from replication.
  """

  replicationSource = _messages.StringField(1)


class SqlInstancesRescheduleMaintenanceRequestBody(_messages.Message):
  r"""Reschedule options for maintenance windows.

  Fields:
    reschedule: Required. The type of the reschedule the user wants.
  """

  reschedule = _messages.MessageField('Reschedule', 1)


class SqlInstancesResetReplicaSizeRequest(_messages.Message):
  r"""Instance reset replica size request.

  Fields:
    forceReduceDataDiskPerformance: Optional. Flag to force reduce data disk
      performance if it will be invalidated by replica disk shrink.
  """

  forceReduceDataDiskPerformance = _messages.BooleanField(1)


class SqlInstancesResetSslConfigRequest(_messages.Message):
  r"""A SqlInstancesResetSslConfigRequest object.

  Enums:
    ModeValueValuesEnum: Optional. Reset SSL mode to use.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    mode: Optional. Reset SSL mode to use.
    project: Project ID of the project that contains the instance.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""Optional. Reset SSL mode to use.

    Values:
      RESET_SSL_MODE_UNSPECIFIED: Reset SSL mode is not specified.
      ALL: Refresh all TLS configs. This is the default behaviour.
      SYNC_FROM_PRIMARY: Refreshes the replication-related TLS configuration
        settings provided by the primary instance. Not applicable to on-
        premises replication instances.
    """
    RESET_SSL_MODE_UNSPECIFIED = 0
    ALL = 1
    SYNC_FROM_PRIMARY = 2

  instance = _messages.StringField(1, required=True)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesRestartRequest(_messages.Message):
  r"""A SqlInstancesRestartRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance to be
      restarted.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesRestoreBackupRequest(_messages.Message):
  r"""A SqlInstancesRestoreBackupRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesRestoreBackupRequest: A InstancesRestoreBackupRequest resource to
      be passed as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRestoreBackupRequest = _messages.MessageField('InstancesRestoreBackupRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesRotateEntraIdCertificateRequest(_messages.Message):
  r"""A SqlInstancesRotateEntraIdCertificateRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    instancesRotateEntraIdCertificateRequest: A
      InstancesRotateEntraIdCertificateRequest resource to be passed as the
      request body.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRotateEntraIdCertificateRequest = _messages.MessageField('InstancesRotateEntraIdCertificateRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesRotateServerCaRequest(_messages.Message):
  r"""A SqlInstancesRotateServerCaRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesRotateServerCaRequest: A InstancesRotateServerCaRequest resource
      to be passed as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRotateServerCaRequest = _messages.MessageField('InstancesRotateServerCaRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesRotateServerCertificateRequest(_messages.Message):
  r"""A SqlInstancesRotateServerCertificateRequest object.

  Fields:
    instance: Required. Cloud SQL instance ID. This does not include the
      project ID.
    instancesRotateServerCertificateRequest: A
      InstancesRotateServerCertificateRequest resource to be passed as the
      request body.
    project: Required. Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  instancesRotateServerCertificateRequest = _messages.MessageField('InstancesRotateServerCertificateRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesStartExternalSyncRequest(_messages.Message):
  r"""A SqlInstancesStartExternalSyncRequest object.

  Enums:
    MigrationTypeValueValuesEnum: Optional. MigrationType configures the
      migration to use physical files or logical dump files. If not set, then
      the logical dump file configuration is used. Valid values are `LOGICAL`
      or `PHYSICAL`. Only applicable to MySQL.
    SyncModeValueValuesEnum: External sync mode.
    SyncParallelLevelValueValuesEnum: Optional. Parallel level for initial
      data sync. Currently only applicable for MySQL.

  Fields:
    migrationType: Optional. MigrationType configures the migration to use
      physical files or logical dump files. If not set, then the logical dump
      file configuration is used. Valid values are `LOGICAL` or `PHYSICAL`.
      Only applicable to MySQL.
    mysqlSyncConfig: MySQL-specific settings for start external sync.
    replicaOverwriteEnabled: Optional. MySQL only. True if end-user has
      confirmed that this SES call will wipe replica databases overlapping
      with the proposed selected_objects. If this field is not set and there
      are both overlapping and additional databases proposed, an error will be
      returned.
    skipVerification: Whether to skip the verification step (VESS).
    syncMode: External sync mode.
    syncParallelLevel: Optional. Parallel level for initial data sync.
      Currently only applicable for MySQL.
  """

  class MigrationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. MigrationType configures the migration to use physical files
    or logical dump files. If not set, then the logical dump file
    configuration is used. Valid values are `LOGICAL` or `PHYSICAL`. Only
    applicable to MySQL.

    Values:
      MIGRATION_TYPE_UNSPECIFIED: Default value is a logical dump file-based
        migration
      LOGICAL: Logical dump file-based migration
      PHYSICAL: Physical file-based migration
    """
    MIGRATION_TYPE_UNSPECIFIED = 0
    LOGICAL = 1
    PHYSICAL = 2

  class SyncModeValueValuesEnum(_messages.Enum):
    r"""External sync mode.

    Values:
      EXTERNAL_SYNC_MODE_UNSPECIFIED: Unknown external sync mode, will be
        defaulted to ONLINE mode
      ONLINE: Online external sync will set up replication after initial data
        external sync
      OFFLINE: Offline external sync only dumps and loads a one-time snapshot
        of the primary instance's data
    """
    EXTERNAL_SYNC_MODE_UNSPECIFIED = 0
    ONLINE = 1
    OFFLINE = 2

  class SyncParallelLevelValueValuesEnum(_messages.Enum):
    r"""Optional. Parallel level for initial data sync. Currently only
    applicable for MySQL.

    Values:
      EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED: Unknown sync parallel level.
        Will be defaulted to OPTIMAL.
      MIN: Minimal parallel level.
      OPTIMAL: Optimal parallel level.
      MAX: Maximum parallel level.
    """
    EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED = 0
    MIN = 1
    OPTIMAL = 2
    MAX = 3

  migrationType = _messages.EnumField('MigrationTypeValueValuesEnum', 1)
  mysqlSyncConfig = _messages.MessageField('MySqlSyncConfig', 2)
  replicaOverwriteEnabled = _messages.BooleanField(3)
  skipVerification = _messages.BooleanField(4)
  syncMode = _messages.EnumField('SyncModeValueValuesEnum', 5)
  syncParallelLevel = _messages.EnumField('SyncParallelLevelValueValuesEnum', 6)


class SqlInstancesStartReplicaRequest(_messages.Message):
  r"""A SqlInstancesStartReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesStopReplicaRequest(_messages.Message):
  r"""A SqlInstancesStopReplicaRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlInstancesSwitchoverRequest(_messages.Message):
  r"""A SqlInstancesSwitchoverRequest object.

  Fields:
    dbTimeout: Optional. (MySQL and PostgreSQL only) Cloud SQL instance
      operations timeout, which is a sum of all database operations. Default
      value is 10 minutes and can be modified to a maximum value of 24 hours.
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the replica.
  """

  dbTimeout = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  project = _messages.StringField(3, required=True)


class SqlInstancesTruncateLogRequest(_messages.Message):
  r"""A SqlInstancesTruncateLogRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    instancesTruncateLogRequest: A InstancesTruncateLogRequest resource to be
      passed as the request body.
    project: Project ID of the Cloud SQL project.
  """

  instance = _messages.StringField(1, required=True)
  instancesTruncateLogRequest = _messages.MessageField('InstancesTruncateLogRequest', 2)
  project = _messages.StringField(3, required=True)


class SqlInstancesUpdateRequest(_messages.Message):
  r"""A SqlInstancesUpdateRequest object.

  Fields:
    databaseInstance: A DatabaseInstance resource to be passed as the request
      body.
    enforcePsaWriteEndpoint: Optional. Deprecated field. Set PSA network to
      the same value as existing network to force DNS write endpoint
      configuration.
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  databaseInstance = _messages.MessageField('DatabaseInstance', 1)
  enforcePsaWriteEndpoint = _messages.BooleanField(2)
  instance = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlInstancesVerifyExternalSyncSettingsRequest(_messages.Message):
  r"""A SqlInstancesVerifyExternalSyncSettingsRequest object.

  Enums:
    MigrationTypeValueValuesEnum: Optional. MigrationType configures the
      migration to use physical files or logical dump files. If not set, then
      the logical dump file configuration is used. Valid values are `LOGICAL`
      or `PHYSICAL`. Only applicable to MySQL.
    SyncModeValueValuesEnum: External sync mode
    SyncParallelLevelValueValuesEnum: Optional. Parallel level for initial
      data sync. Only applicable for PostgreSQL.

  Fields:
    migrationType: Optional. MigrationType configures the migration to use
      physical files or logical dump files. If not set, then the logical dump
      file configuration is used. Valid values are `LOGICAL` or `PHYSICAL`.
      Only applicable to MySQL.
    mysqlSyncConfig: Optional. MySQL-specific settings for start external
      sync.
    selectedObjects: Optional. Migrate only the specified objects from the
      source instance. If this field is empty, then migrate all objects.
    syncMode: External sync mode
    syncParallelLevel: Optional. Parallel level for initial data sync. Only
      applicable for PostgreSQL.
    verifyConnectionOnly: Flag to enable verifying connection only
    verifyReplicationOnly: Optional. Flag to verify settings required by
      replication setup only
  """

  class MigrationTypeValueValuesEnum(_messages.Enum):
    r"""Optional. MigrationType configures the migration to use physical files
    or logical dump files. If not set, then the logical dump file
    configuration is used. Valid values are `LOGICAL` or `PHYSICAL`. Only
    applicable to MySQL.

    Values:
      MIGRATION_TYPE_UNSPECIFIED: Default value is a logical dump file-based
        migration
      LOGICAL: Logical dump file-based migration
      PHYSICAL: Physical file-based migration
    """
    MIGRATION_TYPE_UNSPECIFIED = 0
    LOGICAL = 1
    PHYSICAL = 2

  class SyncModeValueValuesEnum(_messages.Enum):
    r"""External sync mode

    Values:
      EXTERNAL_SYNC_MODE_UNSPECIFIED: Unknown external sync mode, will be
        defaulted to ONLINE mode
      ONLINE: Online external sync will set up replication after initial data
        external sync
      OFFLINE: Offline external sync only dumps and loads a one-time snapshot
        of the primary instance's data
    """
    EXTERNAL_SYNC_MODE_UNSPECIFIED = 0
    ONLINE = 1
    OFFLINE = 2

  class SyncParallelLevelValueValuesEnum(_messages.Enum):
    r"""Optional. Parallel level for initial data sync. Only applicable for
    PostgreSQL.

    Values:
      EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED: Unknown sync parallel level.
        Will be defaulted to OPTIMAL.
      MIN: Minimal parallel level.
      OPTIMAL: Optimal parallel level.
      MAX: Maximum parallel level.
    """
    EXTERNAL_SYNC_PARALLEL_LEVEL_UNSPECIFIED = 0
    MIN = 1
    OPTIMAL = 2
    MAX = 3

  migrationType = _messages.EnumField('MigrationTypeValueValuesEnum', 1)
  mysqlSyncConfig = _messages.MessageField('MySqlSyncConfig', 2)
  selectedObjects = _messages.MessageField('ExternalSyncSelectedObject', 3, repeated=True)
  syncMode = _messages.EnumField('SyncModeValueValuesEnum', 4)
  syncParallelLevel = _messages.EnumField('SyncParallelLevelValueValuesEnum', 5)
  verifyConnectionOnly = _messages.BooleanField(6)
  verifyReplicationOnly = _messages.BooleanField(7)


class SqlInstancesVerifyExternalSyncSettingsResponse(_messages.Message):
  r"""Instance verify external sync settings response.

  Fields:
    errors: List of migration violations.
    kind: This is always `sql#migrationSettingErrorList`.
    warnings: List of migration warnings.
  """

  errors = _messages.MessageField('SqlExternalSyncSettingError', 1, repeated=True)
  kind = _messages.StringField(2)
  warnings = _messages.MessageField('SqlExternalSyncSettingError', 3, repeated=True)


class SqlOperationsCancelRequest(_messages.Message):
  r"""A SqlOperationsCancelRequest object.

  Fields:
    operation: Instance operation ID.
    project: Project ID of the project that contains the instance.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlOperationsGetRequest(_messages.Message):
  r"""A SqlOperationsGetRequest object.

  Fields:
    operation: Instance operation ID.
    project: Project ID of the project that contains the instance.
  """

  operation = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlOperationsListRequest(_messages.Message):
  r"""A SqlOperationsListRequest object.

  Fields:
    filter: Optional. A filter string that follows the rules of EBNF grammar
      (https://google.aip.dev/assets/misc/ebnf-filtering.txt). Cloud SQL
      provides filters for status, operationType, and startTime.
    instance: Cloud SQL instance ID. This does not include the project ID.
    maxResults: Maximum number of operations per response.
    pageToken: A previously-returned page token representing part of the
      larger set of results to view.
    project: Project ID of the project that contains the instance.
  """

  filter = _messages.StringField(1)
  instance = _messages.StringField(2)
  maxResults = _messages.IntegerField(3, variant=_messages.Variant.UINT32)
  pageToken = _messages.StringField(4)
  project = _messages.StringField(5, required=True)


class SqlOutOfDiskReport(_messages.Message):
  r"""This message wraps up the information written by out-of-disk detection
  job.

  Enums:
    SqlOutOfDiskStateValueValuesEnum: This field represents the state
      generated by the proactive database wellness job for OutOfDisk issues. *
      Writers: * the proactive database wellness job for OOD. * Readers: * the
      proactive database wellness job

  Fields:
    sqlMinRecommendedIncreaseSizeGb: The minimum recommended increase size in
      GigaBytes This field is consumed by the frontend * Writers: * the
      proactive database wellness job for OOD. * Readers:
    sqlOutOfDiskState: This field represents the state generated by the
      proactive database wellness job for OutOfDisk issues. * Writers: * the
      proactive database wellness job for OOD. * Readers: * the proactive
      database wellness job
  """

  class SqlOutOfDiskStateValueValuesEnum(_messages.Enum):
    r"""This field represents the state generated by the proactive database
    wellness job for OutOfDisk issues. * Writers: * the proactive database
    wellness job for OOD. * Readers: * the proactive database wellness job

    Values:
      SQL_OUT_OF_DISK_STATE_UNSPECIFIED: Unspecified state
      NORMAL: The instance has plenty space on data disk
      SOFT_SHUTDOWN: Data disk is almost used up. It is shutdown to prevent
        data corruption.
    """
    SQL_OUT_OF_DISK_STATE_UNSPECIFIED = 0
    NORMAL = 1
    SOFT_SHUTDOWN = 2

  sqlMinRecommendedIncreaseSizeGb = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  sqlOutOfDiskState = _messages.EnumField('SqlOutOfDiskStateValueValuesEnum', 2)


class SqlProjectsInstancesGetDiskShrinkConfigRequest(_messages.Message):
  r"""A SqlProjectsInstancesGetDiskShrinkConfigRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlProjectsInstancesGetLatestRecoveryTimeRequest(_messages.Message):
  r"""A SqlProjectsInstancesGetLatestRecoveryTimeRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sourceInstanceDeletionTime: The timestamp used to identify the time when
      the source instance is deleted. If this instance is deleted, then you
      must set the timestamp.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sourceInstanceDeletionTime = _messages.StringField(3)


class SqlProjectsInstancesPerformDiskShrinkRequest(_messages.Message):
  r"""A SqlProjectsInstancesPerformDiskShrinkRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    performDiskShrinkContext: A PerformDiskShrinkContext resource to be passed
      as the request body.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  performDiskShrinkContext = _messages.MessageField('PerformDiskShrinkContext', 2)
  project = _messages.StringField(3, required=True)


class SqlProjectsInstancesRescheduleMaintenanceRequest(_messages.Message):
  r"""A SqlProjectsInstancesRescheduleMaintenanceRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: ID of the project that contains the instance.
    sqlInstancesRescheduleMaintenanceRequestBody: A
      SqlInstancesRescheduleMaintenanceRequestBody resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sqlInstancesRescheduleMaintenanceRequestBody = _messages.MessageField('SqlInstancesRescheduleMaintenanceRequestBody', 3)


class SqlProjectsInstancesResetReplicaSizeRequest(_messages.Message):
  r"""A SqlProjectsInstancesResetReplicaSizeRequest object.

  Fields:
    instance: Cloud SQL read replica instance name.
    project: ID of the project that contains the read replica.
    sqlInstancesResetReplicaSizeRequest: A SqlInstancesResetReplicaSizeRequest
      resource to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sqlInstancesResetReplicaSizeRequest = _messages.MessageField('SqlInstancesResetReplicaSizeRequest', 3)


class SqlProjectsInstancesStartExternalSyncRequest(_messages.Message):
  r"""A SqlProjectsInstancesStartExternalSyncRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: ID of the project that contains the instance.
    sqlInstancesStartExternalSyncRequest: A
      SqlInstancesStartExternalSyncRequest resource to be passed as the
      request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sqlInstancesStartExternalSyncRequest = _messages.MessageField('SqlInstancesStartExternalSyncRequest', 3)


class SqlProjectsInstancesVerifyExternalSyncSettingsRequest(_messages.Message):
  r"""A SqlProjectsInstancesVerifyExternalSyncSettingsRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sqlInstancesVerifyExternalSyncSettingsRequest: A
      SqlInstancesVerifyExternalSyncSettingsRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sqlInstancesVerifyExternalSyncSettingsRequest = _messages.MessageField('SqlInstancesVerifyExternalSyncSettingsRequest', 3)


class SqlScheduledMaintenance(_messages.Message):
  r"""Any scheduled maintenance for this instance.

  Fields:
    canDefer: A boolean attribute.
    canReschedule: If the scheduled maintenance can be rescheduled.
    scheduleDeadlineTime: Maintenance cannot be rescheduled to start beyond
      this deadline.
    startTime: The start time of any upcoming scheduled maintenance for this
      instance.
  """

  canDefer = _messages.BooleanField(1)
  canReschedule = _messages.BooleanField(2)
  scheduleDeadlineTime = _messages.StringField(3)
  startTime = _messages.StringField(4)


class SqlServerAuditConfig(_messages.Message):
  r"""SQL Server specific audit configuration.

  Fields:
    bucket: The name of the destination bucket (e.g., gs://mybucket).
    kind: This is always sql#sqlServerAuditConfig
    retentionInterval: How long to keep generated audit files.
    uploadInterval: How often to upload generated audit files.
  """

  bucket = _messages.StringField(1)
  kind = _messages.StringField(2)
  retentionInterval = _messages.StringField(3)
  uploadInterval = _messages.StringField(4)


class SqlServerDatabaseDetails(_messages.Message):
  r"""Represents a Sql Server database on the Cloud SQL instance.

  Fields:
    compatibilityLevel: The version of SQL Server with which the database is
      to be made compatible
    recoveryModel: The recovery model of a SQL Server database
  """

  compatibilityLevel = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  recoveryModel = _messages.StringField(2)


class SqlServerEntraIdConfig(_messages.Message):
  r"""SQL Server Entra ID configuration.

  Fields:
    applicationId: Optional. The application ID for the Entra ID
      configuration.
    kind: Output only. This is always sql#sqlServerEntraIdConfig
    tenantId: Optional. The tenant ID for the Entra ID configuration.
  """

  applicationId = _messages.StringField(1)
  kind = _messages.StringField(2)
  tenantId = _messages.StringField(3)


class SqlServerUserDetails(_messages.Message):
  r"""Represents a Sql Server user on the Cloud SQL instance.

  Fields:
    disabled: If the user has been disabled
    serverRoles: The server roles for this user
  """

  disabled = _messages.BooleanField(1)
  serverRoles = _messages.StringField(2, repeated=True)


class SqlSslCertsCreateEphemeralRequest(_messages.Message):
  r"""A SqlSslCertsCreateEphemeralRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the Cloud SQL project.
    sslCertsCreateEphemeralRequest: A SslCertsCreateEphemeralRequest resource
      to be passed as the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsCreateEphemeralRequest = _messages.MessageField('SslCertsCreateEphemeralRequest', 3)


class SqlSslCertsDeleteRequest(_messages.Message):
  r"""A SqlSslCertsDeleteRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsGetRequest(_messages.Message):
  r"""A SqlSslCertsGetRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sha1Fingerprint: Sha1 FingerPrint.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sha1Fingerprint = _messages.StringField(3, required=True)


class SqlSslCertsInsertRequest(_messages.Message):
  r"""A SqlSslCertsInsertRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
    sslCertsInsertRequest: A SslCertsInsertRequest resource to be passed as
      the request body.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)
  sslCertsInsertRequest = _messages.MessageField('SslCertsInsertRequest', 3)


class SqlSslCertsListRequest(_messages.Message):
  r"""A SqlSslCertsListRequest object.

  Fields:
    instance: Cloud SQL instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlSubOperationType(_messages.Message):
  r"""The sub operation type based on the operation type.

  Enums:
    MaintenanceTypeValueValuesEnum: The type of maintenance to be performed on
      the instance.

  Fields:
    maintenanceType: The type of maintenance to be performed on the instance.
  """

  class MaintenanceTypeValueValuesEnum(_messages.Enum):
    r"""The type of maintenance to be performed on the instance.

    Values:
      SQL_MAINTENANCE_TYPE_UNSPECIFIED: Maintenance type is unspecified.
      INSTANCE_MAINTENANCE: Indicates that a standalone instance is undergoing
        maintenance. The instance can be either a primary instance or a
        replica.
      REPLICA_INCLUDED_MAINTENANCE: Indicates that the primary instance and
        all of its replicas, including cascading replicas, are undergoing
        maintenance. Maintenance is performed on groups of replicas first,
        followed by the primary instance.
      INSTANCE_SELF_SERVICE_MAINTENANCE: Indicates that the standalone
        instance is undergoing maintenance, initiated by self-service. The
        instance can be either a primary instance or a replica.
      REPLICA_INCLUDED_SELF_SERVICE_MAINTENANCE: Indicates that the primary
        instance and all of its replicas are undergoing maintenance, initiated
        by self-service. Maintenance is performed on groups of replicas first,
        followed by the primary instance.
    """
    SQL_MAINTENANCE_TYPE_UNSPECIFIED = 0
    INSTANCE_MAINTENANCE = 1
    REPLICA_INCLUDED_MAINTENANCE = 2
    INSTANCE_SELF_SERVICE_MAINTENANCE = 3
    REPLICA_INCLUDED_SELF_SERVICE_MAINTENANCE = 4

  maintenanceType = _messages.EnumField('MaintenanceTypeValueValuesEnum', 1)


class SqlTiersListRequest(_messages.Message):
  r"""A SqlTiersListRequest object.

  Fields:
    project: Project ID of the project for which to list tiers.
  """

  project = _messages.StringField(1, required=True)


class SqlUsersDeleteRequest(_messages.Message):
  r"""A SqlUsersDeleteRequest object.

  Fields:
    host: Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
  """

  host = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3)
  project = _messages.StringField(4, required=True)


class SqlUsersGetRequest(_messages.Message):
  r"""A SqlUsersGetRequest object.

  Fields:
    host: Host of a user of the instance.
    instance: Database instance ID. This does not include the project ID.
    name: User of the instance.
    project: Project ID of the project that contains the instance.
  """

  host = _messages.StringField(1)
  instance = _messages.StringField(2, required=True)
  name = _messages.StringField(3, required=True)
  project = _messages.StringField(4, required=True)


class SqlUsersListRequest(_messages.Message):
  r"""A SqlUsersListRequest object.

  Fields:
    instance: Database instance ID. This does not include the project ID.
    project: Project ID of the project that contains the instance.
  """

  instance = _messages.StringField(1, required=True)
  project = _messages.StringField(2, required=True)


class SqlUsersUpdateRequest(_messages.Message):
  r"""A SqlUsersUpdateRequest object.

  Fields:
    databaseRoles: Optional. List of database roles to grant to the user.
      body.database_roles will be ignored for update request.
    host: Optional. Host of the user in the instance.
    instance: Database instance ID. This does not include the project ID.
    name: Name of the user in the instance.
    project: Project ID of the project that contains the instance.
    revokeExistingRoles: Optional. revoke the existing roles granted to the
      user.
    user: A User resource to be passed as the request body.
  """

  databaseRoles = _messages.StringField(1, repeated=True)
  host = _messages.StringField(2)
  instance = _messages.StringField(3, required=True)
  name = _messages.StringField(4)
  project = _messages.StringField(5, required=True)
  revokeExistingRoles = _messages.BooleanField(6)
  user = _messages.MessageField('User', 7)


class SslCert(_messages.Message):
  r"""SslCerts Resource

  Fields:
    cert: PEM representation.
    certSerialNumber: Serial number, as extracted from the certificate.
    commonName: User supplied name. Constrained to [a-zA-Z.-_ ]+.
    createTime: The time when the certificate was created in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    expirationTime: The time when the certificate expires in [RFC
      3339](https://tools.ietf.org/html/rfc3339) format, for example
      `2012-11-15T16:19:00.094Z`.
    instance: Name of the database instance.
    kind: This is always `sql#sslCert`.
    selfLink: The URI of this resource.
    sha1Fingerprint: Sha1 Fingerprint.
  """

  cert = _messages.StringField(1)
  certSerialNumber = _messages.StringField(2)
  commonName = _messages.StringField(3)
  createTime = _messages.StringField(4)
  expirationTime = _messages.StringField(5)
  instance = _messages.StringField(6)
  kind = _messages.StringField(7)
  selfLink = _messages.StringField(8)
  sha1Fingerprint = _messages.StringField(9)


class SslCertDetail(_messages.Message):
  r"""SslCertDetail.

  Fields:
    certInfo: The public information about the cert.
    certPrivateKey: The private key for the client cert, in pem format. Keep
      private in order to protect your security.
  """

  certInfo = _messages.MessageField('SslCert', 1)
  certPrivateKey = _messages.StringField(2)


class SslCertsCreateEphemeralRequest(_messages.Message):
  r"""SslCerts create ephemeral certificate request.

  Fields:
    access_token: Access token to include in the signed certificate.
    public_key: PEM encoded public key to include in the signed certificate.
  """

  access_token = _messages.StringField(1)
  public_key = _messages.StringField(2)


class SslCertsInsertRequest(_messages.Message):
  r"""SslCerts insert request.

  Fields:
    commonName: User supplied name. Must be a distinct name from the other
      certificates for this instance.
  """

  commonName = _messages.StringField(1)


class SslCertsInsertResponse(_messages.Message):
  r"""SslCert insert response.

  Fields:
    clientCert: The new client certificate and private key.
    kind: This is always `sql#sslCertsInsert`.
    operation: The operation to track the ssl certs insert request.
    serverCaCert: The server Certificate Authority's certificate. If this is
      missing you can force a new one to be generated by calling
      resetSslConfig method on instances resource.
  """

  clientCert = _messages.MessageField('SslCertDetail', 1)
  kind = _messages.StringField(2)
  operation = _messages.MessageField('Operation', 3)
  serverCaCert = _messages.MessageField('SslCert', 4)


class SslCertsListResponse(_messages.Message):
  r"""SslCerts list response.

  Fields:
    items: List of client certificates for the instance.
    kind: This is always `sql#sslCertsList`.
  """

  items = _messages.MessageField('SslCert', 1, repeated=True)
  kind = _messages.StringField(2)


class StandardQueryParameters(_messages.Message):
  r"""Query parameters accepted by all methods.

  Enums:
    FXgafvValueValuesEnum: V1 error format.
    AltValueValuesEnum: Data format for response.

  Fields:
    f__xgafv: V1 error format.
    access_token: OAuth access token.
    alt: Data format for response.
    callback: JSONP
    fields: Selector specifying which fields to include in a partial response.
    key: API key. Your API key identifies your project and provides you with
      API access, quota, and reports. Required unless you provide an OAuth 2.0
      token.
    oauth_token: OAuth 2.0 token for the current user.
    prettyPrint: Returns response with indentations and line breaks.
    quotaUser: Available to use for quota purposes for server-side
      applications. Can be any arbitrary string assigned to a user, but should
      not exceed 40 characters.
    trace: A tracing token of the form "token:<tokenid>" to include in api
      requests.
    uploadType: Legacy upload protocol for media (e.g. "media", "multipart").
    upload_protocol: Upload protocol for media (e.g. "raw", "multipart").
  """

  class AltValueValuesEnum(_messages.Enum):
    r"""Data format for response.

    Values:
      json: Responses with Content-Type of application/json
      media: Media download with context-dependent Content-Type
      proto: Responses with Content-Type of application/x-protobuf
    """
    json = 0
    media = 1
    proto = 2

  class FXgafvValueValuesEnum(_messages.Enum):
    r"""V1 error format.

    Values:
      _1: v1 error format
      _2: v2 error format
    """
    _1 = 0
    _2 = 1

  f__xgafv = _messages.EnumField('FXgafvValueValuesEnum', 1)
  access_token = _messages.StringField(2)
  alt = _messages.EnumField('AltValueValuesEnum', 3, default='json')
  callback = _messages.StringField(4)
  fields = _messages.StringField(5)
  key = _messages.StringField(6)
  oauth_token = _messages.StringField(7)
  prettyPrint = _messages.BooleanField(8, default=True)
  quotaUser = _messages.StringField(9)
  trace = _messages.StringField(10)
  uploadType = _messages.StringField(11)
  upload_protocol = _messages.StringField(12)


class Status(_messages.Message):
  r"""The `Status` type defines a logical error model that is suitable for
  different programming environments, including REST APIs and RPC APIs. It is
  used by [gRPC](https://github.com/grpc). Each `Status` message contains
  three pieces of data: error code, error message, and error details. You can
  find out more about this error model and how to work with it in the [API
  Design Guide](https://cloud.google.com/apis/design/errors).

  Messages:
    DetailsValueListEntry: A DetailsValueListEntry object.

  Fields:
    code: The status code, which should be an enum value of google.rpc.Code.
    details: A list of messages that carry the error details. There is a
      common set of message types for APIs to use.
    message: A developer-facing error message, which should be in English. Any
      user-facing error message should be localized and sent in the
      google.rpc.Status.details field, or localized by the client.
  """

  @encoding.MapUnrecognizedFields('additionalProperties')
  class DetailsValueListEntry(_messages.Message):
    r"""A DetailsValueListEntry object.

    Messages:
      AdditionalProperty: An additional property for a DetailsValueListEntry
        object.

    Fields:
      additionalProperties: Properties of the object. Contains field @type
        with type URL.
    """

    class AdditionalProperty(_messages.Message):
      r"""An additional property for a DetailsValueListEntry object.

      Fields:
        key: Name of the additional property.
        value: A extra_types.JsonValue attribute.
      """

      key = _messages.StringField(1)
      value = _messages.MessageField('extra_types.JsonValue', 2)

    additionalProperties = _messages.MessageField('AdditionalProperty', 1, repeated=True)

  code = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  details = _messages.MessageField('DetailsValueListEntry', 2, repeated=True)
  message = _messages.StringField(3)


class SyncFlags(_messages.Message):
  r"""Initial sync flags for certain Cloud SQL APIs. Currently used for the
  MySQL external server initial dump.

  Fields:
    name: The name of the flag.
    value: The value of the flag. This field must be omitted if the flag
      doesn't take a value.
  """

  name = _messages.StringField(1)
  value = _messages.StringField(2)


class TargetMetric(_messages.Message):
  r"""Target metric for read pool auto scaling.

  Fields:
    metric: The metric name to be used for auto scaling.
    targetValue: The target value for the metric.
  """

  metric = _messages.StringField(1)
  targetValue = _messages.FloatField(2, variant=_messages.Variant.FLOAT)


class Tier(_messages.Message):
  r"""A Google Cloud SQL service tier resource.

  Fields:
    DiskQuota: The maximum disk size of this tier in bytes.
    RAM: The maximum RAM usage of this tier in bytes.
    edition: Edition can be STANDARD or ENTERPRISE.
    kind: This is always `sql#tier`.
    region: The applicable regions for this tier.
    tier: An identifier for the machine type, for example, `db-custom-1-3840`.
      For related information, see [Pricing](/sql/pricing).
  """

  DiskQuota = _messages.IntegerField(1)
  RAM = _messages.IntegerField(2)
  edition = _messages.StringField(3)
  kind = _messages.StringField(4)
  region = _messages.StringField(5, repeated=True)
  tier = _messages.StringField(6)


class TiersListResponse(_messages.Message):
  r"""Tiers list response.

  Fields:
    items: List of tiers.
    kind: This is always `sql#tiersList`.
  """

  items = _messages.MessageField('Tier', 1, repeated=True)
  kind = _messages.StringField(2)


class TruncateLogContext(_messages.Message):
  r"""Database Instance truncate log context.

  Fields:
    kind: This is always `sql#truncateLogContext`.
    logType: The type of log to truncate. Valid values are
      `MYSQL_GENERAL_TABLE` and `MYSQL_SLOW_TABLE`.
  """

  kind = _messages.StringField(1)
  logType = _messages.StringField(2)


class UncMapping(_messages.Message):
  r"""Unc mapping proto used for SQL Server.

  Enums:
    ModeValueValuesEnum: The mode of the UNC mapping.

  Fields:
    gcsPath: The GCS path, represent the GCS path.
    mode: The mode of the UNC mapping.
    uncPath: The UNC path, represent the server name.
  """

  class ModeValueValuesEnum(_messages.Enum):
    r"""The mode of the UNC mapping.

    Values:
      UNKNOWN: Unspecified.
      SNAPSHOT_READ: Snapshot read.
      SNAPSHOT_WRITE: Snapshot write.
    """
    UNKNOWN = 0
    SNAPSHOT_READ = 1
    SNAPSHOT_WRITE = 2

  gcsPath = _messages.StringField(1)
  mode = _messages.EnumField('ModeValueValuesEnum', 2)
  uncPath = _messages.StringField(3)


class User(_messages.Message):
  r"""A Cloud SQL user resource.

  Enums:
    DualPasswordTypeValueValuesEnum: Dual password status for the user.
    IamStatusValueValuesEnum: Indicates if a group is active or inactive for
      IAM database authentication.
    TypeValueValuesEnum: The user type. It determines the method to
      authenticate the user during login. The default is the database's built-
      in user type.

  Fields:
    databaseRoles: Optional. Role memberships of the user
    dualPasswordType: Dual password status for the user.
    etag: This field is deprecated and will be removed from a future version
      of the API.
    host: Optional. The host from which the user can connect. For `insert`
      operations, host defaults to an empty string. For `update` operations,
      host is specified as part of the request URL. The host name cannot be
      updated after insertion. For a MySQL instance, it's required; for a
      PostgreSQL or SQL Server instance, it's optional.
    iamEmail: Optional. The full email for an IAM user. For normal database
      users, this will not be filled. Only applicable to MySQL database users.
    iamStatus: Indicates if a group is active or inactive for IAM database
      authentication.
    instance: The name of the Cloud SQL instance. This does not include the
      project ID. Can be omitted for *update* because it is already specified
      on the URL.
    kind: This is always `sql#user`.
    name: The name of the user in the Cloud SQL instance. Can be omitted for
      `update` because it is already specified in the URL.
    password: The password for the user.
    passwordPolicy: User level password validation policy.
    project: The project ID of the project containing the Cloud SQL database.
      The Google apps domain is prefixed if applicable. Can be omitted for
      *update* because it is already specified on the URL.
    sqlserverUserDetails: A SqlServerUserDetails attribute.
    type: The user type. It determines the method to authenticate the user
      during login. The default is the database's built-in user type.
  """

  class DualPasswordTypeValueValuesEnum(_messages.Enum):
    r"""Dual password status for the user.

    Values:
      DUAL_PASSWORD_TYPE_UNSPECIFIED: The default value.
      NO_MODIFY_DUAL_PASSWORD: Do not update the user's dual password status.
      NO_DUAL_PASSWORD: No dual password usable for connecting using this
        user.
      DUAL_PASSWORD: Dual password usable for connecting using this user.
    """
    DUAL_PASSWORD_TYPE_UNSPECIFIED = 0
    NO_MODIFY_DUAL_PASSWORD = 1
    NO_DUAL_PASSWORD = 2
    DUAL_PASSWORD = 3

  class IamStatusValueValuesEnum(_messages.Enum):
    r"""Indicates if a group is active or inactive for IAM database
    authentication.

    Values:
      IAM_STATUS_UNSPECIFIED: The default value for users that are not of type
        CLOUD_IAM_GROUP. Only CLOUD_IAM_GROUP users will be inactive or
        active. Users with an IamStatus of IAM_STATUS_UNSPECIFIED will not
        display whether they are active or inactive as that is not applicable
        to them.
      INACTIVE: INACTIVE indicates a group is not available for IAM database
        authentication.
      ACTIVE: ACTIVE indicates a group is available for IAM database
        authentication.
    """
    IAM_STATUS_UNSPECIFIED = 0
    INACTIVE = 1
    ACTIVE = 2

  class TypeValueValuesEnum(_messages.Enum):
    r"""The user type. It determines the method to authenticate the user
    during login. The default is the database's built-in user type.

    Values:
      BUILT_IN: The database's built-in user type.
      CLOUD_IAM_USER: Cloud IAM user.
      CLOUD_IAM_SERVICE_ACCOUNT: Cloud IAM service account.
      CLOUD_IAM_GROUP: Cloud IAM group. Not used for login.
      CLOUD_IAM_GROUP_USER: Read-only. Login for a user that belongs to the
        Cloud IAM group.
      CLOUD_IAM_GROUP_SERVICE_ACCOUNT: Read-only. Login for a service account
        that belongs to the Cloud IAM group.
      CLOUD_IAM_WORKFORCE_IDENTITY: Cloud IAM workforce identity.
      ENTRAID_USER: Microsoft Entra ID user.
    """
    BUILT_IN = 0
    CLOUD_IAM_USER = 1
    CLOUD_IAM_SERVICE_ACCOUNT = 2
    CLOUD_IAM_GROUP = 3
    CLOUD_IAM_GROUP_USER = 4
    CLOUD_IAM_GROUP_SERVICE_ACCOUNT = 5
    CLOUD_IAM_WORKFORCE_IDENTITY = 6
    ENTRAID_USER = 7

  databaseRoles = _messages.StringField(1, repeated=True)
  dualPasswordType = _messages.EnumField('DualPasswordTypeValueValuesEnum', 2)
  etag = _messages.StringField(3)
  host = _messages.StringField(4)
  iamEmail = _messages.StringField(5)
  iamStatus = _messages.EnumField('IamStatusValueValuesEnum', 6)
  instance = _messages.StringField(7)
  kind = _messages.StringField(8)
  name = _messages.StringField(9)
  password = _messages.StringField(10)
  passwordPolicy = _messages.MessageField('UserPasswordValidationPolicy', 11)
  project = _messages.StringField(12)
  sqlserverUserDetails = _messages.MessageField('SqlServerUserDetails', 13)
  type = _messages.EnumField('TypeValueValuesEnum', 14)


class UserPasswordValidationPolicy(_messages.Message):
  r"""User level password validation policy.

  Fields:
    allowedFailedAttempts: Number of failed login attempts allowed before user
      get locked.
    enableFailedAttemptsCheck: If true, failed login attempts check will be
      enabled.
    enablePasswordVerification: If true, the user must specify the current
      password before changing the password. This flag is supported only for
      MySQL.
    passwordExpirationDuration: Expiration duration after password is updated.
    status: Output only. Read-only password status.
  """

  allowedFailedAttempts = _messages.IntegerField(1, variant=_messages.Variant.INT32)
  enableFailedAttemptsCheck = _messages.BooleanField(2)
  enablePasswordVerification = _messages.BooleanField(3)
  passwordExpirationDuration = _messages.StringField(4)
  status = _messages.MessageField('PasswordStatus', 5)


class UsersListResponse(_messages.Message):
  r"""User list response.

  Fields:
    items: List of user resources in the instance.
    kind: This is always *sql#usersList*.
    nextPageToken: Unused.
  """

  items = _messages.MessageField('User', 1, repeated=True)
  kind = _messages.StringField(2)
  nextPageToken = _messages.StringField(3)


class Value(_messages.Message):
  r"""The cell value of the table.

  Fields:
    nullValue: If cell value is null, then this flag will be set to true.
    value: The cell value represented in string format.
  """

  nullValue = _messages.BooleanField(1)
  value = _messages.StringField(2)


encoding.AddCustomJsonFieldMapping(
    StandardQueryParameters, 'f__xgafv', '$.xgafv')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_1', '1')
encoding.AddCustomJsonEnumMapping(
    StandardQueryParameters.FXgafvValueValuesEnum, '_2', '2')
