/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License version 2.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 * Test that the shared memory object has a size of zero when created.
 * 
 * The test use fstat to get the size of shared memory object.
 */

#include <sys/mman.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <errno.h>
#include <unistd.h>
#include "posixtest.h"

#define SHM_NAME "posixtest_21-1"

int main(){
	int fd, result;
	struct stat stat_buf;

	result = shm_unlink(SHM_NAME);
	if(result != 0 && errno != ENOENT) { 
		/* The shared memory object exist and shm_unlink can not 
		   remove it. */
		perror("An error occurs when calling shm_unlink()");
		return PTS_UNRESOLVED;
	}

	fd = shm_open(SHM_NAME, O_RDONLY|O_CREAT, S_IRUSR|S_IWUSR);
	if(fd == -1) {
		perror("An error occurs when calling shm_open()");
		return PTS_UNRESOLVED;
	}
	
	result = fstat(fd, &stat_buf);
	if(result != 0) {
		perror("An error occurs when calling fstat()");
		shm_unlink(SHM_NAME);
		return PTS_UNRESOLVED;
	}

	shm_unlink(SHM_NAME);

	if(stat_buf.st_size == 0) {
		printf("Test PASSED\n");
		return PTS_PASS;
	}
	printf("The shared memory object has not a size of zero.\n");
	return PTS_FAIL;
}
       
