/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.ssh2get;

import com.trilead.ssh2.Connection;
import com.trilead.ssh2.HTTPProxyData;
import com.trilead.ssh2.KnownHosts;
import com.trilead.ssh2.ProxyData;
import com.trilead.ssh2.SFTPv3Client;
import com.trilead.ssh2.SFTPv3DirectoryEntry;
import com.trilead.ssh2.SFTPv3FileAttributes;
import com.trilead.ssh2.SFTPv3FileHandle;
import com.trilead.ssh2.ServerHostKeyVerifier;
import java.io.File;
import java.io.FileOutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileType;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.ssh2get.FTPUtils;
import org.pentaho.di.job.entries.ssh2get.Messages;
import org.pentaho.di.job.entries.ssh2get.SimpleVerifier;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.resource.ResourceEntry;
import org.pentaho.di.resource.ResourceReference;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntrySSH2GET
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    LogWriter log = LogWriter.getInstance();
    private String serverName;
    private String userName;
    private String password;
    private String serverPort;
    private String ftpDirectory;
    private String localDirectory;
    private String wildcard;
    private boolean onlyGettingNewFiles;
    private boolean usehttpproxy;
    private String httpProxyHost;
    private String httpproxyport;
    private String httpproxyusername;
    private String httpProxyPassword;
    private boolean publicpublickey;
    private String keyFilename;
    private String keyFilePass;
    private boolean useBasicAuthentication;
    private String afterFtpPut;
    private String destinationfolder;
    private boolean createdestinationfolder;
    private boolean cachehostkey;
    private int timeout;
    boolean createtargetfolder;
    boolean includeSubFolders;
    static KnownHosts database = new KnownHosts();
    int nbfilestoget = 0;
    int nbgot = 0;
    int nbrerror = 0;

    public JobEntrySSH2GET(String n) {
        super(n, "");
        this.serverName = null;
        this.publicpublickey = false;
        this.keyFilename = null;
        this.keyFilePass = null;
        this.usehttpproxy = false;
        this.httpProxyHost = null;
        this.httpproxyport = null;
        this.httpproxyusername = null;
        this.httpProxyPassword = null;
        this.serverPort = "22";
        this.useBasicAuthentication = false;
        this.afterFtpPut = "do_nothing";
        this.destinationfolder = null;
        this.includeSubFolders = false;
        this.createdestinationfolder = false;
        this.createtargetfolder = false;
        this.cachehostkey = false;
        this.timeout = 0;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.SSH2_GET);
    }

    public JobEntrySSH2GET() {
        this("");
    }

    public JobEntrySSH2GET(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntrySSH2GET je = (JobEntrySSH2GET)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(128);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"servername", (String)this.serverName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"username", (String)this.userName));
        retval.append("      ").append(XMLHandler.addTagValue((String)"password", (String)Encr.encryptPasswordIfNotUsingVariables((String)this.getPassword())));
        retval.append("      ").append(XMLHandler.addTagValue((String)"serverport", (String)this.serverPort));
        retval.append("      ").append(XMLHandler.addTagValue((String)"ftpdirectory", (String)this.ftpDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"localdirectory", (String)this.localDirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"only_new", (boolean)this.onlyGettingNewFiles));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usehttpproxy", (boolean)this.usehttpproxy));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyhost", (String)this.httpProxyHost));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyport", (String)this.httpproxyport));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxyusername", (String)this.httpproxyusername));
        retval.append("      ").append(XMLHandler.addTagValue((String)"httpproxypassword", (String)this.httpProxyPassword));
        retval.append("      ").append(XMLHandler.addTagValue((String)"publicpublickey", (boolean)this.publicpublickey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilename", (String)this.keyFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"keyfilepass", (String)this.keyFilePass));
        retval.append("      ").append(XMLHandler.addTagValue((String)"usebasicauthentication", (boolean)this.useBasicAuthentication));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterftpput", (String)this.afterFtpPut));
        retval.append("      ").append(XMLHandler.addTagValue((String)"destinationfolder", (String)this.destinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createdestinationfolder", (boolean)this.createdestinationfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"cachehostkey", (boolean)this.cachehostkey));
        retval.append("      ").append(XMLHandler.addTagValue((String)"timeout", (int)this.timeout));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createtargetfolder", (boolean)this.createtargetfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"includeSubFolders", (boolean)this.includeSubFolders));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.serverName = XMLHandler.getTagValue((Node)entrynode, (String)"servername");
            this.userName = XMLHandler.getTagValue((Node)entrynode, (String)"username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)XMLHandler.getTagValue((Node)entrynode, (String)"password"));
            this.serverPort = XMLHandler.getTagValue((Node)entrynode, (String)"serverport");
            this.ftpDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"ftpdirectory");
            this.localDirectory = XMLHandler.getTagValue((Node)entrynode, (String)"localdirectory");
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.onlyGettingNewFiles = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"only_new"));
            this.usehttpproxy = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usehttpproxy"));
            this.httpProxyHost = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyhost");
            this.httpproxyport = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyport");
            this.httpproxyusername = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxyusername");
            this.httpProxyPassword = XMLHandler.getTagValue((Node)entrynode, (String)"httpproxypassword");
            this.publicpublickey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"publicpublickey"));
            this.keyFilename = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilename");
            this.keyFilePass = XMLHandler.getTagValue((Node)entrynode, (String)"keyfilepass");
            this.useBasicAuthentication = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"usebasicauthentication"));
            this.afterFtpPut = XMLHandler.getTagValue((Node)entrynode, (String)"afterftpput");
            this.destinationfolder = XMLHandler.getTagValue((Node)entrynode, (String)"destinationfolder");
            this.createdestinationfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createdestinationfolder"));
            this.cachehostkey = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"cachehostkey"));
            this.timeout = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"timeout"), (int)0);
            this.createtargetfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createtargetfolder"));
            this.includeSubFolders = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"includeSubFolders"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException(Messages.getString("JobSSH2GET.Log.UnableLoadXML", xe.getMessage()));
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.serverName = rep.getJobEntryAttributeString(id_jobentry, "servername");
            this.userName = rep.getJobEntryAttributeString(id_jobentry, "username");
            this.password = Encr.decryptPasswordOptionallyEncrypted((String)rep.getJobEntryAttributeString(id_jobentry, "password"));
            this.serverPort = rep.getJobEntryAttributeString(id_jobentry, "serverport");
            this.ftpDirectory = rep.getJobEntryAttributeString(id_jobentry, "ftpdirectory");
            this.localDirectory = rep.getJobEntryAttributeString(id_jobentry, "localdirectory");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.onlyGettingNewFiles = rep.getJobEntryAttributeBoolean(id_jobentry, "only_new");
            this.usehttpproxy = rep.getJobEntryAttributeBoolean(id_jobentry, "usehttpproxy");
            this.httpProxyHost = rep.getJobEntryAttributeString(id_jobentry, "httpproxyhost");
            this.httpproxyusername = rep.getJobEntryAttributeString(id_jobentry, "httpproxyusername");
            this.httpProxyPassword = rep.getJobEntryAttributeString(id_jobentry, "httpproxypassword");
            this.publicpublickey = rep.getJobEntryAttributeBoolean(id_jobentry, "publicpublickey");
            this.keyFilename = rep.getJobEntryAttributeString(id_jobentry, "keyfilename");
            this.keyFilePass = rep.getJobEntryAttributeString(id_jobentry, "keyfilepass");
            this.useBasicAuthentication = rep.getJobEntryAttributeBoolean(id_jobentry, "usebasicauthentication");
            this.afterFtpPut = rep.getJobEntryAttributeString(id_jobentry, "afterftpput");
            this.destinationfolder = rep.getJobEntryAttributeString(id_jobentry, "destinationfolder");
            this.createdestinationfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createdestinationfolder");
            this.cachehostkey = rep.getJobEntryAttributeBoolean(id_jobentry, "cachehostkey");
            this.timeout = (int)rep.getJobEntryAttributeInteger(id_jobentry, "timeout");
            this.createtargetfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createtargetfolder");
            this.includeSubFolders = rep.getJobEntryAttributeBoolean(id_jobentry, "includeSubFolders");
        }
        catch (KettleException dbe) {
            throw new KettleException(Messages.getString("JobSSH2GET.Log.UnableLoadRep", "" + id_jobentry, dbe.getMessage()));
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "servername", this.serverName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "username", this.userName);
            rep.saveJobEntryAttribute(id_job, this.getID(), "password", Encr.encryptPasswordIfNotUsingVariables((String)this.password));
            rep.saveJobEntryAttribute(id_job, this.getID(), "serverport", this.serverPort);
            rep.saveJobEntryAttribute(id_job, this.getID(), "ftpdirectory", this.ftpDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "localdirectory", this.localDirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "only_new", this.onlyGettingNewFiles);
            rep.saveJobEntryAttribute(id_job, this.getID(), "usehttpproxy", this.usehttpproxy);
            rep.saveJobEntryAttribute(id_job, this.getID(), "httpproxyhost", this.httpProxyHost);
            rep.saveJobEntryAttribute(id_job, this.getID(), "httpproxyport", this.httpproxyport);
            rep.saveJobEntryAttribute(id_job, this.getID(), "httpproxyusername", this.httpproxyusername);
            rep.saveJobEntryAttribute(id_job, this.getID(), "httpproxypassword", this.httpProxyPassword);
            rep.saveJobEntryAttribute(id_job, this.getID(), "publicpublickey", this.publicpublickey);
            rep.saveJobEntryAttribute(id_job, this.getID(), "keyfilename", this.keyFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "keyfilepass", this.keyFilePass);
            rep.saveJobEntryAttribute(id_job, this.getID(), "usebasicauthentication", this.useBasicAuthentication);
            rep.saveJobEntryAttribute(id_job, this.getID(), "afterftpput", this.afterFtpPut);
            rep.saveJobEntryAttribute(id_job, this.getID(), "destinationfolder", this.destinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createdestinationfolder", this.createdestinationfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "cachehostkey", this.cachehostkey);
            rep.saveJobEntryAttribute(id_job, this.getID(), "timeout", this.timeout);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createtargetfolder", this.createtargetfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "includeSubFolders", this.includeSubFolders);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException(Messages.getString("JobSSH2GET.Log.UnableSaveRep", "" + id_job, dbe.getMessage()));
        }
    }

    public String getFtpDirectory() {
        return this.ftpDirectory;
    }

    public void setFtpDirectory(String directory) {
        this.ftpDirectory = directory;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public String getAfterFTPPut() {
        return this.afterFtpPut;
    }

    public void setAfterFTPPut(String afterFtpPut) {
        this.afterFtpPut = afterFtpPut;
    }

    public void setHTTPProxyPassword(String proxyPassword) {
        this.httpProxyPassword = proxyPassword;
    }

    public String getHTTPProxyPassword() {
        return this.httpProxyPassword;
    }

    public void setKeyFilePass(String keyFilePass) {
        this.keyFilePass = keyFilePass;
    }

    public String getKeyFilePass() {
        return this.keyFilePass;
    }

    public String getServerName() {
        return this.serverName;
    }

    public void setServerName(String serverName) {
        this.serverName = serverName;
    }

    public void setHTTPProxyHost(String proxyhost) {
        this.httpProxyHost = proxyhost;
    }

    public String getHTTPProxyHost() {
        return this.httpProxyHost;
    }

    public void setKeyFilename(String keyfilename) {
        this.keyFilename = keyfilename;
    }

    public String getKeyFilename() {
        return this.keyFilename;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public void setHTTPProxyUsername(String proxyusername) {
        this.httpproxyusername = proxyusername;
    }

    public String getHTTPProxyUsername() {
        return this.httpproxyusername;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public String getlocalDirectory() {
        return this.localDirectory;
    }

    public void setlocalDirectory(String localDirectory) {
        this.localDirectory = localDirectory;
    }

    public boolean isOnlyGettingNewFiles() {
        return this.onlyGettingNewFiles;
    }

    public void setOnlyGettingNewFiles(boolean onlyGettingNewFiles) {
        this.onlyGettingNewFiles = onlyGettingNewFiles;
    }

    public void setCacheHostKey(boolean cachehostkeyin) {
        this.cachehostkey = cachehostkeyin;
    }

    public boolean isCacheHostKey() {
        return this.cachehostkey;
    }

    public void setUseHTTPProxy(boolean httpproxy) {
        this.usehttpproxy = httpproxy;
    }

    public boolean isUseHTTPProxy() {
        return this.usehttpproxy;
    }

    public boolean isUseBasicAuthentication() {
        return this.useBasicAuthentication;
    }

    public void setUseBasicAuthentication(boolean useBasicAuthentication) {
        this.useBasicAuthentication = useBasicAuthentication;
    }

    public void setIncludeSubFolders(boolean includeSubFolders) {
        this.includeSubFolders = includeSubFolders;
    }

    public boolean isIncludeSubFolders() {
        return this.includeSubFolders;
    }

    public void setCreateDestinationFolder(boolean createdestinationfolderin) {
        this.createdestinationfolder = createdestinationfolderin;
    }

    public boolean isCreateDestinationFolder() {
        return this.createdestinationfolder;
    }

    public boolean isCreateTargetFolder() {
        return this.createtargetfolder;
    }

    public void setCreateTargetFolder(boolean createtargetfolderin) {
        this.createtargetfolder = createtargetfolderin;
    }

    public void setUsePublicKey(boolean publickey) {
        this.publicpublickey = publickey;
    }

    public boolean isUsePublicKey() {
        return this.publicpublickey;
    }

    public String getServerPort() {
        return this.serverPort;
    }

    public void setServerPort(String serverPort) {
        this.serverPort = serverPort;
    }

    public void setHTTPProxyPort(String proxyport) {
        this.httpproxyport = proxyport;
    }

    public String getHTTPProxyPort() {
        return this.httpproxyport;
    }

    public void setDestinationFolder(String destinationfolderin) {
        this.destinationfolder = destinationfolderin;
    }

    public String getDestinationFolder() {
        return this.destinationfolder;
    }

    public void setTimeout(int timeout) {
        this.timeout = timeout;
    }

    public int getTimeout() {
        return this.timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        SFTPv3Client client;
        Result result;
        block49: {
            boolean mandatoryok;
            String realDestinationFolder;
            String realftpDirectory;
            String realwildcard;
            String realLocalDirectory;
            String relKeyFilepass;
            String realKeyFilename;
            String realProxyPassword;
            String realproxyUserName;
            int realProxyPort;
            String realProxyHost;
            String realServerPassword;
            String realUserName;
            int realServerPort;
            String realServerName;
            LogWriter log;
            block52: {
                block53: {
                    block51: {
                        log = LogWriter.getInstance();
                        result = previousResult;
                        result.setResult(false);
                        if (log.isRowLevel()) {
                            log.logRowlevel(this.toString(), Messages.getString("JobSSH2GET.Log.GettingFieldsValue"), new Object[0]);
                        }
                        realServerName = this.environmentSubstitute(this.serverName);
                        realServerPort = Const.toInt((String)this.environmentSubstitute(this.serverPort), (int)22);
                        realUserName = this.environmentSubstitute(this.userName);
                        realServerPassword = this.environmentSubstitute(this.password);
                        realProxyHost = this.environmentSubstitute(this.httpProxyHost);
                        realProxyPort = Const.toInt((String)this.environmentSubstitute(this.httpproxyport), (int)22);
                        realproxyUserName = this.environmentSubstitute(this.httpproxyusername);
                        realProxyPassword = this.environmentSubstitute(this.httpProxyPassword);
                        realKeyFilename = this.environmentSubstitute(this.keyFilename);
                        relKeyFilepass = this.environmentSubstitute(this.keyFilePass);
                        realLocalDirectory = this.environmentSubstitute(this.localDirectory);
                        realwildcard = this.environmentSubstitute(this.wildcard);
                        realftpDirectory = this.environmentSubstitute(this.ftpDirectory);
                        realDestinationFolder = this.environmentSubstitute(this.destinationfolder);
                        try {
                            realftpDirectory = FTPUtils.normalizePath(realftpDirectory);
                            realDestinationFolder = FTPUtils.normalizePath(realDestinationFolder);
                        }
                        catch (Exception e) {
                            log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.CanNotNormalizePath", e.getMessage()), new Object[0]);
                            result.setNrErrors(1L);
                            return result;
                        }
                        if (log.isRowLevel()) {
                            log.logRowlevel(this.toString(), Messages.getString("JobSSH2GET.Log.CheckingMandatoryFields"), new Object[0]);
                        }
                        mandatoryok = true;
                        if (Const.isEmpty((String)realServerName)) {
                            mandatoryok = false;
                            log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.ServernameMissing"), new Object[0]);
                        }
                        if (this.usehttpproxy && Const.isEmpty((String)realProxyHost)) {
                            mandatoryok = false;
                            log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.HttpProxyhostMissing"), new Object[0]);
                        }
                        if (this.publicpublickey) {
                            if (Const.isEmpty((String)realKeyFilename)) {
                                mandatoryok = false;
                                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.KeyFileMissing"), new Object[0]);
                            } else if (!new File(realKeyFilename).exists()) {
                                mandatoryok = false;
                                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.KeyFileNotExist"), new Object[0]);
                            }
                        }
                        if (!Const.isEmpty((String)realLocalDirectory)) break block51;
                        mandatoryok = false;
                        log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.LocalFolderMissing"), new Object[0]);
                        break block52;
                    }
                    if (new File(realLocalDirectory).exists()) break block53;
                    if (this.createtargetfolder) {
                        if (!this.CreateFolder(realLocalDirectory)) {
                            mandatoryok = false;
                        }
                        break block52;
                    } else {
                        mandatoryok = false;
                        log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.LocalFolderNotExists"), new Object[0]);
                    }
                    break block52;
                }
                if (!new File(realLocalDirectory).isDirectory()) {
                    mandatoryok = false;
                    log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.LocalFolderNotFolder", realLocalDirectory), new Object[0]);
                }
            }
            if (this.afterFtpPut.equals("move_file") && Const.isEmpty((String)realDestinationFolder)) {
                mandatoryok = false;
                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.DestinatFolderMissing"), new Object[0]);
            }
            if (!mandatoryok) return result;
            Connection conn = null;
            client = null;
            boolean good = true;
            try {
                block48: {
                    try {
                        conn = this.getConnection(realServerName, realServerPort, realProxyHost, realProxyPort, realproxyUserName, realProxyPassword);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.ConnectionInstanceCreated"), new Object[0]);
                        }
                        if (this.timeout > 0) {
                            if (this.cachehostkey) {
                                conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database), 0, this.timeout * 1000);
                            } else {
                                conn.connect(null, 0, this.timeout * 1000);
                            }
                        } else if (this.cachehostkey) {
                            conn.connect((ServerHostKeyVerifier)new SimpleVerifier(database));
                        } else {
                            conn.connect();
                        }
                        boolean isAuthenticated = false;
                        isAuthenticated = this.publicpublickey ? conn.authenticateWithPublicKey(realUserName, new File(realKeyFilename), relKeyFilepass) : conn.authenticateWithPassword(realUserName, realServerPassword);
                        if (!isAuthenticated) {
                            log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.AuthenticationFailed"), new Object[0]);
                            break block48;
                        }
                        if (log.isBasic()) {
                            log.logBasic(this.toString(), Messages.getString("JobSSH2GET.Log.Connected", this.serverName, this.userName), new Object[0]);
                        }
                        client = new SFTPv3Client(conn);
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.ProtocolVersion", "" + client.getProtocolVersion()), new Object[0]);
                        }
                        if (!Const.isEmpty((String)realftpDirectory)) {
                            if (!this.sshDirectoryExists(client, realftpDirectory)) {
                                good = false;
                                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.RemoteDirectoryNotExist", realftpDirectory), new Object[0]);
                            } else if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.RemoteDirectoryExist", realftpDirectory), new Object[0]);
                            }
                        }
                        if (realDestinationFolder != null && !this.sshDirectoryExists(client, realDestinationFolder)) {
                            if (this.createdestinationfolder) {
                                if (!this.CreateRemoteFolder(client, realDestinationFolder)) {
                                    good = false;
                                }
                            } else {
                                good = false;
                                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.DestinatFolderNotExist", realDestinationFolder), new Object[0]);
                            }
                        }
                        if (!good) break block48;
                        Pattern pattern = null;
                        if (!Const.isEmpty((String)realwildcard)) {
                            pattern = Pattern.compile(realwildcard);
                        }
                        if (this.includeSubFolders) {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.RecursiveModeOn"), new Object[0]);
                            }
                            this.copyRecursive(realftpDirectory, realLocalDirectory, client, pattern, parentJob);
                        } else {
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.RecursiveModeOff"), new Object[0]);
                            }
                            this.GetFiles(realftpDirectory, realLocalDirectory, client, pattern, parentJob);
                        }
                        if (log.isDetailed()) {
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.Result.JobEntryEnd1"), new Object[0]);
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.Result.TotalFiles", "" + this.nbfilestoget), new Object[0]);
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.Result.TotalFilesPut", "" + this.nbgot), new Object[0]);
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.Result.TotalFilesError", "" + this.nbrerror), new Object[0]);
                            log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.Result.JobEntryEnd2"), new Object[0]);
                        }
                        if (this.nbrerror == 0) {
                            result.setResult(true);
                        }
                    }
                    catch (Exception e) {
                        result.setNrErrors((long)this.nbrerror);
                        log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.ErrorFTP", e.getMessage()), new Object[0]);
                        Object var28_30 = null;
                        if (conn != null) {
                            conn.close();
                        }
                        if (client == null) return result;
                        client.close();
                        return result;
                    }
                }
                Object var28_29 = null;
                if (conn == null) break block49;
            }
            catch (Throwable throwable) {
                Object var28_31 = null;
                if (conn != null) {
                    conn.close();
                }
                if (client == null) throw throwable;
                client.close();
                throw throwable;
            }
            conn.close();
        }
        if (client == null) return result;
        client.close();
        return result;
    }

    private Connection getConnection(String servername, int serverport, String proxyhost, int proxyport, String proxyusername, String proxypassword) {
        Connection conn = new Connection(servername, serverport);
        if (this.usehttpproxy) {
            conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport));
            if (this.useBasicAuthentication) {
                conn.setProxyData((ProxyData)new HTTPProxyData(proxyhost, proxyport, proxyusername, proxypassword));
            }
        }
        return conn;
    }

    public boolean sshFileExists(SFTPv3Client sftpClient, String filename) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(filename);
            if (attributes != null) {
                return attributes.isRegularFile();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean FileExists(String filename) {
        FileObject file = null;
        try {
            file = KettleVFS.getFileObject((String)filename);
            if (!file.exists()) {
                return false;
            }
            return file.getType() == FileType.FILE;
        }
        catch (Exception e) {
            return false;
        }
    }

    public boolean isDirectory(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isDirectory();
        }
        catch (Exception exception) {
            return false;
        }
    }

    public boolean sshDirectoryExists(SFTPv3Client sftpClient, String directory) {
        try {
            SFTPv3FileAttributes attributes = sftpClient.stat(directory);
            if (attributes != null) {
                return attributes.isDirectory();
            }
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public long getFileSize(SFTPv3Client sftpClient, String filename) throws Exception {
        return sftpClient.stat((String)filename).size;
    }

    private boolean getFileWildcard(String selectedfile, Pattern pattern) {
        boolean getIt = true;
        if (pattern != null) {
            Matcher matcher = pattern.matcher(selectedfile);
            getIt = matcher.matches();
        }
        return getIt;
    }

    private boolean deleteOrMoveFiles(SFTPv3Client sftpClient, String filename, String destinationFolder) {
        boolean retval = false;
        if (this.afterFtpPut.equals("delete_file")) {
            try {
                sftpClient.rm(filename);
                retval = true;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.DeletedFile", filename), new Object[0]);
                }
            }
            catch (Exception e) {
                this.log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.CanNotDeleteRemoteFile", filename), new Object[0]);
            }
        } else if (this.afterFtpPut.equals("move_file")) {
            String DestinationFullFilename = destinationFolder + Const.FILE_SEPARATOR + filename;
            try {
                sftpClient.mv(filename, DestinationFullFilename);
                retval = true;
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.DeletedFile", filename), new Object[0]);
                }
            }
            catch (Exception e) {
                this.log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.MovedFile", filename, destinationFolder), new Object[0]);
            }
        }
        return retval;
    }

    private void GetFiles(String sourceLocation, String targetLocation, SFTPv3Client sftpClient, Pattern pattern, Job parentJob) throws Exception {
        String sourceFolder = ".";
        sourceFolder = !Const.isEmpty((String)sourceLocation) ? sourceLocation + FTPUtils.FILE_SEPARATOR : sourceFolder + FTPUtils.FILE_SEPARATOR;
        Vector filelist = sftpClient.ls(sourceFolder);
        if (filelist != null) {
            Iterator iterator = filelist.iterator();
            while (iterator.hasNext() && !parentJob.isStopped()) {
                SFTPv3DirectoryEntry dirEntry = (SFTPv3DirectoryEntry)iterator.next();
                if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..") || this.isDirectory(sftpClient, sourceFolder + dirEntry.filename) || !this.getFileWildcard(dirEntry.filename, pattern)) continue;
                this.copyFile(sourceFolder + dirEntry.filename, targetLocation + FTPUtils.FILE_SEPARATOR + dirEntry.filename, sftpClient);
            }
        }
    }

    private void copyRecursive(String sourceLocation, String targetLocation, SFTPv3Client sftpClient, Pattern pattern, Job parentJob) throws Exception {
        String sourceFolder = "." + FTPUtils.FILE_SEPARATOR;
        if (sourceLocation != null) {
            sourceFolder = sourceLocation;
        }
        if (this.isDirectory(sftpClient, sourceFolder)) {
            Vector filelist = sftpClient.ls(sourceFolder);
            for (SFTPv3DirectoryEntry dirEntry : filelist) {
                if (dirEntry == null || dirEntry.filename.equals(".") || dirEntry.filename.equals("..")) continue;
                this.copyRecursive(sourceFolder + FTPUtils.FILE_SEPARATOR + dirEntry.filename, targetLocation + Const.FILE_SEPARATOR + dirEntry.filename, sftpClient, pattern, parentJob);
            }
        } else if (this.isFile(sftpClient, sourceFolder) && this.getFileWildcard(sourceFolder, pattern)) {
            this.copyFile(sourceFolder, targetLocation, sftpClient);
        }
    }

    public boolean isFile(SFTPv3Client sftpClient, String filename) {
        try {
            return sftpClient.stat(filename).isRegularFile();
        }
        catch (Exception exception) {
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    private void copyFile(String sourceLocation, String targetLocation, SFTPv3Client sftpClient) {
        block23: {
            File transferFile;
            FileOutputStream fos;
            SFTPv3FileHandle sftpFileHandle;
            block22: {
                sftpFileHandle = null;
                fos = null;
                transferFile = null;
                long remoteFileSize = -1L;
                boolean filecopied = true;
                transferFile = new File(targetLocation);
                if (!this.onlyGettingNewFiles || this.onlyGettingNewFiles && !this.FileExists(transferFile.getAbsolutePath())) {
                    int len;
                    new File(transferFile.getParent()).mkdirs();
                    remoteFileSize = this.getFileSize(sftpClient, sourceLocation);
                    if (this.log.isDetailed()) {
                        this.log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.ReceivingFile", sourceLocation, transferFile.getAbsolutePath(), "" + remoteFileSize), new Object[0]);
                    }
                    sftpFileHandle = sftpClient.openFileRO(sourceLocation);
                    fos = null;
                    long offset = 0L;
                    fos = new FileOutputStream(transferFile);
                    byte[] buffer = new byte[2048];
                    while ((len = sftpClient.read(sftpFileHandle, offset, buffer, 0, buffer.length)) > 0) {
                        fos.write(buffer, 0, len);
                        offset += (long)len;
                    }
                    fos.flush();
                    fos.close();
                    fos = null;
                    ++this.nbfilestoget;
                    if (remoteFileSize > 0L && remoteFileSize != transferFile.length()) {
                        filecopied = false;
                        ++this.nbrerror;
                        this.log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.RemoteFileLocalDifferent", "" + remoteFileSize, transferFile.length() + "", "" + offset), new Object[0]);
                    } else {
                        ++this.nbgot;
                        if (this.log.isDetailed()) {
                            this.log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.RemoteFileLocalCopied", sourceLocation, transferFile + ""), new Object[0]);
                        }
                    }
                }
                if (!filecopied || this.afterFtpPut.equals("do_nothing")) break block22;
                this.deleteOrMoveFiles(sftpClient, sourceLocation, this.environmentSubstitute(this.destinationfolder));
            }
            Object var15_13 = null;
            try {
                if (sftpFileHandle != null) {
                    sftpClient.closeFile(sftpFileHandle);
                    sftpFileHandle = null;
                }
                if (fos == null) break block23;
                try {
                    fos.close();
                    fos = null;
                    break block23;
                }
                catch (Exception ex) {
                }
            }
            catch (Exception e2) {}
            break block23;
            {
                catch (Exception e) {
                    ++this.nbrerror;
                    this.log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.WritingFile", transferFile.getAbsolutePath(), e.getMessage()), new Object[0]);
                    Object var15_14 = null;
                    try {
                        if (sftpFileHandle != null) {
                            sftpClient.closeFile(sftpFileHandle);
                            sftpFileHandle = null;
                        }
                        if (fos == null) break block23;
                        try {
                            fos.close();
                            fos = null;
                            break block23;
                        }
                        catch (Exception ex) {
                        }
                    }
                    catch (Exception e2) {}
                }
            }
            catch (Throwable throwable) {
                Object var15_15 = null;
                try {
                    if (sftpFileHandle != null) {
                        sftpClient.closeFile(sftpFileHandle);
                        sftpFileHandle = null;
                    }
                    if (fos != null) {
                        try {
                            fos.close();
                            fos = null;
                        }
                        catch (Exception ex) {}
                    }
                }
                catch (Exception e2) {
                    // empty catch block
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean CreateFolder(String filefolder) {
        FileObject folder;
        block12: {
            folder = null;
            folder = KettleVFS.getFileObject((String)filefolder);
            if (folder.exists()) break block12;
            if (this.createtargetfolder) {
                folder.createFolder();
                if (this.log.isDetailed()) {
                    this.log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.FolderCreated", folder.toString()), new Object[0]);
                }
                break block12;
            }
            boolean bl = false;
            Object var5_6 = null;
            if (folder == null) return bl;
            try {
                folder.close();
                return bl;
            }
            catch (Exception ex) {
                // empty catch block
            }
            return bl;
        }
        boolean bl = true;
        Object var5_7 = null;
        if (folder == null) return bl;
        try {
            folder.close();
            return bl;
        }
        catch (Exception ex) {
            // empty catch block
        }
        return bl;
        catch (Exception e) {
            try {
                this.log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.CanNotCreateFolder", folder.toString()), new Object[0]);
                Object var5_8 = null;
                if (folder == null) return false;
            }
            catch (Throwable throwable) {
                Object var5_9 = null;
                if (folder == null) throw throwable;
                try {
                    folder.close();
                    throw throwable;
                }
                catch (Exception ex) {
                    // empty catch block
                }
                throw throwable;
            }
            try {
                folder.close();
                return false;
            }
            catch (Exception ex) {}
            return false;
        }
    }

    private boolean CreateRemoteFolder(SFTPv3Client sftpClient, String foldername) {
        LogWriter log = LogWriter.getInstance();
        boolean retval = false;
        if (!this.sshDirectoryExists(sftpClient, foldername)) {
            try {
                sftpClient.mkdir(foldername, 448);
                retval = true;
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobSSH2GET.Log.RemoteFolderCreated", foldername), new Object[0]);
                }
            }
            catch (Exception e) {
                log.logError(this.toString(), Messages.getString("JobSSH2GET.Log.Error.CreatingRemoteFolder", foldername), new Object[0]);
            }
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    @Override
    public List<ResourceReference> getResourceDependencies(JobMeta jobMeta) {
        List<ResourceReference> references = super.getResourceDependencies(jobMeta);
        if (!Const.isEmpty((String)this.serverName)) {
            String realServerName = jobMeta.environmentSubstitute(this.serverName);
            ResourceReference reference = new ResourceReference(this);
            reference.getEntries().add(new ResourceEntry(realServerName, ResourceEntry.ResourceType.SERVER));
            references.add(reference);
        }
        return references;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        JobEntryValidatorUtils.andValidator().validate(this, "serverName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "localDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileExistsValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "userName", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "password", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notNullValidator()));
        JobEntryValidatorUtils.andValidator().validate(this, "serverPort", remarks, AndValidator.putValidators(JobEntryValidatorUtils.integerValidator()));
    }
}

