/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.job.entries.unzip;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.vfs.AllFileSelector;
import org.apache.commons.vfs.FileObject;
import org.apache.commons.vfs.FileSelectInfo;
import org.apache.commons.vfs.FileSelector;
import org.apache.commons.vfs.FileSystemException;
import org.apache.commons.vfs.FileType;
import org.apache.commons.vfs.VFS;
import org.pentaho.di.cluster.SlaveServer;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Result;
import org.pentaho.di.core.ResultFile;
import org.pentaho.di.core.RowMetaAndData;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleDatabaseException;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.logging.LogWriter;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobEntryType;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.job.entries.unzip.Messages;
import org.pentaho.di.job.entry.JobEntryBase;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.job.entry.validator.AbstractFileValidator;
import org.pentaho.di.job.entry.validator.AndValidator;
import org.pentaho.di.job.entry.validator.JobEntryValidatorUtils;
import org.pentaho.di.job.entry.validator.ValidatorContext;
import org.pentaho.di.repository.Repository;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JobEntryUnZip
extends JobEntryBase
implements Cloneable,
JobEntryInterface {
    private String zipFilename;
    public int afterunzip;
    private String wildcard;
    private String wildcardexclude;
    private String targetdirectory;
    private String movetodirectory;
    private boolean addfiletoresult;
    private boolean isfromprevious;
    private boolean adddate;
    private boolean addtime;
    private boolean SpecifyFormat;
    private String date_time_format;
    private boolean rootzip;
    private boolean createfolder;
    private String nr_limit;
    private String wildcardSource;
    private int iffileexist;
    private boolean createMoveToDirectory;
    public String SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED = "success_when_at_least";
    public String SUCCESS_IF_ERRORS_LESS = "success_if_errors_less";
    public String SUCCESS_IF_NO_ERRORS = "success_if_no_errors";
    private String success_condition;
    public static final int IF_FILE_EXISTS_SKIP = 0;
    public static final int IF_FILE_EXISTS_OVERWRITE = 1;
    public static final int IF_FILE_EXISTS_UNIQ = 2;
    public static final int IF_FILE_EXISTS_FAIL = 3;
    public static final int IF_FILE_EXISTS_OVERWRITE_DIFF_SIZE = 4;
    public static final int IF_FILE_EXISTS_OVERWRITE_EQUAL_SIZE = 5;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG = 6;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_BIG_EQUAL = 7;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL = 8;
    public static final int IF_FILE_EXISTS_OVERWRITE_ZIP_SMALL_EQUAL = 9;
    public static final String[] typeIfFileExistsCode = new String[]{"SKIP", "OVERWRITE", "UNIQ", "FAIL", "OVERWRITE_DIFF_SIZE", "OVERWRITE_EQUAL_SIZE", "OVERWRITE_ZIP_BIG", "OVERWRITE_ZIP_BIG_EQUAL", "OVERWRITE_ZIP_BIG_SMALL", "OVERWRITE_ZIP_BIG_SMALL_EQUAL"};
    public static final String[] typeIfFileExistsDesc = new String[]{Messages.getString("JobUnZip.Skip.Label"), Messages.getString("JobUnZip.Overwrite.Label"), Messages.getString("JobUnZip.Give_Unique_Name.Label"), Messages.getString("JobUnZip.Fail.Label"), Messages.getString("JobUnZip.OverwriteIfSizeDifferent.Label"), Messages.getString("JobUnZip.OverwriteIfSizeEquals.Label"), Messages.getString("JobUnZip.OverwriteIfZipBigger.Label"), Messages.getString("JobUnZip.OverwriteIfZipBiggerOrEqual.Label"), Messages.getString("JobUnZip.OverwriteIfZipSmaller.Label"), Messages.getString("JobUnZip.OverwriteIfZipSmallerOrEqual.Label")};
    private int NrErrors = 0;
    private int NrSuccess = 0;
    boolean successConditionBroken = false;
    boolean successConditionBrokenExit = false;
    int limitFiles = 0;

    public JobEntryUnZip(String n) {
        super(n, "");
        this.zipFilename = null;
        this.afterunzip = 0;
        this.wildcard = null;
        this.wildcardexclude = null;
        this.targetdirectory = null;
        this.movetodirectory = null;
        this.addfiletoresult = false;
        this.isfromprevious = false;
        this.adddate = false;
        this.addtime = false;
        this.SpecifyFormat = false;
        this.rootzip = false;
        this.createfolder = false;
        this.nr_limit = "10";
        this.wildcardSource = null;
        this.iffileexist = 0;
        this.success_condition = this.SUCCESS_IF_NO_ERRORS;
        this.createMoveToDirectory = false;
        this.setID(-1L);
        this.setJobEntryType(JobEntryType.UNZIP);
    }

    public JobEntryUnZip() {
        this("");
    }

    public JobEntryUnZip(JobEntryBase jeb) {
        super(jeb);
    }

    @Override
    public Object clone() {
        JobEntryUnZip je = (JobEntryUnZip)super.clone();
        return je;
    }

    @Override
    public String getXML() {
        StringBuffer retval = new StringBuffer(50);
        retval.append(super.getXML());
        retval.append("      ").append(XMLHandler.addTagValue((String)"zipfilename", (String)this.zipFilename));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcard", (String)this.wildcard));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardexclude", (String)this.wildcardexclude));
        retval.append("      ").append(XMLHandler.addTagValue((String)"targetdirectory", (String)this.targetdirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"movetodirectory", (String)this.movetodirectory));
        retval.append("      ").append(XMLHandler.addTagValue((String)"afterunzip", (int)this.afterunzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addfiletoresult", (boolean)this.addfiletoresult));
        retval.append("      ").append(XMLHandler.addTagValue((String)"isfromprevious", (boolean)this.isfromprevious));
        retval.append("      ").append(XMLHandler.addTagValue((String)"adddate", (boolean)this.adddate));
        retval.append("      ").append(XMLHandler.addTagValue((String)"addtime", (boolean)this.addtime));
        retval.append("      ").append(XMLHandler.addTagValue((String)"SpecifyFormat", (boolean)this.SpecifyFormat));
        retval.append("      ").append(XMLHandler.addTagValue((String)"date_time_format", (String)this.date_time_format));
        retval.append("      ").append(XMLHandler.addTagValue((String)"rootzip", (boolean)this.rootzip));
        retval.append("      ").append(XMLHandler.addTagValue((String)"createfolder", (boolean)this.createfolder));
        retval.append("      ").append(XMLHandler.addTagValue((String)"nr_limit", (String)this.nr_limit));
        retval.append("      ").append(XMLHandler.addTagValue((String)"wildcardSource", (String)this.wildcardSource));
        retval.append("      ").append(XMLHandler.addTagValue((String)"success_condition", (String)this.success_condition));
        retval.append("      ").append(XMLHandler.addTagValue((String)"iffileexists", (String)JobEntryUnZip.getIfFileExistsCode(this.iffileexist)));
        retval.append("      ").append(XMLHandler.addTagValue((String)"create_move_to_directory", (boolean)this.createMoveToDirectory));
        return retval.toString();
    }

    @Override
    public void loadXML(Node entrynode, List<DatabaseMeta> databases, List<SlaveServer> slaveServers, Repository rep) throws KettleXMLException {
        try {
            super.loadXML(entrynode, databases, slaveServers);
            this.zipFilename = XMLHandler.getTagValue((Node)entrynode, (String)"zipfilename");
            this.afterunzip = Const.toInt((String)XMLHandler.getTagValue((Node)entrynode, (String)"afterunzip"), (int)-1);
            this.wildcard = XMLHandler.getTagValue((Node)entrynode, (String)"wildcard");
            this.wildcardexclude = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardexclude");
            this.targetdirectory = XMLHandler.getTagValue((Node)entrynode, (String)"targetdirectory");
            this.movetodirectory = XMLHandler.getTagValue((Node)entrynode, (String)"movetodirectory");
            this.addfiletoresult = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addfiletoresult"));
            this.isfromprevious = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"isfromprevious"));
            this.adddate = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"adddate"));
            this.addtime = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"addtime"));
            this.SpecifyFormat = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"SpecifyFormat"));
            this.date_time_format = XMLHandler.getTagValue((Node)entrynode, (String)"date_time_format");
            this.rootzip = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"rootzip"));
            this.createfolder = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"createfolder"));
            this.nr_limit = XMLHandler.getTagValue((Node)entrynode, (String)"nr_limit");
            this.wildcardSource = XMLHandler.getTagValue((Node)entrynode, (String)"wildcardSource");
            this.success_condition = XMLHandler.getTagValue((Node)entrynode, (String)"success_condition");
            if (Const.isEmpty((String)this.success_condition)) {
                this.success_condition = this.SUCCESS_IF_NO_ERRORS;
            }
            this.iffileexist = JobEntryUnZip.getIfFileExistsInt(XMLHandler.getTagValue((Node)entrynode, (String)"iffileexists"));
            this.createMoveToDirectory = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)entrynode, (String)"create_move_to_directory"));
        }
        catch (KettleXMLException xe) {
            throw new KettleXMLException("Unable to load job entry of type 'unzip' from XML node", (Throwable)xe);
        }
    }

    @Override
    public void loadRep(Repository rep, long id_jobentry, List<DatabaseMeta> databases, List<SlaveServer> slaveServers) throws KettleException {
        try {
            super.loadRep(rep, id_jobentry, databases, slaveServers);
            this.zipFilename = rep.getJobEntryAttributeString(id_jobentry, "zipfilename");
            this.afterunzip = (int)rep.getJobEntryAttributeInteger(id_jobentry, "afterunzip");
            this.wildcard = rep.getJobEntryAttributeString(id_jobentry, "wildcard");
            this.wildcardexclude = rep.getJobEntryAttributeString(id_jobentry, "wildcardexclude");
            this.targetdirectory = rep.getJobEntryAttributeString(id_jobentry, "targetdirectory");
            this.movetodirectory = rep.getJobEntryAttributeString(id_jobentry, "movetodirectory");
            this.addfiletoresult = rep.getJobEntryAttributeBoolean(id_jobentry, "addfiletoresult");
            this.isfromprevious = rep.getJobEntryAttributeBoolean(id_jobentry, "isfromprevious");
            this.adddate = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.addtime = rep.getJobEntryAttributeBoolean(id_jobentry, "adddate");
            this.SpecifyFormat = rep.getJobEntryAttributeBoolean(id_jobentry, "SpecifyFormat");
            this.date_time_format = rep.getJobEntryAttributeString(id_jobentry, "date_time_format");
            this.rootzip = rep.getJobEntryAttributeBoolean(id_jobentry, "rootzip");
            this.createfolder = rep.getJobEntryAttributeBoolean(id_jobentry, "createfolder");
            this.nr_limit = rep.getJobEntryAttributeString(id_jobentry, "nr_limit");
            this.wildcardSource = rep.getJobEntryAttributeString(id_jobentry, "wildcardSource");
            this.success_condition = rep.getJobEntryAttributeString(id_jobentry, "success_condition");
            if (Const.isEmpty((String)this.success_condition)) {
                this.success_condition = this.SUCCESS_IF_NO_ERRORS;
            }
            this.iffileexist = JobEntryUnZip.getIfFileExistsInt(rep.getJobEntryAttributeString(id_jobentry, "iffileexists"));
            this.createMoveToDirectory = rep.getJobEntryAttributeBoolean(id_jobentry, "create_move_to_directory");
        }
        catch (KettleException dbe) {
            throw new KettleException("Unable to load job entry of type 'unzip' from the repository for id_jobentry=" + id_jobentry, (Throwable)dbe);
        }
    }

    @Override
    public void saveRep(Repository rep, long id_job) throws KettleException {
        try {
            super.saveRep(rep, id_job);
            rep.saveJobEntryAttribute(id_job, this.getID(), "zipfilename", this.zipFilename);
            rep.saveJobEntryAttribute(id_job, this.getID(), "afterunzip", this.afterunzip);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcard", this.wildcard);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcardexclude", this.wildcardexclude);
            rep.saveJobEntryAttribute(id_job, this.getID(), "targetdirectory", this.targetdirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "movetodirectory", this.movetodirectory);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addfiletoresult", this.addfiletoresult);
            rep.saveJobEntryAttribute(id_job, this.getID(), "isfromprevious", this.isfromprevious);
            rep.saveJobEntryAttribute(id_job, this.getID(), "addtime", this.addtime);
            rep.saveJobEntryAttribute(id_job, this.getID(), "adddate", this.adddate);
            rep.saveJobEntryAttribute(id_job, this.getID(), "SpecifyFormat", this.SpecifyFormat);
            rep.saveJobEntryAttribute(id_job, this.getID(), "date_time_format", this.date_time_format);
            rep.saveJobEntryAttribute(id_job, this.getID(), "rootzip", this.rootzip);
            rep.saveJobEntryAttribute(id_job, this.getID(), "createfolder", this.createfolder);
            rep.saveJobEntryAttribute(id_job, this.getID(), "nr_limit", this.nr_limit);
            rep.saveJobEntryAttribute(id_job, this.getID(), "wildcardSource", this.wildcardSource);
            rep.saveJobEntryAttribute(id_job, this.getID(), "success_condition", this.success_condition);
            rep.saveJobEntryAttribute(id_job, this.getID(), "iffileexists", JobEntryUnZip.getIfFileExistsCode(this.iffileexist));
            rep.saveJobEntryAttribute(id_job, this.getID(), "create_move_to_directory", this.createMoveToDirectory);
        }
        catch (KettleDatabaseException dbe) {
            throw new KettleException("Unable to save job entry of type 'unzip' to the repository for id_job=" + id_job, (Throwable)dbe);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public Result execute(Result previousResult, int nr, Repository rep, Job parentJob) {
        block80: {
            block89: {
                block88: {
                    block77: {
                        block87: {
                            block86: {
                                block76: {
                                    block85: {
                                        block71: {
                                            block72: {
                                                log = LogWriter.getInstance();
                                                result = previousResult;
                                                result.setResult(false);
                                                result.setEntryNr(1L);
                                                rows = result.getRows();
                                                resultRow = null;
                                                realFilenameSource = this.environmentSubstitute(this.zipFilename);
                                                realWildcardSource = this.environmentSubstitute(this.wildcardSource);
                                                realWildcard = this.environmentSubstitute(this.wildcard);
                                                realWildcardExclude = this.environmentSubstitute(this.wildcardexclude);
                                                realTargetdirectory = this.environmentSubstitute(this.targetdirectory);
                                                realMovetodirectory = this.environmentSubstitute(this.movetodirectory);
                                                this.limitFiles = Const.toInt((String)this.environmentSubstitute(this.getLimit()), (int)10);
                                                this.NrErrors = 0;
                                                this.NrSuccess = 0;
                                                this.successConditionBroken = false;
                                                this.successConditionBrokenExit = false;
                                                if (this.isfromprevious) {
                                                    if (log.isDetailed()) {
                                                        log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.ArgFromPrevious.Found", (rows != null ? rows.size() : 0) + ""), new Object[0]);
                                                    }
                                                    if (rows.size() == 0) {
                                                        return result;
                                                    }
                                                } else if (Const.isEmpty((String)this.zipFilename)) {
                                                    log.logError(this.toString(), Messages.getString("JobUnZip.No_ZipFile_Defined.Label"), new Object[0]);
                                                    return result;
                                                }
                                                fileObject = null;
                                                targetdir = null;
                                                movetodir = null;
                                                try {
                                                    block79: {
                                                        block78: {
                                                            block73: {
                                                                try {
                                                                    block91: {
                                                                        block90: {
                                                                            exitjobentry = false;
                                                                            targetdir = KettleVFS.getFileObject((String)realTargetdirectory);
                                                                            if (targetdir.exists()) break block90;
                                                                            if (this.createfolder) {
                                                                                targetdir.createFolder();
                                                                                if (log.isDetailed()) {
                                                                                    log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.TargetFolderCreated", realTargetdirectory), new Object[0]);
                                                                                }
                                                                                break block91;
                                                                            } else {
                                                                                log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.TargetFolderNotFound.Label"), new Object[0]);
                                                                                exitjobentry = true;
                                                                            }
                                                                            break block91;
                                                                        }
                                                                        if (targetdir.getType() != FileType.FOLDER) {
                                                                            log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.TargetFolderNotFolder.Label", realTargetdirectory), new Object[0]);
                                                                            exitjobentry = true;
                                                                        } else if (log.isDetailed()) {
                                                                            log.logDetailed(this.toString(), Messages.getString("JobUnZip.TargetFolderExists.Label", realTargetdirectory), new Object[0]);
                                                                        }
                                                                    }
                                                                    if (this.afterunzip == 2) {
                                                                        if (Const.isEmpty((String)this.movetodirectory)) {
                                                                            log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.MoveToDirectoryEmpty.Label"), new Object[0]);
                                                                            exitjobentry = true;
                                                                        } else {
                                                                            movetodir = KettleVFS.getFileObject((String)realMovetodirectory);
                                                                            if (!movetodir.exists() || movetodir.getType() != FileType.FOLDER) {
                                                                                if (this.createMoveToDirectory) {
                                                                                    movetodir.createFolder();
                                                                                    if (log.isDetailed()) {
                                                                                        log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.MoveToFolderCreated", realMovetodirectory), new Object[0]);
                                                                                    }
                                                                                } else {
                                                                                    log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.MoveToDirectoryNotExists.Label"), new Object[0]);
                                                                                    exitjobentry = true;
                                                                                }
                                                                            }
                                                                        }
                                                                    }
                                                                    if (exitjobentry) {
                                                                        var19_20 = result;
                                                                        var22_24 = null;
                                                                        if (fileObject == null) break block71;
                                                                        break block72;
                                                                    }
                                                                    if (this.isfromprevious) {
                                                                        if (rows == null) break block73;
                                                                        for (iteration = 0; iteration < rows.size() && !parentJob.isStopped(); ++iteration) {
                                                                            if (this.successConditionBroken) {
                                                                                if (!this.successConditionBrokenExit) {
                                                                                    log.logError(this.toString(), Messages.getString("JobUnZip.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                                                                                    this.successConditionBrokenExit = true;
                                                                                }
                                                                                result.setEntryNr((long)this.NrErrors);
                                                                                var20_38 = result;
                                                                                var22_25 = null;
                                                                                if (fileObject != null) {
                                                                                    try {
                                                                                        fileObject.close();
                                                                                    }
                                                                                    catch (IOException ex) {
                                                                                        // empty catch block
                                                                                    }
                                                                                }
                                                                                if (targetdir != null) {
                                                                                    try {
                                                                                        targetdir.close();
                                                                                    }
                                                                                    catch (IOException ex) {
                                                                                        // empty catch block
                                                                                    }
                                                                                }
                                                                                if (movetodir == null) return var20_38;
                                                                                try {
                                                                                    movetodir.close();
                                                                                    return var20_38;
                                                                                }
                                                                                catch (IOException ex) {
                                                                                    // empty catch block
                                                                                }
                                                                                return var20_38;
                                                                            }
                                                                            resultRow = (RowMetaAndData)rows.get(iteration);
                                                                            realFilenameSource = resultRow.getString(0, null);
                                                                            realWildcardSource = resultRow.getString(1, null);
                                                                            fileObject = KettleVFS.getFileObject((String)realFilenameSource);
                                                                            if (fileObject.exists()) {
                                                                                this.processOneFile(log, result, parentJob, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                                                                                continue;
                                                                            }
                                                                            this.updateErrors();
                                                                            log.logError(this.toString(), Messages.getString("JobUnZip.Error.CanNotFindFile", realFilenameSource), new Object[0]);
                                                                        }
                                                                        break block73;
                                                                    }
                                                                    fileObject = KettleVFS.getFileObject((String)realFilenameSource);
                                                                    if (!fileObject.exists()) {
                                                                        log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.ZipFile.NotExists.Label", realFilenameSource), new Object[0]);
                                                                        var19_22 = result;
                                                                        break block76;
                                                                    }
                                                                    if (log.isDetailed()) {
                                                                        log.logDetailed(this.toString(), Messages.getString("JobUnZip.Zip_FileExists.Label", realFilenameSource), new Object[0]);
                                                                    }
                                                                    if (Const.isEmpty((String)this.targetdirectory)) {
                                                                        log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.TargetFolderNotFound.Label"), new Object[0]);
                                                                        var19_23 = result;
                                                                        break block77;
                                                                    }
                                                                    this.processOneFile(log, result, parentJob, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, movetodir, realMovetodirectory, realWildcardSource);
                                                                }
                                                                catch (Exception e) {
                                                                    block82: {
                                                                        block81: {
                                                                            log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.ErrorUnzip.Label", realFilenameSource, e.getMessage()), new Object[0]);
                                                                            this.updateErrors();
                                                                            var22_29 = null;
                                                                            if (fileObject != null) {
                                                                                ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl137:
                                                                                // 1 sources

                                                                                fileObject.close();
                                                                                break block81;
lbl139:
                                                                                // 1 sources

                                                                                catch (IOException ex) {
                                                                                    // empty catch block
                                                                                }
                                                                            }
                                                                        }
                                                                        if (targetdir != null) {
                                                                            ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl144:
                                                                            // 1 sources

                                                                            targetdir.close();
                                                                            break block82;
lbl146:
                                                                            // 1 sources

                                                                            catch (IOException ex) {
                                                                                // empty catch block
                                                                            }
                                                                        }
                                                                    }
                                                                    if (movetodir != null) {
                                                                        try {}
                                                                        catch (IOException ex) {}
                                                                        movetodir.close();
                                                                    }
                                                                    break block80;
                                                                }
                                                            }
                                                            var22_28 = null;
                                                            if (fileObject != null) {
                                                                ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl159:
                                                                // 1 sources

                                                                fileObject.close();
                                                                break block78;
lbl161:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (targetdir != null) {
                                                            ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl166:
                                                            // 1 sources

                                                            targetdir.close();
                                                            break block79;
lbl168:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (movetodir != null) {
                                                        try {}
                                                        catch (IOException ex) {}
                                                        movetodir.close();
                                                    }
                                                    break block80;
                                                }
                                                catch (Throwable var21_39) {
                                                    block84: {
                                                        block83: {
                                                            var22_30 = null;
                                                            if (fileObject != null) {
                                                                ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl182:
                                                                // 1 sources

                                                                fileObject.close();
                                                                break block83;
lbl184:
                                                                // 1 sources

                                                                catch (IOException ex) {
                                                                    // empty catch block
                                                                }
                                                            }
                                                        }
                                                        if (targetdir != null) {
                                                            ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl189:
                                                            // 1 sources

                                                            targetdir.close();
                                                            break block84;
lbl191:
                                                            // 1 sources

                                                            catch (IOException ex) {
                                                                // empty catch block
                                                            }
                                                        }
                                                    }
                                                    if (movetodir == null) throw var21_39;
                                                    ** try [egrp 4[TRYBLOCK] [14 : 1017->1027)] { 
lbl196:
                                                    // 1 sources

                                                    movetodir.close();
                                                    throw var21_39;
lbl198:
                                                    // 1 sources

                                                    catch (IOException ex) {
                                                        // empty catch block
                                                    }
                                                    throw var21_39;
                                                }
                                            }
                                            ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl203:
                                            // 1 sources

                                            fileObject.close();
                                            break block71;
lbl205:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                        if (targetdir != null) {
                                            ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl210:
                                            // 1 sources

                                            targetdir.close();
                                            break block85;
lbl212:
                                            // 1 sources

                                            catch (IOException ex) {
                                                // empty catch block
                                            }
                                        }
                                    }
                                    if (movetodir == null) return var19_20;
                                    ** try [egrp 4[TRYBLOCK] [14 : 1017->1027)] { 
lbl217:
                                    // 1 sources

                                    movetodir.close();
                                    return var19_20;
lbl219:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                    return var19_20;
                                }
                                var22_26 = null;
                                if (fileObject != null) {
                                    ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl226:
                                    // 1 sources

                                    fileObject.close();
                                    break block86;
lbl228:
                                    // 1 sources

                                    catch (IOException ex) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (targetdir != null) {
                                ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl233:
                                // 1 sources

                                targetdir.close();
                                break block87;
lbl235:
                                // 1 sources

                                catch (IOException ex) {
                                    // empty catch block
                                }
                            }
                        }
                        if (movetodir == null) return var19_22;
                        ** try [egrp 4[TRYBLOCK] [14 : 1017->1027)] { 
lbl240:
                        // 1 sources

                        movetodir.close();
                        return var19_22;
lbl242:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                        return var19_22;
                    }
                    var22_27 = null;
                    if (fileObject != null) {
                        ** try [egrp 2[TRYBLOCK] [12 : 983->993)] { 
lbl249:
                        // 1 sources

                        fileObject.close();
                        break block88;
lbl251:
                        // 1 sources

                        catch (IOException ex) {
                            // empty catch block
                        }
                    }
                }
                if (targetdir != null) {
                    ** try [egrp 3[TRYBLOCK] [13 : 1000->1010)] { 
lbl256:
                    // 1 sources

                    targetdir.close();
                    break block89;
lbl258:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                }
            }
            if (movetodir == null) return var19_23;
            ** try [egrp 4[TRYBLOCK] [14 : 1017->1027)] { 
lbl263:
            // 1 sources

            movetodir.close();
            return var19_23;
lbl265:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var19_23;
        }
        result.setNrErrors((long)this.NrErrors);
        result.setNrLinesWritten((long)this.NrSuccess);
        if (this.getSuccessStatus()) {
            result.setResult(true);
        }
        this.displayResults(log);
        return result;
    }

    private void displayResults(LogWriter log) {
        if (log.isDetailed()) {
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.Info.FilesInError", "" + this.NrErrors), new Object[0]);
            log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.Info.FilesInSuccess", "" + this.NrSuccess), new Object[0]);
            log.logDetailed(this.toString(), "=======================================", new Object[0]);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean processOneFile(LogWriter log, Result result, Job parentJob, FileObject fileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, FileObject movetodir, String realMovetodirectory, String realWildcardSource) {
        block19: {
            block20: {
                retval = false;
                try {
                    try {
                        if (fileObject.getType().equals(FileType.FILE)) {
                            if (!this.unzipFile(log, fileObject, realTargetdirectory, realWildcard, realWildcardExclude, result, parentJob, fileObject, movetodir, realMovetodirectory)) {
                                this.updateErrors();
                                break block19;
                            } else {
                                this.updateSuccess();
                            }
                            break block19;
                        }
                        children = fileObject.getChildren();
                        for (i = 0; i < children.length && !parentJob.isStopped(); ++i) {
                            if (this.successConditionBroken) {
                                if (!this.successConditionBrokenExit) {
                                    log.logError(this.toString(), Messages.getString("JobUnZip.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                                    this.successConditionBrokenExit = true;
                                }
                                var14_15 = false;
                                var19_19 = null;
                                if (fileObject == null) return var14_15;
                                break block20;
                            }
                            if (children[i].getType().equals(FileType.FOLDER)) continue;
                            unzip = true;
                            filename = children[i].getName().getPath();
                            patternSource = null;
                            if (!Const.isEmpty((String)realWildcardSource)) {
                                patternSource = Pattern.compile(realWildcardSource);
                            }
                            if (patternSource != null) {
                                matcher = patternSource.matcher(filename);
                                unzip = matcher.matches();
                            }
                            if (!unzip) continue;
                            if (!this.unzipFile(log, children[i], realTargetdirectory, realWildcard, realWildcardExclude, result, parentJob, fileObject, movetodir, realMovetodirectory)) {
                                this.updateErrors();
                                continue;
                            }
                            this.updateSuccess();
                        }
                        break block19;
                    }
                    catch (Exception e) {
                        this.updateErrors();
                        log.logError(this.toString(), Messages.getString("JobUnZip.Error.Label", e.getMessage()), new Object[0]);
                        var19_21 = null;
                        if (fileObject == null) return retval;
                        try {
                            fileObject.close();
                            return retval;
                        }
                        catch (IOException ex) {
                            return retval;
                        }
                    }
                }
                catch (Throwable var18_27) {
                    var19_22 = null;
                    if (fileObject == null) throw var18_27;
                    ** try [egrp 2[TRYBLOCK] [6 : 333->343)] { 
lbl53:
                    // 1 sources

                    fileObject.close();
                    throw var18_27;
lbl55:
                    // 1 sources

                    catch (IOException ex) {
                        // empty catch block
                    }
                    throw var18_27;
                }
            }
            ** try [egrp 2[TRYBLOCK] [6 : 333->343)] { 
lbl60:
            // 1 sources

            fileObject.close();
            return var14_15;
lbl62:
            // 1 sources

            catch (IOException ex) {
                // empty catch block
            }
            return var14_15;
        }
        var19_20 = null;
        if (fileObject == null) return retval;
        try {}
        catch (IOException ex) {}
        fileObject.close();
        return retval;
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean unzipFile(LogWriter log, FileObject sourceFileObject, String realTargetdirectory, String realWildcard, String realWildcardExclude, Result result, Job parentJob, FileObject fileObject, FileObject movetodir, String realMovetodirectory) {
        boolean retval = false;
        try {
            FileObject destFile;
            block53: {
                if (log.isDetailed()) {
                    log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.ProcessingFile", sourceFileObject.toString()), new Object[0]);
                }
                if (this.rootzip) {
                    String foldername;
                    FileObject rootfolder;
                    String shortSourceFilename = sourceFileObject.getName().getBaseName();
                    int lenstring = shortSourceFilename.length();
                    int lastindexOfDot = shortSourceFilename.lastIndexOf(46);
                    if (lastindexOfDot == -1) {
                        lastindexOfDot = lenstring;
                    }
                    if (!(rootfolder = KettleVFS.getFileObject((String)(foldername = realTargetdirectory + "/" + shortSourceFilename.substring(0, lastindexOfDot)))).exists()) {
                        try {
                            rootfolder.createFolder();
                            if (log.isDetailed()) {
                                log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.RootFolderCreated", foldername), new Object[0]);
                            }
                        }
                        catch (Exception e) {
                            throw new Exception(Messages.getString("JobUnZip.Error.CanNotCreateRootFolder", foldername), e);
                        }
                    }
                }
                String zipFilename = "zip:" + sourceFileObject.getName().getFriendlyURI();
                FileObject zipFile = KettleVFS.getFileObject((String)zipFilename);
                FileObject[] items = zipFile.findFiles((FileSelector)new AllFileSelector(){

                    public boolean traverseDescendents(FileSelectInfo info) {
                        return true;
                    }

                    public boolean includeFile(FileSelectInfo info) {
                        if (info.getDepth() == 0) {
                            return false;
                        }
                        FileObject fileObject = info.getFile();
                        return fileObject != null;
                    }
                });
                Pattern pattern = null;
                if (!Const.isEmpty((String)realWildcard)) {
                    pattern = Pattern.compile(realWildcard);
                }
                Pattern patternexclude = null;
                if (!Const.isEmpty((String)realWildcardExclude)) {
                    patternexclude = Pattern.compile(realWildcardExclude);
                }
                for (FileObject item : items) {
                    Exception e2;
                    Object var33_42;
                    FileObject newFileObject;
                    block51: {
                        block55: {
                            String newFileName;
                            block54: {
                                if (this.successConditionBroken) {
                                    if (this.successConditionBrokenExit) return false;
                                    log.logError(this.toString(), Messages.getString("JobUnZip.Error.SuccessConditionbroken", "" + this.NrErrors), new Object[0]);
                                    this.successConditionBrokenExit = true;
                                    return false;
                                }
                                newFileObject = null;
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.ProcessingZipEntry", item.getName().getURI(), sourceFileObject.toString()), new Object[0]);
                                }
                                newFileName = realTargetdirectory + Const.FILE_SEPARATOR + this.getTargetFilename(item.getName().getPath());
                                newFileObject = KettleVFS.getFileObject((String)newFileName);
                                if (!item.getType().equals(FileType.FOLDER)) break block54;
                                if (log.isDetailed()) {
                                    log.logDetailed(this.toString(), Messages.getString("JobUnZip.CreatingDirectory.Label", newFileName), new Object[0]);
                                }
                                if (!newFileObject.exists()) {
                                    newFileObject.createFolder();
                                }
                                break block55;
                            }
                            boolean getIt = true;
                            boolean getItexclude = false;
                            if (pattern != null) {
                                Matcher matcher = pattern.matcher(item.getName().getURI());
                                getIt = matcher.matches();
                            }
                            if (patternexclude != null) {
                                Matcher matcherexclude = patternexclude.matcher(item.getName().getURI());
                                getItexclude = matcherexclude.matches();
                            }
                            boolean take = this.takeThisFile(log, item, newFileName);
                            if (getIt && !getItexclude && take) {
                                OutputStream os;
                                block50: {
                                    Object var31_41;
                                    if (log.isDetailed()) {
                                        log.logDetailed(this.toString(), Messages.getString("JobUnZip.ExtractingEntry.Label", item.getName().getURI(), newFileName), new Object[0]);
                                    }
                                    if (this.iffileexist == 2) {
                                        int lenstring = newFileName.length();
                                        int lastindexOfDot = newFileName.lastIndexOf(46);
                                        if (lastindexOfDot == -1) {
                                            lastindexOfDot = lenstring;
                                        }
                                        newFileName = newFileName.substring(0, lastindexOfDot) + StringUtil.getFormattedDateTimeNow((boolean)true) + newFileName.substring(lastindexOfDot, lenstring);
                                        if (log.isDebug()) {
                                            log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.CreatingUniqFile", newFileName), new Object[0]);
                                        }
                                    }
                                    if (!newFileObject.getParent().exists()) {
                                        newFileObject.getParent().createFolder();
                                    }
                                    InputStream is = null;
                                    os = null;
                                    try {
                                        is = KettleVFS.getInputStream((FileObject)item);
                                        os = KettleVFS.getOutputStream((FileObject)newFileObject, (boolean)false);
                                        if (is != null) {
                                            int len;
                                            byte[] buff = new byte[2048];
                                            while ((len = is.read(buff)) > 0) {
                                                os.write(buff, 0, len);
                                            }
                                            this.addFilenameToResultFilenames(result, parentJob, newFileName);
                                        }
                                        var31_41 = null;
                                        if (is == null) break block50;
                                    }
                                    catch (Throwable throwable) {
                                        var31_41 = null;
                                        if (is != null) {
                                            is.close();
                                        }
                                        if (os == null) throw throwable;
                                        os.close();
                                        throw throwable;
                                    }
                                    is.close();
                                }
                                if (os != null) {
                                    os.close();
                                }
                            }
                        }
                        var33_42 = null;
                        if (newFileObject == null) break block51;
                        try {
                            newFileObject.close();
                        }
                        catch (Exception e2) {
                            // empty catch block
                        }
                    }
                    VFS.getManager().closeFileSystem(item.getFileSystem());
                    if (items == null) continue;
                    items = null;
                    {
                        continue;
                        catch (Exception e3) {
                            this.updateErrors();
                            log.logError(this.toString(), Messages.getString("JobUnZip.Error.CanNotProcessZipEntry", item.getName().getURI(), sourceFileObject.toString()), (Throwable)e3);
                            var33_42 = null;
                            if (newFileObject != null) {
                                try {
                                    newFileObject.close();
                                }
                                catch (Exception e2) {
                                    // empty catch block
                                }
                            }
                            VFS.getManager().closeFileSystem(item.getFileSystem());
                            if (items == null) continue;
                            items = null;
                            continue;
                        }
                    }
                    catch (Throwable throwable) {
                        var33_42 = null;
                        if (newFileObject != null) {
                            try {
                                newFileObject.close();
                            }
                            catch (Exception e2) {
                                // empty catch block
                            }
                        }
                        VFS.getManager().closeFileSystem(item.getFileSystem());
                        if (items == null) throw throwable;
                        items = null;
                        throw throwable;
                    }
                }
                if (this.afterunzip == 1) {
                    boolean deleted = fileObject.delete();
                    if (!deleted) {
                        this.updateErrors();
                        log.logError(this.toString(), Messages.getString("JobUnZip.Cant_Delete_File.Label", sourceFileObject.toString()), new Object[0]);
                    }
                    if (!log.isDebug()) return true;
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.File_Deleted.Label", sourceFileObject.toString()), new Object[0]);
                    return true;
                }
                if (this.afterunzip != 2) return true;
                destFile = null;
                String destinationFilename = movetodir + Const.FILE_SEPARATOR + fileObject.getName().getBaseName();
                destFile = KettleVFS.getFileObject((String)destinationFilename);
                fileObject.moveTo(destFile);
                if (!log.isDetailed()) break block53;
                log.logDetailed(this.toString(), Messages.getString("JobUnZip.Log.FileMovedTo", sourceFileObject.toString(), realMovetodirectory), new Object[0]);
            }
            Object var36_46 = null;
            if (destFile == null) return true;
            try {
                destFile.close();
                return true;
            }
            catch (IOException ex) {}
            return true;
            {
                catch (Exception e) {
                    this.updateErrors();
                    log.logError(this.toString(), Messages.getString("JobUnZip.Cant_Move_File.Label", sourceFileObject.toString(), realMovetodirectory, e.getMessage()), new Object[0]);
                    Object var36_47 = null;
                    if (destFile == null) return true;
                    try {
                        destFile.close();
                        return true;
                    }
                    catch (IOException ex) {}
                    return true;
                }
            }
            catch (Throwable throwable) {
                Object var36_48 = null;
                if (destFile == null) throw throwable;
                try {
                    destFile.close();
                    throw throwable;
                }
                catch (IOException ex) {
                    // empty catch block
                }
                throw throwable;
            }
        }
        catch (Exception e) {
            this.updateErrors();
            log.logError(Messages.getString("JobUnZip.Error.Label"), Messages.getString("JobUnZip.ErrorUnzip.Label", sourceFileObject.toString(), e.getMessage()), (Throwable)e);
        }
        return retval;
    }

    private void addFilenameToResultFilenames(Result result, Job parentJob, String newfile) throws Exception {
        if (this.addfiletoresult) {
            ResultFile resultFile = new ResultFile(0, KettleVFS.getFileObject((String)newfile), parentJob.getJobname(), this.toString());
            result.getResultFiles().put(resultFile.getFile().toString(), resultFile);
        }
    }

    private void updateErrors() {
        ++this.NrErrors;
        if (this.checkIfSuccessConditionBroken()) {
            this.successConditionBroken = true;
        }
    }

    private void updateSuccess() {
        ++this.NrSuccess;
    }

    private boolean checkIfSuccessConditionBroken() {
        boolean retval = false;
        if (this.NrErrors > 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrErrors >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean getSuccessStatus() {
        boolean retval = false;
        if (this.NrErrors == 0 && this.getSuccessCondition().equals(this.SUCCESS_IF_NO_ERRORS) || this.NrSuccess >= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_AT_LEAST_X_FILES_UN_ZIPPED) || this.NrErrors <= this.limitFiles && this.getSuccessCondition().equals(this.SUCCESS_IF_ERRORS_LESS)) {
            retval = true;
        }
        return retval;
    }

    private boolean takeThisFile(LogWriter log, FileObject sourceFile, String destinationFile) throws FileSystemException {
        boolean retval = false;
        File destination = new File(destinationFile);
        if (!destination.exists()) {
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.CanNotFindFile", destinationFile), new Object[0]);
            }
            return true;
        }
        if (log.isDebug()) {
            log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileExists", destinationFile), new Object[0]);
        }
        if (this.iffileexist == 0) {
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileSkip", destinationFile), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 3) {
            this.updateErrors();
            log.logError(this.toString(), Messages.getString("JobUnZip.Log.FileError", destinationFile, "" + this.NrErrors), new Object[0]);
            return false;
        }
        if (this.iffileexist == 1) {
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileOverwrite", destinationFile), new Object[0]);
            }
            return true;
        }
        Long entrySize = sourceFile.getContent().getSize();
        Long destinationSize = destination.length();
        if (this.iffileexist == 4) {
            if (entrySize != destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileDiffSize.Diff", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileDiffSize.Same", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 5) {
            if (entrySize == destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileEqualSize.Same", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileEqualSize.Diff", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 6) {
            if (entrySize > destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileBigSize.Big", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileBigSize.Small", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 7) {
            if (entrySize >= destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileBigEqualSize.Big", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileBigEqualSize.Small", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 8) {
            if (entrySize < destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileSmallSize.Small", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileSmallSize.Big", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 9) {
            if (entrySize <= destinationSize) {
                if (log.isDebug()) {
                    log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileSmallEqualSize.Small", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
                }
                return true;
            }
            if (log.isDebug()) {
                log.logDebug(this.toString(), Messages.getString("JobUnZip.Log.FileSmallEqualSize.Big", sourceFile.getName().getURI(), "" + entrySize, destinationFile, "" + destinationSize), new Object[0]);
            }
            return false;
        }
        if (this.iffileexist == 2) {
            return true;
        }
        return retval;
    }

    @Override
    public boolean evaluates() {
        return true;
    }

    public static final int getIfFileExistsInt(String desc) {
        for (int i = 0; i < typeIfFileExistsCode.length; ++i) {
            if (!typeIfFileExistsCode[i].equalsIgnoreCase(desc)) continue;
            return i;
        }
        return 0;
    }

    public static final String getIfFileExistsCode(int i) {
        if (i < 0 || i >= typeIfFileExistsCode.length) {
            return null;
        }
        return typeIfFileExistsCode[i];
    }

    public int getIfFileExist() {
        return this.iffileexist;
    }

    public void setIfFileExists(int iffileexist) {
        this.iffileexist = iffileexist;
    }

    public boolean isCreateMoveToDirectory() {
        return this.createMoveToDirectory;
    }

    public void setCreateMoveToDirectory(boolean createMoveToDirectory) {
        this.createMoveToDirectory = createMoveToDirectory;
    }

    public void setZipFilename(String zipFilename) {
        this.zipFilename = zipFilename;
    }

    public void setWildcard(String wildcard) {
        this.wildcard = wildcard;
    }

    public void setWildcardExclude(String wildcardexclude) {
        this.wildcardexclude = wildcardexclude;
    }

    public void setSourceDirectory(String targetdirectoryin) {
        this.targetdirectory = targetdirectoryin;
    }

    public void setMoveToDirectory(String movetodirectory) {
        this.movetodirectory = movetodirectory;
    }

    public String getSourceDirectory() {
        return this.targetdirectory;
    }

    public String getMoveToDirectory() {
        return this.movetodirectory;
    }

    public String getZipFilename() {
        return this.zipFilename;
    }

    public String getWildcardSource() {
        return this.wildcardSource;
    }

    public void setWildcardSource(String wildcardSource) {
        this.wildcardSource = wildcardSource;
    }

    public String getWildcard() {
        return this.wildcard;
    }

    public String getWildcardExclude() {
        return this.wildcardexclude;
    }

    public void setAddFileToResult(boolean addfiletoresultin) {
        this.addfiletoresult = addfiletoresultin;
    }

    public boolean isAddFileToResult() {
        return this.addfiletoresult;
    }

    public void setDateInFilename(boolean adddate) {
        this.adddate = adddate;
    }

    public boolean isDateInFilename() {
        return this.adddate;
    }

    public void setTimeInFilename(boolean addtime) {
        this.addtime = addtime;
    }

    public boolean isTimeInFilename() {
        return this.addtime;
    }

    public boolean isSpecifyFormat() {
        return this.SpecifyFormat;
    }

    public void setSpecifyFormat(boolean SpecifyFormat) {
        this.SpecifyFormat = SpecifyFormat;
    }

    public String getDateTimeFormat() {
        return this.date_time_format;
    }

    public void setDateTimeFormat(String date_time_format) {
        this.date_time_format = date_time_format;
    }

    public void setDatafromprevious(boolean isfromprevious) {
        this.isfromprevious = isfromprevious;
    }

    public boolean getDatafromprevious() {
        return this.isfromprevious;
    }

    public void setCreateRootFolder(boolean rootzip) {
        this.rootzip = rootzip;
    }

    public boolean isCreateRootFolder() {
        return this.rootzip;
    }

    public void setCreateFolder(boolean createfolder) {
        this.createfolder = createfolder;
    }

    public boolean isCreateFolder() {
        return this.createfolder;
    }

    public void setLimit(String nr_limitin) {
        this.nr_limit = nr_limitin;
    }

    public String getLimit() {
        return this.nr_limit;
    }

    public void setSuccessCondition(String success_condition) {
        this.success_condition = success_condition;
    }

    public String getSuccessCondition() {
        return this.success_condition;
    }

    protected String getTargetFilename(String filename) {
        String retval = "";
        if (filename != null) {
            retval = filename;
        }
        int lenstring = retval.length();
        int lastindexOfDot = retval.lastIndexOf(46);
        if (lastindexOfDot == -1) {
            lastindexOfDot = lenstring;
        }
        retval = retval.substring(0, lastindexOfDot);
        SimpleDateFormat daf = new SimpleDateFormat();
        Date now = new Date();
        if (this.SpecifyFormat && !Const.isEmpty((String)this.date_time_format)) {
            daf.applyPattern(this.date_time_format);
            String dt = daf.format(now);
            retval = retval + dt;
        } else {
            if (this.adddate) {
                daf.applyPattern("yyyyMMdd");
                String d = daf.format(now);
                retval = retval + "_" + d;
            }
            if (this.addtime) {
                daf.applyPattern("HHmmssSSS");
                String t = daf.format(now);
                retval = retval + "_" + t;
            }
        }
        retval = retval + filename.substring(lastindexOfDot, lenstring);
        return retval;
    }

    @Override
    public void check(List<CheckResultInterface> remarks, JobMeta jobMeta) {
        ValidatorContext ctx1 = new ValidatorContext();
        AbstractFileValidator.putVariableSpace(ctx1, this.getVariables());
        AndValidator.putValidators(ctx1, JobEntryValidatorUtils.notBlankValidator(), JobEntryValidatorUtils.fileDoesNotExistValidator());
        JobEntryValidatorUtils.andValidator().validate(this, "zipFilename", remarks, ctx1);
        if (2 == this.afterunzip) {
            JobEntryValidatorUtils.andValidator().validate(this, "moveToDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
        }
        JobEntryValidatorUtils.andValidator().validate(this, "sourceDirectory", remarks, AndValidator.putValidators(JobEntryValidatorUtils.notBlankValidator()));
    }
}

