/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.graph;

import ca.sqlpower.graph.BreadthFirstSearch;
import ca.sqlpower.graph.BreadthFirstSearchListener;
import ca.sqlpower.graph.GraphModel;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import org.apache.log4j.Logger;

public class ConnectedComponentFinder<V, E> {
    private static final Logger logger = Logger.getLogger(ConnectedComponentFinder.class);
    private Comparator<V> comparator;

    public ConnectedComponentFinder() {
        this.comparator = null;
    }

    public ConnectedComponentFinder(Comparator<V> c) {
        this.comparator = c;
    }

    public Set<Set<V>> findConnectedComponents(GraphModel<V, E> model) {
        HashSet<V> undiscovered;
        if (this.comparator != null) {
            ArrayList<V> sortedNodes = new ArrayList<V>(model.getNodes());
            Collections.sort(sortedNodes, this.comparator);
            undiscovered = new LinkedHashSet<V>(sortedNodes);
        } else {
            undiscovered = new HashSet<V>();
            undiscovered.addAll(model.getNodes());
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Nodes to process:" + undiscovered));
        }
        final HashSet thisComponent = new HashSet();
        LinkedHashSet<Set<V>> components = new LinkedHashSet<Set<V>>();
        BreadthFirstSearch<V, E> bfs = new BreadthFirstSearch<V, E>();
        bfs.addBreadthFirstSearchListener(new BreadthFirstSearchListener<V>(){

            @Override
            public void nodeDiscovered(V node) {
                undiscovered.remove(node);
                thisComponent.add(node);
            }
        });
        while (!undiscovered.isEmpty()) {
            logger.debug((Object)"Starting new BFS");
            Object node = undiscovered.iterator().next();
            bfs.performSearch(model, node);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("  Search found " + thisComponent.size() + " nodes"));
            }
            components.add(new HashSet(thisComponent));
            thisComponent.clear();
        }
        return components;
    }
}

