/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.mime4j.field.address;

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.io.Serializable;
import java.io.StringReader;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.james.mime4j.field.address.Address;
import org.apache.james.mime4j.field.address.Builder;
import org.apache.james.mime4j.field.address.Mailbox;
import org.apache.james.mime4j.field.address.MailboxList;
import org.apache.james.mime4j.field.address.parser.AddressListParser;
import org.apache.james.mime4j.field.address.parser.ParseException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AddressList
extends AbstractList<Address>
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final List<? extends Address> addresses;

    public AddressList(List<? extends Address> addresses, boolean dontCopy) {
        this.addresses = addresses != null ? (dontCopy ? addresses : new ArrayList(addresses)) : Collections.emptyList();
    }

    @Override
    public int size() {
        return this.addresses.size();
    }

    @Override
    public Address get(int index) {
        return this.addresses.get(index);
    }

    public MailboxList flatten() {
        boolean groupDetected = false;
        for (Address address : this.addresses) {
            if (address instanceof Mailbox) continue;
            groupDetected = true;
            break;
        }
        if (!groupDetected) {
            List<? extends Address> mailboxes = this.addresses;
            return new MailboxList(mailboxes, true);
        }
        ArrayList<Mailbox> results = new ArrayList<Mailbox>();
        for (Address address : this.addresses) {
            address.addMailboxesTo(results);
        }
        return new MailboxList(results, false);
    }

    public void print() {
        for (Address address : this.addresses) {
            System.out.println(address.toString());
        }
    }

    public static AddressList parse(String rawAddressList) throws ParseException {
        AddressListParser parser = new AddressListParser(new StringReader(rawAddressList));
        return Builder.getInstance().buildAddressList(parser.parseAddressList());
    }

    public static void main(String[] args) throws Exception {
        BufferedReader reader = new BufferedReader(new InputStreamReader(System.in));
        while (true) {
            try {
                while (true) {
                    System.out.print("> ");
                    String line = reader.readLine();
                    if (line.length() == 0 || line.toLowerCase().equals("exit") || line.toLowerCase().equals("quit")) {
                        System.out.println("Goodbye.");
                        return;
                    }
                    AddressList list = AddressList.parse(line);
                    list.print();
                }
            }
            catch (Exception e) {
                e.printStackTrace();
                Thread.sleep(300L);
                continue;
            }
            break;
        }
    }
}

