/*
 * Decompiled with CFR 0.152.
 */
package org.fife.ui.rsyntaxtextarea;

import javax.swing.event.DocumentEvent;
import javax.swing.text.AbstractDocument;
import javax.swing.text.BadLocationException;
import javax.swing.text.Element;
import javax.swing.text.GapContent;
import javax.swing.text.Segment;
import org.fife.ui.rsyntaxtextarea.RSyntaxTextArea;
import org.fife.ui.rsyntaxtextarea.SyntaxConstants;
import org.fife.ui.rsyntaxtextarea.Token;
import org.fife.ui.rsyntaxtextarea.TokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.AssemblerX86TokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.CPlusPlusTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.CSSTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.CSharpTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.CTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.FortranTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.GroovyTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.HTMLTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.JSPTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.JavaScriptTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.JavaTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.LuaTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PerlTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PlainTextTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PropertiesFileTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.PythonTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.SASTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.SQLTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.TclTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.UnixShellTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.WindowsBatchTokenMaker;
import org.fife.ui.rsyntaxtextarea.modes.XMLTokenMaker;
import org.fife.ui.rtextarea.RTextAreaDocument;
import org.fife.util.DynamicIntArray;

public class RSyntaxDocument
extends RTextAreaDocument
implements SyntaxConstants {
    private TokenMaker tokenMaker;
    protected DynamicIntArray lastTokensOnLines;
    private transient Segment s;

    public RSyntaxDocument(int n) {
        super(new GapContent());
        this.putProperty("tabSize", new Integer(5));
        this.lastTokensOnLines = new DynamicIntArray(400);
        this.lastTokensOnLines.add(0);
        this.s = new Segment();
        this.setSyntaxStyle(n);
    }

    protected void fireInsertUpdate(DocumentEvent documentEvent) {
        int n;
        Element element = this.getDefaultRootElement();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray = elementChange == null ? null : elementChange.getChildrenAdded();
        int n2 = element.getElementCount();
        int n3 = element.getElementIndex(documentEvent.getOffset());
        int n4 = n3 - 1;
        int n5 = n = n4 > -1 ? this.lastTokensOnLines.get(n4) : 0;
        if (elementArray != null && elementArray.length > 0) {
            Element[] elementArray2 = elementChange.getChildrenRemoved();
            int n6 = elementArray2 != null ? elementArray2.length : 0;
            int n7 = n3 + elementArray.length - n6;
            for (int i = n3; i < n7; ++i) {
                this.setSharedSegment(i);
                int n8 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n);
                this.lastTokensOnLines.add(i, n8);
                n = n8;
            }
            this.updateLastTokensBelow(n7, n2, n);
        } else {
            this.updateLastTokensBelow(n3, n2, n);
        }
        super.fireInsertUpdate(documentEvent);
    }

    protected void fireRemoveUpdate(DocumentEvent documentEvent) {
        Element[] elementArray;
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        DocumentEvent.ElementChange elementChange = documentEvent.getChange(element);
        Element[] elementArray2 = elementArray = elementChange == null ? null : elementChange.getChildrenRemoved();
        if (elementArray != null && elementArray.length > 0) {
            int n2 = elementChange.getIndex();
            int n3 = n2 - 1;
            int n4 = n3 > -1 ? this.lastTokensOnLines.get(n3) : 0;
            Element[] elementArray3 = elementChange.getChildrenAdded();
            int n5 = elementArray3 == null ? 0 : elementArray3.length;
            int n6 = n2 + elementArray.length - n5;
            this.lastTokensOnLines.removeRange(n2, n6);
            this.updateLastTokensBelow(n2, n, n4);
        } else {
            int n7 = element.getElementIndex(documentEvent.getOffset());
            if (n7 >= this.lastTokensOnLines.getSize()) {
                return;
            }
            int n8 = n7 - 1;
            int n9 = n8 > -1 ? this.lastTokensOnLines.get(n8) : 0;
            this.updateLastTokensBelow(n7, n, n9);
        }
        super.fireRemoveUpdate(documentEvent);
    }

    public int getLastTokenTypeOnLine(int n) {
        return this.lastTokensOnLines.get(n);
    }

    public String[] getLineCommentStartAndEnd() {
        return this.tokenMaker.getLineCommentStartAndEnd();
    }

    public final Token getTokenListForLine(int n) {
        Element element = this.getDefaultRootElement();
        Element element2 = element.getElement(n);
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            this.getText(n2, n3 - n2, this.s);
        }
        catch (BadLocationException badLocationException) {
            badLocationException.printStackTrace();
            return null;
        }
        int n4 = n == 0 ? 0 : this.getLastTokenTypeOnLine(n - 1);
        return this.tokenMaker.getTokenList(this.s, n4, n2);
    }

    private final void setSharedSegment(int n) {
        Element element = this.getDefaultRootElement();
        Element element2 = element.getElement(n);
        if (element2 == null) {
            throw new InternalError("Invalid line number: " + n);
        }
        int n2 = element2.getStartOffset();
        int n3 = element2.getEndOffset() - 1;
        try {
            this.getText(n2, n3 - n2, this.s);
        }
        catch (BadLocationException badLocationException) {
            throw new InternalError("Text range not in document: " + n2 + "-" + n3);
        }
    }

    public void setSyntaxStyle(int n) {
        switch (n) {
            case 1: {
                this.tokenMaker = new AssemblerX86TokenMaker();
                break;
            }
            case 2: {
                this.tokenMaker = new CTokenMaker();
                break;
            }
            case 3: {
                this.tokenMaker = new CPlusPlusTokenMaker();
                break;
            }
            case 4: {
                this.tokenMaker = new CSharpTokenMaker();
                break;
            }
            case 5: {
                this.tokenMaker = new CSSTokenMaker();
                break;
            }
            case 6: {
                this.tokenMaker = new FortranTokenMaker();
                break;
            }
            case 7: {
                this.tokenMaker = new GroovyTokenMaker();
                break;
            }
            case 8: {
                this.tokenMaker = new HTMLTokenMaker();
                break;
            }
            case 9: {
                this.tokenMaker = new JavaTokenMaker();
                break;
            }
            case 10: {
                this.tokenMaker = new JavaScriptTokenMaker();
                break;
            }
            case 11: {
                this.tokenMaker = new JSPTokenMaker();
                break;
            }
            case 12: {
                this.tokenMaker = new LuaTokenMaker();
                break;
            }
            case 13: {
                this.tokenMaker = new PerlTokenMaker();
                break;
            }
            case 15: {
                this.tokenMaker = new PythonTokenMaker();
                break;
            }
            case 14: {
                this.tokenMaker = new PropertiesFileTokenMaker();
                break;
            }
            case 16: {
                this.tokenMaker = new SASTokenMaker();
                break;
            }
            case 17: {
                this.tokenMaker = new SQLTokenMaker();
                break;
            }
            case 18: {
                this.tokenMaker = new TclTokenMaker();
                break;
            }
            case 19: {
                this.tokenMaker = new UnixShellTokenMaker();
                break;
            }
            case 20: {
                this.tokenMaker = new WindowsBatchTokenMaker();
                break;
            }
            case 21: {
                this.tokenMaker = new XMLTokenMaker();
                break;
            }
            default: {
                this.tokenMaker = new PlainTextTokenMaker();
            }
        }
        this.updateSyntaxHighlightingInformation();
    }

    public void setSyntaxStyle(TokenMaker tokenMaker) {
        this.tokenMaker = tokenMaker;
        this.updateSyntaxHighlightingInformation();
    }

    public void setWhitespaceVisible(boolean bl, RSyntaxTextArea rSyntaxTextArea) {
        this.tokenMaker.setWhitespaceVisible(bl, rSyntaxTextArea);
    }

    private int updateLastTokensBelow(int n, int n2, int n3) {
        int n4 = n;
        int n5 = n2 - 1;
        while (n < n5) {
            this.setSharedSegment(n);
            int n6 = this.lastTokensOnLines.get(n);
            int n7 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n3);
            if (n6 == n7) {
                this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, n4, n, DocumentEvent.EventType.CHANGE));
                return n;
            }
            this.lastTokensOnLines.setUnsafe(n, n7);
            n3 = n7;
            ++n;
        }
        if (n > n4) {
            this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, n4, n, DocumentEvent.EventType.CHANGE));
        }
        return n;
    }

    protected void updateSyntaxHighlightingInformation() {
        Element element = this.getDefaultRootElement();
        int n = element.getElementCount();
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            this.setSharedSegment(i);
            n2 = this.tokenMaker.getLastTokenTypeOnLine(this.s, n2);
            this.lastTokensOnLines.set(i, n2);
        }
        this.fireChangedUpdate(new AbstractDocument.DefaultDocumentEvent(this, 0, n - 1, DocumentEvent.EventType.CHANGE));
    }
}

