/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect;

import ca.sqlpower.object.AbstractPoolingSPListener;
import ca.sqlpower.object.SPChildEvent;
import ca.sqlpower.object.SPListener;
import ca.sqlpower.sqlobject.SQLObject;
import org.apache.log4j.Logger;

public class InsertionPointWatcher<T extends SQLObject> {
    private static final Logger logger = Logger.getLogger(InsertionPointWatcher.class);
    private final T objectUnderObservation;
    private int insertionPoint;
    private final Class<? extends SQLObject> childType;
    private final SQLObjectEventHandler eventHandler = new SQLObjectEventHandler();

    public InsertionPointWatcher(T objectUnderObservation, int insertionPoint) {
        this(objectUnderObservation, insertionPoint, SQLObject.class);
    }

    public InsertionPointWatcher(T objectUnderObservation, int insertionPoint, Class<? extends SQLObject> childType) {
        this.objectUnderObservation = objectUnderObservation;
        this.insertionPoint = insertionPoint;
        this.childType = childType;
        objectUnderObservation.addSPListener((SPListener)this.eventHandler);
    }

    public int getInsertionPoint() {
        return this.insertionPoint;
    }

    public T getObjectUnderObservation() {
        return this.objectUnderObservation;
    }

    public void dispose() {
        this.objectUnderObservation.removeSPListener((SPListener)this.eventHandler);
    }

    private class SQLObjectEventHandler
    extends AbstractPoolingSPListener {
        private SQLObjectEventHandler() {
        }

        public void childAddedImpl(SPChildEvent e) {
            if (e.getChildType() == InsertionPointWatcher.this.childType && e.getIndex() <= InsertionPointWatcher.this.insertionPoint) {
                InsertionPointWatcher.this.insertionPoint++;
            }
        }

        public void childRemovedImpl(SPChildEvent e) {
            if (e.getChildType() == InsertionPointWatcher.this.childType && e.getIndex() < InsertionPointWatcher.this.insertionPoint) {
                InsertionPointWatcher.this.insertionPoint--;
            }
        }
    }
}

