/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui;

import ca.sqlpower.architect.layout.ArchitectLayout;
import ca.sqlpower.architect.swingui.PlayPen;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.Timer;

public class LayoutAnimator
implements ActionListener {
    private PlayPen pp;
    private Timer timer;
    private ArchitectLayout layout;
    private boolean animationEnabled = true;
    private int framesPerSecond = 15;

    public LayoutAnimator(PlayPen pp, ArchitectLayout layout) {
        this.pp = pp;
        this.layout = layout;
    }

    public void startAnimation() {
        this.pp.startCompoundEdit("Auto Layout");
        if (!this.animationEnabled) {
            this.layout.done();
        } else {
            this.timer = new Timer((int)(1.0 / (double)this.framesPerSecond * 1000.0), null);
            this.timer.addActionListener(this);
            this.pp.getContentPane().begin("Auto layout");
            this.timer.start();
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        try {
            if (this.layout.isDone()) {
                this.timer.stop();
                this.layout.done();
                this.pp.endCompoundEdit("Layout animation finished");
                this.pp.getContentPane().commit();
            } else {
                this.layout.nextFrame();
                this.pp.revalidate();
            }
        }
        catch (Throwable t) {
            this.pp.getContentPane().rollback("Error doing auto layout");
            throw new RuntimeException(t);
        }
    }

    public ArchitectLayout getLayout() {
        return this.layout;
    }

    public boolean isAnimationEnabled() {
        return this.animationEnabled;
    }

    public void setAnimationEnabled(boolean animationEnabled) {
        this.animationEnabled = animationEnabled;
    }

    public int getFramesPerSecond() {
        return this.framesPerSecond;
    }

    public void setFramesPerSecond(int framesPerSecond) {
        this.framesPerSecond = framesPerSecond;
    }
}

