/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.PlayPenComponent;
import ca.sqlpower.architect.swingui.PlayPenLabel;
import ca.sqlpower.architect.swingui.action.AbstractArchitectAction;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.object.SPLabel;
import ca.sqlpower.object.SPVariableHelper;
import ca.sqlpower.swingui.DataEntryPanel;
import ca.sqlpower.swingui.DataEntryPanelBuilder;
import ca.sqlpower.swingui.FontSelector;
import ca.sqlpower.swingui.LabelEditorPanel;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.util.Collections;
import java.util.List;
import javax.swing.JDialog;
import javax.swing.JOptionPane;

public class EditLabelAction
extends AbstractArchitectAction {
    public EditLabelAction(ArchitectFrame frame) {
        super(frame, "Label Properties...", "Label Properties");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        List<PlayPenComponent> selection = this.getPlaypen().getSelectedItems();
        if (selection.size() < 1) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditLabelAction.noLabelsSelected"));
        } else if (selection.size() > 1) {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditLabelAction.multipleItemsSelected"));
        } else if (selection.get(0) instanceof PlayPenLabel) {
            PlayPenLabel label = (PlayPenLabel)selection.get(0);
            this.showDialog(label);
        } else {
            JOptionPane.showMessageDialog(this.getPlaypen(), Messages.getString("EditLabelAction.pleaseSelectLabel"));
        }
    }

    private void showDialog(PlayPenLabel label) {
        PlayPenLabelEditorPanel panel = new PlayPenLabelEditorPanel(label.getLabel(), false, false);
        JDialog editDialog = DataEntryPanelBuilder.createDataEntryPanelDialog((DataEntryPanel)panel, (Component)this.frame, (String)Messages.getString("EditLabelAction.dialogTitle"), (String)DataEntryPanelBuilder.OK_BUTTON_LABEL);
        editDialog.pack();
        editDialog.setLocationRelativeTo(this.frame);
        editDialog.setVisible(true);
    }

    public class PlayPenLabelEditorPanel
    extends LabelEditorPanel {
        public PlayPenLabelEditorPanel(SPLabel label, boolean variables, boolean override) {
            super(label, variables, override);
        }

        public SPVariableHelper getVariablesHelper() {
            return null;
        }

        public FontSelector getFontSelector() {
            return null;
        }

        public List<Color> getBackgroundColours() {
            return Collections.singletonList(Color.WHITE);
        }
    }
}

