/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.action;

import ca.sqlpower.architect.etl.ExportCSV;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.action.Messages;
import ca.sqlpower.sqlobject.SQLObjectException;
import ca.sqlpower.sqlobject.SQLObjectRuntimeException;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import javax.swing.AbstractAction;
import javax.swing.JFileChooser;
import org.apache.log4j.Logger;

public class ExportCSVAction
extends AbstractAction {
    private static final Logger logger = Logger.getLogger(ExportCSVAction.class);
    private final ArchitectFrame frame;

    public ExportCSVAction(ArchitectFrame frame) {
        super(Messages.getString("ExportCSVAction.name"));
        this.frame = frame;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        OutputStreamWriter output = null;
        try {
            if (this.frame.getCurrentSession() == null) {
                return;
            }
            ExportCSV export = new ExportCSV(this.frame.getCurrentSession().getTargetDatabase().getTables());
            File file = null;
            JFileChooser fileDialog = new JFileChooser();
            fileDialog.setSelectedFile(new File("map.csv"));
            if (fileDialog.showSaveDialog(this.frame) != 0) {
                return;
            }
            file = fileDialog.getSelectedFile();
            output = new FileWriter(file);
            output.write(export.getCSVMapping());
            output.flush();
        }
        catch (IOException e1) {
            throw new RuntimeException(e1);
        }
        catch (SQLObjectException e1) {
            throw new SQLObjectRuntimeException(e1);
        }
        finally {
            if (output != null) {
                try {
                    output.close();
                }
                catch (IOException e1) {
                    logger.error((Object)"IO Error", (Throwable)e1);
                }
            }
        }
    }
}

