/*
 * Decompiled with CFR 0.152.
 */
package ca.sqlpower.architect.swingui.enterprise;

import ca.sqlpower.architect.enterprise.ArchitectClientSideSession;
import ca.sqlpower.architect.swingui.ArchitectFrame;
import ca.sqlpower.architect.swingui.ArchitectSwingSession;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContext;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionContextImpl;
import ca.sqlpower.architect.swingui.ArchitectSwingSessionImpl;
import ca.sqlpower.architect.swingui.enterprise.SecurityPanel;
import ca.sqlpower.enterprise.AbstractNetworkConflictResolver;
import ca.sqlpower.enterprise.client.ProjectLocation;
import ca.sqlpower.enterprise.client.SPServerInfo;
import ca.sqlpower.swingui.SPSUtils;
import ca.sqlpower.swingui.enterprise.client.ServerProjectsManagerPanel;
import ca.sqlpower.util.UserPrompterFactory;
import com.jgoodies.forms.builder.DefaultFormBuilder;
import com.jgoodies.forms.layout.FormLayout;
import java.awt.Component;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.io.IOException;
import java.net.URISyntaxException;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JProgressBar;
import org.json.JSONException;

public class ArchitectServerProjectsManagerPanel
extends ServerProjectsManagerPanel {
    private final ArchitectSwingSession session;
    private final ArchitectSwingSessionContext context;
    private final Action openAction = new AbstractAction("Open"){

        @Override
        public void actionPerformed(ActionEvent e) {
            List selectedProjects = ArchitectServerProjectsManagerPanel.this.getSelectedProjects();
            if (!selectedProjects.isEmpty()) {
                for (ProjectLocation location : selectedProjects) {
                    try {
                        ArchitectSwingSession newSession = ((ArchitectSwingSessionContextImpl)ArchitectServerProjectsManagerPanel.this.context).createServerSession(location, false);
                        ArchitectFrame frame = ArchitectServerProjectsManagerPanel.this.session.getArchitectFrame();
                        frame.addSession(newSession);
                        frame.setCurrentSession(newSession);
                        JLabel messageLabel = new JLabel("Opening");
                        JProgressBar progressBar = new JProgressBar();
                        progressBar.setIndeterminate(true);
                        final JDialog dialog = new JDialog((Frame)frame, "Opening");
                        DefaultFormBuilder builder = new DefaultFormBuilder(new FormLayout("pref:grow, 5dlu, pref"));
                        builder.setDefaultDialogBorder();
                        builder.append((Component)messageLabel, 3);
                        builder.nextLine();
                        builder.append((Component)progressBar, 3);
                        dialog.add(builder.getPanel());
                        dialog.pack();
                        dialog.setLocation(frame.getX() + (frame.getWidth() - dialog.getWidth()) / 2, frame.getY() + (frame.getHeight() - dialog.getHeight()) / 2);
                        dialog.setAlwaysOnTop(true);
                        dialog.setVisible(true);
                        ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).getUpdater().addListener(new AbstractNetworkConflictResolver.UpdateListener(){

                            public boolean updatePerformed(AbstractNetworkConflictResolver resolver) {
                                dialog.dispose();
                                return true;
                            }

                            public boolean updateException(AbstractNetworkConflictResolver resolver, Throwable t) {
                                return false;
                            }

                            public void preUpdatePerformed(AbstractNetworkConflictResolver resolver) {
                            }

                            public void workspaceDeleted() {
                                ArchitectServerProjectsManagerPanel.this.refreshInfoList();
                            }
                        });
                        ((ArchitectClientSideSession)((ArchitectSwingSessionImpl)newSession).getDelegateSession()).startUpdaterThread();
                    }
                    catch (Exception ex) {
                        throw new RuntimeException("Unable to open project", ex);
                    }
                }
                ArchitectServerProjectsManagerPanel.this.getCloseAction().actionPerformed(e);
            }
        }
    };
    private final Action openSecurityManagerPanelAction = new AbstractAction("Security"){

        @Override
        public void actionPerformed(ActionEvent e) {
            final JDialog d = SPSUtils.makeOwnedDialog((Component)ArchitectServerProjectsManagerPanel.this.getDialogOwner(), (String)"Security Manager");
            AbstractAction closeAction = new AbstractAction("Close"){

                @Override
                public void actionPerformed(ActionEvent e) {
                    d.dispose();
                }
            };
            SecurityPanel spm = new SecurityPanel(ArchitectServerProjectsManagerPanel.this.getSelectedServerInfo(), closeAction, d, ArchitectServerProjectsManagerPanel.this.session);
            d.setDefaultCloseOperation(2);
            d.setContentPane(spm.getPanel());
            SPSUtils.makeJDialogCancellable((Window)d, null);
            d.pack();
            d.setLocationRelativeTo(ArchitectServerProjectsManagerPanel.this.getDialogOwner());
            d.setVisible(true);
        }
    };

    public ArchitectServerProjectsManagerPanel(ArchitectSwingSession session, ArchitectSwingSessionContext context, Action closeAction) {
        super(context.getServerManager(), (Component)session.getArchitectFrame(), (UserPrompterFactory)session, closeAction, session.getProjectLoader().getFile(), ArchitectClientSideSession.getCookieStore());
        this.session = session;
        this.context = context;
    }

    public ArchitectServerProjectsManagerPanel(SPServerInfo serverInfo, ArchitectSwingSession session, ArchitectSwingSessionContext context, Action closeAction) {
        super(serverInfo, (Component)session.getArchitectFrame(), (UserPrompterFactory)session, closeAction, session.getProjectLoader().getFile(), ArchitectClientSideSession.getCookieStore());
        this.session = session;
        this.context = context;
    }

    protected List<ProjectLocation> getProjectLocations() throws IOException, URISyntaxException, JSONException {
        ((ArchitectSwingSessionContextImpl)this.session.getContext()).createSecuritySession(this.getSelectedServerInfo());
        return ArchitectClientSideSession.getWorkspaceNames(this.getSelectedServerInfo(), this.session);
    }

    protected Action getOpenAction() {
        return this.openAction;
    }

    protected Action getSecurityAction() {
        return this.openSecurityManagerPanelAction;
    }
}

