/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.query;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.olap4j.query.QueryEvent;
import org.olap4j.query.QueryNode;
import org.olap4j.query.QueryNodeListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class QueryNodeImpl
implements QueryNode {
    private final List<QueryNodeListener> listeners = new ArrayList<QueryNodeListener>();

    QueryNodeImpl() {
    }

    @Override
    public void addQueryNodeListener(QueryNodeListener l) {
        this.listeners.add(l);
    }

    @Override
    public void removeQueryNodeListener(QueryNodeListener l) {
        this.listeners.remove(l);
    }

    protected void notifyAdd(QueryNode child, int index) {
        assert (child != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.CHILDREN_ADDED, this, child, index);
        this.notifyAddInternal(event);
    }

    protected void notifyAdd(Map<Integer, QueryNode> children) {
        assert (children != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.CHILDREN_ADDED, this, children);
        this.notifyAddInternal(event);
    }

    private void notifyAddInternal(QueryEvent event) {
        for (int cpt = this.listeners.size() - 1; cpt >= 0; --cpt) {
            this.listeners.get(cpt).childrenAdded(event);
        }
    }

    protected void notifyRemove(QueryNode child, int index) {
        assert (child != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.CHILDREN_REMOVED, this, child, index);
        this.notifyRemoveInternal(event);
    }

    protected void notifyRemove(Map<Integer, QueryNode> children) {
        assert (children != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.CHILDREN_REMOVED, this, children);
        this.notifyRemoveInternal(event);
    }

    private void notifyRemoveInternal(QueryEvent event) {
        for (int cpt = this.listeners.size() - 1; cpt >= 0; --cpt) {
            this.listeners.get(cpt).childrenRemoved(event);
        }
    }

    protected void notifyChange(QueryNode child, int index) {
        assert (child != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.SELECTION_CHANGED, this, child, index);
        this.notifyChangeInternal(event);
    }

    protected void notifyChange(Map<Integer, QueryNode> children) {
        assert (children != null);
        QueryEvent event = new QueryEvent(QueryEvent.Type.SELECTION_CHANGED, this, children);
        this.notifyChangeInternal(event);
    }

    private void notifyChangeInternal(QueryEvent event) {
        for (int cpt = this.listeners.size() - 1; cpt >= 0; --cpt) {
            this.listeners.get(cpt).selectionChanged(event);
        }
    }

    void clearListeners() {
        this.listeners.clear();
    }

    abstract void tearDown();
}

