/*
 * Decompiled with CFR 0.152.
 */
package org.olap4j.type;

import org.olap4j.OlapException;
import org.olap4j.metadata.Dimension;
import org.olap4j.metadata.Hierarchy;
import org.olap4j.metadata.Level;
import org.olap4j.type.MemberType;
import org.olap4j.type.ScalarType;
import org.olap4j.type.Type;
import org.olap4j.type.TypeUtil;

public class TupleType
implements Type {
    final Type[] elementTypes;
    private final String digest;

    public TupleType(Type[] elementTypes) {
        assert (elementTypes != null);
        this.elementTypes = (Type[])elementTypes.clone();
        StringBuilder buf = new StringBuilder("TupleType<");
        for (int i = 0; i < elementTypes.length; ++i) {
            Type elementType = elementTypes[i];
            if (i > 0) {
                buf.append(", ");
            }
            buf.append(elementType.toString());
        }
        buf.append(">");
        this.digest = buf.toString();
    }

    public String toString() {
        return this.digest;
    }

    public boolean usesDimension(Dimension dimension, boolean maybe) {
        for (Type elementType : this.elementTypes) {
            if (!elementType.usesDimension(dimension, maybe)) continue;
            return true;
        }
        return false;
    }

    public Dimension getDimension() {
        return null;
    }

    public Hierarchy getHierarchy() {
        return null;
    }

    public Level getLevel() {
        return null;
    }

    private Type getValueType() throws OlapException {
        for (Type elementType : this.elementTypes) {
            MemberType memberType;
            if (!(elementType instanceof MemberType) || (memberType = (MemberType)elementType).getDimension().getDimensionType() != Dimension.Type.MEASURE) continue;
            return memberType.getValueType();
        }
        return new ScalarType();
    }

    boolean isUnionCompatibleWith(TupleType that) throws OlapException {
        if (this.elementTypes.length != that.elementTypes.length) {
            return false;
        }
        for (int i = 0; i < this.elementTypes.length; ++i) {
            if (TypeUtil.isUnionCompatible(this.elementTypes[i], that.elementTypes[i])) continue;
            return false;
        }
        return true;
    }
}

