/*
 * Decompiled with CFR 0.152.
 */
package com.android.dx.merge;

import com.android.dx.dex.TableOfContents;
import com.android.dx.io.Annotation;
import com.android.dx.io.ClassDef;
import com.android.dx.io.DexBuffer;
import com.android.dx.io.EncodedValue;
import com.android.dx.io.EncodedValueReader;
import com.android.dx.io.FieldId;
import com.android.dx.io.MethodId;
import com.android.dx.io.ProtoId;
import com.android.dx.merge.SortableType;
import com.android.dx.merge.TypeList;
import com.android.dx.util.ByteArrayAnnotatedOutput;
import com.android.dx.util.ByteInput;
import com.android.dx.util.ByteOutput;
import com.android.dx.util.Leb128Utils;
import com.android.dx.util.Unsigned;
import java.util.HashMap;

public final class IndexMap {
    private final DexBuffer target;
    public final int[] stringIds;
    public final short[] typeIds;
    public final short[] protoIds;
    public final short[] fieldIds;
    public final short[] methodIds;
    private final HashMap<Integer, Integer> typeListOffsets;
    private final HashMap<Integer, Integer> annotationOffsets;
    private final HashMap<Integer, Integer> annotationSetOffsets;
    private final HashMap<Integer, Integer> annotationDirectoryOffsets;

    public IndexMap(DexBuffer target, TableOfContents tableOfContents) {
        this.target = target;
        this.stringIds = new int[tableOfContents.stringIds.size];
        this.typeIds = new short[tableOfContents.typeIds.size];
        this.protoIds = new short[tableOfContents.protoIds.size];
        this.fieldIds = new short[tableOfContents.fieldIds.size];
        this.methodIds = new short[tableOfContents.methodIds.size];
        this.typeListOffsets = new HashMap();
        this.annotationOffsets = new HashMap();
        this.annotationSetOffsets = new HashMap();
        this.annotationDirectoryOffsets = new HashMap();
        this.typeListOffsets.put(0, 0);
        this.annotationSetOffsets.put(0, 0);
        this.annotationDirectoryOffsets.put(0, 0);
    }

    public void putTypeListOffset(int oldOffset, int newOffset) {
        if (oldOffset <= 0 || newOffset <= 0) {
            throw new IllegalArgumentException();
        }
        this.typeListOffsets.put(oldOffset, newOffset);
    }

    public void putAnnotationOffset(int oldOffset, int newOffset) {
        if (oldOffset <= 0 || newOffset <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationOffsets.put(oldOffset, newOffset);
    }

    public void putAnnotationSetOffset(int oldOffset, int newOffset) {
        if (oldOffset <= 0 || newOffset <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationSetOffsets.put(oldOffset, newOffset);
    }

    public void putAnnotationDirectoryOffset(int oldOffset, int newOffset) {
        if (oldOffset <= 0 || newOffset <= 0) {
            throw new IllegalArgumentException();
        }
        this.annotationDirectoryOffsets.put(oldOffset, newOffset);
    }

    public int adjustString(int stringIndex) {
        return stringIndex == -1 ? -1 : this.stringIds[stringIndex];
    }

    public int adjustType(int typeIndex) {
        return typeIndex == -1 ? -1 : this.typeIds[typeIndex] & 0xFFFF;
    }

    public TypeList adjustTypeList(TypeList typeList) {
        if (typeList == TypeList.EMPTY) {
            return typeList;
        }
        short[] types = (short[])typeList.getTypes().clone();
        for (int i = 0; i < types.length; ++i) {
            types[i] = (short)this.adjustType(types[i]);
        }
        return new TypeList(this.target, types);
    }

    public int adjustProto(int protoIndex) {
        return this.protoIds[protoIndex] & 0xFFFF;
    }

    public int adjustField(int fieldIndex) {
        return this.fieldIds[fieldIndex] & 0xFFFF;
    }

    public int adjustMethod(int methodIndex) {
        return this.methodIds[methodIndex] & 0xFFFF;
    }

    public int adjustTypeListOffset(int typeListOffset) {
        return this.typeListOffsets.get(typeListOffset);
    }

    public int adjustAnnotation(int annotationOffset) {
        return this.annotationOffsets.get(annotationOffset);
    }

    public int adjustAnnotationSet(int annotationSetOffset) {
        return this.annotationSetOffsets.get(annotationSetOffset);
    }

    public int adjustAnnotationDirectory(int annotationDirectoryOffset) {
        return this.annotationDirectoryOffsets.get(annotationDirectoryOffset);
    }

    public MethodId adjust(MethodId methodId) {
        return new MethodId(this.target, this.adjustType(methodId.getDeclaringClassIndex()), this.adjustProto(methodId.getProtoIndex()), this.adjustString(methodId.getNameIndex()));
    }

    public FieldId adjust(FieldId fieldId) {
        return new FieldId(this.target, this.adjustType(fieldId.getDeclaringClassIndex()), this.adjustType(fieldId.getTypeIndex()), this.adjustString(fieldId.getNameIndex()));
    }

    public ProtoId adjust(ProtoId protoId) {
        return new ProtoId(this.target, this.adjustString(protoId.getShortyIndex()), this.adjustType(protoId.getReturnTypeIndex()), this.adjustTypeListOffset(protoId.getParametersOffset()));
    }

    public ClassDef adjust(ClassDef classDef) {
        return new ClassDef(this.target, classDef.getOffset(), this.adjustType(classDef.getTypeIndex()), classDef.getAccessFlags(), this.adjustType(classDef.getSupertypeIndex()), this.adjustTypeListOffset(classDef.getInterfacesOffset()), classDef.getSourceFileIndex(), classDef.getAnnotationsOffset(), classDef.getClassDataOffset(), classDef.getStaticValuesOffset());
    }

    public SortableType adjust(SortableType sortableType) {
        return new SortableType(sortableType.getBuffer(), this.adjust(sortableType.getClassDef()));
    }

    public EncodedValue adjustEncodedValue(EncodedValue encodedValue) {
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(encodedValue, out).readValue();
        return new EncodedValue(out.toByteArray());
    }

    public EncodedValue adjustEncodedArray(EncodedValue encodedArray) {
        ByteArrayAnnotatedOutput out = new ByteArrayAnnotatedOutput(32);
        new EncodedValueTransformer(encodedArray, out).readArray();
        return new EncodedValue(out.toByteArray());
    }

    public Annotation adjust(Annotation annotation) {
        int[] names = (int[])annotation.getNames().clone();
        EncodedValue[] values = (EncodedValue[])annotation.getValues().clone();
        for (int i = 0; i < names.length; ++i) {
            names[i] = this.adjustString(names[i]);
            values[i] = this.adjustEncodedValue(values[i]);
        }
        return new Annotation(this.target, annotation.getVisibility(), this.adjustType(annotation.getTypeIndex()), names, values);
    }

    private final class EncodedValueTransformer
    extends EncodedValueReader {
        private final ByteOutput out;

        public EncodedValueTransformer(EncodedValue encodedValue, ByteOutput out) {
            super(encodedValue);
            this.out = out;
        }

        protected void visitArray(int size) {
            Leb128Utils.writeUnsignedLeb128(this.out, size);
        }

        protected void visitAnnotation(int typeIndex, int size) {
            Leb128Utils.writeUnsignedLeb128(this.out, IndexMap.this.adjustType(typeIndex));
            Leb128Utils.writeUnsignedLeb128(this.out, size);
        }

        protected void visitAnnotationName(int index) {
            Leb128Utils.writeUnsignedLeb128(this.out, IndexMap.this.adjustString(index));
        }

        protected void visitPrimitive(int argAndType, int type, int arg, int size) {
            this.out.writeByte(argAndType);
            this.copyBytes(this.in, this.out, size);
        }

        protected void visitString(int type, int index) {
            this.writeTypeAndSizeAndIndex(type, IndexMap.this.adjustString(index));
        }

        protected void visitType(int type, int index) {
            this.writeTypeAndSizeAndIndex(type, IndexMap.this.adjustType(index));
        }

        protected void visitField(int type, int index) {
            this.writeTypeAndSizeAndIndex(type, IndexMap.this.adjustField(index));
        }

        protected void visitMethod(int type, int index) {
            this.writeTypeAndSizeAndIndex(type, IndexMap.this.adjustMethod(index));
        }

        protected void visitArrayValue(int argAndType) {
            this.out.writeByte(argAndType);
        }

        protected void visitAnnotationValue(int argAndType) {
            this.out.writeByte(argAndType);
        }

        protected void visitEncodedBoolean(int argAndType) {
            this.out.writeByte(argAndType);
        }

        protected void visitEncodedNull(int argAndType) {
            this.out.writeByte(argAndType);
        }

        private void writeTypeAndSizeAndIndex(int type, int index) {
            int byteCount = Unsigned.compare(index, 255) <= 0 ? 1 : (Unsigned.compare(index, 65535) <= 0 ? 2 : (Unsigned.compare(index, 0xFFFFFF) <= 0 ? 3 : 4));
            int argAndType = byteCount - 1 << 5 | type;
            this.out.writeByte(argAndType);
            for (int i = 0; i < byteCount; ++i) {
                this.out.writeByte(index & 0xFF);
                index >>>= 8;
            }
        }

        private void copyBytes(ByteInput in, ByteOutput out, int size) {
            for (int i = 0; i < size; ++i) {
                out.writeByte(in.readByte());
            }
        }
    }
}

