/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.model;

import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;
import net.sf.freecol.common.i18n.Messages;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.io.FreeColXMLWriter;
import net.sf.freecol.common.model.Ability;
import net.sf.freecol.common.model.AbstractGoods;
import net.sf.freecol.common.model.Colony;
import net.sf.freecol.common.model.CombatModel;
import net.sf.freecol.common.model.Constants;
import net.sf.freecol.common.model.Consumer;
import net.sf.freecol.common.model.Direction;
import net.sf.freecol.common.model.Europe;
import net.sf.freecol.common.model.Feature;
import net.sf.freecol.common.model.FreeColGameObject;
import net.sf.freecol.common.model.FreeColObject;
import net.sf.freecol.common.model.FreeColSpecObjectType;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Goods;
import net.sf.freecol.common.model.GoodsContainer;
import net.sf.freecol.common.model.GoodsLocation;
import net.sf.freecol.common.model.GoodsType;
import net.sf.freecol.common.model.HighSeas;
import net.sf.freecol.common.model.IndianSettlement;
import net.sf.freecol.common.model.Locatable;
import net.sf.freecol.common.model.Location;
import net.sf.freecol.common.model.Map;
import net.sf.freecol.common.model.Modifier;
import net.sf.freecol.common.model.Movable;
import net.sf.freecol.common.model.Nameable;
import net.sf.freecol.common.model.Ownable;
import net.sf.freecol.common.model.PathNode;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.ProductionInfo;
import net.sf.freecol.common.model.Role;
import net.sf.freecol.common.model.Settlement;
import net.sf.freecol.common.model.Specification;
import net.sf.freecol.common.model.StringTemplate;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.TileImprovement;
import net.sf.freecol.common.model.TileItemContainer;
import net.sf.freecol.common.model.TradeLocation;
import net.sf.freecol.common.model.TradeRoute;
import net.sf.freecol.common.model.TradeRouteStop;
import net.sf.freecol.common.model.Turn;
import net.sf.freecol.common.model.UnitChangeType;
import net.sf.freecol.common.model.UnitLocation;
import net.sf.freecol.common.model.UnitType;
import net.sf.freecol.common.model.UnitTypeChange;
import net.sf.freecol.common.model.WorkLocation;
import net.sf.freecol.common.model.pathfinding.CostDecider;
import net.sf.freecol.common.model.pathfinding.CostDeciders;
import net.sf.freecol.common.model.pathfinding.GoalDecider;
import net.sf.freecol.common.model.pathfinding.GoalDeciders;
import net.sf.freecol.common.util.CollectionUtils;
import net.sf.freecol.common.util.LogBuilder;
import net.sf.freecol.common.util.StringUtils;

public class Unit
extends GoodsLocation
implements Consumer,
Locatable,
Movable,
Nameable,
Ownable {
    private static final Logger logger = Logger.getLogger(Unit.class.getName());
    private static final int UNIT_CLASS_INDEX = 40;
    public static final String TAG = "unit";
    public static final int MANY_TURNS = 10000;
    public static final int DEFAULT_UNIT_VALUE = 500;
    public static final String CARGO_CHANGE = "CARGO_CHANGE";
    public static final String MOVE_CHANGE = "MOVE_CHANGE";
    public static final String ROLE_CHANGE = "ROLE_CHANGE";
    public static final Comparator<Unit> locComparator = Comparator.comparingInt(u -> Location.rankOf(u));
    public static final Comparator<Unit> typeRoleComparator = Comparator.comparing(Unit::getType).thenComparingInt(u -> u.getRole().getRoleIndex()).thenComparing(FreeColObject.fcoComparator);
    public static final Comparator<Unit> increasingSkillComparator = Comparator.comparingInt(Unit::getSkillLevel);
    public static final Comparator<Unit> decreasingSkillComparator = increasingSkillComparator.reversed();
    private static final Comparator<Settlement> settlementStartComparator = CollectionUtils.cachingIntComparator(s -> s == null || !s.getTile().isHighSeasConnected() ? Integer.MAX_VALUE : s.getTile().getHighSeasCount());
    public static final Predicate<Unit> sentryPred = u -> !u.isNaval() && u.getState() == UnitState.SENTRY;
    protected String name = null;
    protected Player owner;
    protected UnitType type;
    protected UnitState state = UnitState.ACTIVE;
    protected Role role;
    protected int roleCount;
    protected Location location;
    protected Location entryLocation;
    protected int movesLeft;
    protected GoodsType workType;
    protected GoodsType experienceType;
    protected int experience = 0;
    protected int workLeft;
    protected TileImprovement workImprovement;
    protected Unit student;
    protected Unit teacher;
    protected int turnsOfTraining = 0;
    protected String nationality = null;
    protected String ethnicity = null;
    protected IndianSettlement indianSettlement = null;
    protected int hitPoints;
    protected Location destination = null;
    protected TradeRoute tradeRoute = null;
    protected int currentStop = -1;
    protected int treasureAmount;
    protected int attrition = 0;
    protected int visibleGoodsCount;
    private static final String ATTRITION_TAG = "attrition";
    private static final String COUNT_TAG = "count";
    private static final String CURRENT_STOP_TAG = "currentStop";
    private static final String DESTINATION_TAG = "destination";
    private static final String ENTRY_LOCATION_TAG = "entryLocation";
    private static final String ETHNICITY_TAG = "ethnicity";
    private static final String EXPERIENCE_TAG = "experience";
    private static final String EXPERIENCE_TYPE_TAG = "experienceType";
    private static final String HIT_POINTS_TAG = "hitPoints";
    private static final String INDIAN_SETTLEMENT_TAG = "indianSettlement";
    private static final String LOCATION_TAG = "location";
    private static final String MOVES_LEFT_TAG = "movesLeft";
    private static final String NAME_TAG = "name";
    private static final String NATIONALITY_TAG = "nationality";
    private static final String OWNER_TAG = "owner";
    private static final String ROLE_TAG = "role";
    private static final String ROLE_COUNT_TAG = "roleCount";
    private static final String STATE_TAG = "state";
    private static final String STUDENT_TAG = "student";
    private static final String TRADE_ROUTE_TAG = "tradeRoute";
    private static final String TEACHER_TAG = "teacher";
    private static final String TREASURE_AMOUNT_TAG = "treasureAmount";
    private static final String TURNS_OF_TRAINING_TAG = "turnsOfTraining";
    private static final String UNIT_TYPE_TAG = "unitType";
    private static final String VISIBLE_GOODS_COUNT_TAG = "visibleGoodsCount";
    private static final String WORK_LEFT_TAG = "workLeft";
    private static final String WORK_TYPE_TAG = "workType";
    private static final String OLD_EQUIPMENT_TAG = "equipment";
    private static final String OLD_TILE_IMPROVEMENT_TAG = "tileimprovement";

    protected Unit(Game game) {
        super(game);
        this.initialize();
    }

    public Unit(Game game, String id) {
        super(game, id);
        this.initialize();
    }

    private final void initialize() {
        Player owner = this.getOwner();
        if (owner != null && this.isPerson()) {
            this.setNationality(owner.getNationId());
            this.setEthnicity(owner.getNationId());
        }
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String newName) {
        this.name = newName;
    }

    public StringTemplate getApparentOwnerName() {
        Player own = this.isOwnerHidden() ? this.getGame().getUnknownEnemy() : this.owner;
        return own.getNationLabel();
    }

    public StringTemplate getLabel() {
        return this.getLabel(UnitLabelType.PLAIN);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public StringTemplate getLabel(UnitLabelType ult) {
        UnitType type = this.getType();
        Role role = this.getRole();
        Player owner = this.getOwner();
        if (type == null || role == null || owner == null) {
            return null;
        }
        switch (ult) {
            case PLAIN: {
                return Messages.getUnitLabel(this.getName(), type.getId(), 1, null, role.getId(), null);
            }
            case NATIONAL: {
                if (role.getMaximumCount() <= 1) {
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), null);
                }
            }
            case FULL: {
                StringTemplate extra = null;
                if (role.isDefaultRole()) {
                    if (this.canCarryTreasure()) {
                        extra = (StringTemplate)StringTemplate.template("goldAmount").addAmount("%amount%", this.getTreasureAmount());
                        return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                    }
                    boolean noEquipment = false;
                    List<Role> expertRoles = type.getExpertRoles();
                    for (Role someRole : expertRoles) {
                        String key = someRole.getId() + ".noequipment";
                        if (!Messages.containsKey(key)) continue;
                        extra = StringTemplate.key(key);
                        return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                    }
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                }
                String equipmentKey = role.getId() + ".equipment";
                if (Messages.containsKey(equipmentKey)) {
                    extra = AbstractGoods.getAbstractLabel(equipmentKey, 1);
                    return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
                } else {
                    List<AbstractGoods> requiredGoods = role.getRequiredGoodsList(this.getRoleCount());
                    boolean first = true;
                    extra = StringTemplate.label("");
                    for (AbstractGoods ag : requiredGoods) {
                        if (first) {
                            first = false;
                        } else {
                            extra.addName(" ");
                        }
                        extra.addStringTemplate(ag.getLabel());
                    }
                }
                return Messages.getUnitLabel(this.getName(), type.getId(), 1, owner.getNationId(), role.getId(), extra);
            }
        }
        return null;
    }

    public String getDescription() {
        return Messages.message(this.getLabel());
    }

    public String getDescription(UnitLabelType ult) {
        return Messages.message(this.getLabel(ult));
    }

    public StringTemplate getCombatLabel(Tile tile) {
        CombatModel.CombatOdds combatOdds = this.getGame().getCombatModel().calculateCombatOdds(this, tile.getDefendingUnit(this));
        boolean unknown = combatOdds.win == -1.0 || tile.hasSettlement();
        return StringTemplate.template("model.unit.attackTileOdds").addName("%chance%", unknown ? "??" : String.valueOf((int)(combatOdds.win * 100.0)));
    }

    public StringTemplate getDestinationLabel() {
        String type = this.isPerson() ? "person" : (this.isNaval() ? "ship" : "other");
        return Unit.getUnitDestinationLabel(type, this.getDestination(), this.getOwner());
    }

    public static StringTemplate getUnitDestinationLabel(String tag, Location destination, Player player) {
        return ((StringTemplate)StringTemplate.template("model.unit.goingTo").addTagged("%type%", tag)).addStringTemplate("%location%", destination.getLocationLabelFor(player));
    }

    public StringTemplate getRepairLabel() {
        return StringTemplate.template("model.unit.underRepair").addAmount("%turns%", this.getTurnsForRepair());
    }

    public final UnitType getType() {
        return this.type;
    }

    public void setType(UnitType type) {
        this.type = type;
    }

    public boolean changeType(UnitType unitType) {
        if (!unitType.isAvailableTo(this.owner)) {
            return false;
        }
        double health = (double)this.getHitPoints() / (double)this.getMaximumHitPoints();
        this.setType(unitType);
        if (this.getMovesLeft() > this.getInitialMovesLeft()) {
            this.setMovesLeft(this.getInitialMovesLeft());
        }
        this.hitPoints = (int)((double)unitType.getHitPoints() * health);
        if (this.getTeacher() != null) {
            if (!this.canBeStudent(this.getTeacher())) {
                this.getTeacher().setStudent(null);
                this.setTeacher(null);
            }
        } else if (this.getStudent() != null && !this.getStudent().canBeStudent(this)) {
            this.getStudent().setTeacher(null);
            this.setStudent(null);
        }
        return true;
    }

    public int getScoreValue() {
        return this.type == null ? 0 : this.type.getScoreValue();
    }

    public boolean isNaval() {
        return this.type == null ? false : this.type.isNaval();
    }

    public boolean isOwnerHidden() {
        return this.type == null ? false : this.type.hasAbility("model.ability.piracy");
    }

    public boolean isUndead() {
        return this.hasAbility("model.ability.undead");
    }

    public boolean canCarryTreasure() {
        return this.hasAbility("model.ability.carryTreasure");
    }

    public boolean canCaptureGoods() {
        return this.hasAbility("model.ability.captureGoods");
    }

    public boolean isTradingUnit() {
        return this.canCarryGoods() && this.owner.isEuropean();
    }

    public boolean isColonist() {
        return this.type.hasAbility("model.ability.foundColony") && this.owner.hasAbility("model.ability.foundsColonies");
    }

    public boolean isCarrier() {
        return this.type.canCarryGoods() || this.type.canCarryUnits();
    }

    public boolean isPerson() {
        return this.type == null ? false : this.type.hasAbility("model.ability.person");
    }

    public UnitState getState() {
        return this.state;
    }

    public boolean checkSetState(UnitState s) {
        if (this.getState() == s) {
            return false;
        }
        switch (s) {
            case ACTIVE: {
                return true;
            }
            case FORTIFIED: {
                return this.getState() == UnitState.FORTIFYING;
            }
            case FORTIFYING: {
                return this.getMovesLeft() > 0;
            }
            case IMPROVING: {
                return this.getMovesLeft() > 0 && this.isOnTile() && this.getOwner().canAcquireForImprovement(this.getLocation().getTile());
            }
            case IN_COLONY: {
                return !this.isNaval();
            }
            case SENTRY: {
                return true;
            }
            case SKIPPED: {
                return this.getState() == UnitState.ACTIVE;
            }
        }
        logger.warning("Invalid unit state: " + s);
        return false;
    }

    public void setState(UnitState s) {
        if (this.state == s) {
            return;
        }
        if (!this.checkSetState(s)) {
            throw new IllegalStateException("Illegal UnitState transition: " + this.state + " -> " + s);
        }
        this.setStateUnchecked(s);
    }

    protected void setStateUnchecked(UnitState s) {
        switch (this.state) {
            case IMPROVING: {
                Tile tile;
                if (this.workImprovement == null || this.getWorkLeft() <= 0) break;
                if (!this.workImprovement.isComplete() && (tile = this.workImprovement.getTile()) != null && tile.getTileItemContainer() != null && CollectionUtils.none(tile.getUnits(), u -> u != this && u.getState() == UnitState.IMPROVING && u.getWorkImprovement() == this.workImprovement)) {
                    this.workImprovement.getTile().getTileItemContainer().removeTileItem(this.workImprovement);
                }
                this.setWorkImprovement(null);
                break;
            }
        }
        switch (s) {
            case ACTIVE: 
            case FORTIFYING: 
            case SENTRY: {
                this.setWorkLeft(-1);
                break;
            }
            case FORTIFIED: {
                this.setWorkLeft(-1);
                this.movesLeft = 0;
                break;
            }
            case IMPROVING: {
                if (this.workImprovement == null) {
                    this.setWorkLeft(-1);
                } else {
                    this.setWorkLeft(this.workImprovement.getTurnsToComplete() + (this.getMovesLeft() > 0 ? 0 : 1));
                }
                this.movesLeft = 0;
                break;
            }
            case SKIPPED: {
                break;
            }
            default: {
                this.setWorkLeft(-1);
            }
        }
        this.state = s;
    }

    public void setStateToAllChildren(UnitState state) {
        if (this.canCarryUnits()) {
            for (Unit u : this.getUnitList()) {
                u.setState(state);
            }
        }
    }

    public void changeOwner(Player owner) {
        Player oldOwner = this.owner;
        if (oldOwner == owner) {
            return;
        }
        if (oldOwner == null) {
            logger.warning("Unit " + this.getId() + " had no owner, when changing owner to " + owner.getId());
        }
        this.getGame().notifyOwnerChanged(this, oldOwner, owner);
        this.setOwner(owner);
        for (Unit u : this.getUnitList()) {
            u.changeOwner(owner);
        }
        if (this.getTeacher() != null && !this.canBeStudent(this.getTeacher())) {
            this.getTeacher().setStudent(null);
            this.setTeacher(null);
        }
        if (this.getTradeRoute() != null) {
            this.setTradeRoute(null);
        }
        if (this.getDestination() != null) {
            this.setDestination(null);
        }
        this.changeHomeIndianSettlement(null);
        if (oldOwner != null) {
            oldOwner.removeUnit(this);
        }
        if (owner != null) {
            owner.addUnit(this);
        }
    }

    public Role getRole() {
        return this.role;
    }

    public void setRole(Role role) {
        this.role = role;
    }

    public int getRoleCount() {
        return this.roleCount;
    }

    public void setRoleCount(int roleCount) {
        this.roleCount = roleCount;
    }

    public boolean hasDefaultRole() {
        return this.role.isDefaultRole();
    }

    public String getRoleSuffix() {
        return Role.getRoleIdSuffix(this.role.getId());
    }

    public void changeRole(Role role, int roleCount) {
        if (!role.isCompatibleWith(this.getRole())) {
            this.setExperience(0);
        }
        this.setRole(role);
        this.setRoleCount(role.isDefaultRole() ? 0 : roleCount);
    }

    public boolean changeRoleCount(int delta) {
        this.roleCount = Math.max(0, this.roleCount + delta);
        if (this.roleCount != 0) {
            return false;
        }
        this.role = this.getSpecification().getDefaultRole();
        return true;
    }

    public boolean roleIsAvailable(Role role) {
        return role.isAvailableTo(this);
    }

    public List<Role> getAvailableRolesList(List<Role> roles) {
        if (roles == null) {
            roles = this.getSpecification().getRolesList();
        }
        return CollectionUtils.transform(roles, r -> this.roleIsAvailable((Role)r));
    }

    public Stream<Role> getAvailableRoles(List<Role> roles) {
        return this.getAvailableRolesList(roles).stream();
    }

    public Role getMilitaryRole() {
        Role bestMilitaryRole = this.getSpecification().getMilitaryRoles().filter(r -> this.roleIsAvailable((Role)r) && !r.hasAbility("model.ability.speakWithChief")).sorted((a, b) -> Double.compare(b.getOffence(), a.getOffence())).findFirst().orElse(null);
        return bestMilitaryRole;
    }

    public List<Role> getSortedMilitaryRoles() {
        return this.getSpecification().getMilitaryRoles().filter(r -> this.roleIsAvailable((Role)r) && !r.hasAbility("model.ability.speakWithChief")).sorted((a, b) -> Double.compare(b.getOffence(), a.getOffence())).collect(Collectors.toList());
    }

    public List<AbstractGoods> getGoodsDifference(Role role, int roleCount) {
        return Role.getGoodsDifference(this.getRole(), this.getRoleCount(), role, roleCount);
    }

    public void setLocationNoUpdate(Location newLocation) {
        this.location = newLocation;
    }

    public boolean isOnCarrier() {
        return this.getLocation() instanceof Unit;
    }

    public boolean isOnTile() {
        return this.getLocation() instanceof Tile;
    }

    public Unit getCarrier() {
        return this.isOnCarrier() ? (Unit)this.getLocation() : null;
    }

    public boolean isAtSea() {
        return this.isOnCarrier() ? this.getCarrier().isAtSea() : this.getLocation() instanceof HighSeas;
    }

    public boolean isInMission() {
        return this.hasAbility("model.ability.establishMission") && this.getLocation() instanceof IndianSettlement;
    }

    public boolean isInColony() {
        return this.getLocation() instanceof WorkLocation;
    }

    public boolean hasTile() {
        return this.getTile() != null;
    }

    public WorkLocation getWorkLocation() {
        return this.isInColony() ? (WorkLocation)this.getLocation() : null;
    }

    public Tile getWorkTile() {
        return this.getLocation() instanceof WorkLocation ? ((WorkLocation)this.getLocation()).getWorkTile() : null;
    }

    public Location getEntryLocation() {
        return this.entryLocation;
    }

    public void setEntryLocation(Location entryLocation) {
        Tile tile;
        this.entryLocation = entryLocation;
        if (this.entryLocation != null && (tile = this.entryLocation.getTile()) != null) {
            this.owner.setEntryTile(tile);
        }
    }

    public Tile getFullEntryLocation() {
        return this.entryLocation != null ? this.entryLocation.getTile() : this.owner.getEntryTile();
    }

    @Override
    public int getMovesLeft() {
        return this.movesLeft;
    }

    public Unit getCarriedUnitById(String id) {
        if (id == null) {
            return null;
        }
        for (Unit u : this.getUnitList()) {
            if (!id.equals(u.getId())) continue;
            return u;
        }
        return null;
    }

    public void setMovesLeft(int moves) {
        this.movesLeft = moves < 0 ? 0 : moves;
    }

    public GoodsType getWorkType() {
        return this.workType;
    }

    public void setWorkType(GoodsType type) {
        this.workType = type;
    }

    public void changeWorkType(GoodsType type) {
        this.setWorkType(type);
        WorkLocation wl = this.getWorkLocation();
        if (wl != null) {
            wl.updateProductionType();
        }
    }

    public GoodsType getExperienceType() {
        return this.experienceType;
    }

    public void changeExperienceType(GoodsType type) {
        if (this.experienceType != type) {
            this.experience = 0;
            this.experienceType = type;
        }
    }

    public int getExperience() {
        return this.experience;
    }

    public void setExperience(int experience) {
        this.experience = Math.min(experience, this.getType().getMaximumExperience());
    }

    public void modifyExperience(int value) {
        this.experience += value;
    }

    public int getWorkLeft() {
        return this.workLeft;
    }

    public void setWorkLeft(int workLeft) {
        this.workLeft = workLeft;
    }

    public int getWorkTurnsLeft() {
        return this.state == UnitState.IMPROVING && this.type.hasAbility("model.ability.expertPioneer") ? (this.getWorkLeft() + 1) / 2 : this.getWorkLeft();
    }

    public TileImprovement getWorkImprovement() {
        return this.workImprovement;
    }

    public void setWorkImprovement(TileImprovement imp) {
        this.workImprovement = imp;
    }

    public final Unit getStudent() {
        return this.student;
    }

    public final void setStudent(Unit newStudent) {
        Unit oldStudent = this.student;
        if (oldStudent == newStudent) {
            return;
        }
        if (newStudent == null) {
            this.student = null;
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
        } else if (newStudent.getColony() != null && newStudent.getColony() == this.getColony() && newStudent.canBeStudent(this)) {
            if (oldStudent != null && oldStudent.getTeacher() == this) {
                oldStudent.setTeacher(null);
            }
            this.student = newStudent;
            newStudent.setTeacher(this);
        } else {
            throw new IllegalStateException("Unit can not be student: " + newStudent);
        }
    }

    public final Unit getTeacher() {
        return this.teacher;
    }

    public final void setTeacher(Unit newTeacher) {
        Unit oldTeacher = this.teacher;
        if (newTeacher == oldTeacher) {
            return;
        }
        if (newTeacher == null) {
            this.teacher = null;
            if (oldTeacher != null && oldTeacher.getStudent() == this) {
                oldTeacher.setStudent(null);
            }
        } else {
            UnitType skillTaught = newTeacher.getType().getSkillTaught();
            if (newTeacher.getColony() != null && newTeacher.getColony() == this.getColony() && this.getColony().canTrain(skillTaught)) {
                if (oldTeacher != null && oldTeacher.getStudent() == this) {
                    oldTeacher.setStudent(null);
                }
                this.teacher = newTeacher;
                this.teacher.setStudent(this);
            } else {
                throw new IllegalStateException("Unit can not be teacher: " + newTeacher);
            }
        }
    }

    public int getTurnsOfTraining() {
        return this.turnsOfTraining;
    }

    public void setTurnsOfTraining(int turnsOfTraining) {
        this.turnsOfTraining = turnsOfTraining;
    }

    public int getNeededTurnsOfTraining() {
        int result = 0;
        if (this.student != null) {
            result = this.getSpecification().getNeededTurnsOfTraining(this.getType(), this.student.getType());
            if (this.getColony() != null) {
                result -= this.getColony().getProductionBonus();
            }
        }
        return result;
    }

    public UnitTypeChange getUnitChange(String change) {
        return this.getUnitChange(change, null);
    }

    public UnitTypeChange getUnitChange(String change, UnitType toType) {
        UnitChangeType uct = this.getSpecification().getUnitChangeType(change);
        if (uct != null && uct.getOwnerChange()) {
            throw new RuntimeException("2-arg getUnitChange of " + this + " change=" + change + " which changes owner");
        }
        return this.getUnitChange(change, toType, this.getOwner());
    }

    public UnitTypeChange getUnitChange(String change, UnitType toType, Player player) {
        if (player == null) {
            throw new RuntimeException("getUnitChange null player: " + change);
        }
        UnitChangeType uct = this.getSpecification().getUnitChangeType(change);
        if (uct != null && uct.getOwnerChange() != (player != this.getOwner())) {
            throw new RuntimeException("getUnitChange of " + this + " change=" + change + " getOwnerChange=" + uct.getOwnerChange() + " != player-change=" + (player != this.getOwner()) + " player=" + player.getSuffix() + " owner=" + this.getOwner().getSuffix());
        }
        UnitTypeChange uc = uct == null || !uct.appliesTo(this) ? null : uct.getUnitChange(this.getType(), toType);
        return uc == null || !uc.isAvailableTo(player) || !uc.appliesTo(this) ? null : uc;
    }

    public UnitType getTeachingType(UnitType teacherType) {
        UnitType ret = this.getSpecification().getUnitChangeType("model.unitChange.education").appliesTo(this) ? this.getType().getTeachingType(teacherType) : null;
        return ret == null || !ret.isAvailableTo(this.getOwner()) ? null : ret;
    }

    public UnitType getTeachingType(Unit teacher) {
        return this.getTeachingType(teacher.getType());
    }

    public boolean canBeStudent(Unit teacher) {
        return teacher != null && teacher != this && this.getTeachingType(teacher) != null;
    }

    public final String getNationality() {
        return this.nationality;
    }

    public final void setNationality(String newNationality) {
        this.nationality = newNationality;
    }

    public final String getEthnicity() {
        return this.ethnicity;
    }

    public final void setEthnicity(String newEthnicity) {
        this.ethnicity = newEthnicity;
    }

    public boolean hasNativeEthnicity() {
        try {
            return this.getGame().getSpecification().getNation(this.ethnicity).getType().isIndian();
        }
        catch (Exception e) {
            return false;
        }
    }

    public IndianSettlement getHomeIndianSettlement() {
        return this.indianSettlement;
    }

    public void setHomeIndianSettlement(IndianSettlement indianSettlement) {
        this.indianSettlement = indianSettlement;
    }

    public IndianSettlement changeHomeIndianSettlement(IndianSettlement indianSettlement) {
        if (this.indianSettlement != null) {
            this.indianSettlement.removeOwnedUnit(this);
        }
        IndianSettlement ret = this.indianSettlement;
        this.indianSettlement = indianSettlement;
        if (indianSettlement != null) {
            indianSettlement.addOwnedUnit(this);
        }
        return ret;
    }

    public int getHitPoints() {
        return this.hitPoints;
    }

    public int getMaximumHitPoints() {
        return this.type.getHitPoints();
    }

    public void setHitPoints(int hitPoints) {
        this.hitPoints = hitPoints;
    }

    public boolean isDamagedAndUnderForcedRepair() {
        return this.isDamaged() && !this.getSpecification().hasAbility("model.ability.hitpointsCombatModel");
    }

    public boolean isDamaged() {
        return this.hitPoints < this.getMaximumHitPoints();
    }

    public int getTurnsForRepair() {
        return this.getMaximumHitPoints() - this.getHitPoints();
    }

    public Location getDestination() {
        return this.destination;
    }

    public void setDestination(Location newDestination) {
        this.destination = newDestination;
    }

    public final TradeRoute getTradeRoute() {
        return this.tradeRoute;
    }

    public final void setTradeRoute(TradeRoute newTradeRoute) {
        this.tradeRoute = newTradeRoute;
    }

    public TradeRouteStop getStop() {
        return this.validateCurrentStop() < 0 ? null : this.getTradeRoute().getStop(this.currentStop);
    }

    public List<TradeRouteStop> getCurrentStops() {
        if (this.validateCurrentStop() < 0) {
            return null;
        }
        List<TradeRouteStop> stops = this.getTradeRoute().getStopList();
        CollectionUtils.rotate(stops, this.currentStop);
        return stops;
    }

    public int getCurrentStop() {
        return this.currentStop;
    }

    public void setCurrentStop(int currentStop) {
        this.currentStop = currentStop;
    }

    private int validateCurrentStop() {
        if (this.tradeRoute == null) {
            this.currentStop = -1;
        } else {
            int stopCount = this.tradeRoute.getStopCount();
            if (stopCount <= 0) {
                this.currentStop = -1;
            } else if (this.currentStop < 0 || this.currentStop >= stopCount) {
                this.currentStop = 0;
            }
        }
        return this.currentStop;
    }

    public boolean atStop(TradeRouteStop stop) {
        return Map.isSameLocation(this.getLocation(), stop.getLocation());
    }

    public TradeLocation getTradeLocation() {
        IndianSettlement is;
        Colony colony = this.getColony();
        return colony != null ? colony : ((is = this.getIndianSettlement()) != null ? is : (this.isInEurope() ? this.getOwner().getEurope() : null));
    }

    public int getTreasureAmount() {
        return this.treasureAmount;
    }

    public void setTreasureAmount(int amount) {
        this.treasureAmount = amount;
    }

    public int getAttrition() {
        return this.attrition;
    }

    public void setAttrition(int attrition) {
        this.attrition = attrition;
    }

    public int getVisibleGoodsCount() {
        return this.visibleGoodsCount >= 0 ? this.visibleGoodsCount : this.getGoodsSpaceTaken();
    }

    public Role getAutomaticRole() {
        Colony settlement;
        if (!this.hasDefaultRole()) {
            return null;
        }
        Settlement settlement2 = this.isInColony() ? this.getColony() : (settlement = this.getLocation() instanceof IndianSettlement ? (Settlement)this.getLocation() : null);
        if (settlement == null) {
            return null;
        }
        Specification spec = this.getSpecification();
        return CollectionUtils.find(CollectionUtils.transform(CollectionUtils.flatten(this.getAbilities("model.ability.automaticEquipment"), Feature::getScopes), CollectionUtils.alwaysTrue(), s -> spec.getRole(s.getType())), r -> r != null && settlement.containsGoods(this.getGoodsDifference((Role)r, 1)));
    }

    public Role canCaptureEquipment(Role role) {
        if (!this.hasAbility("model.ability.captureEquipment")) {
            return null;
        }
        Specification spec = this.getSpecification();
        Role oldRole = this.getRole();
        return CollectionUtils.find(this.getAvailableRoles(spec.getMilitaryRolesList()), r -> CollectionUtils.any(r.getRoleChanges(), rc -> rc.getFrom(spec) == oldRole && rc.getCapture(spec) == role));
    }

    public boolean losingEquipmentKillsUnit() {
        return this.hasAbility("model.ability.disposeOnAllEquipLost") && this.getRole().getDowngrade() == null;
    }

    public boolean losingEquipmentDemotesUnit() {
        return this.hasAbility("model.ability.demoteOnAllEquipLost") && this.getRole().getDowngrade() == null;
    }

    public boolean isArmed() {
        return this.hasAbility("model.ability.armed");
    }

    public boolean isMounted() {
        return this.hasAbility("model.ability.mounted");
    }

    public boolean isBeached() {
        return this.isBeached(this.getTile());
    }

    public boolean isBeached(Tile tile) {
        return tile != null && tile.isLand() && !tile.hasSettlement() && this.isNaval();
    }

    public boolean isDefensiveUnit() {
        return (this.type.isDefensive() || this.getRole().isDefensive()) && !this.isCarrier();
    }

    public boolean isOffensiveUnit() {
        return this.type.isOffensive() || this.getRole().isOffensive();
    }

    public boolean canAmbush(Unit defender) {
        return !(!this.isOnTile() || this.getSettlement() != null || !defender.isOnTile() || defender.getSettlement() != null || defender.getState() == UnitState.FORTIFIED || !this.hasAbility("model.ability.ambushBonus") && !defender.hasAbility("model.ability.ambushPenalty") || !this.getTile().hasAbility("model.ability.ambushTerrain") && !defender.getTile().hasAbility("model.ability.ambushTerrain"));
    }

    public static boolean betterDefender(Unit defender, double defenderPower, Unit other, double otherPower) {
        if (defender == null) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && !defender.isArmed() && other.isArmed()) {
            return true;
        }
        if (defender.isPerson() && other.isPerson() && defender.isArmed() && !other.isArmed()) {
            return false;
        }
        if (!defender.isDefensiveUnit() && other.isDefensiveUnit()) {
            return true;
        }
        if (defender.isDefensiveUnit() && !other.isDefensiveUnit()) {
            return false;
        }
        return defenderPower < otherPower;
    }

    public Location getRepairLocation() {
        Player player = this.getOwner();
        Colony notHere = this.getTile().getColony();
        Predicate<Colony> repairPred = c -> c != notHere && c.hasAbility("model.ability.repairUnits");
        Colony loc = this.getClosestColony(CollectionUtils.transform(player.getColonies(), repairPred));
        return loc != null ? loc : player.getEurope();
    }

    public void damageShip(Location repair) {
        this.setHitPoints(1);
        this.setDestination(null);
        this.setLocation(repair);
        this.setState(UnitState.ACTIVE);
        this.setMovesLeft(0);
    }

    public int getMoveCost(Tile target) {
        return this.getMoveCost(this.getTile(), target, this.getMovesLeft());
    }

    public int getMoveCost(Tile from, Tile target, int ml) {
        TileItemContainer container;
        int cost = target.getType().getBasicMoveCost();
        if (target.isLand() && !this.isNaval() && (container = target.getTileItemContainer()) != null) {
            cost = container.getMoveCost(from, target, cost);
        }
        if (this.isBeached(from)) {
            cost = ml;
        } else if (cost > ml && (ml + 2 >= this.getInitialMovesLeft() || cost <= ml + 2 || target.hasSettlement()) && ml != 0) {
            cost = ml;
        }
        return cost;
    }

    public MoveType getMoveType(Direction direction) {
        Tile target;
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : ((target = this.getTile().getNeighbourOrNull(direction)) == null ? MoveType.MOVE_ILLEGAL : this.getMoveType(target));
    }

    public MoveType getMoveType(Tile target) {
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : this.getMoveType(this.getTile(), target, this.getMovesLeft());
    }

    public MoveType getMoveType(Tile from, Tile target, int ml) {
        MoveType move = this.getSimpleMoveType(from, target);
        if (move.isLegal()) {
            switch (move) {
                case ATTACK_UNIT: 
                case ATTACK_SETTLEMENT: {
                    if (ml > 0) break;
                    move = MoveType.MOVE_NO_MOVES;
                    break;
                }
                default: {
                    if (ml > 0 && (from == null || this.getMoveCost(from, target, ml) <= ml)) break;
                    move = MoveType.MOVE_NO_MOVES;
                }
            }
        }
        return move;
    }

    public MoveType getSimpleMoveType(Tile from, Tile target) {
        return this.isNaval() ? this.getNavalMoveType(from, target) : this.getLandMoveType(from, target);
    }

    public MoveType getSimpleMoveType(Tile target) {
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : this.getSimpleMoveType(this.getTile(), target);
    }

    public MoveType getSimpleMoveType(Direction direction) {
        Tile target;
        return !this.hasTile() ? MoveType.MOVE_NO_TILE : ((target = this.getTile().getNeighbourOrNull(direction)) == null ? MoveType.MOVE_ILLEGAL : this.getSimpleMoveType(this.getTile(), target));
    }

    private MoveType getNavalMoveType(Tile from, Tile target) {
        if (target == null) {
            return this.getOwner().canMoveToEurope() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE_NO_EUROPE;
        }
        if (this.isDamagedAndUnderForcedRepair()) {
            return MoveType.MOVE_NO_REPAIR;
        }
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                return MoveType.MOVE_NO_ACCESS_LAND;
            }
            if (settlement.getOwner() == this.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        Unit defender = target.getFirstUnit();
        if (defender != null && !this.getOwner().owns(defender)) {
            return this.isOffensiveUnit() ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_CIVILIAN;
        }
        return target.isDirectlyHighSeasConnected() ? MoveType.MOVE_HIGH_SEAS : MoveType.MOVE;
    }

    private MoveType getLandMoveType(Tile from, Tile target) {
        if (target == null) {
            return MoveType.MOVE_ILLEGAL;
        }
        Player owner = this.getOwner();
        Unit defender = target.getFirstUnit();
        if (target.isLand()) {
            Settlement settlement = target.getSettlement();
            if (settlement == null) {
                if (defender != null && owner != defender.getOwner()) {
                    if (defender.isNaval()) {
                        return MoveType.ATTACK_UNIT;
                    }
                    if (!this.isOffensiveUnit()) {
                        return MoveType.MOVE_NO_ATTACK_CIVILIAN;
                    }
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_UNIT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (target.hasLostCityRumour() && owner.isEuropean()) {
                    return MoveType.EXPLORE_LOST_CITY_RUMOUR;
                }
                return MoveType.MOVE;
            }
            if (owner == settlement.getOwner()) {
                return MoveType.MOVE;
            }
            if (this.isTradingUnit()) {
                return this.getTradeMoveType(settlement);
            }
            if (this.isColonist()) {
                if (settlement instanceof Colony && this.hasAbility("model.ability.negotiate")) {
                    return this.allowMoveFrom(from) ? MoveType.ENTER_FOREIGN_COLONY_WITH_SCOUT : MoveType.MOVE_NO_ACCESS_WATER;
                }
                if (settlement instanceof IndianSettlement && this.hasAbility("model.ability.speakWithChief")) {
                    return this.allowMoveFrom(from) ? MoveType.ENTER_INDIAN_SETTLEMENT_WITH_SCOUT : MoveType.MOVE_NO_ACCESS_WATER;
                }
                if (this.isOffensiveUnit()) {
                    return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
                }
                if (this.hasAbility("model.ability.establishMission")) {
                    return this.getMissionaryMoveType(from, settlement);
                }
                return this.getLearnMoveType(from, settlement);
            }
            if (this.isOffensiveUnit()) {
                return this.allowMoveFrom(from) ? MoveType.ATTACK_SETTLEMENT : MoveType.MOVE_NO_ATTACK_MARINE;
            }
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        return defender == null || !this.getOwner().owns(defender) ? MoveType.MOVE_NO_ACCESS_EMBARK : (CollectionUtils.any(target.getUnits(), u -> u.canAdd(this)) ? MoveType.EMBARK : MoveType.MOVE_NO_ACCESS_FULL);
    }

    private MoveType getTradeMoveType(Settlement settlement) {
        Player owner = this.getOwner();
        if (settlement instanceof Colony) {
            return owner.atWarWith(settlement.getOwner()) ? MoveType.MOVE_NO_ACCESS_WAR : (!this.hasAbility("model.ability.tradeWithForeignColonies") ? MoveType.MOVE_NO_ACCESS_TRADE : MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS);
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) || this.isNaval() && ((IndianSettlement)settlement).getContactLevel(owner) == IndianSettlement.ContactLevel.UNCONTACTED ? MoveType.MOVE_NO_ACCESS_CONTACT : (this.hasGoodsCargo() || this.getSpecification().getBoolean("model.option.emptyTraders") ? MoveType.ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS : MoveType.MOVE_NO_ACCESS_GOODS);
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getLearnMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (this.getUnitChange("model.unitChange.natives") == null ? MoveType.MOVE_NO_ACCESS_SKILL : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private MoveType getMissionaryMoveType(Tile from, Settlement settlement) {
        if (settlement instanceof Colony) {
            return MoveType.MOVE_NO_ACCESS_SETTLEMENT;
        }
        if (settlement instanceof IndianSettlement) {
            return !this.allowContact(settlement) ? MoveType.MOVE_NO_ACCESS_CONTACT : (!this.allowMoveFrom(from) ? MoveType.MOVE_NO_ACCESS_WATER : (settlement.getOwner().missionsBanned(this.getOwner()) ? MoveType.MOVE_NO_ACCESS_MISSION_BAN : MoveType.ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY));
        }
        return MoveType.MOVE_ILLEGAL;
    }

    private boolean allowMoveFrom(Tile from) {
        return from.isLand() || !this.getOwner().isREF() && this.getSpecification().getBoolean("model.option.amphibiousMoves");
    }

    private boolean allowContact(Settlement settlement) {
        return this.getOwner().hasContacted(settlement.getOwner());
    }

    public boolean isTileAccessible(Tile tile) {
        return this.isNaval() ? !tile.isLand() || tile.hasSettlement() && this.getOwner().owns(tile.getSettlement()) : tile.isLand();
    }

    @Override
    public int getInitialMovesLeft() {
        Turn turn = this.getGame().getTurn();
        return (int)this.apply(this.type.getMovement(), turn, "model.modifier.movementBonus", this.type);
    }

    public String getMovesAsString() {
        StringBuilder sb = new StringBuilder(16);
        int quotient = this.getMovesLeft() / 3;
        int remainder = this.getMovesLeft() % 3;
        if (quotient > 0 || remainder == 0) {
            sb.append(quotient);
        }
        if (remainder > 0) {
            sb.append('(').append(remainder).append("/3) ");
        }
        sb.append('/').append(this.getInitialMovesLeft() / 3);
        return sb.toString();
    }

    public int getSailTurns() {
        float base = this.getSpecification().getInteger("model.option.turnsToSail");
        return (int)this.getOwner().apply(base, this.getGame().getTurn(), "model.modifier.sailHighSeas", this.type);
    }

    public boolean canMoveToHighSeas() {
        Predicate<Tile> highSeasMovePred = t -> t.isDirectlyHighSeasConnected() && this.getMoveType((Tile)t) == MoveType.MOVE_HIGH_SEAS;
        return this.isAtSea() ? true : (this.isInEurope() ? this.getType().canMoveToHighSeas() : (this.hasTile() ? this.getType().canMoveToHighSeas() && this.getOwner().canMoveToEurope() && (this.getTile().isDirectlyHighSeasConnected() || CollectionUtils.any(this.getTile().getSurroundingTiles(1, 1), highSeasMovePred)) : false));
    }

    public boolean canBuildColony() {
        Specification spec = this.getSpecification();
        return this.hasTile() && this.type.canBuildColony() && this.getMovesLeft() > 0 && (!this.getOwner().isRebel() || spec.getBoolean("model.option.foundColonyDuringRebellion"));
    }

    public boolean isAtLocation(Location loc) {
        Location otherLoc;
        Location ourLoc = this.getLocation();
        Location location = otherLoc = loc instanceof Unit ? ((Unit)loc).getLocation() : loc;
        if (ourLoc instanceof Unit) {
            ourLoc = ((Unit)ourLoc).getLocation();
        }
        return Map.isSameLocation(ourLoc, otherLoc);
    }

    public Tile getBestEntryTile(Tile tile) {
        return this.getGame().getMap().getBestEntryTile(this, tile, null, null);
    }

    public Location resolveDestination() {
        Location dst;
        if (!this.isAtSea()) {
            throw new RuntimeException("Not at sea: " + this);
        }
        Tile ret = null;
        TradeRouteStop stop = this.getStop();
        Location location = dst = TradeRoute.isStopValid(this, stop) ? stop.getLocation() : this.getDestination();
        if (dst instanceof Europe) {
            return dst;
        }
        Tile tile = ret = dst != null && dst.getTile() != null ? this.getBestEntryTile(dst.getTile()) : this.getFullEntryLocation();
        if (ret == null) {
            logger.warning("resolveDestination(" + dst + ") is null for: " + this);
        }
        return ret;
    }

    private void spendAllMoves() {
        if (this.getColony() != null && this.getMovesLeft() < this.getInitialMovesLeft()) {
            this.setMovesLeft(0);
        }
    }

    public boolean isReadyToTrade() {
        return !this.isDisposed() && !this.isDamagedAndUnderForcedRepair() && !this.isAtSea() && !this.isOnCarrier() && !this.isInColony() && this.getTradeRoute() != null && this.getState() != UnitState.FORTIFYING && this.getState() != UnitState.SKIPPED && this.getMovesLeft() > 0;
    }

    private boolean readyAndAble() {
        return !this.isDisposed() && !this.isDamagedAndUnderForcedRepair() && !this.isAtSea() && !this.isOnCarrier() && !this.isInColony() && this.getState() == UnitState.ACTIVE && this.getMovesLeft() > 0;
    }

    public boolean isCandidateForNextActiveUnit() {
        return this.couldMove() && !this.isInEurope();
    }

    public boolean couldMove() {
        return this.readyAndAble() && this.getDestination() == null && this.getTradeRoute() == null;
    }

    public boolean goingToDestination() {
        return this.readyAndAble() && this.getTradeRoute() == null && this.getDestination() != null;
    }

    public boolean followingTradeRoute() {
        return this.readyAndAble() && this.getTradeRoute() != null;
    }

    public Location getPathStartLocation() {
        Unit carrier = this.getCarrier();
        Location ret = this.getTile();
        if (this.isOnCarrier()) {
            if (ret == null) {
                ret = carrier.getDestination() == null ? null : (carrier.getDestination() instanceof Map ? carrier.getFullEntryLocation() : (carrier.getDestination() instanceof Settlement ? carrier.getDestination() : null));
            }
        } else if (this.isNaval() && ret == null) {
            ret = this.getDestination() == null || this.getDestination() instanceof Map ? this.getFullEntryLocation() : (this.getDestination() instanceof Settlement ? this.getDestination() : this.getFullEntryLocation());
        }
        if (ret != null) {
            return ret;
        }
        Player owner = this.getOwner();
        Settlement sett = CollectionUtils.minimize(owner.getSettlements(), settlementStartComparator);
        if (sett == null) {
            sett = CollectionUtils.first(owner.getSettlements());
        }
        if (sett != null) {
            return sett;
        }
        if (owner.isREF()) {
            return CollectionUtils.minimize(CollectionUtils.flatten(owner.getRebels(), Player::getSettlements), settlementStartComparator);
        }
        Tile loc = this.getFullEntryLocation();
        return loc == null || loc.getTile() == null ? null : (Location)CollectionUtils.find(loc.getTile().getSurroundingTiles(1, Integer.MAX_VALUE), Tile::isLand);
    }

    public boolean shouldTakeTransportTo(Location loc) {
        PathNode path;
        return loc != null && !this.isNaval() && !this.isAtLocation(loc) && ((path = this.findPath(this.getLocation(), loc, this.getCarrier())) == null || path.usesCarrier());
    }

    public PathNode getTrivialPath() {
        Tile tile;
        if (this.isDisposed() || this.getLocation() == null) {
            return null;
        }
        if (!this.isNaval()) {
            return this.findOurNearestSettlement();
        }
        PathNode path = this.findOurNearestPort();
        if (path == null && (tile = this.getTile()) != null && tile.isOnRiver() && tile.isHighSeasConnected() && (path = this.search(this.getLocation(), GoalDeciders.getCornerGoalDecider(), CostDeciders.avoidSettlementsAndBlockingUnits(), Integer.MAX_VALUE, null)) == null && tile.isRiverCorner()) {
            return new PathNode(tile, 0, 0, false, null, null);
        }
        return path;
    }

    private Comparator<Tile> getPathComparator(Location start, Unit carrier, CostDecider costDecider) {
        return CollectionUtils.cachingIntComparator(t -> {
            PathNode p = this.findPath(start, (Location)t, carrier, costDecider, null);
            return p == null ? Integer.MAX_VALUE : p.getTotalTurns();
        });
    }

    public PathNode findPath(Location end) {
        return this.findPath(this.getLocation(), end);
    }

    public PathNode findPath(Location start, Location end) {
        return this.findPath(start, end, null);
    }

    public PathNode findPath(Location start, Location end, Unit carrier) {
        return this.findPath(start, end, carrier, null, null);
    }

    public PathNode findPath(Location start, Location end, Unit carrier, CostDecider costDecider, LogBuilder lb) {
        if (end == null) {
            throw new IllegalArgumentException("findPath to null for " + this + " from " + start + " on " + carrier);
        }
        return this.getGame().getMap().findPath(this, this.realStart(start, carrier), end, carrier, costDecider, lb);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Location realStart(Location start, Unit carrier) {
        Location entry;
        if (carrier != null && !carrier.canCarryUnits()) {
            throw new IllegalArgumentException("Non-carrier carrier: " + carrier);
        }
        if (carrier != null && !carrier.couldCarry(this)) {
            throw new IllegalArgumentException("Carrier could not carry unit: " + carrier + "/" + this);
        }
        if (start == null) {
            throw new IllegalArgumentException("Null start: " + this);
        }
        if (start instanceof Unit) {
            Location unitLoc = ((Unit)start).getLocation();
            if (unitLoc == null) {
                throw new IllegalArgumentException("Null on-carrier start: " + this + "/" + start);
            }
            if (unitLoc instanceof HighSeas) {
                if (carrier == null) {
                    throw new IllegalArgumentException("Null carrier when starting on high seas: " + this);
                }
                if (carrier != start) {
                    throw new IllegalArgumentException("Wrong carrier when starting on high seas: " + this + "/" + carrier + " != " + start);
                }
                entry = carrier.resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                entry = unitLoc;
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else if (start instanceof HighSeas) {
            if (this.isOnCarrier()) {
                entry = this.getCarrier().resolveDestination();
                return entry.getTile() != null ? entry.getTile() : entry;
            } else {
                if (!this.isNaval()) throw new IllegalArgumentException("No carrier when starting on high seas: " + this + "/" + this.getLocation());
                entry = this.resolveDestination();
            }
            return entry.getTile() != null ? entry.getTile() : entry;
        } else {
            if (!(start instanceof Europe) && start.getTile() == null) throw new IllegalArgumentException("Invalid start: " + start);
            entry = start;
        }
        return entry.getTile() != null ? entry.getTile() : entry;
    }

    public PathNode search(Location start, GoalDecider gd, CostDecider cd, int maxTurns, Unit carrier) {
        return start == null ? null : this.getGame().getMap().search(this, this.realStart(start, carrier), gd, cd, maxTurns, carrier, null);
    }

    public PathNode findPathToNeighbour(Location start, Tile end, Unit carrier, CostDecider costDecider) {
        Player owner = this.getOwner();
        Predicate<Tile> endPred = t -> this.isTileAccessible((Tile)t) && (t.getFirstUnit() == null || owner.owns(t.getFirstUnit()));
        Tile best = CollectionUtils.minimize(end.getSurroundingTiles(1, 1), endPred, this.getPathComparator(start, carrier, costDecider));
        return best == null ? null : this.findPath(start, best, carrier, costDecider, null);
    }

    public int getTurnsToReach(Location end) {
        return this.getTurnsToReach(this.getLocation(), end);
    }

    public int getTurnsToReach(Location start, Location end) {
        return this.getTurnsToReach(start, end, this.getCarrier(), CostDeciders.avoidSettlementsAndBlockingUnits());
    }

    public int getTurnsToReach(Location start, Location end, Unit carrier, CostDecider costDecider) {
        PathNode path = this.findPath(start, end, carrier, costDecider, null);
        return path == null ? 10000 : path.getTotalTurns();
    }

    public Colony getClosestColony(List<Colony> colonies) {
        return this.getClosestColony(colonies.stream());
    }

    public Colony getClosestColony(Stream<Colony> colonies) {
        Comparator<Colony> comp = CollectionUtils.cachingIntComparator(col -> col == null ? 9999 : this.getTurnsToReach((Location)col));
        return CollectionUtils.minimize(CollectionUtils.concat(Stream.of((Colony)null), colonies), comp);
    }

    public PathNode findOurNearestSettlement(boolean excludeStart, int range, boolean coastal) {
        Player player = this.getOwner();
        if (!player.hasSettlements() || !this.hasTile()) {
            return null;
        }
        return this.findOurNearestSettlement(this.getTile(), excludeStart, range, coastal);
    }

    public PathNode findOurNearestSettlement(Tile startTile, boolean excludeStart, int range, boolean coastal) {
        Player player = this.getOwner();
        if (startTile == null || !player.hasSettlements()) {
            return null;
        }
        ClosestSettlementGoalDecider gd = new ClosestSettlementGoalDecider(excludeStart ? startTile : null, coastal);
        return this.search(startTile, gd, CostDeciders.avoidIllegal(), range, null);
    }

    public PathNode findOurNearestSettlement() {
        return this.findOurNearestSettlement(false, Integer.MAX_VALUE, false);
    }

    public PathNode findOurNearestPort() {
        PathNode sPath;
        int sTurns;
        PathNode ePath = null;
        int eTurns = -1;
        Europe europe = this.getOwner().getEurope();
        if (this.getType().canMoveToHighSeas()) {
            ePath = europe == null ? null : this.findPath(europe);
            eTurns = ePath == null ? -1 : ePath.getTotalTurns();
        }
        int n = sTurns = (sPath = this.findOurNearestSettlement(false, Integer.MAX_VALUE, true)) == null ? -1 : sPath.getTotalTurns();
        return ePath == null ? sPath : (sPath == null ? ePath : (sTurns <= eTurns ? sPath : ePath));
    }

    public PathNode findIntermediatePort(Location dst) {
        Settlement ignoreSrc = this.getSettlement();
        Settlement ignoreDst = dst.getSettlement();
        Tile srcTile = this.getTile();
        Tile dstTile = dst.getTile();
        int dstCont = dstTile == null ? -1 : dstTile.getContiguity();
        Comparator<Settlement> settlementComparator = CollectionUtils.cachingIntComparator(s -> {
            PathNode p = this.findPath((Location)s);
            return p == null ? Integer.MAX_VALUE : p.getTotalTurns() + dstTile.getDistanceTo(s.getTile());
        });
        PortMode type = this.isNaval() ? (!srcTile.isHighSeasConnected() ? PortMode.LAKE : (dstTile == null ? PortMode.NO_HIGH_SEAS : (dstTile.isHighSeasConnected() ? (this.getTile().isOnRiver() ? PortMode.NO_HIGH_SEAS : PortMode.BLOCKED) : PortMode.BLOCKED))) : (dstTile == null || this.getTile().getContiguity() != dstCont ? (srcTile.isHighSeasConnected() ? PortMode.NO_HIGH_SEAS : PortMode.BLOCKED) : PortMode.LAND);
        PathNode path = null;
        switch (type) {
            case LAKE: {
                break;
            }
            case NO_HIGH_SEAS: {
                path = this.search(this.getLocation(), GoalDeciders.getReduceHighSeasCountGoalDecider(this), null, Integer.MAX_VALUE, null);
                break;
            }
            case BLOCKED: {
                Predicate<Settlement> portPredicate = s -> s != ignoreSrc && s != ignoreDst;
                Settlement sett = CollectionUtils.minimize(this.getOwner().getConnectedPortList(), portPredicate, settlementComparator);
                path = sett == null ? null : this.findPath(sett);
                break;
            }
            case LAND: {
                Predicate<Settlement> contiguityPred = s -> s != ignoreSrc && s != ignoreDst && s.getTile().getContiguity() == dstCont;
                Settlement sett = CollectionUtils.minimize(this.getOwner().getSettlements(), contiguityPred, settlementComparator);
                path = sett == null ? null : this.findPath(sett);
            }
        }
        return path != null ? path : this.findOurNearestSettlement(false, Integer.MAX_VALUE, false);
    }

    public PathNode findOurNearestOtherSettlement() {
        return this.findOurNearestSettlement(true, Integer.MAX_VALUE, false);
    }

    public boolean canAttack(Unit defender) {
        if (defender == null || !defender.hasTile() || !this.isOffensiveUnit()) {
            return false;
        }
        Tile tile = defender.getTile();
        return this.isNaval() ? !tile.hasSettlement() && defender.isNaval() : !defender.isNaval() || defender.isBeached();
    }

    public PathNode searchForDanger(final int range, final float threat) {
        final CombatModel cm = this.getGame().getCombatModel();
        final Tile start = this.getTile();
        GoalDecider threatDecider = new GoalDecider(){
            private PathNode found = null;

            @Override
            public PathNode getGoal() {
                return this.found;
            }

            @Override
            public boolean hasSubGoals() {
                return false;
            }

            @Override
            public boolean check(Unit unit, PathNode path) {
                Tile tile = path.getTile();
                if (tile == null) {
                    return false;
                }
                Unit first = tile.getFirstUnit();
                if (first == null || !Unit.this.getOwner().atWarWith(first.getOwner())) {
                    return false;
                }
                Predicate<Unit> attackerPred = u -> {
                    PathNode p;
                    return u.canAttack(unit) && cm2.calculateCombatOdds((FreeColGameObject)u, (FreeColGameObject)unit).win >= (double)threat && (p = u.findPath(start)) != null && p.getTotalTurns() < range;
                };
                if (CollectionUtils.any(CollectionUtils.transform(tile.getUnits(), attackerPred))) {
                    this.found = path;
                    return true;
                }
                return false;
            }
        };
        int reverseRange = range * (this.isNaval() ? this.getSpecification().getFastestNavalUnitType() : this.getSpecification().getFastestLandUnitType()).getMovement() / this.getType().getMovement();
        return start == null ? null : this.search(start, threatDecider, CostDeciders.avoidIllegal(), reverseRange, this.getCarrier());
    }

    public boolean isInDanger(int range, float threat) {
        return this.searchForDanger(range, threat) != null;
    }

    public int getLineOfSight() {
        Turn turn = this.getGame().getTurn();
        return (int)Unit.applyModifiers((float)this.type.getLineOfSight(), turn, Stream.concat(this.getModifiers("model.modifier.lineOfSightBonus", this.type, turn), this.hasTile() && this.getTile().isExplored() ? this.getTile().getType().getModifiers("model.modifier.lineOfSightBonus", this.type, turn) : Stream.empty()));
    }

    public Set<Tile> getVisibleTileSet() {
        Tile tile = this.getTile();
        return tile == null ? Collections.emptySet() : new HashSet<Tile>(tile.getSurroundingTiles(0, this.getLineOfSight()));
    }

    private List<Goods> getGoodsInternal(boolean compact) {
        GoodsContainer gc = this.getGoodsContainer();
        if (gc == null) {
            return Collections.emptyList();
        }
        List<Goods> goods = compact ? gc.getCompactGoodsList() : gc.getGoodsList();
        for (Goods g : goods) {
            g.setLocation(this);
        }
        return goods;
    }

    @Override
    public List<Goods> getGoodsList() {
        return this.getGoodsInternal(false);
    }

    @Override
    public List<Goods> getCompactGoodsList() {
        return this.getGoodsInternal(true);
    }

    public boolean canCarryUnits() {
        return this.hasAbility("model.ability.carryUnits");
    }

    public boolean couldCarry(Unit u) {
        return this.canCarryUnits() && this.getCargoCapacity() >= u.getSpaceTaken();
    }

    public boolean canCarryGoods() {
        return this.hasAbility("model.ability.carryGoods");
    }

    public boolean couldCarry(Goods g) {
        return this.canCarryGoods() && this.getCargoCapacity() >= g.getSpaceTaken();
    }

    public int getSpaceLeft() {
        return this.getCargoCapacity() - this.getCargoSpaceTaken();
    }

    public boolean hasSpaceLeft() {
        return this.getSpaceLeft() > 0;
    }

    public int getCargoCapacity() {
        return this.type.getSpace();
    }

    public int getGoodsSpaceTaken() {
        if (!this.canCarryGoods()) {
            return 0;
        }
        GoodsContainer gc = this.getGoodsContainer();
        return gc == null ? 0 : gc.getSpaceTaken();
    }

    public int getUnitSpaceTaken() {
        return this.canCarryUnits() ? CollectionUtils.sum(this.getUnits(), Unit::getSpaceTaken) : 0;
    }

    public int getCargoSpaceTaken() {
        return this.getGoodsSpaceTaken() + this.getUnitSpaceTaken();
    }

    public boolean hasGoodsCargo() {
        return this.getGoodsSpaceTaken() > 0;
    }

    public boolean hasCargo() {
        return this.getCargoSpaceTaken() > 0;
    }

    public int getLoadableAmount(GoodsType type) {
        if (!this.canCarryGoods()) {
            return 0;
        }
        int result = this.getSpaceLeft() * 100;
        int count = this.getGoodsCount(type) % 100;
        if (count != 0) {
            result += 100 - count;
        }
        return result;
    }

    public StringTemplate getOccupationLabel(Player player, boolean full) {
        TradeRoute tradeRoute = this.getTradeRoute();
        Object ret = player != null && player.owns(this) ? (this.isDamagedAndUnderForcedRepair() ? (full ? ((StringTemplate)StringTemplate.label(":").add("model.unit.occupation.underRepair")).addName(String.valueOf(this.getTurnsForRepair())) : StringTemplate.key("model.unit.occupation.underRepair")) : (tradeRoute != null ? (full ? ((StringTemplate)StringTemplate.label(":").add("model.unit.occupation.inTradeRoute")).addName(tradeRoute.getName()) : StringTemplate.key("model.unit.occupation.inTradeRoute")) : (this.getState() == UnitState.ACTIVE && this.getMovesLeft() == 0 && !this.isInEurope() ? StringTemplate.key("model.unit.occupation.activeNoMovesLeft") : (this.getState() == UnitState.IMPROVING && this.getWorkImprovement() != null ? (full ? ((StringTemplate)StringTemplate.label(":").add(this.getWorkImprovement().getType() + ".occupationString")).addName(String.valueOf(this.getWorkTurnsLeft())) : StringTemplate.key(this.getWorkImprovement().getType() + ".occupationString")) : (this.getDestination() != null ? StringTemplate.key("model.unit.occupation.goingSomewhere") : StringTemplate.key("model.unit." + this.getState().getKey())))))) : (this.isNaval() ? StringTemplate.name(String.valueOf(this.getVisibleGoodsCount())) : StringTemplate.key("model.unit.occupation.activeNoMovesLeft"));
        return ret;
    }

    public float getConvertProbability() {
        Specification spec = this.getSpecification();
        int opt = spec.getInteger("model.option.nativeConvertProbability");
        return 0.01f * this.apply(opt, this.getGame().getTurn(), "model.modifier.nativeConvertBonus");
    }

    public float getBurnProbability() {
        Specification spec = this.getSpecification();
        return 0.01f * (float)spec.getInteger("model.option.burnProbability");
    }

    public boolean canCashInTreasureTrain() {
        return this.canCashInTreasureTrain(this.getLocation());
    }

    public boolean canCashInTreasureTrain(Location loc) {
        if (!this.canCarryTreasure()) {
            throw new RuntimeException("Can't carry treasure: " + this);
        }
        if (loc == null) {
            return false;
        }
        if (this.getOwner().getEurope() == null) {
            return loc.getColony() != null;
        }
        if (loc.getColony() != null) {
            return loc.getColony().isConnectedPort() && (this.getOwner().getCarriersForUnit(this).isEmpty() || this.getTransportFee() == 0);
        }
        return loc instanceof Europe || loc instanceof Unit && ((Unit)loc).isInEurope();
    }

    public int getTransportFee() {
        if (!this.isInEurope() && this.getOwner().getEurope() != null) {
            float fee = (float)(this.getSpecification().getInteger("model.option.treasureTransportFee") * this.getTreasureAmount()) / 100.0f;
            return (int)this.getOwner().apply(fee, this.getGame().getTurn(), "model.modifier.treasureTransportFee", this.type);
        }
        return 0;
    }

    public int getSkillLevel() {
        return Unit.getUnitSkillLevel(this.type);
    }

    public static int getUnitSkillLevel(UnitType unitType) {
        return unitType.hasSkill() ? unitType.getSkill() : 0;
    }

    public Set<Modifier> getMissionaryTradeModifiers(boolean sense) {
        Function<Modifier, Modifier> mapper = m -> {
            Modifier mod = Modifier.makeModifier(m);
            if (!sense) {
                mod.setValue(-m.getValue());
            }
            return mod;
        };
        return CollectionUtils.transform(this.getModifiers("model.modifier.missionaryTradeBonus"), m -> m.getValue() != 0.0f, mapper, Collectors.toSet());
    }

    public void addFeature(Feature feature) {
        throw new UnsupportedOperationException("Can not add Feature to Unit directly!");
    }

    public ProductionInfo getProductionInfo(List<AbstractGoods> input) {
        ProductionInfo result = new ProductionInfo();
        result.setConsumption(this.getType().getConsumedGoods());
        result.setMaximumConsumption(this.getType().getConsumedGoods());
        return result;
    }

    public int getPioneerScore() {
        int ht;
        int n = ht = this.hasTile() ? 100 : 0;
        return this.getLocation() == null || !this.isColonist() ? -1000 : (this.hasAbility("model.ability.improveTerrain") ? 900 + ht : (this.hasAbility("model.ability.expertPioneer") ? 700 : (!this.hasDefaultRole() ? 0 : (this.getSkillLevel() > 0 ? 0 : 200 + this.getSkillLevel() * 50))));
    }

    public int getScoutScore() {
        int ht;
        int n = ht = this.hasTile() ? 100 : 0;
        return this.getLocation() == null || !this.isColonist() ? -1000 : (this.hasAbility("model.ability.speakWithChief") ? 900 + ht : (this.hasAbility("model.ability.expertScout") ? 700 : (!this.hasDefaultRole() ? 0 : (this.getSkillLevel() <= 0 ? -200 * this.getSkillLevel() : 0))));
    }

    public int evaluateFor(Player player) {
        Europe europe = player.getEurope();
        if (europe == null) {
            return 500;
        }
        int price = europe.getUnitPrice(this.getType());
        return price == Integer.MIN_VALUE ? 500 : price;
    }

    public Set<Modifier> getCombatModifiers(String id, FreeColSpecObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        HashSet<Modifier> result = new HashSet<Modifier>();
        result.addAll(CollectionUtils.transform(unitType.getModifiers(id, fcgot, turn), CollectionUtils.alwaysTrue(), m -> m.setModifierIndex(m.getType() == Modifier.ModifierType.ADDITIVE ? 20 : 40)));
        result.addAll(CollectionUtils.transform(owner.getModifiers(id, fcgot, turn), CollectionUtils.alwaysTrue(), m -> m.setModifierIndex(50)));
        result.addAll(CollectionUtils.transform(this.role.getModifiers(id, fcgot, turn), CollectionUtils.alwaysTrue(), m -> m.setModifierIndex(30)));
        return result;
    }

    private boolean nonExpertWorker(GoodsType work) {
        return this.isPerson() && this.getWorkType() == work && this.getType().getExpertProduction() != work;
    }

    public Unit trySwapExpert(List<Unit> others) {
        GoodsType work = this.getType().getExpertProduction();
        if (work == null) {
            return null;
        }
        Unit other = CollectionUtils.find(others, u -> u.nonExpertWorker(work));
        if (other != null) {
            this.swapWork(other);
        }
        return other;
    }

    public void swapWork(Unit other) {
        Colony colony = this.getColony();
        Role oldRole = this.getRole();
        int oldRoleCount = this.getRoleCount();
        GoodsType work = this.getType().getExpertProduction();
        GoodsType oldWork = this.getWorkType();
        Location l1 = this.getLocation();
        Location l2 = other.getLocation();
        other.setLocation(colony.getTile());
        this.setLocation(l2);
        this.changeWorkType(work);
        other.setLocation(l1);
        if (oldWork != null) {
            other.changeWorkType(oldWork);
        }
        Role tmpRole = other.getRole();
        int tmpRoleCount = other.getRoleCount();
        other.changeRole(oldRole, oldRoleCount);
        this.changeRole(tmpRole, tmpRoleCount);
    }

    public Tile getNeighbourTile(String directionString) {
        if (!this.hasTile()) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        Direction direction = Enum.valueOf(Direction.class, directionString);
        Tile tile = this.getTile().getNeighbourOrNull(direction);
        if (tile == null) {
            throw new IllegalStateException("Could not find tile in direction: " + direction + " from unit: " + this.getId());
        }
        return tile;
    }

    public <T extends Settlement> T getAdjacentSettlement(String settlementId, Class<T> returnClass) {
        Game game = this.getOwner().getGame();
        Settlement ret = (Settlement)game.getFreeColGameObject(settlementId, returnClass);
        if (ret == null) {
            throw new IllegalStateException("Not a settlement: " + settlementId);
        }
        if (ret.getTile() == null) {
            throw new IllegalStateException("Settlement is not on the map: " + settlementId);
        }
        if (!this.getOwner().hasContacted(ret.getOwner())) {
            throw new IllegalStateException("Player " + this.getOwner().getId() + " has not contacted: " + ret.getOwner().getId());
        }
        if (!this.hasTile()) {
            throw new IllegalStateException("Unit is not on the map: " + this.getId());
        }
        if (this.getTile().getDistanceTo(ret.getTile()) > 1) {
            throw new IllegalStateException("Unit " + this.getId() + " is not adjacent to settlement: " + settlementId);
        }
        if (this.getOwner() == ret.getOwner()) {
            throw new IllegalStateException("Unit: " + this.getId() + " and settlement: " + settlementId + " are both owned by player: " + this.getOwner().getId());
        }
        return (T)ret;
    }

    public Unit reduceVisibility(Tile tile, Player player) {
        Game game = this.getGame();
        Unit ret = (Unit)this.copy(game, player);
        if (this.isOnCarrier()) {
            Unit carrier = (Unit)this.getCarrier().copy(game, player);
            carrier.removeAll();
            carrier.add(ret);
            carrier.setLocationNoUpdate(tile);
            ret.setLocationNoUpdate(carrier);
        } else {
            ret.setLocationNoUpdate(tile);
            ret.setWorkType(null);
            ret.setState(UnitState.ACTIVE);
        }
        return ret;
    }

    @Override
    public List<AbstractGoods> getConsumedGoods() {
        return this.type.getConsumedGoods();
    }

    @Override
    public int getPriority() {
        return this.type.getPriority();
    }

    @Override
    public Stream<Modifier> getConsumptionModifiers(String id) {
        return this.getModifiers(id);
    }

    @Override
    public Player getOwner() {
        return this.owner;
    }

    @Override
    public void setOwner(Player player) {
        this.owner = player;
    }

    @Override
    public Location getLocation() {
        return this.location;
    }

    @Override
    public boolean setLocation(Location newLocation) {
        boolean preserveEducation;
        if (newLocation instanceof Colony) {
            return ((Colony)newLocation).joinColony(this);
        }
        if (newLocation == this.location) {
            return true;
        }
        if (newLocation != null && !newLocation.canAdd(this)) {
            logger.warning("Can not add " + this + " to " + newLocation);
            return false;
        }
        Colony oldColony = this.isInColony() ? this.location.getColony() : null;
        Colony newColony = newLocation instanceof WorkLocation ? newLocation.getColony() : null;
        boolean withinColony = newColony != null && newColony == oldColony;
        boolean bl = preserveEducation = withinColony && ((WorkLocation)this.location).canTeach() == ((WorkLocation)newLocation).canTeach();
        if (oldColony != null && !preserveEducation) {
            oldColony.updateEducation(this, false);
        }
        if (this.location != null && !this.location.remove(this)) {
            throw new RuntimeException("Failed to remove " + this + " from " + this.location.getId());
        }
        if (newLocation == null) {
            this.setLocationNoUpdate(null);
        } else if (!newLocation.add(this)) {
            throw new RuntimeException("Failed to add " + this + " to " + newLocation.getId());
        }
        if (newColony != null && !preserveEducation) {
            newColony.updateEducation(this, true);
        }
        if (!withinColony) {
            if (oldColony != null) {
                oldColony.updatePopulation();
            }
            if (newColony != null) {
                newColony.updatePopulation();
            }
        }
        return true;
    }

    @Override
    public boolean isInEurope() {
        return this.isOnCarrier() ? this.getCarrier().isInEurope() : this.getLocation() instanceof Europe;
    }

    @Override
    public Tile getTile() {
        return this.getLocation() != null ? this.getLocation().getTile() : null;
    }

    @Override
    public StringTemplate getLocationLabel() {
        return StringTemplate.template("model.unit.onBoard").addStringTemplate("%unit%", this.getLabel());
    }

    @Override
    public boolean add(Locatable locatable) {
        if (!this.canAdd(locatable)) {
            return false;
        }
        if (locatable instanceof Unit) {
            Unit unit = (Unit)locatable;
            if (super.add(locatable)) {
                this.spendAllMoves();
                unit.setState(UnitState.SENTRY);
                return true;
            }
        } else if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            if (super.addGoods(goods)) {
                this.spendAllMoves();
                return true;
            }
        } else {
            throw new IllegalStateException("Can not be added to unit: " + locatable);
        }
        return false;
    }

    @Override
    public boolean remove(Locatable locatable) {
        if (locatable == null) {
            throw new RuntimeException("Locatable must not be null: " + this);
        }
        if (locatable instanceof Unit && this.canCarryUnits()) {
            if (super.remove(locatable)) {
                this.spendAllMoves();
                return true;
            }
        } else if (locatable instanceof Goods && this.canCarryGoods()) {
            if (super.removeGoods((Goods)locatable) != null) {
                this.spendAllMoves();
                return true;
            }
        } else {
            logger.warning("Tried to remove from unit: " + locatable);
        }
        return false;
    }

    @Override
    public Settlement getSettlement() {
        Location loc = this.getLocation();
        return loc != null ? loc.getSettlement() : null;
    }

    @Override
    public Location up() {
        return this.isInEurope() ? this.getLocation().up() : (this.isInColony() ? this.getColony() : (this.hasTile() ? this.getTile().up() : this));
    }

    @Override
    public int getRank() {
        return Location.rankOf(this.getLocation());
    }

    @Override
    public String toShortString() {
        StringBuilder sb = new StringBuilder(32);
        sb.append(this.getId()).append('-').append(this.getType().getSuffix());
        if (!this.hasDefaultRole()) {
            sb.append('-').append(this.getRoleSuffix());
            int count = this.getRoleCount();
            if (count > 1) {
                sb.append('.').append(count);
            }
        }
        return sb.toString();
    }

    @Override
    public int getSpaceTaken() {
        return this.type.getSpaceTaken();
    }

    @Override
    public UnitLocation.NoAddReason getNoAddReason(Locatable locatable) {
        if (locatable == this) {
            return UnitLocation.NoAddReason.ALREADY_PRESENT;
        }
        if (locatable instanceof Unit) {
            return !this.canCarryUnits() ? UnitLocation.NoAddReason.WRONG_TYPE : (locatable.getSpaceTaken() > this.getSpaceLeft() ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : super.getNoAddReason(locatable));
        }
        if (locatable instanceof Goods) {
            Goods goods = (Goods)locatable;
            return !this.canCarryGoods() ? UnitLocation.NoAddReason.WRONG_TYPE : (goods.getAmount() > this.getLoadableAmount(goods.getType()) ? UnitLocation.NoAddReason.CAPACITY_EXCEEDED : UnitLocation.NoAddReason.NONE);
        }
        return super.getNoAddReason(locatable);
    }

    @Override
    public void invalidateCache() {
    }

    @Override
    public int getGoodsCapacity() {
        return this.getCargoCapacity();
    }

    public boolean canAttackRanged(Tile tile) {
        return this.getType().getAttackRange() >= this.getTile().getDistanceTo(tile) && (tile.getSettlement() != null && tile.getSettlement().getOwner() != this.getOwner() || tile.getDefendingUnit(this) != null && tile.getDefendingUnit(this).getOwner() != this.getOwner());
    }

    @Override
    public void disposeResources() {
        Location loc = this.getLocation();
        if (loc != null) {
            loc.remove(this);
        }
        if (this.teacher != null) {
            this.teacher.setStudent(null);
            this.teacher = null;
        }
        if (this.student != null) {
            this.student.setTeacher(null);
            this.student = null;
        }
        this.changeHomeIndianSettlement(null);
        this.getOwner().removeUnit(this);
        super.disposeResources();
    }

    @Override
    public FreeColGameObject getLinkTarget(Player player) {
        return this.hasTile() ? (FreeColGameObject)((Object)this.getTile().up()) : player.getEurope();
    }

    @Override
    public Constants.IntegrityType checkIntegrity(boolean fix, LogBuilder lb) {
        Constants.IntegrityType result = super.checkIntegrity(fix, lb);
        if (this.role == null) {
            if (fix) {
                this.role = this.getSpecification().getDefaultRole();
                lb.add("\n  Missing role set to default for: ", this.getId());
                result = result.fix();
            } else {
                lb.add("\n  Missing role for: ", this.getId());
                result = result.fail();
            }
        }
        if (this.destination != null && !((FreeColGameObject)((Object)this.destination)).isInitialized()) {
            if (fix) {
                this.destination = null;
                lb.add("\n  Uninitialized destination cleared for: ", this.getId());
                result = result.fix();
            } else {
                lb.add("\n  Uninitialized destination for: ", this.getId());
                result = result.fail();
            }
        }
        if (this.state == UnitState.IMPROVING && this.workImprovement == null) {
            if (fix) {
                this.state = UnitState.ACTIVE;
                lb.add("\n  Improving unit without improvement made active: ", this.getId());
                result = result.fix();
            } else {
                lb.add("\n  Improving unit without improvement: ", this.getId());
                result = result.fail();
            }
        }
        return result;
    }

    @Override
    public Stream<Ability> getAbilities(String id, FreeColSpecObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        return CollectionUtils.concat(unitType.getAbilities(id), this.role.getAbilities(id, fcgot, turn), owner.getAbilities(id, fcgot, turn), this.getLocationAbilities(id, turn));
    }

    private Stream<Ability> getLocationAbilities(String id, Turn turn) {
        Europe europe;
        UnitType unitType = this.getType();
        Settlement settlement = this.getSettlement();
        if (settlement != null) {
            return settlement.getAbilities(id, unitType, turn);
        }
        if (this.isInEurope() && (europe = this.owner.getEurope()) != null) {
            return europe.getAbilities(id, this.getType(), turn);
        }
        return Stream.empty();
    }

    @Override
    public Stream<Modifier> getModifiers(String id, FreeColSpecObjectType fcgot, Turn turn) {
        Player owner = this.getOwner();
        UnitType unitType = this.getType();
        return CollectionUtils.concat(unitType.getModifiers(id, fcgot, turn), owner.getModifiers(id, fcgot, turn), this.role.getModifiers(id, fcgot, turn));
    }

    @Override
    public int getClassIndex() {
        return 40;
    }

    @Override
    public <T extends FreeColObject> boolean copyIn(T other) {
        Unit o = this.copyInCast(other, Unit.class);
        if (o == null || !super.copyIn(o)) {
            return false;
        }
        Game game = this.getGame();
        this.name = o.getName();
        this.owner = game.updateRef(o.getOwner());
        this.type = o.getType();
        this.state = o.getState();
        this.role = o.getRole();
        this.roleCount = o.getRoleCount();
        this.location = game.updateLocationRef(o.getLocation());
        this.entryLocation = game.updateLocationRef(o.getEntryLocation());
        this.movesLeft = o.getMovesLeft();
        this.workType = o.getWorkType();
        this.experienceType = o.getExperienceType();
        this.experience = o.getExperience();
        this.workLeft = o.getWorkLeft();
        this.workImprovement = game.update(o.getWorkImprovement(), true);
        this.student = game.updateRef(o.getStudent());
        this.teacher = game.updateRef(o.getTeacher());
        this.turnsOfTraining = o.getTurnsOfTraining();
        this.nationality = o.getNationality();
        this.ethnicity = o.getEthnicity();
        this.indianSettlement = game.updateRef(o.getIndianSettlement());
        this.hitPoints = o.getHitPoints();
        this.destination = game.updateLocationRef(o.getDestination());
        this.tradeRoute = game.updateRef(o.getTradeRoute());
        this.currentStop = o.getCurrentStop();
        this.treasureAmount = o.getTreasureAmount();
        this.attrition = o.getAttrition();
        this.visibleGoodsCount = o.getVisibleGoodsCount();
        this.owner.addUnit(this);
        return true;
    }

    @Override
    public FreeColObject getDisplayObject() {
        return this.getType();
    }

    @Override
    protected void writeAttributes(FreeColXMLWriter xw) throws XMLStreamException {
        super.writeAttributes(xw);
        if (this.name != null) {
            xw.writeAttribute(NAME_TAG, this.name);
        }
        xw.writeAttribute(UNIT_TYPE_TAG, this.type);
        xw.writeAttribute(MOVES_LEFT_TAG, this.movesLeft);
        xw.writeAttribute(STATE_TAG, this.state);
        xw.writeAttribute(ROLE_TAG, this.role);
        xw.writeAttribute(ROLE_COUNT_TAG, this.roleCount);
        xw.writeAttribute(HIT_POINTS_TAG, this.hitPoints);
        if (!xw.validFor(this.getOwner()) && this.isOwnerHidden()) {
            xw.writeAttribute(OWNER_TAG, this.getGame().getUnknownEnemy());
        } else {
            xw.writeAttribute(OWNER_TAG, this.getOwner());
            if (this.nationality != null) {
                xw.writeAttribute(NATIONALITY_TAG, this.nationality);
            }
            if (this.ethnicity != null) {
                xw.writeAttribute(ETHNICITY_TAG, this.ethnicity);
            }
        }
        if (this.location != null) {
            xw.writeLocationAttribute(LOCATION_TAG, this.location);
        }
        xw.writeAttribute(TREASURE_AMOUNT_TAG, this.treasureAmount);
        if (xw.validFor(this.getOwner())) {
            if (this.entryLocation != null) {
                xw.writeLocationAttribute(ENTRY_LOCATION_TAG, this.entryLocation);
            }
            xw.writeAttribute(TURNS_OF_TRAINING_TAG, this.turnsOfTraining);
            if (this.workType != null) {
                xw.writeAttribute(WORK_TYPE_TAG, this.workType);
            }
            if (this.experienceType != null) {
                xw.writeAttribute(EXPERIENCE_TYPE_TAG, this.experienceType);
            }
            xw.writeAttribute(EXPERIENCE_TAG, this.experience);
            xw.writeAttribute(INDIAN_SETTLEMENT_TAG, this.indianSettlement);
            xw.writeAttribute(WORK_LEFT_TAG, this.workLeft);
            xw.writeAttribute(ATTRITION_TAG, this.attrition);
            if (this.student != null) {
                xw.writeAttribute(STUDENT_TAG, this.student);
            }
            if (this.teacher != null) {
                xw.writeAttribute(TEACHER_TAG, this.teacher);
            }
            if (this.destination != null) {
                xw.writeLocationAttribute(DESTINATION_TAG, this.destination);
            }
            if (this.tradeRoute != null) {
                xw.writeAttribute(TRADE_ROUTE_TAG, this.tradeRoute);
                xw.writeAttribute(CURRENT_STOP_TAG, this.currentStop);
            }
        } else if (this.getType().canCarryGoods()) {
            xw.writeAttribute(VISIBLE_GOODS_COUNT_TAG, this.getVisibleGoodsCount());
        }
    }

    @Override
    protected void writeChildren(FreeColXMLWriter xw) throws XMLStreamException {
        if (xw.validFor(this.getOwner())) {
            super.writeChildren(xw);
            if (this.workImprovement != null) {
                this.workImprovement.toXML(xw);
            }
        }
    }

    @Override
    protected void readAttributes(FreeColXMLReader xr) throws XMLStreamException {
        super.readAttributes(xr);
        Specification spec = this.getSpecification();
        Game game = this.getGame();
        WorkLocation oldWorkLocation = this.getWorkLocation();
        this.name = xr.getAttribute(NAME_TAG, null);
        Player oldOwner = this.owner;
        this.owner = xr.findFreeColGameObject(game, OWNER_TAG, Player.class, null, true);
        this.type = xr.getType(spec, UNIT_TYPE_TAG, UnitType.class, null);
        this.state = xr.getAttribute(STATE_TAG, UnitState.class, UnitState.ACTIVE);
        this.role = xr.getType(spec, ROLE_TAG, Role.class, spec.getDefaultRole());
        this.roleCount = xr.getAttribute(ROLE_COUNT_TAG, this.role.getMaximumCount());
        this.setLocationNoUpdate(xr.getLocationAttribute(game, LOCATION_TAG, true));
        this.entryLocation = xr.getLocationAttribute(game, ENTRY_LOCATION_TAG, true);
        this.movesLeft = xr.getAttribute(MOVES_LEFT_TAG, 0);
        this.workLeft = xr.getAttribute(WORK_LEFT_TAG, 0);
        this.attrition = xr.getAttribute(ATTRITION_TAG, 0);
        this.nationality = xr.getAttribute(NATIONALITY_TAG, null);
        this.ethnicity = xr.getAttribute(ETHNICITY_TAG, null);
        this.turnsOfTraining = xr.getAttribute(TURNS_OF_TRAINING_TAG, 0);
        this.hitPoints = xr.getAttribute(HIT_POINTS_TAG, -1);
        this.teacher = xr.makeFreeColObject(game, TEACHER_TAG, Unit.class, false);
        this.student = xr.makeFreeColObject(game, STUDENT_TAG, Unit.class, false);
        this.setHomeIndianSettlement(xr.makeFreeColObject(game, INDIAN_SETTLEMENT_TAG, IndianSettlement.class, false));
        this.treasureAmount = xr.getAttribute(TREASURE_AMOUNT_TAG, 0);
        this.destination = xr.getLocationAttribute(game, DESTINATION_TAG, true);
        this.tradeRoute = xr.findFreeColGameObject(game, TRADE_ROUTE_TAG, TradeRoute.class, null, false);
        this.currentStop = this.tradeRoute == null ? -1 : xr.getAttribute(CURRENT_STOP_TAG, 0);
        this.experienceType = xr.getType(spec, EXPERIENCE_TYPE_TAG, GoodsType.class, null);
        if (this.experienceType == null && this.workType != null) {
            this.experienceType = this.workType;
        }
        this.experience = xr.getAttribute(EXPERIENCE_TAG, 0);
        this.visibleGoodsCount = xr.getAttribute(VISIBLE_GOODS_COUNT_TAG, -1);
        this.setWorkType(xr.getType(spec, WORK_TYPE_TAG, GoodsType.class, null));
        WorkLocation wl = this.getWorkLocation();
        if (wl != null && wl != oldWorkLocation) {
            wl.updateProductionType();
        }
        if (xr.shouldIntern()) {
            game.checkOwners(this, oldOwner);
        }
    }

    @Override
    protected void readChildren(FreeColXMLReader xr) throws XMLStreamException {
        if (this.getGoodsContainer() != null) {
            this.getGoodsContainer().removeAll();
        }
        this.workImprovement = null;
        super.readChildren(xr);
    }

    @Override
    protected void readChild(FreeColXMLReader xr) throws XMLStreamException {
        Game game = this.getGame();
        String tag = xr.getLocalName();
        if (OLD_EQUIPMENT_TAG.equals(tag)) {
            xr.swallowTag(OLD_EQUIPMENT_TAG);
        } else if ("tileImprovement".equals(tag) || OLD_TILE_IMPROVEMENT_TAG.equals(tag)) {
            this.workImprovement = xr.readFreeColObject(game, TileImprovement.class);
        } else {
            super.readChild(xr);
        }
    }

    @Override
    public String getXMLTagName() {
        return TAG;
    }

    @Override
    public String toString() {
        return this.toString("");
    }

    public String toString(String prefix) {
        StringBuilder sb = new StringBuilder(64);
        sb.append('[').append(prefix).append(this.getId());
        if (!this.isInitialized()) {
            sb.append(" uninitialized");
        } else if (this.isDisposed()) {
            sb.append(" disposed");
        } else if (this.owner == null) {
            sb.append(" unowned");
        } else if (this.getType() == null) {
            sb.append(" untyped");
        } else {
            sb.append(' ').append(StringUtils.lastPart(this.owner.getNationId(), ".")).append(' ').append(this.getType().getSuffix());
            if (!this.hasDefaultRole()) {
                sb.append('-').append(this.getRoleSuffix());
                int count = this.getRoleCount();
                if (count > 1) {
                    sb.append('.').append(count);
                }
            }
            sb.append(' ').append(this.getMovesAsString());
        }
        sb.append(']');
        return sb.toString();
    }

    public static enum MoveType {
        MOVE(null, true),
        MOVE_HIGH_SEAS(null, true),
        EXPLORE_LOST_CITY_RUMOUR(null, true),
        ATTACK_UNIT(null, false),
        ATTACK_SETTLEMENT(null, false),
        EMBARK(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_FREE_COLONIST(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_SCOUT(null, false),
        ENTER_INDIAN_SETTLEMENT_WITH_MISSIONARY(null, false),
        ENTER_FOREIGN_COLONY_WITH_SCOUT(null, false),
        ENTER_SETTLEMENT_WITH_CARRIER_AND_GOODS(null, false),
        MOVE_NO_MOVES("Attempt to move without moves left"),
        MOVE_NO_ACCESS_LAND("Attempt to move a naval unit onto land"),
        MOVE_NO_ACCESS_BEACHED("Attempt to move onto foreign beached ship"),
        MOVE_NO_ACCESS_EMBARK("Attempt to embark onto absent or foreign carrier"),
        MOVE_NO_ACCESS_FULL("Attempt to embark onto full carrier"),
        MOVE_NO_ACCESS_GOODS("Attempt to trade without goods"),
        MOVE_NO_ACCESS_CONTACT("Attempt to interact with natives before contact"),
        MOVE_NO_ACCESS_MISSION_BAN("Attempt to use missionary at banned settlement"),
        MOVE_NO_ACCESS_SETTLEMENT("Attempt to move into foreign settlement"),
        MOVE_NO_ACCESS_SKILL("Attempt to learn skill with incapable unit"),
        MOVE_NO_ACCESS_TRADE("Attempt to trade without authority"),
        MOVE_NO_ACCESS_WAR("Attempt to trade while at war"),
        MOVE_NO_ACCESS_WATER("Attempt to move into a settlement by water"),
        MOVE_NO_ATTACK_CIVILIAN("Attempt to attack with civilian unit"),
        MOVE_NO_ATTACK_MARINE("Attempt to attack from on board ship"),
        MOVE_NO_EUROPE("Attempt to move to Europe by incapable unit"),
        MOVE_NO_REPAIR("Attempt to move a unit that is under repair"),
        MOVE_NO_TILE("Attempt to move when not on a tile"),
        MOVE_ILLEGAL("Unspecified illegal move");

        private final String reason;
        private final boolean progress;

        private MoveType(String reason) {
            this.reason = reason;
            this.progress = false;
        }

        private MoveType(String reason, boolean progress) {
            this.reason = reason;
            this.progress = progress;
        }

        public boolean isLegal() {
            return this.reason == null;
        }

        public String whyIllegal() {
            return this.reason == null ? "(none)" : this.reason;
        }

        public boolean isProgress() {
            return this.progress;
        }

        public boolean isAttack() {
            return this == ATTACK_UNIT || this == ATTACK_SETTLEMENT;
        }
    }

    public static enum UnitLabelType {
        PLAIN,
        NATIONAL,
        FULL;

    }

    private static enum PortMode {
        LAKE,
        NO_HIGH_SEAS,
        BLOCKED,
        LAND;

    }

    public static enum UnitState {
        ACTIVE,
        FORTIFIED,
        SENTRY,
        IN_COLONY,
        IMPROVING,
        FORTIFYING,
        SKIPPED;


        public String getKey() {
            return "unitState." + StringUtils.getEnumKey(this);
        }
    }

    private static class ClosestSettlementGoalDecider
    implements GoalDecider {
        private Tile exclude;
        private boolean coastal;
        private int bestValue;
        private PathNode best;

        public ClosestSettlementGoalDecider(Tile exclude, boolean coastal) {
            this.exclude = exclude;
            this.coastal = coastal;
            this.bestValue = Integer.MAX_VALUE;
            this.best = null;
        }

        @Override
        public PathNode getGoal() {
            return this.best;
        }

        @Override
        public boolean hasSubGoals() {
            return true;
        }

        @Override
        public boolean check(Unit u, PathNode path) {
            int value;
            Tile t = path.getTile();
            if (t == null || t == this.exclude) {
                return false;
            }
            Settlement settlement = t.getSettlement();
            if (settlement != null && u.getOwner().owns(settlement) && (!this.coastal || settlement.isConnectedPort()) && (value = path.getTotalTurns()) < this.bestValue) {
                this.bestValue = value;
                this.best = path;
                return true;
            }
            return false;
        }
    }
}

