/*
 * Decompiled with CFR 0.152.
 */
package net.sf.freecol.common.networking;

import javax.xml.stream.XMLStreamException;
import net.sf.freecol.client.FreeColClient;
import net.sf.freecol.common.io.FreeColXMLReader;
import net.sf.freecol.common.model.Game;
import net.sf.freecol.common.model.Player;
import net.sf.freecol.common.model.Tile;
import net.sf.freecol.common.model.Unit;
import net.sf.freecol.common.networking.AttributeMessage;
import net.sf.freecol.common.networking.ChangeSet;
import net.sf.freecol.common.networking.Message;
import net.sf.freecol.server.FreeColServer;
import net.sf.freecol.server.ai.AIPlayer;
import net.sf.freecol.server.model.ServerPlayer;

public class NewLandNameMessage
extends AttributeMessage {
    public static final String TAG = "newLandName";
    private static final String NEW_LAND_NAME_TAG = "newLandName";
    private static final String UNIT_TAG = "unit";

    public NewLandNameMessage(Unit unit, String newLandName) {
        super("newLandName", UNIT_TAG, unit.getId(), "newLandName", newLandName);
    }

    public NewLandNameMessage(Game game, FreeColXMLReader xr) throws XMLStreamException {
        super("newLandName", xr, UNIT_TAG, "newLandName");
    }

    @Override
    public Message.MessagePriority getPriority() {
        return Message.MessagePriority.LATE;
    }

    @Override
    public void aiHandler(FreeColServer freeColServer, AIPlayer aiPlayer) {
        Unit unit = this.getUnit(aiPlayer.getPlayer());
        String name = this.getNewLandName();
        aiPlayer.newLandNameHandler(unit, name);
    }

    @Override
    public void clientHandler(FreeColClient freeColClient) {
        Unit unit = this.getUnit(freeColClient.getMyPlayer());
        String defaultName = this.getNewLandName();
        if (defaultName == null || !unit.hasTile()) {
            return;
        }
        this.igc(freeColClient).newLandNameHandler(unit, defaultName);
        this.clientGeneric(freeColClient);
    }

    @Override
    public ChangeSet serverHandler(FreeColServer freeColServer, ServerPlayer serverPlayer) {
        Unit unit;
        try {
            unit = this.getUnit(serverPlayer);
        }
        catch (Exception e) {
            return serverPlayer.clientError(e.getMessage());
        }
        Tile tile = unit.getTile();
        if (tile == null) {
            return serverPlayer.clientError("Unit is not on the map: " + unit.getId());
        }
        if (!tile.isLand()) {
            return serverPlayer.clientError("Unit is not in the new world: " + unit.getId());
        }
        String newLandName = this.getNewLandName();
        if (newLandName == null || newLandName.isEmpty()) {
            return serverPlayer.clientError("Empty new land name");
        }
        return this.igc(freeColServer).setNewLandName(serverPlayer, unit, newLandName);
    }

    public Unit getUnit(Player player) {
        return player.getOurFreeColGameObject(this.getStringAttribute(UNIT_TAG), Unit.class);
    }

    public String getNewLandName() {
        return this.getStringAttribute("newLandName");
    }
}

