/*
 * Decompiled with CFR 0.152.
 */
package sun.jvm.hotspot.runtime.ppc64;

import sun.jvm.hotspot.debugger.Address;
import sun.jvm.hotspot.debugger.ppc64.PPC64ThreadContext;
import sun.jvm.hotspot.runtime.Frame;
import sun.jvm.hotspot.runtime.JavaThread;
import sun.jvm.hotspot.runtime.RegisterMap;
import sun.jvm.hotspot.runtime.VM;
import sun.jvm.hotspot.runtime.ppc64.PPC64Frame;

public class PPC64CurrentFrameGuess {
    private PPC64ThreadContext context;
    private JavaThread thread;
    private Address spFound;
    private Address fpFound;
    private Address pcFound;
    private static final boolean DEBUG = System.getProperty("sun.jvm.hotspot.runtime.ppc64.PPC64Frame.DEBUG") != null;

    public PPC64CurrentFrameGuess(PPC64ThreadContext context, JavaThread thread) {
        this.context = context;
        this.thread = thread;
    }

    public boolean run(long regionInBytesToSearch) {
        Address sp = this.context.getRegisterAsAddress(30);
        Address pc = this.context.getRegisterAsAddress(32);
        if (sp == null) {
            if (this.thread.getLastJavaSP() != null) {
                Address javaSP = this.thread.getLastJavaSP();
                Address javaFP = javaSP.getAddressAt(0L);
                this.setValues(javaSP, javaFP, null);
                return true;
            }
            return false;
        }
        Address fp = sp.getAddressAt(0L);
        this.setValues(null, null, null);
        VM vm = VM.getVM();
        if (vm.isJavaPCDbg(pc)) {
            if (vm.isClientCompiler()) {
                if (DEBUG) {
                    System.out.println("CurrentFrameGuess: choosing compiler frame: sp = " + sp + ", fp = " + fp + ", pc = " + pc);
                }
                this.setValues(sp, fp, pc);
                return true;
            }
            if (vm.getInterpreter().contains(pc)) {
                if (DEBUG) {
                    System.out.println("CurrentFrameGuess: choosing interpreter frame: sp = " + sp + ", fp = " + fp + ", pc = " + pc);
                }
                this.setValues(sp, fp, pc);
                return true;
            }
            for (long offset = 0L; offset < regionInBytesToSearch; offset += vm.getAddressSize()) {
                try {
                    Address curSP = sp.addOffsetTo(offset);
                    fp = curSP.getAddressAt(0L);
                    RegisterMap map = this.thread.newRegisterMap(false);
                    for (Frame frame = new PPC64Frame(curSP, fp, pc); frame != null; frame = frame.sender(map)) {
                        if (!frame.isEntryFrame() || !frame.entryFrameIsFirst()) continue;
                        if (DEBUG) {
                            System.out.println("CurrentFrameGuess: Choosing sp = " + curSP + ", pc = " + pc);
                        }
                        this.setValues(curSP, fp, pc);
                        return true;
                    }
                    continue;
                }
                catch (Exception e) {
                    if (!DEBUG) continue;
                    System.out.println("CurrentFrameGuess: Exception " + e + " at offset " + offset);
                }
            }
            return false;
        }
        if (this.thread.getLastJavaSP() == null) {
            if (DEBUG) {
                System.out.println("CurrentFrameGuess: last java sp is null");
            }
            return false;
        }
        Address javaSP = this.thread.getLastJavaSP();
        Address javaFP = javaSP.getAddressAt(0L);
        Address javaPC = this.thread.getLastJavaPC();
        if (DEBUG) {
            System.out.println("CurrentFrameGuess: choosing last Java frame: sp = " + javaSP + ", fp = " + javaFP + ", pc = " + javaPC);
        }
        this.setValues(javaSP, javaFP, javaPC);
        return true;
    }

    public Address getSP() {
        return this.spFound;
    }

    public Address getFP() {
        return this.fpFound;
    }

    public Address getPC() {
        return this.pcFound;
    }

    private void setValues(Address sp, Address fp, Address pc) {
        this.spFound = sp;
        this.fpFound = fp;
        this.pcFound = pc;
    }
}

