/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jasperreports.engine.export;

import java.awt.Color;
import java.awt.Dimension;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.io.Writer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.sf.jasperreports.engine.JRAbstractExporter;
import net.sf.jasperreports.engine.JRBox;
import net.sf.jasperreports.engine.JRException;
import net.sf.jasperreports.engine.JRExporterParameter;
import net.sf.jasperreports.engine.JRFont;
import net.sf.jasperreports.engine.JRImageRenderer;
import net.sf.jasperreports.engine.JRPrintElement;
import net.sf.jasperreports.engine.JRPrintEllipse;
import net.sf.jasperreports.engine.JRPrintGraphicElement;
import net.sf.jasperreports.engine.JRPrintImage;
import net.sf.jasperreports.engine.JRPrintLine;
import net.sf.jasperreports.engine.JRPrintPage;
import net.sf.jasperreports.engine.JRPrintRectangle;
import net.sf.jasperreports.engine.JRPrintText;
import net.sf.jasperreports.engine.JRRenderable;
import net.sf.jasperreports.engine.JRReportFont;
import net.sf.jasperreports.engine.JRRuntimeException;
import net.sf.jasperreports.engine.JRWrappingSvgRenderer;
import net.sf.jasperreports.engine.export.JRExportProgressMonitor;
import net.sf.jasperreports.engine.export.JRXmlExporterParameter;
import net.sf.jasperreports.engine.xml.JRXmlConstants;
import org.w3c.tools.codec.Base64Encoder;

public class JRXmlExporter
extends JRAbstractExporter {
    protected Writer writer = null;
    protected String encoding = null;
    protected JRExportProgressMonitor progressMonitor = null;
    protected Map rendererToImagePathMap = null;
    protected Map imageNameToImageDataMap = null;
    protected Map fontsMap = new HashMap();
    protected String dtdLocation = null;
    protected boolean isEmbeddingImages = true;
    protected File destFile = null;
    protected File imagesDir = null;
    protected static final int colorMask = Integer.parseInt("FFFFFF", 16);

    public void exportReport() throws JRException {
        StringBuffer sb;
        this.progressMonitor = (JRExportProgressMonitor)this.parameters.get(JRExporterParameter.PROGRESS_MONITOR);
        this.setOffset();
        this.setInput();
        this.setPageRange();
        this.dtdLocation = (String)this.parameters.get(JRXmlExporterParameter.DTD_LOCATION);
        if (this.dtdLocation == null) {
            this.dtdLocation = "http://jasperreports.sourceforge.net/dtds/jasperprint.dtd";
        }
        this.encoding = (String)this.parameters.get(JRExporterParameter.CHARACTER_ENCODING);
        if (this.encoding == null) {
            this.encoding = "UTF-8";
        }
        if ((sb = (StringBuffer)this.parameters.get(JRExporterParameter.OUTPUT_STRING_BUFFER)) != null) {
            StringBuffer buffer = this.exportReportToBuffer();
            sb.append(buffer.toString());
        } else {
            Writer outWriter = (Writer)this.parameters.get(JRExporterParameter.OUTPUT_WRITER);
            if (outWriter != null) {
                try {
                    this.writer = outWriter;
                    this.exportReportToStream();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to writer : " + this.jasperPrint.getName(), e);
                }
            } else {
                OutputStream os = (OutputStream)this.parameters.get(JRExporterParameter.OUTPUT_STREAM);
                if (os != null) {
                    try {
                        this.writer = new OutputStreamWriter(os, this.encoding);
                        this.exportReportToStream();
                    }
                    catch (Exception e) {
                        throw new JRException("Error writing to OutputStream : " + this.jasperPrint.getName(), e);
                    }
                } else {
                    this.destFile = (File)this.parameters.get(JRExporterParameter.OUTPUT_FILE);
                    if (this.destFile == null) {
                        String fileName = (String)this.parameters.get(JRExporterParameter.OUTPUT_FILE_NAME);
                        if (fileName != null) {
                            this.destFile = new File(fileName);
                        } else {
                            throw new JRException("No output specified for the exporter.");
                        }
                    }
                    this.imagesDir = new File(this.destFile.getParent(), this.destFile.getName() + "_files");
                    Boolean isEmbeddingImagesParameter = (Boolean)this.parameters.get(JRXmlExporterParameter.IS_EMBEDDING_IMAGES);
                    if (isEmbeddingImagesParameter == null) {
                        isEmbeddingImagesParameter = Boolean.TRUE;
                    }
                    this.isEmbeddingImages = isEmbeddingImagesParameter;
                    this.exportReportToFile();
                }
            }
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void exportReportToFile() throws JRException {
        block16: {
            this.rendererToImagePathMap = new HashMap();
            this.imageNameToImageDataMap = new HashMap();
            try {
                try {
                    FileOutputStream fileOutputStream = new FileOutputStream(this.destFile);
                    this.writer = new BufferedWriter(new OutputStreamWriter((OutputStream)fileOutputStream, this.encoding));
                    this.exportReportToStream();
                }
                catch (IOException e) {
                    throw new JRException("Error writing to file : " + this.destFile, e);
                }
                Object var3_3 = null;
                if (this.writer == null) break block16;
            }
            catch (Throwable throwable) {
                Object var3_4 = null;
                if (this.writer == null) throw throwable;
                try {
                    this.writer.close();
                    throw throwable;
                }
                catch (IOException e) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e) {}
            this.writer.close();
        }
        if (this.isEmbeddingImages) return;
        Set imageNames = this.imageNameToImageDataMap.keySet();
        if (imageNames == null) return;
        if (imageNames.size() <= 0) return;
        if (!this.imagesDir.exists()) {
            this.imagesDir.mkdir();
        }
        Iterator it = imageNames.iterator();
        while (it.hasNext()) {
            IOException e3;
            Object var9_11;
            String imageName = (String)it.next();
            byte[] imageData = (byte[])this.imageNameToImageDataMap.get(imageName);
            File imageFile = new File(this.imagesDir, imageName);
            FileOutputStream fos = null;
            try {
                try {
                    fos = new FileOutputStream(imageFile);
                    ((OutputStream)fos).write(imageData, 0, imageData.length);
                }
                catch (IOException e2) {
                    throw new JRException("Error writing to image file : " + imageFile, e2);
                }
                var9_11 = null;
                if (fos == null) continue;
                {
                }
            }
            catch (Throwable throwable) {
                var9_11 = null;
                if (fos == null) throw throwable;
                try {
                    ((OutputStream)fos).close();
                    throw throwable;
                }
                catch (IOException e3) {
                    // empty catch block
                }
                throw throwable;
            }
            try {}
            catch (IOException e3) {}
            ((OutputStream)fos).close();
        }
    }

    protected StringBuffer exportReportToBuffer() throws JRException {
        StringWriter buffer = new StringWriter();
        this.writer = buffer;
        try {
            this.exportReportToStream();
        }
        catch (IOException e) {
            throw new JRException("Error while exporting report to buffer", e);
        }
        return buffer.getBuffer();
    }

    protected void exportReportToStream() throws JRException, IOException {
        List pages;
        this.writer.write("<?xml version=\"1.0\" encoding=\"" + this.encoding + "\"?>\n");
        this.writer.write("<!DOCTYPE jasperPrint PUBLIC \"-//JasperReports//DTD Report Design//EN\" \"");
        this.writer.write(this.dtdLocation);
        this.writer.write("\">\n");
        this.writer.write("\n");
        this.writer.write("<jasperPrint name=\"");
        this.writer.write(this.jasperPrint.getName());
        this.writer.write("\"");
        this.writer.write(" pageWidth=\"");
        this.writer.write(String.valueOf(this.jasperPrint.getPageWidth()));
        this.writer.write("\"");
        this.writer.write(" pageHeight=\"");
        this.writer.write(String.valueOf(this.jasperPrint.getPageHeight()));
        this.writer.write("\"");
        if (this.jasperPrint.getOrientation() != 1) {
            this.writer.write(" orientation=\"");
            this.writer.write((String)JRXmlConstants.getOrientationMap().get(new Byte(this.jasperPrint.getOrientation())));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        JRReportFont[] fonts = this.jasperPrint.getFonts();
        if (fonts != null && fonts.length > 0) {
            for (int i = 0; i < fonts.length; ++i) {
                this.fontsMap.put(fonts[i].getName(), fonts[i]);
                this.exportReportFont(fonts[i]);
            }
        }
        if ((pages = this.jasperPrint.getPages()) != null && pages.size() > 0) {
            JRPrintPage page = null;
            for (int i = this.startPageIndex; i <= this.endPageIndex; ++i) {
                if (Thread.currentThread().isInterrupted()) {
                    throw new JRException("Current thread interrupted.");
                }
                page = (JRPrintPage)pages.get(i);
                this.exportPage(page);
            }
        }
        this.writer.write("</jasperPrint>\n");
        this.writer.flush();
    }

    protected void exportReportFont(JRReportFont font) throws IOException {
        this.writer.write("\t<reportFont");
        this.writer.write(" name=\"");
        this.writer.write(font.getName());
        this.writer.write("\"");
        this.writer.write(" isDefault=\"");
        this.writer.write(String.valueOf(font.isDefault()));
        this.writer.write("\"");
        this.writer.write(" fontName=\"");
        this.writer.write(font.getFontName());
        this.writer.write("\"");
        this.writer.write(" size=\"");
        this.writer.write(String.valueOf(font.getSize()));
        this.writer.write("\"");
        this.writer.write(" isBold=\"");
        this.writer.write(String.valueOf(font.isBold()));
        this.writer.write("\"");
        this.writer.write(" isItalic=\"");
        this.writer.write(String.valueOf(font.isItalic()));
        this.writer.write("\"");
        this.writer.write(" isUnderline=\"");
        this.writer.write(String.valueOf(font.isUnderline()));
        this.writer.write("\"");
        this.writer.write(" isStrikeThrough=\"");
        this.writer.write(String.valueOf(font.isStrikeThrough()));
        this.writer.write("\"");
        this.writer.write(" pdfFontName=\"");
        this.writer.write(font.getPdfFontName());
        this.writer.write("\"");
        this.writer.write(" pdfEncoding=\"");
        this.writer.write(font.getPdfEncoding());
        this.writer.write("\"");
        this.writer.write(" isPdfEmbedded=\"");
        this.writer.write(String.valueOf(font.isPdfEmbedded()));
        this.writer.write("\"");
        this.writer.write("/>\n");
    }

    protected void exportPage(JRPrintPage page) throws JRException, IOException {
        this.writer.write("\t<page>\n");
        JRPrintElement element = null;
        List elements = page.getElements();
        if (elements != null && elements.size() > 0) {
            Iterator it = elements.iterator();
            while (it.hasNext()) {
                element = (JRPrintElement)it.next();
                if (element instanceof JRPrintLine) {
                    this.exportLine((JRPrintLine)element);
                    continue;
                }
                if (element instanceof JRPrintRectangle) {
                    this.exportRectangle((JRPrintRectangle)element);
                    continue;
                }
                if (element instanceof JRPrintEllipse) {
                    this.exportEllipse((JRPrintEllipse)element);
                    continue;
                }
                if (element instanceof JRPrintImage) {
                    this.exportImage((JRPrintImage)element);
                    continue;
                }
                if (!(element instanceof JRPrintText)) continue;
                this.exportText((JRPrintText)element);
            }
        }
        this.writer.write("\t</page>\n");
        if (this.progressMonitor != null) {
            this.progressMonitor.afterPageExport();
        }
    }

    protected void exportLine(JRPrintLine line) throws IOException {
        this.writer.write("\t\t<line");
        if (line.getDirection() != 1) {
            this.writer.write(" direction=\"");
            this.writer.write((String)JRXmlConstants.getDirectionMap().get(new Byte(line.getDirection())));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        this.exportReportElement(line);
        this.exportGraphicElement(line);
        this.writer.write("\t\t</line>\n");
    }

    protected void exportReportElement(JRPrintElement element) throws IOException {
        this.writer.write("\t\t\t<reportElement");
        if (element instanceof JRPrintLine && element.getMode() != 1 || element instanceof JRPrintRectangle && element.getMode() != 1 || element instanceof JRPrintEllipse && element.getMode() != 1 || element instanceof JRPrintImage && element.getMode() != 2 || element instanceof JRPrintText && element.getMode() != 2) {
            this.writer.write(" mode=\"");
            this.writer.write((String)JRXmlConstants.getModeMap().get(new Byte(element.getMode())));
            this.writer.write("\"");
        }
        this.writer.write(" x=\"");
        this.writer.write(String.valueOf(element.getX() + this.globalOffsetX));
        this.writer.write("\"");
        this.writer.write(" y=\"");
        this.writer.write(String.valueOf(element.getY() + this.globalOffsetY));
        this.writer.write("\"");
        this.writer.write(" width=\"");
        this.writer.write(String.valueOf(element.getWidth()));
        this.writer.write("\"");
        this.writer.write(" height=\"");
        this.writer.write(String.valueOf(element.getHeight()));
        this.writer.write("\"");
        if (element.getForecolor().getRGB() != Color.black.getRGB()) {
            this.writer.write(" forecolor=\"#");
            this.writer.write(this.getHexaColor(element.getForecolor()));
            this.writer.write("\"");
        }
        if (element.getBackcolor().getRGB() != Color.white.getRGB()) {
            this.writer.write(" backcolor=\"#");
            this.writer.write(this.getHexaColor(element.getBackcolor()));
            this.writer.write("\"");
        }
        this.writer.write("/>\n");
    }

    protected void exportGraphicElement(JRPrintGraphicElement element) throws IOException {
        this.writer.write("\t\t\t<graphicElement");
        if (element instanceof JRPrintLine && element.getPen() != 1 || element instanceof JRPrintRectangle && element.getPen() != 1 || element instanceof JRPrintEllipse && element.getPen() != 1 || element instanceof JRPrintImage && element.getPen() != 0) {
            this.writer.write(" pen=\"");
            this.writer.write((String)JRXmlConstants.getPenMap().get(new Byte(element.getPen())));
            this.writer.write("\"");
        }
        if (element.getFill() != 1) {
            this.writer.write(" fill=\"");
            this.writer.write((String)JRXmlConstants.getFillMap().get(new Byte(element.getFill())));
            this.writer.write("\"");
        }
        this.writer.write("/>\n");
    }

    protected void exportRectangle(JRPrintRectangle rectangle) throws IOException {
        this.writer.write("\t\t<rectangle");
        if (rectangle.getRadius() != 0) {
            this.writer.write(" radius=\"");
            this.writer.write(String.valueOf(rectangle.getRadius()));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        this.exportReportElement(rectangle);
        this.exportGraphicElement(rectangle);
        this.writer.write("\t\t</rectangle>\n");
    }

    protected void exportEllipse(JRPrintEllipse ellipse) throws IOException {
        this.writer.write("\t\t\t<ellipse>\n");
        this.exportReportElement(ellipse);
        this.exportGraphicElement(ellipse);
        this.writer.write("\t\t</ellipse>\n");
    }

    protected void exportImage(JRPrintImage image) throws JRException, IOException {
        this.writer.write("\t\t<image");
        if (image.getScaleImage() != 3) {
            this.writer.write(" scaleImage=\"");
            this.writer.write((String)JRXmlConstants.getScaleImageMap().get(new Byte(image.getScaleImage())));
            this.writer.write("\"");
        }
        if (image.getHorizontalAlignment() != 1) {
            this.writer.write(" hAlign=\"");
            this.writer.write((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(image.getHorizontalAlignment())));
            this.writer.write("\"");
        }
        if (image.getVerticalAlignment() != 1) {
            this.writer.write(" vAlign=\"");
            this.writer.write((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(image.getVerticalAlignment())));
            this.writer.write("\"");
        }
        if (image.isLazy()) {
            this.writer.write(" isLazy=\"");
            this.writer.write(String.valueOf(image.isLazy()));
            this.writer.write("\"");
        }
        if (image.getOnErrorType() != 1) {
            this.writer.write(" onErrorType=\"");
            this.writer.write((String)JRXmlConstants.getOnErrorTypeMap().get(new Byte(image.getOnErrorType())));
            this.writer.write("\"");
        }
        if (image.getHyperlinkType() != 1) {
            this.writer.write(" hyperlinkType=\"");
            this.writer.write((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(image.getHyperlinkType())));
            this.writer.write("\"");
        }
        if (image.getHyperlinkTarget() != 1) {
            this.writer.write(" hyperlinkTarget=\"");
            this.writer.write((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(image.getHyperlinkTarget())));
            this.writer.write("\"");
        }
        if (image.getAnchorName() != null) {
            this.writer.write(" anchorName=\"");
            this.writer.write(image.getAnchorName());
            this.writer.write("\"");
        }
        if (image.getHyperlinkReference() != null) {
            this.writer.write(" hyperlinkReference=\"");
            this.writer.write(image.getHyperlinkReference());
            this.writer.write("\"");
        }
        if (image.getHyperlinkAnchor() != null) {
            this.writer.write(" hyperlinkAnchor=\"");
            this.writer.write(image.getHyperlinkAnchor());
            this.writer.write("\"");
        }
        if (image.getHyperlinkPage() != null) {
            this.writer.write(" hyperlinkPage=\"");
            this.writer.write(String.valueOf(image.getHyperlinkPage()));
            this.writer.write("\"");
        }
        if (image.getBookmarkLevel() != 0) {
            this.writer.write(" bookmarkLevel=\"");
            this.writer.write(String.valueOf(image.getBookmarkLevel()));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        this.exportReportElement(image);
        this.exportBox(image.getBox());
        this.exportGraphicElement(image);
        JRRenderable renderer = image.getRenderer();
        if (renderer != null) {
            this.writer.write("\t\t\t<imageSource");
            if (this.isEmbeddingImages && !image.isLazy()) {
                this.writer.write(" isEmbedded=\"");
                this.writer.write(String.valueOf(this.isEmbeddingImages && !image.isLazy()));
                this.writer.write("\"");
            }
            this.writer.write("><![CDATA[");
            String imageSource = "";
            if (renderer.getType() == 1) {
                renderer = new JRWrappingSvgRenderer(renderer, new Dimension(image.getWidth(), image.getHeight()), image.getBackcolor());
            }
            if (this.isEmbeddingImages && !image.isLazy()) {
                try {
                    ByteArrayInputStream bais = new ByteArrayInputStream(renderer.getImageData());
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    Base64Encoder encoder = new Base64Encoder(bais, baos);
                    encoder.process();
                    imageSource = new String(baos.toByteArray(), "UTF-8");
                }
                catch (IOException e) {
                    throw new JRException("Error embedding image into XML.", e);
                }
            } else if (renderer.getType() == 0 && this.rendererToImagePathMap.containsKey(renderer)) {
                imageSource = (String)this.rendererToImagePathMap.get(renderer);
            } else {
                if (image.isLazy()) {
                    imageSource = ((JRImageRenderer)renderer).getImageLocation();
                } else {
                    imageSource = "img_" + String.valueOf(this.imageNameToImageDataMap.size());
                    this.imageNameToImageDataMap.put(imageSource, renderer.getImageData());
                    imageSource = new File(this.imagesDir, imageSource).getPath();
                }
                this.rendererToImagePathMap.put(renderer, imageSource);
            }
            this.writer.write(imageSource);
            this.writer.write("]]></imageSource>\n");
        }
        this.writer.write("\t\t</image>\n");
    }

    protected void exportText(JRPrintText text) throws IOException {
        this.writer.write("\t\t<text");
        if (text.getHorizontalAlignment() != 1) {
            this.writer.write(" textAlignment=\"");
            this.writer.write((String)JRXmlConstants.getHorizontalAlignMap().get(new Byte(text.getHorizontalAlignment())));
            this.writer.write("\"");
        }
        if (text.getVerticalAlignment() != 1) {
            this.writer.write(" verticalAlignment=\"");
            this.writer.write((String)JRXmlConstants.getVerticalAlignMap().get(new Byte(text.getVerticalAlignment())));
            this.writer.write("\"");
            this.writer.write(" textHeight=\"");
            this.writer.write(String.valueOf(text.getTextHeight()));
            this.writer.write("\"");
        }
        if (text.getRotation() != 0) {
            this.writer.write(" rotation=\"");
            this.writer.write((String)JRXmlConstants.getRotationMap().get(new Byte(text.getRotation())));
            this.writer.write("\"");
        }
        if (text.getRunDirection() != 0) {
            this.writer.write(" runDirection=\"");
            this.writer.write((String)JRXmlConstants.getRunDirectionMap().get(new Byte(text.getRunDirection())));
            this.writer.write("\"");
        }
        if (text.getLineSpacing() != 0) {
            this.writer.write(" lineSpacing=\"");
            this.writer.write((String)JRXmlConstants.getLineSpacingMap().get(new Byte(text.getLineSpacing())));
            this.writer.write("\"");
        }
        if (text.isStyledText()) {
            this.writer.write(" isStyledText=\"");
            this.writer.write(String.valueOf(text.isStyledText()));
            this.writer.write("\"");
        }
        this.writer.write(" lineSpacingFactor=\"");
        this.writer.write(String.valueOf(text.getLineSpacingFactor()));
        this.writer.write("\"");
        this.writer.write(" leadingOffset=\"");
        this.writer.write(String.valueOf(text.getLeadingOffset()));
        this.writer.write("\"");
        if (text.getHyperlinkType() != 1) {
            this.writer.write(" hyperlinkType=\"");
            this.writer.write((String)JRXmlConstants.getHyperlinkTypeMap().get(new Byte(text.getHyperlinkType())));
            this.writer.write("\"");
        }
        if (text.getHyperlinkTarget() != 1) {
            this.writer.write(" hyperlinkTarget=\"");
            this.writer.write((String)JRXmlConstants.getHyperlinkTargetMap().get(new Byte(text.getHyperlinkTarget())));
            this.writer.write("\"");
        }
        if (text.getAnchorName() != null) {
            this.writer.write(" anchorName=\"");
            this.writer.write(text.getAnchorName());
            this.writer.write("\"");
        }
        if (text.getHyperlinkReference() != null) {
            this.writer.write(" hyperlinkReference=\"");
            this.writer.write(text.getHyperlinkReference());
            this.writer.write("\"");
        }
        if (text.getHyperlinkAnchor() != null) {
            this.writer.write(" hyperlinkAnchor=\"");
            this.writer.write(text.getHyperlinkAnchor());
            this.writer.write("\"");
        }
        if (text.getHyperlinkPage() != null) {
            this.writer.write(" hyperlinkPage=\"");
            this.writer.write(String.valueOf(text.getHyperlinkPage()));
            this.writer.write("\"");
        }
        if (text.getBookmarkLevel() != 0) {
            this.writer.write(" bookmarkLevel=\"");
            this.writer.write(String.valueOf(text.getBookmarkLevel()));
            this.writer.write("\"");
        }
        this.writer.write(">\n");
        this.exportReportElement(text);
        this.exportBox(text.getBox());
        String font = this.exportFont(text.getFont());
        if (font != null) {
            this.writer.write("\t\t\t" + font + "\n");
        }
        if (text.getText() != null) {
            this.writer.write("\t\t\t<textContent><![CDATA[");
            this.writer.write(text.getText());
            this.writer.write("]]></textContent>\n");
        }
        this.writer.write("\t\t</text>\n");
    }

    private void exportBox(JRBox box) throws IOException {
        if (box != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (box.getBorder() != 0) {
                tmpBuffer.append(" border=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getBorderColor() != null) {
                tmpBuffer.append(" borderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getPadding() > 0) {
                tmpBuffer.append(" padding=\"");
                tmpBuffer.append(box.getPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorder() != null) {
                tmpBuffer.append(" topBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnTopBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopBorderColor() != null) {
                tmpBuffer.append(" topBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnTopBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnTopPadding() != null) {
                tmpBuffer.append(" topPadding=\"");
                tmpBuffer.append(box.getOwnTopPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorder() != null) {
                tmpBuffer.append(" leftBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnLeftBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftBorderColor() != null) {
                tmpBuffer.append(" leftBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnLeftBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnLeftPadding() != null) {
                tmpBuffer.append(" leftPadding=\"");
                tmpBuffer.append(box.getOwnLeftPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorder() != null) {
                tmpBuffer.append(" bottomBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnBottomBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomBorderColor() != null) {
                tmpBuffer.append(" bottomBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnBottomBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnBottomPadding() != null) {
                tmpBuffer.append(" bottomPadding=\"");
                tmpBuffer.append(box.getOwnBottomPadding());
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorder() != null) {
                tmpBuffer.append(" rightBorder=\"");
                tmpBuffer.append((String)JRXmlConstants.getPenMap().get(new Byte(box.getOwnRightBorder())));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightBorderColor() != null) {
                tmpBuffer.append(" rightBorderColor=\"#");
                tmpBuffer.append(this.getHexaColor(box.getOwnRightBorderColor()));
                tmpBuffer.append("\"");
            }
            if (box.getOwnRightPadding() != null) {
                tmpBuffer.append(" rightPadding=\"");
                tmpBuffer.append(box.getOwnRightPadding());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                this.writer.write("\t\t\t<box");
                this.writer.write(tmpBuffer.toString());
                this.writer.write("/>\n");
            }
        }
    }

    protected String exportFont(JRFont font) {
        String fontChunk = null;
        if (font != null) {
            StringBuffer tmpBuffer = new StringBuffer();
            if (font.getReportFont() != null) {
                JRFont baseFont = (JRFont)this.fontsMap.get(font.getReportFont().getName());
                if (baseFont != null) {
                    tmpBuffer.append(" reportFont=\"");
                    tmpBuffer.append(font.getReportFont().getName());
                    tmpBuffer.append("\"");
                } else {
                    throw new JRRuntimeException("Referenced report font not found : " + font.getReportFont().getName());
                }
            }
            if (font.getOwnFontName() != null) {
                tmpBuffer.append(" fontName=\"");
                tmpBuffer.append(font.getOwnFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnSize() != null) {
                tmpBuffer.append(" size=\"");
                tmpBuffer.append(font.getOwnSize());
                tmpBuffer.append("\"");
            }
            if (font.isOwnBold() != null) {
                tmpBuffer.append(" isBold=\"");
                tmpBuffer.append(font.isOwnBold());
                tmpBuffer.append("\"");
            }
            if (font.isOwnItalic() != null) {
                tmpBuffer.append(" isItalic=\"");
                tmpBuffer.append(font.isOwnItalic());
                tmpBuffer.append("\"");
            }
            if (font.isOwnUnderline() != null) {
                tmpBuffer.append(" isUnderline=\"");
                tmpBuffer.append(font.isOwnUnderline());
                tmpBuffer.append("\"");
            }
            if (font.isOwnStrikeThrough() != null) {
                tmpBuffer.append(" isStrikeThrough=\"");
                tmpBuffer.append(font.isOwnStrikeThrough());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfFontName() != null) {
                tmpBuffer.append(" pdfFontName=\"");
                tmpBuffer.append(font.getOwnPdfFontName());
                tmpBuffer.append("\"");
            }
            if (font.getOwnPdfEncoding() != null) {
                tmpBuffer.append(" pdfEncoding=\"");
                tmpBuffer.append(font.getOwnPdfEncoding());
                tmpBuffer.append("\"");
            }
            if (font.isOwnPdfEmbedded() != null) {
                tmpBuffer.append(" isPdfEmbedded=\"");
                tmpBuffer.append(font.isOwnPdfEmbedded());
                tmpBuffer.append("\"");
            }
            if (tmpBuffer.length() > 0) {
                fontChunk = "<font" + tmpBuffer.toString() + "/>";
            }
        }
        return fontChunk;
    }

    private String getHexaColor(Color color) {
        String hexa = Integer.toHexString(color.getRGB() & colorMask).toUpperCase();
        return ("000000" + hexa).substring(hexa.length());
    }
}

