/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.forensics.analyzer;

import de.rub.nds.tlsattacker.core.config.Config;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.protocol.ModifiableVariableHolder;
import de.rub.nds.tlsattacker.core.protocol.message.ProtocolMessage;
import de.rub.nds.tlsattacker.core.protocol.message.computations.KeyExchangeComputations;
import de.rub.nds.tlsattacker.core.record.AbstractRecord;
import de.rub.nds.tlsattacker.core.record.layer.TlsRecordLayer;
import de.rub.nds.tlsattacker.core.state.State;
import de.rub.nds.tlsattacker.core.state.TlsContext;
import de.rub.nds.tlsattacker.core.workflow.WorkflowTrace;
import de.rub.nds.tlsattacker.core.workflow.action.GenericReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.MessageAction;
import de.rub.nds.tlsattacker.core.workflow.action.ReceiveAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendAction;
import de.rub.nds.tlsattacker.core.workflow.action.SendingAction;
import de.rub.nds.tlsattacker.core.workflow.action.TlsAction;
import de.rub.nds.tlsattacker.core.workflow.action.executor.MessageActionResult;
import de.rub.nds.tlsattacker.core.workflow.action.executor.ReceiveMessageHelper;
import de.rub.nds.tlsattacker.transport.ConnectionEndType;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.math.BigInteger;
import java.security.Provider;
import java.security.Security;
import java.util.LinkedList;
import java.util.List;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.jce.provider.BouncyCastleProvider;

public class ForensicAnalyzer {
    private static final Logger LOGGER = LogManager.getLogger();
    private ConnectionEndType connectionEndType;

    public WorkflowTrace getRealWorkflowTrace(WorkflowTrace executedWorkflow, BigInteger rsaPrivateKey) throws IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        if (!this.isSupported(executedWorkflow)) {
            return null;
        }
        WorkflowTrace reconstructed = new WorkflowTrace();
        int tracePosition = 0;
        State state = new State();
        TlsContext context = state.getTlsContext();
        if (rsaPrivateKey != null) {
            context.getConfig().setDefaultClientRSAPrivateKey(rsaPrivateKey);
            context.getConfig().setDefaultServerRSAPrivateKey(rsaPrivateKey);
        }
        context.setRecordLayer(new TlsRecordLayer(context));
        this.adjustPrivateKeys(state, executedWorkflow);
        this.connectionEndType = ConnectionEndType.CLIENT;
        if (executedWorkflow.getTlsActions().size() > 0 && !(executedWorkflow.getTlsActions().get(0) instanceof SendingAction)) {
            this.connectionEndType = ConnectionEndType.SERVER;
        }
        while (tracePosition < executedWorkflow.getTlsActions().size()) {
            MessageAction reconstructedAction;
            boolean sending;
            List<TlsAction> joinedActions;
            if (executedWorkflow.getTlsActions().get(tracePosition) instanceof SendingAction) {
                joinedActions = this.joinSendActions(tracePosition, executedWorkflow);
                sending = true;
            } else {
                joinedActions = this.joinReceiveActions(tracePosition, executedWorkflow);
                sending = false;
            }
            byte[] joinedRecordBytes = this.joinRecordBytes(joinedActions);
            tracePosition += joinedActions.size();
            if (joinedRecordBytes.length == 0) continue;
            ReceiveMessageHelper helper = new ReceiveMessageHelper();
            if (sending) {
                context.setTalkingConnectionEndType(this.connectionEndType);
            } else {
                context.setTalkingConnectionEndType(this.connectionEndType.getPeer());
            }
            if (context.getTalkingConnectionEndType() == ConnectionEndType.CLIENT) {
                context.setConnection(new InboundConnection());
            } else {
                context.setConnection(new OutboundConnection());
            }
            context.setReversePrepareAfterParse(sending);
            MessageActionResult parsedMessageResult = helper.handleReceivedBytes(joinedRecordBytes, context);
            if (sending) {
                reconstructedAction = new SendAction(parsedMessageResult.getMessageList());
                ((SendAction)reconstructedAction).setRecords(parsedMessageResult.getRecordList());
                reconstructed.addTlsAction(reconstructedAction);
                continue;
            }
            reconstructedAction = new GenericReceiveAction();
            reconstructedAction.setRecords(parsedMessageResult.getRecordList());
            reconstructedAction.setMessages(parsedMessageResult.getMessageList());
            reconstructed.addTlsAction(reconstructedAction);
        }
        return reconstructed;
    }

    public WorkflowTrace getRealWorkflowTrace(WorkflowTrace executedWorkflow) throws IOException {
        return this.getRealWorkflowTrace(executedWorkflow, null);
    }

    public byte[] joinRecordBytes(List<TlsAction> sendActions) {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        for (TlsAction action : sendActions) {
            if (!action.isExecuted()) continue;
            if (action instanceof MessageAction) {
                MessageAction msgAction = (MessageAction)action;
                List<AbstractRecord> records = msgAction.getRecords();
                for (AbstractRecord record : records) {
                    try {
                        if (record.getCompleteRecordBytes() != null && record.getCompleteRecordBytes().getValue() != null) {
                            stream.write((byte[])record.getCompleteRecordBytes().getValue());
                            continue;
                        }
                        LOGGER.warn("Something went terribly wrong. The record does not contain complete record bytes");
                    }
                    catch (IOException ex) {
                        LOGGER.warn("Could not write to ByteArrayOutputStream.", (Throwable)ex);
                    }
                }
                continue;
            }
            throw new IllegalArgumentException("List contains non MessageActions");
        }
        return stream.toByteArray();
    }

    public boolean isSupported(WorkflowTrace trace) {
        for (TlsAction action : trace.getTlsActions()) {
            if (action instanceof SendAction || action instanceof ReceiveAction || action instanceof GenericReceiveAction) continue;
            return false;
        }
        return true;
    }

    public List<TlsAction> joinSendActions(int position, WorkflowTrace trace) {
        LinkedList<TlsAction> joinedActions = new LinkedList<TlsAction>();
        for (int i = position; i < trace.getTlsActions().size(); ++i) {
            TlsAction action = trace.getTlsActions().get(i);
            if (!(action instanceof SendAction)) {
                return joinedActions;
            }
            joinedActions.add(action);
        }
        return joinedActions;
    }

    public List<TlsAction> joinReceiveActions(int position, WorkflowTrace trace) {
        LinkedList<TlsAction> joinedActions = new LinkedList<TlsAction>();
        for (int i = position; i < trace.getTlsActions().size(); ++i) {
            TlsAction action = trace.getTlsActions().get(i);
            if (!(action instanceof ReceiveAction) && !(action instanceof GenericReceiveAction)) {
                return joinedActions;
            }
            joinedActions.add(action);
        }
        return joinedActions;
    }

    public void adjustPrivateKeys(State state, WorkflowTrace executedTrace) {
        Config config = state.getConfig();
        List<SendingAction> sendingActions = executedTrace.getSendingActions();
        for (SendingAction action : sendingActions) {
            for (ProtocolMessage message : action.getSendMessages()) {
                for (ModifiableVariableHolder holder : message.getAllModifiableVariableHolders()) {
                    if (!(holder instanceof KeyExchangeComputations)) continue;
                    ((KeyExchangeComputations)holder).setSecretsInConfig(config);
                }
            }
        }
    }
}

