/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.modifiablevariable.biginteger;

import de.rub.nds.modifiablevariable.ModifiableVariable;
import de.rub.nds.modifiablevariable.VariableModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerAddModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerExplicitValueModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerModificationFactory;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerSubtractModification;
import de.rub.nds.modifiablevariable.biginteger.BigIntegerXorModification;
import de.rub.nds.modifiablevariable.util.ArrayConverter;
import java.io.Serializable;
import java.math.BigInteger;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.bind.annotation.XmlType;

@XmlRootElement
@XmlSeeAlso(value={BigIntegerAddModification.class, BigIntegerExplicitValueModification.class, BigIntegerSubtractModification.class, BigIntegerXorModification.class})
@XmlType(propOrder={"originalValue", "modification", "assertEquals"})
public class ModifiableBigInteger
extends ModifiableVariable<BigInteger>
implements Serializable {
    private BigInteger originalValue;

    @Override
    protected void createRandomModification() {
        VariableModification<BigInteger> vm = BigIntegerModificationFactory.createRandomModification();
        this.setModification(vm);
    }

    public BigInteger getAssertEquals() {
        return (BigInteger)this.assertEquals;
    }

    public void setAssertEquals(BigInteger assertEquals) {
        this.assertEquals = assertEquals;
    }

    @Override
    public boolean isOriginalValueModified() {
        return this.getOriginalValue() != null && this.getOriginalValue().compareTo((BigInteger)this.getValue()) != 0;
    }

    public byte[] getByteArray() {
        return ArrayConverter.bigIntegerToByteArray((BigInteger)this.getValue());
    }

    public byte[] getByteArray(int size) {
        return ArrayConverter.bigIntegerToByteArray((BigInteger)this.getValue(), size, true);
    }

    @Override
    public boolean validateAssertions() {
        return this.assertEquals == null || ((BigInteger)this.assertEquals).compareTo((BigInteger)this.getValue()) == 0;
    }

    @Override
    public BigInteger getOriginalValue() {
        return this.originalValue;
    }

    @Override
    public void setOriginalValue(BigInteger originalValue) {
        this.originalValue = originalValue;
    }

    public String toString() {
        return "ModifiableBigInteger{originalValue=" + this.originalValue + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof ModifiableBigInteger)) {
            return false;
        }
        ModifiableBigInteger that = (ModifiableBigInteger)o;
        return this.getValue() != null ? ((BigInteger)this.getValue()).equals(that.getValue()) : that.getValue() == null;
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + (this.getValue() != null ? ((BigInteger)this.getValue()).hashCode() : 0);
        return result;
    }
}

