/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.config;

import de.rub.nds.modifiablevariable.util.ArrayConverter;
import de.rub.nds.modifiablevariable.util.UnformattedByteArrayAdapter;
import de.rub.nds.tlsattacker.core.certificate.CertificateKeyPair;
import de.rub.nds.tlsattacker.core.config.ConfigCache;
import de.rub.nds.tlsattacker.core.config.ConfigIO;
import de.rub.nds.tlsattacker.core.connection.InboundConnection;
import de.rub.nds.tlsattacker.core.connection.OutboundConnection;
import de.rub.nds.tlsattacker.core.constants.AlertDescription;
import de.rub.nds.tlsattacker.core.constants.AlertLevel;
import de.rub.nds.tlsattacker.core.constants.AuthzDataFormat;
import de.rub.nds.tlsattacker.core.constants.CertificateKeyType;
import de.rub.nds.tlsattacker.core.constants.CertificateStatusRequestType;
import de.rub.nds.tlsattacker.core.constants.CertificateType;
import de.rub.nds.tlsattacker.core.constants.ChooserType;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.ClientAuthenticationType;
import de.rub.nds.tlsattacker.core.constants.ClientCertificateType;
import de.rub.nds.tlsattacker.core.constants.CompressionMethod;
import de.rub.nds.tlsattacker.core.constants.ECPointFormat;
import de.rub.nds.tlsattacker.core.constants.EsniDnsKeyRecordVersion;
import de.rub.nds.tlsattacker.core.constants.EsniVersion;
import de.rub.nds.tlsattacker.core.constants.ExtensionType;
import de.rub.nds.tlsattacker.core.constants.GOSTCurve;
import de.rub.nds.tlsattacker.core.constants.HashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.HeartbeatMode;
import de.rub.nds.tlsattacker.core.constants.MaxFragmentLength;
import de.rub.nds.tlsattacker.core.constants.NameType;
import de.rub.nds.tlsattacker.core.constants.NamedGroup;
import de.rub.nds.tlsattacker.core.constants.PRFAlgorithm;
import de.rub.nds.tlsattacker.core.constants.ProtocolVersion;
import de.rub.nds.tlsattacker.core.constants.PskKeyExchangeMode;
import de.rub.nds.tlsattacker.core.constants.RunningModeType;
import de.rub.nds.tlsattacker.core.constants.SSL2CipherSuite;
import de.rub.nds.tlsattacker.core.constants.SignatureAndHashAlgorithm;
import de.rub.nds.tlsattacker.core.constants.SrtpProtectionProfiles;
import de.rub.nds.tlsattacker.core.constants.StarttlsType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingKeyParameters;
import de.rub.nds.tlsattacker.core.constants.TokenBindingType;
import de.rub.nds.tlsattacker.core.constants.TokenBindingVersion;
import de.rub.nds.tlsattacker.core.constants.UserMappingExtensionHintType;
import de.rub.nds.tlsattacker.core.crypto.ec.CurveFactory;
import de.rub.nds.tlsattacker.core.crypto.ec.EllipticCurve;
import de.rub.nds.tlsattacker.core.crypto.ec.Point;
import de.rub.nds.tlsattacker.core.crypto.keys.CustomRSAPrivateKey;
import de.rub.nds.tlsattacker.core.exceptions.ConfigurationException;
import de.rub.nds.tlsattacker.core.protocol.message.extension.cachedinfo.CachedObject;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.keyshare.KeyShareStoreEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.psk.PskSet;
import de.rub.nds.tlsattacker.core.protocol.message.extension.sni.SNIEntry;
import de.rub.nds.tlsattacker.core.protocol.message.extension.statusrequestv2.RequestItemV2;
import de.rub.nds.tlsattacker.core.protocol.message.extension.trustedauthority.TrustedAuthority;
import de.rub.nds.tlsattacker.core.record.layer.RecordLayerType;
import de.rub.nds.tlsattacker.core.workflow.action.executor.WorkflowExecutorType;
import de.rub.nds.tlsattacker.core.workflow.factory.WorkflowTraceType;
import de.rub.nds.tlsattacker.core.workflow.filter.FilterType;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.math.BigInteger;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.bouncycastle.crypto.tls.Certificate;

@XmlRootElement
@XmlAccessorType(value=XmlAccessType.FIELD)
public class Config
implements Serializable {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String DEFAULT_CONFIG_FILE = "/default_config.xml";
    private static final ConfigCache DEFAULT_CONFIG_CACHE = new ConfigCache(Config.createConfig());
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultHandshakeSecret = new byte[32];
    private CertificateKeyType preferedCertificateSignatureType = CertificateKeyType.RSA;
    private NamedGroup preferedCertificateSignatureGroup = NamedGroup.SECP256R1;
    private Boolean autoSelectCertificate = true;
    private CertificateKeyPair defaultExplicitCertificateKeyPair;
    private Boolean autoAdjustSignatureAndHashAlgorithm = true;
    private HashAlgorithm preferredHashAlgorithm = HashAlgorithm.SHA256;
    private List<FilterType> outputFilters;
    private Boolean applyFiltersInPlace = true;
    private Boolean filtersKeepUserSettings = true;
    private Boolean reorderReceivedDtlsRecords = true;
    private ProtocolVersion highestProtocolVersion = ProtocolVersion.TLS12;
    private OutboundConnection defaultClientConnection;
    private InboundConnection defaultServerConnection;
    private RunningModeType defaultRunningMode = RunningModeType.CLIENT;
    private Boolean clientAuthentication = false;
    private List<SignatureAndHashAlgorithm> defaultClientSupportedSignatureAndHashAlgorithms;
    private List<CipherSuite> defaultClientSupportedCiphersuites;
    private List<CipherSuite> defaultServerSupportedCiphersuites;
    private List<NamedGroup> defaultClientNamedGroups;
    private List<NamedGroup> defaultServerNamedGroups;
    private List<ProtocolVersion> supportedVersions;
    private HeartbeatMode heartbeatMode = HeartbeatMode.PEER_ALLOWED_TO_SEND;
    private Integer defaultAdditionalPadding = 0;
    private NamedGroup defaultSelectedNamedGroup = NamedGroup.SECP256R1;
    private BigInteger defaultKeySharePrivateKey = new BigInteger("FFFF", 16);
    private List<KeyShareStoreEntry> defaultClientKeyShareEntries;
    private KeyShareStoreEntry defaultServerKeyShareEntry;
    private NameType sniType = NameType.HOST_NAME;
    private MaxFragmentLength maxFragmentLength = MaxFragmentLength.TWO_9;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] tlsSessionTicket = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientRenegotiationInfo = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerRenegotiationInfo = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSignedCertificateTimestamp = new byte[0];
    private TokenBindingVersion defaultTokenBindingVersion = TokenBindingVersion.DRAFT_13;
    private List<TokenBindingKeyParameters> defaultTokenBindingKeyParameters;
    private CertificateStatusRequestType certificateStatusRequestExtensionRequestType = CertificateStatusRequestType.OCSP;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] certificateStatusRequestExtensionResponderIDList = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] certificateStatusRequestExtensionRequestExtension = new byte[0];
    private String[] alpnAnnouncedProtocols = new String[]{"h2"};
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] secureRemotePasswordExtensionIdentifier = "UserName".getBytes(Charset.forName("UTF-8"));
    private List<SrtpProtectionProfiles> secureRealTimeTransportProtocolProtectionProfiles;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] secureRealTimeTransportProtocolMasterKeyIdentifier = new byte[0];
    private UserMappingExtensionHintType userMappingExtensionHintType = UserMappingExtensionHintType.UPN_DOMAIN_HINT;
    private List<CertificateType> certificateTypeDesiredTypes;
    private List<CertificateType> clientCertificateTypeDesiredTypes;
    private List<CertificateType> serverCertificateTypeDesiredTypes;
    private List<AuthzDataFormat> clientAuthzExtensionDataFormat;
    private Boolean certificateTypeExtensionMessageState = true;
    private List<AuthzDataFormat> serverAuthzExtensionDataFormat;
    private List<TrustedAuthority> trustedCaIndicationExtensionAuthorties;
    private Boolean clientCertificateTypeExtensionMessageState = true;
    private Boolean cachedInfoExtensionIsClientState = true;
    private List<CachedObject> cachedObjectList;
    private List<RequestItemV2> statusRequestV2RequestList;
    private String workflowInput = null;
    private String workflowOutput = null;
    private String configOutput = null;
    private WorkflowTraceType workflowTraceType = null;
    private Boolean serverSendsApplicationData = false;
    private Boolean addExtensionsInSSL = false;
    private Boolean addECPointFormatExtension = true;
    private Boolean addEllipticCurveExtension = true;
    private Boolean addHeartbeatExtension = false;
    private Boolean addMaxFragmentLengthExtension = false;
    private Boolean addServerNameIndicationExtension = false;
    private Boolean addSignatureAndHashAlgorithmsExtension = true;
    private Boolean addSupportedVersionsExtension = false;
    private Boolean addKeyShareExtension = false;
    private Boolean addEarlyDataExtension = false;
    private Boolean addEncryptedServerNameIndicationExtension = false;
    private Boolean addPWDClearExtension = false;
    private Boolean addPWDProtectExtension = false;
    private Boolean addPSKKeyExchangeModesExtension = false;
    private Boolean addPreSharedKeyExtension = false;
    private Boolean addPaddingExtension = false;
    private Boolean addExtendedMasterSecretExtension = false;
    private Boolean addSessionTicketTLSExtension = false;
    private Boolean addExtendedRandomExtension = false;
    private Boolean addSignedCertificateTimestampExtension = false;
    private Boolean addRenegotiationInfoExtension = true;
    private Boolean addTokenBindingExtension = false;
    private Boolean addHttpsCookie = false;
    private String defaultHttpsCookieName = "tls-attacker";
    private String defaultHttpsCookieValue = "42130912812";
    private Boolean addCertificateStatusRequestExtension = false;
    private Boolean addAlpnExtension = false;
    private Boolean addSRPExtension = false;
    private Boolean addSRTPExtension = false;
    private Boolean addTruncatedHmacExtension = false;
    private Boolean addUserMappingExtension = false;
    private Boolean addCertificateTypeExtension = false;
    private Boolean addClientAuthzExtension = false;
    private Boolean addServerAuthzExtension = false;
    private Boolean addClientCertificateTypeExtension = false;
    private Boolean addServerCertificateTypeExtension = false;
    private Boolean addEncryptThenMacExtension = false;
    private Boolean addCachedInfoExtension = false;
    private Boolean addClientCertificateUrlExtension = false;
    private Boolean addTrustedCaIndicationExtension = false;
    private Boolean addCertificateStatusRequestV2Extension = false;
    private Boolean updateTimestamps = true;
    List<PskKeyExchangeMode> pskKeyExchangeModes;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] psk = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] clientEarlyTrafficSecret = new byte[128];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlySecret = new byte[256];
    private CipherSuite earlyDataCipherSuite = CipherSuite.TLS_AES_128_GCM_SHA256;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlyDataPsk = new byte[256];
    private List<PskSet> defaultPskSets = new LinkedList<PskSet>();
    private Boolean usePsk = false;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] earlyData = ArrayConverter.hexStringToByteArray((String)"544c532d41747461636b65720a");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] distinguishedNames = new byte[0];
    private Boolean enforceSettings = false;
    private Boolean earlyStop = false;
    private Boolean stopActionsAfterIOException = false;
    private Boolean stopTraceAfterUnexpected = false;
    private BigInteger defaultServerDhGenerator = new BigInteger("2");
    private BigInteger defaultServerDhModulus = new BigInteger("5809605995369958062791915965639201402176612226902900533702900882779736177890990861472094774477339581147373410185646378328043729800750470098210924487866935059164371588168047540943981644516632755067501626434556398193186628990071248660819361205119793693985433297036118232914410171876807536457391277857011849897410207519105333355801121109356897459426271845471397952675959440793493071628394122780510124618488232602464649876850458861245784240929258426287699705312584509625419513463605155428017165714465363094021609290561084025893662561222573202082865797821865270991145082200656978177192827024538990239969175546190770645685893438011714430426409338676314743571154537142031573004276428701433036381801705308659830751190352946025482059931306571004727362479688415574702596946457770284148435989129632853918392117997472632693078113129886487399347796982772784615865232621289656944284216824611318709764535152507354116344703769998514148343807");
    private BigInteger defaultClientDhGenerator = new BigInteger("2");
    private BigInteger defaultClientDhModulus = new BigInteger("5809605995369958062791915965639201402176612226902900533702900882779736177890990861472094774477339581147373410185646378328043729800750470098210924487866935059164371588168047540943981644516632755067501626434556398193186628990071248660819361205119793693985433297036118232914410171876807536457391277857011849897410207519105333355801121109356897459426271845471397952675959440793493071628394122780510124618488232602464649876850458861245784240929258426287699705312584509625419513463605155428017165714465363094021609290561084025893662561222573202082865797821865270991145082200656978177192827024538990239969175546190770645685893438011714430426409338676314743571154537142031573004276428701433036381801705308659830751190352946025482059931306571004727362479688415574702596946457770284148435989129632853918392117997472632693078113129886487399347796982772784615865232621289656944284216824611318709764535152507354116344703769998514148343807");
    private BigInteger defaultServerDhPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultClientDhPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultServerDhPublicKey = new BigInteger("2043613254509771843465057207078304133427100053346630496863115304729422431506842297554370188431622336168084226893060531474609378481237396107127063278624858982135545329954888129900714249447398611399069380214077491792199889131147659097337451088584054931352640316306698530468089459265836208766829761530786550035554546801263324790398605318443686766315312672983302101280548433287949333943437948214799189911192606949101858307621640886413682299273130735853556255008467704876737231663242842259426239401780891543201358635180397430055997246351872086043137262555233050955216238105392009330462604912891943865361186717249962097299588875409587651544594728203293910128024102640696503192096755401014128136916889018704050784334709496695214785225237421325503031115105974843553040027247097092511319153606298406218024502785451855415341620633845851737579504653807158340552365430158715166515645118698024341396560621615465703434564793715203380646117");
    private BigInteger defaultClientDhPublicKey = new BigInteger("2043613254509771843465057207078304133427100053346630496863115304729422431506842297554370188431622336168084226893060531474609378481237396107127063278624858982135545329954888129900714249447398611399069380214077491792199889131147659097337451088584054931352640316306698530468089459265836208766829761530786550035554546801263324790398605318443686766315312672983302101280548433287949333943437948214799189911192606949101858307621640886413682299273130735853556255008467704876737231663242842259426239401780891543201358635180397430055997246351872086043137262555233050955216238105392009330462604912891943865361186717249962097299588875409587651544594728203293910128024102640696503192096755401014128136916889018704050784334709496695214785225237421325503031115105974843553040027247097092511319153606298406218024502785451855415341620633845851737579504653807158340552365430158715166515645118698024341396560621615465703434564793715203380646117");
    private BigInteger defaultServerDsaPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultServerDsaPublicKey = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"3c991ffbb26fce963dae6540ce45904079c50398b0c32fa8485ada51dd9614e150bc8983ab6996ce4d7f8237aeeef9ec97a10e6c0949417b8412cc5711a8482f540d6b030da4e1ed591c152062775e61e6fef897c3b12a38185c12d8feddbe85298dc41324b2450d83e3b90a419373380b60ee1ca9094437c0be19fb73184726"));
    private BigInteger defaultServerDsaPrimeP = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"0093c33a88f3af1bacb3b20500fef26e70d08d1591874e9e77f1cc98ba004ae8c04d2022edce758e0ee8ceee9520381a9d4b2dda1c8f7b249aa2c452e8cada51ab57709053184316eb691f3dace9f4b60f8e70c95314b473782f8d6401181945ae83c3befcb9478e0b050ad4e146eedbdd42afb136eef59ec751af958f35466529"));
    private BigInteger defaultServerDsaPrimeQ = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"00ac2ef188503342ec5ccb04541dfa5d5eade8b019"));
    private BigInteger defaultServerDsaGenerator = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"1e813bdd058e57f807aef75c3626dfae3918be6dd87efe5739201b37581d33865b9626aff787aa847e9dbdbf20f57f7d2fce39a5f53c6869254d12fa6b95cfeebc2c1151e69b3d52073d6c23d7cb7c830e2cbb286a624cebbab5648b6d0276dfede31c4717ec03035f13ed81d183a07076a53d79f746f6f67237dbfc6211dc5a"));
    private BigInteger defaultClientDsaPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultClientDsaPublicKey = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"3c991ffbb26fce963dae6540ce45904079c50398b0c32fa8485ada51dd9614e150bc8983ab6996ce4d7f8237aeeef9ec97a10e6c0949417b8412cc5711a8482f540d6b030da4e1ed591c152062775e61e6fef897c3b12a38185c12d8feddbe85298dc41324b2450d83e3b90a419373380b60ee1ca9094437c0be19fb73184726"));
    private BigInteger defaultClientDsaPrimeP = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"0093c33a88f3af1bacb3b20500fef26e70d08d1591874e9e77f1cc98ba004ae8c04d2022edce758e0ee8ceee9520381a9d4b2dda1c8f7b249aa2c452e8cada51ab57709053184316eb691f3dace9f4b60f8e70c95314b473782f8d6401181945ae83c3befcb9478e0b050ad4e146eedbdd42afb136eef59ec751af958f35466529"));
    private BigInteger defaultClientDsaPrimeQ = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"00ac2ef188503342ec5ccb04541dfa5d5eade8b019"));
    private BigInteger defaultClientDsaGenerator = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"1e813bdd058e57f807aef75c3626dfae3918be6dd87efe5739201b37581d33865b9626aff787aa847e9dbdbf20f57f7d2fce39a5f53c6869254d12fa6b95cfeebc2c1151e69b3d52073d6c23d7cb7c830e2cbb286a624cebbab5648b6d0276dfede31c4717ec03035f13ed81d183a07076a53d79f746f6f67237dbfc6211dc5a"));
    private GOSTCurve defaultSelectedGostCurve = GOSTCurve.GostR3410_2001_CryptoPro_XchB;
    private String defaultApplicationMessageData = "Test";
    private List<ClientCertificateType> clientCertificateTypes;
    private Integer heartbeatPayloadLength = 256;
    private Integer heartbeatPaddingLength = 256;
    private Integer defaultMaxRecordData = 16384;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPaddingExtensionBytes = new byte[]{0, 0, 0, 0, 0, 0};
    private Integer dtlsDefaultCookieLength = 20;
    private Integer dtlsMaximumFragmentLength = 1400;
    private WorkflowExecutorType workflowExecutorType = WorkflowExecutorType.DEFAULT;
    private Boolean flushOnMessageTypeChange = true;
    private Boolean createRecordsDynamically = true;
    private Boolean createIndividualRecords = true;
    private RecordLayerType recordLayerType = RecordLayerType.RECORD;
    private Boolean resetWorkflowtracesBeforeSaving = false;
    private Boolean quickReceive = true;
    private Boolean workflowExecutorShouldOpen = true;
    private Boolean workflowExecutorShouldClose = true;
    private Boolean stopReceivingAfterFatal = false;
    private Boolean stopActionsAfterFatal = false;
    private CipherSuite defaultSelectedCipherSuite = CipherSuite.TLS_RSA_WITH_AES_128_CBC_SHA;
    private CertificateType defaultSelectedServerCertificateType = CertificateType.X509;
    private CertificateType defaultSelectedClientCertificateType = CertificateType.X509;
    private SSL2CipherSuite defaultSSL2CipherSuite = SSL2CipherSuite.SSL_CK_RC4_128_WITH_MD5;
    private List<ECPointFormat> defaultServerSupportedPointFormats;
    private List<ECPointFormat> defaultClientSupportedPointFormats;
    private List<SignatureAndHashAlgorithm> defaultServerSupportedSignatureAndHashAlgorithms;
    private SignatureAndHashAlgorithm defaultSelectedSignatureAndHashAlgorithm = SignatureAndHashAlgorithm.RSA_SHA1;
    private List<SNIEntry> defaultClientSNIEntryList;
    private ProtocolVersion defaultLastRecordProtocolVersion = ProtocolVersion.TLS10;
    private ProtocolVersion defaultSelectedProtocolVersion = ProtocolVersion.TLS12;
    private ProtocolVersion defaultHighestClientProtocolVersion = ProtocolVersion.TLS12;
    private MaxFragmentLength defaultMaxFragmentLength = MaxFragmentLength.TWO_12;
    private HeartbeatMode defaultHeartbeatMode = HeartbeatMode.PEER_ALLOWED_TO_SEND;
    private List<CompressionMethod> defaultClientSupportedCompressionMethods;
    private List<CompressionMethod> defaultServerSupportedCompressionMethods;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultMasterSecret = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPreMasterSecret = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientExtendedRandom = ArrayConverter.hexStringToByteArray((String)"AABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABB");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerExtendedRandom = ArrayConverter.hexStringToByteArray((String)"AABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABBCCDDEEFFAABB");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientRandom = ArrayConverter.hexStringToByteArray((String)"00112233445566778899AABBCCDDEEFFFFEEDDCCBBAA99887766554433221100");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerRandom = ArrayConverter.hexStringToByteArray((String)"00112233445566778899AABBCCDDEEFFFFEEDDCCBBAA99887766554433221100");
    private Boolean parseKeyShareOld = true;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientSessionId = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerSessionId = new byte[0];
    private CompressionMethod defaultSelectedCompressionMethod = CompressionMethod.NULL;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] dtlsDefaultCookie = new byte[0];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultCertificateRequestContext = new byte[0];
    private PRFAlgorithm defaultPRFAlgorithm = PRFAlgorithm.TLS_PRF_LEGACY;
    private AlertDescription defaultAlertDescription = AlertDescription.CLOSE_NOTIFY;
    private AlertLevel defaultAlertLevel = AlertLevel.WARNING;
    private NamedGroup defaultEcCertificateCurve = NamedGroup.SECP256R1;
    private Point defaultClientEcPublicKey;
    private Point defaultServerEcPublicKey;
    private BigInteger defaultServerEcPrivateKey = new BigInteger("3");
    private BigInteger defaultClientEcPrivateKey = new BigInteger("3");
    private BigInteger defaultServerRSAModulus = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"00c8820d6c3ce84c8430f6835abfc7d7a912e1664f44578751f376501a8c68476c3072d919c5d39bd0dbe080e71db83bd4ab2f2f9bde3dffb0080f510a5f6929c196551f2b3c369be051054c877573195558fd282035934dc86edab8d4b1b7f555e5b2fee7275384a756ef86cb86793b5d1333f0973203cb96966766e655cd2cccae1940e4494b8e9fb5279593b75afd0b378243e51a88f6eb88def522a8cd5c6c082286a04269a2879760fcba45005d7f2672dd228809d47274f0fe0ea5531c2bd95366c05bf69edc0f3c3189866edca0c57adcca93250ae78d9eaca0393a95ff9952fc47fb7679dd3803e6a7a6fa771861e3d99e4b551a4084668b111b7eef7d"));
    private BigInteger defaultClientRSAModulus = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"00c8820d6c3ce84c8430f6835abfc7d7a912e1664f44578751f376501a8c68476c3072d919c5d39bd0dbe080e71db83bd4ab2f2f9bde3dffb0080f510a5f6929c196551f2b3c369be051054c877573195558fd282035934dc86edab8d4b1b7f555e5b2fee7275384a756ef86cb86793b5d1333f0973203cb96966766e655cd2cccae1940e4494b8e9fb5279593b75afd0b378243e51a88f6eb88def522a8cd5c6c082286a04269a2879760fcba45005d7f2672dd228809d47274f0fe0ea5531c2bd95366c05bf69edc0f3c3189866edca0c57adcca93250ae78d9eaca0393a95ff9952fc47fb7679dd3803e6a7a6fa771861e3d99e4b551a4084668b111b7eef7d"));
    private BigInteger defaultServerRSAPublicKey = new BigInteger("65537");
    private BigInteger defaultClientRSAPublicKey = new BigInteger("65537");
    private BigInteger defaultServerRSAPrivateKey = new BigInteger("7dc0cb485a3edb56811aeab12cdcda8e48b023298dd453a37b4d75d9e0bbba27c98f0e4852c16fd52341ffb673f64b580b7111abf14bf323e53a2dfa92727364ddb34f541f74a478a077f15277c013606aea839307e6f5fec23fdd72506feea7cbe362697949b145fe8945823a39a898ac6583fc5fbaefa1e77cbc95b3b475e66106e92b906bdbb214b87bcc94020f317fc1c056c834e9cee0ad21951fbdca088274c4ef9d8c2004c6294f49b370fb249c1e2431fb80ce5d3dc9e342914501ef4c162e54e1ee4fed9369b82afc00821a29f4979a647e60935420d44184d98f9cb75122fb604642c6d1ff2b3a51dc32eefdc57d9a9407ad6a06d10e83e2965481", 16);
    private BigInteger defaultClientRSAPrivateKey = new BigInteger("7dc0cb485a3edb56811aeab12cdcda8e48b023298dd453a37b4d75d9e0bbba27c98f0e4852c16fd52341ffb673f64b580b7111abf14bf323e53a2dfa92727364ddb34f541f74a478a077f15277c013606aea839307e6f5fec23fdd72506feea7cbe362697949b145fe8945823a39a898ac6583fc5fbaefa1e77cbc95b3b475e66106e92b906bdbb214b87bcc94020f317fc1c056c834e9cee0ad21951fbdca088274c4ef9d8c2004c6294f49b370fb249c1e2431fb80ce5d3dc9e342914501ef4c162e54e1ee4fed9369b82afc00821a29f4979a647e60935420d44184d98f9cb75122fb604642c6d1ff2b3a51dc32eefdc57d9a9407ad6a06d10e83e2965481", 16);
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKKey = ArrayConverter.hexStringToByteArray((String)"1a2b3c4d");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKIdentity = "Client_Identity".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultPSKIdentityHint = new byte[0];
    private BigInteger defaultSRPModulus = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"EEAF0AB9ADB38DD69C33F80AFA8FC5E86072618775FF3C0B9EA2314C9C256576D674DF7496EA81D3383B4813D692C6E0E0D5D8E250B98BE48E495C1D6089DAD15DC7D7B46154D6B6CE8EF4AD69B15D4982559B297BCF1885C529F566660E57EC68EDBC3C05726CC02FD4CBF4976EAA9AFD5138FE8376435B9FC61D2FC0EB06E3"));
    private BigInteger defaultPSKModulus = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"FFFFFFFFFFFFFFFFC90FDAA22168C234C4C6628B80DC1CD129024E088A67CC74020BBEA63B139B22514A08798E3404DDEF9519B3CD3A431B302B0A6DF25F14374FE1356D6D51C245E485B576625E7EC6F44C42E9A637ED6B0BFF5CB6F406B7EDEE386BFB5A899FA5AE9F24117C4B1FE649286651ECE45B3DC2007CB8A163BF0598DA48361C55D39A69163FA8FD24CF5F83655D23DCA3AD961C62F356208552BB9ED529077096966D670C354E4ABC9804F1746C08CA18217C32905E462E36CE3BE39E772C180E86039B2783A2EC07A28FB5C55DF06F4C52C9DE2BCBF6955817183995497CEA956AE515D2261898FA051015728E5A8AAAC42DAD33170D04507A33A85521ABDF1CBA64ECFB850458DBEF0A8AEA71575D060C7DB3970F85A6E1E4C7ABF5AE8CDB0933D71E8C94E04A25619DCEE3D2261AD2EE6BF12FFA06D98A0864D87602733EC86A64521F2B18177B200CBBE117577A615D6C770988C0BAD946E208E24FA074E5AB3143DB5BFCE0FD108E4B82D120A93AD2CAFFFFFFFFFFFFFFFF"));
    private BigInteger defaultPSKGenerator = new BigInteger("2");
    private BigInteger defaultPskDhServerPrivateKey = new BigInteger("FFFF", 16);
    private BigInteger defaultPskDhServerPublicKey = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"5a0d3d4e049faa939ffa6a375b9c3c16a4c39753d19ff7da36bc391ea72fc0f68c929bdb400552ed84e0900c7a44c3222fd54d7148256862886bfb4016bd2d03c4c4cf476567c291770e47bd59d0aa5323cfddfc5596e0d6558c480ee8b0c62599834d4581a796a01981468789164504afbd29ce9936e86a290c5f00f8ba986b48010f3e5c079c7f351ddca2ee1fd50846b37bf7463c2b0f3d001b1317ac3069cd89e2e4927ed3d40875a6049af649d2dc349db5995a7525d70a3a1c9b673f5482f83343bd90d45e9c3962dc4a4bf2b4adb37e9166b2ddb31ccf11c5b9e6c98e0a9a3377abba56b0f4283b2eaa69f5368bc107e1c22599f88dd1924d0899c5f153462c911a8293078aefee9fb2389a7854833fcea61cfecbb49f828c361a981a5fedecf13796ae36e36c15a16670af96996c3c45a30e900e18c858f6232b5f7072bdd9e47d7fc61246ef5d19765739f38509284379bc319d9409e8fe236bd29b0335a5bc5bb0424ee44de8a19f864a159fda907d6f5a30ebc0a17e3628e490e5"));
    private BigInteger defaultSRPGenerator = new BigInteger("2");
    private BigInteger defaultSRPServerPrivateKey = new BigInteger("3");
    private BigInteger defaultSRPClientPrivateKey = new BigInteger("5");
    private BigInteger defaultSRPServerPublicKey = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"AC47983DEB1698D9A9029E8F7B39092F441DDD72C56D3A63F236E1CF6CEE839937AB5FD69F8CEBBA64C210170A59B2526ED34B9DD83EF86DF7899DF68297844B15E6F2D1BD2448640D32A48220E6343875976A268F28D25174C37D8DC19F2BA5A35301CEED689206FA91CE7A172D908B821DF8C760918E6A5D1C0CFA76AF503B"));
    private BigInteger defaultSRPClientPublicKey = new BigInteger(1, ArrayConverter.hexStringToByteArray((String)"25C843"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPServerSalt = ArrayConverter.hexStringToByteArray((String)"AABBCCDD");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPIdentity = "UserName".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSRPPassword = "Password".getBytes(Charset.forName("UTF-8"));
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientHandshakeTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerHandshakeTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientApplicationTrafficSecret = new byte[32];
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerApplicationTrafficSecret = new byte[32];
    private TokenBindingType defaultTokenBindingType = TokenBindingType.PROVIDED_TOKEN_BINDING;
    private Point defaultTokenBindingECPublicKey = null;
    private BigInteger defaultTokenBindingRsaPublicKey = new BigInteger("65537");
    private BigInteger defaultTokenBindingRsaPrivateKey = new BigInteger("89489425009274444368228545921773093919669586065884257445497854456487674839629818390934941973262879616797970608917283679875499331574161113854088813275488110588247193077582527278437906504015680623423550067240042466665654232383502922215493623289472138866445818789127946123407807725702626644091036502372545139713");
    private BigInteger defaultTokenBindingEcPrivateKey = new BigInteger("3");
    private BigInteger defaultTokenBindingRsaModulus = new BigInteger("145906768007583323230186939349070635292401872375357164399581871019873438799005358938369571402670149802121818086292467422828157022922076746906543401224889672472407926969987100581290103199317858753663710862357656510507883714297115637342788911463535102712032765166518411726859837988672111837205085526346618740053");
    private Boolean useFreshRandom = true;
    private ChooserType chooserType = ChooserType.DEFAULT;
    private Boolean useAllProvidedRecords = false;
    private Boolean httpsParsingEnabled = false;
    private StarttlsType starttlsType = StarttlsType.NONE;
    private Long sessionTicketLifetimeHint = 0L;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketKeyAES = ArrayConverter.hexStringToByteArray((String)"536563757265535469636b65744b6579");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketKeyHMAC = ArrayConverter.hexStringToByteArray((String)"536563757265535469636b65744b6579536563757265535469636b65744b6579");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] sessionTicketKeyName = ArrayConverter.hexStringToByteArray((String)"544c532d41747461636b6572204b6579");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketAgeAdd = ArrayConverter.hexStringToByteArray((String)"cb8dbe8e");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketNonce = ArrayConverter.hexStringToByteArray((String)"00");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultSessionTicketIdentity = ArrayConverter.hexStringToByteArray((String)"5266d21abe0f5156106eb1f0ec54a48a90fbc136de990a8881192211cc83aa7992ceb67d7a40b3f304fdea87e4ca61042c19641fd7493975ec69a3ec3f5fb6404aa4ac5acd5efbea15d454d89888a46fc4e6c6b9a3e0ee08ea21538372ced8d0aca453ceae44ce372a5388ab4cef67c5eae8cc1c72735d2646c19b2c50a4ee9bc97e70c6b57cab276a11a59fc5cbe0f5d2519e164fbf9f07a9dd053bcfc08939b475c7a2e76f04ef2a06cc9672bd4034");
    private ClientAuthenticationType clientAuthenticationType = ClientAuthenticationType.ANONYMOUS;
    private Boolean tls13BackwardsCompatibilityMode = true;
    private String defaultClientPWDUsername = "fred";
    private NamedGroup defaultPWDProtectGroup = NamedGroup.SECP256R1;
    private Point defaultServerPWDProtectPublicKey;
    private BigInteger defaultServerPWDProtectPrivateKey = new BigInteger("191991257030464195512760799659436374116556484140110877679395918219072292938297573720808302564562486757422301181089761");
    private BigInteger defaultServerPWDProtectRandomSecret = new BigInteger("1111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111111");
    private String defaultPWDPassword = "barney";
    private Integer defaultPWDIterations = 40;
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDPrivate = ArrayConverter.hexStringToByteArray((String)"21d99d341c9797b3ae72dfd289971f1b74ce9de68ad4b9abf54888d8f6c5043c");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDMask = ArrayConverter.hexStringToByteArray((String)"0d96ab624d082c71255be3648dcd303f6ab0ca61a95034a553e3308d1d3744e5");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientPWDPrivate = ArrayConverter.hexStringToByteArray((String)"171de8caa5352d36ee96a39979b5b72fa189ae7a6a09c77f7b438af16df4a88b");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultClientPWDMask = ArrayConverter.hexStringToByteArray((String)"4f745bdfc295d3b38429f7eb3025a48883728b07d88605c0ee202316a072d1bd");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultServerPWDSalt = ArrayConverter.hexStringToByteArray((String)"963c77cdc13a2a8d75cdddd1e0449929843711c21d47ce6e6383cdda37e47da3");
    private Boolean parseInvalidRecordsUnencrypted = false;
    private ECPointFormat defaultSelectedPointFormat = ECPointFormat.UNCOMPRESSED;
    private BigInteger defaultEsniClientPrivateKey = new BigInteger("191991257030464195512760799659436374116556484140110877679395918219072292938297573720808302564562486757422301181089761");
    private List<CipherSuite> clientSupportedEsniCiphersuites = new LinkedList<CipherSuite>();
    private List<NamedGroup> clientSupportedEsniNamedGroups = new LinkedList<NamedGroup>();
    private List<KeyShareEntry> esniServerKeyPairs = new LinkedList<KeyShareEntry>();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniClientNonce = ArrayConverter.hexStringToByteArray((String)"a7284c9a52f15c13644b947261774657");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniServerNonce = ArrayConverter.hexStringToByteArray((String)"00000000000000000000000000000000");
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniRecordBytes = ArrayConverter.hexStringToByteArray((String)"ff0100124b2a0024001d0020fa572d03e21e15f9ca1aa7fb85f61b9fc78458a78050ac581811863325944412000213010104000000005dcc3a45000000005dda12050000");
    private EsniDnsKeyRecordVersion defaultEsniRecordVersion = EsniVersion.DRAFT_2.getDnsKeyRecordVersion();
    @XmlJavaTypeAdapter(value=UnformattedByteArrayAdapter.class)
    private byte[] defaultEsniRecordChecksum = ArrayConverter.hexStringToByteArray((String)"00124b2a");
    private List<KeyShareStoreEntry> defaultEsniServerKeyShareEntries = new LinkedList<KeyShareStoreEntry>();
    private List<CipherSuite> defaultEsniServerCiphersuites = new LinkedList<CipherSuite>();
    private Integer defaultEsniPaddedLength = 260;
    private Long defaultEsniNotBefore = 1582655135231L;
    private Long defaultEsniNotAfter = 1585247135231L;
    private List<ExtensionType> defaultEsniExtensions = new LinkedList<ExtensionType>();
    private Boolean acceptOnlyFittingDtlsFragments = false;
    private Boolean acceptContentRewritingDtlsFragments = true;
    private boolean writeKeylogFile = false;
    private String keylogFilePath = null;

    public static Config createConfig() {
        if (DEFAULT_CONFIG_CACHE != null) {
            return DEFAULT_CONFIG_CACHE.getCachedCopy();
        }
        InputStream stream = Config.class.getResourceAsStream(DEFAULT_CONFIG_FILE);
        return ConfigIO.read(stream);
    }

    public static Config createConfig(File f) {
        return ConfigIO.read(f);
    }

    public static Config createConfig(InputStream stream) {
        Config config = ConfigIO.read(stream);
        try {
            stream.close();
        }
        catch (IOException ex) {
            LOGGER.warn("Could not close resource Stream!", (Throwable)ex);
            return ConfigIO.read(stream);
        }
        return config;
    }

    public static Config createEmptyConfig() {
        Config c = new Config();
        for (Field field : c.getClass().getDeclaredFields()) {
            if (field.getName().equals("LOGGER") || field.getType().isPrimitive() || field.getName().contains("Extension")) continue;
            field.setAccessible(true);
            try {
                field.set(c, null);
            }
            catch (IllegalAccessException e) {
                LOGGER.warn("Could not set field in Config!", (Throwable)e);
            }
        }
        return c;
    }

    Config() {
        Certificate cert;
        this.defaultClientConnection = new OutboundConnection("client", 443, "localhost");
        this.defaultServerConnection = new InboundConnection("server", 443, "localhost");
        this.workflowTraceType = WorkflowTraceType.HANDSHAKE;
        this.defaultEsniServerKeyShareEntries.add(new KeyShareStoreEntry(NamedGroup.ECDH_X25519, ArrayConverter.hexStringToByteArray((String)"fa572d03e21e15f9ca1aa7fb85f61b9fc78458a78050ac581811863325944412")));
        this.defaultEsniServerCiphersuites.add(CipherSuite.TLS_AES_128_GCM_SHA256);
        this.defaultClientSupportedSignatureAndHashAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultClientSupportedSignatureAndHashAlgorithms.addAll(SignatureAndHashAlgorithm.getImplemented());
        this.defaultClientSupportedCompressionMethods = new LinkedList<CompressionMethod>();
        this.defaultClientSupportedCompressionMethods.add(CompressionMethod.NULL);
        this.defaultServerSupportedCompressionMethods = new LinkedList<CompressionMethod>();
        this.defaultServerSupportedCompressionMethods.add(CompressionMethod.NULL);
        this.defaultClientSupportedCiphersuites = new LinkedList<CipherSuite>();
        this.defaultClientSupportedCiphersuites.addAll(CipherSuite.getImplemented());
        this.defaultServerSupportedCiphersuites = new LinkedList<CipherSuite>();
        this.defaultServerSupportedCiphersuites.addAll(CipherSuite.getImplemented());
        this.defaultClientNamedGroups = NamedGroup.getImplemented();
        this.defaultServerNamedGroups = NamedGroup.getImplemented();
        this.clientCertificateTypes = new LinkedList<ClientCertificateType>();
        this.clientCertificateTypes.add(ClientCertificateType.RSA_SIGN);
        this.supportedVersions = new LinkedList<ProtocolVersion>();
        this.supportedVersions.add(ProtocolVersion.TLS13);
        this.defaultTokenBindingKeyParameters = new LinkedList<TokenBindingKeyParameters>();
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.ECDSAP256);
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.RSA2048_PKCS1_5);
        this.defaultTokenBindingKeyParameters.add(TokenBindingKeyParameters.RSA2048_PSS);
        this.defaultServerSupportedSignatureAndHashAlgorithms = new LinkedList<SignatureAndHashAlgorithm>();
        this.defaultServerSupportedSignatureAndHashAlgorithms.addAll(SignatureAndHashAlgorithm.getImplemented());
        this.defaultServerSupportedPointFormats = new LinkedList<ECPointFormat>();
        this.defaultClientSupportedPointFormats = new LinkedList<ECPointFormat>();
        this.defaultServerSupportedPointFormats.add(ECPointFormat.UNCOMPRESSED);
        this.defaultClientSupportedPointFormats.add(ECPointFormat.UNCOMPRESSED);
        EllipticCurve curve = CurveFactory.getCurve(this.defaultSelectedNamedGroup);
        this.defaultClientEcPublicKey = curve.mult(this.defaultClientEcPrivateKey, curve.getBasePoint());
        this.defaultServerEcPublicKey = curve.mult(this.defaultServerEcPrivateKey, curve.getBasePoint());
        EllipticCurve secp256R1Curve = CurveFactory.getCurve(NamedGroup.SECP256R1);
        this.defaultTokenBindingECPublicKey = secp256R1Curve.mult(this.defaultTokenBindingEcPrivateKey, secp256R1Curve.getBasePoint());
        this.defaultServerPWDProtectPublicKey = curve.mult(this.defaultServerPWDProtectPrivateKey, curve.getBasePoint());
        this.secureRealTimeTransportProtocolProtectionProfiles = new LinkedList<SrtpProtectionProfiles>();
        this.secureRealTimeTransportProtocolProtectionProfiles.add(SrtpProtectionProfiles.SRTP_AES128_CM_HMAC_SHA1_80);
        this.secureRealTimeTransportProtocolProtectionProfiles.add(SrtpProtectionProfiles.SRTP_AES128_CM_HMAC_SHA1_32);
        this.secureRealTimeTransportProtocolProtectionProfiles.add(SrtpProtectionProfiles.SRTP_NULL_HMAC_SHA1_80);
        this.secureRealTimeTransportProtocolProtectionProfiles.add(SrtpProtectionProfiles.SRTP_NULL_HMAC_SHA1_32);
        this.certificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.certificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.certificateTypeDesiredTypes.add(CertificateType.X509);
        this.clientAuthzExtensionDataFormat = new LinkedList<AuthzDataFormat>();
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT_URL);
        this.clientAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION_URL);
        this.serverAuthzExtensionDataFormat = new LinkedList<AuthzDataFormat>();
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.X509_ATTR_CERT_URL);
        this.serverAuthzExtensionDataFormat.add(AuthzDataFormat.SAML_ASSERTION_URL);
        this.clientCertificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.clientCertificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.clientCertificateTypeDesiredTypes.add(CertificateType.X509);
        this.clientCertificateTypeDesiredTypes.add(CertificateType.RAW_PUBLIC_KEY);
        this.serverCertificateTypeDesiredTypes = new LinkedList<CertificateType>();
        this.serverCertificateTypeDesiredTypes.add(CertificateType.OPEN_PGP);
        this.serverCertificateTypeDesiredTypes.add(CertificateType.X509);
        this.serverCertificateTypeDesiredTypes.add(CertificateType.RAW_PUBLIC_KEY);
        this.cachedObjectList = new LinkedList<CachedObject>();
        this.trustedCaIndicationExtensionAuthorties = new LinkedList<TrustedAuthority>();
        this.statusRequestV2RequestList = new LinkedList<RequestItemV2>();
        this.outputFilters = new ArrayList<FilterType>();
        this.outputFilters.add(FilterType.DEFAULT);
        this.applyFiltersInPlace = false;
        this.filtersKeepUserSettings = true;
        this.defaultClientKeyShareEntries = new LinkedList<KeyShareStoreEntry>();
        this.defaultClientKeyShareEntries.add(new KeyShareStoreEntry(NamedGroup.ECDH_X25519, ArrayConverter.hexStringToByteArray((String)"2A981DB6CDD02A06C1763102C9E741365AC4E6F72B3176A6BD6A3523D3EC0F4C")));
        this.defaultServerKeyShareEntry = new KeyShareStoreEntry(NamedGroup.ECDH_X25519, ArrayConverter.hexStringToByteArray((String)"2A981DB6CDD02A06C1763102C9E741365AC4E6F72B3176A6BD6A3523D3EC0F4C"));
        this.pskKeyExchangeModes = new LinkedList<PskKeyExchangeMode>();
        this.pskKeyExchangeModes.add(PskKeyExchangeMode.PSK_KE);
        this.pskKeyExchangeModes.add(PskKeyExchangeMode.PSK_DHE_KE);
        this.defaultPskSets = new LinkedList<PskSet>();
        try {
            cert = Certificate.parse((InputStream)new ByteArrayInputStream(ArrayConverter.hexStringToByteArray((String)"0003970003943082039030820278A003020102020900A650C00794049FCD300D06092A864886F70D01010B0500305C310B30090603550406130241553113301106035504080C0A536F6D652D53746174653121301F060355040A0C18496E7465726E6574205769646769747320507479204C74643115301306035504030C0C544C532D41747461636B65723020170D3137303731333132353331385A180F32313137303631393132353331385A305C310B30090603550406130241553113301106035504080C0A536F6D652D53746174653121301F060355040A0C18496E7465726E6574205769646769747320507479204C74643115301306035504030C0C544C532D41747461636B657230820122300D06092A864886F70D01010105000382010F003082010A0282010100C8820D6C3CE84C8430F6835ABFC7D7A912E1664F44578751F376501A8C68476C3072D919C5D39BD0DBE080E71DB83BD4AB2F2F9BDE3DFFB0080F510A5F6929C196551F2B3C369BE051054C877573195558FD282035934DC86EDAB8D4B1B7F555E5B2FEE7275384A756EF86CB86793B5D1333F0973203CB96966766E655CD2CCCAE1940E4494B8E9FB5279593B75AFD0B378243E51A88F6EB88DEF522A8CD5C6C082286A04269A2879760FCBA45005D7F2672DD228809D47274F0FE0EA5531C2BD95366C05BF69EDC0F3C3189866EDCA0C57ADCCA93250AE78D9EACA0393A95FF9952FC47FB7679DD3803E6A7A6FA771861E3D99E4B551A4084668B111B7EEF7D0203010001A3533051301D0603551D0E04160414E7A92FE5543AEE2FF7592F800AC6E66541E3268B301F0603551D23041830168014E7A92FE5543AEE2FF7592F800AC6E66541E3268B300F0603551D130101FF040530030101FF300D06092A864886F70D01010B050003820101000D5C11E28CF19D1BC17E4FF543695168570AA7DB85B3ECB85405392A0EDAFE4F097EE4685B7285E3D9B869D23257161CA65E20B5E6A585D33DA5CD653AF81243318132C9F64A476EC08BA80486B3E439F765635A7EA8A969B3ABD8650036D74C5FC4A04589E9AC8DC3BE2708743A6CFE3B451E3740F735F156D6DC7FFC8A2C852CD4E397B942461C2FCA884C7AFB7EBEF7918D6AAEF1F0D257E959754C4665779FA0E3253EF2BEDBBD5BE5DA600A0A68E51D2D1C125C4E198669A6BC715E8F3884E9C3EFF39D40838ADA4B1F38313F6286AA395DC6DEA9DAF49396CF12EC47EFA7A0D3882F8B84D9AEEFFB252C6B81A566609605FBFD3F0D17E5B12401492A1A")));
        }
        catch (IOException ex) {
            throw new ConfigurationException("Could not create default config");
        }
        CustomRSAPrivateKey key = new CustomRSAPrivateKey(new BigInteger("25311792238044219946174684693224603884785773358330971609415825404567987089738069857630011723336937795827963868604847118759739071441983186580158833210553280838765514351236797316564714837320618887805126341832834827826790060810763662161735652692660340953325435378344445537136408926502767545150207605087601783216982476527090447255508303291994973748877217756699811604529317375418362425978959405980207726316912995165050065189202729278788324244413992973017231054259638764128689366135764356716715140925548909967670376902528818677308871053953559814432449223427664069339511214707847837366043835739060653160903099571514118172541"), new BigInteger("15874858421354831201422373086128612745111153124913833804748747602178280564406425154617488927847142136837462790351481317765255581632968169400556456985418488827925888221598273953686611745401672309465708043217648197631331184971921491765473252248751361737713587292004390571935209364268173007740802648762007661253254661694353602685239350183219876383969245059520622897526828073822681994419744648185400986499062312630392385618231497966730037670361639244062483305891646041343885072158127929403028249239589737831073084456798375448844113695963693837622356344855176327289719518978665114515326513514352049909912072269175924872321"));
        try {
            this.defaultExplicitCertificateKeyPair = new CertificateKeyPair(cert, key);
        }
        catch (IOException ex) {
            throw new ConfigurationException("Could not create default config", ex);
        }
    }

    public Boolean isAcceptOnlyFittingDtlsFragments() {
        return this.acceptOnlyFittingDtlsFragments;
    }

    public void setAcceptOnlyFittingDtlsFragments(Boolean acceptOnlyFittingDtlsFragments) {
        this.acceptOnlyFittingDtlsFragments = acceptOnlyFittingDtlsFragments;
    }

    public Boolean isAcceptContentRewritingDtlsFragments() {
        return this.acceptContentRewritingDtlsFragments;
    }

    public void setAcceptContentRewritingDtlsFragments(Boolean acceptContentRewritingDtlsFragments) {
        this.acceptContentRewritingDtlsFragments = acceptContentRewritingDtlsFragments;
    }

    public Boolean getReorderReceivedDtlsRecords() {
        return this.reorderReceivedDtlsRecords;
    }

    public void setReorderReceivedDtlsRecords(Boolean reorderReceivedDtlsRecords) {
        this.reorderReceivedDtlsRecords = reorderReceivedDtlsRecords;
    }

    public Config createCopy() {
        ByteArrayOutputStream stream = new ByteArrayOutputStream();
        ConfigIO.write(this, stream);
        return ConfigIO.read(new ByteArrayInputStream(stream.toByteArray()));
    }

    public CertificateType getDefaultSelectedServerCertificateType() {
        return this.defaultSelectedServerCertificateType;
    }

    public void setDefaultSelectedServerCertificateType(CertificateType defaultSelectedServerCertificateType) {
        this.defaultSelectedServerCertificateType = defaultSelectedServerCertificateType;
    }

    public CertificateType getDefaultSelectedClientCertificateType() {
        return this.defaultSelectedClientCertificateType;
    }

    public void setDefaultSelectedClientCertificateType(CertificateType defaultSelectedClientCertificateType) {
        this.defaultSelectedClientCertificateType = defaultSelectedClientCertificateType;
    }

    public ECPointFormat getDefaultSelectedPointFormat() {
        return this.defaultSelectedPointFormat;
    }

    public void setDefaultSelectedPointFormat(ECPointFormat defaultSelectedPointFormat) {
        this.defaultSelectedPointFormat = defaultSelectedPointFormat;
    }

    public Boolean getStopActionsAfterIOException() {
        return this.stopActionsAfterIOException;
    }

    public void setStopActionsAfterIOException(Boolean stopActionsAfterIOException) {
        this.stopActionsAfterIOException = stopActionsAfterIOException;
    }

    public Boolean getTls13BackwardsCompatibilityMode() {
        return this.tls13BackwardsCompatibilityMode;
    }

    public void setTls13BackwardsCompatibilityMode(Boolean tls13BackwardsCompatibilityMode) {
        this.tls13BackwardsCompatibilityMode = tls13BackwardsCompatibilityMode;
    }

    public long getSessionTicketLifetimeHint() {
        return this.sessionTicketLifetimeHint;
    }

    public void setSessionTicketLifetimeHint(long sessionTicketLifetimeHint) {
        this.sessionTicketLifetimeHint = sessionTicketLifetimeHint;
    }

    public byte[] getSessionTicketKeyAES() {
        return Arrays.copyOf(this.sessionTicketKeyAES, this.sessionTicketKeyAES.length);
    }

    public void setSessionTicketKeyAES(byte[] sessionTicketKeyAES) {
        this.sessionTicketKeyAES = sessionTicketKeyAES;
    }

    public byte[] getSessionTicketKeyHMAC() {
        return Arrays.copyOf(this.sessionTicketKeyHMAC, this.sessionTicketKeyHMAC.length);
    }

    public void setSessionTicketKeyHMAC(byte[] sessionTicketKeyHMAC) {
        this.sessionTicketKeyHMAC = sessionTicketKeyHMAC;
    }

    public byte[] getSessionTicketKeyName() {
        return Arrays.copyOf(this.sessionTicketKeyName, this.sessionTicketKeyName.length);
    }

    public void setSessionTicketKeyName(byte[] sessionTicketKeyName) {
        this.sessionTicketKeyName = sessionTicketKeyName;
    }

    public ClientAuthenticationType getClientAuthenticationType() {
        return this.clientAuthenticationType;
    }

    public void setClientAuthenticationType(ClientAuthenticationType clientAuthenticationType) {
        this.clientAuthenticationType = clientAuthenticationType;
    }

    public Boolean isHttpsParsingEnabled() {
        return this.httpsParsingEnabled;
    }

    public void setHttpsParsingEnabled(Boolean httpsParsingEnabled) {
        this.httpsParsingEnabled = httpsParsingEnabled;
    }

    public Boolean isUseFreshRandom() {
        return this.useFreshRandom;
    }

    public void setUseFreshRandom(Boolean useFreshRandom) {
        this.useFreshRandom = useFreshRandom;
    }

    public Boolean isParseKeyShareOld() {
        return this.parseKeyShareOld;
    }

    public void setParseKeyShareOld(boolean parseKeyShareOld) {
        this.parseKeyShareOld = parseKeyShareOld;
    }

    public Boolean isUseAllProvidedRecords() {
        return this.useAllProvidedRecords;
    }

    public void setUseAllProvidedRecords(Boolean useAllProvidedRecords) {
        this.useAllProvidedRecords = useAllProvidedRecords;
    }

    public byte[] getDefaultServerRenegotiationInfo() {
        return Arrays.copyOf(this.defaultServerRenegotiationInfo, this.defaultServerRenegotiationInfo.length);
    }

    public void setDefaultServerRenegotiationInfo(byte[] defaultServerRenegotiationInfo) {
        this.defaultServerRenegotiationInfo = defaultServerRenegotiationInfo;
    }

    public ChooserType getChooserType() {
        return this.chooserType;
    }

    public void setChooserType(ChooserType chooserType) {
        this.chooserType = chooserType;
    }

    public Boolean isEarlyStop() {
        return this.earlyStop;
    }

    public void setEarlyStop(Boolean earlyStop) {
        this.earlyStop = earlyStop;
    }

    public Point getDefaultTokenBindingECPublicKey() {
        return this.defaultTokenBindingECPublicKey;
    }

    public void setDefaultTokenBindingECPublicKey(Point defaultTokenBindingECPublicKey) {
        this.defaultTokenBindingECPublicKey = defaultTokenBindingECPublicKey;
    }

    public BigInteger getDefaultTokenBindingRsaPublicKey() {
        return this.defaultTokenBindingRsaPublicKey;
    }

    public void setDefaultTokenBindingRsaPublicKey(BigInteger defaultTokenBindingRsaPublicKey) {
        this.defaultTokenBindingRsaPublicKey = defaultTokenBindingRsaPublicKey;
    }

    public BigInteger getDefaultTokenBindingRsaPrivateKey() {
        return this.defaultTokenBindingRsaPrivateKey;
    }

    public void setDefaultTokenBindingRsaPrivateKey(BigInteger defaultTokenBindingRsaPrivateKey) {
        this.defaultTokenBindingRsaPrivateKey = defaultTokenBindingRsaPrivateKey;
    }

    public BigInteger getDefaultTokenBindingEcPrivateKey() {
        return this.defaultTokenBindingEcPrivateKey;
    }

    public void setDefaultTokenBindingEcPrivateKey(BigInteger defaultTokenBindingEcPrivateKey) {
        this.defaultTokenBindingEcPrivateKey = defaultTokenBindingEcPrivateKey;
    }

    public BigInteger getDefaultTokenBindingRsaModulus() {
        return this.defaultTokenBindingRsaModulus;
    }

    public void setDefaultTokenBindingRsaModulus(BigInteger defaultTokenBindingRsaModulus) {
        this.defaultTokenBindingRsaModulus = defaultTokenBindingRsaModulus;
    }

    public TokenBindingType getDefaultTokenBindingType() {
        return this.defaultTokenBindingType;
    }

    public void setDefaultTokenBindingType(TokenBindingType defaultTokenBindingType) {
        this.defaultTokenBindingType = defaultTokenBindingType;
    }

    public byte[] getDefaultClientHandshakeTrafficSecret() {
        return Arrays.copyOf(this.defaultClientHandshakeTrafficSecret, this.defaultClientHandshakeTrafficSecret.length);
    }

    public void setDefaultClientHandshakeTrafficSecret(byte[] defaultClientHandshakeTrafficSecret) {
        this.defaultClientHandshakeTrafficSecret = defaultClientHandshakeTrafficSecret;
    }

    public byte[] getDefaultServerHandshakeTrafficSecret() {
        return Arrays.copyOf(this.defaultServerHandshakeTrafficSecret, this.defaultServerHandshakeTrafficSecret.length);
    }

    public void setDefaultServerHandshakeTrafficSecret(byte[] defaultServerHandshakeTrafficSecret) {
        this.defaultServerHandshakeTrafficSecret = defaultServerHandshakeTrafficSecret;
    }

    public byte[] getDefaultCertificateRequestContext() {
        return Arrays.copyOf(this.defaultCertificateRequestContext, this.defaultCertificateRequestContext.length);
    }

    public void setDefaultCertificateRequestContext(byte[] defaultCertificateRequestContext) {
        this.defaultCertificateRequestContext = defaultCertificateRequestContext;
    }

    public Boolean isWorkflowExecutorShouldOpen() {
        return this.workflowExecutorShouldOpen;
    }

    public void setWorkflowExecutorShouldOpen(Boolean workflowExecutorShouldOpen) {
        this.workflowExecutorShouldOpen = workflowExecutorShouldOpen;
    }

    public Boolean isWorkflowExecutorShouldClose() {
        return this.workflowExecutorShouldClose;
    }

    public void setWorkflowExecutorShouldClose(Boolean workflowExecutorShouldClose) {
        this.workflowExecutorShouldClose = workflowExecutorShouldClose;
    }

    public Boolean isStopReceivingAfterFatal() {
        return this.stopReceivingAfterFatal;
    }

    public void setStopReceivingAfterFatal(Boolean stopReceivingAfterFatal) {
        this.stopReceivingAfterFatal = stopReceivingAfterFatal;
    }

    public byte[] getDefaultPSKKey() {
        return Arrays.copyOf(this.defaultPSKKey, this.defaultPSKKey.length);
    }

    public void setDefaultPSKKey(byte[] defaultPSKKey) {
        this.defaultPSKKey = defaultPSKKey;
    }

    public byte[] getDefaultPSKIdentity() {
        return Arrays.copyOf(this.defaultPSKIdentity, this.defaultPSKIdentity.length);
    }

    public void setDefaultPSKIdentity(byte[] defaultPSKIdentity) {
        this.defaultPSKIdentity = defaultPSKIdentity;
    }

    public byte[] getDefaultPSKIdentityHint() {
        return Arrays.copyOf(this.defaultPSKIdentityHint, this.defaultPSKIdentityHint.length);
    }

    public void setDefaultPSKIdentityHint(byte[] defaultPSKIdentityHint) {
        this.defaultPSKIdentityHint = defaultPSKIdentityHint;
    }

    public BigInteger getDefaultSRPModulus() {
        return this.defaultSRPModulus;
    }

    public void setDefaultSRPModulus(BigInteger defaultSRPModulus) {
        this.defaultSRPModulus = defaultSRPModulus;
    }

    public BigInteger getDefaultPSKModulus() {
        return this.defaultPSKModulus;
    }

    public void setDefaultPSKModulus(BigInteger defaultPSKModulus) {
        this.defaultPSKModulus = defaultPSKModulus;
    }

    public BigInteger getDefaultPSKServerPrivateKey() {
        return this.defaultPskDhServerPrivateKey;
    }

    public void setDefaultPSKServerPrivateKey(BigInteger defaultPskDhServerPrivateKey) {
        this.defaultPskDhServerPrivateKey = defaultPskDhServerPrivateKey;
    }

    public BigInteger getDefaultPSKServerPublicKey() {
        return this.defaultPskDhServerPublicKey;
    }

    public void setDefaultPSKServerPublicKey(BigInteger defaultPskDhServerPublicKey) {
        this.defaultPskDhServerPublicKey = defaultPskDhServerPublicKey;
    }

    public BigInteger getDefaultPSKGenerator() {
        return this.defaultPSKGenerator;
    }

    public void setDefaultPSKGenerator(BigInteger defaultPSKGenerator) {
        this.defaultPSKGenerator = defaultPSKGenerator;
    }

    public BigInteger getDefaultSRPServerPrivateKey() {
        return this.defaultSRPServerPrivateKey;
    }

    public void setDefaultSRPServerPrivateKey(BigInteger defaultSRPServerPrivateKey) {
        this.defaultSRPServerPrivateKey = defaultSRPServerPrivateKey;
    }

    public BigInteger getDefaultSRPServerPublicKey() {
        return this.defaultSRPServerPublicKey;
    }

    public void setDefaultSRPServerPublicKey(BigInteger defaultSRPServerPublicKey) {
        this.defaultSRPServerPublicKey = defaultSRPServerPublicKey;
    }

    public BigInteger getDefaultSRPClientPrivateKey() {
        return this.defaultSRPClientPrivateKey;
    }

    public void setDefaultSRPClientPrivateKey(BigInteger defaultSRPClientPrivateKey) {
        this.defaultSRPClientPrivateKey = defaultSRPClientPrivateKey;
    }

    public BigInteger getDefaultSRPClientPublicKey() {
        return this.defaultSRPClientPublicKey;
    }

    public void setDefaultSRPClientPublicKey(BigInteger defaultSRPClientPublicKey) {
        this.defaultSRPClientPublicKey = defaultSRPClientPublicKey;
    }

    public BigInteger getDefaultSRPGenerator() {
        return this.defaultSRPGenerator;
    }

    public void setDefaultSRPGenerator(BigInteger defaultSRPGenerator) {
        this.defaultSRPGenerator = defaultSRPGenerator;
    }

    public byte[] getDefaultSRPServerSalt() {
        return Arrays.copyOf(this.defaultSRPServerSalt, this.defaultSRPServerSalt.length);
    }

    public void setDefaultSRPServerSalt(byte[] defaultSRPServerSalt) {
        this.defaultSRPServerSalt = defaultSRPServerSalt;
    }

    public byte[] getDefaultSRPIdentity() {
        return Arrays.copyOf(this.defaultSRPIdentity, this.defaultSRPIdentity.length);
    }

    public void setDefaultSRPIdentity(byte[] defaultSRPIdentity) {
        this.defaultSRPIdentity = defaultSRPIdentity;
    }

    public byte[] getDefaultSRPPassword() {
        return Arrays.copyOf(this.defaultSRPPassword, this.defaultSRPPassword.length);
    }

    public void setDefaultSRPPassword(byte[] defaultSRPPassword) {
        this.defaultSRPPassword = defaultSRPPassword;
    }

    public BigInteger getDefaultClientRSAPrivateKey() {
        return this.defaultClientRSAPrivateKey;
    }

    public void setDefaultClientRSAPrivateKey(BigInteger defaultClientRSAPrivateKey) {
        this.defaultClientRSAPrivateKey = defaultClientRSAPrivateKey;
    }

    public BigInteger getDefaultServerRSAPrivateKey() {
        return this.defaultServerRSAPrivateKey;
    }

    public void setDefaultServerRSAPrivateKey(BigInteger defaultServerRSAPrivateKey) {
        this.defaultServerRSAPrivateKey = defaultServerRSAPrivateKey;
    }

    public BigInteger getDefaultServerRSAModulus() {
        return this.defaultServerRSAModulus;
    }

    public void setDefaultServerRSAModulus(BigInteger defaultServerRSAModulus) {
        if (defaultServerRSAModulus.signum() != 1) {
            throw new IllegalArgumentException("Modulus cannot be negative or zero" + defaultServerRSAModulus.toString());
        }
        this.defaultServerRSAModulus = defaultServerRSAModulus;
    }

    public BigInteger getDefaultServerRSAPublicKey() {
        return this.defaultServerRSAPublicKey;
    }

    public void setDefaultServerRSAPublicKey(BigInteger defaultServerRSAPublicKey) {
        this.defaultServerRSAPublicKey = defaultServerRSAPublicKey;
    }

    public BigInteger getDefaultClientRSAPublicKey() {
        return this.defaultClientRSAPublicKey;
    }

    public void setDefaultClientRSAPublicKey(BigInteger defaultClientRSAPublicKey) {
        this.defaultClientRSAPublicKey = defaultClientRSAPublicKey;
    }

    public BigInteger getDefaultServerEcPrivateKey() {
        return this.defaultServerEcPrivateKey;
    }

    public void setDefaultServerEcPrivateKey(BigInteger defaultServerEcPrivateKey) {
        this.defaultServerEcPrivateKey = defaultServerEcPrivateKey;
    }

    public BigInteger getDefaultClientEcPrivateKey() {
        return this.defaultClientEcPrivateKey;
    }

    public void setDefaultClientEcPrivateKey(BigInteger defaultClientEcPrivateKey) {
        this.defaultClientEcPrivateKey = defaultClientEcPrivateKey;
    }

    public Point getDefaultClientEcPublicKey() {
        return this.defaultClientEcPublicKey;
    }

    public void setDefaultClientEcPublicKey(Point defaultClientEcPublicKey) {
        this.defaultClientEcPublicKey = defaultClientEcPublicKey;
    }

    public Point getDefaultServerEcPublicKey() {
        return this.defaultServerEcPublicKey;
    }

    public void setDefaultServerEcPublicKey(Point defaultServerEcPublicKey) {
        this.defaultServerEcPublicKey = defaultServerEcPublicKey;
    }

    public AlertDescription getDefaultAlertDescription() {
        return this.defaultAlertDescription;
    }

    public void setDefaultAlertDescription(AlertDescription defaultAlertDescription) {
        this.defaultAlertDescription = defaultAlertDescription;
    }

    public AlertLevel getDefaultAlertLevel() {
        return this.defaultAlertLevel;
    }

    public void setDefaultAlertLevel(AlertLevel defaultAlertLevel) {
        this.defaultAlertLevel = defaultAlertLevel;
    }

    public BigInteger getDefaultServerDhPublicKey() {
        return this.defaultServerDhPublicKey;
    }

    public void setDefaultServerDhPublicKey(BigInteger defaultServerDhPublicKey) {
        this.defaultServerDhPublicKey = defaultServerDhPublicKey;
    }

    public BigInteger getDefaultClientDhPublicKey() {
        return this.defaultClientDhPublicKey;
    }

    public void setDefaultClientDhPublicKey(BigInteger defaultClientDhPublicKey) {
        this.defaultClientDhPublicKey = defaultClientDhPublicKey;
    }

    public BigInteger getDefaultServerDhPrivateKey() {
        return this.defaultServerDhPrivateKey;
    }

    public void setDefaultServerDhPrivateKey(BigInteger defaultServerDhPrivateKey) {
        this.defaultServerDhPrivateKey = defaultServerDhPrivateKey;
    }

    public GOSTCurve getDefaultSelectedGostCurve() {
        return this.defaultSelectedGostCurve;
    }

    public void setDefaultSelectedGostCurve(GOSTCurve defaultSelectedGostCurve) {
        this.defaultSelectedGostCurve = defaultSelectedGostCurve;
    }

    public BigInteger getDefaultServerDsaPrivateKey() {
        return this.defaultServerDsaPrivateKey;
    }

    public void setDefaultServerDsaPrivateKey(BigInteger defaultServerDsaPrivateKey) {
        this.defaultServerDsaPrivateKey = defaultServerDsaPrivateKey;
    }

    public PRFAlgorithm getDefaultPRFAlgorithm() {
        return this.defaultPRFAlgorithm;
    }

    public void setDefaultPRFAlgorithm(PRFAlgorithm defaultPRFAlgorithm) {
        this.defaultPRFAlgorithm = defaultPRFAlgorithm;
    }

    public byte[] getDtlsDefaultCookie() {
        return Arrays.copyOf(this.dtlsDefaultCookie, this.dtlsDefaultCookie.length);
    }

    public void setDtlsDefaultCookie(byte[] defaultDtlsCookie) {
        this.dtlsDefaultCookie = defaultDtlsCookie;
    }

    public Integer getDtlsDefaultCookieLength() {
        return this.dtlsDefaultCookieLength;
    }

    public void setDtlsDefaultCookieLength(Integer dtlsDefaultCookieLength) {
        this.dtlsDefaultCookieLength = dtlsDefaultCookieLength;
    }

    public Integer getDtlsMaximumFragmentLength() {
        return this.dtlsMaximumFragmentLength;
    }

    public void setDtlsMaximumFragmentLength(Integer dtlsMaximumFragmentLength) {
        this.dtlsMaximumFragmentLength = dtlsMaximumFragmentLength;
    }

    public byte[] getDefaultClientSessionId() {
        return Arrays.copyOf(this.defaultClientSessionId, this.defaultClientSessionId.length);
    }

    public void setDefaultClientSessionId(byte[] defaultClientSessionId) {
        this.defaultClientSessionId = defaultClientSessionId;
    }

    public byte[] getDefaultServerSessionId() {
        return Arrays.copyOf(this.defaultServerSessionId, this.defaultServerSessionId.length);
    }

    public void setDefaultServerSessionId(byte[] defaultServerSessionId) {
        this.defaultServerSessionId = defaultServerSessionId;
    }

    public CompressionMethod getDefaultSelectedCompressionMethod() {
        return this.defaultSelectedCompressionMethod;
    }

    public void setDefaultSelectedCompressionMethod(CompressionMethod defaultSelectedCompressionMethod) {
        this.defaultSelectedCompressionMethod = defaultSelectedCompressionMethod;
    }

    public boolean isAddExtendedRandomExtension() {
        return this.addExtendedRandomExtension;
    }

    public void setAddExtendedRandomExtension(boolean addExtendedRandomExtension) {
        this.addExtendedRandomExtension = addExtendedRandomExtension;
    }

    public byte[] getDefaultClientExtendedRandom() {
        return Arrays.copyOf(this.defaultClientExtendedRandom, this.defaultClientExtendedRandom.length);
    }

    public byte[] getDefaultServerExtendedRandom() {
        return Arrays.copyOf(this.defaultServerExtendedRandom, this.defaultServerExtendedRandom.length);
    }

    public void setDefaultClientExtendedRandom(byte[] defaultClientExtendedRandom) {
        this.defaultClientExtendedRandom = defaultClientExtendedRandom;
    }

    public void setDefaultServerExtendedRandom(byte[] defaultServerExtendedRandom) {
        this.defaultServerExtendedRandom = defaultServerExtendedRandom;
    }

    public byte[] getDefaultServerRandom() {
        return Arrays.copyOf(this.defaultServerRandom, this.defaultServerRandom.length);
    }

    public void setDefaultServerRandom(byte[] defaultServerRandom) {
        this.defaultServerRandom = defaultServerRandom;
    }

    public byte[] getDefaultClientRandom() {
        return Arrays.copyOf(this.defaultClientRandom, this.defaultClientRandom.length);
    }

    public void setDefaultClientRandom(byte[] defaultClientRandom) {
        this.defaultClientRandom = defaultClientRandom;
    }

    public byte[] getDefaultPreMasterSecret() {
        return Arrays.copyOf(this.defaultPreMasterSecret, this.defaultPreMasterSecret.length);
    }

    public void setDefaultPreMasterSecret(byte[] defaultPreMasterSecret) {
        this.defaultPreMasterSecret = defaultPreMasterSecret;
    }

    public byte[] getDefaultMasterSecret() {
        return Arrays.copyOf(this.defaultMasterSecret, this.defaultMasterSecret.length);
    }

    public void setDefaultMasterSecret(byte[] defaultMasterSecret) {
        this.defaultMasterSecret = defaultMasterSecret;
    }

    public ProtocolVersion getDefaultHighestClientProtocolVersion() {
        return this.defaultHighestClientProtocolVersion;
    }

    public void setDefaultHighestClientProtocolVersion(ProtocolVersion defaultHighestClientProtocolVersion) {
        this.defaultHighestClientProtocolVersion = defaultHighestClientProtocolVersion;
    }

    public ProtocolVersion getDefaultSelectedProtocolVersion() {
        return this.defaultSelectedProtocolVersion;
    }

    public void setDefaultSelectedProtocolVersion(ProtocolVersion defaultSelectedProtocolVersion) {
        this.defaultSelectedProtocolVersion = defaultSelectedProtocolVersion;
    }

    public List<SignatureAndHashAlgorithm> getDefaultServerSupportedSignatureAndHashAlgorithms() {
        return this.defaultServerSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultServerSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> defaultServerSupportedSignatureAndHashAlgorithms) {
        this.defaultServerSupportedSignatureAndHashAlgorithms = defaultServerSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultServerSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... defaultServerSupportedSignatureAndHashAlgorithms) {
        this.defaultServerSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(defaultServerSupportedSignatureAndHashAlgorithms));
    }

    public List<CipherSuite> getDefaultServerSupportedCiphersuites() {
        return this.defaultServerSupportedCiphersuites;
    }

    public void setDefaultServerSupportedCiphersuites(List<CipherSuite> defaultServerSupportedCiphersuites) {
        this.defaultServerSupportedCiphersuites = defaultServerSupportedCiphersuites;
    }

    public final void setDefaultServerSupportedCiphersuites(CipherSuite ... defaultServerSupportedCiphersuites) {
        this.defaultServerSupportedCiphersuites = new ArrayList<CipherSuite>(Arrays.asList(defaultServerSupportedCiphersuites));
    }

    public List<CompressionMethod> getDefaultClientSupportedCompressionMethods() {
        return this.defaultClientSupportedCompressionMethods;
    }

    public void setDefaultClientSupportedCompressionMethods(List<CompressionMethod> defaultClientSupportedCompressionMethods) {
        this.defaultClientSupportedCompressionMethods = defaultClientSupportedCompressionMethods;
    }

    public final void setDefaultClientSupportedCompressionMethods(CompressionMethod ... defaultClientSupportedCompressionMethods) {
        this.defaultClientSupportedCompressionMethods = new ArrayList<CompressionMethod>(Arrays.asList(defaultClientSupportedCompressionMethods));
    }

    public HeartbeatMode getDefaultHeartbeatMode() {
        return this.defaultHeartbeatMode;
    }

    public void setDefaultHeartbeatMode(HeartbeatMode defaultHeartbeatMode) {
        this.defaultHeartbeatMode = defaultHeartbeatMode;
    }

    public MaxFragmentLength getDefaultMaxFragmentLength() {
        return this.defaultMaxFragmentLength;
    }

    public void setDefaultMaxFragmentLength(MaxFragmentLength defaultMaxFragmentLength) {
        this.defaultMaxFragmentLength = defaultMaxFragmentLength;
    }

    public SignatureAndHashAlgorithm getDefaultSelectedSignatureAndHashAlgorithm() {
        return this.defaultSelectedSignatureAndHashAlgorithm;
    }

    public void setDefaultSelectedSignatureAndHashAlgorithm(SignatureAndHashAlgorithm defaultSelectedSignatureAndHashAlgorithm) {
        this.defaultSelectedSignatureAndHashAlgorithm = defaultSelectedSignatureAndHashAlgorithm;
    }

    public List<ECPointFormat> getDefaultClientSupportedPointFormats() {
        return this.defaultClientSupportedPointFormats;
    }

    public void setDefaultClientSupportedPointFormats(List<ECPointFormat> defaultClientSupportedPointFormats) {
        this.defaultClientSupportedPointFormats = defaultClientSupportedPointFormats;
    }

    public final void setDefaultClientSupportedPointFormats(ECPointFormat ... defaultClientSupportedPointFormats) {
        this.defaultClientSupportedPointFormats = new ArrayList<ECPointFormat>(Arrays.asList(defaultClientSupportedPointFormats));
    }

    public ProtocolVersion getDefaultLastRecordProtocolVersion() {
        return this.defaultLastRecordProtocolVersion;
    }

    public void setDefaultLastRecordProtocolVersion(ProtocolVersion defaultLastRecordProtocolVersion) {
        this.defaultLastRecordProtocolVersion = defaultLastRecordProtocolVersion;
    }

    public List<SNIEntry> getDefaultClientSNIEntryList() {
        return this.defaultClientSNIEntryList;
    }

    public void setDefaultClientSNIEntryList(List<SNIEntry> defaultClientSNIEntryList) {
        this.defaultClientSNIEntryList = defaultClientSNIEntryList;
    }

    public final void setDefaultClientSNIEntries(SNIEntry ... defaultClientSNIEntryList) {
        this.defaultClientSNIEntryList = new ArrayList<SNIEntry>(Arrays.asList(defaultClientSNIEntryList));
    }

    public List<ECPointFormat> getDefaultServerSupportedPointFormats() {
        return this.defaultServerSupportedPointFormats;
    }

    public void setDefaultServerSupportedPointFormats(List<ECPointFormat> defaultServerSupportedPointFormats) {
        this.defaultServerSupportedPointFormats = defaultServerSupportedPointFormats;
    }

    public final void setDefaultServerSupportedPointFormats(ECPointFormat ... defaultServerSupportedPointFormats) {
        this.defaultServerSupportedPointFormats = new ArrayList<ECPointFormat>(Arrays.asList(defaultServerSupportedPointFormats));
    }

    public List<NamedGroup> getDefaultClientNamedGroups() {
        return this.defaultClientNamedGroups;
    }

    public void setDefaultClientNamedGroups(List<NamedGroup> defaultClientNamedGroups) {
        this.defaultClientNamedGroups = defaultClientNamedGroups;
    }

    public final void setDefaultClientNamedGroups(NamedGroup ... defaultClientNamedGroups) {
        this.defaultClientNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(defaultClientNamedGroups));
    }

    public List<NamedGroup> getDefaultServerNamedGroups() {
        return this.defaultServerNamedGroups;
    }

    public void setDefaultServerNamedGroups(List<NamedGroup> defaultServerNamedGroups) {
        this.defaultServerNamedGroups = defaultServerNamedGroups;
    }

    public final void setDefaultServerNamedGroups(NamedGroup ... defaultServerNamedGroups) {
        this.defaultServerNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(defaultServerNamedGroups));
    }

    public CipherSuite getDefaultSelectedCipherSuite() {
        return this.defaultSelectedCipherSuite;
    }

    public void setDefaultSelectedCipherSuite(CipherSuite defaultSelectedCipherSuite) {
        this.defaultSelectedCipherSuite = defaultSelectedCipherSuite;
    }

    public SSL2CipherSuite getDefaultSSL2CipherSuite() {
        return this.defaultSSL2CipherSuite;
    }

    public void setDefaultSSL2CipherSuite(SSL2CipherSuite defaultSSL2CipherSuite) {
        this.defaultSSL2CipherSuite = defaultSSL2CipherSuite;
    }

    public Boolean isQuickReceive() {
        return this.quickReceive;
    }

    public void setQuickReceive(Boolean quickReceive) {
        this.quickReceive = quickReceive;
    }

    public Boolean isResetWorkflowtracesBeforeSaving() {
        return this.resetWorkflowtracesBeforeSaving;
    }

    public void setResetWorkflowtracesBeforeSaving(Boolean resetWorkflowtracesBeforeSaving) {
        this.resetWorkflowtracesBeforeSaving = resetWorkflowtracesBeforeSaving;
    }

    public RecordLayerType getRecordLayerType() {
        return this.recordLayerType;
    }

    public void setRecordLayerType(RecordLayerType recordLayerType) {
        this.recordLayerType = recordLayerType;
    }

    public Boolean isFlushOnMessageTypeChange() {
        return this.flushOnMessageTypeChange;
    }

    public void setFlushOnMessageTypeChange(Boolean flushOnMessageTypeChange) {
        this.flushOnMessageTypeChange = flushOnMessageTypeChange;
    }

    public Boolean isCreateRecordsDynamically() {
        return this.createRecordsDynamically;
    }

    public void setCreateRecordsDynamically(Boolean createRecordsDynamically) {
        this.createRecordsDynamically = createRecordsDynamically;
    }

    public Boolean isCreateIndividualRecords() {
        return this.createIndividualRecords;
    }

    public void setCreateIndividualRecords(Boolean createIndividualRecords) {
        this.createIndividualRecords = createIndividualRecords;
    }

    public int getDefaultMaxRecordData() {
        return this.defaultMaxRecordData;
    }

    public void setDefaultMaxRecordData(int defaultMaxRecordData) {
        if (defaultMaxRecordData == 0) {
            LOGGER.warn("defaultMaxRecordData is being set to 0");
        }
        this.defaultMaxRecordData = defaultMaxRecordData;
    }

    public WorkflowExecutorType getWorkflowExecutorType() {
        return this.workflowExecutorType;
    }

    public void setWorkflowExecutorType(WorkflowExecutorType workflowExecutorType) {
        this.workflowExecutorType = workflowExecutorType;
    }

    public NameType getSniType() {
        return this.sniType;
    }

    public void setSniType(NameType sniType) {
        this.sniType = sniType;
    }

    public int getHeartbeatPayloadLength() {
        return this.heartbeatPayloadLength;
    }

    public void setHeartbeatPayloadLength(int heartbeatPayloadLength) {
        this.heartbeatPayloadLength = heartbeatPayloadLength;
    }

    public int getHeartbeatPaddingLength() {
        return this.heartbeatPaddingLength;
    }

    public void setHeartbeatPaddingLength(int heartbeatPaddingLength) {
        this.heartbeatPaddingLength = heartbeatPaddingLength;
    }

    public Boolean isAddPaddingExtension() {
        return this.addPaddingExtension;
    }

    public void setAddPaddingExtension(Boolean addPaddingExtension) {
        this.addPaddingExtension = addPaddingExtension;
    }

    public Boolean isAddExtendedMasterSecretExtension() {
        return this.addExtendedMasterSecretExtension;
    }

    public void setAddExtendedMasterSecretExtension(Boolean addExtendedMasterSecretExtension) {
        this.addExtendedMasterSecretExtension = addExtendedMasterSecretExtension;
    }

    public Boolean isAddSessionTicketTLSExtension() {
        return this.addSessionTicketTLSExtension;
    }

    public void setAddSessionTicketTLSExtension(Boolean addSessionTicketTLSExtension) {
        this.addSessionTicketTLSExtension = addSessionTicketTLSExtension;
    }

    public byte[] getDefaultPaddingExtensionBytes() {
        return Arrays.copyOf(this.defaultPaddingExtensionBytes, this.defaultPaddingExtensionBytes.length);
    }

    public void setDefaultPaddingExtensionBytes(byte[] defaultPaddingExtensionBytes) {
        this.defaultPaddingExtensionBytes = defaultPaddingExtensionBytes;
    }

    public List<ClientCertificateType> getClientCertificateTypes() {
        return this.clientCertificateTypes;
    }

    public void setClientCertificateTypes(List<ClientCertificateType> clientCertificateTypes) {
        this.clientCertificateTypes = clientCertificateTypes;
    }

    public final void setClientCertificateTypes(ClientCertificateType ... clientCertificateTypes) {
        this.clientCertificateTypes = new ArrayList<ClientCertificateType>(Arrays.asList(clientCertificateTypes));
    }

    public String getDefaultApplicationMessageData() {
        return this.defaultApplicationMessageData;
    }

    public void setDefaultApplicationMessageData(String defaultApplicationMessageData) {
        this.defaultApplicationMessageData = defaultApplicationMessageData;
    }

    public Boolean isEnforceSettings() {
        return this.enforceSettings;
    }

    public void setEnforceSettings(Boolean enforceSettings) {
        this.enforceSettings = enforceSettings;
    }

    public BigInteger getDefaultServerDhGenerator() {
        return this.defaultServerDhGenerator;
    }

    public void setDefaultServerDhGenerator(BigInteger defaultServerDhGenerator) {
        this.defaultServerDhGenerator = defaultServerDhGenerator;
    }

    public BigInteger getDefaultServerDhModulus() {
        return this.defaultServerDhModulus;
    }

    public void setDefaultServerDhModulus(BigInteger defaultServerDhModulus) {
        if (defaultServerDhModulus.signum() != 1) {
            throw new IllegalArgumentException("Modulus cannot be negative or zero:" + defaultServerDhModulus.toString());
        }
        this.defaultServerDhModulus = defaultServerDhModulus;
    }

    public BigInteger getDefaultClientDhPrivateKey() {
        return this.defaultClientDhPrivateKey;
    }

    public void setDefaultClientDhPrivateKey(BigInteger defaultClientDhPrivateKey) {
        this.defaultClientDhPrivateKey = defaultClientDhPrivateKey;
    }

    public byte[] getDistinguishedNames() {
        return Arrays.copyOf(this.distinguishedNames, this.distinguishedNames.length);
    }

    public void setDistinguishedNames(byte[] distinguishedNames) {
        this.distinguishedNames = distinguishedNames;
    }

    public ProtocolVersion getHighestProtocolVersion() {
        return this.highestProtocolVersion;
    }

    public void setHighestProtocolVersion(ProtocolVersion highestProtocolVersion) {
        this.highestProtocolVersion = highestProtocolVersion;
    }

    public Boolean isUpdateTimestamps() {
        return this.updateTimestamps;
    }

    public void setUpdateTimestamps(Boolean updateTimestamps) {
        this.updateTimestamps = updateTimestamps;
    }

    public Boolean isServerSendsApplicationData() {
        return this.serverSendsApplicationData;
    }

    public void setServerSendsApplicationData(Boolean serverSendsApplicationData) {
        this.serverSendsApplicationData = serverSendsApplicationData;
    }

    public WorkflowTraceType getWorkflowTraceType() {
        return this.workflowTraceType;
    }

    public void setWorkflowTraceType(WorkflowTraceType workflowTraceType) {
        this.workflowTraceType = workflowTraceType;
    }

    public String getWorkflowOutput() {
        return this.workflowOutput;
    }

    public void setWorkflowOutput(String workflowOutput) {
        this.workflowOutput = workflowOutput;
    }

    public String getConfigOutput() {
        return this.configOutput;
    }

    public void setConfigOutput(String configOutput) {
        this.configOutput = configOutput;
    }

    public String getWorkflowInput() {
        return this.workflowInput;
    }

    public void setWorkflowInput(String workflowInput) {
        this.workflowInput = workflowInput;
    }

    public MaxFragmentLength getMaxFragmentLength() {
        return this.maxFragmentLength;
    }

    public void setMaxFragmentLength(MaxFragmentLength maxFragmentLengthConfig) {
        this.maxFragmentLength = maxFragmentLengthConfig;
    }

    public NamedGroup getDefaultSelectedNamedGroup() {
        return this.defaultSelectedNamedGroup;
    }

    public void setDefaultSelectedNamedGroup(NamedGroup defaultSelectedNamedGroup) {
        this.defaultSelectedNamedGroup = defaultSelectedNamedGroup;
    }

    public Boolean isDynamicWorkflow() {
        throw new UnsupportedOperationException("DynamicWorkflow is currently not supported.");
    }

    public void setDynamicWorkflow(Boolean dynamicWorkflow) {
        throw new UnsupportedOperationException("DynamicWorkflow is currently not supported.");
    }

    public List<CipherSuite> getDefaultClientSupportedCiphersuites() {
        return this.defaultClientSupportedCiphersuites;
    }

    public void setDefaultClientSupportedCiphersuites(List<CipherSuite> defaultClientSupportedCiphersuites) {
        this.defaultClientSupportedCiphersuites = defaultClientSupportedCiphersuites;
    }

    public final void setDefaultClientSupportedCiphersuites(CipherSuite ... defaultClientSupportedCiphersuites) {
        this.defaultClientSupportedCiphersuites = new ArrayList<CipherSuite>(Arrays.asList(defaultClientSupportedCiphersuites));
    }

    public Boolean isClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(Boolean clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public List<SignatureAndHashAlgorithm> getDefaultClientSupportedSignatureAndHashAlgorithms() {
        return this.defaultClientSupportedSignatureAndHashAlgorithms;
    }

    public void setDefaultClientSupportedSignatureAndHashAlgorithms(List<SignatureAndHashAlgorithm> defaultClientSupportedSignatureAndHashAlgorithms) {
        this.defaultClientSupportedSignatureAndHashAlgorithms = defaultClientSupportedSignatureAndHashAlgorithms;
    }

    public final void setDefaultClientSupportedSignatureAndHashAlgorithms(SignatureAndHashAlgorithm ... supportedSignatureAndHashAlgorithms) {
        this.defaultClientSupportedSignatureAndHashAlgorithms = new ArrayList<SignatureAndHashAlgorithm>(Arrays.asList(supportedSignatureAndHashAlgorithms));
    }

    public List<ProtocolVersion> getSupportedVersions() {
        return this.supportedVersions;
    }

    public void setSupportedVersions(List<ProtocolVersion> supportedVersions) {
        this.supportedVersions = supportedVersions;
    }

    public final void setSupportedVersions(ProtocolVersion ... supportedVersions) {
        this.supportedVersions = new ArrayList<ProtocolVersion>(Arrays.asList(supportedVersions));
    }

    public HeartbeatMode getHeartbeatMode() {
        return this.heartbeatMode;
    }

    public void setHeartbeatMode(HeartbeatMode heartbeatMode) {
        this.heartbeatMode = heartbeatMode;
    }

    public Boolean isAddECPointFormatExtension() {
        return this.addECPointFormatExtension;
    }

    public void setAddECPointFormatExtension(Boolean addECPointFormatExtension) {
        this.addECPointFormatExtension = addECPointFormatExtension;
    }

    public Boolean isAddExtensionsInSSL() {
        return this.addExtensionsInSSL;
    }

    public void setAddExtensionsInSSL(Boolean addExtensionsInSSL) {
        this.addExtensionsInSSL = addExtensionsInSSL;
    }

    public Boolean isAddEllipticCurveExtension() {
        return this.addEllipticCurveExtension;
    }

    public void setAddEllipticCurveExtension(Boolean addEllipticCurveExtension) {
        this.addEllipticCurveExtension = addEllipticCurveExtension;
    }

    public Boolean isAddHeartbeatExtension() {
        return this.addHeartbeatExtension;
    }

    public void setAddHeartbeatExtension(Boolean addHeartbeatExtension) {
        this.addHeartbeatExtension = addHeartbeatExtension;
    }

    public boolean isAddMaxFragmentLengthExtension() {
        return this.addMaxFragmentLengthExtension;
    }

    public void setAddMaxFragmentLengthExtension(boolean addMaxFragmentLengthExtenstion) {
        this.addMaxFragmentLengthExtension = addMaxFragmentLengthExtenstion;
    }

    public Boolean isAddServerNameIndicationExtension() {
        return this.addServerNameIndicationExtension;
    }

    public void setAddServerNameIndicationExtension(Boolean addServerNameIndicationExtension) {
        this.addServerNameIndicationExtension = addServerNameIndicationExtension;
    }

    public Boolean isAddSignatureAndHashAlgrorithmsExtension() {
        return this.addSignatureAndHashAlgorithmsExtension;
    }

    public void setAddSignatureAndHashAlgorithmsExtension(Boolean addSignatureAndHashAlgorithmsExtension) {
        this.addSignatureAndHashAlgorithmsExtension = addSignatureAndHashAlgorithmsExtension;
    }

    public Boolean isAddSupportedVersionsExtension() {
        return this.addSupportedVersionsExtension;
    }

    public void setAddSupportedVersionsExtension(Boolean addSupportedVersionsExtension) {
        this.addSupportedVersionsExtension = addSupportedVersionsExtension;
    }

    public Boolean isAddKeyShareExtension() {
        return this.addKeyShareExtension;
    }

    public void setAddKeyShareExtension(Boolean addKeyShareExtension) {
        this.addKeyShareExtension = addKeyShareExtension;
    }

    public Boolean isAddEarlyDataExtension() {
        return this.addEarlyDataExtension;
    }

    public void setAddEarlyDataExtension(Boolean addEarlyDataExtension) {
        this.addEarlyDataExtension = addEarlyDataExtension;
    }

    public Boolean isAddEncryptedServerNameIndicationExtension() {
        return this.addEncryptedServerNameIndicationExtension;
    }

    public void setAddEncryptedServerNameIndicationExtension(Boolean addEncryptedServerNameIndicationExtension) {
        this.addEncryptedServerNameIndicationExtension = addEncryptedServerNameIndicationExtension;
    }

    public void setAddPWDClearExtension(Boolean addPWDClearExtension) {
        this.addPWDClearExtension = addPWDClearExtension;
    }

    public Boolean isAddPSKKeyExchangeModesExtension() {
        return this.addPSKKeyExchangeModesExtension;
    }

    public void setAddPSKKeyExchangeModesExtension(Boolean addPSKKeyExchangeModesExtension) {
        this.addPSKKeyExchangeModesExtension = addPSKKeyExchangeModesExtension;
    }

    public Boolean isAddPreSharedKeyExtension() {
        return this.addPreSharedKeyExtension;
    }

    public Boolean isAddPWDClearExtension() {
        return this.addPWDClearExtension;
    }

    public void setAddPreSharedKeyExtension(Boolean addPreSharedKeyExtension) {
        this.addPreSharedKeyExtension = addPreSharedKeyExtension;
    }

    public void setPSKKeyExchangeModes(List<PskKeyExchangeMode> pskKeyExchangeModes) {
        this.pskKeyExchangeModes = pskKeyExchangeModes;
    }

    public List<PskKeyExchangeMode> getPSKKeyExchangeModes() {
        return this.pskKeyExchangeModes;
    }

    public Integer getDefaultAdditionalPadding() {
        return this.defaultAdditionalPadding;
    }

    public void setDefaultAdditionalPadding(Integer defaultAdditionalPadding) {
        this.defaultAdditionalPadding = defaultAdditionalPadding;
    }

    public BigInteger getKeySharePrivate() {
        return this.defaultKeySharePrivateKey;
    }

    public void setKeySharePrivate(BigInteger defaultKeySharePrivateKey) {
        this.defaultKeySharePrivateKey = defaultKeySharePrivateKey;
    }

    public byte[] getTlsSessionTicket() {
        return Arrays.copyOf(this.tlsSessionTicket, this.tlsSessionTicket.length);
    }

    public void setTlsSessionTicket(byte[] tlsSessionTicket) {
        this.tlsSessionTicket = tlsSessionTicket;
    }

    public byte[] getDefaultSignedCertificateTimestamp() {
        return Arrays.copyOf(this.defaultSignedCertificateTimestamp, this.defaultSignedCertificateTimestamp.length);
    }

    public void setDefaultSignedCertificateTimestamp(byte[] defaultSignedCertificateTimestamp) {
        this.defaultSignedCertificateTimestamp = defaultSignedCertificateTimestamp;
    }

    public Boolean isAddSignedCertificateTimestampExtension() {
        return this.addSignedCertificateTimestampExtension;
    }

    public void setAddSignedCertificateTimestampExtension(Boolean addSignedCertificateTimestampExtension) {
        this.addSignedCertificateTimestampExtension = addSignedCertificateTimestampExtension;
    }

    public byte[] getDefaultClientRenegotiationInfo() {
        return Arrays.copyOf(this.defaultClientRenegotiationInfo, this.defaultClientRenegotiationInfo.length);
    }

    public void setDefaultClientRenegotiationInfo(byte[] defaultClientRenegotiationInfo) {
        this.defaultClientRenegotiationInfo = defaultClientRenegotiationInfo;
    }

    public Boolean isAddRenegotiationInfoExtension() {
        return this.addRenegotiationInfoExtension;
    }

    public void setAddRenegotiationInfoExtension(Boolean addRenegotiationInfoExtension) {
        this.addRenegotiationInfoExtension = addRenegotiationInfoExtension;
    }

    public TokenBindingVersion getDefaultTokenBindingVersion() {
        return this.defaultTokenBindingVersion;
    }

    public void setDefaultTokenBindingVersion(TokenBindingVersion defaultTokenBindingVersion) {
        this.defaultTokenBindingVersion = defaultTokenBindingVersion;
    }

    public List<TokenBindingKeyParameters> getDefaultTokenBindingKeyParameters() {
        return this.defaultTokenBindingKeyParameters;
    }

    public void setDefaultTokenBindingKeyParameters(List<TokenBindingKeyParameters> defaultTokenBindingKeyParameters) {
        this.defaultTokenBindingKeyParameters = defaultTokenBindingKeyParameters;
    }

    public final void setDefaultTokenBindingKeyParameters(TokenBindingKeyParameters ... defaultTokenBindingKeyParameters) {
        this.defaultTokenBindingKeyParameters = new ArrayList<TokenBindingKeyParameters>(Arrays.asList(defaultTokenBindingKeyParameters));
    }

    public Boolean isAddTokenBindingExtension() {
        return this.addTokenBindingExtension;
    }

    public void setAddTokenBindingExtension(Boolean addTokenBindingExtension) {
        this.addTokenBindingExtension = addTokenBindingExtension;
    }

    public Boolean isAddHttpsCookie() {
        return this.addHttpsCookie;
    }

    public void setAddHttpsCookie(Boolean addHttpsCookie) {
        this.addHttpsCookie = addHttpsCookie;
    }

    public String getDefaultHttpsCookieName() {
        return this.defaultHttpsCookieName;
    }

    public void setDefaultHttpsCookieName(String defaultHttpsCookieName) {
        this.defaultHttpsCookieName = defaultHttpsCookieName;
    }

    public String getDefaultHttpsCookieValue() {
        return this.defaultHttpsCookieValue;
    }

    public void setDefaultHttpsCookieValue(String defaultHttpsCookieValue) {
        this.defaultHttpsCookieValue = defaultHttpsCookieValue;
    }

    public CertificateStatusRequestType getCertificateStatusRequestExtensionRequestType() {
        return this.certificateStatusRequestExtensionRequestType;
    }

    public void setCertificateStatusRequestExtensionRequestType(CertificateStatusRequestType certificateStatusRequestExtensionRequestType) {
        this.certificateStatusRequestExtensionRequestType = certificateStatusRequestExtensionRequestType;
    }

    public byte[] getCertificateStatusRequestExtensionResponderIDList() {
        return Arrays.copyOf(this.certificateStatusRequestExtensionResponderIDList, this.certificateStatusRequestExtensionResponderIDList.length);
    }

    public void setCertificateStatusRequestExtensionResponderIDList(byte[] certificateStatusRequestExtensionResponderIDList) {
        this.certificateStatusRequestExtensionResponderIDList = certificateStatusRequestExtensionResponderIDList;
    }

    public byte[] getCertificateStatusRequestExtensionRequestExtension() {
        return Arrays.copyOf(this.certificateStatusRequestExtensionRequestExtension, this.certificateStatusRequestExtensionRequestExtension.length);
    }

    public void setCertificateStatusRequestExtensionRequestExtension(byte[] certificateStatusRequestExtensionRequestExtension) {
        this.certificateStatusRequestExtensionRequestExtension = certificateStatusRequestExtensionRequestExtension;
    }

    public byte[] getSecureRemotePasswordExtensionIdentifier() {
        return Arrays.copyOf(this.secureRemotePasswordExtensionIdentifier, this.secureRemotePasswordExtensionIdentifier.length);
    }

    public void setSecureRemotePasswordExtensionIdentifier(byte[] secureRemotePasswordExtensionIdentifier) {
        this.secureRemotePasswordExtensionIdentifier = secureRemotePasswordExtensionIdentifier;
    }

    public List<SrtpProtectionProfiles> getSecureRealTimeTransportProtocolProtectionProfiles() {
        return this.secureRealTimeTransportProtocolProtectionProfiles;
    }

    public void setSecureRealTimeTransportProtocolProtectionProfiles(List<SrtpProtectionProfiles> secureRealTimeTransportProtocolProtectionProfiles) {
        this.secureRealTimeTransportProtocolProtectionProfiles = secureRealTimeTransportProtocolProtectionProfiles;
    }

    public byte[] getSecureRealTimeTransportProtocolMasterKeyIdentifier() {
        return Arrays.copyOf(this.secureRealTimeTransportProtocolMasterKeyIdentifier, this.secureRealTimeTransportProtocolMasterKeyIdentifier.length);
    }

    public void setSecureRealTimeTransportProtocolMasterKeyIdentifier(byte[] secureRealTimeTransportProtocolMasterKeyIdentifier) {
        this.secureRealTimeTransportProtocolMasterKeyIdentifier = secureRealTimeTransportProtocolMasterKeyIdentifier;
    }

    public UserMappingExtensionHintType getUserMappingExtensionHintType() {
        return this.userMappingExtensionHintType;
    }

    public void setUserMappingExtensionHintType(UserMappingExtensionHintType userMappingExtensionHintType) {
        this.userMappingExtensionHintType = userMappingExtensionHintType;
    }

    public List<CertificateType> getCertificateTypeDesiredTypes() {
        return this.certificateTypeDesiredTypes;
    }

    public void setCertificateTypeDesiredTypes(List<CertificateType> certificateTypeDesiredTypes) {
        this.certificateTypeDesiredTypes = certificateTypeDesiredTypes;
    }

    public List<CertificateType> getClientCertificateTypeDesiredTypes() {
        return this.clientCertificateTypeDesiredTypes;
    }

    public void setClientCertificateTypeDesiredTypes(List<CertificateType> clientCertificateTypeDesiredTypes) {
        this.clientCertificateTypeDesiredTypes = clientCertificateTypeDesiredTypes;
    }

    public List<CertificateType> getServerCertificateTypeDesiredTypes() {
        return this.serverCertificateTypeDesiredTypes;
    }

    public void setServerCertificateTypeDesiredTypes(List<CertificateType> serverCertificateTypeDesiredTypes) {
        this.serverCertificateTypeDesiredTypes = serverCertificateTypeDesiredTypes;
    }

    public List<AuthzDataFormat> getClientAuthzExtensionDataFormat() {
        return this.clientAuthzExtensionDataFormat;
    }

    public void setClientAuthzExtensionDataFormat(List<AuthzDataFormat> clientAuthzExtensionDataFormat) {
        this.clientAuthzExtensionDataFormat = clientAuthzExtensionDataFormat;
    }

    public Boolean isCertificateTypeExtensionMessageState() {
        return this.certificateTypeExtensionMessageState;
    }

    public void setCertificateTypeExtensionMessageState(Boolean certificateTypeExtensionMessageState) {
        this.certificateTypeExtensionMessageState = certificateTypeExtensionMessageState;
    }

    public List<AuthzDataFormat> getServerAuthzExtensionDataFormat() {
        return this.serverAuthzExtensionDataFormat;
    }

    public void setServerAuthzExtensionDataFormat(List<AuthzDataFormat> serverAuthzExtensionDataFormat) {
        this.serverAuthzExtensionDataFormat = serverAuthzExtensionDataFormat;
    }

    public List<TrustedAuthority> getTrustedCaIndicationExtensionAuthorties() {
        return this.trustedCaIndicationExtensionAuthorties;
    }

    public void setTrustedCaIndicationExtensionAuthorties(List<TrustedAuthority> trustedCaIndicationExtensionAuthorties) {
        this.trustedCaIndicationExtensionAuthorties = trustedCaIndicationExtensionAuthorties;
    }

    public Boolean isClientCertificateTypeExtensionMessageState() {
        return this.clientCertificateTypeExtensionMessageState;
    }

    public void setClientCertificateTypeExtensionMessageState(Boolean clientCertificateTypeExtensionMessageState) {
        this.clientCertificateTypeExtensionMessageState = clientCertificateTypeExtensionMessageState;
    }

    public Boolean isCachedInfoExtensionIsClientState() {
        return this.cachedInfoExtensionIsClientState;
    }

    public void setCachedInfoExtensionIsClientState(Boolean cachedInfoExtensionIsClientState) {
        this.cachedInfoExtensionIsClientState = cachedInfoExtensionIsClientState;
    }

    public List<CachedObject> getCachedObjectList() {
        return this.cachedObjectList;
    }

    public void setCachedObjectList(List<CachedObject> cachedObjectList) {
        this.cachedObjectList = cachedObjectList;
    }

    public List<RequestItemV2> getStatusRequestV2RequestList() {
        return this.statusRequestV2RequestList;
    }

    public void setStatusRequestV2RequestList(List<RequestItemV2> statusRequestV2RequestList) {
        this.statusRequestV2RequestList = statusRequestV2RequestList;
    }

    public Boolean isAddCertificateStatusRequestExtension() {
        return this.addCertificateStatusRequestExtension;
    }

    public void setAddCertificateStatusRequestExtension(Boolean addCertificateStatusRequestExtension) {
        this.addCertificateStatusRequestExtension = addCertificateStatusRequestExtension;
    }

    public Boolean isAddAlpnExtension() {
        return this.addAlpnExtension;
    }

    public void setAddAlpnExtension(Boolean addAlpnExtension) {
        this.addAlpnExtension = addAlpnExtension;
    }

    public Boolean isAddSRPExtension() {
        return this.addSRPExtension;
    }

    public void setAddSRPExtension(Boolean addSRPExtension) {
        this.addSRPExtension = addSRPExtension;
    }

    public Boolean isAddSRTPExtension() {
        return this.addSRTPExtension;
    }

    public void setAddSRTPExtension(Boolean addSRTPExtension) {
        this.addSRTPExtension = addSRTPExtension;
    }

    public Boolean isAddTruncatedHmacExtension() {
        return this.addTruncatedHmacExtension;
    }

    public void setAddTruncatedHmacExtension(Boolean addTruncatedHmacExtension) {
        this.addTruncatedHmacExtension = addTruncatedHmacExtension;
    }

    public Boolean isAddUserMappingExtension() {
        return this.addUserMappingExtension;
    }

    public void setAddUserMappingExtension(Boolean addUserMappingExtension) {
        this.addUserMappingExtension = addUserMappingExtension;
    }

    public Boolean isAddCertificateTypeExtension() {
        return this.addCertificateTypeExtension;
    }

    public void setAddCertificateTypeExtension(Boolean addCertificateTypeExtension) {
        this.addCertificateTypeExtension = addCertificateTypeExtension;
    }

    public Boolean isAddClientAuthzExtension() {
        return this.addClientAuthzExtension;
    }

    public void setAddClientAuthzExtension(Boolean addClientAuthzExtension) {
        this.addClientAuthzExtension = addClientAuthzExtension;
    }

    public Boolean isAddServerAuthzExtension() {
        return this.addServerAuthzExtension;
    }

    public void setAddServerAuthzExtension(Boolean addServerAuthzExtension) {
        this.addServerAuthzExtension = addServerAuthzExtension;
    }

    public Boolean isAddClientCertificateTypeExtension() {
        return this.addClientCertificateTypeExtension;
    }

    public void setAddClientCertificateTypeExtension(Boolean addClientCertificateTypeExtension) {
        this.addClientCertificateTypeExtension = addClientCertificateTypeExtension;
    }

    public Boolean isAddServerCertificateTypeExtension() {
        return this.addServerCertificateTypeExtension;
    }

    public void setAddServerCertificateTypeExtension(Boolean addServerCertificateTypeExtension) {
        this.addServerCertificateTypeExtension = addServerCertificateTypeExtension;
    }

    public Boolean isAddEncryptThenMacExtension() {
        return this.addEncryptThenMacExtension;
    }

    public void setAddEncryptThenMacExtension(Boolean addEncryptThenMacExtension) {
        this.addEncryptThenMacExtension = addEncryptThenMacExtension;
    }

    public Boolean isAddCachedInfoExtension() {
        return this.addCachedInfoExtension;
    }

    public void setAddCachedInfoExtension(Boolean addCachedInfoExtension) {
        this.addCachedInfoExtension = addCachedInfoExtension;
    }

    public Boolean isAddClientCertificateUrlExtension() {
        return this.addClientCertificateUrlExtension;
    }

    public void setAddClientCertificateUrlExtension(Boolean addClientCertificateUrlExtension) {
        this.addClientCertificateUrlExtension = addClientCertificateUrlExtension;
    }

    public Boolean isAddTrustedCaIndicationExtension() {
        return this.addTrustedCaIndicationExtension;
    }

    public void setAddTrustedCaIndicationExtension(Boolean addTrustedCaIndicationExtension) {
        this.addTrustedCaIndicationExtension = addTrustedCaIndicationExtension;
    }

    public Boolean isAddCertificateStatusRequestV2Extension() {
        return this.addCertificateStatusRequestV2Extension;
    }

    public void setAddCertificateStatusRequestV2Extension(Boolean addCertificateStatusRequestV2Extension) {
        this.addCertificateStatusRequestV2Extension = addCertificateStatusRequestV2Extension;
    }

    public List<CompressionMethod> getDefaultServerSupportedCompressionMethods() {
        return this.defaultServerSupportedCompressionMethods;
    }

    public void setDefaultServerSupportedCompressionMethods(List<CompressionMethod> defaultServerSupportedCompressionMethods) {
        this.defaultServerSupportedCompressionMethods = defaultServerSupportedCompressionMethods;
    }

    public void setDefaultServerSupportedCompressionMethods(CompressionMethod ... defaultServerSupportedCompressionMethods) {
        this.defaultServerSupportedCompressionMethods = new ArrayList<CompressionMethod>(Arrays.asList(defaultServerSupportedCompressionMethods));
    }

    public OutboundConnection getDefaultClientConnection() {
        return this.defaultClientConnection;
    }

    public void setDefaultClientConnection(OutboundConnection defaultClientConnection) {
        this.defaultClientConnection = defaultClientConnection;
    }

    public InboundConnection getDefaultServerConnection() {
        return this.defaultServerConnection;
    }

    public void setDefaultServerConnection(InboundConnection defaultServerConnection) {
        this.defaultServerConnection = defaultServerConnection;
    }

    public RunningModeType getDefaultRunningMode() {
        return this.defaultRunningMode;
    }

    public void setDefaultRunningMode(RunningModeType defaultRunningMode) {
        this.defaultRunningMode = defaultRunningMode;
    }

    public Boolean isStopActionsAfterFatal() {
        return this.stopActionsAfterFatal;
    }

    public void setStopActionsAfterFatal(Boolean stopActionsAfterFatal) {
        this.stopActionsAfterFatal = stopActionsAfterFatal;
    }

    public List<FilterType> getOutputFilters() {
        return this.outputFilters;
    }

    public void setOutputFilters(List<FilterType> outputFilters) {
        this.outputFilters = outputFilters;
    }

    public Boolean isApplyFiltersInPlace() {
        return this.applyFiltersInPlace;
    }

    public void setApplyFiltersInPlace(Boolean applyFiltersInPlace) {
        this.applyFiltersInPlace = applyFiltersInPlace;
    }

    public Boolean isFiltersKeepUserSettings() {
        return this.filtersKeepUserSettings;
    }

    public void setFiltersKeepUserSettings(Boolean filtersKeepUserSettings) {
        this.filtersKeepUserSettings = filtersKeepUserSettings;
    }

    public byte[] getDefaultClientApplicationTrafficSecret() {
        return Arrays.copyOf(this.defaultClientApplicationTrafficSecret, this.defaultClientApplicationTrafficSecret.length);
    }

    public void setDefaultClientApplicationTrafficSecret(byte[] defaultClientApplicationTrafficSecret) {
        this.defaultClientApplicationTrafficSecret = defaultClientApplicationTrafficSecret;
    }

    public byte[] getDefaultServerApplicationTrafficSecret() {
        return Arrays.copyOf(this.defaultServerApplicationTrafficSecret, this.defaultServerApplicationTrafficSecret.length);
    }

    public void setDefaultServerApplicationTrafficSecret(byte[] defaultServerApplicationTrafficSecret) {
        this.defaultServerApplicationTrafficSecret = defaultServerApplicationTrafficSecret;
    }

    public byte[] getEarlyData() {
        return Arrays.copyOf(this.earlyData, this.earlyData.length);
    }

    public void setEarlyData(byte[] earlyData) {
        this.earlyData = earlyData;
    }

    public List<PskSet> getDefaultPskSets() {
        return this.defaultPskSets;
    }

    public void setDefaultPskSets(List<PskSet> defaultPskSets) {
        this.defaultPskSets = defaultPskSets;
    }

    public byte[] getPsk() {
        return Arrays.copyOf(this.psk, this.psk.length);
    }

    public void setPsk(byte[] psk) {
        this.psk = psk;
    }

    public byte[] getDefaultSessionTicketAgeAdd() {
        return Arrays.copyOf(this.defaultSessionTicketAgeAdd, this.defaultSessionTicketAgeAdd.length);
    }

    public void setDefaultSessionTicketAgeAdd(byte[] defaultSessionTicketAgeAdd) {
        this.defaultSessionTicketAgeAdd = defaultSessionTicketAgeAdd;
    }

    public byte[] getDefaultSessionTicketNonce() {
        return Arrays.copyOf(this.defaultSessionTicketNonce, this.defaultSessionTicketNonce.length);
    }

    public void setDefaultSessionTicketNonce(byte[] defaultSessionTicketNonce) {
        this.defaultSessionTicketNonce = defaultSessionTicketNonce;
    }

    public byte[] getDefaultSessionTicketIdentity() {
        return Arrays.copyOf(this.defaultSessionTicketIdentity, this.defaultSessionTicketIdentity.length);
    }

    public void setDefaultSessionTicketIdentity(byte[] defaultSessionTicketIdentity) {
        this.defaultSessionTicketIdentity = defaultSessionTicketIdentity;
    }

    public byte[] getClientEarlyTrafficSecret() {
        return Arrays.copyOf(this.clientEarlyTrafficSecret, this.clientEarlyTrafficSecret.length);
    }

    public void setClientEarlyTrafficSecret(byte[] clientEarlyTrafficSecret) {
        this.clientEarlyTrafficSecret = clientEarlyTrafficSecret;
    }

    public byte[] getEarlySecret() {
        return Arrays.copyOf(this.earlySecret, this.earlySecret.length);
    }

    public void setEarlySecret(byte[] earlySecret) {
        this.earlySecret = earlySecret;
    }

    public CipherSuite getEarlyDataCipherSuite() {
        return this.earlyDataCipherSuite;
    }

    public void setEarlyDataCipherSuite(CipherSuite earlyDataCipherSuite) {
        this.earlyDataCipherSuite = earlyDataCipherSuite;
    }

    public byte[] getEarlyDataPsk() {
        return Arrays.copyOf(this.earlyDataPsk, this.earlyDataPsk.length);
    }

    public void setEarlyDataPsk(byte[] earlyDataPsk) {
        this.earlyDataPsk = earlyDataPsk;
    }

    public Boolean isUsePsk() {
        return this.usePsk;
    }

    public void setUsePsk(Boolean usePsk) {
        this.usePsk = usePsk;
    }

    public String[] getAlpnAnnouncedProtocols() {
        return this.alpnAnnouncedProtocols;
    }

    public void setAlpnAnnouncedProtocols(String[] alpnAnnouncedProtocols) {
        this.alpnAnnouncedProtocols = alpnAnnouncedProtocols;
    }

    public NamedGroup getDefaultEcCertificateCurve() {
        return this.defaultEcCertificateCurve;
    }

    public void setDefaultEcCertificateCurve(NamedGroup defaultEcCertificateCurve) {
        this.defaultEcCertificateCurve = defaultEcCertificateCurve;
    }

    public BigInteger getDefaultClientRSAModulus() {
        return this.defaultClientRSAModulus;
    }

    public void setDefaultClientRSAModulus(BigInteger defaultClientRSAModulus) {
        this.defaultClientRSAModulus = defaultClientRSAModulus;
    }

    public BigInteger getDefaultClientDhGenerator() {
        return this.defaultClientDhGenerator;
    }

    public void setDefaultClientDhGenerator(BigInteger defaultClientDhGenerator) {
        this.defaultClientDhGenerator = defaultClientDhGenerator;
    }

    public BigInteger getDefaultClientDhModulus() {
        return this.defaultClientDhModulus;
    }

    public void setDefaultClientDhModulus(BigInteger defaultClientDhModulus) {
        this.defaultClientDhModulus = defaultClientDhModulus;
    }

    public StarttlsType getStarttlsType() {
        return this.starttlsType;
    }

    public void setStarttlsType(StarttlsType starttlsType) {
        this.starttlsType = starttlsType;
    }

    public BigInteger getDefaultKeySharePrivateKey() {
        return this.defaultKeySharePrivateKey;
    }

    public void setDefaultKeySharePrivateKey(BigInteger defaultKeySharePrivateKey) {
        this.defaultKeySharePrivateKey = defaultKeySharePrivateKey;
    }

    public List<KeyShareStoreEntry> getDefaultClientKeyShareEntries() {
        return this.defaultClientKeyShareEntries;
    }

    public void setDefaultClientKeyShareEntries(List<KeyShareStoreEntry> defaultClientKeyShareEntries) {
        this.defaultClientKeyShareEntries = defaultClientKeyShareEntries;
    }

    public KeyShareStoreEntry getDefaultServerKeyShareEntry() {
        return this.defaultServerKeyShareEntry;
    }

    public void setDefaultServerKeyShareEntry(KeyShareStoreEntry defaultServerKeyShareEntry) {
        this.defaultServerKeyShareEntry = defaultServerKeyShareEntry;
    }

    public BigInteger getDefaultServerDsaPublicKey() {
        return this.defaultServerDsaPublicKey;
    }

    public void setDefaultServerDsaPublicKey(BigInteger defaultServerDsaPublicKey) {
        this.defaultServerDsaPublicKey = defaultServerDsaPublicKey;
    }

    public BigInteger getDefaultServerDsaPrimeP() {
        return this.defaultServerDsaPrimeP;
    }

    public void setDefaultServerDsaPrimeP(BigInteger defaultServerDsaPrimeP) {
        this.defaultServerDsaPrimeP = defaultServerDsaPrimeP;
    }

    public BigInteger getDefaultServerDsaPrimeQ() {
        return this.defaultServerDsaPrimeQ;
    }

    public void setDefaultServerDsaPrimeQ(BigInteger defaultServerDsaPrimeQ) {
        this.defaultServerDsaPrimeQ = defaultServerDsaPrimeQ;
    }

    public BigInteger getDefaultServerDsaGenerator() {
        return this.defaultServerDsaGenerator;
    }

    public void setDefaultServerDsaGenerator(BigInteger defaultServerDsaGenerator) {
        this.defaultServerDsaGenerator = defaultServerDsaGenerator;
    }

    public boolean isAutoSelectCertificate() {
        return this.autoSelectCertificate;
    }

    public void setAutoSelectCertificate(boolean autoSelectCertificate) {
        this.autoSelectCertificate = autoSelectCertificate;
    }

    public NamedGroup getPreferedCertificateSignatureGroup() {
        return this.preferedCertificateSignatureGroup;
    }

    public void setPreferedCertificateSignatureGroup(NamedGroup preferedCertificateSignatureGroup) {
        this.preferedCertificateSignatureGroup = preferedCertificateSignatureGroup;
    }

    public CertificateKeyType getPreferedCertificateSignatureType() {
        return this.preferedCertificateSignatureType;
    }

    public void setPreferedCertificateSignatureType(CertificateKeyType preferedCertificateSignatureType) {
        this.preferedCertificateSignatureType = preferedCertificateSignatureType;
    }

    public CertificateKeyPair getDefaultExplicitCertificateKeyPair() {
        return this.defaultExplicitCertificateKeyPair;
    }

    public void setDefaultExplicitCertificateKeyPair(CertificateKeyPair defaultExplicitCertificateKeyPair) {
        this.defaultExplicitCertificateKeyPair = defaultExplicitCertificateKeyPair;
    }

    public BigInteger getDefaultClientDsaPrivateKey() {
        return this.defaultClientDsaPrivateKey;
    }

    public void setDefaultClientDsaPrivateKey(BigInteger defaultClientDsaPrivateKey) {
        this.defaultClientDsaPrivateKey = defaultClientDsaPrivateKey;
    }

    public BigInteger getDefaultClientDsaPublicKey() {
        return this.defaultClientDsaPublicKey;
    }

    public void setDefaultClientDsaPublicKey(BigInteger defaultClientDsaPublicKey) {
        this.defaultClientDsaPublicKey = defaultClientDsaPublicKey;
    }

    public BigInteger getDefaultClientDsaPrimeP() {
        return this.defaultClientDsaPrimeP;
    }

    public void setDefaultClientDsaPrimeP(BigInteger defaultClientDsaPrimeP) {
        this.defaultClientDsaPrimeP = defaultClientDsaPrimeP;
    }

    public BigInteger getDefaultClientDsaPrimeQ() {
        return this.defaultClientDsaPrimeQ;
    }

    public void setDefaultClientDsaPrimeQ(BigInteger defaultClientDsaPrimeQ) {
        this.defaultClientDsaPrimeQ = defaultClientDsaPrimeQ;
    }

    public BigInteger getDefaultClientDsaGenerator() {
        return this.defaultClientDsaGenerator;
    }

    public void setDefaultClientDsaGenerator(BigInteger defaultClientDsaGenerator) {
        this.defaultClientDsaGenerator = defaultClientDsaGenerator;
    }

    public Boolean getAutoAdjustSignatureAndHashAlgorithm() {
        return this.autoAdjustSignatureAndHashAlgorithm;
    }

    public void setAutoAdjustSignatureAndHashAlgorithm(Boolean autoAdjustSignatureAndHashAlgorithm) {
        this.autoAdjustSignatureAndHashAlgorithm = autoAdjustSignatureAndHashAlgorithm;
    }

    public HashAlgorithm getPreferredHashAlgorithm() {
        return this.preferredHashAlgorithm;
    }

    public void setPreferredHashAlgorithm(HashAlgorithm preferredHashAlgorithm) {
        this.preferredHashAlgorithm = preferredHashAlgorithm;
    }

    public byte[] getDefaultHandshakeSecret() {
        return Arrays.copyOf(this.defaultHandshakeSecret, this.defaultHandshakeSecret.length);
    }

    public void setDefaultHandshakeSecret(byte[] defaultHandshakeSecret) {
        this.defaultHandshakeSecret = defaultHandshakeSecret;
    }

    public Boolean getParseInvalidRecordNormally() {
        return this.parseInvalidRecordsUnencrypted;
    }

    public void setParseInvalidRecordNormally(Boolean parseInvalidRecordNormally) {
        this.parseInvalidRecordsUnencrypted = parseInvalidRecordNormally;
    }

    public String getDefaultClientPWDUsername() {
        return this.defaultClientPWDUsername;
    }

    public void setDefaultClientPWDUsername(String username) {
        this.defaultClientPWDUsername = username;
    }

    public byte[] getDefaultServerPWDSalt() {
        return this.defaultServerPWDSalt;
    }

    public void setDefaultServerPWDSalt(byte[] salt) {
        this.defaultServerPWDSalt = salt;
    }

    public String getDefaultPWDPassword() {
        return this.defaultPWDPassword;
    }

    public void setDefaultPWDPassword(String password) {
        this.defaultPWDPassword = password;
    }

    public Integer getDefaultPWDIterations() {
        return this.defaultPWDIterations;
    }

    public void setDefaultPWDIterations(Integer defaultPWDIterations) {
        this.defaultPWDIterations = defaultPWDIterations;
    }

    public byte[] getDefaultServerPWDPrivate() {
        return this.defaultServerPWDPrivate;
    }

    public void setDefaultServerPWDPrivate(byte[] defaultServerPWDPrivate) {
        this.defaultServerPWDPrivate = defaultServerPWDPrivate;
    }

    public byte[] getDefaultServerPWDMask() {
        return this.defaultServerPWDMask;
    }

    public void setDefaultServerPWDMask(byte[] defaultServerPWDMask) {
        this.defaultServerPWDMask = defaultServerPWDMask;
    }

    public byte[] getDefaultClientPWDPrivate() {
        return this.defaultClientPWDPrivate;
    }

    public void setDefaultClientPWDPrivate(byte[] defaultClientPWDPrivate) {
        this.defaultClientPWDPrivate = defaultClientPWDPrivate;
    }

    public byte[] getDefaultClientPWDMask() {
        return this.defaultClientPWDMask;
    }

    public void setDefaultClientPWDMask(byte[] defaultClientPWDMask) {
        this.defaultClientPWDMask = defaultClientPWDMask;
    }

    public NamedGroup getDefaultPWDProtectGroup() {
        return this.defaultPWDProtectGroup;
    }

    public void setDefaultPWDProtectGroup(NamedGroup defaultPWDProtectGroup) {
        this.defaultPWDProtectGroup = defaultPWDProtectGroup;
    }

    public Point getDefaultServerPWDProtectPublicKey() {
        return this.defaultServerPWDProtectPublicKey;
    }

    public void setDefaultServerPWDProtectPublicKey(Point defaultServerPWDProtectPublicKey) {
        this.defaultServerPWDProtectPublicKey = defaultServerPWDProtectPublicKey;
    }

    public BigInteger getDefaultServerPWDProtectPrivateKey() {
        return this.defaultServerPWDProtectPrivateKey;
    }

    public void setDefaultServerPWDProtectPrivateKey(BigInteger defaultServerPWDProtectPrivateKey) {
        this.defaultServerPWDProtectPrivateKey = defaultServerPWDProtectPrivateKey;
    }

    public BigInteger getDefaultServerPWDProtectRandomSecret() {
        return this.defaultServerPWDProtectRandomSecret;
    }

    public void setDefaultServerPWDProtectRandomSecret(BigInteger defaultServerPWDProtectRandomSecret) {
        this.defaultServerPWDProtectRandomSecret = defaultServerPWDProtectRandomSecret;
    }

    public Boolean isAddPWDProtectExtension() {
        return this.addPWDProtectExtension;
    }

    public void setAddPWDProtectExtension(Boolean addPWDProtectExtension) {
        this.addPWDProtectExtension = addPWDProtectExtension;
    }

    public Boolean isStopTraceAfterUnexpected() {
        return this.stopTraceAfterUnexpected;
    }

    public void setStopTraceAfterUnexpected(Boolean stopTraceAfterUnexpected) {
        this.stopTraceAfterUnexpected = stopTraceAfterUnexpected;
    }

    public List<CipherSuite> getClientSupportedEsniCiphersuites() {
        return this.clientSupportedEsniCiphersuites;
    }

    public void setClientSupportedEsniCiphersuites(List<CipherSuite> clientSupportedEsniCiphersuites) {
        this.clientSupportedEsniCiphersuites = clientSupportedEsniCiphersuites;
    }

    public void setClientSupportedEsniCiphersuites(CipherSuite ... clientSupportedEsniCiphersuites) {
        this.clientSupportedEsniCiphersuites = new ArrayList<CipherSuite>(Arrays.asList(clientSupportedEsniCiphersuites));
    }

    public List<NamedGroup> getClientSupportedEsniNamedGroups() {
        return this.clientSupportedEsniNamedGroups;
    }

    public void setClientSupportedEsniNamedGroups(List<NamedGroup> clientSupportedEsniNamedGroups) {
        this.clientSupportedEsniNamedGroups = clientSupportedEsniNamedGroups;
    }

    public final void setClientSupportedEsniNamedGroups(NamedGroup ... clientSupportedEsniNamedGroups) {
        this.clientSupportedEsniNamedGroups = new ArrayList<NamedGroup>(Arrays.asList(clientSupportedEsniNamedGroups));
    }

    public List<KeyShareEntry> getEsniServerKeyPairs() {
        return this.esniServerKeyPairs;
    }

    public void setEsniServerKeyPairs(List<KeyShareEntry> esniServerKeyPairs) {
        this.esniServerKeyPairs = esniServerKeyPairs;
    }

    public final void setEsniServerKeyPairs(KeyShareEntry ... esniServerKeyPairs) {
        this.esniServerKeyPairs = new ArrayList<KeyShareEntry>(Arrays.asList(esniServerKeyPairs));
    }

    public byte[] getDefaultEsniClientNonce() {
        return this.defaultEsniClientNonce;
    }

    public void setDefaultEsniClientNonce(byte[] defaultEsniClientNonce) {
        this.defaultEsniClientNonce = defaultEsniClientNonce;
    }

    public byte[] getDefaultEsniServerNonce() {
        return this.defaultEsniServerNonce;
    }

    public void setDefaultEsniServerNonce(byte[] defaultEsniServerNonce) {
        this.defaultEsniServerNonce = defaultEsniServerNonce;
    }

    public byte[] getDefaultEsniRecordBytes() {
        return this.defaultEsniRecordBytes;
    }

    public void setDefaultEsniRecordBytes(byte[] defaultEsniRecordBytes) {
        this.defaultEsniRecordBytes = defaultEsniRecordBytes;
    }

    public EsniDnsKeyRecordVersion getDefaultEsniRecordVersion() {
        return this.defaultEsniRecordVersion;
    }

    public void setDefaultEsniRecordVersion(EsniDnsKeyRecordVersion defaultEsniRecordVersion) {
        this.defaultEsniRecordVersion = defaultEsniRecordVersion;
    }

    public byte[] getDefaultEsniRecordChecksum() {
        return this.defaultEsniRecordChecksum;
    }

    public void setDefaultEsniRecordChecksum(byte[] defualtEsniRecordChecksum) {
        this.defaultEsniRecordChecksum = defualtEsniRecordChecksum;
    }

    public List<KeyShareStoreEntry> getDefaultEsniServerKeyShareEntries() {
        return this.defaultEsniServerKeyShareEntries;
    }

    public void setDefaultEsniServerKeyShareEntries(List<KeyShareStoreEntry> defaultEsniServerKeyShareEntries) {
        this.defaultEsniServerKeyShareEntries = defaultEsniServerKeyShareEntries;
    }

    public List<CipherSuite> getDefaultEsniServerCiphersuites() {
        return this.defaultEsniServerCiphersuites;
    }

    public void setDefaultEsniServerCiphersuites(List<CipherSuite> defaultEsniServerCiphersuites) {
        this.defaultEsniServerCiphersuites = defaultEsniServerCiphersuites;
    }

    public Integer getDefaultEsniPaddedLength() {
        return this.defaultEsniPaddedLength;
    }

    public void setDefaultEsniPaddedLength(Integer defaultEsniPaddedLength) {
        this.defaultEsniPaddedLength = defaultEsniPaddedLength;
    }

    public Long getDefaultEsniNotBefore() {
        return this.defaultEsniNotBefore;
    }

    public void setDefaultEsniNotBefore(Long defaultEsniNotBefore) {
        this.defaultEsniNotBefore = defaultEsniNotBefore;
    }

    public Long getDefaultEsniNotAfter() {
        return this.defaultEsniNotAfter;
    }

    public void setDefaultEsniNotAfter(Long defaultEsniNotAfter) {
        this.defaultEsniNotAfter = defaultEsniNotAfter;
    }

    public List<ExtensionType> getDefaultEsniExtensions() {
        return this.defaultEsniExtensions;
    }

    public void setDefaultEsniExtensions(List<ExtensionType> defaultEsniExtensions) {
        this.defaultEsniExtensions = defaultEsniExtensions;
    }

    public boolean isWriteKeylogFile() {
        return this.writeKeylogFile;
    }

    public void setWriteKeylogFile(boolean writeKeylogFile) {
        this.writeKeylogFile = writeKeylogFile;
    }

    public String getKeylogFilePath() {
        return this.keylogFilePath;
    }

    public void setKeylogFilePath(String keylogFilePath) {
        this.keylogFilePath = keylogFilePath;
    }

    public BigInteger getDefaultEsniClientPrivateKey() {
        return this.defaultEsniClientPrivateKey;
    }

    public void setDefaultEsniClientPrivateKey(BigInteger defaultEsniClientPrivateKey) {
        this.defaultEsniClientPrivateKey = defaultEsniClientPrivateKey;
    }
}

