/*
 * Decompiled with CFR 0.152.
 */
package de.rub.nds.tlsattacker.core.protocol.handler;

import de.rub.nds.tlsattacker.core.constants.AlgorithmResolver;
import de.rub.nds.tlsattacker.core.constants.CipherSuite;
import de.rub.nds.tlsattacker.core.constants.KeyExchangeAlgorithm;
import de.rub.nds.tlsattacker.core.protocol.handler.ClientKeyExchangeHandler;
import de.rub.nds.tlsattacker.core.protocol.message.GOSTClientKeyExchangeMessage;
import de.rub.nds.tlsattacker.core.protocol.parser.GOSTClientKeyExchangeParser;
import de.rub.nds.tlsattacker.core.protocol.parser.ProtocolMessageParser;
import de.rub.nds.tlsattacker.core.protocol.preparator.GOST01ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.GOST12ClientKeyExchangePreparator;
import de.rub.nds.tlsattacker.core.protocol.preparator.ProtocolMessagePreparator;
import de.rub.nds.tlsattacker.core.protocol.serializer.GOSTClientKeyExchangeSerializer;
import de.rub.nds.tlsattacker.core.protocol.serializer.ProtocolMessageSerializer;
import de.rub.nds.tlsattacker.core.state.TlsContext;

public class GOSTClientKeyExchangeHandler
extends ClientKeyExchangeHandler<GOSTClientKeyExchangeMessage> {
    public GOSTClientKeyExchangeHandler(TlsContext tlsContext) {
        super(tlsContext);
    }

    @Override
    public ProtocolMessageParser getParser(byte[] message, int pointer) {
        return new GOSTClientKeyExchangeParser(pointer, message, this.tlsContext.getChooser().getLastRecordVersion(), this.tlsContext.getConfig());
    }

    @Override
    public ProtocolMessagePreparator getPreparator(GOSTClientKeyExchangeMessage message) {
        CipherSuite cipherSuite = this.tlsContext.getChooser().getSelectedCipherSuite();
        KeyExchangeAlgorithm exchangeAlg = AlgorithmResolver.getKeyExchangeAlgorithm(cipherSuite);
        if (exchangeAlg == KeyExchangeAlgorithm.VKO_GOST12) {
            return new GOST12ClientKeyExchangePreparator(this.tlsContext.getChooser(), message);
        }
        return new GOST01ClientKeyExchangePreparator(this.tlsContext.getChooser(), message);
    }

    @Override
    public ProtocolMessageSerializer getSerializer(GOSTClientKeyExchangeMessage message) {
        return new GOSTClientKeyExchangeSerializer(message, this.tlsContext.getChooser().getSelectedProtocolVersion());
    }

    @Override
    public void adjustTLSContext(GOSTClientKeyExchangeMessage message) {
        this.adjustPremasterSecret(message);
        this.adjustMasterSecret(message);
        this.setRecordCipher();
        this.spawnNewSession();
    }
}

