/* avatar-cache.c generated by valac 0.35.3.10-6b27, the Vala compiler
 * generated from avatar-cache.vala, do not modify */

/*
 * Copyright (C) 2011 Philip Withnall
 *
 * This library is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 2.1 of the License, or
 * (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this library.  If not, see <http://www.gnu.org/licenses/>.
 *
 * Authors:
 *       Philip Withnall <philip@tecnocode.co.uk>
 */

#include <glib.h>
#include <glib-object.h>
#include <folks-test.h>
#include <folks/folks.h>
#include <gio/gio.h>
#include <stdlib.h>
#include <string.h>


#define TYPE_AVATAR_CACHE_TESTS (avatar_cache_tests_get_type ())
#define AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests))
#define AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))
#define IS_AVATAR_CACHE_TESTS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_AVATAR_CACHE_TESTS))
#define IS_AVATAR_CACHE_TESTS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_AVATAR_CACHE_TESTS))
#define AVATAR_CACHE_TESTS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsClass))

typedef struct _AvatarCacheTests AvatarCacheTests;
typedef struct _AvatarCacheTestsClass AvatarCacheTestsClass;
typedef struct _AvatarCacheTestsPrivate AvatarCacheTestsPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_main_loop_unref0(var) ((var == NULL) ? NULL : (var = (g_main_loop_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _Block1Data Block1Data;
typedef struct _Block2Data Block2Data;
typedef struct _Block3Data Block3Data;
#define _vala_assert(expr, msg) if G_LIKELY (expr) ; else g_assertion_message_expr (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);
#define _vala_return_if_fail(expr, msg) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return; }
#define _vala_return_val_if_fail(expr, msg, val) if G_LIKELY (expr) ; else { g_return_if_fail_warning (G_LOG_DOMAIN, G_STRFUNC, msg); return val; }
#define _vala_warn_if_fail(expr, msg) if G_LIKELY (expr) ; else g_warn_message (G_LOG_DOMAIN, __FILE__, __LINE__, G_STRFUNC, msg);

struct _AvatarCacheTests {
	FolksTestCase parent_instance;
	AvatarCacheTestsPrivate * priv;
};

struct _AvatarCacheTestsClass {
	FolksTestCaseClass parent_class;
};

struct _AvatarCacheTestsPrivate {
	FolksAvatarCache* _cache;
	GFile* _cache_dir;
	GLoadableIcon* _avatar;
	GMainLoop* _main_loop;
};

struct _Block1Data {
	int _ref_count_;
	AvatarCacheTests* self;
	GLoadableIcon* avatar;
};

struct _Block2Data {
	int _ref_count_;
	AvatarCacheTests* self;
	guint n_remaining;
};

struct _Block3Data {
	int _ref_count_;
	Block2Data * _data2_;
	guint i;
};


static gpointer avatar_cache_tests_parent_class = NULL;

GType avatar_cache_tests_get_type (void) G_GNUC_CONST;
#define AVATAR_CACHE_TESTS_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_AVATAR_CACHE_TESTS, AvatarCacheTestsPrivate))
enum  {
	AVATAR_CACHE_TESTS_DUMMY_PROPERTY
};
AvatarCacheTests* avatar_cache_tests_new (void);
AvatarCacheTests* avatar_cache_tests_construct (GType object_type);
void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_store_many_avatars (AvatarCacheTests* self);
static void _avatar_cache_tests_test_store_many_avatars_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self);
static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self);
void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self);
static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self);
static void avatar_cache_tests_real_set_up (FolksTestCase* base);
void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self);
static void avatar_cache_tests_real_tear_down (FolksTestCase* base);
void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error);
void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar);
static void __lambda4_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id);
static Block1Data* block1_data_ref (Block1Data* _data1_);
static void block1_data_unref (void * _userdata_);
static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res);
static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id);
static void __lambda9_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res);
static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b);
static void __lambda6_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_);
static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static Block2Data* block2_data_ref (Block2Data* _data2_);
static void block2_data_unref (void * _userdata_);
static Block3Data* block3_data_ref (Block3Data* _data3_);
static void block3_data_unref (void * _userdata_);
static void _____lambda7_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res);
static void ______lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static gboolean ___lambda8_ (AvatarCacheTests* self);
static gboolean ____lambda8__gsource_func (gpointer self);
static void avatar_cache_tests_finalize (GObject * obj);
gint _vala_main (gchar** args, int args_length1);


static void _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method (gpointer self) {
#line 43 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_and_load_avatar ((AvatarCacheTests*) self);
#line 147 "avatar-cache.c"
}


static void _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method (gpointer self) {
#line 44 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_avatar_overwrite ((AvatarCacheTests*) self);
#line 154 "avatar-cache.c"
}


static void _avatar_cache_tests_test_store_many_avatars_folks_test_case_test_method (gpointer self) {
#line 46 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_store_many_avatars ((AvatarCacheTests*) self);
#line 161 "avatar-cache.c"
}


static void _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 47 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_load_avatar_non_existent ((AvatarCacheTests*) self);
#line 168 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method (gpointer self) {
#line 49 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar ((AvatarCacheTests*) self);
#line 175 "avatar-cache.c"
}


static void _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method (gpointer self) {
#line 50 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_remove_avatar_non_existent ((AvatarCacheTests*) self);
#line 182 "avatar-cache.c"
}


static void _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method (gpointer self) {
#line 52 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_test_build_uri_for_avatar ((AvatarCacheTests*) self);
#line 189 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_construct (GType object_type) {
	AvatarCacheTests * self = NULL;
	gchar* tmp_path;
	const gchar* _tmp0_;
	gchar* _tmp1_;
	const gchar* _tmp2_;
	GFile* _tmp3_;
#line 34 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) folks_test_case_construct (object_type, "AvatarCache");
#line 38 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = g_get_tmp_dir ();
#line 38 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_strconcat (_tmp0_, "/folks-avatar-cache-tests", NULL);
#line 38 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	tmp_path = _tmp1_;
#line 39 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_setenv ("XDG_CACHE_HOME", tmp_path, TRUE);
#line 40 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = g_get_user_cache_dir ();
#line 40 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (g_strcmp0 (_tmp2_, tmp_path) == 0, "Environment.get_user_cache_dir () == tmp_path");
#line 41 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_new_for_path (tmp_path);
#line 41 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 41 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache_dir = _tmp3_;
#line 43 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-and-load-avatar", _avatar_cache_tests_test_store_and_load_avatar_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 44 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-avatar-overwrite", _avatar_cache_tests_test_store_avatar_overwrite_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 46 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "store-many-avatars", _avatar_cache_tests_test_store_many_avatars_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 47 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "load-avatar-non-existent", _avatar_cache_tests_test_load_avatar_non_existent_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 49 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar", _avatar_cache_tests_test_remove_avatar_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 50 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "remove-avatar-non-existent", _avatar_cache_tests_test_remove_avatar_non_existent_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 52 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_add_test ((FolksTestCase*) self, "build-uri-for-avatar", _avatar_cache_tests_test_build_uri_for_avatar_folks_test_case_test_method, g_object_ref (self), g_object_unref);
#line 32 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (tmp_path);
#line 32 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return self;
#line 238 "avatar-cache.c"
}


AvatarCacheTests* avatar_cache_tests_new (void) {
#line 32 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return avatar_cache_tests_construct (TYPE_AVATAR_CACHE_TESTS);
#line 245 "avatar-cache.c"
}


static void avatar_cache_tests_real_set_up (FolksTestCase* base) {
	AvatarCacheTests * self;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	GFile* _tmp3_;
	GFile* _tmp4_;
	GFileIcon* _tmp5_;
	GMainLoop* _tmp6_;
#line 55 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 57 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (avatar_cache_tests_parent_class)->set_up (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 58 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 60 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = folks_avatar_cache_dup ();
#line 60 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 60 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = _tmp0_;
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_test_utils_get_source_test_data ("data/avatar-01.jpg");
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _tmp1_;
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_new_for_path (_tmp2_);
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = _tmp3_;
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = (GFileIcon*) g_file_icon_new (_tmp4_);
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = (GLoadableIcon*) _tmp5_;
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (_tmp4_);
#line 61 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp2_);
#line 65 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp6_ = g_main_loop_new (NULL, FALSE);
#line 65 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 65 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = _tmp6_;
#line 294 "avatar-cache.c"
}


static void avatar_cache_tests_real_tear_down (FolksTestCase* base) {
	AvatarCacheTests * self;
#line 68 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = (AvatarCacheTests*) base;
#line 70 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 70 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_main_loop = NULL;
#line 71 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 71 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_avatar = NULL;
#line 72 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 72 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv->_cache = NULL;
#line 73 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_delete_cache_directory (self);
#line 74 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	FOLKS_TEST_CASE_CLASS (avatar_cache_tests_parent_class)->tear_down (G_TYPE_CHECK_INSTANCE_CAST (self, FOLKS_TYPE_TEST_CASE, FolksTestCase));
#line 318 "avatar-cache.c"
}


void _avatar_cache_tests_delete_directory (AvatarCacheTests* self, GFile* dir, GError** error) {
	GFileEnumerator* enumerator;
	GFile* _tmp0_;
	GFileEnumerator* _tmp1_;
	GFileInfo* file_info;
	GFileEnumerator* _tmp2_;
	GFileInfo* _tmp3_;
	GFileEnumerator* _tmp17_;
	GFile* _tmp18_;
	GError * _inner_error_ = NULL;
#line 77 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 77 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (dir != NULL);
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = dir;
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = g_file_enumerate_children (_tmp0_, G_FILE_ATTRIBUTE_STANDARD_NAME, G_FILE_QUERY_INFO_NONE, NULL, &_inner_error_);
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	enumerator = _tmp1_;
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 80 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 348 "avatar-cache.c"
	}
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = enumerator;
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = g_file_enumerator_next_file (_tmp2_, NULL, &_inner_error_);
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	file_info = _tmp3_;
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 84 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 364 "avatar-cache.c"
	}
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	while (TRUE) {
#line 368 "avatar-cache.c"
		GFileInfo* _tmp4_;
		GFile* child_file;
		GFile* _tmp5_;
		GFileInfo* _tmp6_;
		const gchar* _tmp7_;
		GFile* _tmp8_;
		GFile* _tmp9_;
		GFileType _tmp10_;
		GFileInfo* _tmp13_;
		GFileEnumerator* _tmp14_;
		GFileInfo* _tmp15_;
		GFileInfo* _tmp16_;
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = file_info;
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (!(_tmp4_ != NULL)) {
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			break;
#line 387 "avatar-cache.c"
		}
#line 87 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp5_ = dir;
#line 87 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp6_ = file_info;
#line 87 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp7_ = g_file_info_get_name (_tmp6_);
#line 87 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp8_ = g_file_get_child (_tmp5_, _tmp7_);
#line 87 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		child_file = _tmp8_;
#line 89 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp9_ = child_file;
#line 89 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp10_ = g_file_query_file_type (_tmp9_, G_FILE_QUERY_INFO_NONE, NULL);
#line 89 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (_tmp10_ == G_FILE_TYPE_DIRECTORY) {
#line 405 "avatar-cache.c"
			GFile* _tmp11_;
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_tmp11_ = child_file;
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_avatar_cache_tests_delete_directory (self, _tmp11_, &_inner_error_);
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 92 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				return;
#line 423 "avatar-cache.c"
			}
		} else {
			GFile* _tmp12_;
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_tmp12_ = child_file;
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			g_file_delete (_tmp12_, NULL, &_inner_error_);
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				g_propagate_error (error, _inner_error_);
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (child_file);
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (file_info);
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (enumerator);
#line 96 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				return;
#line 443 "avatar-cache.c"
			}
		}
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp14_ = enumerator;
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp15_ = g_file_enumerator_next_file (_tmp14_, NULL, &_inner_error_);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp13_ = _tmp15_;
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			g_propagate_error (error, _inner_error_);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (child_file);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (file_info);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_g_object_unref0 (enumerator);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			return;
#line 464 "avatar-cache.c"
		}
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp16_ = _tmp13_;
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp13_ = NULL;
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 99 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		file_info = _tmp16_;
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_tmp13_);
#line 85 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (child_file);
#line 478 "avatar-cache.c"
	}
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp17_ = enumerator;
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_file_enumerator_close (_tmp17_, NULL, &_inner_error_);
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 101 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 494 "avatar-cache.c"
	}
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp18_ = dir;
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_file_delete (_tmp18_, NULL, &_inner_error_);
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_propagate_error (error, _inner_error_);
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (file_info);
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (enumerator);
#line 104 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 510 "avatar-cache.c"
	}
#line 77 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (file_info);
#line 77 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (enumerator);
#line 516 "avatar-cache.c"
}


void _avatar_cache_tests_delete_cache_directory (AvatarCacheTests* self) {
	GError * _inner_error_ = NULL;
#line 107 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 524 "avatar-cache.c"
	{
		GFile* _tmp0_;
#line 111 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache_dir;
#line 111 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_avatar_cache_tests_delete_directory (self, _tmp0_, &_inner_error_);
#line 111 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 533 "avatar-cache.c"
			goto __catch0_g_error;
		}
	}
	goto __finally0;
	__catch0_g_error:
	{
		GError* e = NULL;
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 547 "avatar-cache.c"
	}
	__finally0:
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 109 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 558 "avatar-cache.c"
	}
}


static void __lambda4_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp5_;
	GError * _inner_error_ = NULL;
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 568 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = _tmp2_;
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_free0 (_tmp3_);
#line 125 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 586 "avatar-cache.c"
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp4_;
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 129 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = e->message;
#line 129 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:129: Error storing avatar: %s", _tmp4_);
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 605 "avatar-cache.c"
	}
	__finally1:
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 123 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 616 "avatar-cache.c"
	}
#line 132 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp5_ = self->priv->_main_loop;
#line 132 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp5_);
#line 622 "avatar-cache.c"
}


static void ___lambda4__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	__lambda4_ ((AvatarCacheTests*) self, source_object, res);
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 631 "avatar-cache.c"
}


void _avatar_cache_tests_assert_store_avatar (AvatarCacheTests* self, const gchar* id, GLoadableIcon* avatar) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GLoadableIcon* _tmp2_;
	GMainLoop* _tmp3_;
#line 119 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 119 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 119 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (avatar != NULL);
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 121 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_store_avatar (_tmp0_, _tmp1_, _tmp2_, ___lambda4__gasync_ready_callback, g_object_ref (self));
#line 135 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 135 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp3_);
#line 658 "avatar-cache.c"
}


static Block1Data* block1_data_ref (Block1Data* _data1_) {
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_atomic_int_inc (&_data1_->_ref_count_);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return _data1_;
#line 667 "avatar-cache.c"
}


static void block1_data_unref (void * _userdata_) {
	Block1Data* _data1_;
	_data1_ = (Block1Data*) _userdata_;
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (g_atomic_int_dec_and_test (&_data1_->_ref_count_)) {
#line 676 "avatar-cache.c"
		AvatarCacheTests* self;
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		self = _data1_->self;
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (self);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_slice_free (Block1Data, _data1_);
#line 686 "avatar-cache.c"
	}
}


static void __lambda5_ (Block1Data* _data1_, GObject* obj, GAsyncResult* res) {
	AvatarCacheTests* self;
	GMainLoop* _tmp6_;
	GError * _inner_error_ = NULL;
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = _data1_->self;
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 699 "avatar-cache.c"
	{
		GLoadableIcon* _tmp0_;
		FolksAvatarCache* _tmp1_;
		GAsyncResult* _tmp2_;
		GLoadableIcon* _tmp3_;
		GLoadableIcon* _tmp4_;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = self->priv->_cache;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = res;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = folks_avatar_cache_load_avatar_finish (_tmp1_, _tmp2_, &_inner_error_);
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = _tmp3_;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 716 "avatar-cache.c"
			goto __catch2_g_error;
		}
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = _tmp0_;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = NULL;
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_data1_->avatar);
#line 146 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data1_->avatar = _tmp4_;
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (_tmp0_);
#line 729 "avatar-cache.c"
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp5_;
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 150 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp5_ = e->message;
#line 150 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:150: Error loading avatar: %s", _tmp5_);
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 746 "avatar-cache.c"
	}
	__finally2:
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 144 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 757 "avatar-cache.c"
	}
#line 153 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp6_ = self->priv->_main_loop;
#line 153 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp6_);
#line 763 "avatar-cache.c"
}


static void ___lambda5__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	__lambda5_ (self, source_object, res);
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (self);
#line 772 "avatar-cache.c"
}


static gpointer _g_object_ref0 (gpointer self) {
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return self ? g_object_ref (self) : NULL;
#line 779 "avatar-cache.c"
}


GLoadableIcon* _avatar_cache_tests_assert_load_avatar (AvatarCacheTests* self, const gchar* id) {
	GLoadableIcon* result = NULL;
	Block1Data* _data1_;
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
	GLoadableIcon* _tmp3_;
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (self != NULL, NULL);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_val_if_fail (id != NULL, NULL);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data1_ = g_slice_new0 (Block1Data);
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data1_->_ref_count_ = 1;
#line 138 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data1_->self = g_object_ref (self);
#line 140 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data1_->avatar = NULL;
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 142 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_load_avatar (_tmp0_, _tmp1_, ___lambda5__gasync_ready_callback, block1_data_ref (_data1_));
#line 156 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 156 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _g_object_ref0 (_data1_->avatar);
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	result = _tmp3_;
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	block1_data_unref (_data1_);
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data1_ = NULL;
#line 158 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 822 "avatar-cache.c"
}


static void __lambda9_ (AvatarCacheTests* self, GObject* obj, GAsyncResult* res) {
	GMainLoop* _tmp3_;
	GError * _inner_error_ = NULL;
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 831 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
#line 167 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 167 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 167 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		folks_avatar_cache_remove_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 167 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 843 "avatar-cache.c"
			goto __catch3_g_error;
		}
	}
	goto __finally3;
	__catch3_g_error:
	{
		GError* e = NULL;
		const gchar* _tmp2_;
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 171 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = e->message;
#line 171 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:171: Error removing avatar: %s", _tmp2_);
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 862 "avatar-cache.c"
	}
	__finally3:
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 165 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 873 "avatar-cache.c"
	}
#line 174 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_main_loop;
#line 174 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp3_);
#line 879 "avatar-cache.c"
}


static void ___lambda9__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	__lambda9_ ((AvatarCacheTests*) self, source_object, res);
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 888 "avatar-cache.c"
}


void _avatar_cache_tests_assert_remove_avatar (AvatarCacheTests* self, const gchar* id) {
	FolksAvatarCache* _tmp0_;
	const gchar* _tmp1_;
	GMainLoop* _tmp2_;
#line 161 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 161 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (id != NULL);
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = id;
#line 163 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_avatar_cache_remove_avatar (_tmp0_, _tmp1_, ___lambda9__gasync_ready_callback, g_object_ref (self));
#line 177 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 177 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 910 "avatar-cache.c"
}


static void __lambda6_ (AvatarCacheTests* self, GObject* object, GAsyncResult* _result_) {
	GAsyncResult* _tmp0_;
	gboolean _tmp1_;
	GMainLoop* _tmp2_;
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (_result_ != NULL);
#line 184 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _result_;
#line 184 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_test_utils_loadable_icons_content_equal_finish (_tmp0_);
#line 184 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp1_, "TestUtils.loadable_icons_content_equal.end (result)");
#line 185 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 185 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp2_);
#line 930 "avatar-cache.c"
}


static void ___lambda6__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	__lambda6_ ((AvatarCacheTests*) self, source_object, res);
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_object_unref (self);
#line 939 "avatar-cache.c"
}


void _avatar_cache_tests_assert_avatars_equal (AvatarCacheTests* self, GLoadableIcon* a, GLoadableIcon* b) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GMainLoop* _tmp2_;
#line 180 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 180 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (a != NULL);
#line 180 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (b != NULL);
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = a;
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = b;
#line 182 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_utils_loadable_icons_content_equal (_tmp0_, _tmp1_, -1, ___lambda6__gasync_ready_callback, g_object_ref (self));
#line 188 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_main_loop;
#line 188 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_run (_tmp2_);
#line 963 "avatar-cache.c"
}


void avatar_cache_tests_test_store_and_load_avatar (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_;
#line 191 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 194 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 194 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-id", _tmp0_);
#line 197 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-id");
#line 197 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 200 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar != NULL, "avatar != null");
#line 201 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (avatar, g_loadable_icon_get_type ()), "avatar is LoadableIcon");
#line 202 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = self->priv->_avatar;
#line 202 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp2_, avatar);
#line 191 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 992 "avatar-cache.c"
}


void avatar_cache_tests_test_store_avatar_overwrite (AvatarCacheTests* self) {
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_;
#line 205 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 208 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 208 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp0_);
#line 209 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = self->priv->_avatar;
#line 209 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-store-avatar-ow-id", _tmp1_);
#line 212 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = _avatar_cache_tests_assert_load_avatar (self, "test-store-avatar-ow-id");
#line 212 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp2_;
#line 215 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar != NULL, "avatar != null");
#line 216 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (avatar, g_loadable_icon_get_type ()), "avatar is LoadableIcon");
#line 217 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = self->priv->_avatar;
#line 217 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_avatars_equal (self, _tmp3_, avatar);
#line 205 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1026 "avatar-cache.c"
}


static Block2Data* block2_data_ref (Block2Data* _data2_) {
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_atomic_int_inc (&_data2_->_ref_count_);
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return _data2_;
#line 1035 "avatar-cache.c"
}


static void block2_data_unref (void * _userdata_) {
	Block2Data* _data2_;
	_data2_ = (Block2Data*) _userdata_;
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (g_atomic_int_dec_and_test (&_data2_->_ref_count_)) {
#line 1044 "avatar-cache.c"
		AvatarCacheTests* self;
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		self = _data2_->self;
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_object_unref0 (self);
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_slice_free (Block2Data, _data2_);
#line 1052 "avatar-cache.c"
	}
}


static Block3Data* block3_data_ref (Block3Data* _data3_) {
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_atomic_int_inc (&_data3_->_ref_count_);
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return _data3_;
#line 1062 "avatar-cache.c"
}


static void block3_data_unref (void * _userdata_) {
	Block3Data* _data3_;
	_data3_ = (Block3Data*) _userdata_;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (g_atomic_int_dec_and_test (&_data3_->_ref_count_)) {
#line 1071 "avatar-cache.c"
		AvatarCacheTests* self;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		self = _data3_->_data2_->self;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		block2_data_unref (_data3_->_data2_);
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_->_data2_ = NULL;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_slice_free (Block3Data, _data3_);
#line 1081 "avatar-cache.c"
	}
}


static void _____lambda7_ (Block3Data* _data3_, GObject* obj, GAsyncResult* res) {
	Block2Data* _data2_;
	AvatarCacheTests* self;
	GError * _inner_error_ = NULL;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_ = _data3_->_data2_;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = _data2_->self;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (res != NULL);
#line 1096 "avatar-cache.c"
	{
		FolksAvatarCache* _tmp0_;
		GAsyncResult* _tmp1_;
		gchar* _tmp2_;
		gchar* _tmp3_;
		guint _tmp4_;
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp0_ = self->priv->_cache;
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp1_ = res;
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp2_ = folks_avatar_cache_store_avatar_finish (_tmp0_, _tmp1_, &_inner_error_);
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp3_ = _tmp2_;
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_free0 (_tmp3_);
#line 235 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 1115 "avatar-cache.c"
			goto __catch4_g_error;
		}
#line 236 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp4_ = _data2_->n_remaining;
#line 236 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data2_->n_remaining = _tmp4_ - 1;
#line 1122 "avatar-cache.c"
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		guint _tmp5_;
		const gchar* _tmp6_;
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		e = _inner_error_;
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_inner_error_ = NULL;
#line 240 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp5_ = _data3_->i;
#line 240 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp6_ = e->message;
#line 240 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_error ("avatar-cache.vala:240: Error storing avatar %u: %s", _tmp5_, _tmp6_);
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_g_error_free0 (e);
#line 1142 "avatar-cache.c"
	}
	__finally4:
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	if (G_UNLIKELY (_inner_error_ != NULL)) {
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_clear_error (&_inner_error_);
#line 233 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		return;
#line 1153 "avatar-cache.c"
	}
}


static void ______lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_____lambda7_ (self, source_object, res);
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	block3_data_unref (self);
#line 1163 "avatar-cache.c"
}


static gboolean ___lambda8_ (AvatarCacheTests* self) {
	gboolean result = FALSE;
	GMainLoop* _tmp0_;
#line 251 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_main_loop;
#line 251 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_main_loop_quit (_tmp0_);
#line 252 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	result = FALSE;
#line 252 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 1178 "avatar-cache.c"
}


static gboolean ____lambda8__gsource_func (gpointer self) {
	gboolean result;
	result = ___lambda8_ ((AvatarCacheTests*) self);
#line 249 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 1187 "avatar-cache.c"
}


void avatar_cache_tests_test_store_many_avatars (AvatarCacheTests* self) {
	Block2Data* _data2_;
#line 224 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	static const guint n_avatars = (guint) 1000;
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_ = g_slice_new0 (Block2Data);
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_->_ref_count_ = 1;
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_->self = g_object_ref (self);
#line 225 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_->n_remaining = n_avatars;
#line 1205 "avatar-cache.c"
	{
		Block3Data* _data3_;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_ = g_slice_new0 (Block3Data);
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_->_ref_count_ = 1;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_->_data2_ = block2_data_ref (_data2_);
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_->i = (guint) 0;
#line 1216 "avatar-cache.c"
		{
			gboolean _tmp0_;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_tmp0_ = TRUE;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			while (TRUE) {
#line 1223 "avatar-cache.c"
				guint _tmp2_;
				gchar* id;
				guint _tmp3_;
				gchar* _tmp4_;
				FolksAvatarCache* _tmp5_;
				const gchar* _tmp6_;
				GLoadableIcon* _tmp7_;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				if (!_tmp0_) {
#line 1233 "avatar-cache.c"
					guint _tmp1_;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					_tmp1_ = _data3_->i;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					_data3_->i = _tmp1_ + 1;
#line 1239 "avatar-cache.c"
				}
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp0_ = FALSE;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp2_ = _data3_->i;
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				if (!(_tmp2_ < n_avatars)) {
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					break;
#line 1249 "avatar-cache.c"
				}
#line 229 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp3_ = _data3_->i;
#line 229 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp4_ = g_strdup_printf ("test-store-many-avatars-%u", _tmp3_);
#line 229 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				id = _tmp4_;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp5_ = self->priv->_cache;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp6_ = id;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp7_ = self->priv->_avatar;
#line 231 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				folks_avatar_cache_store_avatar (_tmp5_, _tmp6_, _tmp7_, ______lambda7__gasync_ready_callback, block3_data_ref (_data3_));
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_free0 (id);
#line 1267 "avatar-cache.c"
			}
		}
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		block3_data_unref (_data3_);
#line 227 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_data3_ = NULL;
#line 1274 "avatar-cache.c"
	}
#line 247 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	while (TRUE) {
#line 1278 "avatar-cache.c"
		guint _tmp8_;
		GMainLoop* _tmp9_;
#line 247 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp8_ = _data2_->n_remaining;
#line 247 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		if (!(_tmp8_ > ((guint) 0))) {
#line 247 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			break;
#line 1287 "avatar-cache.c"
		}
#line 249 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_idle_add_full (G_PRIORITY_DEFAULT_IDLE, ____lambda8__gsource_func, g_object_ref (self), g_object_unref);
#line 255 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		_tmp9_ = self->priv->_main_loop;
#line 255 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		g_main_loop_run (_tmp9_);
#line 1295 "avatar-cache.c"
	}
	{
		guint i;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
		i = (guint) 0;
#line 1301 "avatar-cache.c"
		{
			gboolean _tmp10_;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			_tmp10_ = TRUE;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
			while (TRUE) {
#line 1308 "avatar-cache.c"
				guint _tmp12_;
				gchar* id;
				guint _tmp13_;
				gchar* _tmp14_;
				GLoadableIcon* avatar;
				const gchar* _tmp15_;
				GLoadableIcon* _tmp16_;
				GLoadableIcon* _tmp17_;
				GLoadableIcon* _tmp18_;
				GLoadableIcon* _tmp19_;
				GLoadableIcon* _tmp20_;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				if (!_tmp10_) {
#line 1322 "avatar-cache.c"
					guint _tmp11_;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					_tmp11_ = i;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					i = _tmp11_ + 1;
#line 1328 "avatar-cache.c"
				}
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp10_ = FALSE;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp12_ = i;
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				if (!(_tmp12_ < n_avatars)) {
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
					break;
#line 1338 "avatar-cache.c"
				}
#line 261 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp13_ = i;
#line 261 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp14_ = g_strdup_printf ("test-store-many-avatars-%u", _tmp13_);
#line 261 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				id = _tmp14_;
#line 262 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp15_ = id;
#line 262 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp16_ = _avatar_cache_tests_assert_load_avatar (self, _tmp15_);
#line 262 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				avatar = _tmp16_;
#line 264 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp17_ = avatar;
#line 264 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_vala_assert (_tmp17_ != NULL, "avatar != null");
#line 265 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp18_ = avatar;
#line 265 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_vala_assert (G_TYPE_CHECK_INSTANCE_TYPE (_tmp18_, g_loadable_icon_get_type ()), "avatar is LoadableIcon");
#line 266 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp19_ = self->priv->_avatar;
#line 266 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_tmp20_ = avatar;
#line 266 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_avatar_cache_tests_assert_avatars_equal (self, _tmp19_, _tmp20_);
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_object_unref0 (avatar);
#line 259 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
				_g_free0 (id);
#line 1370 "avatar-cache.c"
			}
		}
	}
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	block2_data_unref (_data2_);
#line 220 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_data2_ = NULL;
#line 1378 "avatar-cache.c"
}


void avatar_cache_tests_test_load_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp0_;
#line 270 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 273 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-load-avatar-non-existent");
#line 273 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 274 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar == NULL, "avatar == null");
#line 270 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1395 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar (AvatarCacheTests* self) {
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp0_;
	GLoadableIcon* _tmp1_;
	GLoadableIcon* _tmp2_;
	GLoadableIcon* _tmp3_;
	GLoadableIcon* _tmp4_;
#line 277 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 279 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = NULL;
#line 282 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_avatar;
#line 282 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_store_avatar (self, "test-remove-avatar", _tmp0_);
#line 285 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 285 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 285 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp1_;
#line 286 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = avatar;
#line 286 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp2_ != NULL, "avatar != null");
#line 289 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar");
#line 292 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar");
#line 292 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 292 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp3_;
#line 293 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp4_ = avatar;
#line 293 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp4_ == NULL, "avatar == null");
#line 277 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1438 "avatar-cache.c"
}


void avatar_cache_tests_test_remove_avatar_non_existent (AvatarCacheTests* self) {
	GLoadableIcon* avatar;
	GLoadableIcon* _tmp0_;
#line 296 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 299 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = _avatar_cache_tests_assert_load_avatar (self, "test-remove-avatar-non-existent");
#line 299 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar = _tmp0_;
#line 300 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (avatar == NULL, "avatar == null");
#line 303 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_avatar_cache_tests_assert_remove_avatar (self, "test-remove-avatar-non-existent");
#line 296 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (avatar);
#line 1457 "avatar-cache.c"
}


void avatar_cache_tests_test_build_uri_for_avatar (AvatarCacheTests* self) {
	gchar* uri;
	FolksAvatarCache* _tmp0_;
	gchar* _tmp1_;
	gchar* _tmp2_;
	gchar* _tmp3_;
#line 306 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_return_if_fail (self != NULL);
#line 309 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = self->priv->_cache;
#line 309 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp1_ = folks_avatar_cache_build_uri_for_avatar (_tmp0_, "test-id");
#line 309 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	uri = _tmp1_;
#line 310 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (uri != NULL, "uri != null");
#line 311 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp2_ = g_uri_parse_scheme (uri);
#line 311 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp3_ = _tmp2_;
#line 311 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_vala_assert (_tmp3_ != NULL, "Uri.parse_scheme (uri) != null");
#line 311 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (_tmp3_);
#line 306 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_free0 (uri);
#line 1487 "avatar-cache.c"
}


static void avatar_cache_tests_class_init (AvatarCacheTestsClass * klass) {
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	avatar_cache_tests_parent_class = g_type_class_peek_parent (klass);
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_type_class_add_private (klass, sizeof (AvatarCacheTestsPrivate));
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	((FolksTestCaseClass *) klass)->set_up = avatar_cache_tests_real_set_up;
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	((FolksTestCaseClass *) klass)->tear_down = avatar_cache_tests_real_tear_down;
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (klass)->finalize = avatar_cache_tests_finalize;
#line 1502 "avatar-cache.c"
}


static void avatar_cache_tests_instance_init (AvatarCacheTests * self) {
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self->priv = AVATAR_CACHE_TESTS_GET_PRIVATE (self);
#line 1509 "avatar-cache.c"
}


static void avatar_cache_tests_finalize (GObject * obj) {
	AvatarCacheTests * self;
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_AVATAR_CACHE_TESTS, AvatarCacheTests);
#line 27 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache);
#line 28 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_cache_dir);
#line 29 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (self->priv->_avatar);
#line 30 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_main_loop_unref0 (self->priv->_main_loop);
#line 25 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	G_OBJECT_CLASS (avatar_cache_tests_parent_class)->finalize (obj);
#line 1527 "avatar-cache.c"
}


GType avatar_cache_tests_get_type (void) {
	static volatile gsize avatar_cache_tests_type_id__volatile = 0;
	if (g_once_init_enter (&avatar_cache_tests_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (AvatarCacheTestsClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) avatar_cache_tests_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (AvatarCacheTests), 0, (GInstanceInitFunc) avatar_cache_tests_instance_init, NULL };
		GType avatar_cache_tests_type_id;
		avatar_cache_tests_type_id = g_type_register_static (FOLKS_TYPE_TEST_CASE, "AvatarCacheTests", &g_define_type_info, 0);
		g_once_init_leave (&avatar_cache_tests_type_id__volatile, avatar_cache_tests_type_id);
	}
	return avatar_cache_tests_type_id__volatile;
}


gint _vala_main (gchar** args, int args_length1) {
	gint result = 0;
	AvatarCacheTests* tests;
	AvatarCacheTests* _tmp0_;
#line 317 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_test_init (&args_length1, &args, NULL);
#line 319 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_tmp0_ = avatar_cache_tests_new ();
#line 319 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	tests = _tmp0_;
#line 320 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_register ((FolksTestCase*) tests);
#line 321 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	g_test_run ();
#line 322 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	folks_test_case_final_tear_down ((FolksTestCase*) tests);
#line 324 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	result = 0;
#line 324 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	_g_object_unref0 (tests);
#line 324 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return result;
#line 1565 "avatar-cache.c"
}


int main (int argc, char ** argv) {
#if !GLIB_CHECK_VERSION (2,35,0)
	g_type_init ();
#endif
#line 315 "/opt/gnome/source/folks/tests/folks/avatar-cache.vala"
	return _vala_main (argv, argc);
#line 1575 "avatar-cache.c"
}



