# NOTE: Assertions have been autogenerated by utils/update_mca_test_checks.py
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m3 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M3
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m4 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M4
# RUN: llvm-mca -march=aarch64 -mcpu=exynos-m5 -resource-pressure=false < %s | FileCheck %s -check-prefixes=ALL,M5

ldr	w0, 1f
ldur	x0, [sp, #8]
ldrb	w0, [sp], #1
ldrsh	w0, [sp, #2]!
ldr	x0, [sp, #8]
ldrb	w0, [sp, x31]
ldrsh	w0, [sp, x31, lsl #1]
ldr	w0, [sp, w31, sxtw]
ldr	x0, [sp, w31, uxtw #3]
ldnp	w0, w1, [sp, #8]
ldp	x0, x1, [sp], #16
ldpsw	x0, x1, [sp, #8]!

1:

# ALL:      Iterations:        100
# ALL-NEXT: Instructions:      1200
# ALL-NEXT: Total Cycles:      1904

# M3-NEXT:  Total uOps:        1600
# M4-NEXT:  Total uOps:        1400
# M5-NEXT:  Total uOps:        1400

# ALL:      Dispatch Width:    6

# M3-NEXT:  uOps Per Cycle:    0.84
# M4-NEXT:  uOps Per Cycle:    0.74
# M5-NEXT:  uOps Per Cycle:    0.74

# ALL-NEXT: IPC:               0.63
# ALL-NEXT: Block RThroughput: 6.0

# ALL:      Instruction Info:
# ALL-NEXT: [1]: #uOps
# ALL-NEXT: [2]: Latency
# ALL-NEXT: [3]: RThroughput
# ALL-NEXT: [4]: MayLoad
# ALL-NEXT: [5]: MayStore
# ALL-NEXT: [6]: HasSideEffects (U)

# ALL:      [1]    [2]    [3]    [4]    [5]    [6]    Instructions:
# ALL-NEXT:  1      4     0.50    *                   ldr	w0, {{\.?}}Ltmp0
# ALL-NEXT:  1      4     0.50    *                   ldur	x0, [sp, #8]
# ALL-NEXT:  1      4     0.50    *                   ldrb	w0, [sp], #1
# ALL-NEXT:  1      4     0.50    *                   ldrsh	w0, [sp, #2]!
# ALL-NEXT:  1      4     0.50    *                   ldr	x0, [sp, #8]
# ALL-NEXT:  1      4     0.50    *                   ldrb	w0, [sp, xzr]
# ALL-NEXT:  1      5     0.50    *                   ldrsh	w0, [sp, xzr, lsl #1]

# M3-NEXT:   2      5     0.50    *                   ldr	w0, [sp, wzr, sxtw]
# M3-NEXT:   2      5     0.50    *                   ldr	x0, [sp, wzr, uxtw #3]

# M4-NEXT:   1      5     0.50    *                   ldr	w0, [sp, wzr, sxtw]
# M4-NEXT:   1      5     0.50    *                   ldr	x0, [sp, wzr, uxtw #3]

# M5-NEXT:   1      5     0.50    *                   ldr	w0, [sp, wzr, sxtw]
# M5-NEXT:   1      5     0.50    *                   ldr	x0, [sp, wzr, uxtw #3]

# ALL-NEXT:  1      4     0.50    *                   ldnp	w0, w1, [sp, #8]
# ALL-NEXT:  2      4     0.50    *                   ldp	x0, x1, [sp], #16
# ALL-NEXT:  2      4     0.50    *                   ldpsw	x0, x1, [sp, #8]!
