/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#include "Columns.hxx"
#include "Column.hxx"

#include "TConnection.hxx"

using namespace connectivity;
using namespace connectivity::firebird;
using namespace connectivity::sdbcx;

Column::Column()
    : OColumn( true ) // case sensitive
{
    construct();
}

void Column::construct()
{
    OColumn::construct();
    m_sAutoIncrement = "GENERATED BY DEFAULT AS IDENTITY";
    registerProperty(OMetaConnection::getPropMap().getNameByIndex(
                            PROPERTY_ID_AUTOINCREMENTCREATION),
                     PROPERTY_ID_AUTOINCREMENTCREATION,
                     0,
                     &m_sAutoIncrement,
                     cppu::UnoType<decltype(m_sAutoIncrement)>::get()
                     );
}

::cppu::IPropertyArrayHelper* Column::createArrayHelper( sal_Int32 /*_nId*/ ) const
{
    return doCreateArrayHelper();
}

::cppu::IPropertyArrayHelper & SAL_CALL Column::getInfoHelper()
{
    return *Column_PROP::getArrayHelper(isNew() ? 1 : 0);
}

css::uno::Sequence< OUString > SAL_CALL Column::getSupportedServiceNames(  )
{
    css::uno::Sequence< OUString > aSupported { "com.sun.star.sdbc.Firebird" };

    return aSupported;
}

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
