'
' This file is part of the LibreOffice project.
'
' This Source Code Form is subject to the terms of the Mozilla Public
' License, v. 2.0. If a copy of the MPL was not distributed with this
' file, You can obtain one at http://mozilla.org/MPL/2.0/.
'

Option VBASupport 1
Option Explicit
Dim passCount As Integer
Dim failCount As Integer
Dim result As String

Enum CountDown ' Values get ROUNDED to Int32
    FIVE = 4.11
    FOUR = -4.25
    THREE = 5
    TWO = -.315E1
    ONE = 286.0E-2 ' equals 3
    LIFT_OFF = 7
End Enum ' CountDown

Function doUnitTest()
    ''' test_vba.cxx main entry point '''
    Call ENUM_TestCases
    If failCount <> 0 Or passCount = 0 Then
        doUnitTest = result
    Else
        doUnitTest = "OK"
    End If
End Function


Sub ENUM_TestCases()

    passCount = 0
    failCount = 0

    result = "Test Results" & vbNewLine & "============" & vbNewLine

try:
    On Error Goto catch

    With CountDown

a:      TestLog_ASSERT .ONE = 3, "case a", "CountDown.ONE equals " & Str(.ONE)

b:      TestLog_ASSERT .TWO = -3, "case b", "CountDown.TWO equals " & Str(.TWO)

c:      TestLog_ASSERT TypeName(.FOUR) = "Long", "case c", "CountDown.FOUR type is: " & TypeName(.FOUR)

d:      Dim sum As Double
        sum = .FIVE + .FOUR + .THREE + .TWO + .ONE + .LIFT_OFF
        TestLog_Assert sum = 12, "case d", "SUM of CountDown values is: " & Str(sum)

    End With ' CountDown

finally:
    result = result & vbNewLine & "Tests passed: " & passCount & vbNewLine & "Tests failed: " & failCount & vbNewLine
    Exit Sub

catch:
    TestLog_ASSERT (False), "ERROR", "#"& Str(Err.Number) &" in 'ENUM_TestCases' at line"& Str(Erl) &" - "& Error$
    Resume Next
End Sub

Sub TestLog_ASSERT(assertion As Boolean, Optional testId As String, Optional testComment As String)

    If assertion = True Then
        passCount = passCount + 1
    Else
        Dim testMsg As String
        If Not IsMissing(testId) Then
            testMsg = testMsg + testId + ":"
        End If
        If Not IsMissing(testComment) And Not (testComment = "") Then
            testMsg = testMsg + " (" + testComment + ")"
        End If

        result = result & vbNewLine & "Failed: " & testMsg
        failCount = failCount + 1
    End If

End Sub

'Sub DEV_TEST : doUnitTest : MsgBox result : End Sub
