/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the LibreOffice project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 *
 * This file incorporates work covered by the following license notice:
 *
 *   Licensed to the Apache Software Foundation (ASF) under one or more
 *   contributor license agreements. See the NOTICE file distributed
 *   with this work for additional information regarding copyright
 *   ownership. The ASF licenses this file to you under the Apache
 *   License, Version 2.0 (the "License"); you may not use this file
 *   except in compliance with the License. You may obtain a copy of
 *   the License at http://www.apache.org/licenses/LICENSE-2.0 .
 */
#ifndef INCLUDED_SVX_INC_HELPIDS_H
#define INCLUDED_SVX_INC_HELPIDS_H

#include <rtl/ustring.hxx>

inline constexpr OUStringLiteral HID_BMPMASK_CTL_QCOL_1 = u"SVX_HID_BMPMASK_CTL_QCOL_1";
inline constexpr OUStringLiteral HID_COLOR_CTL_COLORS = u"SVX_HID_COLOR_CTL_COLORS";
inline constexpr OUStringLiteral HID_CTRL3D_HSCROLL = u"SVX_HID_CTRL3D_HSCROLL";
inline constexpr OUStringLiteral HID_CTRL3D_SWITCHER = u"SVX_HID_CTRL3D_SWITCHER";
inline constexpr OUStringLiteral HID_CTRL3D_VSCROLL = u"SVX_HID_CTRL3D_VSCROLL";
inline constexpr OUStringLiteral HID_CTRL_COLOR = u"SVX_HID_CTRL_COLOR";
inline constexpr OUStringLiteral HID_GALLERY_ICONVIEW = u"SVX_HID_GALLERY_ICONVIEW";
inline constexpr OUStringLiteral HID_GALLERY_LISTVIEW = u"SVX_HID_GALLERY_LISTVIEW";
inline constexpr OUStringLiteral HID_GALLERY_NEWTHEME = u"SVX_HID_GALLERY_NEWTHEME";
inline constexpr OUStringLiteral HID_GALLERY_THEMELIST = u"SVX_HID_GALLERY_THEMELIST";
inline constexpr OUStringLiteral HID_GALLERY_WINDOW = u"SVX_HID_GALLERY_WINDOW";
inline constexpr OUStringLiteral HID_POPUP_COLOR = u"SVX_HID_POPUP_COLOR";
inline constexpr OUStringLiteral HID_POPUP_COLOR_CTRL = u"SVX_HID_POPUP_COLOR_CTRL";
inline constexpr OUStringLiteral HID_POPUP_FRAME = u"SVX_HID_POPUP_FRAME";
inline constexpr OUStringLiteral HID_POPUP_LINE = u"SVX_HID_POPUP_LINE";
inline constexpr OUStringLiteral HID_POPUP_LINEEND = u"SVX_HID_POPUP_LINEEND";
inline constexpr OUStringLiteral HID_POPUP_LINEEND_CTRL = u"SVX_HID_POPUP_LINEEND_CTRL";
inline constexpr OUStringLiteral HID_STYLE_LISTBOX = u"SVX_HID_STYLE_LISTBOX";
inline constexpr OUStringLiteral HID_VALUESET_EXTRUSION_LIGHTING = u"SVX_HID_VALUESET_EXTRUSION_LIGHTING";
inline constexpr OUStringLiteral HID_UNDERLINE_BTN = u"SVX_HID_UNDERLINE_BTN";
inline constexpr OUStringLiteral HID_SPACING_MB_KERN = u"SVX_HID_SPACING_MB_KERN";

inline constexpr OUStringLiteral HID_FORM_NAVIGATOR = u"SVX_HID_FORM_NAVIGATOR";
inline constexpr OUStringLiteral HID_FORM_NAVIGATOR_WIN = u"SVX_HID_FORM_NAVIGATOR_WIN";
inline constexpr OUStringLiteral HID_FIELD_SEL = u"SVX_HID_FIELD_SEL";
inline constexpr OUStringLiteral HID_FIELD_SEL_WIN = u"SVX_HID_FIELD_SEL_WIN";
inline constexpr OUStringLiteral HID_FILTER_NAVIGATOR = u"SVX_HID_FILTER_NAVIGATOR";
inline constexpr OUStringLiteral HID_FILTER_NAVIGATOR_WIN = u"SVX_HID_FILTER_NAVIGATOR_WIN";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_FIRST = u"SVX_HID_GRID_TRAVEL_FIRST";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_PREV = u"SVX_HID_GRID_TRAVEL_PREV";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_NEXT = u"SVX_HID_GRID_TRAVEL_NEXT";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_LAST = u"SVX_HID_GRID_TRAVEL_LAST";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_NEW = u"SVX_HID_GRID_TRAVEL_NEW";
inline constexpr OUStringLiteral HID_GRID_TRAVEL_ABSOLUTE = u"SVX_HID_GRID_TRAVEL_ABSOLUTE";
inline constexpr OUStringLiteral HID_GRID_NUMBEROFRECORDS = u"SVX_HID_GRID_NUMBEROFRECORDS";

// Help IDs for Manage Track Changes
inline constexpr OUStringLiteral HID_REDLINE_CTRL_VIEW = u"SVX_HID_REDLINE_CTRL_VIEW";
inline constexpr OUStringLiteral HID_REDLINE_CTRL_FILTER = u"SVX_HID_REDLINE_CTRL_FILTER";

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
