.\"
.\" "$Id: cups-config.man 12854 2015-08-28 14:08:00Z msweet $"
.\"
.\" cups-config man page for CUPS.
.\"
.\" Copyright 2007-2014 by Apple Inc.
.\" Copyright 1997-2006 by Easy Software Products.
.\"
.\" These coded instructions, statements, and computer programs are the
.\" property of Apple Inc. and are protected by Federal copyright
.\" law.  Distribution and use rights are outlined in the file "LICENSE.txt"
.\" which should have been included with this file.  If this file is
.\" file is missing or damaged, see the license at "http://www.cups.org/".
.\"
.TH cups-config 1 "CUPS" "15 April 2014" "Apple Inc."
.SH NAME
cups\-config \- get cups api, compiler, directory, and link information.
.SH SYNOPSIS
.B cups\-config
.I \-\-api\-version
.br
.B cups\-config
.I \-\-build
.br
.B cups\-config
.I \-\-cflags
.br
.B cups\-config
.I \-\-datadir
.br
.B cups\-config
.I \-\-help
.br
.B cups\-config
.I \-\-ldflags
.br
.B cups\-config
[
.I \-\-image
] [
.I \-\-static
]
.I \-\-libs
.br
.B cups\-config
.I \-\-serverbin
.br
.B cups\-config
.I \-\-serverroot
.br
.B cups-config
.I \-\-version
.br
.SH DESCRIPTION
The \fBcups-config\fR command allows application developers to determine the necessary command-line options for the compiler and linker, as well as the installation directories for filters, configuration files, and drivers.
All values are reported to the standard output.
.SH OPTIONS
The \fBcups-config\fR command accepts the following command-line options:
.TP 5
.B \-\-api-version
Reports the current API version (major.minor).
.TP 5
.B \-\-build
Reports a system-specific build number.
.TP 5
.B \-\-cflags
Reports the necessary compiler options.
.TP 5
.B \-\-datadir
Reports the default CUPS data directory.
.TP 5
.B \-\-help
Reports the program usage message.
.TP 5
.B \-\-image
When used with \fI\-\-libs\fR, adds the CUPS imaging library to the
list of libraries.
.TP 5
.B \-\-ldflags
Reports the necessary linker options.
.TP 5
.B \-\-libs
Reports the necessary libraries to link to.
.TP 5
.B \-\-serverbin
Reports the default CUPS binary directory, where filters and backends are stored.
.TP 5
.B \-\-serverroot
Reports the default CUPS configuration file directory.
.TP 5
.B \-\-static
When used with \fI\-\-libs\fR, reports the static libraries instead of the default (shared) libraries.
.TP 5
.B \-\-version
Reports the full version number of the CUPS installation (major.minor.patch).
.SH EXAMPLES
Show the currently installed version of CUPS:
.nf

    cups-config \-\-version

.fi
Compile a simple one-file CUPS filter:
.nf

    cc `cups\-config \-\-cflags \-\-ldflags` \-o filter filter.c \\
        `cups\-config \-\-libs`
.fi
.SH SEE ALSO
.BR cups (1),
CUPS Online Help (http://localhost:631/help)
.SH COPYRIGHT
Copyright \[co] 2007-2015 by Apple Inc.
.\"
.\" End of "$Id: cups-config.man 12854 2015-08-28 14:08:00Z msweet $".
.\"
