// Licensed to the .NET Foundation under one or more agreements.
// The .NET Foundation licenses this file to you under the MIT license.
// See the LICENSE file in the project root for more information.
// ------------------------------------------------------------------------------
// Changes to this file must follow the http://aka.ms/api-review process.
// ------------------------------------------------------------------------------
[assembly: System.Runtime.CompilerServices.CompilationRelaxations(8)]
[assembly: System.Runtime.CompilerServices.RuntimeCompatibility(WrapNonExceptionThrows = true)]
[assembly: System.Diagnostics.Debuggable(System.Diagnostics.DebuggableAttribute.DebuggingModes.IgnoreSymbolStoreSequencePoints)]
[assembly: System.CLSCompliant(true)]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Packaging.FuncTest, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Packaging.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("NuGet.Commands.Test, PublicKey=0024000004800000940000000602000000240000525341310004000001000100b5fc90e7027f67871e773a8fde8938c81dd402ba65b9201d60593e96c492651e889cc13f1415ebb53fac1131ae0bd333c5ee6021672d9718ea31a8aebd0da0072f25d87dba6fc90ffd598ed4da35e44c398c454307e8e33b8426143daec9f596836f97c8f74750e5975c64e2189f45def46b2a2b1247adc3652bf5c308055da9")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("DynamicProxyGenAssembly2, PublicKey=0024000004800000940000000602000000240000525341310004000001000100c547cac37abd99c8db225ef2f6c8a3602f3b3606cc9891605d02baa56104f4cfc0734aa39b93bf7852f7d9266654753cc297e7d2edfe0bac1cdcf9f717241550e0a7b191195b7667bb4f64bcb8e2121380fd1d9d46ad2d92d2d15605093924cceaf74c4861eff62abf69b9291ed0a340e113be11e6a7d3113e92484cf7045cc7")]
[assembly: System.Runtime.CompilerServices.InternalsVisibleTo("Test.Utility, PublicKey=002400000480000094000000060200000024000052534131000400000100010007d1fa57c4aed9f0a32e84aa0faefd0de9e8fd6aec8f87fb03766c834c99921eb23be79ad9d5dcc1dd9ad236132102900b723cf980957fc4e177108fc607774f29e8320e92ea05ece4e821c0a5efe8f1645c4c0c93c1ab99285d622caa652c1dfad63d745d6f2de5f17e5eaf0fc4963d261c8a12436518206dc093344d5ad293")]
[assembly: System.Runtime.Versioning.TargetFramework(".NETCoreApp,Version=v5.0", FrameworkDisplayName = ".NET 5.0")]
[assembly: System.Reflection.AssemblyCompany("Microsoft Corporation")]
[assembly: System.Reflection.AssemblyConfiguration("release")]
[assembly: System.Reflection.AssemblyCopyright("© Microsoft Corporation. All rights reserved.")]
[assembly: System.Reflection.AssemblyDescription("NuGet's understanding of packages. Reading nuspec, nupkgs and package signing.")]
[assembly: System.Reflection.AssemblyFileVersion("6.2.4.1")]
[assembly: System.Reflection.AssemblyInformationalVersion("6.2.4+8fef55f5a55a3b4f2c96cd1a9b5ddc51d4b927f8.8fef55f5a55a3b4f2c96cd1a9b5ddc51d4b927f8")]
[assembly: System.Reflection.AssemblyProduct("NuGet")]
[assembly: System.Reflection.AssemblyTitle("NuGet.Packaging")]
[assembly: System.Reflection.AssemblyMetadata("RepositoryUrl", "https://github.com/NuGet/NuGet.Client")]
[assembly: System.Resources.NeutralResourcesLanguage("en-US")]
[assembly: System.Reflection.AssemblyVersionAttribute("6.2.4.1")]
[assembly: System.Runtime.CompilerServices.ReferenceAssembly]
[assembly: System.Reflection.AssemblyFlagsAttribute((System.Reflection.AssemblyNameFlags)0x70)]
namespace NuGet.Client
{
    public partial class ManagedCodeConventions
    {
        public ManagedCodeConventions(RuntimeModel.RuntimeGraph runtimeGraph) { }

        public ManagedCodeCriteria Criteria { get { throw null; } }

        public ManagedCodePatterns Patterns { get { throw null; } }

        public System.Collections.Generic.IReadOnlyDictionary<string, ContentModel.ContentPropertyDefinition> Properties { get { throw null; } }

        public partial class ManagedCodeCriteria
        {
            internal ManagedCodeCriteria() { }

            public ContentModel.SelectionCriteria ForFramework(Frameworks.NuGetFramework framework) { throw null; }

            public ContentModel.SelectionCriteria ForFrameworkAndRuntime(Frameworks.NuGetFramework framework, string runtimeIdentifier) { throw null; }

            public ContentModel.SelectionCriteria ForRuntime(string runtimeIdentifier) { throw null; }
        }

        public partial class ManagedCodePatterns
        {
            internal ManagedCodePatterns() { }

            public ContentModel.PatternSet AnyTargettedFile { get { throw null; } }

            public ContentModel.PatternSet CompileLibAssemblies { get { throw null; } }

            public ContentModel.PatternSet CompileRefAssemblies { get { throw null; } }

            public ContentModel.PatternSet ContentFiles { get { throw null; } }

            public ContentModel.PatternSet EmbedAssemblies { get { throw null; } }

            public ContentModel.PatternSet MSBuildFiles { get { throw null; } }

            public ContentModel.PatternSet MSBuildMultiTargetingFiles { get { throw null; } }

            public ContentModel.PatternSet MSBuildTransitiveFiles { get { throw null; } }

            public ContentModel.PatternSet NativeLibraries { get { throw null; } }

            public ContentModel.PatternSet ResourceAssemblies { get { throw null; } }

            public ContentModel.PatternSet RuntimeAssemblies { get { throw null; } }

            public ContentModel.PatternSet ToolsAssemblies { get { throw null; } }
        }

        public static partial class PropertyNames
        {
            public static readonly string AnyValue;
            public static readonly string CodeLanguage;
            public static readonly string Locale;
            public static readonly string ManagedAssembly;
            public static readonly string MSBuild;
            public static readonly string RuntimeIdentifier;
            public static readonly string SatelliteAssembly;
            public static readonly string TargetFrameworkMoniker;
        }
    }
}

namespace NuGet.ContentModel
{
    public partial class Asset
    {
        public string Link { get { throw null; } set { } }

        public string Path { get { throw null; } set { } }

        public override string ToString() { throw null; }
    }

    public partial class ContentItem
    {
        public string Path { get { throw null; } set { } }

        public System.Collections.Generic.Dictionary<string, object> Properties { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public partial class ContentItemCollection
    {
        public bool HasContract { get { throw null; } }

        public ContentItemGroup FindBestItemGroup(SelectionCriteria criteria, params PatternSet[] definitions) { throw null; }

        [System.Obsolete("This method causes excessive memory allocation with yield return. Use ContentItemCollection.PopulateItemGroups instead.")]
        public System.Collections.Generic.IEnumerable<ContentItemGroup> FindItemGroups(PatternSet definition) { throw null; }

        public System.Collections.Generic.IEnumerable<ContentItem> FindItems(PatternSet definition) { throw null; }

        public bool HasItemGroup(SelectionCriteria criteria, params PatternSet[] definitions) { throw null; }

        public void Load(System.Collections.Generic.IEnumerable<string> paths) { }

        public void PopulateItemGroups(PatternSet definition, System.Collections.Generic.IList<ContentItemGroup> contentItemGroupList) { }
    }

    public partial class ContentItemGroup
    {
        public System.Collections.Generic.IList<ContentItem> Items { get { throw null; } }

        public System.Collections.Generic.IDictionary<string, object> Properties { get { throw null; } }
    }

    public partial class ContentPropertyDefinition
    {
        public ContentPropertyDefinition(string name, System.Collections.Generic.IEnumerable<string> fileExtensions, bool allowSubfolders) { }

        public ContentPropertyDefinition(string name, System.Collections.Generic.IEnumerable<string> fileExtensions) { }

        public ContentPropertyDefinition(string name, System.Func<object, object, bool> compatibilityTest) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser, System.Collections.Generic.IEnumerable<string> fileExtensions, bool allowSubfolders) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser, System.Collections.Generic.IEnumerable<string> fileExtensions) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser, System.Func<object, object, bool> compatibilityTest, System.Func<object, object, object, int> compareTest, System.Collections.Generic.IEnumerable<string> fileExtensions, bool allowSubfolders) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser, System.Func<object, object, bool> compatibilityTest, System.Func<object, object, object, int> compareTest) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser, System.Func<object, object, bool> compatibilityTest) { }

        public ContentPropertyDefinition(string name, System.Func<string, PatternTable, object> parser) { }

        public ContentPropertyDefinition(string name) { }

        public System.Func<object, object, object, int> CompareTest { get { throw null; } }

        public System.Func<object, object, bool> CompatibilityTest { get { throw null; } }

        public bool FileExtensionAllowSubFolders { get { throw null; } }

        public System.Collections.Generic.List<string> FileExtensions { get { throw null; } }

        public string Name { get { throw null; } }

        public System.Func<string, PatternTable, object> Parser { get { throw null; } }

        public virtual int Compare(object criteriaValue, object candidateValue1, object candidateValue2) { throw null; }

        public virtual bool IsCriteriaSatisfied(object critieriaValue, object candidateValue) { throw null; }

        public virtual bool TryLookup(string name, PatternTable table, out object value) { throw null; }
    }

    public partial class PatternDefinition
    {
        public PatternDefinition(string pattern, PatternTable table, System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, object>> defaults) { }

        public PatternDefinition(string pattern, PatternTable table) { }

        public PatternDefinition(string pattern) { }

        public System.Collections.Generic.IReadOnlyDictionary<string, object> Defaults { get { throw null; } }

        public string Pattern { get { throw null; } }

        public PatternTable Table { get { throw null; } }

        public static implicit operator PatternDefinition(string pattern) { throw null; }
    }

    public partial class PatternSet
    {
        public PatternSet(System.Collections.Generic.IReadOnlyDictionary<string, ContentPropertyDefinition> properties, System.Collections.Generic.IEnumerable<PatternDefinition> groupPatterns, System.Collections.Generic.IEnumerable<PatternDefinition> pathPatterns) { }

        public System.Collections.Generic.IEnumerable<PatternDefinition> GroupPatterns { get { throw null; } }

        public System.Collections.Generic.IEnumerable<PatternDefinition> PathPatterns { get { throw null; } }

        public System.Collections.Generic.IReadOnlyDictionary<string, ContentPropertyDefinition> PropertyDefinitions { get { throw null; } set { } }
    }

    public partial class PatternTable
    {
        public PatternTable() { }

        public PatternTable(System.Collections.Generic.IEnumerable<PatternTableEntry> entries) { }

        public bool TryLookup(string propertyName, string name, out object value) { throw null; }
    }

    public partial class PatternTableEntry
    {
        public PatternTableEntry(string propertyName, string name, object value) { }

        public string Name { get { throw null; } }

        public string PropertyName { get { throw null; } }

        public object Value { get { throw null; } }
    }

    public partial class SelectionCriteria
    {
        public System.Collections.Generic.IList<SelectionCriteriaEntry> Entries { get { throw null; } set { } }
    }

    public partial class SelectionCriteriaBuilder
    {
        public SelectionCriteriaBuilder(System.Collections.Generic.IReadOnlyDictionary<string, ContentPropertyDefinition> properties) { }

        public virtual SelectionCriteriaEntryBuilder Add { get { throw null; } }

        public virtual SelectionCriteria Criteria { get { throw null; } }

        public System.Collections.Generic.IReadOnlyDictionary<string, ContentPropertyDefinition> Properties { get { throw null; } }
    }

    public partial class SelectionCriteriaEntry
    {
        public System.Collections.Generic.IDictionary<string, object> Properties { get { throw null; } set { } }
    }

    public partial class SelectionCriteriaEntryBuilder : SelectionCriteriaBuilder
    {
        internal SelectionCriteriaEntryBuilder() : base(default!) { }

        public override SelectionCriteriaEntryBuilder Add { get { throw null; } }

        public SelectionCriteriaBuilder Builder { get { throw null; } }

        public override SelectionCriteria Criteria { get { throw null; } }

        public SelectionCriteriaEntry Entry { get { throw null; } }

        public SelectionCriteriaEntryBuilder this[string key, object value] { get { throw null; } }

        public SelectionCriteriaEntryBuilder this[string key, string value] { get { throw null; } }
    }
}

namespace NuGet.ContentModel.Infrastructure
{
    public partial class PatternExpression
    {
        public PatternExpression(PatternDefinition pattern) { }

        public ContentItem Match(string path, System.Collections.Generic.IReadOnlyDictionary<string, ContentPropertyDefinition> propertyDefinitions) { throw null; }
    }
}

namespace NuGet.Packaging
{
    public static partial class CollectionExtensions
    {
        public static void AddRange<T>(this System.Collections.Generic.ICollection<T> collection, System.Collections.Generic.IEnumerable<T> items) { }
    }

    public enum ExtractionSource
    {
        RestoreCommand = 0,
        DownloadResource = 1,
        NuGetFolderProject = 2
    }

    public partial class FallbackPackagePathInfo
    {
        public FallbackPackagePathInfo(string id, Versioning.NuGetVersion version, VersionFolderPathResolver resolver) { }

        public string Id { get { throw null; } }

        public VersionFolderPathResolver PathResolver { get { throw null; } }

        public Versioning.NuGetVersion Version { get { throw null; } }
    }

    public partial class FallbackPackagePathResolver
    {
        public FallbackPackagePathResolver(Common.INuGetPathContext pathContext) { }

        public FallbackPackagePathResolver(string userPackageFolder, System.Collections.Generic.IEnumerable<string> fallbackPackageFolders) { }

        public string GetPackageDirectory(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetPackageDirectory(string packageId, string version) { throw null; }

        public FallbackPackagePathInfo GetPackageInfo(string packageId, Versioning.NuGetVersion version) { throw null; }
    }

    public partial class FrameworkAssemblyReference
    {
        public FrameworkAssemblyReference(string assemblyName, System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> supportedFrameworks) { }

        public string AssemblyName { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> SupportedFrameworks { get { throw null; } }
    }

    public static partial class FrameworkNameUtility
    {
        public static System.Runtime.Versioning.FrameworkName ParseFrameworkFolderName(string path, bool strictParsing, out string effectivePath) { throw null; }

        public static System.Runtime.Versioning.FrameworkName ParseFrameworkNameFromFilePath(string filePath, out string effectivePath) { throw null; }

        public static Frameworks.NuGetFramework ParseNuGetFrameworkFolderName(string path, bool strictParsing, out string effectivePath) { throw null; }

        public static Frameworks.NuGetFramework ParseNuGetFrameworkFromFilePath(string filePath, out string effectivePath) { throw null; }
    }

    public sealed partial class FrameworkReference : System.IEquatable<FrameworkReference>, System.Collections.Generic.IComparer<FrameworkReference>, System.IComparable<FrameworkReference>
    {
        public FrameworkReference(string name) { }

        public string Name { get { throw null; } }

        public int Compare(FrameworkReference x, FrameworkReference y) { throw null; }

        public int CompareTo(FrameworkReference other) { throw null; }

        public bool Equals(FrameworkReference other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public partial class FrameworkReferenceGroup : System.IEquatable<FrameworkReferenceGroup>, Frameworks.IFrameworkSpecific
    {
        public FrameworkReferenceGroup(Frameworks.NuGetFramework targetFramework, System.Collections.Generic.IEnumerable<FrameworkReference> frameworkReferences) { }

        public System.Collections.Generic.IEnumerable<FrameworkReference> FrameworkReferences { get { throw null; } }

        public Frameworks.NuGetFramework TargetFramework { get { throw null; } }

        public bool Equals(FrameworkReferenceGroup other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public static partial class FrameworksExtensions
    {
        public static string GetFrameworkString(this Frameworks.NuGetFramework self) { throw null; }
    }

    public partial class FrameworkSpecificGroup : System.IEquatable<FrameworkSpecificGroup>, Frameworks.IFrameworkSpecific
    {
        public FrameworkSpecificGroup(Frameworks.NuGetFramework targetFramework, System.Collections.Generic.IEnumerable<string> items) { }

        public bool HasEmptyFolder { get { throw null; } }

        public System.Collections.Generic.IEnumerable<string> Items { get { throw null; } }

        public Frameworks.NuGetFramework TargetFramework { get { throw null; } }

        public bool Equals(FrameworkSpecificGroup other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public partial interface IAsyncPackageContentReader
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetBuildItemsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetContentItemsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetFrameworkItemsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetLibItemsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PackageDependencyGroup>> GetPackageDependenciesAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetReferenceItemsAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetToolItemsAsync(System.Threading.CancellationToken cancellationToken);
    }

    public partial interface IHashFunction : System.IDisposable
    {
        string GetHash();
        void Update(byte[] data, int offset, int count);
    }

    public partial interface INuspecReader : Core.INuspecCoreReader
    {
        System.Collections.Generic.IEnumerable<PackageDependencyGroup> GetDependencyGroups();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFrameworkReferenceGroups();
        string GetLanguage();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetReferenceGroups();
    }

    public partial interface IPackageContentReader
    {
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetBuildItems();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetContentItems();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFrameworkItems();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetLibItems();
        System.Collections.Generic.IEnumerable<PackageDependencyGroup> GetPackageDependencies();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetReferenceItems();
        System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetToolItems();
    }

    public partial interface IPackageDownloader : System.IDisposable
    {
        IAsyncPackageContentReader ContentReader { get; }

        Core.IAsyncPackageCoreReader CoreReader { get; }

        Signing.ISignedPackageReader SignedPackageReader { get; }

        string Source { get; }

        System.Threading.Tasks.Task<bool> CopyNupkgFileToAsync(string destinationFilePath, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<string> GetPackageHashAsync(string hashAlgorithm, System.Threading.CancellationToken cancellationToken);
        void SetExceptionHandler(System.Func<System.Exception, System.Threading.Tasks.Task<bool>> handleExceptionAsync);
        void SetThrottle(System.Threading.SemaphoreSlim throttle);
    }

    public partial interface IPackageFile
    {
        string EffectivePath { get; }

        System.DateTimeOffset LastWriteTime { get; }

        Frameworks.NuGetFramework NuGetFramework { get; }

        string Path { get; }

        [System.Obsolete("Use NuGetFramework instead. This property will be null for any frameworks net5.0 or above.")]
        System.Runtime.Versioning.FrameworkName TargetFramework { get; }

        System.IO.Stream GetStream();
    }

    public partial interface IPackageMetadata
    {
        System.Collections.Generic.IEnumerable<string> Authors { get; }

        System.Collections.Generic.IEnumerable<ManifestContentFiles> ContentFiles { get; }

        string Copyright { get; }

        System.Collections.Generic.IEnumerable<PackageDependencyGroup> DependencyGroups { get; }

        string Description { get; }

        bool DevelopmentDependency { get; }

        System.Collections.Generic.IEnumerable<FrameworkReferenceGroup> FrameworkReferenceGroups { get; }

        System.Collections.Generic.IEnumerable<FrameworkAssemblyReference> FrameworkReferences { get; }

        string Icon { get; }

        System.Uri IconUrl { get; }

        string Id { get; }

        string Language { get; }

        LicenseMetadata LicenseMetadata { get; }

        System.Uri LicenseUrl { get; }

        System.Version MinClientVersion { get; }

        System.Collections.Generic.IEnumerable<string> Owners { get; }

        System.Collections.Generic.IEnumerable<PackageReferenceSet> PackageAssemblyReferences { get; }

        System.Collections.Generic.IEnumerable<Core.PackageType> PackageTypes { get; }

        System.Uri ProjectUrl { get; }

        string Readme { get; }

        string ReleaseNotes { get; }

        Core.RepositoryMetadata Repository { get; }

        bool RequireLicenseAcceptance { get; }

        bool Serviceable { get; }

        string Summary { get; }

        string Tags { get; }

        string Title { get; }

        Versioning.NuGetVersion Version { get; }
    }

    public partial interface IPackageResolver
    {
        System.Collections.Generic.IEnumerable<Core.PackageIdentity> Resolve(System.Collections.Generic.IEnumerable<Core.PackageIdentity> targets, System.Collections.Generic.IEnumerable<Core.PackageDependencyInfo> availablePackages, System.Collections.Generic.IEnumerable<PackageReference> installedPackages, System.Threading.CancellationToken token);
        System.Collections.Generic.IEnumerable<Core.PackageIdentity> Resolve(System.Collections.Generic.IEnumerable<Core.PackageIdentity> targets, System.Collections.Generic.IEnumerable<Core.PackageDependencyInfo> availablePackages, System.Threading.CancellationToken token);
        System.Collections.Generic.IEnumerable<Core.PackageIdentity> Resolve(System.Collections.Generic.IEnumerable<string> targets, System.Collections.Generic.IEnumerable<Core.PackageDependencyInfo> availablePackages, System.Collections.Generic.IEnumerable<PackageReference> installedPackages, System.Threading.CancellationToken token);
        System.Collections.Generic.IEnumerable<Core.PackageIdentity> Resolve(System.Collections.Generic.IEnumerable<string> targets, System.Collections.Generic.IEnumerable<Core.PackageDependencyInfo> availablePackages, System.Threading.CancellationToken token);
    }

    public partial class LicenseMetadata : System.IEquatable<LicenseMetadata>
    {
        public static readonly System.Version CurrentVersion;
        public static readonly System.Version EmptyVersion;
        public static readonly System.Uri LicenseFileDeprecationUrl;
        public static readonly string LicenseServiceLinkTemplate;
        public LicenseMetadata(LicenseType type, string license, Licenses.NuGetLicenseExpression expression, System.Collections.Generic.IReadOnlyList<string> warningsAndErrors, System.Version version) { }

        public string License { get { throw null; } }

        public Licenses.NuGetLicenseExpression LicenseExpression { get { throw null; } }

        public System.Uri LicenseUrl { get { throw null; } }

        public LicenseType Type { get { throw null; } }

        public System.Version Version { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> WarningsAndErrors { get { throw null; } }

        public bool Equals(LicenseMetadata other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public enum LicenseType
    {
        File = 0,
        Expression = 1
    }

    [System.Obsolete("Use NuGet.Protocol.LocalPackageArchiveDownloader")]
    public sealed partial class LocalPackageArchiveDownloader : IPackageDownloader, System.IDisposable
    {
        public LocalPackageArchiveDownloader(string source, string packageFilePath, Core.PackageIdentity packageIdentity, Common.ILogger logger) { }

        public IAsyncPackageContentReader ContentReader { get { throw null; } }

        public Core.IAsyncPackageCoreReader CoreReader { get { throw null; } }

        public Signing.ISignedPackageReader SignedPackageReader { get { throw null; } }

        public string Source { get { throw null; } }

        public System.Threading.Tasks.Task<bool> CopyNupkgFileToAsync(string destinationFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        public System.Threading.Tasks.Task<string> GetPackageHashAsync(string hashAlgorithm, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void SetExceptionHandler(System.Func<System.Exception, System.Threading.Tasks.Task<bool>> handleExceptionAsync) { }

        public void SetThrottle(System.Threading.SemaphoreSlim throttle) { }
    }

    public partial class Manifest
    {
        public Manifest(ManifestMetadata metadata, System.Collections.Generic.ICollection<ManifestFile> files) { }

        public Manifest(ManifestMetadata metadata) { }

        public System.Collections.Generic.ICollection<ManifestFile> Files { get { throw null; } }

        public bool HasFilesNode { get { throw null; } }

        public ManifestMetadata Metadata { get { throw null; } }

        public static Manifest Create(IPackageMetadata metadata) { throw null; }

        public static Manifest ReadFrom(System.IO.Stream stream, bool validateSchema) { throw null; }

        public static Manifest ReadFrom(System.IO.Stream stream, System.Func<string, string> propertyProvider, bool validateSchema) { throw null; }

        public void Save(System.IO.Stream stream, bool generateBackwardsCompatible) { }

        public void Save(System.IO.Stream stream, int minimumManifestVersion, bool generateBackwardsCompatible) { }

        public void Save(System.IO.Stream stream, int minimumManifestVersion) { }

        public void Save(System.IO.Stream stream) { }

        public static void Validate(Manifest manifest) { }
    }

    public partial class ManifestContentFiles
    {
        public string BuildAction { get { throw null; } set { } }

        public string CopyToOutput { get { throw null; } set { } }

        public string Exclude { get { throw null; } set { } }

        public string Flatten { get { throw null; } set { } }

        public string Include { get { throw null; } set { } }
    }

    public partial class ManifestFile
    {
        public string Exclude { get { throw null; } set { } }

        public string Source { get { throw null; } set { } }

        public string Target { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<string> Validate() { throw null; }
    }

    public partial class ManifestMetadata : IPackageMetadata
    {
        public ManifestMetadata() { }

        public ManifestMetadata(IPackageMetadata copy) { }

        public System.Collections.Generic.IEnumerable<string> Authors { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<ManifestContentFiles> ContentFiles { get { throw null; } set { } }

        public string Copyright { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<PackageDependencyGroup> DependencyGroups { get { throw null; } set { } }

        public string Description { get { throw null; } set { } }

        public bool DevelopmentDependency { get { throw null; } set { } }

        public bool EmitRequireLicenseAcceptance { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<FrameworkReferenceGroup> FrameworkReferenceGroups { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<FrameworkAssemblyReference> FrameworkReferences { get { throw null; } set { } }

        public string Icon { get { throw null; } set { } }

        public System.Uri IconUrl { get { throw null; } }

        public string Id { get { throw null; } set { } }

        public string Language { get { throw null; } set { } }

        public LicenseMetadata LicenseMetadata { get { throw null; } set { } }

        public System.Uri LicenseUrl { get { throw null; } }

        public System.Version MinClientVersion { get { throw null; } }

        public string MinClientVersionString { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<string> Owners { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<PackageReferenceSet> PackageAssemblyReferences { get { throw null; } set { } }

        public System.Collections.Generic.IEnumerable<Core.PackageType> PackageTypes { get { throw null; } set { } }

        public System.Uri ProjectUrl { get { throw null; } }

        public string Readme { get { throw null; } set { } }

        public string ReleaseNotes { get { throw null; } set { } }

        public Core.RepositoryMetadata Repository { get { throw null; } set { } }

        public bool RequireLicenseAcceptance { get { throw null; } set { } }

        public bool Serviceable { get { throw null; } set { } }

        public string Summary { get { throw null; } set { } }

        public string Tags { get { throw null; } set { } }

        public string Title { get { throw null; } set { } }

        public Versioning.NuGetVersion Version { get { throw null; } set { } }

        public void SetIconUrl(string iconUrl) { }

        public void SetLicenseUrl(string licenseUrl) { }

        public void SetProjectUrl(string projectUrl) { }

        public System.Collections.Generic.IEnumerable<string> Validate() { throw null; }
    }

    public static partial class ManifestSchemaUtility
    {
        public static string GetSchemaNamespace(int version) { throw null; }

        public static int GetVersionFromNamespace(string @namespace) { throw null; }

        public static bool IsKnownSchema(string schemaNamespace) { throw null; }
    }

    public static partial class ManifestVersionUtility
    {
        public const int DefaultVersion = 1;
        public const int SemverVersion = 3;
        public const int TargetFrameworkSupportForDependencyContentsAndToolsVersion = 4;
        public const int TargetFrameworkSupportForReferencesVersion = 5;
        public const int XdtTransformationVersion = 6;
        public static int GetManifestVersion(ManifestMetadata metadata) { throw null; }
    }

    public partial class MinClientVersionException : Core.PackagingException, Common.ILogMessageException
    {
        public MinClientVersionException(string message) : base(default!) { }

        public override Common.ILogMessage AsLogMessage() { throw null; }
    }

    public static partial class MinClientVersionUtility
    {
        public static Versioning.NuGetVersion GetNuGetClientVersion() { throw null; }

        public static bool IsMinClientVersionCompatible(Core.NuspecCoreReaderBase nuspecReader) { throw null; }

        public static bool IsMinClientVersionCompatible(Versioning.NuGetVersion packageMinClientVersion) { throw null; }

        public static void VerifyMinClientVersion(Core.NuspecCoreReaderBase nuspecReader) { }
    }

    public partial class NupkgMetadataFile : System.IEquatable<NupkgMetadataFile>
    {
        public string ContentHash { get { throw null; } set { } }

        public string Source { get { throw null; } set { } }

        public int Version { get { throw null; } set { } }

        public bool Equals(NupkgMetadataFile other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public static partial class NupkgMetadataFileFormat
    {
        public static readonly int Version;
        public static NupkgMetadataFile Read(System.IO.Stream stream, Common.ILogger log, string path) { throw null; }

        public static NupkgMetadataFile Read(System.IO.TextReader reader, Common.ILogger log, string path) { throw null; }

        public static NupkgMetadataFile Read(string filePath, Common.ILogger log) { throw null; }

        public static NupkgMetadataFile Read(string filePath) { throw null; }

        public static void Write(System.IO.Stream stream, NupkgMetadataFile hashFile) { }

        public static void Write(System.IO.TextWriter textWriter, NupkgMetadataFile hashFile) { }

        public static void Write(string filePath, NupkgMetadataFile hashFile) { }
    }

    public partial class NuspecReader : Core.NuspecCoreReaderBase
    {
        public NuspecReader(System.IO.Stream stream, Frameworks.IFrameworkNameProvider frameworkProvider, bool leaveStreamOpen) : base(default(string)!) { }

        public NuspecReader(System.IO.Stream stream) : base(default(string)!) { }

        public NuspecReader(string path, Frameworks.IFrameworkNameProvider frameworkProvider) : base(default(string)!) { }

        public NuspecReader(string path) : base(default(string)!) { }

        public NuspecReader(System.Xml.Linq.XDocument xml, Frameworks.IFrameworkNameProvider frameworkProvider) : base(default(string)!) { }

        public NuspecReader(System.Xml.Linq.XDocument xml) : base(default(string)!) { }

        public string GetAuthors() { throw null; }

        public System.Collections.Generic.IEnumerable<Core.ContentFilesEntry> GetContentFiles() { throw null; }

        public string GetCopyright() { throw null; }

        public System.Collections.Generic.IEnumerable<PackageDependencyGroup> GetDependencyGroups() { throw null; }

        public System.Collections.Generic.IEnumerable<PackageDependencyGroup> GetDependencyGroups(bool useStrictVersionCheck) { throw null; }

        public string GetDescription() { throw null; }

        public System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFrameworkAssemblyGroups() { throw null; }

        [System.Obsolete("GetFrameworkReferenceGroups() is deprecated. Please use GetFrameworkAssemblyGroups() instead.")]
        public System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFrameworkReferenceGroups() { throw null; }

        public System.Collections.Generic.IEnumerable<FrameworkReferenceGroup> GetFrameworkRefGroups() { throw null; }

        public string GetIcon() { throw null; }

        public string GetIconUrl() { throw null; }

        public string GetLanguage() { throw null; }

        public LicenseMetadata GetLicenseMetadata() { throw null; }

        public string GetLicenseUrl() { throw null; }

        public string GetOwners() { throw null; }

        public string GetProjectUrl() { throw null; }

        public string GetReadme() { throw null; }

        public System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetReferenceGroups() { throw null; }

        public string GetReleaseNotes() { throw null; }

        public Core.RepositoryMetadata GetRepositoryMetadata() { throw null; }

        public bool GetRequireLicenseAcceptance() { throw null; }

        public string GetSummary() { throw null; }

        public string GetTags() { throw null; }

        public string GetTitle() { throw null; }
    }

    public partial class PackageArchiveReader : PackageReaderBase
    {
        public PackageArchiveReader(System.IO.Compression.ZipArchive zipArchive, Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) : base(default!) { }

        public PackageArchiveReader(System.IO.Compression.ZipArchive zipArchive) : base(default!) { }

        public PackageArchiveReader(System.IO.Stream stream, Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) : base(default!) { }

        public PackageArchiveReader(System.IO.Stream stream, bool leaveStreamOpen, Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) : base(default!) { }

        public PackageArchiveReader(System.IO.Stream stream, bool leaveStreamOpen) : base(default!) { }

        public PackageArchiveReader(System.IO.Stream stream) : base(default!) { }

        public PackageArchiveReader(string filePath, Frameworks.IFrameworkNameProvider frameworkProvider = null, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider = null) : base(default!) { }

        protected Signing.SigningSpecifications SigningSpecifications { get { throw null; } }

        protected System.IO.Stream ZipReadStream { get { throw null; } set { } }

        public override bool CanVerifySignedPackages(Signing.SignedPackageVerifierSettings verifierSettings) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> CopyFiles(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task<string> CopyNupkgAsync(string nupkgFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        protected override void Dispose(bool disposing) { }

        public System.Collections.Generic.IEnumerable<ZipFilePair> EnumeratePackageEntries(System.Collections.Generic.IEnumerable<string> packageFiles, string packageDirectory) { throw null; }

        public string ExtractFile(string packageFile, string targetFilePath, Common.ILogger logger) { throw null; }

        public override System.Threading.Tasks.Task<byte[]> GetArchiveHashAsync(Common.HashAlgorithmName hashAlgorithmName, System.Threading.CancellationToken token) { throw null; }

        public override string GetContentHash(System.Threading.CancellationToken token, System.Func<string> GetUnsignedPackageHash = null) { throw null; }

        public System.IO.Compression.ZipArchiveEntry GetEntry(string packageFile) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles() { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles(string folder) { throw null; }

        public override System.Threading.Tasks.Task<Signing.PrimarySignature> GetPrimarySignatureAsync(System.Threading.CancellationToken token) { throw null; }

        public override System.IO.Stream GetStream(string path) { throw null; }

        public override System.Threading.Tasks.Task<bool> IsSignedAsync(System.Threading.CancellationToken token) { throw null; }

        protected void ThrowIfZipReadStreamIsNull() { }

        public override System.Threading.Tasks.Task ValidateIntegrityAsync(Signing.SignatureContent signatureContent, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task ValidatePackageEntriesAsync(System.Threading.CancellationToken token) { throw null; }
    }

    public partial class PackageBuilder : IPackageMetadata
    {
        public const int MaxIconFileSize = 1048576;
        public PackageBuilder() { }

        public PackageBuilder(bool deterministic, Common.ILogger logger) { }

        public PackageBuilder(bool deterministic) { }

        public PackageBuilder(System.IO.Stream stream, string basePath, System.Func<string, string> propertyProvider) { }

        public PackageBuilder(System.IO.Stream stream, string basePath) { }

        public PackageBuilder(string path, System.Func<string, string> propertyProvider, bool includeEmptyDirectories, bool deterministic, Common.ILogger logger) { }

        public PackageBuilder(string path, System.Func<string, string> propertyProvider, bool includeEmptyDirectories, bool deterministic) { }

        public PackageBuilder(string path, System.Func<string, string> propertyProvider, bool includeEmptyDirectories) { }

        public PackageBuilder(string path, string basePath, System.Func<string, string> propertyProvider, bool includeEmptyDirectories, bool deterministic, Common.ILogger logger) { }

        public PackageBuilder(string path, string basePath, System.Func<string, string> propertyProvider, bool includeEmptyDirectories, bool deterministic) { }

        public PackageBuilder(string path, string basePath, System.Func<string, string> propertyProvider, bool includeEmptyDirectories) { }

        public System.Collections.Generic.ISet<string> Authors { get { throw null; } }

        public System.Collections.Generic.ICollection<ManifestContentFiles> ContentFiles { get { throw null; } }

        public string Copyright { get { throw null; } set { } }

        public System.Collections.ObjectModel.Collection<PackageDependencyGroup> DependencyGroups { get { throw null; } }

        public string Description { get { throw null; } set { } }

        public bool DevelopmentDependency { get { throw null; } set { } }

        public bool EmitRequireLicenseAcceptance { get { throw null; } set { } }

        public System.Collections.Generic.ICollection<IPackageFile> Files { get { throw null; } }

        public System.Collections.ObjectModel.Collection<FrameworkReferenceGroup> FrameworkReferenceGroups { get { throw null; } }

        public System.Collections.ObjectModel.Collection<FrameworkAssemblyReference> FrameworkReferences { get { throw null; } }

        public bool HasSnapshotVersion { get { throw null; } set { } }

        public string Icon { get { throw null; } set { } }

        public System.Uri IconUrl { get { throw null; } set { } }

        public string Id { get { throw null; } set { } }

        public string Language { get { throw null; } set { } }

        public LicenseMetadata LicenseMetadata { get { throw null; } set { } }

        public System.Uri LicenseUrl { get { throw null; } set { } }

        public System.Version MinClientVersion { get { throw null; } set { } }

        System.Collections.Generic.IEnumerable<string> IPackageMetadata.Authors { get { throw null; } }

        System.Collections.Generic.IEnumerable<ManifestContentFiles> IPackageMetadata.ContentFiles { get { throw null; } }

        System.Collections.Generic.IEnumerable<PackageDependencyGroup> IPackageMetadata.DependencyGroups { get { throw null; } }

        System.Collections.Generic.IEnumerable<FrameworkReferenceGroup> IPackageMetadata.FrameworkReferenceGroups { get { throw null; } }

        System.Collections.Generic.IEnumerable<FrameworkAssemblyReference> IPackageMetadata.FrameworkReferences { get { throw null; } }

        System.Collections.Generic.IEnumerable<string> IPackageMetadata.Owners { get { throw null; } }

        System.Collections.Generic.IEnumerable<PackageReferenceSet> IPackageMetadata.PackageAssemblyReferences { get { throw null; } }

        System.Collections.Generic.IEnumerable<Core.PackageType> IPackageMetadata.PackageTypes { get { throw null; } }

        string IPackageMetadata.Tags { get { throw null; } }

        public string OutputName { get { throw null; } set { } }

        public System.Collections.Generic.ISet<string> Owners { get { throw null; } }

        public System.Collections.Generic.ICollection<PackageReferenceSet> PackageAssemblyReferences { get { throw null; } set { } }

        public System.Collections.Generic.ICollection<Core.PackageType> PackageTypes { get { throw null; } set { } }

        public System.Uri ProjectUrl { get { throw null; } set { } }

        public System.Collections.Generic.Dictionary<string, string> Properties { get { throw null; } }

        public string Readme { get { throw null; } set { } }

        public string ReleaseNotes { get { throw null; } set { } }

        public Core.RepositoryMetadata Repository { get { throw null; } set { } }

        public bool RequireLicenseAcceptance { get { throw null; } set { } }

        public bool Serviceable { get { throw null; } set { } }

        public string Summary { get { throw null; } set { } }

        public System.Collections.Generic.ISet<string> Tags { get { throw null; } }

        public System.Collections.Generic.IList<Frameworks.NuGetFramework> TargetFrameworks { get { throw null; } set { } }

        public string Title { get { throw null; } set { } }

        public Versioning.NuGetVersion Version { get { throw null; } set { } }

        public void AddFiles(string basePath, string source, string destination, string exclude = null) { }

        public void Populate(ManifestMetadata manifestMetadata) { }

        public void PopulateFiles(string basePath, System.Collections.Generic.IEnumerable<ManifestFile> files) { }

        public void Save(System.IO.Stream stream) { }

        public static void ValidateReferenceAssemblies(System.Collections.Generic.IEnumerable<IPackageFile> files, System.Collections.Generic.IEnumerable<PackageReferenceSet> packageAssemblyReferences) { }
    }

    public partial class PackageDependencyGroup : System.IEquatable<PackageDependencyGroup>, Frameworks.IFrameworkSpecific
    {
        public PackageDependencyGroup(Frameworks.NuGetFramework targetFramework, System.Collections.Generic.IEnumerable<Core.PackageDependency> packages) { }

        public System.Collections.Generic.IEnumerable<Core.PackageDependency> Packages { get { throw null; } }

        public Frameworks.NuGetFramework TargetFramework { get { throw null; } }

        public bool Equals(PackageDependencyGroup other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class PackageExtractionContext
    {
        public PackageExtractionContext(PackageSaveMode packageSaveMode, XmlDocFileSaveMode xmlDocFileSaveMode, Signing.ClientPolicyContext clientPolicyContext, Common.ILogger logger) { }

        public Signing.ClientPolicyContext ClientPolicyContext { get { throw null; } }

        public bool CopySatelliteFiles { get { throw null; } set { } }

        public Common.ILogger Logger { get { throw null; } }

        public PackageSaveMode PackageSaveMode { get { throw null; } set { } }

        public Signing.IPackageSignatureVerifier SignedPackageVerifier { get { throw null; } set { } }

        public XmlDocFileSaveMode XmlDocFileSaveMode { get { throw null; } set { } }
    }

    public partial class PackageExtractionResult
    {
        public PackageExtractionResult(bool cached, System.TimeSpan signVerifyDelay, PackageSignType packageType, bool success, System.DateTimeOffset signVerifyStartTime, System.DateTimeOffset signVerifyEndTime) { }

        public PackageExtractionResult(bool cached, System.TimeSpan signVerifyDelay, PackageSignType packageType, bool success, System.TimeSpan duration) { }

        public bool Cached { get { throw null; } }

        public System.TimeSpan Duration { get { throw null; } set { } }

        public PackageSignType PackageType { get { throw null; } }

        public System.TimeSpan SignVerifyDelay { get { throw null; } }

        public System.DateTimeOffset SignVerifyEndTime { get { throw null; } }

        public System.DateTimeOffset SignVerifyStartTime { get { throw null; } }

        public bool Success { get { throw null; } }
    }

    public partial class PackageExtractionTelemetryEvent : Common.TelemetryEvent
    {
        public const string EventName = "PackageExtractionInformation";
        public PackageExtractionTelemetryEvent(PackageSaveMode packageSaveMode, Common.NuGetOperationStatus status, ExtractionSource extractionSource, Core.PackageIdentity packageId = null) : base(default!) { }

        public ExtractionSource ExtractionSource { get { throw null; } }

        public string PackageId { get { throw null; } }

        public PackageSaveMode PackageSaveMode { get { throw null; } }

        public string PackageVersion { get { throw null; } }

        public Common.NuGetOperationStatus Status { get { throw null; } }

        public void LogPackageIdentity(Core.PackageIdentity packageId) { }

        public void SetResult(Common.NuGetOperationStatus status) { }
    }

    public static partial class PackageExtractor
    {
        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> CopySatelliteFilesAsync(Core.PackageIdentity packageIdentity, PackagePathResolver packagePathResolver, PackageSaveMode packageSaveMode, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token) { throw null; }

        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> ExtractPackageAsync(string source, PackageReaderBase packageReader, PackagePathResolver packagePathResolver, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }

        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> ExtractPackageAsync(string source, PackageReaderBase packageReader, System.IO.Stream packageStream, PackagePathResolver packagePathResolver, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }

        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> ExtractPackageAsync(string source, System.IO.Stream packageStream, PackagePathResolver packagePathResolver, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }

        public static System.Threading.Tasks.Task<bool> InstallFromSourceAsync(Core.PackageIdentity packageIdentity, IPackageDownloader packageDownloader, VersionFolderPathResolver versionFolderPathResolver, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }

        public static System.Threading.Tasks.Task<bool> InstallFromSourceAsync(string source, Core.PackageIdentity packageIdentity, System.Func<System.IO.Stream, System.Threading.Tasks.Task> copyToAsync, VersionFolderPathResolver versionFolderPathResolver, PackageExtractionContext packageExtractionContext, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }
    }

    public partial class PackageFileExtractor
    {
        public PackageFileExtractor(System.Collections.Generic.IEnumerable<string> packageFiles, XmlDocFileSaveMode xmlDocFileSaveMode) { }

        public string ExtractPackageFile(string source, string target, System.IO.Stream stream) { throw null; }
    }

    public partial class PackageFolderReader : PackageReaderBase
    {
        public PackageFolderReader(System.IO.DirectoryInfo folder, Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) : base(default!) { }

        public PackageFolderReader(System.IO.DirectoryInfo folder) : base(default!) { }

        public PackageFolderReader(string folderPath, Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) : base(default!) { }

        public PackageFolderReader(string folderPath) : base(default!) { }

        public override bool CanVerifySignedPackages(Signing.SignedPackageVerifierSettings verifierSettings) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> CopyFiles(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        protected override void Dispose(bool disposing) { }

        public override System.Threading.Tasks.Task<byte[]> GetArchiveHashAsync(Common.HashAlgorithmName hashAlgorithm, System.Threading.CancellationToken token) { throw null; }

        public override string GetContentHash(System.Threading.CancellationToken token, System.Func<string> GetUnsignedPackageHash = null) { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles() { throw null; }

        public override System.Collections.Generic.IEnumerable<string> GetFiles(string folder) { throw null; }

        public override string GetNuspecFile() { throw null; }

        public override System.Threading.Tasks.Task<Signing.PrimarySignature> GetPrimarySignatureAsync(System.Threading.CancellationToken token) { throw null; }

        public override System.IO.Stream GetStream(string path) { throw null; }

        public override System.Threading.Tasks.Task<bool> IsSignedAsync(System.Threading.CancellationToken token) { throw null; }

        public override System.Threading.Tasks.Task ValidateIntegrityAsync(Signing.SignatureContent signatureContent, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class PackageHelper
    {
        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<ZipFilePair>> GetInstalledPackageFilesAsync(PackageArchiveReader packageReader, Core.PackageIdentity packageIdentity, PackagePathResolver packagePathResolver, PackageSaveMode packageSaveMode, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Threading.Tasks.Task<System.Tuple<string, System.Collections.Generic.IEnumerable<ZipFilePair>>> GetInstalledSatelliteFilesAsync(PackageArchiveReader packageReader, PackagePathResolver packagePathResolver, PackageSaveMode packageSaveMode, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Threading.Tasks.Task<System.Tuple<string, System.Collections.Generic.IEnumerable<string>>> GetSatelliteFilesAsync(PackageReaderBase packageReader, PackagePathResolver packagePathResolver, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static bool IsAssembly(string path) { throw null; }

        public static bool IsManifest(string path) { throw null; }

        public static bool IsNuspec(string path) { throw null; }

        public static bool IsPackageFile(string packageFileName, PackageSaveMode packageSaveMode) { throw null; }

        public static bool IsRoot(string path) { throw null; }
    }

    public static partial class PackageIdValidator
    {
        public const int MaxPackageIdLength = 100;
        public static bool IsValidPackageId(string packageId) { throw null; }

        public static void ValidatePackageId(string packageId) { }
    }

    public static partial class PackagePathHelper
    {
        public static string GetInstalledPackageFilePath(Core.PackageIdentity packageIdentity, PackagePathResolver packagePathResolver) { throw null; }

        public static System.Collections.Generic.IEnumerable<string> GetPackageLookupPaths(Core.PackageIdentity packageIdentity, PackagePathResolver packagePathResolver) { throw null; }
    }

    public partial class PackagePathResolver
    {
        public PackagePathResolver(string rootDirectory, bool useSideBySidePaths = true) { }

        protected internal string Root { get { throw null; } }

        public bool UseSideBySidePaths { get { throw null; } }

        public virtual string GetInstalledPackageFilePath(Core.PackageIdentity packageIdentity) { throw null; }

        public virtual string GetInstalledPath(Core.PackageIdentity packageIdentity) { throw null; }

        public virtual string GetInstallPath(Core.PackageIdentity packageIdentity) { throw null; }

        public string GetManifestFileName(Core.PackageIdentity packageIdentity) { throw null; }

        public virtual string GetPackageDirectoryName(Core.PackageIdentity packageIdentity) { throw null; }

        public string GetPackageDownloadMarkerFileName(Core.PackageIdentity packageIdentity) { throw null; }

        public virtual string GetPackageFileName(Core.PackageIdentity packageIdentity) { throw null; }
    }

    public abstract partial class PackageReaderBase : Core.IPackageCoreReader, System.IDisposable, IPackageContentReader, Core.IAsyncPackageCoreReader, IAsyncPackageContentReader, Signing.ISignedPackageReader
    {
        public PackageReaderBase(Frameworks.IFrameworkNameProvider frameworkProvider, Frameworks.IFrameworkCompatibilityProvider compatibilityProvider) { }

        public PackageReaderBase(Frameworks.IFrameworkNameProvider frameworkProvider) { }

        protected Frameworks.IFrameworkCompatibilityProvider CompatibilityProvider { get { throw null; } set { } }

        protected Frameworks.IFrameworkNameProvider FrameworkProvider { get { throw null; } set { } }

        public virtual NuspecReader NuspecReader { get { throw null; } }

        public abstract bool CanVerifySignedPackages(Signing.SignedPackageVerifierSettings verifierSettings);
        public abstract System.Collections.Generic.IEnumerable<string> CopyFiles(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken token);
        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> CopyFilesAsync(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, Core.ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Threading.Tasks.Task<string> CopyNupkgAsync(string nupkgFilePath, System.Threading.CancellationToken cancellationToken) { throw null; }

        public void Dispose() { }

        protected abstract void Dispose(bool disposing);
        public abstract System.Threading.Tasks.Task<byte[]> GetArchiveHashAsync(Common.HashAlgorithmName hashAlgorithm, System.Threading.CancellationToken token);
        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetBuildItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetBuildItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public abstract string GetContentHash(System.Threading.CancellationToken token, System.Func<string> GetUnsignedPackageHash = null);
        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetContentItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetContentItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual bool GetDevelopmentDependency() { throw null; }

        public virtual System.Threading.Tasks.Task<bool> GetDevelopmentDependencyAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        protected System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFileGroups(string folder) { throw null; }

        public abstract System.Collections.Generic.IEnumerable<string> GetFiles();
        public abstract System.Collections.Generic.IEnumerable<string> GetFiles(string folder);
        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(string folder, System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        protected Frameworks.NuGetFramework GetFrameworkFromPath(string path, bool allowSubFolders = false) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetFrameworkItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetFrameworkItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual Core.PackageIdentity GetIdentity() { throw null; }

        public virtual System.Threading.Tasks.Task<Core.PackageIdentity> GetIdentityAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetItems(string folderName) { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetItemsAsync(string folderName, System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetLibItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetLibItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual Versioning.NuGetVersion GetMinClientVersion() { throw null; }

        public virtual System.Threading.Tasks.Task<Versioning.NuGetVersion> GetMinClientVersionAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.IO.Stream GetNuspec() { throw null; }

        public virtual System.Threading.Tasks.Task<System.IO.Stream> GetNuspecAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual string GetNuspecFile() { throw null; }

        protected static string GetNuspecFile(System.Collections.Generic.IEnumerable<string> files) { throw null; }

        public virtual System.Threading.Tasks.Task<string> GetNuspecFileAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Threading.Tasks.Task<NuspecReader> GetNuspecReaderAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<PackageDependencyGroup> GetPackageDependencies() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<PackageDependencyGroup>> GetPackageDependenciesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IReadOnlyList<Core.PackageType> GetPackageTypes() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<Core.PackageType>> GetPackageTypesAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public abstract System.Threading.Tasks.Task<Signing.PrimarySignature> GetPrimarySignatureAsync(System.Threading.CancellationToken token);
        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetReferenceItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetReferenceItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public abstract System.IO.Stream GetStream(string path);
        public virtual System.Threading.Tasks.Task<System.IO.Stream> GetStreamAsync(string path, System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework> GetSupportedFrameworks() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<Frameworks.NuGetFramework>> GetSupportedFrameworksAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public virtual System.Collections.Generic.IEnumerable<FrameworkSpecificGroup> GetToolItems() { throw null; }

        public virtual System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<FrameworkSpecificGroup>> GetToolItemsAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        protected static bool IsAllowedBuildFile(string packageId, string path) { throw null; }

        protected static bool IsReferenceAssembly(string path) { throw null; }

        public virtual bool IsServiceable() { throw null; }

        public virtual System.Threading.Tasks.Task<bool> IsServiceableAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public abstract System.Threading.Tasks.Task<bool> IsSignedAsync(System.Threading.CancellationToken token);
        protected string NormalizeDirectoryPath(string path) { throw null; }

        public abstract System.Threading.Tasks.Task ValidateIntegrityAsync(Signing.SignatureContent signatureContent, System.Threading.CancellationToken token);
        protected static void ValidatePackageEntries(string normalizedDestination, System.Collections.Generic.IEnumerable<string> packageFiles, Core.PackageIdentity packageIdentity) { }

        protected static void ValidatePackageEntry(string normalizedDestination, string normalizedFilePath, Core.PackageIdentity packageIdentity) { }
    }

    public static partial class PackageReaderExtensions
    {
        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetPackageFilesAsync(this Core.IAsyncPackageCoreReader packageReader, PackageSaveMode packageSaveMode, System.Threading.CancellationToken cancellationToken) { throw null; }

        public static System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetSatelliteFilesAsync(this IAsyncPackageContentReader packageReader, string packageLanguage, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class PackageReference
    {
        public PackageReference(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework, bool userInstalled, bool developmentDependency, bool requireReinstallation, Versioning.VersionRange allowedVersions) { }

        public PackageReference(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework, bool userInstalled, bool developmentDependency, bool requireReinstallation) { }

        public PackageReference(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework, bool userInstalled) { }

        public PackageReference(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework) { }

        public Versioning.VersionRange AllowedVersions { get { throw null; } }

        public bool HasAllowedVersions { get { throw null; } }

        public bool IsDevelopmentDependency { get { throw null; } }

        public bool IsUserInstalled { get { throw null; } }

        public Core.PackageIdentity PackageIdentity { get { throw null; } }

        public bool RequireReinstallation { get { throw null; } }

        public Frameworks.NuGetFramework TargetFramework { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public partial class PackageReferenceSet
    {
        public PackageReferenceSet(Frameworks.NuGetFramework targetFramework, System.Collections.Generic.IEnumerable<string> references) { }

        public PackageReferenceSet(System.Collections.Generic.IEnumerable<string> references) { }

        public PackageReferenceSet(string targetFramework, System.Collections.Generic.IEnumerable<string> references) { }

        public System.Collections.Generic.IReadOnlyCollection<string> References { get { throw null; } }

        public Frameworks.NuGetFramework TargetFramework { get { throw null; } }

        public System.Collections.Generic.IEnumerable<string> Validate() { throw null; }
    }

    [System.Flags]
    public enum PackageSaveMode
    {
        None = 0,
        Nuspec = 1,
        Nupkg = 2,
        Files = 4,
        Defaultv2 = 6,
        Defaultv3 = 7
    }

    public static partial class PackagesConfig
    {
        public static readonly string allowedVersionsAttributeName;
        public static readonly string developmentDependencyAttributeName;
        public static readonly string IdAttributeName;
        public static readonly string MinClientAttributeName;
        public static readonly string PackageNodeName;
        public static readonly string PackagesNodeName;
        public static readonly string RequireInstallAttributeName;
        public static readonly string TargetFrameworkAttributeName;
        public static readonly string UserInstalledAttributeName;
        public static readonly string VersionAttributeName;
        public static bool BoolAttribute(System.Xml.Linq.XElement node, string name, bool defaultValue = false) { throw null; }

        public static bool HasAttributeValue(System.Xml.Linq.XElement node, string attributeName, string targetValue, out System.Xml.Linq.XElement element) { throw null; }

        public static bool TryGetAttribute(System.Xml.Linq.XElement node, string name, out string value) { throw null; }
    }

    public partial class PackagesConfigReader
    {
        public PackagesConfigReader(Frameworks.IFrameworkNameProvider frameworkMappings, System.IO.Stream stream, bool leaveStreamOpen) { }

        public PackagesConfigReader(Frameworks.IFrameworkNameProvider frameworkMappings, System.Xml.Linq.XDocument xml) { }

        public PackagesConfigReader(System.IO.Stream stream, bool leaveStreamOpen) { }

        public PackagesConfigReader(System.IO.Stream stream) { }

        public PackagesConfigReader(System.Xml.Linq.XDocument xml) { }

        public Versioning.NuGetVersion GetMinClientVersion() { throw null; }

        public System.Collections.Generic.IEnumerable<PackageReference> GetPackages() { throw null; }

        public System.Collections.Generic.IEnumerable<PackageReference> GetPackages(bool allowDuplicatePackageIds) { throw null; }
    }

    public partial class PackagesConfigReaderException : Core.PackagingException
    {
        public PackagesConfigReaderException(string message, System.Exception innerException) : base(default!) { }

        public PackagesConfigReaderException(string message) : base(default!) { }
    }

    public partial class PackagesConfigWriter : System.IDisposable
    {
        public PackagesConfigWriter(System.IO.Stream stream, bool createNew, Frameworks.IFrameworkNameProvider frameworkMappings) { }

        public PackagesConfigWriter(System.IO.Stream stream, bool createNew) { }

        public PackagesConfigWriter(string fullPath, bool createNew, Frameworks.IFrameworkNameProvider frameworkMappings) { }

        public PackagesConfigWriter(string fullPath, bool createNew) { }

        public void AddPackageEntry(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework) { }

        public void AddPackageEntry(PackageReference entry) { }

        public void AddPackageEntry(string packageId, Versioning.NuGetVersion version, Frameworks.NuGetFramework targetFramework) { }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }

        public void RemovePackageEntry(Core.PackageIdentity identity, Frameworks.NuGetFramework targetFramework) { }

        public void RemovePackageEntry(PackageReference entry) { }

        public void RemovePackageEntry(string packageId, Versioning.NuGetVersion version, Frameworks.NuGetFramework targetFramework) { }

        public void UpdateOrAddPackageEntry(System.Xml.Linq.XDocument originalConfig, PackageReference newEntry) { }

        public void UpdatePackageEntry(PackageReference oldEntry, PackageReference newEntry) { }

        public void WriteFile(string fullPath) { }

        public void WriteMinClientVersion(Versioning.NuGetVersion version) { }
    }

    public partial class PackagesConfigWriterException : Core.PackagingException
    {
        public PackagesConfigWriterException(string message, System.Exception innerException) : base(default!) { }

        public PackagesConfigWriterException(string message) : base(default!) { }
    }

    public partial class PackageSigningTelemetryEvent : Common.TelemetryEvent
    {
        public const string EventName = "SigningInformation";
        public PackageSigningTelemetryEvent() : base(default!) { }

        public string ExtractionId { get { throw null; } }

        public PackageSignType PackageSignType { get { throw null; } }

        public Common.NuGetOperationStatus Status { get { throw null; } }

        public void SetResult(PackageSignType packageSignType, Common.NuGetOperationStatus status) { }
    }

    public enum PackageSignType
    {
        Signed = 0,
        Unsigned = 1
    }

    public static partial class PackagingConstants
    {
        public static readonly string AgnosticFramework;
        public static readonly string AnyCodeLanguage;
        public static readonly string AnyFramework;
        public static readonly string ContentFilesDefaultBuildAction;
        public static readonly string ManifestExtension;
        public static readonly string PackageVerifyDurationName;
        public static readonly string SnupkgFormat;
        public static readonly string SymbolsNupkgFormat;
        public static readonly string TargetFrameworkPropertyKey;
        public static partial class Folders
        {
            public static readonly string Analyzers;
            public static readonly string Build;
            public static readonly string BuildCrossTargeting;
            public static readonly string BuildTransitive;
            public static readonly string Content;
            public static readonly string ContentFiles;
            public static readonly string Lib;
            public static readonly string Native;
            public static readonly string Ref;
            public static readonly string Runtimes;
            public static readonly string Source;
            public static readonly string Tools;
            public static string[] Known { get { throw null; } }
        }
    }

    public partial class PhysicalPackageFile : IPackageFile
    {
        public PhysicalPackageFile() { }

        public PhysicalPackageFile(System.IO.MemoryStream stream) { }

        public string EffectivePath { get { throw null; } }

        public System.DateTimeOffset LastWriteTime { get { throw null; } }

        public Frameworks.NuGetFramework NuGetFramework { get { throw null; } }

        public string Path { get { throw null; } }

        public string SourcePath { get { throw null; } set { } }

        public System.Runtime.Versioning.FrameworkName TargetFramework { get { throw null; } }

        public string TargetPath { get { throw null; } set { } }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public System.IO.Stream GetStream() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class RepositorySignatureInfo
    {
        public RepositorySignatureInfo(bool allRepositorySigned, System.Collections.Generic.IEnumerable<Core.IRepositoryCertificateInfo> repositoryCertificateInfos) { }

        public bool AllRepositorySigned { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Core.IRepositoryCertificateInfo> RepositoryCertificateInfos { get { throw null; } }
    }

    public partial class RepositorySignatureInfoProvider
    {
        public static RepositorySignatureInfoProvider Instance { get { throw null; } }

        public void AddOrUpdateRepositorySignatureInfo(string source, RepositorySignatureInfo repositorySignatureInfo) { }

        public bool TryGetRepositorySignatureInfo(string source, out RepositorySignatureInfo repositorySignatureInfo) { throw null; }
    }

    public sealed partial class Sha512HashFunction : IHashFunction, System.IDisposable
    {
        public void Dispose() { }

        public string GetHash() { throw null; }

        public byte[] GetHashBytes() { throw null; }

        public void Update(byte[] data, int offset, int count) { }
    }

    public static partial class StreamExtensions
    {
        public static string CopyToFile(this System.IO.Stream inputStream, string fileFullPath) { throw null; }
    }

    public static partial class TopologicalSortUtility
    {
        public static System.Collections.Generic.IReadOnlyList<Core.PackageDependencyInfo> SortPackagesByDependencyOrder(System.Collections.Generic.IEnumerable<Core.PackageDependencyInfo> packages) { throw null; }

        public static System.Collections.Generic.IReadOnlyList<T> SortPackagesByDependencyOrder<T>(System.Collections.Generic.IEnumerable<T> items, System.StringComparer comparer, System.Func<T, string> getId, System.Func<T, string[]> getDependencies)
            where T : class { throw null; }
    }

    public partial class UnsafePackageEntryException : Core.PackagingException, Common.ILogMessageException
    {
        public UnsafePackageEntryException(string message) : base(default!) { }

        public override Common.ILogMessage AsLogMessage() { throw null; }
    }

    public partial class VersionFolderPathResolver
    {
        public VersionFolderPathResolver(string rootPath, bool isLowercase) { }

        public VersionFolderPathResolver(string rootPath) { }

        public bool IsLowerCase { get { throw null; } }

        public string RootPath { get { throw null; } }

        public string GetHashFileName(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetHashPath(string packageId, Versioning.NuGetVersion version) { throw null; }

        public virtual string GetInstallPath(string packageId, Versioning.NuGetVersion version) { throw null; }

        public virtual string GetManifestFileName(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetManifestFilePath(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetNupkgMetadataPath(string packageId, Versioning.NuGetVersion version) { throw null; }

        public virtual string GetPackageDirectory(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetPackageDownloadMarkerFileName(string packageId) { throw null; }

        public virtual string GetPackageFileName(string packageId, Versioning.NuGetVersion version) { throw null; }

        public string GetPackageFilePath(string packageId, Versioning.NuGetVersion version) { throw null; }

        public virtual string GetVersionListDirectory(string packageId) { throw null; }

        public string GetVersionListPath(string packageId) { throw null; }
    }

    public static partial class XElementExtensions
    {
        public static System.Collections.Generic.IEnumerable<System.Xml.Linq.XElement> ElementsNoNamespace(this System.Xml.Linq.XContainer container, string localName) { throw null; }

        public static System.Xml.Linq.XElement Except(this System.Xml.Linq.XElement source, System.Xml.Linq.XElement target) { throw null; }

        public static string GetOptionalAttributeValue(this System.Xml.Linq.XElement element, string localName, string namespaceName = null) { throw null; }
    }

    public enum XmlDocFileSaveMode
    {
        None = 0,
        Skip = 1,
        Compress = 2
    }

    [System.Obsolete("This class is obsolete and will be removed in a future release.")]
    public static partial class XmlUtility
    {
        public static System.Xml.Linq.XDocument LoadSafe(System.IO.Stream input, bool ignoreWhiteSpace) { throw null; }

        public static System.Xml.Linq.XDocument LoadSafe(System.IO.Stream input) { throw null; }
    }

    public static partial class ZipArchiveExtensions
    {
        public static System.Collections.Generic.IEnumerable<string> GetFiles(this System.IO.Compression.ZipArchive zipArchive) { throw null; }

        public static System.IO.Compression.ZipArchiveEntry LookupEntry(this System.IO.Compression.ZipArchive zipArchive, string path) { throw null; }

        public static System.IO.Stream OpenFile(this System.IO.Compression.ZipArchive zipArchive, string path) { throw null; }

        public static string SaveAsFile(this System.IO.Compression.ZipArchiveEntry entry, string fileFullPath, Common.ILogger logger) { throw null; }

        public static void UpdateFileTimeFromEntry(this System.IO.Compression.ZipArchiveEntry entry, string fileFullPath, Common.ILogger logger) { }
    }

    public partial class ZipFilePair
    {
        public ZipFilePair(string fileFullPath, System.IO.Compression.ZipArchiveEntry entry) { }

        public string FileFullPath { get { throw null; } }

        public System.IO.Compression.ZipArchiveEntry PackageEntry { get { throw null; } }

        public bool IsInstalled() { throw null; }
    }
}

namespace NuGet.Packaging.Core
{
    public partial class ContentFilesEntry
    {
        public ContentFilesEntry(string include, string exclude, string buildAction, bool? copyToOutput, bool? flatten) { }

        public string BuildAction { get { throw null; } }

        public bool? CopyToOutput { get { throw null; } }

        public string Exclude { get { throw null; } }

        public bool? Flatten { get { throw null; } }

        public string Include { get { throw null; } }
    }

    public delegate string ExtractPackageFileDelegate(string sourceFile, string targetPath, System.IO.Stream fileStream);
    public partial class Fingerprints
    {
        public Fingerprints(System.Collections.Generic.IDictionary<string, string> fingerPrints) { }

        public string this[string key] { get { throw null; } }

        public System.Collections.Generic.IEnumerator<System.Collections.Generic.KeyValuePair<string, string>> GetEnumerator() { throw null; }
    }

    public partial interface IAsyncPackageCoreReader : System.IDisposable
    {
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> CopyFilesAsync(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(string folder, System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IEnumerable<string>> GetFilesAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<PackageIdentity> GetIdentityAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<Versioning.NuGetVersion> GetMinClientVersionAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.IO.Stream> GetNuspecAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<string> GetNuspecFileAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.Collections.Generic.IReadOnlyList<PackageType>> GetPackageTypesAsync(System.Threading.CancellationToken cancellationToken);
        System.Threading.Tasks.Task<System.IO.Stream> GetStreamAsync(string path, System.Threading.CancellationToken cancellationToken);
    }

    public partial interface INuspecCoreReader
    {
        string GetId();
        PackageIdentity GetIdentity();
        System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, string>> GetMetadata();
        Versioning.NuGetVersion GetMinClientVersion();
        System.Collections.Generic.IReadOnlyList<PackageType> GetPackageTypes();
        Versioning.NuGetVersion GetVersion();
    }

    public partial interface IPackageCoreReader : System.IDisposable
    {
        System.Collections.Generic.IEnumerable<string> CopyFiles(string destination, System.Collections.Generic.IEnumerable<string> packageFiles, ExtractPackageFileDelegate extractFile, Common.ILogger logger, System.Threading.CancellationToken token);
        System.Collections.Generic.IEnumerable<string> GetFiles();
        System.Collections.Generic.IEnumerable<string> GetFiles(string folder);
        PackageIdentity GetIdentity();
        Versioning.NuGetVersion GetMinClientVersion();
        System.IO.Stream GetNuspec();
        string GetNuspecFile();
        System.Collections.Generic.IReadOnlyList<PackageType> GetPackageTypes();
        System.IO.Stream GetStream(string path);
    }

    public partial interface IPackageIdentityComparer : System.Collections.Generic.IEqualityComparer<PackageIdentity>, System.Collections.Generic.IComparer<PackageIdentity>
    {
    }

    public partial interface IRepositoryCertificateInfo
    {
        string ContentUrl { get; }

        Fingerprints Fingerprints { get; }

        string Issuer { get; }

        System.DateTimeOffset NotAfter { get; }

        System.DateTimeOffset NotBefore { get; }

        string Subject { get; }
    }

    public partial class NuspecCoreReader : NuspecCoreReaderBase
    {
        public NuspecCoreReader(System.IO.Stream stream) : base(default(string)!) { }

        public NuspecCoreReader(System.Xml.Linq.XDocument xml) : base(default(string)!) { }

        public virtual System.Collections.Generic.IEnumerable<PackageDependency> GetDependencies() { throw null; }
    }

    public abstract partial class NuspecCoreReaderBase : INuspecCoreReader
    {
        protected const string DevelopmentDependency = "developmentDependency";
        protected const string Id = "id";
        protected const string Metadata = "metadata";
        protected const string MinClientVersion = "minClientVersion";
        protected const string Version = "version";
        public NuspecCoreReaderBase(System.IO.Stream stream, bool leaveStreamOpen) { }

        public NuspecCoreReaderBase(System.IO.Stream stream) { }

        public NuspecCoreReaderBase(string path) { }

        public NuspecCoreReaderBase(System.Xml.Linq.XDocument xml) { }

        protected System.Xml.Linq.XElement MetadataNode { get { throw null; } }

        protected System.Collections.Generic.Dictionary<string, string> MetadataValues { get { throw null; } }

        public System.Xml.Linq.XDocument Xml { get { throw null; } }

        public virtual bool GetDevelopmentDependency() { throw null; }

        public virtual string GetId() { throw null; }

        public virtual PackageIdentity GetIdentity() { throw null; }

        public virtual System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, string>> GetMetadata() { throw null; }

        public virtual string GetMetadataValue(string name) { throw null; }

        public virtual Versioning.NuGetVersion GetMinClientVersion() { throw null; }

        public virtual System.Collections.Generic.IReadOnlyList<PackageType> GetPackageTypes() { throw null; }

        public virtual Versioning.NuGetVersion GetVersion() { throw null; }

        public virtual bool IsServiceable() { throw null; }
    }

    public static partial class NuspecUtility
    {
        public static readonly string FrameworkReference;
        public static readonly string FrameworkReferences;
        public static readonly string Group;
        public static readonly string License;
        public static readonly string Name;
        public static readonly string PackageType;
        public static readonly string PackageTypes;
        public static readonly string Repository;
        public static readonly string RepositoryBranch;
        public static readonly string RepositoryCommit;
        public static readonly string RepositoryUrl;
        public static readonly string Serviceable;
        public static readonly string TargetFramework;
        public static readonly string Type;
        public static readonly string Version;
        public static System.Collections.Generic.IReadOnlyList<PackageType> GetPackageTypes(System.Xml.Linq.XElement metadataNode, bool useMetadataNamespace) { throw null; }

        public static bool IsServiceable(System.Xml.Linq.XElement metadataNode) { throw null; }
    }

    public partial class PackageDependency : System.IEquatable<PackageDependency>
    {
        public PackageDependency(string id, Versioning.VersionRange versionRange, System.Collections.Generic.IReadOnlyList<string> include, System.Collections.Generic.IReadOnlyList<string> exclude) { }

        public PackageDependency(string id, Versioning.VersionRange versionRange) { }

        public PackageDependency(string id) { }

        public System.Collections.Generic.IReadOnlyList<string> Exclude { get { throw null; } }

        public string Id { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> Include { get { throw null; } }

        public Versioning.VersionRange VersionRange { get { throw null; } }

        public bool Equals(PackageDependency other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class PackageDependencyComparer : System.Collections.Generic.IEqualityComparer<PackageDependency>
    {
        public static readonly PackageDependencyComparer Default;
        public PackageDependencyComparer() { }

        public PackageDependencyComparer(Versioning.IVersionRangeComparer versionRangeComparer) { }

        public bool Equals(PackageDependency x, PackageDependency y) { throw null; }

        public int GetHashCode(PackageDependency obj) { throw null; }
    }

    public partial class PackageDependencyInfo : PackageIdentity, System.IEquatable<PackageDependencyInfo>
    {
        public PackageDependencyInfo(PackageIdentity identity, System.Collections.Generic.IEnumerable<PackageDependency> dependencies) : base(default!, default!) { }

        public PackageDependencyInfo(string id, Versioning.NuGetVersion version, System.Collections.Generic.IEnumerable<PackageDependency> dependencies) : base(default!, default!) { }

        public PackageDependencyInfo(string id, Versioning.NuGetVersion version) : base(default!, default!) { }

        public System.Collections.Generic.IEnumerable<PackageDependency> Dependencies { get { throw null; } }

        public bool Equals(PackageDependencyInfo other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class PackageDependencyInfoComparer : System.Collections.Generic.IEqualityComparer<PackageDependencyInfo>
    {
        public PackageDependencyInfoComparer() { }

        public PackageDependencyInfoComparer(IPackageIdentityComparer identityComparer, PackageDependencyComparer dependencyComparer) { }

        public static PackageDependencyInfoComparer Default { get { throw null; } }

        public bool Equals(PackageDependencyInfo x, PackageDependencyInfo y) { throw null; }

        public int GetHashCode(PackageDependencyInfo obj) { throw null; }
    }

    public partial class PackageIdentity : System.IEquatable<PackageIdentity>, System.IComparable<PackageIdentity>
    {
        public PackageIdentity(string id, Versioning.NuGetVersion version) { }

        public static PackageIdentityComparer Comparer { get { throw null; } }

        public bool HasVersion { get { throw null; } }

        public string Id { get { throw null; } }

        public Versioning.NuGetVersion Version { get { throw null; } }

        public int CompareTo(PackageIdentity other) { throw null; }

        public virtual bool Equals(PackageIdentity other, Versioning.VersionComparison versionComparison) { throw null; }

        public bool Equals(PackageIdentity other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class PackageIdentityComparer : IPackageIdentityComparer, System.Collections.Generic.IEqualityComparer<PackageIdentity>, System.Collections.Generic.IComparer<PackageIdentity>
    {
        public PackageIdentityComparer() { }

        public PackageIdentityComparer(Versioning.IVersionComparer versionComparer) { }

        public PackageIdentityComparer(Versioning.VersionComparison versionComparison) { }

        public static PackageIdentityComparer Default { get { throw null; } }

        public int Compare(PackageIdentity x, PackageIdentity y) { throw null; }

        public bool Equals(PackageIdentity x, PackageIdentity y) { throw null; }

        public int GetHashCode(PackageIdentity obj) { throw null; }
    }

    public partial class PackageType : System.IEquatable<PackageType>, System.IComparable<PackageType>
    {
        public static readonly PackageType Dependency;
        public static readonly PackageType DotnetCliTool;
        public static readonly PackageType DotnetPlatform;
        public static readonly PackageType DotnetTool;
        public static readonly System.Version EmptyVersion;
        public static readonly PackageType Legacy;
        public static readonly System.StringComparer PackageTypeNameComparer;
        public static readonly PackageType SymbolsPackage;
        public PackageType(string name, System.Version version) { }

        public string Name { get { throw null; } }

        public System.Version Version { get { throw null; } }

        public int CompareTo(PackageType other) { throw null; }

        public bool Equals(PackageType other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public static bool operator ==(PackageType a, PackageType b) { throw null; }

        public static bool operator !=(PackageType a, PackageType b) { throw null; }
    }

    public static partial class PackagingCoreConstants
    {
        public static readonly string EmptyFolder;
        public static readonly string ForwardSlashEmptyFolder;
        public static readonly string HashFileExtension;
        public static readonly string NupkgExtension;
        public static readonly string NupkgMetadataFileExtension;
        public static readonly string NuspecExtension;
        public static readonly string PackageDownloadMarkerFileExtension;
    }

    public partial class PackagingException : System.Exception, Common.ILogMessageException
    {
        public PackagingException(Common.NuGetLogCode logCode, string message, System.Exception innerException) { }

        public PackagingException(Common.NuGetLogCode logCode, string message) { }

        public PackagingException(string message, System.Exception innerException) { }

        public PackagingException(string message) { }

        public virtual Common.ILogMessage AsLogMessage() { throw null; }
    }

    public partial class RepositoryMetadata : System.IEquatable<RepositoryMetadata>
    {
        public RepositoryMetadata() { }

        public RepositoryMetadata(string type, string url, string branch, string commit) { }

        public string Branch { get { throw null; } set { } }

        public string Commit { get { throw null; } set { } }

        public string Type { get { throw null; } set { } }

        public string Url { get { throw null; } set { } }

        public bool Equals(RepositoryMetadata other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public static bool operator ==(RepositoryMetadata a, RepositoryMetadata b) { throw null; }

        public static bool operator !=(RepositoryMetadata a, RepositoryMetadata b) { throw null; }
    }
}

namespace NuGet.Packaging.Licenses
{
    public partial class ExceptionData
    {
        public ExceptionData(string licenseID, bool isDeprecatedLicenseId) { }

        public bool IsDeprecatedLicenseId { get { throw null; } }

        public string LicenseExceptionID { get { throw null; } }
    }

    public partial class LicenseData
    {
        public LicenseData(string licenseID, bool isOsiApproved, bool isDeprecatedLicenseId, bool isFsfLibre) { }

        public bool IsDeprecatedLicenseId { get { throw null; } }

        public bool IsFsfLibre { get { throw null; } }

        public bool IsOsiApproved { get { throw null; } }

        public string LicenseID { get { throw null; } }
    }

    public enum LicenseExpressionType
    {
        License = 0,
        Operator = 1
    }

    public abstract partial class LicenseOperator : NuGetLicenseExpression
    {
        protected LicenseOperator(LicenseOperatorType operatorType) { }

        public LicenseOperatorType OperatorType { get { throw null; } }
    }

    public enum LicenseOperatorType
    {
        WithOperator = 0,
        LogicalOperator = 1
    }

    public partial class LogicalOperator : LicenseOperator
    {
        public LogicalOperator(LogicalOperatorType logicalOperatorType, NuGetLicenseExpression left, NuGetLicenseExpression right) : base(default) { }

        public NuGetLicenseExpression Left { get { throw null; } }

        public LogicalOperatorType LogicalOperatorType { get { throw null; } }

        public NuGetLicenseExpression Right { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public enum LogicalOperatorType
    {
        And = 0,
        Or = 1
    }

    public partial class NuGetLicense : NuGetLicenseExpression
    {
        internal NuGetLicense() { }

        public string Identifier { get { throw null; } }

        public bool IsStandardLicense { get { throw null; } }

        public bool Plus { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public static partial class NuGetLicenseData
    {
        public static readonly System.Collections.Generic.IReadOnlyDictionary<string, ExceptionData> ExceptionList;
        public static readonly System.Collections.Generic.IReadOnlyDictionary<string, LicenseData> LicenseList;
        public static string LicenseListVersion { get { throw null; } }
    }

    public partial class NuGetLicenseException
    {
        internal NuGetLicenseException() { }

        public string Identifier { get { throw null; } }

        public override string ToString() { throw null; }
    }

    public abstract partial class NuGetLicenseExpression
    {
        public LicenseExpressionType Type { get { throw null; } protected set { } }

        public static NuGetLicenseExpression Parse(string expression) { throw null; }
    }

    public static partial class NuGetLicenseExpressionExtensions
    {
        public static bool HasOnlyStandardIdentifiers(this NuGetLicenseExpression expression) { throw null; }

        public static bool IsUnlicensed(this NuGetLicense license) { throw null; }

        public static bool IsUnlicensed(this NuGetLicenseExpression expression) { throw null; }

        public static void OnEachLeafNode(this NuGetLicenseExpression expression, System.Action<NuGetLicense> licenseProcessor, System.Action<NuGetLicenseException> exceptionProcessor) { }
    }

    public partial class NuGetLicenseExpressionParsingException : System.Exception
    {
        public NuGetLicenseExpressionParsingException(string message, System.Exception innerException) { }

        public NuGetLicenseExpressionParsingException(string message) { }
    }

    public partial class WithOperator : LicenseOperator
    {
        public WithOperator(NuGetLicense license, NuGetLicenseException exception) : base(default) { }

        public NuGetLicenseException Exception { get { throw null; } }

        public NuGetLicense License { get { throw null; } }

        public override string ToString() { throw null; }
    }
}

namespace NuGet.Packaging.PackageExtraction
{
    public static partial class PackageExtractionBehavior
    {
        public static XmlDocFileSaveMode XmlDocFileSaveMode { get { throw null; } set { } }
    }
}

namespace NuGet.Packaging.Rules
{
    [System.CodeDom.Compiler.GeneratedCode("System.Resources.Tools.StronglyTypedResourceBuilder", "16.0.0.0")]
    public partial class AnalysisResources
    {
        internal AnalysisResources() { }

        public static string AssemblyDirectlyUnderLibWarning { get { throw null; } }

        public static string AssemblyOutsideLibWarning { get { throw null; } }

        public static string BuildConventionIsViolatedWarning { get { throw null; } }

        public static System.Globalization.CultureInfo Culture { get { throw null; } set { } }

        public static string DefaultSpecValueWarning { get { throw null; } }

        public static string DependenciesGroupsForEachTFMBeginningToFiles { get { throw null; } }

        public static string DependenciesGroupsForEachTFMBeginningToNuspec { get { throw null; } }

        public static string DependenciesGroupsForEachTFMEndingToFile { get { throw null; } }

        public static string DependenciesGroupsForEachTFMEndingToNuspec { get { throw null; } }

        public static string DependenciesGroupsForEachTFMHasCompatMatch { get { throw null; } }

        public static string DependenciesGroupsForEachTFMHasNoExactMatch { get { throw null; } }

        public static string FilePathTooLongWarning { get { throw null; } }

        public static string IconUrlDeprecationWarning { get { throw null; } }

        public static string InvalidFrameworkWarning { get { throw null; } }

        public static string InvalidPlaceholderFileWarning { get { throw null; } }

        public static string InvalidPrereleaseDependencyWarning { get { throw null; } }

        public static string InvalidUndottedFrameworkInDependencyGroupsWarning { get { throw null; } }

        public static string InvalidUndottedFrameworkInFilesWarning { get { throw null; } }

        public static string InvalidUndottedFrameworkInFrameworkAssemblyGroupsWarning { get { throw null; } }

        public static string InvalidUndottedFrameworkInReferenceGroupsWarning { get { throw null; } }

        public static string InvalidUndottedFrameworkWarning { get { throw null; } }

        public static string LegacyVersionWarning { get { throw null; } }

        public static string LicenseUrlDeprecationWarning { get { throw null; } }

        public static string Migrator_AssemblyDirectlyUnderLibWarning { get { throw null; } }

        public static string Migrator_PackageHasContentFolder { get { throw null; } }

        public static string Migrator_PackageHasInstallScript { get { throw null; } }

        public static string Migrator_XdtTransformInPackage { get { throw null; } }

        public static string MisplacedInitScriptWarning { get { throw null; } }

        public static string MisplacedTransformFileWarning { get { throw null; } }

        public static string NoRefOrLibFolderInPackage { get { throw null; } }

        public static string PlaceholderFileInPackageWarning { get { throw null; } }

        public static string ReferencesInNuspecAndRefFilesDontMatchWarning { get { throw null; } }

        public static string ReferencesInNuspecAndRefFilesDontMatchWarningAddToNuspecListItemFormat { get { throw null; } }

        public static string ReferencesInNuspecAndRefFilesDontMatchWarningAddToNuspecNoTfmListItemFormat { get { throw null; } }

        public static string ReferencesInNuspecAndRefFilesDontMatchWarningAddToRefListItemFormat { get { throw null; } }

        public static System.Resources.ResourceManager ResourceManager { get { throw null; } }

        public static string ScriptOutsideToolsWarning { get { throw null; } }

        public static string UnrecognizedLicenseIdentifier { get { throw null; } }

        public static string UnrecognizedScriptWarning { get { throw null; } }

        public static string UnspecifiedDependencyVersionWarning { get { throw null; } }

        public static string WinRTObsoleteWarning { get { throw null; } }
    }

    public partial class DefaultManifestValuesRule : IPackageRule
    {
        public DefaultManifestValuesRule(string messageFormat) { }

        public string MessageFormat { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder) { throw null; }
    }

    public partial class IconUrlDeprecationWarning : IPackageRule
    {
        public IconUrlDeprecationWarning(string messageFormat) { }

        public string MessageFormat { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder) { throw null; }
    }

    public partial interface IPackageRule
    {
        string MessageFormat { get; }

        System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder);
    }

    public partial class LicenseUrlDeprecationWarning : IPackageRule
    {
        public LicenseUrlDeprecationWarning(string messageFormat) { }

        public string MessageFormat { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder) { throw null; }
    }

    public partial class PathTooLongRule : IPackageRule
    {
        public PathTooLongRule(string messageFormat) { }

        public string MessageFormat { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder) { throw null; }
    }

    public static partial class RuleSet
    {
        public static System.Collections.Generic.IEnumerable<IPackageRule> PackageCreationRuleSet { get { throw null; } }

        public static System.Collections.Generic.IEnumerable<IPackageRule> PackagesConfigToPackageReferenceMigrationRuleSet { get { throw null; } }
    }

    public partial class UnspecifiedDependencyVersionRule : IPackageRule
    {
        public UnspecifiedDependencyVersionRule(string messageFormat) { }

        public string MessageFormat { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.PackagingLogMessage> Validate(PackageArchiveReader builder) { throw null; }
    }
}

namespace NuGet.Packaging.Signing
{
    public sealed partial class Accuracy
    {
        internal Accuracy() { }

        public int? Microseconds { get { throw null; } }

        public int? Milliseconds { get { throw null; } }

        public int? Seconds { get { throw null; } }

        public long? GetTotalMicroseconds() { throw null; }

        public static Accuracy Read(byte[] bytes) { throw null; }
    }

    public sealed partial class AlgorithmIdentifier
    {
        internal AlgorithmIdentifier() { }

        public System.Security.Cryptography.Oid Algorithm { get { throw null; } }

        public static AlgorithmIdentifier Read(byte[] bytes) { throw null; }
    }

    public partial class AllowListVerificationProvider : ISignatureVerificationProvider
    {
        public AllowListVerificationProvider(System.Collections.Generic.IReadOnlyCollection<VerificationAllowListEntry> allowList, bool requireNonEmptyAllowList = false, string emptyListErrorMessage = "", string noMatchErrorMessage = "") { }

        public System.Threading.Tasks.Task<PackageVerificationResult> GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class AttributeUtility
    {
        public static System.Security.Cryptography.CryptographicAttributeObject CreateCommitmentTypeIndication(SignatureType type) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObject CreateNuGetPackageOwners(System.Collections.Generic.IReadOnlyList<string> packageOwners) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObject CreateNuGetV3ServiceIndexUrl(System.Uri v3ServiceIndexUrl) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObject CreateSigningCertificateV2(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithm) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObject GetAttribute(this System.Security.Cryptography.CryptographicAttributeObjectCollection attributes, string oid) { throw null; }

        public static System.Collections.Generic.IEnumerable<System.Security.Cryptography.CryptographicAttributeObject> GetAttributes(this System.Security.Cryptography.CryptographicAttributeObjectCollection attributes, string oid) { throw null; }

        public static System.Collections.Generic.IReadOnlyList<string> GetNuGetPackageOwners(System.Security.Cryptography.CryptographicAttributeObjectCollection signedAttributes) { throw null; }

        public static System.Uri GetNuGetV3ServiceIndexUrl(System.Security.Cryptography.CryptographicAttributeObjectCollection signedAttributes) { throw null; }

        public static SignatureType GetSignatureType(System.Security.Cryptography.CryptographicAttributeObjectCollection signedAttributes) { throw null; }

        public static SignatureType GetSignatureType(string oid) { throw null; }

        public static string GetSignatureTypeOid(SignatureType signatureType) { throw null; }
    }

    public sealed partial class AuthorPrimarySignature : PrimarySignature
    {
        public AuthorPrimarySignature(System.Security.Cryptography.Pkcs.SignedCms signedCms) : base(default!, default) { }

        public override string FriendlyName { get { throw null; } }

        public override SignatureVerificationSummary Verify(Timestamp timestamp, SignatureVerifySettings settings, Common.HashAlgorithmName fingerprintAlgorithm, System.Security.Cryptography.X509Certificates.X509Certificate2Collection certificateExtraStore) { throw null; }
    }

    public sealed partial class AuthorSignPackageRequest : SignPackageRequest
    {
        public AuthorSignPackageRequest(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName signatureHashAlgorithm, Common.HashAlgorithmName timestampHashAlgorithm) : base(default!, default, default) { }

        public AuthorSignPackageRequest(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithm) : base(default!, default, default) { }

        public override SignatureType SignatureType { get { throw null; } }
    }

    public sealed partial class CentralDirectoryHeaderMetadata
    {
        public long ChangeInOffset { get { throw null; } set { } }

        public long FileEntryTotalSize { get { throw null; } set { } }

        public long HeaderSize { get { throw null; } set { } }

        public int IndexInHeaders { get { throw null; } set { } }

        public bool IsPackageSignatureFile { get { throw null; } set { } }

        public long OffsetToLocalFileHeader { get { throw null; } set { } }

        public long Position { get { throw null; } set { } }
    }

    public static partial class CertificateChainUtility
    {
        public static IX509CertificateChain GetCertificateChain(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, System.Security.Cryptography.X509Certificates.X509Certificate2Collection extraStore, Common.ILogger logger, CertificateType certificateType) { throw null; }

        public static IX509CertificateChain GetCertificateChain(System.Security.Cryptography.X509Certificates.X509Chain x509Chain) { throw null; }
    }

    public partial class CertificateHashAllowListEntry : VerificationAllowListEntry
    {
        public CertificateHashAllowListEntry(VerificationTarget target, SignaturePlacement placement, string fingerprint, Common.HashAlgorithmName algorithm) : base(default, default) { }

        public string Fingerprint { get { throw null; } }

        public Common.HashAlgorithmName FingerprintAlgorithm { get { throw null; } }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public enum CertificateType
    {
        Signature = 0,
        Timestamp = 1
    }

    public static partial class CertificateUtility
    {
        public static byte[] GetHash(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithm) { throw null; }

        public static string GetHashString(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithm) { throw null; }

        public static System.Collections.Generic.IReadOnlyList<byte[]> GetRawDataForCollection(System.Security.Cryptography.X509Certificates.X509Certificate2Collection certificates) { throw null; }

        public static bool HasExtendedKeyUsage(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, string ekuOid) { throw null; }

        public static bool HasLifetimeSigningEku(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static bool IsCertificatePublicKeyValid(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static bool IsCertificateValidityPeriodInTheFuture(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static bool IsDateInsideValidityPeriod(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, System.DateTimeOffset date) { throw null; }

        public static bool IsSelfIssued(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static bool IsSignatureAlgorithmSupported(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static bool IsValidForPurposeFast(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, string ekuOid) { throw null; }

        public static string X509Certificate2CollectionToString(System.Security.Cryptography.X509Certificates.X509Certificate2Collection certCollection, Common.HashAlgorithmName fingerprintAlgorithm) { throw null; }

        public static string X509Certificate2ToString(System.Security.Cryptography.X509Certificates.X509Certificate2 cert, Common.HashAlgorithmName fingerprintAlgorithm) { throw null; }

        public static string X509ChainToString(System.Security.Cryptography.X509Certificates.X509Chain chain, Common.HashAlgorithmName fingerprintAlgorithm) { throw null; }
    }

    public partial class ClientPolicyContext
    {
        internal ClientPolicyContext() { }

        public System.Collections.Generic.IReadOnlyCollection<TrustedSignerAllowListEntry> AllowList { get { throw null; } }

        public Common.SignatureValidationMode Policy { get { throw null; } }

        public SignedPackageVerifierSettings VerifierSettings { get { throw null; } }

        public static ClientPolicyContext GetClientPolicy(Configuration.ISettings settings, Common.ILogger logger) { throw null; }
    }

    public sealed partial class CommitmentTypeIndication
    {
        internal CommitmentTypeIndication() { }

        public System.Security.Cryptography.Oid CommitmentTypeId { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<CommitmentTypeQualifier> Qualifiers { get { throw null; } }

        public static CommitmentTypeIndication Create(System.Security.Cryptography.Oid commitmentTypeId) { throw null; }

        public static CommitmentTypeIndication Read(byte[] bytes) { throw null; }
    }

    public sealed partial class CommitmentTypeQualifier
    {
        internal CommitmentTypeQualifier() { }

        public System.Security.Cryptography.Oid CommitmentTypeIdentifier { get { throw null; } }

        public byte[] Qualifier { get { throw null; } }

        public static CommitmentTypeQualifier Read(byte[] bytes) { throw null; }
    }

    public static partial class Crc32
    {
        [System.CLSCompliant(false)]
        public static uint CalculateCrc(byte[] data) { throw null; }
    }

    public sealed partial class EssCertId
    {
        internal EssCertId() { }

        public byte[] CertificateHash { get { throw null; } }

        public IssuerSerial IssuerSerial { get { throw null; } }

        public static EssCertId Read(byte[] bytes) { throw null; }
    }

    public sealed partial class EssCertIdV2
    {
        internal EssCertIdV2() { }

        public byte[] CertificateHash { get { throw null; } }

        public AlgorithmIdentifier HashAlgorithm { get { throw null; } }

        public IssuerSerial IssuerSerial { get { throw null; } }

        public static EssCertIdV2 Create(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithmName) { throw null; }

        public static EssCertIdV2 Read(byte[] bytes) { throw null; }
    }

    public sealed partial class Extension
    {
        internal Extension() { }

        public bool Critical { get { throw null; } }

        public System.Security.Cryptography.Oid Id { get { throw null; } }

        public byte[] Value { get { throw null; } }
    }

    public sealed partial class Extensions
    {
        internal Extensions() { }

        public System.Collections.Generic.IReadOnlyList<Extension> ExtensionsList { get { throw null; } }

        public static Extensions Read(byte[] bytes) { throw null; }
    }

    public sealed partial class GeneralName
    {
        internal GeneralName() { }

        public System.Security.Cryptography.X509Certificates.X500DistinguishedName DirectoryName { get { throw null; } }

        public static GeneralName Create(System.Security.Cryptography.X509Certificates.X500DistinguishedName distinguishedName) { throw null; }

        public static GeneralName Read(byte[] bytes) { throw null; }
    }

    public partial class IntegrityVerificationProvider : ISignatureVerificationProvider
    {
        public System.Threading.Tasks.Task<PackageVerificationResult> GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token) { throw null; }
    }

    public partial class InvalidSignaturePackageVerificationResult : PackageVerificationResult
    {
        public InvalidSignaturePackageVerificationResult(SignatureVerificationStatus trust, System.Collections.Generic.IEnumerable<SignatureLog> issues) : base(default, default!) { }
    }

    public partial interface IPackageSignatureVerifier
    {
        System.Threading.Tasks.Task<VerifySignaturesResult> VerifySignaturesAsync(ISignedPackageReader package, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token, System.Guid telemetryOperationId);
    }

    public partial interface IRepositorySignature : ISignature
    {
        System.Collections.Generic.IReadOnlyList<string> PackageOwners { get; }

        System.Uri V3ServiceIndexUrl { get; }
    }

    public partial interface ISignature
    {
        System.Security.Cryptography.Pkcs.SignerInfo SignerInfo { get; }

        SignatureType Type { get; }
    }

    public partial interface ISignatureProvider
    {
        System.Threading.Tasks.Task<PrimarySignature> CreatePrimarySignatureAsync(SignPackageRequest request, SignatureContent signatureContent, Common.ILogger logger, System.Threading.CancellationToken token);
        System.Threading.Tasks.Task<PrimarySignature> CreateRepositoryCountersignatureAsync(RepositorySignPackageRequest request, PrimarySignature primarySignature, Common.ILogger logger, System.Threading.CancellationToken token);
    }

    public partial interface ISignatureVerificationProvider
    {
        System.Threading.Tasks.Task<PackageVerificationResult> GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token);
    }

    public partial interface ISignedPackage : ISignedPackageReader, System.IDisposable, ISignedPackageWriter
    {
    }

    public partial interface ISignedPackageReader : System.IDisposable
    {
        bool CanVerifySignedPackages(SignedPackageVerifierSettings verifierSettings);
        System.Threading.Tasks.Task<byte[]> GetArchiveHashAsync(Common.HashAlgorithmName hashAlgorithm, System.Threading.CancellationToken token);
        string GetContentHash(System.Threading.CancellationToken token, System.Func<string> GetUnsignedPackageHash = null);
        System.Threading.Tasks.Task<PrimarySignature> GetPrimarySignatureAsync(System.Threading.CancellationToken token);
        System.Threading.Tasks.Task<bool> IsSignedAsync(System.Threading.CancellationToken token);
        System.Threading.Tasks.Task ValidateIntegrityAsync(SignatureContent signatureContent, System.Threading.CancellationToken token);
    }

    public partial interface ISignedPackageWriter
    {
        System.Threading.Tasks.Task AddSignatureAsync(System.IO.Stream signatureStream, System.Threading.CancellationToken token);
        System.Threading.Tasks.Task<bool> IsZip64Async(System.Threading.CancellationToken token);
        System.Threading.Tasks.Task RemoveSignatureAsync(System.Threading.CancellationToken token);
    }

    public sealed partial class IssuerSerial
    {
        internal IssuerSerial() { }

        public System.Collections.Generic.IReadOnlyList<GeneralName> GeneralNames { get { throw null; } }

        public byte[] SerialNumber { get { throw null; } }

        public static IssuerSerial Create(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate) { throw null; }

        public static IssuerSerial Read(byte[] bytes) { throw null; }
    }

    public partial interface ITimestampProvider
    {
        System.Threading.Tasks.Task<PrimarySignature> TimestampSignatureAsync(PrimarySignature primarySignature, TimestampRequest request, Common.ILogger logger, System.Threading.CancellationToken token);
    }

    public partial interface ITrustedSignersProvider
    {
        void AddOrUpdateTrustedSigner(Configuration.TrustedSignerItem trustedSigner);
        System.Collections.Generic.IReadOnlyList<Configuration.TrustedSignerItem> GetTrustedSigners();
        void Remove(System.Collections.Generic.IReadOnlyList<Configuration.TrustedSignerItem> trustedSigners);
    }

    public partial interface IX509CertificateChain : System.Collections.Generic.IReadOnlyList<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.Collections.Generic.IEnumerable<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.IDisposable
    {
    }

    public partial class KeyPairFileReader : System.IDisposable
    {
        public KeyPairFileReader(System.IO.Stream stream, System.Text.Encoding encoding) { }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }

        public System.Collections.Generic.Dictionary<string, string> ReadSection() { throw null; }
    }

    public static partial class KeyPairFileUtility
    {
        public static string GetValueOrThrow(System.Collections.Generic.Dictionary<string, string> values, string key) { throw null; }
    }

    public partial class KeyPairFileWriter : System.IDisposable
    {
        public KeyPairFileWriter(System.IO.Stream stream, System.Text.Encoding encoding, bool leaveOpen) { }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }

        public void WritePair(string key, string value) { }

        public void WriteSectionBreak() { }
    }

    public sealed partial class MessageImprint
    {
        internal MessageImprint() { }

        public AlgorithmIdentifier HashAlgorithm { get { throw null; } }

        public byte[] HashedMessage { get { throw null; } }

        public static MessageImprint Read(byte[] bytes) { throw null; }
    }

    public sealed partial class NuGetPackageOwners
    {
        public NuGetPackageOwners(System.Collections.Generic.IReadOnlyList<string> packageOwners) { }

        public System.Collections.Generic.IReadOnlyList<string> PackageOwners { get { throw null; } }

        public byte[] Encode() { throw null; }

        public static NuGetPackageOwners Read(byte[] bytes) { throw null; }
    }

    public sealed partial class NuGetV3ServiceIndexUrl
    {
        public NuGetV3ServiceIndexUrl(System.Uri v3ServiceIndexUrl) { }

        public System.Uri V3ServiceIndexUrl { get { throw null; } }

        public byte[] Encode() { throw null; }

        public static NuGetV3ServiceIndexUrl Read(byte[] bytes) { throw null; }
    }

    public static partial class Oids
    {
        public const string AnyPolicy = "2.5.29.32.0";
        public const string AuthorityKeyIdentifier = "2.5.29.35";
        public const string BaselineTimestampPolicy = "0.4.0.2023.1.1";
        public const string CodeSigningEku = "1.3.6.1.5.5.7.3.3";
        public const string CommitmentTypeIdentifierProofOfOrigin = "1.2.840.113549.1.9.16.6.1";
        public const string CommitmentTypeIdentifierProofOfReceipt = "1.2.840.113549.1.9.16.6.2";
        public const string CommitmentTypeIndication = "1.2.840.113549.1.9.16.2.16";
        public const string Countersignature = "1.2.840.113549.1.9.6";
        public const string EnhancedKeyUsage = "2.5.29.37";
        public const string IdQtCps = "1.3.6.1.5.5.7.2.1";
        public const string IdQtUnotice = "1.3.6.1.5.5.7.2.2";
        public const string LifetimeSigningEku = "1.3.6.1.4.1.311.10.3.13";
        public const string NuGetPackageOwners = "1.3.6.1.4.1.311.84.2.1.1.2";
        public const string NuGetV3ServiceIndexUrl = "1.3.6.1.4.1.311.84.2.1.1.1";
        public const string Pkcs7Data = "1.2.840.113549.1.7.1";
        public const string Sha1 = "1.3.14.3.2.26";
        public const string Sha256 = "2.16.840.1.101.3.4.2.1";
        public const string Sha256WithRSAEncryption = "1.2.840.113549.1.1.11";
        public const string Sha384 = "2.16.840.1.101.3.4.2.2";
        public const string Sha384WithRSAEncryption = "1.2.840.113549.1.1.12";
        public const string Sha512 = "2.16.840.1.101.3.4.2.3";
        public const string Sha512WithRSAEncryption = "1.2.840.113549.1.1.13";
        public const string SignatureTimeStampTokenAttribute = "1.2.840.113549.1.9.16.2.14";
        public const string SigningCertificate = "1.2.840.113549.1.9.16.2.12";
        public const string SigningCertificateV2 = "1.2.840.113549.1.9.16.2.47";
        public const string SigningTime = "1.2.840.113549.1.9.5";
        public const string SubjectKeyIdentifier = "2.5.29.14";
        public const string TimeStampingEku = "1.3.6.1.5.5.7.3.8";
        public const string TSTInfoContentType = "1.2.840.113549.1.9.16.1.4";
    }

    public partial class PackageSignatureVerifier : IPackageSignatureVerifier
    {
        public PackageSignatureVerifier(System.Collections.Generic.IEnumerable<ISignatureVerificationProvider> verificationProviders) { }

        public System.Threading.Tasks.Task<VerifySignaturesResult> VerifySignaturesAsync(ISignedPackageReader package, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token, System.Guid parentId = default) { throw null; }
    }

    public abstract partial class PackageVerificationResult
    {
        public PackageVerificationResult(SignatureVerificationStatus trust, System.Collections.Generic.IEnumerable<SignatureLog> issues) { }

        public virtual System.Collections.Generic.IEnumerable<SignatureLog> Issues { get { throw null; } }

        public virtual SignatureVerificationStatus Trust { get { throw null; } }

        public System.Collections.Generic.IEnumerable<Common.ILogMessage> GetErrorIssues() { throw null; }

        public System.Collections.Generic.IEnumerable<Common.ILogMessage> GetWarningIssues() { throw null; }
    }

    public sealed partial class PolicyInformation
    {
        internal PolicyInformation() { }

        public System.Security.Cryptography.Oid PolicyIdentifier { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PolicyQualifierInfo> PolicyQualifiers { get { throw null; } }

        public static PolicyInformation Read(byte[] bytes) { throw null; }
    }

    public sealed partial class PolicyQualifierInfo
    {
        internal PolicyQualifierInfo() { }

        public System.Security.Cryptography.Oid PolicyQualifierId { get { throw null; } }

        public byte[] Qualifier { get { throw null; } }

        public static PolicyQualifierInfo Read(byte[] bytes) { throw null; }
    }

    public abstract partial class PrimarySignature : Signature
    {
        protected PrimarySignature(System.Security.Cryptography.Pkcs.SignedCms signedCms, SignatureType signatureType) : base(default!, default) { }

        public override string FriendlyName { get { throw null; } }

        public SignatureContent SignatureContent { get { throw null; } }

        public System.Security.Cryptography.Pkcs.SignedCms SignedCms { get { throw null; } }

        public byte[] GetBytes() { throw null; }

        public override byte[] GetSignatureValue() { throw null; }

        public static PrimarySignature Load(byte[] data) { throw null; }

        public static PrimarySignature Load(System.IO.Stream stream) { throw null; }

        public static PrimarySignature Load(System.Security.Cryptography.Pkcs.SignedCms cms) { throw null; }

        public void Save(System.IO.Stream stream) { }

        protected static void ThrowForInvalidPrimarySignature() { }

        protected override void ThrowForInvalidSignature() { }
    }

    public static partial class PrimarySignatureFactory
    {
        public static PrimarySignature CreateSignature(System.Security.Cryptography.Pkcs.SignedCms signedCms) { throw null; }
    }

    public sealed partial class ReadOnlyBufferedStream : System.IO.Stream
    {
        public ReadOnlyBufferedStream(System.IO.Stream stream, bool leaveOpen, int bufferSize) { }

        public ReadOnlyBufferedStream(System.IO.Stream stream, bool leaveOpen) { }

        public override bool CanRead { get { throw null; } }

        public override bool CanSeek { get { throw null; } }

        public override bool CanTimeout { get { throw null; } }

        public override bool CanWrite { get { throw null; } }

        public override long Length { get { throw null; } }

        public override long Position { get { throw null; } set { } }

        public override int ReadTimeout { get { throw null; } set { } }

        public override int WriteTimeout { get { throw null; } set { } }

        public override System.Threading.Tasks.Task CopyToAsync(System.IO.Stream destination, int bufferSize, System.Threading.CancellationToken cancellationToken) { throw null; }

        protected override void Dispose(bool disposing) { }

        public override void Flush() { }

        public override System.Threading.Tasks.Task FlushAsync(System.Threading.CancellationToken cancellationToken) { throw null; }

        public override int Read(byte[] buffer, int offset, int count) { throw null; }

        public override int ReadByte() { throw null; }

        public override long Seek(long offset, System.IO.SeekOrigin origin) { throw null; }

        public override void SetLength(long value) { }

        public override void Write(byte[] buffer, int offset, int count) { }

        public override System.Threading.Tasks.Task WriteAsync(byte[] buffer, int offset, int count, System.Threading.CancellationToken cancellationToken) { throw null; }

        public override void WriteByte(byte value) { }
    }

    public sealed partial class RepositoryCountersignature : Signature, IRepositorySignature, ISignature
    {
        internal RepositoryCountersignature() : base(default!, default) { }

        public override string FriendlyName { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> PackageOwners { get { throw null; } }

        public System.Uri V3ServiceIndexUrl { get { throw null; } }

        public static RepositoryCountersignature GetRepositoryCountersignature(PrimarySignature primarySignature) { throw null; }

        public override byte[] GetSignatureValue() { throw null; }

        protected override void ThrowForInvalidSignature() { }

        public override SignatureVerificationSummary Verify(Timestamp timestamp, SignatureVerifySettings settings, Common.HashAlgorithmName fingerprintAlgorithm, System.Security.Cryptography.X509Certificates.X509Certificate2Collection certificateExtraStore) { throw null; }
    }

    public sealed partial class RepositoryPrimarySignature : PrimarySignature, IRepositorySignature, ISignature
    {
        public RepositoryPrimarySignature(System.Security.Cryptography.Pkcs.SignedCms signedCms) : base(default!, default) { }

        public override string FriendlyName { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> PackageOwners { get { throw null; } }

        public System.Uri V3ServiceIndexUrl { get { throw null; } }

        public override SignatureVerificationSummary Verify(Timestamp timestamp, SignatureVerifySettings settings, Common.HashAlgorithmName fingerprintAlgorithm, System.Security.Cryptography.X509Certificates.X509Certificate2Collection certificateExtraStore) { throw null; }
    }

    public static partial class RepositorySignatureInfoUtility
    {
        public static System.Collections.Generic.IReadOnlyCollection<CertificateHashAllowListEntry> GetRepositoryAllowList(System.Collections.Generic.IEnumerable<Core.IRepositoryCertificateInfo> repositoryCertificateInfos) { throw null; }

        public static SignedPackageVerifierSettings GetSignedPackageVerifierSettings(RepositorySignatureInfo repoSignatureInfo, SignedPackageVerifierSettings fallbackSettings) { throw null; }
    }

    public sealed partial class RepositorySignPackageRequest : SignPackageRequest
    {
        public RepositorySignPackageRequest(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName signatureHashAlgorithm, Common.HashAlgorithmName timestampHashAlgorithm, System.Uri v3ServiceIndexUrl, System.Collections.Generic.IReadOnlyList<string> packageOwners) : base(default!, default, default) { }

        public System.Collections.Generic.IReadOnlyList<string> PackageOwners { get { throw null; } }

        public override SignatureType SignatureType { get { throw null; } }

        public System.Uri V3ServiceIndexUrl { get { throw null; } }
    }

    public partial class Rfc3161TimestampProvider : ITimestampProvider
    {
        public Rfc3161TimestampProvider(System.Uri timeStampServerUrl) { }

        public System.Threading.Tasks.Task<PrimarySignature> TimestampSignatureAsync(PrimarySignature primarySignature, TimestampRequest request, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }

    public sealed partial class Rfc3161TimestampTokenInfo : System.Security.Cryptography.AsnEncodedData
    {
    }

    public abstract partial class Signature : ISignature
    {
        protected Signature(System.Security.Cryptography.Pkcs.SignerInfo signerInfo, SignatureType type) { }

        public virtual string FriendlyName { get { throw null; } }

        public System.Security.Cryptography.Pkcs.SignerInfo SignerInfo { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<Timestamp> Timestamps { get { throw null; } }

        public SignatureType Type { get { throw null; } }

        public abstract byte[] GetSignatureValue();
        public string GetSigningCertificateFingerprint(Common.HashAlgorithmName algorithm) { throw null; }

        protected abstract void ThrowForInvalidSignature();
        public virtual SignatureVerificationSummary Verify(Timestamp timestamp, SignatureVerifySettings settings, Common.HashAlgorithmName fingerprintAlgorithm, System.Security.Cryptography.X509Certificates.X509Certificate2Collection certificateExtraStore) { throw null; }
    }

    public sealed partial class SignatureContent
    {
        public SignatureContent(SigningSpecifications signingSpecifications, Common.HashAlgorithmName hashAlgorithm, string hashValue) { }

        public Common.HashAlgorithmName HashAlgorithm { get { throw null; } }

        public string HashValue { get { throw null; } }

        public byte[] GetBytes() { throw null; }

        public static SignatureContent Load(byte[] bytes, SigningSpecifications signingSpecifications) { throw null; }
    }

    public partial class SignatureException : Core.PackagingException
    {
        public SignatureException(Common.NuGetLogCode code, string message, Core.PackageIdentity package) : base(default!) { }

        public SignatureException(Common.NuGetLogCode code, string message, System.Exception innerException) : base(default!) { }

        public SignatureException(Common.NuGetLogCode code, string message) : base(default!) { }

        public SignatureException(System.Collections.Generic.IReadOnlyList<PackageVerificationResult> results, Core.PackageIdentity package) : base(default!) { }

        public SignatureException(string message) : base(default!) { }

        public Common.NuGetLogCode Code { get { throw null; } }

        public Core.PackageIdentity PackageIdentity { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PackageVerificationResult> Results { get { throw null; } }

        public System.TimeSpan VerifyDuration { get { throw null; } set { } }
    }

    public partial class SignatureLog : Common.ILogMessage, System.IEquatable<SignatureLog>
    {
        internal SignatureLog() { }

        public Common.NuGetLogCode Code { get { throw null; } set { } }

        public Common.LogLevel Level { get { throw null; } set { } }

        public string LibraryId { get { throw null; } set { } }

        public string Message { get { throw null; } set { } }

        public string ProjectPath { get { throw null; } set { } }

        public System.DateTimeOffset Time { get { throw null; } set { } }

        public Common.WarningLevel WarningLevel { get { throw null; } set { } }

        public Common.RestoreLogMessage AsRestoreLogMessage() { throw null; }

        public static SignatureLog DebugLog(string message) { throw null; }

        public static SignatureLog DetailedLog(string message) { throw null; }

        public bool Equals(SignatureLog other) { throw null; }

        public static SignatureLog Error(Common.NuGetLogCode code, string message) { throw null; }

        public static SignatureLog InformationLog(string message) { throw null; }

        public static SignatureLog Issue(bool fatal, Common.NuGetLogCode code, string message) { throw null; }

        public static SignatureLog MinimalLog(string message) { throw null; }
    }

    [System.Flags]
    public enum SignaturePlacement
    {
        PrimarySignature = 1,
        Countersignature = 2,
        Any = 3
    }

    public sealed partial class SignatureTrustAndValidityVerificationProvider : ISignatureVerificationProvider
    {
        public SignatureTrustAndValidityVerificationProvider(System.Collections.Generic.IEnumerable<System.Collections.Generic.KeyValuePair<string, Common.HashAlgorithmName>> allowUntrustedRootList = null) { }

        public System.Threading.Tasks.Task<PackageVerificationResult> GetTrustResultAsync(ISignedPackageReader package, PrimarySignature signature, SignedPackageVerifierSettings settings, System.Threading.CancellationToken token) { throw null; }
    }

    public enum SignatureType
    {
        Unknown = 0,
        Author = 1,
        Repository = 2
    }

    public static partial class SignatureUtility
    {
        public static IX509CertificateChain GetCertificateChain(PrimarySignature primarySignature, RepositoryCountersignature repositoryCountersignature) { throw null; }

        public static IX509CertificateChain GetCertificateChain(PrimarySignature primarySignature) { throw null; }

        public static IX509CertificateChain GetTimestampCertificateChain(PrimarySignature primarySignature, RepositoryCountersignature repositoryCountersignature) { throw null; }

        public static IX509CertificateChain GetTimestampCertificateChain(PrimarySignature primarySignature) { throw null; }

        public static bool HasRepositoryCountersignature(PrimarySignature primarySignature) { throw null; }
    }

    public enum SignatureVerificationBehavior
    {
        Never = 0,
        IfExists = 1,
        IfExistsAndIsNecessary = 2,
        Always = 3
    }

    public enum SignatureVerificationStatus
    {
        Unknown = 0,
        Suspect = 1,
        Disallowed = 2,
        Valid = 3
    }

    [System.Flags]
    public enum SignatureVerificationStatusFlags
    {
        NoErrors = 0,
        NoSignature = 1,
        NoCertificate = 2,
        MultipleSignatures = 4,
        SignatureCheckFailed = 8,
        SignatureAlgorithmUnsupported = 16,
        CertificatePublicKeyInvalid = 32,
        HasLifetimeSigningEku = 64,
        CertificateValidityInTheFuture = 128,
        CertificateExpired = 256,
        HashAlgorithmUnsupported = 512,
        MessageImprintUnsupportedAlgorithm = 1024,
        Illegal = 1790,
        IntegrityCheckFailed = 2048,
        ChainBuildingFailure = 4096,
        UnknownRevocation = 8192,
        CertificateRevoked = 16384,
        Suspect = 18432,
        UntrustedRoot = 32768,
        GeneralizedTimeOutsideValidity = 65536,
        Untrusted = 110849,
        NoValidTimestamp = 131072,
        MultipleTimestamps = 262144
    }

    public sealed partial class SignatureVerificationSummary
    {
        public SignatureVerificationSummary(SignatureType signatureType, SignatureVerificationStatus status, SignatureVerificationStatusFlags flags, Timestamp timestamp, System.Collections.Generic.IEnumerable<SignatureLog> issues) { }

        public SignatureVerificationSummary(SignatureType signatureType, SignatureVerificationStatus status, SignatureVerificationStatusFlags flags, Timestamp timestamp, System.DateTimeOffset? expirationTime, System.Collections.Generic.IEnumerable<SignatureLog> issues) { }

        public SignatureVerificationSummary(SignatureType signatureType, SignatureVerificationStatus status, SignatureVerificationStatusFlags flags, System.Collections.Generic.IEnumerable<SignatureLog> issues) { }

        public System.DateTimeOffset? ExpirationTime { get { throw null; } }

        public SignatureVerificationStatusFlags Flags { get { throw null; } }

        public System.Collections.Generic.IEnumerable<SignatureLog> Issues { get { throw null; } set { } }

        public SignatureType SignatureType { get { throw null; } }

        public SignatureVerificationStatus Status { get { throw null; } }

        public Timestamp Timestamp { get { throw null; } }
    }

    public sealed partial class SignatureVerifySettings
    {
        public SignatureVerifySettings(bool allowIllegal, bool allowUntrusted, bool allowUnknownRevocation, bool reportUnknownRevocation, bool reportUntrustedRoot, Common.RevocationMode revocationMode) { }

        public bool AllowIllegal { get { throw null; } }

        public bool AllowUnknownRevocation { get { throw null; } }

        public bool AllowUntrusted { get { throw null; } }

        public static SignatureVerifySettings Default { get { throw null; } }

        public bool ReportUnknownRevocation { get { throw null; } }

        public bool ReportUntrustedRoot { get { throw null; } }

        public Common.RevocationMode RevocationMode { get { throw null; } }
    }

    public partial class SignedPackageArchive : PackageArchiveReader, ISignedPackage, ISignedPackageReader, System.IDisposable, ISignedPackageWriter
    {
        public SignedPackageArchive(System.IO.Stream packageReadStream, System.IO.Stream packageWriteStream) : base(default(System.IO.Stream)!) { }

        public System.Threading.Tasks.Task AddSignatureAsync(System.IO.Stream signatureStream, System.Threading.CancellationToken token) { throw null; }

        protected override void Dispose(bool disposing) { }

        public System.Threading.Tasks.Task<bool> IsZip64Async(System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task RemoveSignatureAsync(System.Threading.CancellationToken token) { throw null; }
    }

    public static partial class SignedPackageArchiveIOUtility
    {
        public static void HashBytes(System.Security.Cryptography.HashAlgorithm hashAlgorithm, byte[] bytes) { }

        public static void ReadAndHashUntilPosition(System.IO.BinaryReader reader, System.Security.Cryptography.HashAlgorithm hashAlgorithm, long position) { }

        public static void ReadAndWriteUntilPosition(System.IO.BinaryReader reader, System.IO.BinaryWriter writer, long position) { }

        public static SignedPackageArchiveMetadata ReadSignedArchiveMetadata(System.IO.BinaryReader reader, bool validateSignatureEntry = true) { throw null; }
    }

    public sealed partial class SignedPackageArchiveMetadata
    {
        public System.Collections.Generic.List<CentralDirectoryHeaderMetadata> CentralDirectoryHeaders { get { throw null; } set { } }

        public long EndOfCentralDirectory { get { throw null; } set { } }

        public int SignatureCentralDirectoryHeaderIndex { get { throw null; } set { } }

        public long StartOfLocalFileHeaders { get { throw null; } set { } }

        public CentralDirectoryHeaderMetadata GetPackageSignatureFileCentralDirectoryHeaderMetadata() { throw null; }
    }

    public static partial class SignedPackageArchiveUtility
    {
        public static bool IsSigned(System.IO.BinaryReader reader) { throw null; }

        public static bool IsZip64(System.IO.BinaryReader reader) { throw null; }

        public static System.IO.Stream OpenPackageSignatureFileStream(System.IO.BinaryReader reader) { throw null; }

        public static System.Threading.Tasks.Task<bool> RemoveRepositorySignaturesAsync(System.IO.Stream input, System.IO.Stream output, System.Threading.CancellationToken cancellationToken) { throw null; }
    }

    public partial class SignedPackageVerificationResult : PackageVerificationResult
    {
        public SignedPackageVerificationResult(SignatureVerificationStatus trust, PrimarySignature signature, System.Collections.Generic.IEnumerable<SignatureLog> issues) : base(default, default!) { }

        public PrimarySignature Signature { get { throw null; } }
    }

    public sealed partial class SignedPackageVerifierSettings
    {
        public SignedPackageVerifierSettings(bool allowUnsigned, bool allowIllegal, bool allowUntrusted, bool allowIgnoreTimestamp, bool allowMultipleTimestamps, bool allowNoTimestamp, bool allowUnknownRevocation, bool reportUnknownRevocation, VerificationTarget verificationTarget, SignaturePlacement signaturePlacement, SignatureVerificationBehavior repositoryCountersignatureVerificationBehavior, Common.RevocationMode revocationMode) { }

        public bool AllowIgnoreTimestamp { get { throw null; } }

        public bool AllowIllegal { get { throw null; } }

        public bool AllowMultipleTimestamps { get { throw null; } }

        public bool AllowNoTimestamp { get { throw null; } }

        public bool AllowUnknownRevocation { get { throw null; } }

        public bool AllowUnsigned { get { throw null; } }

        public bool AllowUntrusted { get { throw null; } }

        public bool ReportUnknownRevocation { get { throw null; } }

        public SignatureVerificationBehavior RepositoryCountersignatureVerificationBehavior { get { throw null; } }

        public Common.RevocationMode RevocationMode { get { throw null; } }

        public SignaturePlacement SignaturePlacement { get { throw null; } }

        public VerificationTarget VerificationTarget { get { throw null; } }

        public static SignedPackageVerifierSettings GetAcceptModeDefaultPolicy(Common.IEnvironmentVariableReader environmentVariableReader = null) { throw null; }

        public static SignedPackageVerifierSettings GetDefault(Common.IEnvironmentVariableReader environmentVariableReader = null) { throw null; }

        public static SignedPackageVerifierSettings GetRequireModeDefaultPolicy(Common.IEnvironmentVariableReader environmentVariableReader = null) { throw null; }

        public static SignedPackageVerifierSettings GetVerifyCommandDefaultPolicy(Common.IEnvironmentVariableReader environmentVariableReader = null) { throw null; }
    }

    public sealed partial class SigningCertificate
    {
        internal SigningCertificate() { }

        public System.Collections.Generic.IReadOnlyList<EssCertId> Certificates { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PolicyInformation> Policies { get { throw null; } }

        public static SigningCertificate Read(byte[] bytes) { throw null; }
    }

    public sealed partial class SigningCertificateV2
    {
        internal SigningCertificateV2() { }

        public System.Collections.Generic.IReadOnlyList<EssCertIdV2> Certificates { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PolicyInformation> Policies { get { throw null; } }

        public static SigningCertificateV2 Create(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName hashAlgorithmName) { throw null; }

        public byte[] Encode() { throw null; }

        public static SigningCertificateV2 Read(byte[] bytes) { throw null; }
    }

    public sealed partial class SigningOptions : System.IDisposable
    {
        public SigningOptions(System.Lazy<System.IO.Stream> inputPackageStream, System.Lazy<System.IO.Stream> outputPackageStream, bool overwrite, ISignatureProvider signatureProvider, Common.ILogger logger) { }

        public System.IO.Stream InputPackageStream { get { throw null; } }

        public Common.ILogger Logger { get { throw null; } }

        public System.IO.Stream OutputPackageStream { get { throw null; } }

        public bool Overwrite { get { throw null; } }

        public ISignatureProvider SignatureProvider { get { throw null; } }

        public static SigningOptions CreateFromFilePaths(string inputPackageFilePath, string outputPackageFilePath, bool overwrite, ISignatureProvider signatureProvider, Common.ILogger logger) { throw null; }

        public void Dispose() { }
    }

    public abstract partial class SigningSpecifications
    {
        public static readonly SigningSpecificationsV1 V1;
        public abstract string[] AllowedHashAlgorithmOids { get; }
        public abstract Common.HashAlgorithmName[] AllowedHashAlgorithms { get; }
        public abstract string[] AllowedSignatureAlgorithmOids { get; }
        public abstract Common.SignatureAlgorithmName[] AllowedSignatureAlgorithms { get; }
        public abstract System.Text.Encoding Encoding { get; }
        public abstract int RSAPublicKeyMinLength { get; }
        public abstract string SignaturePath { get; }
        public abstract string Version { get; }
    }

    public sealed partial class SigningSpecificationsV1 : SigningSpecifications
    {
        public override string[] AllowedHashAlgorithmOids { get { throw null; } }

        public override Common.HashAlgorithmName[] AllowedHashAlgorithms { get { throw null; } }

        public override string[] AllowedSignatureAlgorithmOids { get { throw null; } }

        public override Common.SignatureAlgorithmName[] AllowedSignatureAlgorithms { get { throw null; } }

        public override System.Text.Encoding Encoding { get { throw null; } }

        public override int RSAPublicKeyMinLength { get { throw null; } }

        public override string SignaturePath { get { throw null; } }

        public override string Version { get { throw null; } }
    }

    public static partial class SigningUtility
    {
        public static System.Security.Cryptography.Pkcs.CmsSigner CreateCmsSigner(SignPackageRequest request, Common.ILogger logger) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObjectCollection CreateSignedAttributes(RepositorySignPackageRequest request, System.Collections.Generic.IReadOnlyList<System.Security.Cryptography.X509Certificates.X509Certificate2> chainList) { throw null; }

        public static System.Security.Cryptography.CryptographicAttributeObjectCollection CreateSignedAttributes(SignPackageRequest request, System.Collections.Generic.IReadOnlyList<System.Security.Cryptography.X509Certificates.X509Certificate2> chainList) { throw null; }

        public static System.Threading.Tasks.Task SignAsync(SigningOptions options, SignPackageRequest signRequest, System.Threading.CancellationToken token) { throw null; }

        public static void Verify(SignPackageRequest request, Common.ILogger logger) { }
    }

    public abstract partial class SignPackageRequest : System.IDisposable
    {
        protected SignPackageRequest(System.Security.Cryptography.X509Certificates.X509Certificate2 certificate, Common.HashAlgorithmName signatureHashAlgorithm, Common.HashAlgorithmName timestampHashAlgorithm) { }

        public System.Security.Cryptography.X509Certificates.X509Certificate2Collection AdditionalCertificates { get { throw null; } }

        public System.Security.Cryptography.X509Certificates.X509Certificate2 Certificate { get { throw null; } }

        public System.Security.Cryptography.CngKey PrivateKey { get { throw null; } set { } }

        public Common.HashAlgorithmName SignatureHashAlgorithm { get { throw null; } }

        public abstract SignatureType SignatureType { get; }

        public Common.HashAlgorithmName TimestampHashAlgorithm { get { throw null; } }

        public void Dispose() { }

        protected virtual void Dispose(bool disposing) { }
    }

    public sealed partial class Timestamp
    {
        public Timestamp() { }

        public Timestamp(System.Security.Cryptography.Pkcs.SignedCms timestampCms) { }

        public System.DateTimeOffset GeneralizedTime { get { throw null; } }

        public System.DateTimeOffset LowerLimit { get { throw null; } }

        public System.Security.Cryptography.Pkcs.SignedCms SignedCms { get { throw null; } }

        public System.Security.Cryptography.Pkcs.SignerInfo SignerInfo { get { throw null; } }

        public System.DateTimeOffset UpperLimit { get { throw null; } }
    }

    public partial class TimestampException : SignatureException
    {
        public TimestampException() : base(default!) { }

        public TimestampException(Common.NuGetLogCode code, string message, System.Exception innerException) : base(default!) { }

        public TimestampException(Common.NuGetLogCode code, string message) : base(default!) { }

        public TimestampException(string message) : base(default!) { }
    }

    public partial class TimestampRequest
    {
        public TimestampRequest(SigningSpecifications signingSpecifications, byte[] hashedMessage, Common.HashAlgorithmName hashAlgorithm, SignaturePlacement target) { }

        public Common.HashAlgorithmName HashAlgorithm { get { throw null; } }

        public byte[] HashedMessage { get { throw null; } }

        public SigningSpecifications SigningSpecifications { get { throw null; } }

        public SignaturePlacement Target { get { throw null; } }
    }

    public sealed partial class TrustedSignerAllowListEntry : CertificateHashAllowListEntry
    {
        public TrustedSignerAllowListEntry(VerificationTarget target, SignaturePlacement placement, string fingerprint, Common.HashAlgorithmName algorithm, bool allowUntrustedRoot = false, System.Collections.Generic.IReadOnlyList<string> owners = null) : base(default, default, default!, default) { }

        public bool AllowUntrustedRoot { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<string> Owners { get { throw null; } }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }
    }

    public sealed partial class TrustedSignersProvider : ITrustedSignersProvider
    {
        public TrustedSignersProvider(Configuration.ISettings settings) { }

        public void AddOrUpdateTrustedSigner(Configuration.TrustedSignerItem trustedSigner) { }

        public static System.Collections.Generic.IReadOnlyList<TrustedSignerAllowListEntry> GetAllowListEntries(Configuration.ISettings settings, Common.ILogger logger) { throw null; }

        public System.Collections.Generic.IReadOnlyList<Configuration.TrustedSignerItem> GetTrustedSigners() { throw null; }

        public void Remove(System.Collections.Generic.IReadOnlyList<Configuration.TrustedSignerItem> trustedSigners) { }
    }

    public sealed partial class TstInfo
    {
        internal TstInfo() { }

        public Accuracy Accuracy { get { throw null; } }

        public System.Security.Cryptography.X509Certificates.X509ExtensionCollection Extensions { get { throw null; } }

        public System.DateTimeOffset GenTime { get { throw null; } }

        public MessageImprint MessageImprint { get { throw null; } }

        public byte[] Nonce { get { throw null; } }

        public bool Ordering { get { throw null; } }

        public System.Security.Cryptography.Oid Policy { get { throw null; } }

        public byte[] SerialNumber { get { throw null; } }

        public byte[] Tsa { get { throw null; } }

        public int Version { get { throw null; } }

        public static TstInfo Read(byte[] bytes) { throw null; }
    }

    public sealed partial class UnknownPrimarySignature : PrimarySignature
    {
        public UnknownPrimarySignature(System.Security.Cryptography.Pkcs.SignedCms signedCms) : base(default!, default) { }
    }

    public partial class UnsignedPackageVerificationResult : PackageVerificationResult
    {
        public UnsignedPackageVerificationResult(SignatureVerificationStatus trust, System.Collections.Generic.IEnumerable<SignatureLog> issues) : base(default, default!) { }
    }

    public abstract partial class VerificationAllowListEntry
    {
        public VerificationAllowListEntry(VerificationTarget target, SignaturePlacement placement) { }

        public SignaturePlacement Placement { get { throw null; } }

        public VerificationTarget Target { get { throw null; } }
    }

    [System.Flags]
    public enum VerificationTarget
    {
        None = 0,
        Unknown = 2,
        Author = 4,
        Repository = 8,
        All = 14
    }

    public static partial class VerificationUtility
    {
        public static SignatureVerificationStatus GetSignatureVerificationStatus(SignatureVerificationStatusFlags flags) { throw null; }

        public static bool IsVerificationTarget(SignatureType signatureType, VerificationTarget target) { throw null; }
    }

    public sealed partial class VerifySignaturesResult
    {
        public VerifySignaturesResult(bool isValid, bool isSigned, System.Collections.Generic.IEnumerable<PackageVerificationResult> results) { }

        public VerifySignaturesResult(bool isValid, bool isSigned) { }

        public bool IsSigned { get { throw null; } }

        public bool IsValid { get { throw null; } }

        public System.Collections.Generic.IReadOnlyList<PackageVerificationResult> Results { get { throw null; } }
    }

    public sealed partial class X509CertificateChain : System.Collections.Generic.List<System.Security.Cryptography.X509Certificates.X509Certificate2>, IX509CertificateChain, System.Collections.Generic.IReadOnlyList<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.Collections.Generic.IEnumerable<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.Collections.IEnumerable, System.Collections.Generic.IReadOnlyCollection<System.Security.Cryptography.X509Certificates.X509Certificate2>, System.IDisposable
    {
        public void Dispose() { }
    }

    public sealed partial class X509ChainHolder : System.IDisposable
    {
        public System.Security.Cryptography.X509Certificates.X509Chain Chain { get { throw null; } }

        public void Dispose() { }
    }

    public partial class X509SignatureProvider : ISignatureProvider
    {
        public X509SignatureProvider(ITimestampProvider timestampProvider) { }

        public System.Threading.Tasks.Task<PrimarySignature> CreatePrimarySignatureAsync(SignPackageRequest request, SignatureContent signatureContent, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }

        public System.Threading.Tasks.Task<PrimarySignature> CreateRepositoryCountersignatureAsync(RepositorySignPackageRequest request, PrimarySignature primarySignature, Common.ILogger logger, System.Threading.CancellationToken token) { throw null; }
    }
}

namespace NuGet.Packaging.Signing.DerEncoding
{
    public sealed partial class DerGeneralizedTime
    {
        internal DerGeneralizedTime() { }

        public System.DateTime DateTime { get { throw null; } }

        public static DerGeneralizedTime Read(string decodedTime) { throw null; }
    }
}

namespace NuGet.RuntimeModel
{
    public partial class CompatibilityProfile : System.IEquatable<CompatibilityProfile>
    {
        public CompatibilityProfile(string name, System.Collections.Generic.IEnumerable<Frameworks.FrameworkRuntimePair> restoreContexts) { }

        public CompatibilityProfile(string name) { }

        public string Name { get { throw null; } }

        public System.Collections.Generic.IList<Frameworks.FrameworkRuntimePair> RestoreContexts { get { throw null; } }

        public CompatibilityProfile Clone() { throw null; }

        public bool Equals(CompatibilityProfile other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial interface IObjectWriter
    {
        void WriteArrayEnd();
        void WriteArrayStart(string name);
        void WriteNameArray(string name, System.Collections.Generic.IEnumerable<string> values);
        void WriteNameValue(string name, bool value);
        void WriteNameValue(string name, int value);
        void WriteNameValue(string name, string value);
        void WriteObjectEnd();
        void WriteObjectStart();
        void WriteObjectStart(string name);
    }

    public sealed partial class JsonObjectWriter : IObjectWriter, System.IDisposable
    {
        public JsonObjectWriter(Newtonsoft.Json.JsonWriter writer) { }

        public void Dispose() { }

        public void WriteArrayEnd() { }

        public void WriteArrayStart(string name) { }

        public void WriteNameArray(string name, System.Collections.Generic.IEnumerable<string> values) { }

        public void WriteNameValue(string name, bool value) { }

        public void WriteNameValue(string name, int value) { }

        public void WriteNameValue(string name, string value) { }

        public void WriteObjectEnd() { }

        public void WriteObjectStart() { }

        public void WriteObjectStart(string name) { }
    }

    public static partial class JsonRuntimeFormat
    {
        public static RuntimeGraph ReadRuntimeGraph(Newtonsoft.Json.Linq.JToken json) { throw null; }

        public static RuntimeGraph ReadRuntimeGraph(System.IO.Stream stream) { throw null; }

        public static RuntimeGraph ReadRuntimeGraph(System.IO.TextReader textReader) { throw null; }

        public static RuntimeGraph ReadRuntimeGraph(string filePath) { throw null; }

        public static void WriteRuntimeGraph(IObjectWriter writer, RuntimeGraph runtimeGraph) { }

        public static void WriteRuntimeGraph(string filePath, RuntimeGraph runtimeGraph) { }
    }

    public partial class RuntimeDependencySet : System.IEquatable<RuntimeDependencySet>
    {
        public RuntimeDependencySet(string id, System.Collections.Generic.IEnumerable<RuntimePackageDependency> dependencies) { }

        public RuntimeDependencySet(string id) { }

        public System.Collections.Generic.IReadOnlyDictionary<string, RuntimePackageDependency> Dependencies { get { throw null; } }

        public string Id { get { throw null; } }

        public RuntimeDependencySet Clone() { throw null; }

        public bool Equals(RuntimeDependencySet other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class RuntimeDescription : System.IEquatable<RuntimeDescription>
    {
        public RuntimeDescription(string runtimeIdentifier, System.Collections.Generic.IEnumerable<RuntimeDependencySet> runtimeDependencySets) { }

        public RuntimeDescription(string runtimeIdentifier, System.Collections.Generic.IEnumerable<string> inheritedRuntimes, System.Collections.Generic.IEnumerable<RuntimeDependencySet> runtimeDependencySets) { }

        public RuntimeDescription(string runtimeIdentifier, System.Collections.Generic.IEnumerable<string> inheritedRuntimes) { }

        public RuntimeDescription(string runtimeIdentifier) { }

        public System.Collections.Generic.IReadOnlyList<string> InheritedRuntimes { get { throw null; } }

        public System.Collections.Generic.IReadOnlyDictionary<string, RuntimeDependencySet> RuntimeDependencySets { get { throw null; } }

        public string RuntimeIdentifier { get { throw null; } }

        public RuntimeDescription Clone() { throw null; }

        public bool Equals(RuntimeDescription other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public static RuntimeDescription Merge(RuntimeDescription left, RuntimeDescription right) { throw null; }

        public override string ToString() { throw null; }
    }

    public partial class RuntimeGraph : System.IEquatable<RuntimeGraph>
    {
        public static readonly RuntimeGraph Empty;
        public static readonly string RuntimeGraphFileName;
        public RuntimeGraph() { }

        public RuntimeGraph(System.Collections.Generic.IEnumerable<CompatibilityProfile> supports) { }

        public RuntimeGraph(System.Collections.Generic.IEnumerable<RuntimeDescription> runtimes, System.Collections.Generic.IEnumerable<CompatibilityProfile> supports) { }

        public RuntimeGraph(System.Collections.Generic.IEnumerable<RuntimeDescription> runtimes) { }

        public System.Collections.Generic.IReadOnlyDictionary<string, RuntimeDescription> Runtimes { get { throw null; } }

        public System.Collections.Generic.IReadOnlyDictionary<string, CompatibilityProfile> Supports { get { throw null; } set { } }

        public bool AreCompatible(string criteria, string provided) { throw null; }

        public RuntimeGraph Clone() { throw null; }

        public bool Equals(RuntimeGraph other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public System.Collections.Generic.IEnumerable<string> ExpandRuntime(string runtime) { throw null; }

        public System.Collections.Generic.IEnumerable<RuntimePackageDependency> FindRuntimeDependencies(string runtimeName, string packageId) { throw null; }

        public override int GetHashCode() { throw null; }

        public static RuntimeGraph Merge(RuntimeGraph left, RuntimeGraph right) { throw null; }
    }

    public partial class RuntimePackageDependency : System.IEquatable<RuntimePackageDependency>
    {
        public RuntimePackageDependency(string id, Versioning.VersionRange versionRange) { }

        public string Id { get { throw null; } }

        public Versioning.VersionRange VersionRange { get { throw null; } }

        public RuntimePackageDependency Clone() { throw null; }

        public bool Equals(RuntimePackageDependency other) { throw null; }

        public override bool Equals(object obj) { throw null; }

        public override int GetHashCode() { throw null; }

        public override string ToString() { throw null; }
    }
}