package iothub

// Copyright (c) Microsoft and contributors.  All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
// http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//
// See the License for the specific language governing permissions and
// limitations under the License.
//
// Code generated by Microsoft (R) AutoRest Code Generator 0.17.0.0
// Changes may cause incorrect behavior and will be lost if the code is
// regenerated.

import (
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"net/http"
)

// ResourceOperationsClient is the aPI for using the IoT Hub Features.
type ResourceOperationsClient struct {
	ManagementClient
}

// NewResourceOperationsClient creates an instance of the
// ResourceOperationsClient client.
func NewResourceOperationsClient(subscriptionID string) ResourceOperationsClient {
	return NewResourceOperationsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewResourceOperationsClientWithBaseURI creates an instance of the
// ResourceOperationsClient client.
func NewResourceOperationsClientWithBaseURI(baseURI string, subscriptionID string) ResourceOperationsClient {
	return ResourceOperationsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// CheckNameAvailability check if an IotHub name is available.
//
// operationInputs is the operation inputs. Set the name parameter in the
// operationInputs structure to the desired iothub name.
func (client ResourceOperationsClient) CheckNameAvailability(operationInputs OperationInputs) (result NameAvailabilityInfo, err error) {
	req, err := client.CheckNameAvailabilityPreparer(operationInputs)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CheckNameAvailability", nil, "Failure preparing request")
	}

	resp, err := client.CheckNameAvailabilitySender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CheckNameAvailability", resp, "Failure sending request")
	}

	result, err = client.CheckNameAvailabilityResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CheckNameAvailability", resp, "Failure responding to request")
	}

	return
}

// CheckNameAvailabilityPreparer prepares the CheckNameAvailability request.
func (client ResourceOperationsClient) CheckNameAvailabilityPreparer(operationInputs OperationInputs) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/checkNameAvailability", pathParameters),
		autorest.WithJSON(operationInputs),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CheckNameAvailabilitySender sends the CheckNameAvailability request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) CheckNameAvailabilitySender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CheckNameAvailabilityResponder handles the response to the CheckNameAvailability request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) CheckNameAvailabilityResponder(resp *http.Response) (result NameAvailabilityInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateEventHubConsumerGroup add an EventHub Consumer Group to an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. eventHubEndpointName is the name of the event hub
// endpoint. name is the name of the consumer group.
func (client ResourceOperationsClient) CreateEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.CreateEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateEventHubConsumerGroup", nil, "Failure preparing request")
	}

	resp, err := client.CreateEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateEventHubConsumerGroup", resp, "Failure sending request")
	}

	result, err = client.CreateEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// CreateEventHubConsumerGroupPreparer prepares the CreateEventHubConsumerGroup request.
func (client ResourceOperationsClient) CreateEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// CreateEventHubConsumerGroupSender sends the CreateEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) CreateEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// CreateEventHubConsumerGroupResponder handles the response to the CreateEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) CreateEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// CreateOrUpdate create or update an IotHub. This method may poll for
// completion. Polling can be canceled by passing the cancel channel
// argument. The channel will be used to cancel polling and any outstanding
// HTTP requests.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. iotHubDescription is the Iot hub description.
func (client ResourceOperationsClient) CreateOrUpdate(resourceGroupName string, resourceName string, iotHubDescription Description, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.CreateOrUpdatePreparer(resourceGroupName, resourceName, iotHubDescription, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateOrUpdate", nil, "Failure preparing request")
	}

	resp, err := client.CreateOrUpdateSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateOrUpdate", resp, "Failure sending request")
	}

	result, err = client.CreateOrUpdateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "CreateOrUpdate", resp, "Failure responding to request")
	}

	return
}

// CreateOrUpdatePreparer prepares the CreateOrUpdate request.
func (client ResourceOperationsClient) CreateOrUpdatePreparer(resourceGroupName string, resourceName string, iotHubDescription Description, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithJSON(iotHubDescription),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// CreateOrUpdateSender sends the CreateOrUpdate request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) CreateOrUpdateSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// CreateOrUpdateResponder handles the response to the CreateOrUpdate request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) CreateOrUpdateResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Delete delete an IotHub. This method may poll for completion. Polling can
// be canceled by passing the cancel channel argument. The channel will be
// used to cancel polling and any outstanding HTTP requests.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) Delete(resourceGroupName string, resourceName string, cancel <-chan struct{}) (result autorest.Response, err error) {
	req, err := client.DeletePreparer(resourceGroupName, resourceName, cancel)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Delete", nil, "Failure preparing request")
	}

	resp, err := client.DeleteSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Delete", resp, "Failure sending request")
	}

	result, err = client.DeleteResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Delete", resp, "Failure responding to request")
	}

	return
}

// DeletePreparer prepares the Delete request.
func (client ResourceOperationsClient) DeletePreparer(resourceGroupName string, resourceName string, cancel <-chan struct{}) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{Cancel: cancel})
}

// DeleteSender sends the Delete request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) DeleteSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client,
		req,
		azure.DoPollForAsynchronous(client.PollingDelay))
}

// DeleteResponder handles the response to the Delete request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) DeleteResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusAccepted),
		autorest.ByClosing())
	result.Response = resp
	return
}

// DeleteEventHubConsumerGroup delete EventHub Consumer Group for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. eventHubEndpointName is the name of the event hub
// endpoint. name is the name of the consumer group.
func (client ResourceOperationsClient) DeleteEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result autorest.Response, err error) {
	req, err := client.DeleteEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "DeleteEventHubConsumerGroup", nil, "Failure preparing request")
	}

	resp, err := client.DeleteEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = resp
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "DeleteEventHubConsumerGroup", resp, "Failure sending request")
	}

	result, err = client.DeleteEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "DeleteEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// DeleteEventHubConsumerGroupPreparer prepares the DeleteEventHubConsumerGroup request.
func (client ResourceOperationsClient) DeleteEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsDelete(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// DeleteEventHubConsumerGroupSender sends the DeleteEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) DeleteEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// DeleteEventHubConsumerGroupResponder handles the response to the DeleteEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) DeleteEventHubConsumerGroupResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// ExportDevices export all the devices in an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. exportDevicesParameters is the export devices
// parameters.
func (client ResourceOperationsClient) ExportDevices(resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (result JobResponse, err error) {
	req, err := client.ExportDevicesPreparer(resourceGroupName, resourceName, exportDevicesParameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ExportDevices", nil, "Failure preparing request")
	}

	resp, err := client.ExportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ExportDevices", resp, "Failure sending request")
	}

	result, err = client.ExportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ExportDevices", resp, "Failure responding to request")
	}

	return
}

// ExportDevicesPreparer prepares the ExportDevices request.
func (client ResourceOperationsClient) ExportDevicesPreparer(resourceGroupName string, resourceName string, exportDevicesParameters ExportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/exportDevices", pathParameters),
		autorest.WithJSON(exportDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ExportDevicesSender sends the ExportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ExportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ExportDevicesResponder handles the response to the ExportDevices request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ExportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) Get(resourceGroupName string, resourceName string) (result Description, err error) {
	req, err := client.GetPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Get", nil, "Failure preparing request")
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Get", resp, "Failure sending request")
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "Get", resp, "Failure responding to request")
	}

	return
}

// GetPreparer prepares the Get request.
func (client ResourceOperationsClient) GetPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetResponder(resp *http.Response) (result Description, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetEventHubConsumerGroup get EventHub Consumer Group for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. eventHubEndpointName is the name of the event hub
// endpoint. name is the name of the consumer group.
func (client ResourceOperationsClient) GetEventHubConsumerGroup(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (result EventHubConsumerGroupInfo, err error) {
	req, err := client.GetEventHubConsumerGroupPreparer(resourceGroupName, resourceName, eventHubEndpointName, name)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetEventHubConsumerGroup", nil, "Failure preparing request")
	}

	resp, err := client.GetEventHubConsumerGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetEventHubConsumerGroup", resp, "Failure sending request")
	}

	result, err = client.GetEventHubConsumerGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetEventHubConsumerGroup", resp, "Failure responding to request")
	}

	return
}

// GetEventHubConsumerGroupPreparer prepares the GetEventHubConsumerGroup request.
func (client ResourceOperationsClient) GetEventHubConsumerGroupPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string, name string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"name":                 autorest.Encode("path", name),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups/{name}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetEventHubConsumerGroupSender sends the GetEventHubConsumerGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetEventHubConsumerGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetEventHubConsumerGroupResponder handles the response to the GetEventHubConsumerGroup request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetEventHubConsumerGroupResponder(resp *http.Response) (result EventHubConsumerGroupInfo, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetJob get a job in an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. jobID is the job identifier.
func (client ResourceOperationsClient) GetJob(resourceGroupName string, resourceName string, jobID string) (result JobResponse, err error) {
	req, err := client.GetJobPreparer(resourceGroupName, resourceName, jobID)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetJob", nil, "Failure preparing request")
	}

	resp, err := client.GetJobSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetJob", resp, "Failure sending request")
	}

	result, err = client.GetJobResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetJob", resp, "Failure responding to request")
	}

	return
}

// GetJobPreparer prepares the GetJob request.
func (client ResourceOperationsClient) GetJobPreparer(resourceGroupName string, resourceName string, jobID string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"jobId":             autorest.Encode("path", jobID),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs/{jobId}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetJobSender sends the GetJob request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetJobSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetJobResponder handles the response to the GetJob request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetJobResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetKeysForKeyName get the Key given a specific KeyName for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. keyName is the name of the key.
func (client ResourceOperationsClient) GetKeysForKeyName(resourceGroupName string, resourceName string, keyName string) (result SharedAccessSignatureAuthorizationRule, err error) {
	req, err := client.GetKeysForKeyNamePreparer(resourceGroupName, resourceName, keyName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetKeysForKeyName", nil, "Failure preparing request")
	}

	resp, err := client.GetKeysForKeyNameSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetKeysForKeyName", resp, "Failure sending request")
	}

	result, err = client.GetKeysForKeyNameResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetKeysForKeyName", resp, "Failure responding to request")
	}

	return
}

// GetKeysForKeyNamePreparer prepares the GetKeysForKeyName request.
func (client ResourceOperationsClient) GetKeysForKeyNamePreparer(resourceGroupName string, resourceName string, keyName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"keyName":           autorest.Encode("path", keyName),
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubKeys/{keyName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetKeysForKeyNameSender sends the GetKeysForKeyName request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetKeysForKeyNameSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetKeysForKeyNameResponder handles the response to the GetKeysForKeyName request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetKeysForKeyNameResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRule, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotaMetrics get quota metrics for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) GetQuotaMetrics(resourceGroupName string, resourceName string) (result QuotaMetricInfoListResult, err error) {
	req, err := client.GetQuotaMetricsPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", nil, "Failure preparing request")
	}

	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", resp, "Failure sending request")
	}

	result, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", resp, "Failure responding to request")
	}

	return
}

// GetQuotaMetricsPreparer prepares the GetQuotaMetrics request.
func (client ResourceOperationsClient) GetQuotaMetricsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/quotaMetrics", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetQuotaMetricsSender sends the GetQuotaMetrics request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetQuotaMetricsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetQuotaMetricsResponder handles the response to the GetQuotaMetrics request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetQuotaMetricsResponder(resp *http.Response) (result QuotaMetricInfoListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetQuotaMetricsNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) GetQuotaMetricsNextResults(lastResults QuotaMetricInfoListResult) (result QuotaMetricInfoListResult, err error) {
	req, err := lastResults.QuotaMetricInfoListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetQuotaMetricsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", resp, "Failure sending next results request request")
	}

	result, err = client.GetQuotaMetricsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetQuotaMetrics", resp, "Failure responding to next results request request")
	}

	return
}

// GetStats get IotHub Stats.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) GetStats(resourceGroupName string, resourceName string) (result RegistryStatistics, err error) {
	req, err := client.GetStatsPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetStats", nil, "Failure preparing request")
	}

	resp, err := client.GetStatsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetStats", resp, "Failure sending request")
	}

	result, err = client.GetStatsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetStats", resp, "Failure responding to request")
	}

	return
}

// GetStatsPreparer prepares the GetStats request.
func (client ResourceOperationsClient) GetStatsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/IotHubStats", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetStatsSender sends the GetStats request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetStatsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetStatsResponder handles the response to the GetStats request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetStatsResponder(resp *http.Response) (result RegistryStatistics, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetValidSkus get Valid Skus.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) GetValidSkus(resourceGroupName string, resourceName string) (result SkuDescriptionListResult, err error) {
	req, err := client.GetValidSkusPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", nil, "Failure preparing request")
	}

	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", resp, "Failure sending request")
	}

	result, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", resp, "Failure responding to request")
	}

	return
}

// GetValidSkusPreparer prepares the GetValidSkus request.
func (client ResourceOperationsClient) GetValidSkusPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/skus", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// GetValidSkusSender sends the GetValidSkus request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) GetValidSkusSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// GetValidSkusResponder handles the response to the GetValidSkus request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) GetValidSkusResponder(resp *http.Response) (result SkuDescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// GetValidSkusNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) GetValidSkusNextResults(lastResults SkuDescriptionListResult) (result SkuDescriptionListResult, err error) {
	req, err := lastResults.SkuDescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.GetValidSkusSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", resp, "Failure sending next results request request")
	}

	result, err = client.GetValidSkusResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "GetValidSkus", resp, "Failure responding to next results request request")
	}

	return
}

// ImportDevices import all the devices in an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. importDevicesParameters is the import devices
// parameters.
func (client ResourceOperationsClient) ImportDevices(resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (result JobResponse, err error) {
	req, err := client.ImportDevicesPreparer(resourceGroupName, resourceName, importDevicesParameters)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ImportDevices", nil, "Failure preparing request")
	}

	resp, err := client.ImportDevicesSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ImportDevices", resp, "Failure sending request")
	}

	result, err = client.ImportDevicesResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ImportDevices", resp, "Failure responding to request")
	}

	return
}

// ImportDevicesPreparer prepares the ImportDevices request.
func (client ResourceOperationsClient) ImportDevicesPreparer(resourceGroupName string, resourceName string, importDevicesParameters ImportDevicesRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsJSON(),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/importDevices", pathParameters),
		autorest.WithJSON(importDevicesParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ImportDevicesSender sends the ImportDevices request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ImportDevicesSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ImportDevicesResponder handles the response to the ImportDevices request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ImportDevicesResponder(resp *http.Response) (result JobResponse, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroup get all IotHubs in a Resource group.
//
// resourceGroupName is the name of the resource group.
func (client ResourceOperationsClient) ListByResourceGroup(resourceGroupName string) (result DescriptionListResult, err error) {
	req, err := client.ListByResourceGroupPreparer(resourceGroupName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", nil, "Failure preparing request")
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", resp, "Failure sending request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", resp, "Failure responding to request")
	}

	return
}

// ListByResourceGroupPreparer prepares the ListByResourceGroup request.
func (client ResourceOperationsClient) ListByResourceGroupPreparer(resourceGroupName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListByResourceGroupSender sends the ListByResourceGroup request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ListByResourceGroupSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListByResourceGroupResponder handles the response to the ListByResourceGroup request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ListByResourceGroupResponder(resp *http.Response) (result DescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListByResourceGroupNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) ListByResourceGroupNextResults(lastResults DescriptionListResult) (result DescriptionListResult, err error) {
	req, err := lastResults.DescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListByResourceGroupSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", resp, "Failure sending next results request request")
	}

	result, err = client.ListByResourceGroupResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListByResourceGroup", resp, "Failure responding to next results request request")
	}

	return
}

// ListBySubscription get all IotHubs in a subscription.
func (client ResourceOperationsClient) ListBySubscription() (result DescriptionListResult, err error) {
	req, err := client.ListBySubscriptionPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", nil, "Failure preparing request")
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", resp, "Failure sending request")
	}

	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", resp, "Failure responding to request")
	}

	return
}

// ListBySubscriptionPreparer prepares the ListBySubscription request.
func (client ResourceOperationsClient) ListBySubscriptionPreparer() (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"subscriptionId": autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/providers/Microsoft.Devices/IotHubs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListBySubscriptionSender sends the ListBySubscription request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ListBySubscriptionSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListBySubscriptionResponder handles the response to the ListBySubscription request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ListBySubscriptionResponder(resp *http.Response) (result DescriptionListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListBySubscriptionNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) ListBySubscriptionNextResults(lastResults DescriptionListResult) (result DescriptionListResult, err error) {
	req, err := lastResults.DescriptionListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListBySubscriptionSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", resp, "Failure sending next results request request")
	}

	result, err = client.ListBySubscriptionResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListBySubscription", resp, "Failure responding to next results request request")
	}

	return
}

// ListEventHubConsumerGroups get EventHub Consumer Groups for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource. eventHubEndpointName is the name of the event hub
// endpoint.
func (client ResourceOperationsClient) ListEventHubConsumerGroups(resourceGroupName string, resourceName string, eventHubEndpointName string) (result EventHubConsumerGroupsListResult, err error) {
	req, err := client.ListEventHubConsumerGroupsPreparer(resourceGroupName, resourceName, eventHubEndpointName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", nil, "Failure preparing request")
	}

	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", resp, "Failure sending request")
	}

	result, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", resp, "Failure responding to request")
	}

	return
}

// ListEventHubConsumerGroupsPreparer prepares the ListEventHubConsumerGroups request.
func (client ResourceOperationsClient) ListEventHubConsumerGroupsPreparer(resourceGroupName string, resourceName string, eventHubEndpointName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"eventHubEndpointName": autorest.Encode("path", eventHubEndpointName),
		"resourceGroupName":    autorest.Encode("path", resourceGroupName),
		"resourceName":         autorest.Encode("path", resourceName),
		"subscriptionId":       autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/eventHubEndpoints/{eventHubEndpointName}/ConsumerGroups", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListEventHubConsumerGroupsSender sends the ListEventHubConsumerGroups request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ListEventHubConsumerGroupsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListEventHubConsumerGroupsResponder handles the response to the ListEventHubConsumerGroups request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ListEventHubConsumerGroupsResponder(resp *http.Response) (result EventHubConsumerGroupsListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListEventHubConsumerGroupsNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) ListEventHubConsumerGroupsNextResults(lastResults EventHubConsumerGroupsListResult) (result EventHubConsumerGroupsListResult, err error) {
	req, err := lastResults.EventHubConsumerGroupsListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListEventHubConsumerGroupsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", resp, "Failure sending next results request request")
	}

	result, err = client.ListEventHubConsumerGroupsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListEventHubConsumerGroups", resp, "Failure responding to next results request request")
	}

	return
}

// ListJobs get all the jobs in an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) ListJobs(resourceGroupName string, resourceName string) (result JobResponseListResult, err error) {
	req, err := client.ListJobsPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", nil, "Failure preparing request")
	}

	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", resp, "Failure sending request")
	}

	result, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", resp, "Failure responding to request")
	}

	return
}

// ListJobsPreparer prepares the ListJobs request.
func (client ResourceOperationsClient) ListJobsPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/jobs", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListJobsSender sends the ListJobs request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ListJobsSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListJobsResponder handles the response to the ListJobs request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ListJobsResponder(resp *http.Response) (result JobResponseListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListJobsNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) ListJobsNextResults(lastResults JobResponseListResult) (result JobResponseListResult, err error) {
	req, err := lastResults.JobResponseListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListJobsSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", resp, "Failure sending next results request request")
	}

	result, err = client.ListJobsResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListJobs", resp, "Failure responding to next results request request")
	}

	return
}

// ListKeys get all keys for an IotHub.
//
// resourceGroupName is the name of the resource group. resourceName is the
// name of the resource.
func (client ResourceOperationsClient) ListKeys(resourceGroupName string, resourceName string) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := client.ListKeysPreparer(resourceGroupName, resourceName)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", nil, "Failure preparing request")
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", resp, "Failure sending request")
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", resp, "Failure responding to request")
	}

	return
}

// ListKeysPreparer prepares the ListKeys request.
func (client ResourceOperationsClient) ListKeysPreparer(resourceGroupName string, resourceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"resourceGroupName": autorest.Encode("path", resourceGroupName),
		"resourceName":      autorest.Encode("path", resourceName),
		"subscriptionId":    autorest.Encode("path", client.SubscriptionID),
	}

	queryParameters := map[string]interface{}{
		"api-version": client.APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Devices/IotHubs/{resourceName}/listkeys", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare(&http.Request{})
}

// ListKeysSender sends the ListKeys request. The method will close the
// http.Response Body if it receives an error.
func (client ResourceOperationsClient) ListKeysSender(req *http.Request) (*http.Response, error) {
	return autorest.SendWithSender(client, req)
}

// ListKeysResponder handles the response to the ListKeys request. The method always
// closes the http.Response Body.
func (client ResourceOperationsClient) ListKeysResponder(resp *http.Response) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	err = autorest.Respond(
		resp,
		client.ByInspecting(),
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListKeysNextResults retrieves the next set of results, if any.
func (client ResourceOperationsClient) ListKeysNextResults(lastResults SharedAccessSignatureAuthorizationRuleListResult) (result SharedAccessSignatureAuthorizationRuleListResult, err error) {
	req, err := lastResults.SharedAccessSignatureAuthorizationRuleListResultPreparer()
	if err != nil {
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", nil, "Failure preparing next results request request")
	}
	if req == nil {
		return
	}

	resp, err := client.ListKeysSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", resp, "Failure sending next results request request")
	}

	result, err = client.ListKeysResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "iothub.ResourceOperationsClient", "ListKeys", resp, "Failure responding to next results request request")
	}

	return
}
