; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=aarch64 | FileCheck %s

define i64 @select_ogt_float(float %a, float %b) {
; CHECK-LABEL: select_ogt_float:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    lsl x0, x8, #2
; CHECK-NEXT:    ret
entry:
  %cc = fcmp ogt float %a, %b
  %sel = select i1 %cc, i64 4, i64 0
  ret i64 %sel
}

define i64 @select_ule_float_inverse(float %a, float %b) {
; CHECK-LABEL: select_ule_float_inverse:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    fcmp s0, s1
; CHECK-NEXT:    cset w8, gt
; CHECK-NEXT:    lsl x0, x8, #2
; CHECK-NEXT:    ret
entry:
  %cc = fcmp ule float %a, %b
  %sel = select i1 %cc, i64 0, i64 4
  ret i64 %sel
}

define i64 @select_eq_i32(i32 %a, i32 %b) {
; CHECK-LABEL: select_eq_i32:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, eq
; CHECK-NEXT:    lsl x0, x8, #2
; CHECK-NEXT:    ret
entry:
  %cc = icmp eq i32 %a, %b
  %sel = select i1 %cc, i64 4, i64 0
  ret i64 %sel
}

define i64 @select_ne_i32_inverse(i32 %a, i32 %b) {
; CHECK-LABEL: select_ne_i32_inverse:
; CHECK:       // %bb.0: // %entry
; CHECK-NEXT:    cmp w0, w1
; CHECK-NEXT:    cset w8, eq
; CHECK-NEXT:    lsl x0, x8, #2
; CHECK-NEXT:    ret
entry:
  %cc = icmp ne i32 %a, %b
  %sel = select i1 %cc, i64 0, i64 4
  ret i64 %sel
}
