; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse2 | FileCheck %s --check-prefix=SSE --check-prefix=SSE2
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+sse4.1 | FileCheck %s --check-prefix=SSE --check-prefix=SSE41
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx | FileCheck %s --check-prefix=AVX --check-prefix=AVX1
; RUN: llc < %s -mtriple=x86_64-unknown-unknown -mattr=+avx512f | FileCheck %s --check-prefix=AVX --check-prefix=AVX512

; Ensure that the backend no longer emits unnecessary vector insert
; instructions immediately after SSE scalar fp instructions
; like addss or mulss.

define <4 x float> @test_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %add = fadd float %2, %1
  %3 = insertelement <4 x float> %a, float %add, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %sub = fsub float %2, %1
  %3 = insertelement <4 x float> %a, float %sub, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %mul = fmul float %2, %1
  %3 = insertelement <4 x float> %a, float %mul, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %div = fdiv float %2, %1
  %3 = insertelement <4 x float> %a, float %div, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_sqrt_ss(<4 x float> %a) {
; SSE2-LABEL: test_sqrt_ss:
; SSE2:       # %bb.0:
; SSE2-NEXT:    sqrtss %xmm0, %xmm1
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_sqrt_ss:
; SSE41:       # %bb.0:
; SSE41-NEXT:    sqrtss %xmm0, %xmm1
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_sqrt_ss:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vsqrtss %xmm0, %xmm0, %xmm1
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_sqrt_ss:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vsqrtss %xmm0, %xmm0, %xmm1
; AVX512-NEXT:    vmovss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; AVX512-NEXT:    retq
  %1 = extractelement <4 x float> %a, i32 0
  %2 = call float @llvm.sqrt.f32(float %1)
  %3 = insertelement <4 x float> %a, float %2, i32 0
  ret <4 x float> %3
}
declare float @llvm.sqrt.f32(float)

define <2 x double> @test_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %b, i32 0
  %2 = extractelement <2 x double> %a, i32 0
  %add = fadd double %2, %1
  %3 = insertelement <2 x double> %a, double %add, i32 0
  ret <2 x double> %3
}

define <2 x double> @test_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %b, i32 0
  %2 = extractelement <2 x double> %a, i32 0
  %sub = fsub double %2, %1
  %3 = insertelement <2 x double> %a, double %sub, i32 0
  ret <2 x double> %3
}

define <2 x double> @test_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %b, i32 0
  %2 = extractelement <2 x double> %a, i32 0
  %mul = fmul double %2, %1
  %3 = insertelement <2 x double> %a, double %mul, i32 0
  ret <2 x double> %3
}

define <2 x double> @test_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %b, i32 0
  %2 = extractelement <2 x double> %a, i32 0
  %div = fdiv double %2, %1
  %3 = insertelement <2 x double> %a, double %div, i32 0
  ret <2 x double> %3
}

define <2 x double> @test_sqrt_sd(<2 x double> %a) {
; SSE2-LABEL: test_sqrt_sd:
; SSE2:       # %bb.0:
; SSE2-NEXT:    sqrtsd %xmm0, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: test_sqrt_sd:
; SSE41:       # %bb.0:
; SSE41-NEXT:    sqrtsd %xmm0, %xmm1
; SSE41-NEXT:    blendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: test_sqrt_sd:
; AVX1:       # %bb.0:
; AVX1-NEXT:    vsqrtsd %xmm0, %xmm0, %xmm1
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX1-NEXT:    retq
;
; AVX512-LABEL: test_sqrt_sd:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vsqrtsd %xmm0, %xmm0, %xmm1
; AVX512-NEXT:    vmovsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; AVX512-NEXT:    retq
  %1 = extractelement <2 x double> %a, i32 0
  %2 = call double @llvm.sqrt.f64(double %1)
  %3 = insertelement <2 x double> %a, double %2, i32 0
  ret <2 x double> %3
}
declare double @llvm.sqrt.f64(double)

define <4 x float> @test2_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test2_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %a, i32 0
  %2 = extractelement <4 x float> %b, i32 0
  %add = fadd float %1, %2
  %3 = insertelement <4 x float> %b, float %add, i32 0
  ret <4 x float> %3
}

define <4 x float> @test2_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test2_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %a, i32 0
  %2 = extractelement <4 x float> %b, i32 0
  %sub = fsub float %2, %1
  %3 = insertelement <4 x float> %b, float %sub, i32 0
  ret <4 x float> %3
}

define <4 x float> @test2_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test2_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %a, i32 0
  %2 = extractelement <4 x float> %b, i32 0
  %mul = fmul float %1, %2
  %3 = insertelement <4 x float> %b, float %mul, i32 0
  ret <4 x float> %3
}

define <4 x float> @test2_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test2_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %a, i32 0
  %2 = extractelement <4 x float> %b, i32 0
  %div = fdiv float %2, %1
  %3 = insertelement <4 x float> %b, float %div, i32 0
  ret <4 x float> %3
}

define <2 x double> @test2_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test2_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %a, i32 0
  %2 = extractelement <2 x double> %b, i32 0
  %add = fadd double %1, %2
  %3 = insertelement <2 x double> %b, double %add, i32 0
  ret <2 x double> %3
}

define <2 x double> @test2_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test2_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %a, i32 0
  %2 = extractelement <2 x double> %b, i32 0
  %sub = fsub double %2, %1
  %3 = insertelement <2 x double> %b, double %sub, i32 0
  ret <2 x double> %3
}

define <2 x double> @test2_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test2_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %a, i32 0
  %2 = extractelement <2 x double> %b, i32 0
  %mul = fmul double %1, %2
  %3 = insertelement <2 x double> %b, double %mul, i32 0
  ret <2 x double> %3
}

define <2 x double> @test2_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: test2_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test2_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <2 x double> %a, i32 0
  %2 = extractelement <2 x double> %b, i32 0
  %div = fdiv double %2, %1
  %3 = insertelement <2 x double> %b, double %div, i32 0
  ret <2 x double> %3
}

define <4 x float> @test_multiple_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_multiple_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm0, %xmm1
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_multiple_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %add = fadd float %2, %1
  %add2 = fadd float %2, %add
  %3 = insertelement <4 x float> %a, float %add2, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_multiple_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_multiple_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    subss %xmm1, %xmm2
; SSE-NEXT:    subss %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_multiple_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %sub = fsub float %2, %1
  %sub2 = fsub float %2, %sub
  %3 = insertelement <4 x float> %a, float %sub2, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_multiple_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_multiple_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm0, %xmm1
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_multiple_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %mul = fmul float %2, %1
  %mul2 = fmul float %2, %mul
  %3 = insertelement <4 x float> %a, float %mul2, i32 0
  ret <4 x float> %3
}

define <4 x float> @test_multiple_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: test_multiple_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    movaps %xmm0, %xmm2
; SSE-NEXT:    divss %xmm1, %xmm2
; SSE-NEXT:    divss %xmm2, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: test_multiple_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm1
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = extractelement <4 x float> %b, i32 0
  %2 = extractelement <4 x float> %a, i32 0
  %div = fdiv float %2, %1
  %div2 = fdiv float %2, %div
  %3 = insertelement <4 x float> %a, float %div2, i32 0
  ret <4 x float> %3
}

; With SSE4.1 or greater, the shuffles in the following tests may
; be lowered to X86Blendi nodes.

define <4 x float> @blend_add_ss(<4 x float> %a, float %b) {
; SSE-LABEL: blend_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <4 x float> %a, i32 0
  %op = fadd float %b, %ext
  %ins = insertelement <4 x float> undef, float %op, i32 0
  %shuf = shufflevector <4 x float> %ins, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %shuf
}

define <4 x float> @blend_sub_ss(<4 x float> %a, float %b) {
; SSE-LABEL: blend_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <4 x float> %a, i32 0
  %op = fsub float %ext, %b
  %ins = insertelement <4 x float> undef, float %op, i32 0
  %shuf = shufflevector <4 x float> %ins, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %shuf
}

define <4 x float> @blend_mul_ss(<4 x float> %a, float %b) {
; SSE-LABEL: blend_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <4 x float> %a, i32 0
  %op = fmul float %b, %ext
  %ins = insertelement <4 x float> undef, float %op, i32 0
  %shuf = shufflevector <4 x float> %ins, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %shuf
}

define <4 x float> @blend_div_ss(<4 x float> %a, float %b) {
; SSE-LABEL: blend_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <4 x float> %a, i32 0
  %op = fdiv float %ext, %b
  %ins = insertelement <4 x float> undef, float %op, i32 0
  %shuf = shufflevector <4 x float> %ins, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %shuf
}

define <2 x double> @blend_add_sd(<2 x double> %a, double %b) {
; SSE-LABEL: blend_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <2 x double> %a, i32 0
  %op = fadd double %b, %ext
  %ins = insertelement <2 x double> undef, double %op, i32 0
  %shuf = shufflevector <2 x double> %ins, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %shuf
}

define <2 x double> @blend_sub_sd(<2 x double> %a, double %b) {
; SSE-LABEL: blend_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <2 x double> %a, i32 0
  %op = fsub double %ext, %b
  %ins = insertelement <2 x double> undef, double %op, i32 0
  %shuf = shufflevector <2 x double> %ins, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %shuf
}

define <2 x double> @blend_mul_sd(<2 x double> %a, double %b) {
; SSE-LABEL: blend_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <2 x double> %a, i32 0
  %op = fmul double %b, %ext
  %ins = insertelement <2 x double> undef, double %op, i32 0
  %shuf = shufflevector <2 x double> %ins, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %shuf
}

define <2 x double> @blend_div_sd(<2 x double> %a, double %b) {
; SSE-LABEL: blend_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: blend_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq

  %ext = extractelement <2 x double> %a, i32 0
  %op = fdiv double %ext, %b
  %ins = insertelement <2 x double> undef, double %op, i32 0
  %shuf = shufflevector <2 x double> %ins, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %shuf
}

; Ensure that the backend selects SSE/AVX scalar fp instructions
; from a packed fp instruction plus a vector insert.

define <4 x float> @insert_test_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <4 x float> %a, %b
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <4 x float> %a, %b
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <4 x float> %a, %b
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <4 x float> %a, %b
  %2 = shufflevector <4 x float> %1, <4 x float> %a, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <2 x double> @insert_test_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <2 x double> %a, %b
  %2 = shufflevector <2 x double> %1, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <2 x double> %a, %b
  %2 = shufflevector <2 x double> %1, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <2 x double> %a, %b
  %2 = shufflevector <2 x double> %1, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <2 x double> %a, %b
  %2 = shufflevector <2 x double> %1, <2 x double> %a, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <4 x float> @insert_test2_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test2_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <4 x float> %b, %a
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test2_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test2_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <4 x float> %b, %a
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test2_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test2_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <4 x float> %b, %a
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <4 x float> @insert_test2_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test2_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <4 x float> %b, %a
  %2 = shufflevector <4 x float> %1, <4 x float> %b, <4 x i32> <i32 0, i32 5, i32 6, i32 7>
  ret <4 x float> %2
}

define <2 x double> @insert_test2_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test2_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <2 x double> %b, %a
  %2 = shufflevector <2 x double> %1, <2 x double> %b, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test2_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test2_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <2 x double> %b, %a
  %2 = shufflevector <2 x double> %1, <2 x double> %b, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test2_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test2_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <2 x double> %b, %a
  %2 = shufflevector <2 x double> %1, <2 x double> %b, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <2 x double> @insert_test2_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test2_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test2_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <2 x double> %b, %a
  %2 = shufflevector <2 x double> %1, <2 x double> %b, <2 x i32> <i32 0, i32 3>
  ret <2 x double> %2
}

define <4 x float> @insert_test3_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test3_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <4 x float> %a, %b
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %a, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test3_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test3_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <4 x float> %a, %b
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %a, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test3_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test3_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <4 x float> %a, %b
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %a, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test3_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test3_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <4 x float> %a, %b
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %a, <4 x float> %1
  ret <4 x float> %2
}

define <2 x double> @insert_test3_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test3_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <2 x double> %a, %b
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %a, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test3_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test3_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <2 x double> %a, %b
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %a, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test3_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test3_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <2 x double> %a, %b
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %a, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test3_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test3_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test3_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm1, %xmm0, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <2 x double> %a, %b
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %a, <2 x double> %1
  ret <2 x double> %2
}

define <4 x float> @insert_test4_add_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test4_add_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    addss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_add_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <4 x float> %b, %a
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %b, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test4_sub_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test4_sub_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    subss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_sub_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <4 x float> %b, %a
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %b, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test4_mul_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test4_mul_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    mulss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_mul_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <4 x float> %b, %a
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %b, <4 x float> %1
  ret <4 x float> %2
}

define <4 x float> @insert_test4_div_ss(<4 x float> %a, <4 x float> %b) {
; SSE-LABEL: insert_test4_div_ss:
; SSE:       # %bb.0:
; SSE-NEXT:    divss %xmm0, %xmm1
; SSE-NEXT:    movaps %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_div_ss:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivss %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <4 x float> %b, %a
  %2 = select <4 x i1> <i1 false, i1 true, i1 true, i1 true>, <4 x float> %b, <4 x float> %1
  ret <4 x float> %2
}

define <2 x double> @insert_test4_add_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test4_add_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    addsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_add_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vaddsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fadd <2 x double> %b, %a
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %b, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test4_sub_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test4_sub_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    subsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_sub_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vsubsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fsub <2 x double> %b, %a
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %b, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test4_mul_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test4_mul_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    mulsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_mul_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vmulsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fmul <2 x double> %b, %a
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %b, <2 x double> %1
  ret <2 x double> %2
}

define <2 x double> @insert_test4_div_sd(<2 x double> %a, <2 x double> %b) {
; SSE-LABEL: insert_test4_div_sd:
; SSE:       # %bb.0:
; SSE-NEXT:    divsd %xmm0, %xmm1
; SSE-NEXT:    movapd %xmm1, %xmm0
; SSE-NEXT:    retq
;
; AVX-LABEL: insert_test4_div_sd:
; AVX:       # %bb.0:
; AVX-NEXT:    vdivsd %xmm0, %xmm1, %xmm0
; AVX-NEXT:    retq
  %1 = fdiv <2 x double> %b, %a
  %2 = select <2 x i1> <i1 false, i1 true>, <2 x double> %b, <2 x double> %1
  ret <2 x double> %2
}

define <4 x float> @add_ss_mask(<4 x float> %a, <4 x float> %b, <4 x float> %c, i8 %mask) {
; SSE2-LABEL: add_ss_mask:
; SSE2:       # %bb.0:
; SSE2-NEXT:    testb $1, %dil
; SSE2-NEXT:    jne .LBB62_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    movaps %xmm2, %xmm1
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB62_1:
; SSE2-NEXT:    addss %xmm0, %xmm1
; SSE2-NEXT:    movss {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: add_ss_mask:
; SSE41:       # %bb.0:
; SSE41-NEXT:    testb $1, %dil
; SSE41-NEXT:    jne .LBB62_1
; SSE41-NEXT:  # %bb.2:
; SSE41-NEXT:    movaps %xmm2, %xmm1
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE41-NEXT:    retq
; SSE41-NEXT:  .LBB62_1:
; SSE41-NEXT:    addss %xmm0, %xmm1
; SSE41-NEXT:    blendps {{.*#+}} xmm0 = xmm1[0],xmm0[1,2,3]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: add_ss_mask:
; AVX1:       # %bb.0:
; AVX1-NEXT:    testb $1, %dil
; AVX1-NEXT:    je .LBB62_2
; AVX1-NEXT:  # %bb.1:
; AVX1-NEXT:    vaddss %xmm1, %xmm0, %xmm2
; AVX1-NEXT:  .LBB62_2:
; AVX1-NEXT:    vblendps {{.*#+}} xmm0 = xmm2[0],xmm0[1,2,3]
; AVX1-NEXT:    retq
;
; AVX512-LABEL: add_ss_mask:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vaddss %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vmovss %xmm1, %xmm0, %xmm2 {%k1}
; AVX512-NEXT:    vmovaps %xmm2, %xmm0
; AVX512-NEXT:    retq
  %1 = extractelement <4 x float> %a, i64 0
  %2 = extractelement <4 x float> %b, i64 0
  %3 = fadd float %1, %2
  %4 = extractelement <4 x float> %c, i32 0
  %5 = bitcast i8 %mask to <8 x i1>
  %6 = extractelement <8 x i1> %5, i64 0
  %7 = select i1 %6, float %3, float %4
  %8 = insertelement <4 x float> %a, float %7, i64 0
  ret <4 x float> %8
}

define <2 x double> @add_sd_mask(<2 x double> %a, <2 x double> %b, <2 x double> %c, i8 %mask) {
; SSE2-LABEL: add_sd_mask:
; SSE2:       # %bb.0:
; SSE2-NEXT:    testb $1, %dil
; SSE2-NEXT:    jne .LBB63_1
; SSE2-NEXT:  # %bb.2:
; SSE2-NEXT:    movapd %xmm2, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
; SSE2-NEXT:  .LBB63_1:
; SSE2-NEXT:    addsd %xmm0, %xmm1
; SSE2-NEXT:    movsd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE2-NEXT:    retq
;
; SSE41-LABEL: add_sd_mask:
; SSE41:       # %bb.0:
; SSE41-NEXT:    testb $1, %dil
; SSE41-NEXT:    jne .LBB63_1
; SSE41-NEXT:  # %bb.2:
; SSE41-NEXT:    movapd %xmm2, %xmm1
; SSE41-NEXT:    blendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE41-NEXT:    retq
; SSE41-NEXT:  .LBB63_1:
; SSE41-NEXT:    addsd %xmm0, %xmm1
; SSE41-NEXT:    blendpd {{.*#+}} xmm0 = xmm1[0],xmm0[1]
; SSE41-NEXT:    retq
;
; AVX1-LABEL: add_sd_mask:
; AVX1:       # %bb.0:
; AVX1-NEXT:    testb $1, %dil
; AVX1-NEXT:    je .LBB63_2
; AVX1-NEXT:  # %bb.1:
; AVX1-NEXT:    vaddsd %xmm1, %xmm0, %xmm2
; AVX1-NEXT:  .LBB63_2:
; AVX1-NEXT:    vblendpd {{.*#+}} xmm0 = xmm2[0],xmm0[1]
; AVX1-NEXT:    retq
;
; AVX512-LABEL: add_sd_mask:
; AVX512:       # %bb.0:
; AVX512-NEXT:    vaddsd %xmm1, %xmm0, %xmm1
; AVX512-NEXT:    kmovw %edi, %k1
; AVX512-NEXT:    vmovsd %xmm1, %xmm0, %xmm2 {%k1}
; AVX512-NEXT:    vmovapd %xmm2, %xmm0
; AVX512-NEXT:    retq
  %1 = extractelement <2 x double> %a, i64 0
  %2 = extractelement <2 x double> %b, i64 0
  %3 = fadd double %1, %2
  %4 = extractelement <2 x double> %c, i32 0
  %5 = bitcast i8 %mask to <8 x i1>
  %6 = extractelement <8 x i1> %5, i64 0
  %7 = select i1 %6, double %3, double %4
  %8 = insertelement <2 x double> %a, double %7, i64 0
  ret <2 x double> %8
}
