using System;
using Indicate;
using Gtk;
using GLib;

namespace IndicatorExample
{
	class MainClass
	{
		public static void Main(string[] args)
		{
			Application.Init ();
			Indicate.Server server = Indicate.Server.RefDefault();
			server.SetType("message.im");
			server.DesktopFile("/usr/share/applications/empathy.desktop");
			server.ServerDisplay += new Indicate.ServerDisplayHandler(ServerDisplay);
			server.Show();

			Indicator indicator = new Indicate.Indicator();
			indicator.SetProperty("subtype", "im");
			indicator.SetProperty("sender", "Barney Rubble");
			indicator.UserDisplay += new EventHandler(UserDisplay);
			indicator.Show();

			Application.Run ();
		}
		
		public static void ServerDisplay (object sender, Indicate.ServerDisplayArgs args)
		{
			Console.WriteLine ("Server was displayed");
		}
		
		public static void UserDisplay (object sender, System.EventArgs args)
		{
			Console.WriteLine ("Indicator was displayed");
			Indicate.Indicator indicator = sender as Indicate.Indicator;
			indicator.Hide();
		}
	}
}
