#ifndef __UNITY_WEBAPPS_URL_DB_H
#define __UNITY_WEBAPPS_URL_DB_H

#include <glib.h>

typedef struct _UnityWebappsUrlDB UnityWebappsUrlDB;

typedef struct _UnityWebappsUrlDBRecord {
  gchar *package_name;
  gchar *application_name;
  gchar *domain;
} UnityWebappsUrlDBRecord;

UnityWebappsUrlDB *unity_webapps_url_db_open (gboolean read_only, const gchar *database_path);
void unity_webapps_url_db_free (UnityWebappsUrlDB *db);

UnityWebappsUrlDB *unity_webapps_url_db_open_default (gboolean read_only);

gboolean unity_webapps_url_db_insert_url (UnityWebappsUrlDB *url_db, const gchar *url,
					  UnityWebappsUrlDBRecord *record);
gboolean unity_webapps_url_db_lookup_urls (UnityWebappsUrlDB *url_db, const gchar *url,
					   GList **records);

UnityWebappsUrlDBRecord *unity_webapps_url_db_record_new (const gchar *package_name, const gchar *application_name, const gchar *application_domain);
void unity_webapps_url_db_record_free (UnityWebappsUrlDBRecord *record);
void unity_webapps_url_db_record_list_free (GList *record_list);


#endif

